<?php
$theme_options_data = get_theme_mods();

wp_enqueue_script('thim-flexslider');
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'col-sm-12' ); ?>>
	<div class="content-inner">
		<div class="entry-content">
			<?php

			if ( has_post_format( 'link' ) && thim_meta( 'thim_link_url' ) && thim_meta( 'thim_link_text' ) ) {
				$url   = thim_meta( 'thim_link_url' );
				$title = thim_meta( 'thim_link_text' );
			} else {
				$url   = get_permalink();
				$title = get_the_title();
			}

			?>
			<header class="entry-header<?php if ( get_theme_mod( 'thim_show_date', 1 ) == 1 ) {
				echo ' has_date';
			} ?>">
				<?php
				if ( get_theme_mod( 'thim_show_date', 1 ) == 1 ) {
					echo '<div class="date-meta">' . get_the_date( "d\<\i\>\ M\<\/\i\>\ " ) . '</div>';
				}
				?>

				<div class="entry-contain">
					<?php echo sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">%s</a></h2>', esc_url( $url ), esc_attr( $title ) ); ?>
					<?php thim_entry_meta(); ?>
				</div>
			</header>
			<!-- .entry-header -->
			<?php do_action( 'thim_entry_top', 'full' ); ?>
			<div class="entry-summary">
				<?php
				echo thim_excerpt( get_theme_mod( 'thim_post_excerpt_length', 50 ) );
				?>
			</div><!-- .entry-summary -->
			<div class="readmore">
				<a class="thim-button"
				   href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html__( 'Read More', 'coaching' ); ?></a>
			</div>
			<div class="thim_sharepost">
				<?php do_action( 'thim_social_share' ); ?>
			</div>

		</div>

	</div>
</article><!-- #post-## -->
