<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @package thim
 */
get_header();
/**
 * thim_wrapper_loop_start hook
 *
 * @hooked thim_wrapper_loop_end - 1
 * @hooked thim_wapper_page_title - 5
 * @hooked thim_wrapper_loop_start - 30
 */

do_action( 'thim_wrapper_loop_start' );
$image 			= !empty(get_theme_mod('thim_404_image')) ? get_theme_mod('thim_404_image') : get_template_directory_uri() . '/images/404.png' ;
$title_text 	= !empty(get_theme_mod('thim_404_custom_text')) ? get_theme_mod('thim_404_custom_text') : '404 Page Not Found!' ;
$desc_text 		= !empty(get_theme_mod('thim_404_custom_text_desc')) ? get_theme_mod('thim_404_custom_text_desc') : 'The page you are looking for cannot be found.' ;
?>
<section class="error-404 not-found">
	<div class="page-404-content">
		<div class="row">
			<div class="col-sm-6">
				<img src="<?php echo esc_url( $image ); ?>" alt="404 Page" />
			</div>
			<div class="col-sm-6 text-center">
				<h2><?php esc_html_e( $title_text, 'coaching' ); ?></h2>
				<p class="messages-404"><?php esc_html_e( $desc_text , 'coaching' ); ?></p>
				<a href="<?php echo esc_url( home_url('/') ); ?>" class="thim-color"><?php esc_html_e( 'Back To Home', 'coaching' ); ?></a>
			</div>
		</div>
	</div>
	<!-- .page-content -->
</section>
<?php
/**
 * thim_wrapper_loop_end hook
 *
 * @hooked thim_wrapper_loop_end - 10
 * @hooked thim_wrapper_div_close - 30
 */
do_action( 'thim_wrapper_loop_end' );

get_footer();
?>
