<?php

class dc_jqmegamenu_widget extends WP_Widget {
    /** constructor */
    function __construct() {

		$name =			'MPC - Mega Menu';
		$desc = 		'Create Mega Menus From Any Wordpress Custom Menu';
		$id_base = 		'dc_jqmegamenu_widget';
		$css_class = 	'';
		$alt_option = 	'widget_dcjq_mega_menu_navigation';

		$widget_ops = array(
			'classname' => $css_class,
			'description' => __( $desc, 'dcjq-mega-menu' ),
		);
		parent::__construct( 'nav_menu', __('Custom Menu'), $widget_ops );

		parent::__construct($id_base, __($name, 'dcjqmegamenu'), $widget_ops);
		$this->alt_option_name = $alt_option;

		add_action( 'wp_footer', array(&$this, 'footer'), 10, 1 );

		$this->defaults = array(
			'rowItems' => 3,
		);
    }

	function widget($args, $instance) {
		extract( $args );
		// Get menu

		$widget_options = wp_parse_args( $instance, $this->defaults );
		extract( $widget_options, EXTR_SKIP );

		$nav_menu = wp_get_nav_menu_object( $instance['nav_menu'] );

		if ( !$nav_menu )
			return;

		echo $args['before_widget'];

		?>
		<div class="dcjq-mega-menu" id="<?php echo $this->id.'-item'; ?>">

		<?php
			wp_nav_menu( array( 'fallback_cb' => '', 'menu' => $nav_menu, 'container' => false ) );
		?>

		</div>
		<?php

		echo $args['after_widget'];
	}

    /** @see WP_Widget::update */
    function update( $new_instance, $old_instance ) {
		$instance['nav_menu'] = (int) $new_instance['nav_menu'];
		$instance['rowItems'] = $new_instance['rowItems'];

		return $instance;
	}

    /** @see WP_Widget::form */
    function form($instance) {
		$nav_menu = isset( $instance['nav_menu'] ) ? $instance['nav_menu'] : '';
		$rowItems = isset( $instance['rowItems'] ) ? $instance['rowItems'] : '';

		$widget_options = wp_parse_args( $instance, $this->defaults );
		extract( $widget_options, EXTR_SKIP );

		// Get menus
		$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );

		// If no menus exists, direct the user to go and create some.
		if ( !$menus ) {
			echo '<p>'. sprintf( __('No menus have been created yet. <a href="%s">Create some</a>.'), admin_url('nav-menus.php') ) .'</p>';
			return;
		}
		?>
	<p>
		<label for="<?php echo $this->get_field_id('nav_menu'); ?>"><?php _e('Select Menu:'); ?></label>
		<select id="<?php echo $this->get_field_id('nav_menu'); ?>" name="<?php echo $this->get_field_name('nav_menu'); ?>">
		<?php
			foreach ( $menus as $menu ) {
				$selected = $nav_menu == $menu->term_id ? ' selected="selected"' : '';
				echo '<option'. $selected .' value="'. $menu->term_id .'">'. $menu->name .'</option>';
			}
		?>
		</select>
	</p>
	<p>
	  <label for="<?php echo $this->get_field_id('rowItems'); ?>"><?php _e( 'Number Items Per Row' , 'dcjq-mega-menu' ); ?></label>
		<select name="<?php echo $this->get_field_name('rowItems'); ?>" id="<?php echo $this->get_field_id('rowItems'); ?>" >
			<option value='1' <?php selected( $rowItems, '1'); ?> >1</option>
			<option value='2' <?php selected( $rowItems, '2'); ?> >2</option>
			<option value='3' <?php selected( $rowItems, '3'); ?> >3</option>
			<option value='4' <?php selected( $rowItems, '4'); ?> >4</option>
			<option value='5' <?php selected( $rowItems, '5'); ?> >5</option>
			<option value='6' <?php selected( $rowItems, '6'); ?> >6</option>
			<option value='7' <?php selected( $rowItems, '7'); ?> >7</option>
			<option value='8' <?php selected( $rowItems, '8'); ?> >8</option>
			<option value='9' <?php selected( $rowItems, '9'); ?> >9</option>
			<option value='10' <?php selected( $rowItems, '10'); ?> >10</option>
		</select>
		</p>
	    <input type="hidden" value="<?php echo $subMenuWidth; ?>" class="widefat" id="<?php echo $this->get_field_id('subMenuWidth'); ?>" name="<?php echo $this->get_field_name('subMenuWidth'); ?>" />

	<?php
	}

	/** Adds ID based activation script to the footer */
	function footer(){

		if(!is_admin()){

		$all_widgets = $this->get_settings();

		foreach ($all_widgets as $key => $wpdcjqmegamenu){

			$widget_id = $this->id_base . '-' . $key;

			if(is_active_widget(false, $widget_id, $this->id_base)){

			?>
			<script type="text/javascript">
				jQuery(document).ready(function($) {
					jQuery('#<?php echo $widget_id.'-item'; ?> .menu').dcMegaMenu({
						rowItems: <?php echo $wpdcjqmegamenu['rowItems']; ?>
					});
				});
			</script>

			<?php

			}
		}
		}
	}
} // class dc_jqmegamenu_widget