<?php
/*
		Plugin Name: MPC Mega Menu
		Plugin URI: http://www.designchemical.com/blog/index.php/wordpress-plugins/wordpress-plugin-jquery-mega-menu-widget/
		Tags: jquery, dropdown, menu, vertical accordion, animated, css, navigation
		Description: This is a modified version of jQuery MegaMenu plugin authored by Lee Chestnutt. All credits goes to initial author.
		Author: Lee Chestnutt | Modified by MPC Team
		Version: 1.5
		Author URI: http://www.designchemical.com
*/

global $registered_skins;

class dc_jqmegamenu {

	function __construct(){

		global $registered_skins;

		if(!is_admin()){

			// Scripts & styles
			add_action("wp_enqueue_scripts", array( $this, 'add_jqmegamenu_styles' )); /* Custom change by MPC Team due to Strict Standard errors */
			add_action("wp_enqueue_scripts", array( $this, 'add_jqmegamenu_scripts' )); /* Custom change by MPC Team due to Strict Standard errors */
		}

		$registered_skins = array();
	}

	function add_jqmegamenu_styles() {
		wp_enqueue_style( 'dcjq-mega-menu', dc_jqmegamenu::get_plugin_directory() . '/css/dcjq-mega-menu.css');
	}

	function add_jqmegamenu_scripts() {
		wp_enqueue_script( 'dcjqmegamenu', dc_jqmegamenu::get_plugin_directory() . '/js/jquery.dcmegamenu.1.3.4.min.js', array('jquery') );
	}

	function options(){}

	function get_plugin_directory(){
		return plugins_url() . '/jquery-mega-menu';
	}

};

// Include the widget
include_once('dcwp_jquery_mega_menu_widget.php');

// Initialize the plugin.
$dcjqmegamenu = new dc_jqmegamenu();

// Register the widget
add_action('widgets_init', create_function('', 'return register_widget("dc_jqmegamenu_widget");'));

?>