<?php
/* Register grid custom post type */
add_action('init', 'mpc_ex_grid');
function mpc_ex_grid() {
	$labels = array(
		'name' => __('Grid', 'mpc-ex'),
		'singular_name' => __('Grid Item', 'mpc-ex'),
		'all_items' => __('Grid Items', 'mpc-ex'),
		'add_new_item' => __('Add New Grid Item', 'mpc-ex'),
		'edit_item' => __('Edit Grid Item', 'mpc-ex'),
		'new_item' => __('New Grid Item', 'mpc-ex'),
		'view_item' => __('View Grid Item', 'mpc-ex'),
		'search_items' => __('Search Grid Items', 'mpc-ex'),
		'not_found' => __('No Grid Items found', 'mpc-ex'),
		'not_found_in_trash' => __('No Grid Items found in Trash', 'mpc-ex')
	);

	$grid_args = array(
		'labels' => $labels,
		'public' => true,
		'show_ui' => true,
		'exclude_from_search' => true,
		'menu_icon' => 'dashicons-screenoptions',
		'capability_type' => 'post',
		'hierarchical' => false,
		'supports' => array('title', 'editor'),
	);

	register_post_type('mpc_grid', $grid_args);
}