<?php ob_start(ob_gzhandler); 

/*Cache Start*/
$lastModified = filemtime(__FILE__);
$etagFile = md5_file(__FILE__);
$ifModifiedSince=(isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) ? $_SERVER['HTTP_IF_MODIFIED_SINCE'] : false);
$etagHeader=(isset($_SERVER['HTTP_IF_NONE_MATCH']) ? trim($_SERVER['HTTP_IF_NONE_MATCH']) : false);
header("Last-Modified: ".gmdate("D, d M Y H:i:s", $lastModified)." GMT");
header("Etag: $etagFile");
header('Cache-Control: public');
if(@strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE'])==$lastModified || $etagHeader == $etagFile){
    header("HTTP/1.1 304 Not Modified"); exit;
}
/*Cache End*/

require(__DIR__ ."/includes/config.php");
switch($_GET['mod']):
	case "temp":
		$ext = strtolower($_GET['file'], PATHINFO_EXTENSION);
		$ctype = $ext=="jpg" || $ext == "jpeg" ? 'image/jpeg' : 'image/png';
		header("Content-Type: $ctype");
		echo @readfile(__DIR__ . '/assets/temp/'.$_GET['file']);
	break;
	case "dp":
		@list($w, $h) = explode("x", $_GET['res']);
		$oimage = __DIR__ . '/assets/dps/'.$z->decode($_GET['file']);
		$image = __DIR__ . '/assets/dps/'.$_GET['res'].'_'.$z->decode($_GET['file']);
		$ext = $_GET['ext'];
		$ctype = $ext=="jpg" || $ext == "jpeg" ? 'image/jpeg' : 'image/png';
		if(!file_exists($image)){
			try{
				require(__DIR__ . "/includes/resize/vendor/autoload.php");
				$img = new \claviska\SimpleImage();
				$img->fromFile($oimage)->resize($w, $h)->toFile($image, 'image/jpeg');
			}catch(Exception $e){				
				$image = $oimage;
			}
		}		
		header("Content-Type: $ctype");
		echo @readfile($image);
	break;
	case "track":
		@list($ID, $source) = explode("@@", $z->decode($_GET['file']));
		$poster = $ID; //$ID.'.jpg';
		$thumb = __DIR__ .'/assets/posters/thumb_'.$poster;
		if(!file_exists($thumb)){
			$local = __DIR__ . '/assets/posters/'.$poster;
			if($source=='youtube'){
				$resolutions = array('maxresdefault', 'hqdefault', 'mqdefault');     
				foreach($resolutions as $res):
					$YTID = str_replace(".jpg", "", $ID);
					$imgUrl = "http://i.ytimg.com/vi/".$YTID."/".$res.".jpg";
					if(@getimagesize(($imgUrl))){
						break;
					}
				endforeach;
				$img = @file_get_contents($imgUrl);
				@file_put_contents($local, $img);
			}		
			include_once(__DIR__ .'/includes/wide/WideImage.php');
			@list($width, $height) = @getimagesize($local);
			$rthumb = __DIR__ .'/assets/posters/tmp_'.$poster;
			$crop = WideImage::load($local)->crop('center', 'center', $height, $height); //->output('jpg');
			$crop->saveToFile($rthumb);
			WideImage::load($rthumb)->resize(200, 200)->saveToFile($thumb);
			unlink($rthumb); if($source=='youtube'){ unlink($local); }
		}
		header("Content-type: image/jpeg");
		echo @readfile($thumb);
	break;
	case "album":
		$photo = $z->decode($_GET['file']);		
		$local = __DIR__ . '/assets/covers/'.$photo;
		if($photo!='no-cover.png'){
			$local = __DIR__ . '/assets/covers/thumb_'.$photo;
			if(!file_exists($local)){
				$rthumb = __DIR__ . '/assets/covers/'.$photo;
				@list($width, $height) = @getimagesize($local);
				include_once(__DIR__ .'/includes/wide/WideImage.php');
				WideImage::load($rthumb)->resize(250, 250)->saveToFile($local);			
			}
		}
		header("Content-type: image/jpeg");
		echo @readfile($local);
	break;
endswitch;

ob_flush(); ?>