<?php 
if(!isset($area)){
	$area = isset($_GET['area']) ? $_GET['area'] : 'featured';
}
?>
<ol class="ibl htabs size15 fontb">
	<li class="rel"><a href="<?php echo baseurl; ?>" data-mod="featured" class="bl anim noul pstate pstate-featured<?php echo $area=='featured' ? ' on' : ''; ?>">Featured</a></li>
	<li class="rel"><a href="<?php echo baseurl; ?>genres" data-mod="genres" class="bl anim noul pstate pstate-genres<?php echo $area=='genres' ? ' on' : ''; ?>">Genres & Moods</a></li>
	<li class="rel"><a href="<?php echo baseurl; ?>new-releases" data-mod="newreleases" class="bl anim noul pstate pstate-newreleases<?php echo $area=='newreleases' ? ' on' : ''; ?>">New Releases</a></li>
	<li class="rel"><a href="<?php echo baseurl; ?>discover" data-mod="discover" class="bl anim noul pstate pstate-discover<?php echo $area=='discover' ? ' on' : ''; ?>">Discover</a></li>
</ol>
<div class="dataBox rel">
<?php 
switch($area):
	case "featured":
		
		if($session->result=="ok"){
			//Recently played
			$xlist = $z->select("SELECT tid FROM history WHERE uid=? ORDER BY added DESC LIMIT ?", array($session->ID, 20), "ii");
			if($xlist->result=="ok" && $xlist->count > 0){
				$IDS = array();
				for($n = 0; $n < count($xlist->fetch); $n++):
					array_push($IDS, $xlist->fetch[$n]->tid);
				endfor;
				$params = implode(",", array_map('intval', $IDS));				
				$list = $z->select("SELECT * FROM tracks WHERE ID IN ($params) AND status=? ORDER BY FIELD(ID, $params)", array("yes"), "s");				
				echo '<h2 class="size30 fontb cfff areaTitle">Recently Played</h2>';
				echo '<ul class="tracks tracksFeatured ibl fontn">';				
				for($n = 0; $n < count($list->fetch); $n++):
					echo $z->trackItem($list->fetch[$n]);
				endfor;
				echo '</ul>';
			}
		}
		
		//Featured
		$total = $z->select("SELECT COUNT(ID) as total FROM tracks WHERE status=?", array("yes"), "s")->row->total; 
		$start = 0; $limit = 50;
		if(isset($_GET['start'])){ 
			$ostart = $_GET['start'];
			$start = $limit * $ostart - $limit;	
		}		
		$list = $z->select("SELECT * FROM tracks WHERE status=? ORDER BY views DESC LIMIT ?,?", array("yes",$start,$limit), "sss");				
		echo '<h2 class="size30 fontb cfff areaTitle">Featured</h2>';
		echo '<ul class="tracks ibl fontn">';
		$adsPerRow = $z->getSetting('show_ads_per_row');		
		for($n = 0; $n < count($list->fetch); $n++):
			if($n > 0 && $n % $adsPerRow == 0){ 
				$_ad = $z->getAd(); echo $_ad=='none' ? '' : $z->trackItem($_ad, true);
			}
			echo $z->trackItem($list->fetch[$n]);
		endfor;
		echo '</ul>';		
		
	break;
	case "genres":
	
		if(isset($_GET['genre'])){
			$genreID = $_GET['genre'];
			$genre = $z->select("SELECT ID,title FROM genres WHERE slug=? LIMIT 1", array($genreID), "s")->row;
			$total = $z->select("SELECT COUNT(ID) as total FROM tracks WHERE genre=? AND status=?", array($genre->ID, "yes"), "is")->row->total; 
			$start = 0; $limit = 50;
			if(isset($_GET['start'])){ 
				$ostart = $_GET['start'];
				$start = $limit * $ostart - $limit;	
			}		
			$list = $z->select("SELECT * FROM tracks WHERE genre=? AND status=? ORDER BY ID DESC LIMIT ?,?", array($genre->ID,"yes",$start,$limit), "isss");				
			$labelPage = isset($_GET['start']) && $_GET['start'] > 1 ? ' &ndash; Page '.$_GET['start'] : '';
			echo '<h2 class="size30 fontb cfff areaTitle">Browse '.$genre->title.' Tracks'.$labelPage.'</h2>';
			if($list->result=="ok" && $list->count > 0){
				echo '<ul class="tracks ibl fontn">';			
				for($n = 0; $n < count($list->fetch); $n++):
					echo $z->trackItem($list->fetch[$n]);
				endfor;
				echo '</ul>';
				$pagin = '<ol class="pages pagesGenre ibl" data-slug="'.$genreID.'">';
				$fresh_start = isset($_GET['start']) ? $_GET['start'] : 1;	
				$next = $fresh_start+1;
				$prev = $fresh_start-1;
				$prevlink = baseurl.'genres/'.$genreID.'/p'.$prev;
				$link_first = baseurl.'genres/'.$genreID;
				$nextlink = baseurl.'genres/'.$genreID.'/p'.$next;
				$link_last = baseurl.'genres/'.$genreID.'/p'.ceil($total/$limit); 
				$link_i = baseurl.'genres/'.$genreID.'/p';
				$pagin .= $z->pagination($total, $limit, $start, $fresh_start, $link_first, $prevlink, $prev, $next, $nextlink, $link_last, $link_i, $genre->title);		
				$pagin .= '</ol>';
				echo $pagin;				
			}else{
				echo '<div class="emptyTracks rel size40 cfff fontl"><div class="icon-puzzle ico"></div>It\'s a bit empty here...</div>';
			}
		}else{
			$list = $z->select("SELECT * FROM genres WHERE status=? ORDER BY title ASC", array("yes"), "s");				
			echo '<h2 class="size30 fontb cfff areaTitle">Genres & Moods</h2>';
			echo '<ul class="genreslist ibl fontn">';
			for($n = 0; $n < count($list->fetch); $n++):
				$ID = $list->fetch[$n]->ID;
				$yt = $z->select("SELECT ytid FROM tracks WHERE genre=? ORDER BY ID DESC LIMIT 1", array($ID), "i");
				if($yt->result=="ok" && $yt->count > 0){
					$img = baseurl.'photo/track/'.$z->encode($yt->row->ytid).'/default.jpg';	
				}else{
					$img = baseurl.'ui/no-image.png';	
				}			
				echo '<li class="rel"><a href="'.baseurl.'genres/'.$list->fetch[$n]->slug.'" class="bl noul anim bstate" data-slug="'.$list->fetch[$n]->slug.'" '
				. 'data-title="'.$list->fetch[$n]->title.'">'
				. '<div class="ico anim"><img src="'.$img.'" class="bl rel"></div>'
				. '<h2 class="size14 fontb">'.$list->fetch[$n]->title.'</h2>'
				. '</a></li>';			
			endfor;
			echo '</ul>';
		}
		
	break;
	case "newreleases":
		
		//New Releases
		$total = $z->select("SELECT COUNT(ID) as total FROM tracks WHERE status=?", array("yes"), "s")->row->total; 
		$start = 0; $limit = 50;
		if(isset($_GET['start'])){ 
			$ostart = $_GET['start'];
			$start = $limit * $ostart - $limit;	
		}		
		$list = $z->select("SELECT * FROM tracks WHERE status=? ORDER BY ID DESC LIMIT ?,?", array("yes",$start,$limit), "sss");				
		$labelPage = isset($_GET['start']) && $_GET['start'] > 1 ? ' &ndash; Page '.$_GET['start'] : '';
		$adsPerRow = $z->getSetting('show_ads_per_row');
		echo '<h2 class="size30 fontb cfff areaTitle">Newest Release'.$labelPage.'</h2>';
		echo '<ul class="tracks ibl fontn">';
		for($n = 0; $n < count($list->fetch); $n++):
			if($n > 0 && $n % $adsPerRow == 0){ 
				$_ad = $z->getAd(); echo $_ad=='none' ? '' : $z->trackItem($_ad, true);
			}
			echo $z->trackItem($list->fetch[$n]);
		endfor;
		echo '</ul>';		
		$pagin = '<ol class="pages pagesNewest ibl" data-pg="'.$start.'">';
		$fresh_start = isset($_GET['start']) ? $_GET['start'] : 1;	
		$next = $fresh_start+1;
		$prev = $fresh_start-1;
		$prevlink = baseurl.'new-releases/p'.$prev;
		$link_first = baseurl.'new-releases';
		$nextlink = baseurl.'new-releases/p'.$next;
		$link_last = baseurl.'new-releases/p'.ceil($total/$limit); 
		$link_i = baseurl.'new-releases/p';
		$pagin .= $z->pagination($total, $limit, $start, $fresh_start, $link_first, $prevlink, $prev, $next, $nextlink, $link_last, $link_i, 'Newest Release');		
		$pagin .= '</ol>';
		echo $pagin;
				
	break;
	case "discover":
		//Featured
		$total = $z->select("SELECT COUNT(ID) as total FROM tracks WHERE status=?", array("yes"), "s")->row->total; 
		$start = 0; $limit = 100;
		if(isset($_GET['start'])){ 
			$ostart = $_GET['start'];
			$start = $limit * $ostart - $limit;	
		}		
		$adsPerRow = $z->getSetting('show_ads_per_row');
		$list = $z->select("SELECT * FROM tracks WHERE status=? ORDER BY RAND() LIMIT ?", array("yes",$limit), "si");				
		echo '<h2 class="size30 fontb cfff areaTitle">Editors Pick</h2>';
		echo '<ul class="tracks ibl fontn">';
		for($n = 0; $n < count($list->fetch); $n++):
			if($n > 0 && $n % $adsPerRow == 0){ 
				$_ad = $z->getAd(); echo $_ad=='none' ? '' : $z->trackItem($_ad, true);
			}
			echo $z->trackItem($list->fetch[$n]);
		endfor;
		echo '</ul>';	
	break;
	
endswitch;
?>
</div>