<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"> 
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:og="http://ogp.me/ns#"  itemscope itemtype="http://schema.org/Article" xmlns:fb="http://www.facebook.com/2008/fbml">
<head>
<?php 
$prefix = SITE_NAME; $sept = ' &ndash; '; $suffix = SITE_SLOGAN;
$area = '';
switch($page):
	case "welcome":
		$prefix = SITE_NAME;
		$suffix = SITE_SLOGAN;
	break;
	case "home":
		$area = isset($_GET['area']) ? $_GET['area'] : 'featured';
		switch($area):
			case "genres":
				$prefix = 'Genres & Moods';
				$suffix = SITE_NAME;
			break;
			case "newreleases":
				$prefix = 'Newest Tracks';
				$suffix = SITE_NAME;
			break;
			case "discover":
				$prefix = 'Editor Picks';
				$suffix = SITE_NAME;
			break;
		endswitch;
		
	break;
	case "search":
		if(isset($_GET['q']) && !empty($_GET['q'])){
			$prefix = 'Search: '.$_GET['q'];
			$suffix = SITE_NAME;
		}else{
			$prefix = 'Search '.SITE_NAME;
			$sept = $suffix = '';
		}
	break;
	case "library":
		$prefix = 'Your Library';
		$suffix = SITE_NAME;
	break;
	case "listen":
		$slug = $z->clean($_GET['slug']);
		$ctrack = $z->select("SELECT * FROM tracks WHERE slug=? AND status=? LIMIT 1", array($slug,"yes"), "ss");
		if($ctrack->result=="ok" && $ctrack->count > 0){
			$title = stripslashes($ctrack->row->title);
			$prefix = $title; $suffix = SITE_NAME;
			$description = 'Listen '.$title.' on '.SITE_NAME;
			$keywords = $ctrack->row->tags;
			$listenImage = $img = baseurl.'photo/track/'.$z->encode($ctrack->row->poster.'@@'.$ctrack->row->type).'/default.jpg';
			echo '<meta itemprop="name" content="'.$title.'">
			<meta itemprop="description" content="'.$description.'">
			<meta itemprop="image" content="'.$img.'">			
			<meta name="twitter:card" content="summary_large_image">
			<meta name="twitter:site" content="@kamranwajdani">
			<meta name="twitter:title" content="'.$title.'">
			<meta name="twitter:description" content="'.$description.'">
			<meta name="twitter:creator" content="@kamranwajdani">			
			<meta name="twitter:image:src" content="'.$img.'">			
			<meta property="og:title" content="'.$title.'" />
			<meta property="og:type" content="article" />
			<meta property="og:url" content="'.$curl.'" />
			<meta property="og:image" content="'.$img.'" />
			<meta property="og:description" content="'.$description.'" />
			<meta property="og:site_name" content="'.SITE_NAME.'" />			
			<meta property="article:tag" content="'.$keywords.'" />';			
		}else{
			$prefix = 'Unknown Track'; $suffix = SITE_NAME;
		}
	break;
	case "account":
		$prefix = 'Sign in to '.SITE_NAME;
		$sept = $suffix = '';
	break;
	//Adminpanel
	case "admin":
		if(true===$z->isAdmin($session)){
			$prefix = "Admin: "; 
			switch($_GET['area']):
				case "dashboard":
					$prefix .= "Dashboard";
				break;
				case "upload":
					$prefix .= "Upload";
				break;
				case "users":
					$prefix .= "Users";
				break;
				case "albums":
					$prefix .= "Albums";
				break;
				case "tracks":
					$prefix .= "Tracks";
				break;
				case "genres":
					$prefix .= "Genres";
				break;
				case "servers":
					$prefix .= "Servers";
				break;
				case "settings":
					$prefix .= "Settings";
				break;
			endswitch;
			$suffix = SITE_NAME;
		}else{
			header("location: ".baseurl); exit;
		}
	break;
endswitch;
?>
<meta name="robots" content="all" />
<meta name="revisit-after" content="1 days" />
<meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta name="google-site-verification" content="zbJ77MJNlQXRRLIrqKYMR0JSKEdEFgri-Mcv6mQY24k" />
<link href="<?php echo baseurl; ?>ui/favicon.ico" rel="shortcut icon" />
<link rel="stylesheet" href="<?php echo baseurl; ?>css/icon.css" type="text/css" media="screen"/>
<link rel="stylesheet" href="<?php echo baseurl; ?>css/props.css" type="text/css" media="screen"/>
<link rel="stylesheet" href="<?php echo baseurl; ?>css/scroll.css" type="text/css" media="screen"/>
<link rel="stylesheet" href="<?php echo baseurl; ?>css/core.css?<?php echo time(); ?>" type="text/css" media="screen"/>
<?php 
if($z->isMobile()){  echo '<link rel="stylesheet" href="'.baseurl.'css/mob.css?'.time().'" type="text/css" media="screen"/>'; }
if($page=="admin"){  
	echo '<link rel="stylesheet" href="'.baseurl.'css/admin.css?'.time().'" type="text/css" media="screen"/>'; 
	if($z->isMobile()){  echo '<link rel="stylesheet" href="'.baseurl.'css/admin.mob.css?'.time().'" type="text/css" media="screen"/>'; }
}
?>
<title><?php echo $prefix.$sept.$suffix; ?></title>
<meta name="google-signin-client_id" content="<?php echo GOOGLE_CLIENT_ID; ?>">
<meta name="description" content="<?php echo $description; ?>"> 
<meta name="keywords" content="<?php echo $keywords; ?>">
<?php 
$GoogleGaID = $z->getSetting('google_ga');
if(!empty($GoogleGaID) && $GoogleGaID!='ua-xxxxxxxx-x'){
echo '<!-- Global site tag (gtag.js) - Google Analytics -->'
. '<script async src="https://www.googletagmanager.com/gtag/js?id='.strtoupper($GoogleGaID).'"></script>'
. '<script>window.dataLayer = window.dataLayer || [];'
. 'function gtag(){dataLayer.push(arguments);}'
. 'gtag(\'js\', new Date());'
. 'gtag(\'config\', \''.strtoupper($GoogleGaID).'\');</script>';	
}
?>
</head>
<body class="scrollbars size14 fontn color333 <?php echo $z->isMobile() ? 'm ' : ''; echo $area; ?>">
<?php  if($z->isMobile()){ ?>
<div class="header fixed">
	<button class="menuBtn abs bl" data-open="0"><div class="n"></div><div class="n"></div><div class="n"></div></button>
	<a href="<?php echo baseurl; ?>" class="logo rel noul pnvl anim withpstate bl" title="<?php echo SITE_TITLE; ?>"><img src="<?php echo baseurl; ?>ui/logo-head.png" class="bl" title="<?php echo SITE_TITLE; ?>"></a>
	<button class="btnShowPlayer abs bl">
		<div class="icon-album rel icn"><div class="lin abs"></div></div>
		<h2 class="lbl size11 c999">Playing</h2>
	</button>
</div>
<?php } ?>

<?php if($z->getSetting("must_signin")=='yes' && $session->result!='ok'){ ?>
<div class="header fixed">
	<a href="<?php echo baseurl; ?>" class="logo rel noul pnvl anim bl" title="<?php echo SITE_TITLE; ?>"><img src="<?php echo baseurl; ?>ui/logo-head.png" class="bl" title="<?php echo SITE_TITLE; ?>"></a>
	<a href="<?php echo baseurl; ?>account" class="abs accbtn noul size14 fontb">Sign in</a>
</div><div class="header-clr rel"></div>
<?php }else{ ?>
<div class="sidebar fixed scrolls">	
	<a href="<?php echo baseurl; ?>" class="logo rel noul pnvl anim withpstate bl" title="<?php echo SITE_TITLE; ?>"><img src="<?php echo baseurl; ?>ui/logo-head.png" class="bl" title="<?php echo SITE_TITLE; ?>"></a>
	<?php 	
	if($session->result=="ok"){
		echo '<div class="youBox rel">'
			. '<img src="'.$session->dp.'" class="bl dp">'
			. '<h2 class="size13 fontb cfff wordwrap bl nm">'.$session->name->full.'</h2>'
			. '<h2 class="size11 fontn c999 wordwrap bl em">'.$session->email.'</h2>'
		. '</div>';
	}
	
	if($page=="admin" && $_GET['area']!='upload'){?>
	<a href="<?php echo baseurl; ?>admin/upload" class="addNewTrack actBtn noul anim bl size15 fontb">Upload</a>
	<?php } ?>
	<ul class="nav size16 fontl">
		<?php if($page=="admin"){ ?>
			<li class="rel"><a href="<?php echo baseurl; ?>admin/dashboard" class="bl noul anim <?php echo $_GET['area']=="dashboard" ? ' on' : ''; ?>"><div class="ibl icon-chart-pie-outline icn"></div>Dashboard</a></li>
			<li class="rel"><a href="<?php echo baseurl; ?>admin/users" class="bl noul anim <?php echo $_GET['area']=="users" ? ' on' : ''; ?>"><div class="ibl icon-group-outline icn"></div>Users</a></li>
			<li class="rel"><a href="<?php echo baseurl; ?>admin/albums" class="bl noul anim <?php echo $_GET['area']=="albums" ? ' on' : ''; ?>"><div class="ibl icon-tabs-outline icn"></div>Albums</a></li>
			<li class="rel"><a href="<?php echo baseurl; ?>admin/tracks" class="bl noul anim <?php echo $_GET['area']=="tracks" ? ' on' : ''; ?>"><div class="ibl icon-notes-outline icn"></div>Tracks</a></li>
			<li class="rel"><a href="<?php echo baseurl; ?>admin/genres" class="bl noul anim <?php echo $_GET['area']=="genres" ? ' on' : ''; ?>"><div class="ibl icon-tags icn"></div>Genres</a></li>
			<li class="rel"><a href="<?php echo baseurl; ?>admin/servers" class="bl noul anim <?php echo $_GET['area']=="servers" ? ' on' : ''; ?>"><div class="ibl icon-chart-bar-outline icn"></div>Servers</a></li>
			<li class="rel"><a href="<?php echo baseurl; ?>admin/settings" class="bl noul anim <?php echo $_GET['area']=="settings" ? ' on' : ''; ?>"><div class="ibl icon-cog-outline icn"></div>Settings</a></li>
			<li class="rel"><a href="<?php echo baseurl; ?>admin/apikeys" class="bl noul anim <?php echo $_GET['area']=="apikeys" ? ' on' : ''; ?>"><div class="ibl icon-code-outline icn"></div>API Keys</a></li>
			<li class="rel spt"></li>
			<li class="rel"><a href="<?php echo baseurl; ?>signout" class="bl noul anim"><div class="ibl icon-directions icn"></div>Sign out</a></li>
			<li class="rel"><a href="<?php echo baseurl; ?>" class="bl noul anim"><div class="ibl icon-home-outline icn"></div>Back to Site</a></li>
		<?php }else{ ?>
			<li class="rel"><a href="<?php echo baseurl; ?>" data-title="<?php echo SITE_NAME; ?>" class="bl noul anim nstate-home nstate<?php echo $page=="home" ? ' on' : ''; ?>" mod="home"><div class="ibl icon-home-outline icn"></div>Home</a></li>
			<li class="rel"><a href="<?php echo baseurl; ?>search" data-title="Search <?php echo SITE_NAME; ?>" class="bl noul anim nstate-search nstate<?php echo $page=="search" ? ' on' : ''; ?>" mod="search"><div class="ibl icon-zoom-outline icn"></div>Search</a></li>
			<li class="rel"><a href="<?php echo baseurl; ?>library" data-title="Your Library" class="bl noul anim nstate-library nstate<?php echo $page=="library" ? ' on' : ''; ?>" mod="library"><div class="ibl icon-notes-outline icn"></div>Your Library</a></li>
			<?php if($session->result!="ok"){ ?>
				<li class="rel"><a href="<?php echo baseurl; ?>account" class="bl noul anim nstate" mod="account"><div class="ibl icon-user-outline icn"></div>Sign in</a></li>
			<?php }else{ ?>				
				<li class="rel"><a href="<?php echo baseurl; ?>signout" class="bl noul anim"><div class="ibl icon-directions icn"></div>Sign out</a></li>
				<?php if($session->type=='admin' || $session->type=='moderator'){ ?>
					<li class="rel spt"></li>
					<li class="rel"><a href="<?php echo baseurl; ?>admin/dashboard" class="bl noul anim"><div class="ibl icon-coffee icn"></div>Admin Panel</a></li>
					<li class="rel"><a href="<?php echo baseurl; ?>admin/upload" class="bl noul anim"><div class="ibl icon-upload-outline icn"></div>Upload Track</a></li>
				<?php } ?>
			<?php } ?>
		<?php } ?>
	</ul>
</div>
<?php } ?>
<div class="fixed gbox gbox-<?php echo $area; if($z->getSetting("must_signin")=='yes' && $session->result!='ok'){ echo ' gbox-off'; }else{ echo ' scrolls'; } ?>">