<h2 class="size24 fontl cfff title">Welcome to <?php echo SITE_NAME; ?>'s Admin Dashboard</h2>	
<?php 
//Update Check
//zuzmusicversion
$lastUpdateCheck = $z->getSetting('last_updated');
if((time() - $lastUpdateCheck) > (3600 * 24 * 7)){
	$__update = @json_decode($z->_CURL('https://zuz.host/do/zuzmusicversion', false));
	if($__update->version != zuz_version){
		echo '<div class="size14 fontn updateMsg ibl">Version <span class="fontb">'.$__update->version.'</span> (Released on '.$__update->release_date.') is available for download. <a href="https://codecanyon.net/item/zuz-music-advance-music-platform-system/21633476" class="fontb noul noulh color">Visit Codecanyon.net</a></div>';
	}
}
?>	
<ol class="ibl stats">
	<li>
		<h1 class="size40 cont fontb cfff"><?php echo number_format($z->select("SELECT COUNT(ID) as total FROM users WHERE status!=? AND status!=?", array("banned","deleted"), "ss")->row->total); ?></h1>
		<h1 class="size20 lbl fontn cfff">Users</h1>
	</li>
	<li>
		<h1 class="size40 cont fontb cfff"><?php echo number_format($z->select("SELECT COUNT(ID) as total FROM albums WHERE status=?", array("yes"), "s")->row->total); ?></h1>
		<h1 class="size20 lbl fontn cfff">Albums</h1>
	</li>
	<li>
		<h1 class="size40 cont fontb cfff"><?php echo number_format($z->select("SELECT COUNT(ID) as total FROM tracks WHERE status=?", array("yes"), "s")->row->total); ?></h1>
		<h1 class="size20 lbl fontn cfff">Tracks</h1>
	</li>
	<li>
		<h1 class="size40 cont fontb cfff"><?php echo number_format($z->select("SELECT SUM(loops) as total FROM history WHERE uid!=?", array("-1"), "s")->row->total); ?></h1>
		<h1 class="size20 lbl fontn cfff">Loops</h1>
	</li>
</ol>
	
<?php 
//Tracks
$list = $z->select("SELECT * FROM tracks WHERE status=? ORDER BY ID DESC LIMIT 5", array("yes"), "s");
if($list->count > 0 && $list->result=="ok"){
	echo '<div class="rel dashSection">'
	. '<h2 class="size16 title fontb cfff">Newest Tracks &nbsp;&nbsp;&#46;&nbsp;&nbsp;<a href="'.baseurl.'admin/tracks" class="fontn noul noulh c999">View All</a></h2>'
	. '<ol class="trackList ibl">';
	for($n = 0; $n < count($list->fetch); $n++):
		echo $z->trackItemAdmin($list->fetch[$n]);
	endfor;
	echo '</ol></div>';
}

//Users
$list = $z->select("SELECT * FROM users WHERE status!=? ORDER BY ID DESC LIMIT 5", array("deleted"), "s");
if($list->count > 0 && $list->result=="ok"){
	echo '<div class="rel dashSection">'
	. '<h2 class="size16 title fontb cfff">Newest Users &nbsp;&nbsp;&#46;&nbsp;&nbsp;<a href="'.baseurl.'admin/users" class="fontn noul noulh c999">View All</a></h2>'
	. '<ol class="usersList">';
	for($n = 0; $n < count($list->fetch); $n++):
		$dp = baseurl.'dp/'.$z->encode($list->fetch[$n]->dp).'/50x50/picture.jpg';							
		@list($ip, $city, $country) = explode("@@", $list->fetch[$n]->join_location);
		$loct = ""; if(!empty($city)){ $loct .= $city.', '; }
		$loct .= $country;
		@list($_ip, $_city, $_country) = explode("@@", $list->fetch[$n]->last_login_location);
		$_loct = ""; if(!empty($_city)){ $_loct .= $_city.', '; }
		$_loct .= $_country;
		$admin = '<div class="uverify abs">';		
		if($list->fetch[$n]->utype=="admin"){
			$admin  .= '<div class="ic icon-verified_user" title="Admin"></div>';
		}else if($list->fetch[$n]->utype=="moderator"){
			$admin  .= '<div class="ic icon-security" title="Moderator"></div>';
		}
		$admin .= '</div>';
		$hashID = $hash->encode($list->fetch[$n]->ID);
		$statusCurrent = $list->fetch[$n]->status == 'active' || $list->fetch[$n]->status == 'toactivate' ? $z->encode('banned@@'.time()) : $z->encode('active@@'.time());
		$statusLabel = $list->fetch[$n]->status == 'active' || $list->fetch[$n]->status == 'toactivate' ? 'Ban User' : 'Remove Ban';
		echo '<li class="rel val val'.$hashID.' fontn">
			<div class="ibl stat col">
				<div class="sts ibl sts-'.$list->fetch[$n]->status.'" title="'.ucfirst($list->fetch[$n]->status).'"></div>';
				echo $list->fetch[$n]->locked == 'yes' ? '<div class="locked abs icon-lock" title="You cannot edit this user"></div>' : '';
			echo '</div>
			<div class="ibl nam col">
				<div class="ibl dp rel">'.$admin.'<img src="'.$dp.'"></div>
				<div class="naam ibl">
					<h2 class="wordwrap nw fontb">'.stripslashes($list->fetch[$n]->fname).' '.stripslashes($list->fetch[$n]->lname).'</h2>
					<h2 class="wordwrap c999 mail size13 fontn">'.$list->fetch[$n]->email.'</h2>
				</div>
			</div>
			<div class="ibl joind col">
				<h2 class="wordwrap fontb">'.date("d M Y", $list->fetch[$n]->join_date).'</h2>
				<h2 class="mail size13 fontn c999">'.$loct.'</h2>
			</div>
			<div class="ibl logd col">
				<h2 class="wordwrap fontb">'.$z->timeAgo($list->fetch[$n]->last_login).'</h2>
				<h2 class="mail size13 fontn c999">'.$_loct.'</h2>
			</div>		
			<div class="ibl acts col rel">';
			if($list->fetch[$n]->ID!=$session->ID){
				echo '<button class="userAction bl anim size13" data-id="'.$hashID.'">Action<div class="aro ibl"></div></button>
				<ol class="userOptions userOptions'.$hashID.' hoc abs size13 fontn">					
					<li class="btn uopt'.$hashID.'bl anim rel" data-mod="moder" data-id="'.$hashID.'">User Type <div class="raro abs"></div>
						<ol class="subOpt subOpt'.$hashID.' abs size13 fontn">
							<li class="btn action bl anim'; echo $list->fetch[$n]->utype=='user' ? ' on' : ''; echo '" data-mod="utype" data-type="user" data-token="'.$z->encode('user@@'.time()).'" data-id="'.$hashID.'"><div class="ibl icn icon-tick"></div>Standard User</li>
							<li class="btn action bl anim'; echo $list->fetch[$n]->utype=='admin' ? ' on' : ''; echo '" data-mod="utype" data-type="admin" data-token="'.$z->encode('admin@@'.time()).'" data-id="'.$hashID.'"><div class="ibl icn icon-tick"></div>Admin</li>
							<li class="btn action bl anim'; echo $list->fetch[$n]->utype=='moderator' ? ' on' : ''; echo '" data-mod="utype" data-type="moderator" data-token="'.$z->encode('moderator@@'.time()).'" data-id="'.$hashID.'"><div class="ibl icn icon-tick"></div>Moderator</li>							
						</ol>
					</li>
					<li class="btn action uopt'.$hashID.' bl anim" data-mod="ban" data-current="'.$statusCurrent.'" data-id="'.$hashID.'">'.$statusLabel.'</li>
				</ol>';
			}
			echo '</div>
			<div class="abs covr cover'.$hashID.'"></div>
		</li>';
	endfor;
	echo '</ol></div>';
}

?>
