var _upload = { id: -1, que: [], status: false };
function GetYtId(url){
    var regExp = /^(?:https?:\/\/)?(?:www\.)?youtu\.?be(?:\.com)?.*?(?:v|list)=(.*?)(?:&|$)|^(?:https?:\/\/)?(?:www\.)?youtu\.?be(?:\.com)?(?:(?!=).)*\/(.*)$/;
	var match = url.match(regExp), type;
	if(match){
		if(match[0].indexOf('/playlist?list=') > -1){
			type = 'playlist';
		}else if(match[0].indexOf('/watch?v=') > -1){
			type = 'video';
		}
		return {result: 'ok', type: type, ID: match[1]};
	}
	return {result: 'error'};	
}
function isSoundCloudUrl(url){
  var regexp = /^https?:\/\/(soundcloud\.com|snd\.sc)\/(.*)$/;
  return url.match(regexp) ? true : false;
}
function getSoundCloudID(url){
  var regexp = /^https?:\/\/(soundcloud\.com|snd\.sc)\/(.*)$/,
  id = url.match(regexp) && url.match(regexp)[2];
  return id.replace(/\//g, '');
}
function loadAlbums(){
	$(".ualbums li.cat").remove();
	for(var n = 0; n < zuz.albums.length; n++){
		var s = parseInt(zuz.albums[n].count) > 1 ? "s" : "";
		$(".ualbums").append('<li class="cat anim" data-count="'+zuz.albums[n].count+'" data-id="'+zuz.albums[n].ID+'" data-cover="'+zuz.albums[n].cover+'" data-label="'+zuz.albums[n].label+'"><div class="ibl thumb"><img class="bl" src="'+zuz.albums[n].cover+'"></div>'
			+ '<div class="ibl naam">'
				+ '<span class="fontb">'+zuz.albums[n].label+'</span>'
				+ '<div class="bl ctr">'+zuz.albums[n].count+' track'+s+'</div>'
			+ '</div></li>');
	}
}

function loadGenres(){
	$(".ucates li.cat").remove();
	for(var n = 0; n < zuz.genres.length; n++){
		var s = parseInt(zuz.genres[n].count) > 1 ? "s" : "";
		$(".ucates").append('<li class="cat anim" data-count="'+zuz.genres[n].count+'" data-id="'+zuz.genres[n].ID+'" data-label="'+zuz.genres[n].label+'"><div class="ibl thumb"><img src="'+zuz.base+'ui/no-image.png" class="bl"></div>'
			+ '<div class="ibl naam">'
				+ '<span class="fontb">'+zuz.genres[n].label+'</span>'
				+ '<div class="bl ctr">'+zuz.genres[n].count+' track'+s+'</div>'
			+ '</div></li>');
	}
	
}

function addTrackCount(album, cate){
	for(var n = 0; n < zuz.genres.length; n++){
		if(zuz.genres[n].ID==cate){
			zuz.genres[n].count++;
		}
	}
	for(var n = 0; n < zuz.albums.length; n++){
		if(zuz.albums[n].ID==album){
			zuz.albums[n].count++;
		}
	}
	loadAlbums();
	loadGenres();
}

function tagr(tag){
	return '<li class="rel" data-tag="'+tag+'">' + tag
	+ '<button class="rmTag abs">&times;</button>'
	+ '</li>';
}

function fetchYoutubePlaylist(ID, next){
	var uri = 'https://oyecdn.us/zemdrive/do/getytlist?id='+ID;
	uri += next!='none' ? '&next=' + next : '';
	zuz.post(uri, '', function(resp){		
		if(resp.result=="ok"){			
			for(var n = 0; n < resp.ids.length; n++){
				addTrackToUploadQue('youtube', resp.ids[n], resp.ids[n]);
			}			
			if(resp.nxt=='none'){
				zuz.toast('Playlist added to Upload Que...', 6);		
			}else{
				fetchYoutubePlaylist(ID, resp.nxt);
			}
		}else{
			zuz.toast(resp.message, 6);	
		}
	}, function(){
		zuz.toast("Unable to process request...", 6);
	});
}

function addTrackToUploadQue(type, ID, uri){
	if($("li.que-"+ID).length > 0){ zuz.toast('Requested Track already in que...', 6); $(".up-yt-uri").select(); return; }
	$(".upload-que").append(UploadItem(type, ID, " barb")).show();	
	if(type=='local'){
		$(".upbox .que li .imglodr-"+ID).unbind("change").on("change", function(){
			var self = $(this), btn = $(".chooseLocalPhoto"+ID),
			phid = self.attr("data-id"),
			_files = self.prop('files');						
			if(_files && _files.length > 0){
				btn.hide();
				$(".upbox .que li .head .thumb .iprog-"+phid).show();
				var bar = $(".upbox .que li .head .thumb .iprog-"+phid+" .bar");
				bar.css("width", "0px");
				var formData = new FormData();
				formData.append('file', _files[0]);
				formData.append('uid', zuz.me.ID);
				formData.append('token', zuz.me.token);				
				$(".upbox .que li .imglodr-"+ID).attr("value", "");
				$.ajax({
					xhr: function(){
						var obj = $.ajaxSettings.xhr();
						if(obj.upload){
							obj.upload.addEventListener('progress', function(evt){
								var percent = 0,
								pos = evt.loaded || evt.position,
								total = evt.total;
								if(evt.lengthComputable){
									percent = Math.ceil(pos / total * 100);                                                        	
								}
								bar.css("width", percent + '%');
								if(percent == 100){ bar.css("width", '100%'); }
							}, false);
						}
						return obj;
					},
					url: zuz.app+'adminSavePoster',
					type: "POST",
					contentType:false,
					processData: false,
					cache: false,
					data: formData,
					timeout: 300 * 1000,
					success: function(resp){														
						$(".upbox .que li .head .thumb .iprog-"+phid).hide();	
						btn.show();						
						if(resp.result=="ok"){							
							$(".upbox .que li .uhead-"+phid+" .thumb img").attr("src", resp.src).attr("data-img", resp.fileid);
							$(".uhead-"+phid+" .thumb").attr("data-thumb", resp.fileid);
						}else{
							go.toast(resp.message, 6);														
						}
					},
					error: function(resp){
						go.toast("Unable to save photo");
						btn.show();
						$(".upbox .que li .head .thumb .iprog-"+phid).hide();							
					}
				});
			}
		});
	}
	$(".emptyQue").hide();
	$(".upload-que").show();
	$(".up-yt-uri").val("");
	$(".uploadbtns .uploadsp").hide();	
	var canAdd = true;
	if(_upload.que.length > 0){
		for(var x = 0; x < _upload.que.length; x++){
			if(_upload.que[x].ID==ID){ canAdd = false; }
		}		
	}
	if(canAdd==true){ _upload.que.push({ ID: ID, type: type, url: uri }); }
	if(_upload.status==false){ _upload.id++; }
	uploadQue();
}

function uploadQue(){
	$("span.que-count").html(' ('+$("li.que-pending").length+')');	
	if($("li.uque").length > 0){
		if(_upload.status==true) return;
		_upload.status = true;		
		var Q = _upload.que[_upload.id],
		ID = Q.ID,
		cli = $("li.que-"+ID);
		console.log(Q);
		$("li.que-"+ID+" .info .filest").html("Fetching available server...");
		$('.adminBox').animate({ scrollTop: $("li.que-"+ID).offset().top - 200 }, 1000);		
		zuz.post(zuz.app+'adminGetServer', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&mod='+Q.type+'&sid='+ID, function(resp){
			if(resp.result=="ok"){				
				if(Q.type=='local'){
					$("li.que-"+ID+" .info .filest").html("Uploading...");
					var formData = new FormData();
					formData.append('client', zuz.urlencode(zuz.base));
					formData.append('uid', zuz.me.ID);
					formData.append('token', zuz.me.token);
					formData.append('sid', resp.ID);
					formData.append('mod', Q.type);
					formData.append('vid', Q.url);					
					formData.append('formats', zuz.audioFormats);					
					var bar = $(".upload-que .que-"+ID+" .prog .bar");
					bar.removeClass("barb");
					$.ajax({
						xhr: function(){
							var obj = $.ajaxSettings.xhr();
							if(obj.upload){
								obj.upload.addEventListener('progress', function(evt){
									var percent = 0,
									pos = evt.loaded || evt.position,
									total = evt.total;
									if(evt.lengthComputable){
										percent = Math.ceil(pos / total * 100);                                                        	
									}
									bar.css("width", percent + '%');
									$("li.que-"+ID+" .info .filest").html("Uploading " + percent + "%");
									if(percent == 100){ 
										bar.css("width", '100%'); 
										bar.addClass("barb");
										$("li.que-"+ID+" .info .filest").html("Converting & Saving...");
									}									
								}, false);
							}
							return obj;
						},
						url: resp.uri,
						type: "POST",
						contentType:false,
						processData: false,
						cache: false,
						data: formData,
						timeout: 300 * 1000,
						success: function(data){														
							/*if(resp.result=="ok"){
								li.removeClass("pending").attr("data-photo", resp.fileid);
								rem.transition({scale: 1.1}).transition({scale: 1});
								prog.hide();
							}else{
								go.toast(resp.message, 6);
								li.transition({scale: 1.1}).transition({scale: 0, complete: function(){ li.remove(); }});
							}*/
							if(data.result=="ok"){
								loadAlbums();
								loadGenres();
								zuz.scrolls();					
								$(".utrack-"+ID+" .save-this-track").attr({
									dataid : data.id,
									source : data.source,
									server : resp.ID,
									disk : data.disk
								});					
								$(".utrack-"+ID+" .track-title").val(Q.url.name);
								$(".utrack-"+ID+" .track-duration").val(data.duration.format);
								$(".utrack-"+ID+" .track-duration").attr("data-duration", data.duration.raw);
								$(".utrack-"+ID+" .track-artist").val(data.artist);
								$(".uhead-"+ID+" .prog .bar").removeClass("barb").animate({ width : "100%" });
								$("li.que-"+ID+" .info .filest").html("Converted & saved...");
								$(".utrack-"+ID).slideDown(500);
								$(".que-"+ID).removeClass("que-pending");
								_upload.status = false;
								if(_upload.id < _upload.que.length - 1){
									_upload.id++; uploadQue();
								}else{
									$("span.que-count").html(' ('+$("li.que-pending").length+')');
								}	
							}else{
								_upload.status = false;
								var retry = parseInt(GetAttr($("li.que-"+ID), "retry")) - 1;			
								$("li.que-"+ID).attr("retry", retry);
								if(retry > 0){
									uploadQue();
								}else{
									$("li.que-"+ID+" .info .filest").html("Max Retry Limit Reached. Skipping...");
									$(".uhead-"+ID+" .prog .bar").removeClass("barb").addClass("bare").animate({ width : "100%" });
									$(".uhead-"+ID+" .icn-error").transition({scale: 1.2}).transition({scale: 1});
									$(".que-"+ID).removeClass("que-pending");
									setTimeout(function(){
										if(_upload.id < _upload.que.length - 1){
											_upload.id++; uploadQue();
										}else{
											$("span.que-count").html(' ('+$("li.que-pending").length+')');
											$(".emptyQue").show();
											$(".upload-que").hide();
										}
									}, 2000);
								}	
							}
						},
						error: function(resp){
							/*go.toast("Unable to save photo");
							li.transition({scale: 1.1}).transition({scale: 0, complete: function(){ li.remove(); }});*/
							_upload.status = false;
							var retry = parseInt(GetAttr($("li.que-"+ID), "retry")) - 1;			
							$("li.que-"+ID).attr("retry", retry);
							if(retry > 0){
								uploadQue();
							}else{
								$("li.que-"+ID+" .info .filest").html("Max Retry Limit Reached. Skipping...");
								$(".uhead-"+ID+" .prog .bar").removeClass("barb").addClass("bare").animate({ width : "100%" });
								$(".uhead-"+ID+" .icn-error").transition({scale: 1.2}).transition({scale: 1});
								$(".que-"+ID).removeClass("que-pending");
								setTimeout(function(){
									if(_upload.id < _upload.que.length - 1){
										_upload.id++; uploadQue();
									}else{
										$("span.que-count").html(' ('+$("li.que-pending").length+')');
										$(".emptyQue").show();
										$(".upload-que").hide();
									}
								}, 2000);
							}	
						}
					});
				}else{			
					zuz.post(resp.uri, 'client='+zuz.urlencode(zuz.base)+'&uid='+zuz.me.ID+'&token='+zuz.me.token+'&sid='+resp.ID+'&mod='+Q.type+'&vid='+Q.url+'&formats='+zuz.audioFormats, function(data){
						loadAlbums();
						loadGenres();
						zuz.scrolls();					
						$(".utrack-"+ID+" .save-this-track").attr({
							dataid : data.id,
							source : data.source,
							server : resp.ID,
							disk : data.disk
						});					
						if(data.source=="soundcloud"){
							$(".uhead-"+ID+" .thumb").attr("data-thumb", data.thumb).css("background", "url("+data.thumb+") no-repeat center").css("background-size","cover");
							$(".uhead-"+ID+" .thumb img").hide();
						}
						$(".utrack-"+ID+" .track-title").val(data.title);
						$(".utrack-"+ID+" .track-duration").val(data.duration.format);
						$(".utrack-"+ID+" .track-duration").attr("data-duration", data.duration.raw);
						$(".utrack-"+ID+" .track-artist").val(data.artist);
						$(".uhead-"+ID+" .prog .bar").removeClass("barb").animate({ width : "100%" });
						$("li.que-"+ID+" .info .filest").html("Converted & saved...");
						var split = data.tags.split(",");
						for(var n = 0; n < split.length; n++){
							$(".utrack-"+ID+" .track-tags li.toknr").before(tagr(split[n])).show();
						}					
						$(".utrack-"+ID).slideDown(500);
						$(".que-"+ID).removeClass("que-pending");
						_upload.status = false;
						if(_upload.id < _upload.que.length - 1){
							_upload.id++; uploadQue();
						}else{
							$("span.que-count").html(' ('+$("li.que-pending").length+')');
						}					
					}, function(){
						_upload.status = false;
						var retry = parseInt(GetAttr($("li.que-"+ID), "retry")) - 1;			
						$("li.que-"+ID).attr("retry", retry);
						if(retry > 0){
							uploadQue();
						}else{
							$("li.que-"+ID+" .info .filest").html("Max Retry Limit Reached. Skipping...");
							$(".uhead-"+ID+" .prog .bar").removeClass("barb").addClass("bare").animate({ width : "100%" });
							$(".uhead-"+ID+" .icn-error").transition({scale: 1.2}).transition({scale: 1});
							$(".que-"+ID).removeClass("que-pending");
							setTimeout(function(){
								if(_upload.id < _upload.que.length - 1){
									_upload.id++; uploadQue();
								}else{
									$("span.que-count").html(' ('+$("li.que-pending").length+')');
									$(".emptyQue").show();
									$(".upload-que").hide();
								}
							}, 2000);
						}	
					});	
				}				
			}else if(resp.result=="already"){
				zuz.toast(resp.message, 6);
				_upload.status = false;
				$("li.que-"+ID+" .info .filest").html("Already uploaded. Skiped.");
				$(".uhead-"+ID+" .prog .bar").removeClass("barb").animate({ width : "100%" });
				$(".uhead-"+ID+" .icn-ok").transition({scale: 1.2}).transition({scale: 1});
				$(".que-"+ID).removeClass("que-pending");
				setTimeout(function(){
					if(_upload.id < _upload.que.length - 1){
						_upload.id++; uploadQue();
					}
				}, 2000);
			}else{
				_upload.status = false;
				var retry = parseInt(GetAttr($("li.que-"+ID), "retry")) - 1;			
				$("li.que-"+ID).attr("retry", retry);
				if(retry > 0){
					uploadQue();
				}else{
					$("li.que-"+ID+" .info .filest").html("Max Retry Limit Reached. Skipping...");
					$(".uhead-"+ID+" .prog .bar").removeClass("barb").addClass("bare").animate({ width : "100%" });
					$(".uhead-"+ID+" .icn-error").transition({scale: 1.2}).transition({scale: 1});
					$(".que-"+ID).removeClass("que-pending");
					setTimeout(function(){
						if(_upload.id < _upload.que.length - 1){
							_upload.id++; uploadQue();
						}else{
							$("span.que-count").html(' ('+$("li.que-pending").length+')');
							$(".emptyQue").show();
							$(".upload-que").hide();
						}
					}, 2000);
				}
			}
		}, function(){
			_upload.status = false;
			var retry = parseInt(GetAttr($("li.que-"+ID), "retry")) - 1;			
			$("li.que-"+ID).attr("retry", retry);
			if(retry > 0){
				uploadQue();
			}else{
				$("li.que-"+ID+" .info .filest").html("Max Retry Limit Reached. Skipping...");
				$(".uhead-"+ID+" .prog .bar").removeClass("barb").addClass("bare").animate({ width : "100%" });
				$(".uhead-"+ID+" .icn-error").transition({scale: 1.2}).transition({scale: 1});
				$(".que-"+ID).removeClass("que-pending");
				setTimeout(function(){
					if(_upload.id < _upload.que.length - 1){
						_upload.id++; uploadQue();
					}else{
						$("span.que-count").html(' ('+$("li.que-pending").length+')');
						$(".emptyQue").show();
						$(".upload-que").hide();
					}
				}, 2000);
			}
		});
	}
}

function UploadItem(mod, ID, cls){
	var img = zuz.base+'ui/local.png',
	uri = 'Local file', imgupod = '';
	if(mod=='youtube'){
		img = 'https://i.ytimg.com/vi/'+ID+'/mqdefault.jpg';
		uri = 'Youtu.be/'+ID;
	}else if(mod=='soundcloud'){
		img = zuz.base+'ui/soundcloud.png';
		uri = ID;
	}else if(mod=='local'){
		imgupod = '<input type="file" class="imglodr imglodr-'+ID+' fixed" data-id="'+ID+'" accept="image/*">' +
		'<button class="icon-photo chooseLocalPhoto chooseLocalPhoto'+ID+' abs anim" title="Select Image File" data-id="'+ID+'"></button>' +
		'<div class="abs iprog iprog-'+ID+'"><div class="abs bar"></div></div>';
	}
	return '<li class="rel uque item que-'+ID+' que-pending" retry="3">'
		+ '<div class="head uhead-'+ID+' rel">'
			+ '<div class="ibl thumb rel" data-thumb="none">'+imgupod+'<img src="'+img+'" data-img="none"></div>'
			+ '<div class="ibl info">'
				+ '<h2 class="filet size16 fontn cfff wordwrap">'+uri+'</h2>'
				+ '<div class="prog rel"><div class="bar'+cls+'"></div></div>'
				+ '<h2 class="filest size12 fontn">In Que...</h2>'
			+ '</div>'
			+ '<div class="icon-tick icn-ok abs"></div>'
			+ '<div class="icon-times icn-error abs"></div>'
		+ '</div>'
		+ '<div class="track utrack-'+ID+' cfff rel">'
			+ '<div class="rel hed size16 fontn cfff">Track Info'
				+ '<button class="actBtn abs save-this-track size13 fontb" data-id="'+ID+'">Publish</button>'
			+ '</div>'
			+ '<div class="put putb ibl rel">'
				+ '<h2 class="size14 fontb ibl">Select Album</h2>'
				+ '&nbsp;&nbsp;&nbsp;<a href="javascript:;" class="create-new-album ibl size14 fontn noul noulh">(Create New)</a>'
				+ '<div class="iput size14 fontn usalbum ualbum'+ID+' track-album rel" data-id="'+ID+'" dataid="-1">'
					+ '<div class="ibl thumb"></div>'
					+ '<div class="ibl naam">'
						+ '<span class="fontb lab">Click to Select</span>'
						+ '<div class="bl ctr">--</div>'							
					+ '</div>'
					+ '<div class="aro abs"></div>'
				+ '</div>'
				+ '<ul class="ualbums-'+ID+' hoc ualbums uselect scrolls abs size13 fontn" data-id="'+ID+'"></ul>'
			+ '</div>'
			+ '<div class="put putb ibl rel">'
				+ '<h2 class="size14 fontb ibl">Genre</h2>'
				+ '<div class="iput size14 fontn uscate ucate'+ID+' track-album rel" data-id="'+ID+'" dataid="-1">'
					+ '<div class="ibl thumb"></div>'
					+ '<div class="ibl naam">'
						+ '<span class="fontb lab">Click to Select</span>'
						+ '<div class="bl ctr">--</div>'
					+ '</div>'						
					+ '<div class="aro abs"></div>'
				+ '</div>'
				+ '<ul class="ugenres-'+ID+' hoc ucates uselect scrolls abs size13 fontn" data-id="'+ID+'"></ul>'
			+ '</div>'				
			+ '<div class="put rel">'
				+ '<h2 class="size14 fontb">Title</h2>'
				+ '<input type="text" placeholder="Track title..." class="iput cfff size14 fontn track-title">'
			+ '</div>'
			+ '<div class="put put-t rel">'
				+ '<h2 class="size14 fontb">Tags</h2>'
				+ '<div class="iput rel"><ol class="size14 fontn size14 ibl tagr tagr'+ID+' track-tags">'
				+ '<li class="rel toknr"><input data-id="'+ID+'" type="text" placeholder="Enter tag..." class="tokener size14 fontn cfff" data-id="'+ID+'"></li>'
				+ '</ol></div>'
			+ '</div>'
			+ '<div class="put putb ibl rel">'
				+ '<h2 class="size14 fontb">Duration</h2>'
				+ '<input type="text" placeholder="00:00:00" class="iput fontn cfff size14 rel track-duration">'
			+ '</div>'
			+ '<div class="put putb ibl rel">'
				+ '<h2 class="size14 fontb">Artist</h2>'
				+ '<input type="text" placeholder="Artist name" class="iput fontn cfff size14 rel track-artist">'
			+ '</div>'
		+ '</div>'
	+ '</li>';
}

function editItem(item){
	return '<div class="rel editItem" data-local="no" data-id="'+item.attr("data-id")+'">'
		+ '<div class="trackDP rel"><img src="'+item.attr("data-poster")+'"></div>'			
		+ '<div class="put rel">'
			+ '<h2 class="size14 fontb">Track Photo</h2>'
			+ '<input type="file" class="iput cfff size14 fontn _selectTrackPhoto">'
		+ '</div>'
		+ '<div class="put putb ibl rel">'
			+ '<h2 class="size14 fontb ibl">Select Album</h2>'			
			+ '<div class="iput size14 fontn uAlbumCurrent usalbum ualbum'+item.attr("data-id")+' track-album rel" data-id="'+item.attr("data-id")+'" dataid="-1">'
				+ '<div class="ibl thumb"></div>'
				+ '<div class="ibl naam">'
					+ '<span class="fontb lab">Click to Select</span>'
					+ '<div class="bl ctr">--</div>'							
				+ '</div>'
				+ '<div class="aro abs"></div>'
			+ '</div>'
			+ '<ul class="ualbums-'+item.attr("data-id")+' hoc uSelectAlbums ualbums uselect scrolls abs size13 fontn" data-id="'+item.attr("data-id")+'"></ul>'
		+ '</div>'
		+ '<div class="put putb ibl rel">'
			+ '<h2 class="size14 fontb ibl">Genre</h2>'
			+ '<div class="iput size14 fontn uCateCurrent uscate ucate'+item.attr("data-id")+' track-album rel" data-id="'+item.attr("data-id")+'" dataid="-1">'
				+ '<div class="ibl thumb"></div>'
				+ '<div class="ibl naam">'
					+ '<span class="fontb lab">Click to Select</span>'
					+ '<div class="bl ctr">--</div>'
				+ '</div>'						
				+ '<div class="aro abs"></div>'
			+ '</div>'
			+ '<ul class="ugenres-'+item.attr("data-id")+' hoc ucates uSelectGenres uselect scrolls abs size13 fontn" data-id="'+item.attr("data-id")+'"></ul>'
		+ '</div>'				
		+ '<div class="put rel">'
			+ '<h2 class="size14 fontb">Title</h2>'
			+ '<input type="text" placeholder="Track title..." value="'+item.attr("data-title")+'" class="iput cfff size14 fontn track-title">'
		+ '</div>'
		+ '<div class="put put-t rel">'
			+ '<h2 class="size14 fontb">Tags</h2>'
			+ '<div class="iput rel"><ol class="size14 fontn size14 ibl tagr tagr'+item.attr("data-id")+' track-tags">'
			+ '<li class="rel toknr"><input data-id="'+item.attr("data-id")+'" type="text" placeholder="Enter tag..." class="tokener size14 fontn cfff" data-id="'+item.attr("data-id")+'"></li>'
			+ '</ol></div>'
		+ '</div>'
		+ '<div class="put putb ibl rel">'
			+ '<h2 class="size14 fontb">Artist</h2>'
			+ '<input type="text" placeholder="Artist name" value="'+item.attr("data-artist")+'" class="iput fontn cfff size14 rel track-artist">'
		+ '</div>'	
	+ '</div>';
}

zuz.addEvent("click", ".actionokadmin", function(){
	switch($(this).attr("data-mod")){
		case "_cnalbm":
			var album = $(".newalbum-naam").val();
			if($(".cover .box .albumDP .cropper-container").length == 0){
				ShakeBox();
				zuz.toast("Album cover is missing...", 6);
			}else if(album==""){
				ShakeBox();
				$(".newalbum-naam").focus();
			}else{
				$(".loadingCover").fadeIn(200);
				$(".cover .box .albumDP .img").cropper('getCroppedCanvas').toBlob(function(blob){
					var formData = new FormData();
					formData.append("uid", zuz.me.ID);					
					formData.append("token", zuz.me.token);
					formData.append('cover', blob);
					formData.append('name', album);
					$.ajax(zuz.app+'adminCreateAlbum', {
						method: "POST",
						data: formData,
						processData: false,
						contentType: false,
						timeout: 60 * 15 * 1000,
						success: function (data) {
							if(data.result=="ok"){
								$(".loadingCover .loc").html(zuz.material.ok(50));
								zuz.albums.push({ ID: data.ID, label: album, cover: data.cover, count: 0 });
								loadAlbums();
								if($(".albumList").length > 0){
									$(".albumList").prepend(
										'<li class="rel album'+data.ID+'">'
										+ '<div class="poster rel"><img src="'+data.cover+'" class="bl"></div>'
										+ '<h2 class="size14 fontb wordwrap ttl cfff">'+album+'</h2>'
										+ '<h2 class="size13 fontn ctr c999">0 Track</h2>'
										+ '<button class="editBtn bl size13 fontn anim" data-cover="'+data.cover+'" data-title="'+album+'" data-id="'+data.ID+'">Edit</button>'
										+ '<a href="javascript:;" class="size11 noul noulh rmAlbum" data-id="'+data.ID+'">Delete</a></li>'
									);
								}
								setTimeout(function(){
									cover(false);
								}, 2000);
							}else{
								$(".loadingCover").hide();
								ShakeBox();
								$(".newalbum-naam").focus();
								zuz.toast(resp.message, 6);
							}
						},
						error: function(){
							$(".loadingCover").hide();
							ShakeBox();
							$(".newalbum-naam").focus();
							zuz.toast("We are unable to process your request...", 6);
						}
					});
				});				
			}
		break;
		case "_easvalbm":
			var album = $(".newalbum-naam").val(),
			ID = $(".newalbum-naam").attr("data-id"),
			covr = $(".albumList li.album"+ID+" .poster img").attr("src");
			if(album==""){
				ShakeBox();
				$(".newalbum-naam").focus();
			}else{
				$(".loadingCover").fadeIn(200);
				$(".cover .box .albumDP .img").cropper('getCroppedCanvas').toBlob(function(blob){
					var formData = new FormData();
					formData.append("uid", zuz.me.ID);					
					formData.append("token", zuz.me.token);
					formData.append('cover', blob);
					formData.append('name', album);
					formData.append('aid', ID);
					$.ajax(zuz.app+'adminUpdateAlbum', {
						method: "POST",
						data: formData,
						processData: false,
						contentType: false,
						timeout: 60 * 15 * 1000,
						success: function (data) {
							if(data.result=="ok"){
								$(".loadingCover .loc").html(zuz.material.ok(50));								
								$(".albumList li.album"+ID+" .poster img").attr("src", data.cover);
								$(".albumList li.album"+ID+" .ttl").html(data.title);
								setTimeout(function(){
									cover(false);
								}, 2000);
							}else{
								$(".loadingCover").fadeOut(200);
								ShakeBox();
								$(".newalbum-naam").focus();
								zuz.toast(resp.message, 6);
							}
						},
						error: function(){
							ShakeBox();
							$(".newalbum-naam").focus();
							$(".loadingCover").fadeOut(200);
							zuz.toast("We are unable to process your request...", 6);
						}
					});
				});				
			}
		break;
		case "_easvtrack":
			var ID = $(".editItem").attr("data-id"),
			imgLocal = $(".editItem").attr("data-local"),
			album = $(".editItem .uAlbumCurrent").attr("dataid"),
			genre = $(".editItem .uCateCurrent").attr("dataid"),
			title = $(".editItem .track-title").val(),
			tags = [], artist = $(".editItem .track-artist").val();
			$(".editItem .tagr li").each(function(){
				if(zuz.hasAttr($(this).attr("data-tag"))==true){
					tags.push($(this).attr("data-tag"));
				}
			});
			if(title==""){
				zuz.toast("Enter track title...", 6);
				$(".editItem .track-title").focus();
				ShakeBox();
			}else if(tags.length==0){
				zuz.toast("Enter track tags...", 6);				
				ShakeBox();
			}else if(artist==""){
				zuz.toast("Enter track artist...", 6);
				$(".editItem .track-artist").focus();
				ShakeBox();
			}else{
				$(".loadingCover").show();
				if(imgLocal=='yes'){
					$(".cover .trackDP .img").cropper('getCroppedCanvas').toBlob(function(blob){
						var formData = new FormData();
						formData.append("uid", zuz.me.ID);					
						formData.append("token", zuz.me.token);
						formData.append('isposter', "yes");
						formData.append('poster', blob);
						formData.append('album', album);
						formData.append('genre', genre);
						formData.append('title', title);
						formData.append('tags', tags.join());
						formData.append('artist', artist);
						formData.append('tid', ID);
						$.ajax(zuz.app+'adminUpdateTrack', {
							method: "POST",
							data: formData,
							processData: false,
							contentType: false,
							timeout: 60 * 15 * 1000,
							success: function (data) {
								if(data.result=="ok"){
									$(".loadingCover .loc").html(zuz.material.ok(50));								
									setTimeout(function(){										
										window.location = window.location.href;
									}, 2000);
								}else{
									$(".loadingCover").fadeOut(200);
									ShakeBox();									
									zuz.toast(resp.message, 6);
								}
							},
							error: function(){
								ShakeBox();								
								$(".loadingCover").fadeOut(200);
								zuz.toast("We are unable to process your request...", 6);
							}
						});
					});
				}else{
					var formData = new FormData();
					formData.append("uid", zuz.me.ID);					
					formData.append("token", zuz.me.token);
					formData.append('isposter', "no");					
					formData.append('album', album);
					formData.append('genre', genre);
					formData.append('title', title);
					formData.append('tags', tags.join());
					formData.append('artist', artist);
					formData.append('tid', ID);
					$.ajax(zuz.app+'adminUpdateTrack', {
						method: "POST",
						data: formData,
						processData: false,
						contentType: false,
						timeout: 60 * 15 * 1000,
						success: function (data) {
							if(data.result=="ok"){
								$(".loadingCover .loc").html(zuz.material.ok(50));								
								setTimeout(function(){										
									window.location = window.location.href;
								}, 2000);
							}else{
								$(".loadingCover").fadeOut(200);
								ShakeBox();									
								zuz.toast(resp.message, 6);
							}
						},
						error: function(){
							ShakeBox();								
							$(".loadingCover").fadeOut(200);
							zuz.toast("We are unable to process your request...", 6);
						}
					});
				}
			}
		break;
		case "_easvgenre":
			var naam = $(".genre-naam").val(),
			slug = $(".genre-slug").val(),
			ID = $(".genre-naam").attr("data-id");
			if(naam==""){
				$(".genre-naam").focus();
				ShakeBox();
			}else{
				$(".loadingCover").show();
				zuz.post(zuz.app+'adminUpdateGenre', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&gid='+ID+'&slug='+zuz.urlencode(slug)+'&naam='+zuz.urlencode(naam),
				function(resp){
					zuz.toast(resp.message, 6);					
					if(resp.result=="ok"){
						$(".loadingCover .loc").html(zuz.material.ok(50));								
						setTimeout(function(){										
							cover(false);
						}, 2000);
						$(".genreList li.genre"+ID+" .lab").html(naam).attr("data-slug", resp.slug).attr("data-label", naam);
					}else{
						$(".loadingCover").hide();
					}
				}, function(){
					zuz.toast("We are unable to process request...", 6);
					$(".loadingCover").hide();
				});
			}			
		break;
		case "_cngenrnow":
			var naam = $(".genre-naam").val();
			if(naam==""){
				$(".genre-naam").focus();
				ShakeBox();
			}else{
				$(".loadingCover").show();
				zuz.post(zuz.app+'adminNewGenre', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&naam='+zuz.urlencode(naam),
				function(resp){
					zuz.toast(resp.message, 6);					
					if(resp.result=="ok"){
						$(".loadingCover .loc").html(zuz.material.ok(50));								
						$(".genreList").prepend('<li class="rel genre'+resp.ID+'">'
						+ '<div class="ico anim"><img src="'+zuz.base+'ui/no-image.png" class="bl rel"></div>'
						+ '<h2 class="size14 cfff lab fontb">'+resp.title+'</h2>'
						+ '<button class="editBtn bl size13 fontn anim" data-slug="'+resp.slug+'" '
							+ 'data-label="'+resp.title+'" data-id="'+resp.ID+'">Edit</button>'
						+ '<a href="javascript:;" class="size11 noul noulh rmGenre" data-id="'+resp.ID+'">Delete</a>'
						+ '</li>');
						$(".que-count").html('('+resp.total+')');
						setTimeout(function(){										
							cover(false);
						}, 2000);						
					}else{
						$(".loadingCover").hide();
					}
				}, function(){
					zuz.toast("We are unable to process request...", 6);
					$(".loadingCover").hide();
				});
			}
		break;
		case "_anservrnow":
			var name = $(".server-naam").val(),
			url = $(".server-url").val(),
			space = parseInt($(".server-space").val());
			if(name==""){
				$(".server-naam").focus();
				ShakeBox();
			}else if(url=="" || zuz.isValidUrl(url)==false){
				$(".server-url").focus();
				ShakeBox();
				zuz.toast("Enter valid server url ending a slash...", 6);
			}else if(space <= 0){
				$(".server-space").focus();
				ShakeBox();
				zuz.toast("Enter server space in GB e.g: 5", 6);
			}else{
				$(".loadingCover").show();
				zuz.post(zuz.app+'adminNewServer', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&naam='+zuz.urlencode(name)
				+ '&url='+zuz.urlencode(url)+'&space='+space,
				function(resp){
					zuz.toast(resp.message, 6);					
					if(resp.result=="ok"){
						$(".loadingCover .loc").html(zuz.material.ok(50));								
						$(".serverList").prepend('<li class="rel val val'+resp.ID+' fontb size11">'
							+ '<div class="ibl stat col"><div class="sts ibl sts-active" title="Active"></div></div>'
							+ '<div class="ibl nam col">'
								+ '<h2 class="wordwrap lbl fontb cfff size14">'+name+'</h2>'
								+ '<h2 class="wordwrap c999 addr size13 fontn">'+url+'</h2>'
							+ '</div>'
							+ '<div class="ibl added col">'+resp.added+'</div>'
							+ '<div class="ibl disk col"><span class="current">0 Byte of '+resp.disk+'</span><div class="rog rel"><div class="res"></div></div></div>'
							+ '<div class="ibl acts col">'
								+ '<a href="javascript:;" class="editServer size12 fontn noul noulh" '
								+ 'data-title="'+name+'" data-address="'+url+'" '
								+ 'data-space="'+space+'" data-status="active" data-id="'+resp.ID+'">Edit</a>'								
								+ '&nbsp;&#46;&nbsp;'
								+ '<a href="javascript:;" class="rmServer size12 fontn noul noulh" data-id="'+resp.ID+'">Delete</a>'
							+ '</div><div class="abs covr cover'+resp.ID+'"></div></li>');
						$(".que-count").html('('+resp.total+')');
						setTimeout(function(){										
							cover(false);
						}, 2000);						
					}else{
						$(".loadingCover").hide();
					}
				}, function(){
					zuz.toast("We are unable to process request...", 6);
					$(".loadingCover").hide();
				});
			}
		break;
		case "_uptservrnow":
			var ID = $(".server-naam").attr("data-id"),
			name = $(".server-naam").val(),
			url = $(".server-url").val(),
			space = parseInt($(".server-space").val()),
			closed = $(".cover .server-status").is(":checked") ? 'closed' : 'not';			
			if(name==""){
				$(".server-naam").focus();
				ShakeBox();
			}else if(url=="" || zuz.isValidUrl(url)==false){
				$(".server-url").focus();
				ShakeBox();
				zuz.toast("Enter valid server url ending a slash...", 6);
			}else if(space <= 0){
				$(".server-space").focus();
				ShakeBox();
				zuz.toast("Enter server space in GB e.g: 5", 6);
			}else{
				$(".loadingCover").show();
				zuz.post(zuz.app+'adminUpdateServer', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&sid='+ID+'&closed='+closed+'&naam='+zuz.urlencode(name)
				+ '&url='+zuz.urlencode(url)+'&space='+space,
				function(resp){
					zuz.toast(resp.message, 6);					
					if(resp.result=="ok"){
						$(".loadingCover .loc").html(zuz.material.ok(50));								
						$(".serverList .server"+ID+" .nam .lbl").html(name);						
						$(".serverList .server"+ID+" .nam .addr").html(url);
						$(".serverList .server"+ID+" .added").html(resp.added);
						$(".serverList .server"+ID+" .disk .current").html(resp.disk.label);
						$(".serverList .server"+ID+" .disk .rog .res").css("width", resp.disk.percent);
						$(".serverList .server"+ID+" .stat .sts").removeClass("sts-active sts-closed sts-no").addClass(resp.sts);		
						$(".serverList .server"+ID+" .editServer").attr("data-title", name);
						$(".serverList .server"+ID+" .editServer").attr("data-address", url);
						$(".serverList .server"+ID+" .editServer").attr("data-space", space);
						$(".serverList .server"+ID+" .editServer").attr("data-status", resp.status);
						setTimeout(function(){										
							cover(false);
						}, 2000);						
					}else{
						$(".loadingCover").hide();
					}
				}, function(){
					zuz.toast("We are unable to process request...", 6);
					$(".loadingCover").hide();
				});
			}
		break;
	}
});

zuz.addEvent("click", ".uselect", function(e){ 
	zuz.istop(e); 
	$(".uselect").not(this).each(function(){ $(this).hide(); });
});

zuz.addEvent("click", ".uploadbtns ._sftup", function(e){
	zuz.istop(e); $(".uploadbtns .uploadsp").show();
});
zuz.addEvent("click", ".uploadsp .closeupsp", function(){	$(".uploadbtns .uploadsp").hide(); });
zuz.addEvent("click", ".uploadsp .tabs .tab", function(){
	$(".uploadsp .tabs .tab").removeClass("tab-on");
	$(".upSects .upmods").hide();
	$(this).addClass("tab-on");
	$(".upSects .mod-"+$(this).attr("mod")).show();
});
zuz.addEvent("click", ".selectFileFromPC", function(){
	$(".uploadsp .upmods .localFile").click();
});
zuz.addEvent("click", ".saveFromYoutube", function(){
	if($(".up-yt-uri").val()==""){ zuz.toast('Enter valid youtube url', 5); $(".up-yt-uri").focus(); return; }
	var vd = GetYtId($(".up-yt-uri").val());
	if(vd.result=='error'){ zuz.toast('Unable to retrieve youtube id', 5); $(".up-yt-uri").select(); return; }
	//return {result: 'ok', type: type, ID: match[1]};
	var ID = vd.ID, type = vd.type;
	if(type=='video'){
		addTrackToUploadQue('youtube', ID, ID);
	}else if(type=='playlist'){
		$(".emptyQue").hide();
		$(".upload-que").show();
		$(".up-yt-uri").val("");
		$(".uploadbtns .uploadsp").hide();	
		fetchYoutubePlaylist(ID, 'none');
		//addTrackToUploadQue(ID);
	}
});
zuz.addEvent("click", ".saveFromSoundCloud", function(){
	if($(".up-sc-uri").val()==""){ zuz.toast('Enter valid SoundCloud url', 5); $(".up-sc-uri").focus(); return; }
	var uri = $(".up-sc-uri").val();
	if(isSoundCloudUrl(uri)==false){ zuz.toast('Enter a valid SoundCloud Url', 5); $(".up-sc-uri").select(); return; }
	var ID = getSoundCloudID($(".up-sc-uri").val());
	if($("li.que-"+ID).length > 0){ zuz.toast('Requested Track already in que...', 6); $(".up-sc-uri").select(); return; }
	$(".upload-que").append(UploadItem("soundcloud", ID, " barb")).show();	
	$(".emptyQue").hide();
	$(".upload-que").show();
	$(".up-sc-uri").val("");
	$(".uploadbtns .uploadsp").hide();	
	var canAdd = true;
	if(_upload.que.length > 0){
		for(var x = 0; x < _upload.que.length; x++){
			if(_upload.que[x].ID==ID){ canAdd = false; }
		}		
	}
	if(canAdd==true){ _upload.que.push({ ID: ID, type: 'soundcloud', url: uri }); }	
	if(_upload.status==false){ _upload.id++; }
	uploadQue();
});
zuz.addEvent("keyup", ".tagr li.toknr .tokener", function(e){
	if(e.keyCode==13 && $(this).val()!=""){
		var ID = $(this).attr("data-id"),
		tag = $(this).val(), add = true;
		$(".utrack-"+ID+" .track-tags li").each(function(){
			if($(this).attr("data-tag")==tag){
				add = false;
			}
		});
		if(add==true){
			$(".utrack-"+ID+" .track-tags li.toknr").before(tagr(tag)).show();	
		}
		$(this).val('').focus();
	}
});
zuz.addEvent("click", ".uscate", function(e){
	zuz.istop(e);
	$(".uselect").hide();
	$(".ugenres-"+$(this).attr("data-id")).show();
});
zuz.addEvent("click", ".usalbum", function(e){
	zuz.istop(e);
	$(".uselect").hide();
	$(".ualbums-"+$(this).attr("data-id")).show();
});
zuz.addEvent("click", ".ucates li.cat", function(e){
	var that = $(this), ID = that.closest(".uselect").attr("data-id"), count = that.attr("data-count"),
	s = parseInt(count) > 1 ? "s" : "";
	$(".ucate"+ID+" .naam .lab").html(that.attr("data-label"));
	$(".ucate"+ID+" .naam .ctr").html(that.attr("data-count") + " Track"+s);
	$(".ucate"+ID).attr({
		dataid: that.attr("data-id"),
		datacount: that.attr("data-count"),
		datalabel: that.attr("data-label")
	});
	$(".ugenres-"+ID).hide();
});
zuz.addEvent("click", ".create-new-album", function(){
	var msg = '<div class="albumDP rel"><div class="abs ico icon-notes-outline"></div></div>'
		+ '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Album Cover</h2>'
			+ '<input type="file" class="_localalbumdp put">'
		+ '</div>'
		+ '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">New Album Name</h2>'
			+ '<input type="text" class="put size14 fontn cfff newalbum-naam" placeholder="Album Name">'
		+ '</div>';	
	cover(true, getBox('Create Album', msg, true, 'Create', '_cnalbm', true, 'Cancel'), 400);
	$(".cover .box .actionokxcover").removeClass("actionokxcover").addClass("actionokadmin");
	$(".newalbum-naam").focus();		
});
zuz.addEvent("change", ".cover .box ._localalbumdp", function(){
	var iput = $(".cover .box ._localalbumdp");
	if(iput[0].files && iput[0].files[0]){
		var reader = new FileReader();
		reader.onload = function(e){
			$(".cover .box .albumDP").html('<img class="img" src="'+e.target.result+'">');
			zuz.uploadCrop = $(".cover .box .albumDP .img").cropper({
				aspectRatio: 1/1,
				zoomable: true, 
				zoomOnWheel: true,
				cropBoxMovable: true,
				crop: function(e){}
			});
			iput.val("");
		};
		reader.readAsDataURL(iput[0].files[0]);
	}
});
zuz.addEvent("click", ".ualbums li.cat", function(e){
	var that = $(this), ID = that.closest(".uselect").attr("data-id"), count = that.attr("data-count"),
	s = parseInt(count) > 1 ? "s" : "";
	$(".ualbum"+ID+" .thumb").html('<img src="'+that.attr("data-cover")+'" class="bl">');
	$(".ualbum"+ID+" .naam .lab").html(that.attr("data-label"));
	$(".ualbum"+ID+" .naam .ctr").html(that.attr("data-count") + " Track"+s);
	$(".ualbum"+ID).attr({
		dataid: that.attr("data-id"),
		datacount: that.attr("data-count"),
		datalabel: that.attr("data-label")
	});
	$(".ualbums-"+ID).hide();
});

zuz.addEvent("click", ".tagr li .rmTag", function(){ $(this).parent().remove(); });

zuz.addEvent("click", ".save-this-track", function(){
	var OID = $(this).attr("data-id"),
	ID = $(this).attr("dataid"),
	thumb = $(".uhead-"+OID+" .thumb").attr("data-thumb"),
	source = $(this).attr("source"),
	server = $(this).attr("server"),
	space = $(this).attr("disk"),
	album = $(".ualbum"+OID).attr("dataid"),
	cate = $(".ucate"+OID).attr("dataid"),
	title = $(".utrack-"+OID+" .track-title").val(),
	dura = $(".utrack-"+OID+" .track-duration").val(),
	duration = $(".utrack-"+OID+" .track-duration").attr("data-duration"),
	artist = $(".utrack-"+OID+" .track-artist").val(),
	tags = [];
	$(".utrack-"+OID+" .tagr li").each(function(){
		if(zuz.hasAttr($(this).attr("data-tag"))==true){
			tags.push($(this).attr("data-tag"));
		}
	});
	if(thumb=='none' && source=='local'){
		zuz.toast("Select track poster...", 6);
	}else if(album=="-1"){
		zuz.toast("Select track album...", 6);
	}else if(cate=="-1"){
		zuz.toast("Select track genre...", 6);
	}else if(title==""){
		zuz.toast("Enter track title...", 6);
		$(".utrack-"+OID+" .track-title").focus();
	}else if(tags.length == 0 || tags.join()==""){
		zuz.toast("Enter track tags...", 6);
		$(".utrack-"+OID+" .tagr .tokener").focus();
	}else if(duration==""){
		zuz.toast("Enter track duration...", 6);
		$(".utrack-"+OID+" .track-duration").focus();
	}else if(artist==""){
		zuz.toast("Enter track artist...", 6);
		$(".utrack-"+OID+" .track-artist").focus();
	}else{
		$(".utrack-"+OID).slideUp(500);
		$(".uhead-"+OID+" .prog .bar").addClass("barb");
		$("li.que-"+OID+" .info .filest").html("Publishing...");
		zuz.post(zuz.app+'adminPublishTrack', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&server='+server+'&disk='+space+'&source='+source+'&thumb='+thumb+'&sid='+ID+'&album='+album+'&cate='+cate+'&title='+zuz.urlencode(title)+'&duration='+duration+'&artist='+zuz.urlencode(artist)+'&formats='+zuz.audioFormats+'&tags='+tags.join(), function(resp){
			zuz.toast(resp.message, 6);
			if(resp.result=="ok"){
				addTrackCount(album, cate);
				$(".uhead-"+OID+" .prog .bar").css("width", "0px").removeClass("barb").animate({ width: '100%' });
				$(".uhead-"+OID+" .icn-ok").transition({ scale: 1.2 }).transition({ scale: 1 });
				$("li.que-"+OID+" .info .filest").html("Published Successfully.");
			}else{
				$("li.que-"+OID+" .info .filest").html("Publish Failed!");
				$(".uhead-"+OID+" .prog .bar").removeClass("barb");
				$(".utrack-"+OID).slideDown(500);	
			}
		}, function(){
			$(".uhead-"+OID+" .prog .bar").removeClass("barb");
			$(".utrack-"+OID).slideDown(500);
		});
	}
});
zuz.addEvent("click", ".usersList li .acts .userAction", function(e){
	zuz.istop(e);
	$(".userOptions"+$(this).attr("data-id")).show();
});
zuz.addEvent("click", ".userOptions li.action", function(e){
	var that = $(this), uid = that.attr("data-id");
	switch(that.attr("data-mod")){
		case "ban":
			$(".usersList li.val"+uid+" .covr").html('<div class="abs lod">'+zuz.loading(40, 2)+'</div>').show();
			zuz.post(zuz.app+'adminUpdateUserStatus', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&user='+uid+'&status='+that.attr("data-current"),
			function(resp){
				zuz.toast(resp.message, 5);
				$(".usersList li.val"+uid+" .covr").hide();				
				if(resp.result=="ok"){
					that.attr("data-current", resp.current);
					that.html(resp.label);
					$(".usersList li.val"+uid+" .sts").removeClass("sts-banned sts-active").addClass("sts-"+resp.cls);
				}
			}, function(){
				$(".usersList li.val"+uid+" .covr").hide();
				zuz.toast("Unable to process request...", 5);
			});
		break;	
		case "utype":
			var dtype = that.attr("data-type"); 
			$(".subOpt"+uid+" .action").removeClass("on"); that.addClass("on");
			$(".usersList li.val"+uid+" .covr").html('<div class="abs lod">'+zuz.loading(40, 2)+'</div>').show();
			zuz.post(zuz.app+'adminUpdateUserType', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&user='+uid+'&type='+that.attr("data-token"),
			function(resp){
				zuz.toast(resp.message, 5);
				$(".usersList li.val"+uid+" .covr").hide();				
				if(resp.result=="ok"){
					if(dtype=="user"){
						$(".usersList li.val"+uid+" .uverify").html("").transition({ scale: 1.2 }).transition({ scale: 1 });
					}else if(dtype=="admin"){
						$(".usersList li.val"+uid+" .uverify").html('<div class="ic icon-verified_user" title="Admin"></div>').transition({ scale: 1.2 }).transition({ scale: 1 });
					}else if(dtype=="moderator"){
						$(".usersList li.val"+uid+" .uverify").html('<div class="ic icon-security" title="Moderator"></div>').transition({ scale: 1.2 }).transition({ scale: 1 });
					}			
				}
			}, function(){
				$(".usersList li.val"+uid+" .covr").hide();
				zuz.toast("Unable to process request...", 5);
			});
		break;
	}	
});
zuz.addEvent("click", ".albumList li .editBtn", function(){
	var tht = $(this),
	msg = '<div class="albumDP rel"><img class="img" src="'+tht.attr("data-cover")+'"></div>'
		+ '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Album Cover</h2>'
			+ '<input type="file" class="_localalbumdp put">'
		+ '</div>'
		+ '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Album Name</h2>'
			+ '<input type="text" class="put size14 fontn cfff newalbum-naam" data-id="'+tht.attr("data-id")+'" data-title="'+tht.attr("data-title")+'" placeholder="Album Name" value="'+tht.attr("data-title")+'">'
		+ '</div>';	
	cover(true, getBox('Edit Album', msg, true, 'Update', '_easvalbm', true, 'Cancel'), 400);
	$(".cover .box .actionokxcover").removeClass("actionokxcover").addClass("actionokadmin");
	zuz.uploadCrop = $(".cover .box .albumDP .img").cropper({
		aspectRatio: 1/1,
		zoomable: true, 
		zoomOnWheel: true,
		cropBoxMovable: true,
		crop: function(e){}
	});
});
zuz.addEvent("click", ".albumList li .rmAlbum", function(){
	var tht = $(this), ID = $(this).attr("data-id");
	if(confirm("Are you sure you want to remove this Album?\nAll tracks in this album will be removed as well!")){
		$(".album"+ID).hide();
		zuz.post(zuz.app+'adminRemoveAlbum', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&aid='+ID,
		function(resp){
			zuz.toast(resp.message, 5);
			if(resp.result=="ok"){
				$(".album"+ID).remove();
			}else{
				$(".album"+ID).show();
			}
		}, function(){
			$(".album"+ID).show();
			zuz.toast("Unable to process request...", 5);
		});	
	}	
});
zuz.addEvent("click", ".trackList li .editBtn", function(){
	var tht = $(this);
	cover(true, getBox('Edit Album', editItem(tht), true, 'Update', '_easvtrack', true, 'Cancel'), 400);
	loadAlbums();
	loadGenres();
	$(".editItem .uSelectAlbums li").each(function(){
		if($(this).attr("data-id")==tht.attr("data-album")){
			var cnt = parseInt($(this).attr("data-count")),
			countLabel = cnt + ' Track';
			countLabel += cnt > 1 ? 's' : '';
			$(".editItem .uAlbumCurrent .thumb").html('<img src="'+$(this).attr("data-cover")+'" class="bl">');
			$(".editItem .uAlbumCurrent .naam .lab").html($(this).attr("data-label"));
			$(".editItem .uAlbumCurrent .naam .ctr").html(countLabel);
			$(".editItem .uAlbumCurrent").attr({
				dataid: $(this).attr("data-id"),
				datacount: $(this).attr("data-count"),
				datalabel: $(this).attr("data-label")
			});
		}
	});
	$(".editItem .uSelectGenres li").each(function(){
		if($(this).attr("data-id")==tht.attr("data-genre")){
			var cnt = parseInt($(this).attr("data-count")),
			countLabel = cnt + ' Track';
			countLabel += cnt > 1 ? 's' : '';
			$(".editItem .uCateCurrent .thumb").html('<img src="'+zuz.base+'ui/no-image.png" class="bl">');
			$(".editItem .uCateCurrent .naam .lab").html($(this).attr("data-label"));
			$(".editItem .uCateCurrent .naam .ctr").html(countLabel);
			$(".editItem .uCateCurrent").attr({
				dataid: $(this).attr("data-id"),
				datacount: $(this).attr("data-count"),
				datalabel: $(this).attr("data-label")
			});
		}
	});
	var tags = tht.attr("data-tags").split(",");
	for(var i = 0; i < tags.length; i++){
		if(tags[i]!=""){
			$(".editItem .tagr .toknr").before('<li class="rel" data-tag="'+tags[i]+'">'+tags[i]+'<button class="rmTag abs">×</button></li>');
		}
	}
	$(".cover .box .actionokxcover").removeClass("actionokxcover").addClass("actionokadmin");
	zuz.uploadCrop = $(".cover .box .trackDP img").cropper({
		aspectRatio: 1/1,
		zoomable: true, 
		zoomOnWheel: true,
		cropBoxMovable: true,
		crop: function(e){}
	});
});
zuz.addEvent("change", ".cover ._selectTrackPhoto", function(){
	var iput = $(".cover .box ._selectTrackPhoto");
	if(iput[0].files && iput[0].files[0]){
		var reader = new FileReader();
		reader.onload = function(e){
			$(".cover .trackDP").html('<img class="img" src="'+e.target.result+'">');
			zuz.uploadCrop = $(".cover .trackDP .img").cropper({
				aspectRatio: 1/1,
				zoomable: true, 
				zoomOnWheel: true,
				cropBoxMovable: true,
				crop: function(e){}
			});
			iput.val("");
			$(".editItem").attr("data-local", "yes");
		};
		reader.readAsDataURL(iput[0].files[0]);
	}
});
zuz.addEvent("click", ".trackList li .rmTrack", function(){
	if(confirm("Are you sure you want to remove this track?\nThis can't be undone and track will be removed permanently!")){
		var ID = $(this).attr("data-id");
		$(".trackList .atrack"+ID).hide();
		zuz.post(zuz.app+'adminRemoveTrack', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&tid='+ID,
		function(resp){
			zuz.toast(resp.message, 5);
			if(resp.result=="ok"){
				$(".trackList .atrack"+ID).remove();
			}else{
				$(".trackList .atrack"+ID).show();
			}
		}, function(){
			$(".trackList .atrack"+ID).show();
			zuz.toast("Unable to process request...", 5);
		});		
	}
});
zuz.addEvent("click", ".genreList li .editBtn", function(){
	var tht = $(this),
	msg = '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Genre Label</h2>'
			+ '<input type="text" class="put size14 fontn cfff genre-naam" data-id="'+tht.attr("data-id")+'" placeholder="Genre Label" value="'+tht.attr("data-label")+'">'
		+ '</div>'
		+ '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Genre Slug</h2>'
			+ '<input type="text" class="put size14 fontn cfff genre-slug" placeholder="Genre Slug" value="'+tht.attr("data-slug")+'">'
		+ '</div>';			
	cover(true, getBox('Edit Genre', msg, true, 'Update', '_easvgenre', true, 'Cancel'), 400);
	$(".cover .box .actionokxcover").removeClass("actionokxcover").addClass("actionokadmin");
	$(".cover .genre-naam").select();
});
zuz.addEvent("click", ".genreList li .rmGenre", function(){
	if(confirm("Are you sure you want to remove this Genre?\nThis can't be undone!")){
		var ID = $(this).attr("data-id");
		$(".genreList .genre"+ID).hide();
		zuz.post(zuz.app+'adminRemoveGenre', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&gid='+ID,
		function(resp){
			zuz.toast(resp.message, 5);
			if(resp.result=="ok"){
				$(".que-count").html('('+resp.total+')');
				$(".genreList .genre"+ID).remove();
			}else{
				$(".genreList .genre"+ID).show();
			}
		}, function(){
			$(".genreList .genre"+ID).show();
			zuz.toast("Unable to process request...", 5);
		});		
	}
});
zuz.addEvent("click", ".creatNewGenre", function(){
	var tht = $(this),
	msg = '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Genre Label</h2>'
			+ '<input type="text" class="put size14 fontn cfff genre-naam" placeholder="Genre Label">'
		+ '</div>';			
	cover(true, getBox('New Genre', msg, true, 'Save', '_cngenrnow', true, 'Cancel'), 400);
	$(".cover .box .actionokxcover").removeClass("actionokxcover").addClass("actionokadmin");
	$(".cover .genre-naam").focus();;
});
zuz.addEvent("click", ".addNewServer", function(){
	var tht = $(this),
	msg = '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Server Name</h2>'
			+ '<input type="text" class="put size14 fontn cfff server-naam" placeholder="Server Label">'
		+ '</div>'
		+ '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Server Address</h2>'
			+ '<h2 class="lbl size12 fontn slg c999">e.g: https://youserver.com/</h2>'
			+ '<h2 class="lbl size12 fontn slg c999">Url should end with slash</h2>'
			+ '<input type="text" class="put size14 fontn cfff server-url" placeholder="Server URL">'
		+ '</div>'
		+ '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Disk Space (GB)</h2>'
			+ '<input type="number" min="1" class="put size14 fontn cfff server-space" placeholder="10" value="10">'
		+ '</div>';			
	cover(true, getBox('New Genre', msg, true, 'Save', '_anservrnow', true, 'Cancel'), 400);
	$(".cover .box .actionokxcover").removeClass("actionokxcover").addClass("actionokadmin");
	$(".cover .server-naam").focus();;
});
zuz.addEvent("click", ".serverList li .editServer", function(){
	var tht = $(this), checked = tht.attr("data-status")=="closed" ? ' checked' : '',
	msg = '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Server Name</h2>'
			+ '<input type="text" class="put size14 fontn cfff server-naam" data-id="'+tht.attr("data-id")+'" placeholder="Server Label" value="'+tht.attr("data-title")+'">'
		+ '</div>'
		+ '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Server Address</h2>'
			+ '<h2 class="lbl size12 fontn slg c999">e.g: https://youserver.com/</h2>'
			+ '<h2 class="lbl size12 fontn slg c999">Url should end with slash</h2>'
			+ '<input type="text" class="put size14 fontn cfff server-url" placeholder="Server URL" value="'+tht.attr("data-address")+'">'
		+ '</div>'
		+ '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Disk Space (GB)</h2>'
			+ '<input type="number" min="1" class="put size14 fontn cfff server-space" placeholder="10" value="'+tht.attr("data-space")+'">'
		+ '</div>'
		+ '<div class="iput size14 fontn">'
			+ '<h2 class="lbl size14 fontb cfff">Server Status</h2>'
			+ '<h2 class="lbl size12 fontn slg c999">By marking server as closed; It will be not available for upload and but its Tracks will be accessible.</h2>'
			+ '<label class="cfff put bl"><input type="checkbox" class="checkbox server-status" value="yes"'+checked+'> Closed</label>'
		+ '</div>';			
	cover(true, getBox('Edit Server', msg, true, 'Save', '_uptservrnow', true, 'Cancel'), 400);
	$(".cover .box .actionokxcover").removeClass("actionokxcover").addClass("actionokadmin");
});
zuz.addEvent("click", ".serverList li .rmServer", function(){
	if(confirm("Are you sure you want to remove this Server?\nAll tracks on this server will be lost\nThis can't be undone!")){
		var ID = $(this).attr("data-id");
		$(".serverList .server"+ID+" .covr").html('<div class="abs lod">'+zuz.loadingC(40, 2)+'</div>').show();
		zuz.post(zuz.app+'adminRemoveServer', 'uid='+zuz.me.ID+'&token='+zuz.me.token+'&sid='+ID,
		function(resp){
			zuz.toast(resp.message, 5);
			if(resp.result=="ok"){ 
				$(".que-count").html('('+resp.total+')');
				$(".serverList .server"+ID).remove();
			}else{
				$(".serverList .server"+ID+" .covr").hide();
			}
		}, function(){
			$(".serverList .server"+ID+" .covr").hide();
			zuz.toast("Unable to process request...", 5);
		});		
	}
});
zuz.addEvent("click", ".saveSiteCog", function(){
	var mustlogin = $(".cog-mustlogin").is(":checked")===true ? 'yes' : 'no',
	title = $(".cog-title").val(),
	googleGA = $(".cog-google-ga").val(),
	download = $(".cog-download").is(":checked")===true ? 'yes' : 'no',
	tagline = $(".cog-tagline").val(),
	formats = [], live = $(".cog-live").is(":checked") ? 'no' : 'yes';
	if($(".cog-format128").is(":checked")===true){ formats.push(128); }
	if($(".cog-format192").is(":checked")===true){ formats.push(192); }
	if($(".cog-format256").is(":checked")===true){ formats.push(256); }
	if($(".cog-format320").is(":checked")===true){ formats.push(320); }
	if(title==""){
		zuz.toast("Enter Title...", 5);
		$(".cog-title").focus();
	}else if(tagline==""){
		zuz.toast("Enter Tagline...", 5);
		$(".cog-tagline").focus();
	}else if(formats.length == 0){
		zuz.toast("Select at-least one audio format type...", 5);
	}else{
		$(".cogBox .cvr").html('<div class="abs lod">'+zuz.loading(50, 2)+'</div>').show();
		zuz.post(zuz.app+'adminUpdateCog', 'uid='+zuz.me.ID+'&token='+zuz.me.token
			+'&live='+live+'&mustlogin='+mustlogin+'&title='+zuz.urlencode(title)+'&slogan='+zuz.urlencode(tagline)+'&formats='+formats.join()
			+'&googlega='+zuz.urlencode(googleGA)+'&download='+download,
		function(resp){
			zuz.toast(resp.message, 5);
			$(".cogBox .cvr").hide();				
		}, function(){
			$(".cogBox .cvr").hide();
			zuz.toast("Unable to process request...", 5);
		});	
	}	
});

$(document).ready(function(){
	if($(".uploadsp .upmods .localFile").length > 0){
		$(".uploadsp .upmods .localFile").unbind("change").on("change", function(){
			var _files = $(".uploadsp .upmods .localFile").prop('files');
			if(_files && _files.length > 0){
				for(var n = 0; n < _files.length; n++){
					addTrackToUploadQue('local', zuz.randit(123456789,1234567890), _files[n]);	
				}
				$(".uploadsp .upmods .localFile").attr("value", "").val("");
				$(".uploadsp .closeupsp").click();
			}
		});				
	}
});
zuz.addEvent("click", ".upbox .que li .head .thumb .chooseLocalPhoto", function(){
	$(".upbox .que li .head .thumb .imglodr-"+$(this).attr("data-id")).click();
});
zuz.addEvent("click", ".__resetApiKey", function(){
	$(".cogBox .cvr").html('<div class="abs lod">'+zuz.loading(30, 2)+'</div>').show();
	zuz.post(zuz.app+'adminResetKey', 'uid='+zuz.me.ID+'&token='+zuz.me.token,
	function(resp){		
		zuz.toast(resp.message, 5);
		$(".cogBox .cvr").hide();				
		if(resp.result=="ok"){
			$(".__apikey").val(resp.key);
		}
	}, function(){
		$(".cogBox .cvr").hide();
		zuz.toast("Unable to process request...", 5);
	});
});