<?php
class father{

	static $DB;
	public function db(){
		if(!isset(self::$DB)){
			self::$DB = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
			if(self::$DB->connect_error){
				die("Error in establishing Database Connection..."); exit;	
			}
			self::$DB->set_charset("utf8");
		}
	}	
	
	public function cookie($name, $value, $time){
		$time = $time > 0 ? time() + ($time * 3600) : time() - 86400 * 7;
		setcookie($name, $value, $time, '/', cookieurl);	
	}
	
	public function json($array, $decode = false){
		if($decode==true){
			return json_decode(json_encode($array));
		}else{
			return json_encode($array, 128);
		}
	}
	
	public function _CURL($url, $header = true, $timeout = 3600){
		$ch = curl_init($url);		
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		if($header==true) curl_setopt($ch, CURLOPT_HEADER, TRUE); // We'll parse redirect url from header.
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE); // We want to just get redirect url but not to follow it.
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
		curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
		return curl_exec($ch);
	}
	
	public function isEmail($email){
		return !filter_var($email, FILTER_VALIDATE_EMAIL) === false ? true : false;
	}
	
	public function realescape($str){
		return addslashes($str);
	}
	
	public function isMobile(){
		$useragent=$_SERVER['HTTP_USER_AGENT'];
		return preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',substr($useragent,0,4));
	}
	
	public function clean($str){
		$f = array("`", "'", "^", "/", "\/", "|", "?", "<", ">", "$", "#", "@", "!", "=", "+", "~");
		$r = array("", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "");
		return str_replace($f, $r, $str);
	}
	
	public function randit($digits){
		srand ((double) microtime() * 10000000);
		$input = array ("A", "B", "C", "D", "E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z");
		$random_generator="";
		for($i=1;$i<$digits+1;$i++){ 
			if(rand(1,2) == 1){
				$rand_index = array_rand($input);
				$random_generator .=$input[$rand_index];
			}else{
				$random_generator .=rand(1,10);
			}
		}
		return $random_generator;
	}
	
	public function myip(){
		if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
		{    $ip=$_SERVER['HTTP_CLIENT_IP'];    }
		elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
		{    $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];    }
		else
		{    $ip=$_SERVER['REMOTE_ADDR'];    }
		return $ip;
	}
	
	public  function safe_b64encode($string) {
        $data = base64_encode($string);
        $data = str_replace(array('+','/','='),array('-','_',''),$data);
        return $data;
	}
	 
	public function safe_b64decode($string) {
			$data = str_replace(array('-','_'),array('+','/'),$string);
			$mod4 = strlen($data) % 4;
			if ($mod4) {
				$data .= substr('====', $mod4);
			}
			return base64_decode($data);
	}

	public  function encode($value, $key = "none"){ 
			if(!$value){return false;}
			$text = $value;
			$ENCRYPT_KEY = $key == "none" ? ENCRYPTION_KEY : $key;
			$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
			$iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
			$crypttext = mcrypt_encrypt(MCRYPT_RIJNDAEL_256, md5($ENCRYPT_KEY), $text, MCRYPT_MODE_ECB, $iv);
			return trim($this->safe_b64encode($crypttext)); 
	}
	 
	public function decode($value, $key = "none"){
			if(!$value){return false;}
			$ENCRYPT_KEY = $key == "none" ? ENCRYPTION_KEY : $key;
			$crypttext = $this->safe_b64decode($value); 
			$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
			$iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
			$decrypttext = mcrypt_decrypt(MCRYPT_RIJNDAEL_256, md5($ENCRYPT_KEY), $crypttext, MCRYPT_MODE_ECB, $iv);
			return trim($decrypttext);
	}
	
	public function slug($string){
		$string = str_replace("&", "and", $string);
	    $slug = preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
	    $slug=  strtolower($slug);
	    $dash = true;
	    while(substr($slug, -1) == '-'){
		   $slug = rtrim($slug, '-');
	    }	
	    $slug = empty($slug) ? $this->url_slug($string, array('lowercase' => true)) : $slug;
	    $slug = str_replace("----", "-", $slug);
	    $slug = str_replace("---", "-", $slug);
	    $slug = str_replace("--", "-", $slug);
	    return $slug;
	}

	public function url_slug($str, $options = array()) {
		$str = mb_convert_encoding((string)$str, 'UTF-8', mb_list_encodings());
		$defaults = array(
			'delimiter' => '-',
			'limit' => null,
			'lowercase' => true,
			'replacements' => array(),
			'transliterate' => false,
		);
		$options = array_merge($defaults, $options);
		$char_map = array(
			// Latin
			'À' => 'A', 'Á' => 'A', 'Â' => 'A', 'Ã' => 'A', 'Ä' => 'A', 'Å' => 'A', 'Æ' => 'AE', 'Ç' => 'C', 
			'È' => 'E', 'É' => 'E', 'Ê' => 'E', 'Ë' => 'E', 'Ì' => 'I', 'Í' => 'I', 'Î' => 'I', 'Ï' => 'I', 
			'Ð' => 'D', 'Ñ' => 'N', 'Ò' => 'O', 'Ó' => 'O', 'Ô' => 'O', 'Õ' => 'O', 'Ö' => 'O', 'O' => 'O', 
			'Ø' => 'O', 'Ù' => 'U', 'Ú' => 'U', 'Û' => 'U', 'Ü' => 'U', 'U' => 'U', 'Ý' => 'Y', 'Þ' => 'TH', 
			'ß' => 'ss', 
			'à' => 'a', 'á' => 'a', 'â' => 'a', 'ã' => 'a', 'ä' => 'a', 'å' => 'a', 'æ' => 'ae', 'ç' => 'c', 
			'è' => 'e', 'é' => 'e', 'ê' => 'e', 'ë' => 'e', 'ì' => 'i', 'í' => 'i', 'î' => 'i', 'ï' => 'i', 
			'ð' => 'd', 'ñ' => 'n', 'ò' => 'o', 'ó' => 'o', 'ô' => 'o', 'õ' => 'o', 'ö' => 'o', 'o' => 'o', 
			'ø' => 'o', 'ù' => 'u', 'ú' => 'u', 'û' => 'u', 'ü' => 'u', 'u' => 'u', 'ý' => 'y', 'þ' => 'th', 
			'ÿ' => 'y',
			// Latin symbols
			'©' => '(c)',
			// Greek
			'?' => 'A', '?' => 'B', 'G' => 'G', '?' => 'D', '?' => 'E', '?' => 'Z', '?' => 'H', 'T' => '8',
			'?' => 'I', '?' => 'K', '?' => 'L', '?' => 'M', '?' => 'N', '?' => '3', '?' => 'O', '?' => 'P',
			'?' => 'R', 'S' => 'S', '?' => 'T', '?' => 'Y', 'F' => 'F', '?' => 'X', '?' => 'PS', 'O' => 'W',
			'?' => 'A', '?' => 'E', '?' => 'I', '?' => 'O', '?' => 'Y', '?' => 'H', '?' => 'W', '?' => 'I',
			'?' => 'Y',
			'a' => 'a', 'ß' => 'b', '?' => 'g', 'd' => 'd', 'e' => 'e', '?' => 'z', '?' => 'h', '?' => '8',
			'?' => 'i', '?' => 'k', '?' => 'l', 'µ' => 'm', '?' => 'n', '?' => '3', '?' => 'o', 'p' => 'p',
			'?' => 'r', 's' => 's', 't' => 't', '?' => 'y', 'f' => 'f', '?' => 'x', '?' => 'ps', '?' => 'w',
			'?' => 'a', '?' => 'e', '?' => 'i', '?' => 'o', '?' => 'y', '?' => 'h', '?' => 'w', '?' => 's',
			'?' => 'i', '?' => 'y', '?' => 'y', '?' => 'i',
			// Turkish
			'S' => 'S', 'I' => 'I', 'Ç' => 'C', 'Ü' => 'U', 'Ö' => 'O', 'G' => 'G',
			's' => 's', 'i' => 'i', 'ç' => 'c', 'ü' => 'u', 'ö' => 'o', 'g' => 'g', 
			// Russian
			'?' => 'A', '?' => 'B', '?' => 'V', '?' => 'G', '?' => 'D', '?' => 'E', '?' => 'Yo', '?' => 'Zh',
			'?' => 'Z', '?' => 'I', '?' => 'J', '?' => 'K', '?' => 'L', '?' => 'M', '?' => 'N', '?' => 'O',
			'?' => 'P', '?' => 'R', '?' => 'S', '?' => 'T', '?' => 'U', '?' => 'F', '?' => 'H', '?' => 'C',
			'?' => 'Ch', '?' => 'Sh', '?' => 'Sh', '?' => '', '?' => 'Y', '?' => '', '?' => 'E', '?' => 'Yu',
			'?' => 'Ya',
			'?' => 'a', '?' => 'b', '?' => 'v', '?' => 'g', '?' => 'd', '?' => 'e', '?' => 'yo', '?' => 'zh',
			'?' => 'z', '?' => 'i', '?' => 'j', '?' => 'k', '?' => 'l', '?' => 'm', '?' => 'n', '?' => 'o',
			'?' => 'p', '?' => 'r', '?' => 's', '?' => 't', '?' => 'u', '?' => 'f', '?' => 'h', '?' => 'c',
			'?' => 'ch', '?' => 'sh', '?' => 'sh', '?' => '', '?' => 'y', '?' => '', '?' => 'e', '?' => 'yu',
			'?' => 'ya',
			// Ukrainian
			'?' => 'Ye', '?' => 'I', '?' => 'Yi', '?' => 'G',
			'?' => 'ye', '?' => 'i', '?' => 'yi', '?' => 'g',
			// Czech
			'C' => 'C', 'D' => 'D', 'E' => 'E', 'N' => 'N', 'R' => 'R', 'Š' => 'S', 'T' => 'T', 'U' => 'U', 
			'Ž' => 'Z', 
			'c' => 'c', 'd' => 'd', 'e' => 'e', 'n' => 'n', 'r' => 'r', 'š' => 's', 't' => 't', 'u' => 'u',
			'ž' => 'z', 
			// Polish
			'A' => 'A', 'C' => 'C', 'E' => 'e', 'L' => 'L', 'N' => 'N', 'Ó' => 'o', 'S' => 'S', 'Z' => 'Z', 
			'Z' => 'Z', 
			'a' => 'a', 'c' => 'c', 'e' => 'e', 'l' => 'l', 'n' => 'n', 'ó' => 'o', 's' => 's', 'z' => 'z',
			'z' => 'z',
			// Latvian
			'A' => 'A', 'C' => 'C', 'E' => 'E', 'G' => 'G', 'I' => 'i', 'K' => 'k', 'L' => 'L', 'N' => 'N', 
			'Š' => 'S', 'U' => 'u', 'Ž' => 'Z',
			'a' => 'a', 'c' => 'c', 'e' => 'e', 'g' => 'g', 'i' => 'i', 'k' => 'k', 'l' => 'l', 'n' => 'n',
			'š' => 's', 'u' => 'u', 'ž' => 'z'
		);
		$str = preg_replace(array_keys($options['replacements']), $options['replacements'], $str);
		if ($options['transliterate']) {
			$str = str_replace(array_keys($char_map), $char_map, $str);
		}
		$str = preg_replace('/[^\p{L}\p{Nd}]+/u', $options['delimiter'], $str);
		$str = preg_replace('/(' . preg_quote($options['delimiter'], '/') . '){2,}/', '$1', $str);
		$str = mb_substr($str, 0, ($options['limit'] ? $options['limit'] : mb_strlen($str, 'UTF-8')), 'UTF-8');
		$str = trim($str, $options['delimiter']);
		return $options['lowercase'] ? mb_strtolower($str, 'UTF-8') : $str;
	}
	
	public function Geo($MIP = 'none'){		
		$ip = $MIP != 'none' ? $MIP : $this->myip();				
		return $this->_CURL('https://api.zuz.host/geo/'.$ip, false);		
	}
	
	public function select($query, $values, $types){
		$this->db(); self::$DB->set_charset("utf8");
		$q = self::$DB->prepare($query);
		$q->bind_param($types, ...$values);
		$q->execute();
		$result = $q->get_result();		
		if($result->num_rows>0){
			$arr = array();
			$farr = "";
			$n = 0;
			while($fo = $result->fetch_array()):
				if($n==0){ $farr = $fo; }
				$arr[] = $fo;
				$n++;
			endwhile;
			return $this->json(array(
				'result' => 'ok',
				'count' => $result->num_rows,
				'row' => $farr,
				'fetch' => $arr			
			), true);
		}else{
			return $this->json(array(
				'result' => 'no',
				'count' => 0
			), true);
		}
	}
	
	public function insert($query, $values, $types){
		$this->db(); self::$DB->set_charset("utf8");		
		$q = self::$DB->prepare($query);		
		$_bnd = $q->bind_param($types, ...$values);		
		if(!$q){
			return $this->json(array(
				'result' => 'failed'
			), true);
		}
		if($q->execute()){
			return $this->json(array(
				'result' => 'ok',
				'ID' => $q->insert_id
			), true);
		}else{
			return $this->json(array(
				'result' => 'failed',
				'error' => self::$DB->errno
			), true);
		}
	}
	
	public function update($query, $value, $types){
		$this->db(); self::$DB->set_charset("utf8");
		$q = self::$DB->prepare($query);
		$q->bind_param($types, ...$value);
		if($q->execute()){
			return $this->json(array('result' => 'ok'), true);
		}else{
			return $this->json(array('result' => 'failed', 'error' => $q->errno), true);
		}
	}
	
	public function SendMail($from, $to, $subject, $message, $debug = false){		
		require_once(__DIR__ .'/phpmailer/PHPMailerAutoload.php');
		$from_name = SITE_NAME;
		$mail = new PHPMailer;
		$mail->IsSMTP();
		if($debug==true){
			$mail->SMTPDebug = 2;
			$mail->Debugoutput = 'html';
		}
		$mail->Host = MAIL_HOST;
		$mail->Port = MAIL_PORT;
		$mail->SMTPAuth = true;
		$mail->Username = $from['user'];
		$mail->Password = $from['pass'];
		$mail->SMTPDebug = false;
		$mail->SMTPSecure = 'tls';
		$mail->SMTPOptions = array(
			'ssl' => array(
				'verify_peer' => false,
				'verify_peer_name' => false,
				'allow_self_signed' => true
			)
		);
		$mail->From = $from['user'];
		$mail->FromName = $from['name'];
		$mail->AddAddress($to['mail'], $to['name']);
		$mail->IsHTML(true);
		$mail->Subject = $subject;
		$mail->Body = $message;
		$mail->Send();
	}
	
	public function getMail($subject, $message){
		$_mail = '<div style="margin:0 auto;width:520px;font-family:segoe ui regular, sans-serif, arial, tahoma;font-size:16px;position:relative;">
			<div style="border: 1px #d6d6d6 solid;border-radius: 3px;padding: 40px;color:#333;">
				<a href="'.baseurl.'?f=mail" style="text-decoration:none;display:block;margin-bottom:50px;"><img src="'.baseurl.'ui/logo-mail.png" style="display:block;margin:0 auto;height:50px;outline:none;"></a>
				'.$message.'							
			</div>
			<div style="padding:10px 0px;position:relative;color:#999;font-size:12px;width:100%;box-sizing:border-box;">
				'.MAIL_FOOTER.' &mdash; &copy; '.date("Y").' '.SITE_NAME.'
			</div>				
		</div>';
		return $_mail;
	}
	
	public function pagination($total, $limit, $start, $currentpage, $linkfirst, $prevlink, $prev, $next, $nextlink, $linklast, $link_i, $pagetitle = ''){
		$return = '';
		if($start==0){ $start = 1; }
		$totalpages = ceil($total/$limit);
			if(!($currentpage<=1)){					
				$return .= '<li class="nd"><a href="'.$linkfirst.'" title="'.$pagetitle.'" class="withpstate ibl noul btn fontb size14 anim" >First</a></li>';
			}else{
				$return .= '<li class="nd"><div class="ibl noul btn no-select fontb size14">First</div></li>';	
			}
			
			if(!($currentpage<=1)){					
				$return .= '<li><a href="'.$prevlink.'" title="'.$pagetitle.' - Page '.$prev.'" class="withpstate ibl noul btn fontb size14 anim">Prev</a></li>';
			}else{
				$return .= '<li><div class="ibl noul btn size14 fontb">Prev</div></li>';
			}
		
			$range = 3;
			if($currentpage<$range){
				$begin = 1;	
			}else{
				$begin = $currentpage-2;
			}	
			if(($begin+$range)<=$totalpages){
				$end = $begin+$range;	
			}else{
				$begin = $totalpages-$range;
				$end = $totalpages;
			}
			if($begin<=0){		$begin = 1;	}
			
			for($i=$begin;$i<=$end;$i++){										
				if($i!=$currentpage){							
					$return .= '<li class="nd"><a href="'.$link_i.$i.'" title="'.$pagetitle.' - Page '.$i.'" class="withpstate ibl noul btn fontb size14 anim">'.$i.'</a></li>';
				}else{							
					$return .= '<li class="nd ndi"><div class="ibl noul on btn btni size14 fontb">'.$i.'</div></li>';
				}															
			}
				
			if(!($start >= $total-$limit)){
				$return .= '<li><a href="'.$nextlink.'" title="'.$pagetitle.' - Page '.$next.'" class="withpstate ibl noul btn fontb size14 anim">Next</a></li>';
			}else{
				$return .= '<li><div class="ibl noul btn size14 fontb">Next</div></li>';
			}
						
						
			if($currentpage!=$totalpages){
				$return .= '<li class="nd"><a href="'.$linklast.'" title="'.$pagetitle.' - Page '.$totalpages.'" class="withpstate ibl noul btn size14 fontb anim">Last</a></li>';
			}else{
				$return .= '<li class="nd"><div class="ibl noul btn size14 fontb">Last</div></li>';	
			}			
			
			return $return;
	}
	
	public function getCombinations($array){	
		$length = count($array);
		$combocount=pow(2,$length);
		for ($i = 0;$i<=$combocount;$i++){
			$binary=$this->decextbin($i,$length);
			$combination='';
			for($j=0;$j<$length;$j++)
			{
				if($binary[$j]=="1")
					$combination.=$array[$j].' ';
			}
			$combinationsarray[]=$combination;			
		}
		return array_reverse($combinationsarray);
	}

	public function decextbin($decimalnumber,$bit){
		$binarynumber = '';
		$maxval = 1;
		$sumval = 1;
		for($i=1;$i< $bit;$i++)
		{
			$maxval = $maxval * 2;
			$sumval = $sumval + $maxval;
		}
	 
		if ($sumval < $decimalnumber) return 'ERROR - Not enough bits to display this figure in binary.';
		for($bitvalue=$maxval;$bitvalue>=1;$bitvalue=$bitvalue/2)
		{
			if (($decimalnumber/$bitvalue) >= 1) $thisbit = 1; else $thisbit = 0;
			if ($thisbit == 1) $decimalnumber = $decimalnumber - $bitvalue;
		$binarynumber .= $thisbit;
		}
		return $binarynumber;
	}
	
	public function timeAgo($time_ago, $number_only = false){
		$time_ago = is_numeric($time_ago) ? $time_ago : strtotime($time_ago);
		$cur_time   = time();
		$time_elapsed   = $cur_time - $time_ago;
		$seconds    = $time_elapsed ;
		$minutes    = round($time_elapsed / 60 );
		$hours      = round($time_elapsed / 3600);
		$days       = round($time_elapsed / 86400 );
		$weeks      = round($time_elapsed / 604800);
		$months     = round($time_elapsed / 2600640 );
		$years      = round($time_elapsed / 31207680 );
		
		if($number_only==true){
			if($seconds <= 60){
				return $this->json(array('time' => $seconds, 'lbl' => $seconds < 10 ? 'sec' : 'secs'), true);
			}
			if($minutes <= 60){
				return $this->json(array('time' => $minutes, 'lbl' => $minutes < 10 ? 'mint' : 'mints'), true);
			}
			return 'in a sec';
		}
		
		// Seconds
		if($seconds <= 60){
			return "just now";
		}
		//Minutes
		else if($minutes <=60){
			if($minutes==1){
				return "one minute ago";
			}
			else{
				return "$minutes minutes ago";
			}
		}
		//Hours
		else if($hours <=24){
			if($hours==1){
				return "an hour ago";
			}else{
				return "$hours hrs ago";
			}
		}
		//Days
		else if($days <= 7){
			if($days==1){
				return "yesterday";
			}else{
				return "$days days ago";
			}
		}
		//Weeks
		else if($weeks <= 4.3){
			if($weeks==1){
				return "a week ago";
			}else{
				return "$weeks weeks ago";
			}
		}
		//Months
		else if($months <=12){
			if($months==1){
				return "a month ago";
			}else{
				return "$months months ago";
			}
		}
		//Years
		else{
			if($years==1){
				return "one year ago";
			}else{
				return "$years years ago";
			}
		}
	}
	
	public function formatSize($size, $precision = 2){
		$base = log($size, 1024);
		$suffixes = array('', 'Kb', 'MB', 'GB', 'TB');   

		return round(pow(1024, $base - floor($base)), $precision) .' '. $suffixes[floor($base)];
	}
	
}
?>