<?php ob_start(ob_gzhandler); require(__DIR__ . "/includes/config.php"); header("Content-Type: application/json");
if(isset($_GET['action'])){
	switch($_GET['action']):
		case "tomp":
			$uri = 'http://oyecdn.us/ipapi/?ip='.$z->myip();
			$data = @json_decode($z->_CURL($uri, false));
			print_r($data);
		break;
		case "loginwithgoogle":
			$oauth = @json_decode($z->_CURL('https://www.googleapis.com/oauth2/v3/tokeninfo?id_token='.$_POST['token'], false));
			if(is_object($oauth)){
				if(GOOGLE_CLIENT_ID!==$oauth->aud || $_POST['gid']!=$oauth->sub){
					echo $z->json(array(
						'result' => 'failed',
						'message' => 'Invalid Login Token. Refresh your page and try again!'
					));	exit;
				}
				@list($offline) = explode("@@", $z->decode($_POST['offline']));
				$gid = isset($oauth->sub) ? $oauth->sub : $_POST['gid']; //google user id
				$gmail = $oauth->email; //google user mail
				$gstatus = $oauth->email_verified == "true" || $oauth->email_verified == true ? 'active' : 'toactivate'; //is email verified
				$gname = isset($oauth->name) ? $oauth->name : SITE_NAME.' User'; //fullname
				$fname = SITE_NAME; $lname = 'User';
				if(!empty($gname) && $gname!="undefined"){
					if(strpos($gname, "+") !== false){
						@list($fn, $ln) = explode("+", $gname);
					}else{
						@list($fn, $ln) = explode(" ", $gname);
					}
					$fname = $fn; $lname = $ln;
				}
				if(empty($gmail) || $z->isEmail($gmail)===false){
					echo $z->json(array(
						'result' => 'failed',
						'message' => 'Your Email is Invaild or is Empty'
					));	exit;
				}				
				echo $z->signup($gid, $gmail, 'user', $fname, $lname, $offline, $mod = 'google'); exit;
			}
			echo $z->json(array(
				'result' => 'failed',
				'message' => 'Security Token Expired. Refresh your page and try again!'
			)); exit;
		break;
		case "isSessionAdmin":
			$uid = (int) $hash->decode($_GET['uid'])[0];
			@list($coken) = explode("@@", $z->decode($_GET['token']));
			echo $z->isSessAdmin($uid, $coken);
		break;		
		case "stream":
			@list($ID, $server, $filename, $format, $title) = explode("@@", $z->decode($_GET['token']));
			if($session->result=="ok"){
				$UID = $session->ID;
				$go = $z->select("SELECT ID FROM history WHERE uid=? AND tid=? LIMIT 1", array($UID, $ID), "ii");
				if($z->result=="ok" && $z->count > 0){
					$z->update("UPDATE history SET loops=loops+1, added=? WHERE uid=? AND tid=? LIMIT 1", array(time(),$UID,$ID), "iii");
				}else{
					$z->insert("INSERT INTO history (uid,tid,loops,added) VALUES(?,?,?,?)", array($UID,$ID,"1",time()), "iiii");
					$z->update("UPDATE tracks SET views=views+1 WHERE ID=? LIMIT 1", array($ID), "i");
				}
			}else{
				$ip = $z->myip();
				$go = $z->select("SELECT ID FROM history WHERE ipaddr=? AND tid=? LIMIT 1", array($ip, $ID), "si");
				if($z->result=="ok" && $z->count > 0){
					$z->update("UPDATE history SET loops=loops+1, added=? WHERE ipaddr=? AND tid=? LIMIT 1", array(time(),$ip,$ID), "isi");
				}else{
					$z->insert("INSERT INTO history (ipaddr,tid,loops,added) VALUES(?,?,?,?)", array($ip,$ID,"1",time()), "siii");
					$z->update("UPDATE tracks SET views=views+1 WHERE ID=? LIMIT 1", array($ID), "i");
				}
			}
			$UID = $session->result=="ok" ? $session->ID : 0;
			$ip = $z->myip();
			$eKey = $z->randit(12);
			$uri = $z->select("SELECT address FROM servers WHERE ID=? LIMIT 1", array($server), "i")->row->address;
			$uri .= 'stream/'.$eKey.'/'.$z->encode($filename.'@@'.$format.'@@'.$title.'@@'.time(), $eKey);			
			header("location: ".$uri); exit;
		break;
		case "createPlaylist":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], false)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$user = (int) $hash->decode($_POST['uid'])[0];			
			$naam = urldecode($_POST['naam']);
			$ck = $z->select("SELECT ID FROM playlists WHERE uid=? AND label=?", array($user,$naam), "is");
			if($ck->result=="ok" && $ck->count > 0){
				echo $z->json(array('result' => 'failed', 'message' => 'You already have a playlist with this name...')); exit;
			}else{
				$new = $z->insert("INSERT INTO playlists (uid,label) VALUES(?,?)", array($user,$naam), "is");
				if($new->result=="ok"){
					echo $z->json(array('result' => 'ok', 'message' => 'Playlist created successfully...', 'ID' => $hash->encode($new->ID), 'name' => $naam)); exit;
				}else{
					echo $z->json(array('result' => 'failed', 'message' => 'Unable to process request...')); exit;	
				}
			}
		break;
		case "getPlaylist":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], false)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$user = (int) $hash->decode($_POST['uid'])[0];			
			$ID = (int) $hash->decode($_POST['pid'])[0];
			$list = $z->select("SELECT tid FROM playlists_tracks WHERE pid=? AND status=? GROUP BY tid ORDER BY ID DESC", array($ID,"yes"), "is");
			if($list->result=="ok" && $list->count > 0){
				$ids = array();
				for($n = 0; $n < count($list->fetch); $n++):
					array_push($ids, $list->fetch[$n]->tid);
				endfor;
				$params = implode(",", array_map('intval', $ids));
				$list = $z->select("SELECT * FROM tracks WHERE ID IN ($params) AND status=?", array("yes"), "s");				
				$data = array();
				for($n = 0; $n < count($list->fetch); $n++):
					$item = $list->fetch[$n];
					$trackTitle = stripslashes($item->title);
					$s = $item->views > 1 ? "s" : "";
					$img = baseurl.'photo/track/'.$z->encode($item->poster).'/default.jpg';
					$stream = $z->streamLink($item);							
					$data[] = array(
						'ID' => $hash->encode($item->ID),
						'artist' => $item->artist,
						'duration' => $z->toHMS($item->duration),
						'formats' => $item->formats,
						'poster' => $img,
						'slug' => $item->slug,
						'stream' => $stream,
						'title' => $trackTitle,
						'link' => baseurl.'track/'.$item->slug
					);
				endfor;				
				echo $z->json(array('result' => 'ok', 'list' => $data, 'message' => 'Playlist add to Play Que...')); exit;	
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Playlist is empty...')); exit;	
			}
		break;
		case "addToPlaylist":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], false)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$user = (int) $hash->decode($_POST['uid'])[0];			
			$pid = (int) $hash->decode($_POST['pid'])[0];			
			$tid = (int) $hash->decode($_POST['tid'])[0];			
			$count = 0;
			$countLabel = '';
			$playlist = $z->select("SELECT * FROM playlists WHERE ID=? AND uid=? LIMIT 1", array($pid, $user), "ii");
			if($playlist->result=="ok" && $playlist->count > 0){
				$playlist = $playlist->row;
				$in = $z->select("SELECT ID FROM playlists_tracks WHERE pid=? AND tid=? AND status=? LIMIT 1", array($pid, $tid, "yes"), "iis");
				if($in->result=="ok" && $in->count > 0){				
					echo $z->json(array('result' => 'failed', 'message' => 'Track is already in this Playlist...')); exit;
				}else{
					$save = $z->insert("INSERT INTO playlists_tracks (pid,tid,status) VALUES (?,?,?)", array($pid,$tid,"yes"), "iis");
					if($save->result=="ok"){					
						$count = $playlist->tracks + 1;
						$countLabel = $count.' Track';
						$countLabel .= $count > 1 ? "s" : "";
						$z->update("UPDATE playlists SET tracks=tracks+1 WHERE ID=? LIMIT 1", array($pid), "i");
						echo $z->json(array('result' => 'ok', 'count' => $count, 'countLabel' => $countLabel, 'message' => 'Track added to Playlist...')); exit;
					}else{
						echo $z->json(array('result' => 'failed', 'message' => 'Unable to process your request...')); exit;
					}
				}
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process your request...')); exit;
			}
		break;
		case "removeFromPlaylist":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], false)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$user = (int) $hash->decode($_POST['uid'])[0];			
			@list($ID, $PID) = explode("@@", $z->decode($_POST['pti']));
			$playlist = $z->select("SELECT * FROM playlists WHERE ID=? AND uid=? LIMIT 1", array($PID, $user), "ii");
			if($playlist->result=="ok" && $playlist->count > 0){
				$count = $playlist->row->tracks - 1;
				$countLabel = $count . ' Track';
				$countLabel .= $count > 1 ? 's' : '';
				$z->update("UPDATE playlists_tracks SET status=? WHERE ID=? AND pid=? LIMIT 1", array("no",$ID,$PID), "sii");	
				$z->update("UPDATE playlists SET tracks=? WHERE ID=? AND uid=? LIMIT 1", array($count,$PID,$user), "iii");	
				echo $z->json(array('result' => 'ok', 'message' => 'Track removed from Playlist...', 'count' => $count, 'countLabel' => $countLabel)); exit;
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process your request...')); exit;
			}
		break;
		
		
		//Admin
		case "adminGetServer":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			
			$SID = $_POST['sid'];
			$check = $z->select("SELECT ID FROM tracks WHERE ytid=? AND status='yes' LIMIT 1", array($SID), "s");
			if($check->result=="ok" && $check->count > 0){
				echo $z->json(array(
					'result' => 'already', 
					'message' => 'Requested track already uploaded...'
				)); exit;
			}
			
			$get = $z->select("SELECT ID,address FROM servers WHERE status=? ORDER BY ID ASC LIMIT 1", array("active"), "s");	
			if($get->result=="ok"){
				echo $z->json(array(
					'result' => 'ok', 
					'ID' => $hash->encode($get->row->ID),
					'uri' => $get->row->address.'upload/'.$_POST['mod']
				)); exit;
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process your request...')); exit;
			}
		break;
		case "adminCreateAlbum":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$user = (int) $hash->decode($_POST['uid'])[0];
			$cover = $user.'.'.time().'.png';
			$ndp = __DIR__ . '/assets/covers/'.$cover;
			$name = $_POST['name'];			
			$slug = $z->slug($name);
			$slugChk = $z->select("SELECT ID FROM albums WHERE slug=? LIMIT 1", array($slug), "s");
			if($slugChk->result=="ok" && $slugChk->count > 0){
				$slug .= "-2";
			}
			if(@move_uploaded_file($_FILES['cover']['tmp_name'], $ndp)){
				$create = $z->insert("INSERT INTO albums (userid,title,slug,photo) VALUES (?,?,?,?)", array($user,$name,$slug,$cover), "isss");
				if($create->result=="ok"){
					echo $z->json(array(
						'result' => 'ok',
						'ID' => $hash->encode($create->ID),
						'cover' => baseurl.'photo/album/'.$z->encode($cover).'/default.jpg'
					)); exit;
				}else{
					echo $z->json(array('result' => 'failed', 'message' => 'Unable to process your request...')); exit;
				}
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process your request...')); exit;
			}
		break;
		case "adminSavePoster":			
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			set_time_limit(0);
			$uid = $_POST['uid'];
			$utoken = $_POST['token'];			
			$ext = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
			$fileid  = $session->ID.'.'.time().'.'.$ext;	
			$targetpath = __DIR__ . '/assets/temp/'.$fileid;
			$tmppath = $_FILES['file']['tmp_name'];
			if(!empty($tmppath)){
				if(@move_uploaded_file($tmppath, $targetpath)){
					echo $z->json(array('result' => 'ok', 'message' => 'Photo saved.', 'src' => baseurl.'tphoto/'.$fileid, 'fileid' => $z->encode($fileid))); exit;
				}	
			}	
			echo $z->json(array('result' => 'failed', 'message' => 'Unable to save photo. Try again.'));				
		break;
		case "adminUpdateAlbum":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$user = (int) $hash->decode($_POST['uid'])[0];
			$albumID = (int) $hash->decode($_POST['aid'])[0];
			$albumPosterCurrent = $z->select("SELECT photo FROM albums WHERE ID=? LIMIT 1", array($albumID), "i")->row->photo;
			$cover = $user.'.'.time().'.png';
			$ndp = __DIR__ . '/assets/covers/'.$cover;
			$name = $_POST['name'];			
			if(@move_uploaded_file($_FILES['cover']['tmp_name'], $ndp)){
				$update = $z->update("UPDATE albums SET title=?, photo=? WHERE ID=? LIMIT 1", array($name, $cover, $albumID), "ssi");
				if($update->result=="ok"){					
					if($albumPosterCurrent!="no-cover.png"){ 
						@unlink(__DIR__ . '/assets/covers/'.$albumPosterCurrent);
					}
					echo $z->json(array(
						'result' => 'ok', 
						'cover' => baseurl.'photo/album/'.$z->encode($cover).'/default.jpg',
						'title' => stripslashes($name)
					)); exit;
				}else{
					echo $z->json(array('result' => 'failed', 'message' => 'Unable to process your request...')); exit;
				}
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process your request...')); exit;
			}
		break;
		case "adminRemoveAlbum":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$user = (int) $hash->decode($_POST['uid'])[0];
			$albumID = (int) $hash->decode($_POST['aid'])[0];
			$z->update("UPDATE albums SET status=? WHERE ID=? LIMIT 1", array("no", $albumID), "si");
			$album = $z->select("SELECT * FROM albums WHERE ID=? LIMIT 1", array($albumID), "i")->row;
			if($album->locked=='yes'){
				echo $z->json(array('result' => 'failed', 'message' => 'You cannot remove this Album!')); exit;
			}else{
				echo $z->json(array('result' => 'ok', 'message' => 'Album removed successfully...')); exit;
			}
		break;
		case "adminPublishTrack":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}			
			$user = (int) $hash->decode($_POST['uid'])[0];
			$ID = $_POST['sid'];
			$thumb = $_POST['thumb'];
			$source = $_POST['source'];
			$server = (int) $hash->decode($_POST['server'])[0];
			$disk = (int) $_POST['disk'];
			$album = (int) $hash->decode($_POST['album'])[0];
			$genre = (int) $hash->decode($_POST['cate'])[0];
			$title = urldecode($_POST['title']);
			$duration = urldecode($_POST['duration']);
			$artist = urldecode($_POST['artist']);			
			$tags = urldecode($_POST['tags']);
			$formats = $_POST['formats'];
			
			$slug = $z->slug($title);
			$checkSlug = $z->select("SELECT ID FROM tracks WHERE slug=? LIMIT 1", array($slug), "s");
			if($checkSlug->result=="ok" && $checkSlug->count > 0){
				$slug .= '-2';
			}			
			
			$poster = $ID.'.jpg';
			$filename = $ID.'.mp3';			
			if($source=="local"){				
				$poster = $z->decode($thumb);				
				@file_put_contents(__DIR__ . '/assets/posters/'.$poster, @file_get_contents(__DIR__ . '/assets/temp/'.$poster));
			}else if($source=="soundcloud"){				
				@file_put_contents(__DIR__ . '/assets/posters/'.$poster, @file_get_contents('https:'.$thumb));
			}			
			
			$save = $z->insert("INSERT INTO tracks (userid,type,ytid,albumid,genre,title,slug,tags,poster,duration,artist,server,filename,formats,added)
			VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", array($user,$source,$ID,$album,$genre,$title,$slug,$tags,$poster,$duration,$artist,$server,$filename,$formats,time()),
			"issiissssisissi");
			
			if($save->result=="ok"){				
				$z->update("UPDATE servers SET bspace=bspace+".$disk." WHERE ID=?", array($server), "i");
				$z->update("UPDATE albums SET tracks=tracks+1 WHERE ID=?", array($album), "i");
				$z->update("UPDATE genres SET tracks=tracks+1 WHERE ID=?", array($genre), "i");
				echo $z->json(array('result' => 'ok', 'message' => 'Track saved successfully...'));
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to save track...'));
			}
		break;
		case "adminUpdateUserStatus":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}			
			$you = (int) $hash->decode($_POST['uid'])[0];			
			$uid = (int) $hash->decode($_POST['user'])[0];
			if($you==$uid){
				echo $z->json(array('result' => 'failed', 'message' => 'You cannot edit yourself...')); exit;
			}
			@list($status, $x) = explode("@@", $z->decode($_POST['status']));			
			$user = $z->select("SELECT * FROM users WHERE ID=? LIMIT 1", array($uid), "i")->row;
			if($user->locked=='yes'){
				echo $z->json(array('result' => 'failed', 'message' => 'Requested User is Locked...')); exit;
			}
			$z->update("UPDATE users SET status=? WHERE ID=? LIMIT 1", array($status, $uid), "si");
			$statusCurrent = $status == 'banned' ? $z->encode('active@@'.time()) : $z->encode('banned@@'.time());
			$statusLabel = $status == 'banned' ? 'Remove Ban' : 'Ban User';			
			echo $z->json(array('result' => 'ok', 'message' => 'User updated...', 'cls' => $status, 'current' => $statusCurrent, 'label' => $statusLabel));
		break;
		case "adminUpdateUserType":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}			
			$you = (int) $hash->decode($_POST['uid'])[0];			
			$uid = (int) $hash->decode($_POST['user'])[0];
			if($you==$uid){
				echo $z->json(array('result' => 'failed', 'message' => 'You cannot edit yourself...')); exit;
			}
			$user = $z->select("SELECT * FROM users WHERE ID=? LIMIT 1", array($uid), "i")->row;
			if($user->locked=='yes'){
				echo $z->json(array('result' => 'failed', 'message' => 'Requested User is Locked...')); exit;
			}
			@list($utype, $x) = explode("@@", $z->decode($_POST['type']));
			$z->update("UPDATE users SET utype=? WHERE ID=? LIMIT 1", array($utype, $uid), "si");
			echo $z->json(array('result' => 'ok', 'message' => 'User updated...'));					
		break;
		case "adminUpdateTrack":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}			
			$you = (int) $hash->decode($_POST['uid'])[0];			
			$tid = (int) $hash->decode($_POST['tid'])[0];
			$isPoster = $_POST['isposter'];
			$album = (int) $hash->decode($_POST['album'])[0];
			$genre = (int) $hash->decode($_POST['genre'])[0];
			$title = $_POST['title'];
			$tags = $_POST['tags'];
			$artist = $_POST['artist'];
			
			$otrack = $z->select("SELECT * FROM tracks WHERE ID=? LIMIT 1", array($tid), "i")->row;
			$oaid = $otrack->albumid; //current album id
			$ogid = $otrack->genre; //current genre
			
			$save = false;			
			if($isPoster=='yes'){
				$ytid = $otrack->ytid;
				$cover = 'thumb_'.$ytid.'.jpg';
				@unlink($cover);
				$ndp = __DIR__ . '/assets/posters/'.$cover;
				if(@move_uploaded_file($_FILES['poster']['tmp_name'], $ndp)){
					if($z->update("UPDATE tracks SET albumid=?, genre=?, title=?, tags=?, poster=?, artist=? WHERE ID=? LIMIT 1",
					array($album,$genre,$title,$tags,$cover,$artist,$tid), "iissssi")->result=="ok"){
						if($album!=$oaid){
							$z->update("UPDATE albums SET tracks=tracks-1 WHERE ID=? LIMIT 1", array($oaid), "i");
							$z->update("UPDATE albums SET tracks=tracks+1 WHERE ID=? LIMIT 1", array($album), "i");
						}
						if($genre!=$ogid){
							$z->update("UPDATE genres SET tracks=tracks-1 WHERE ID=? LIMIT 1", array($ogid), "i");
							$z->update("UPDATE genres SET tracks=tracks+1 WHERE ID=? LIMIT 1", array($genre), "i");
						}
						$save = true;
					}	
				}
			}else{
				if($z->update("UPDATE tracks SET albumid=?, genre=?, title=?, tags=?, artist=? WHERE ID=? LIMIT 1",
				array($album,$genre,$title,$tags,$artist,$tid), "iisssi")->result=="ok"){
					if($album!=$oaid){
						$z->update("UPDATE albums SET tracks=tracks-1 WHERE ID=? LIMIT 1", array($oaid), "i");
						$z->update("UPDATE albums SET tracks=tracks+1 WHERE ID=? LIMIT 1", array($album), "i");
					}
					if($genre!=$ogid){
						$z->update("UPDATE genres SET tracks=tracks-1 WHERE ID=? LIMIT 1", array($ogid), "i");
						$z->update("UPDATE genres SET tracks=tracks+1 WHERE ID=? LIMIT 1", array($genre), "i");
					}
					$save = true;
				}
			}
			
			if($save==true){
				
				echo $z->json(array('result' => 'ok', 'message' => 'Track updated...'));
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process request...'));
			}
			
				
		break;
		case "adminRemoveTrack":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$user = (int) $hash->decode($_POST['uid'])[0];
			$trackID = (int) $hash->decode($_POST['tid'])[0];
			$track = $z->select("SELECT * FROM tracks WHERE ID=? LIMIT 1", array($trackID), "i")->row;
			if($z->update("UPDATE tracks SET status=? WHERE ID=? LIMIT 1", array("no", $trackID), "si")->result=="ok"){				
				$z->update("UPDATE albums SET tracks=tracks-1 WHERE ID=? LIMIT 1", array($track->albumid), "i");
				$z->update("UPDATE genres SET tracks=tracks-1 WHERE ID=? LIMIT 1", array($track->genre), "i");								
				echo $z->json(array('result' => 'ok', 'message' => 'Track removed successfully...')); exit;
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process request...')); exit;
			}			
		break;
		case "adminUpdateGenre":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$user = (int) $hash->decode($_POST['uid'])[0];
			$ID = (int) $hash->decode($_POST['gid'])[0];
			$slug = $z->slug(urldecode($_POST['slug']));
			$naam = urldecode($_POST['naam']);
			$genre = $z->select("SELECT * FROM genres WHERE ID=? LIMIT 1", array($ID), "i")->row;
			if($genre->slug==$slug){
				if($genre->title!=$naam){
					$z->update("UPDATE genres SET title=? WHERE ID=? LIMIT 1", array($naam, $ID), "si");									
				}	
				echo $z->json(array('result' => 'ok', 'slug' => $slug, 'message' => 'Genre updated...')); exit;	
			}else{
				$aslug = $z->select("SELECT * FROM genres WHERE slug=? LIMIT 1", array($slug), "s");
				if($aslug->result=="ok" && $aslug->count > 0){
					echo $z->json(array('result' => 'failed', 'message' => 'Slug is already in use. Try different one...')); exit;	
				}
				$z->update("UPDATE genres SET title=?, slug=? WHERE ID=? LIMIT 1", array($naam, $slug, $ID), "ssi");
				echo $z->json(array('result' => 'ok',  'slug' => $slug, 'message' => 'Genre updated...')); exit;	
			}
		break;
		case "adminRemoveGenre":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$user = (int) $hash->decode($_POST['uid'])[0];
			$genreID = (int) $hash->decode($_POST['gid'])[0];
			$track = $z->select("SELECT * FROM genres WHERE ID=? LIMIT 1", array($genreID), "i")->row;
			if($z->update("UPDATE genres SET status=? WHERE ID=? LIMIT 1", array("no", $genreID), "si")->result=="ok"){				
				echo $z->json(array(
					'result' => 'ok',
					'message' => 'Genre removed successfully...',
					'total' => number_format($z->select("SELECT COUNT(ID) as total FROM genres WHERE status=? ORDER BY ID DESC", array("yes"), "s")->row->total)
				)); exit;
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process request...')); exit;
			}			
		break;
		case "adminNewGenre":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$naam = urldecode($_POST['naam']);
			$genre = $z->select("SELECT * FROM genres WHERE title=? LIMIT 1", array($naam), "s");
			if($genre->result=="ok" && $genre->count > 0){
				echo $z->json(array('result' => 'failed', 'message' => 'Genre `<span class="fontb">'.$naam.'</span>` already exists...')); exit;
			}
			$slug = $z->slug($naam);
			$genre = $z->select("SELECT * FROM genres WHERE slug=? LIMIT 1", array($slug), "s");
			if($genre->result=="ok" && $genre->count > 0){
				$slug .= '-2';
			}
			$save = $z->insert("INSERT INTO genres (title,slug) VALUES(?,?)", array($naam,$slug), "ss");
			if($save->result=="ok"){
				echo $z->json(array(
					'result' => 'ok',
					'message' => 'Genre added successfully...',
					'ID' => $hash->encode($save->ID),
					'title' => $naam,
					'slug' => $slug,
					'total' => number_format($z->select("SELECT COUNT(ID) as total FROM genres WHERE status=? ORDER BY ID DESC", array("yes"), "s")->row->total)
				)); exit;
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process request...')); exit;
			}
		break;
		case "adminNewServer":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$naam = urldecode($_POST['naam']);
			$url = urldecode($_POST['url']);
			if(filter_var($url, FILTER_VALIDATE_URL) === FALSE) {
				echo $z->json(array('result' => 'failed', 'message' => 'Enter valid server url...')); exit;
			}else{
				$url_headers = @get_headers($url);
				if(!$url_headers || $url_headers[0] == 'HTTP/1.1 404 Not Found'){
					echo $z->json(array('result' => 'failed', 'message' => 'Your Server `<span class="fontb">'.$url.'</span>` looks down. Please check...')); exit;
				}
			}
			$space = (int) $_POST['space'];
			if($space <= 0){
				echo $z->json(array('result' => 'failed', 'message' => 'Enter Disk Space in GBs (Numeric Only)...')); exit;
			}
			$GB = $space * (1024 * 1024 * 1024);			
			$save = $z->insert("INSERT INTO servers (title,address,tspace,added) VALUES(?,?,?,?)", array($naam,$url,$GB,time()), "ssii");
			if($save->result=="ok"){
				echo $z->json(array(
					'result' => 'ok',
					'message' => 'Server added successfully...',
					'ID' => $hash->encode($save->ID),
					'disk' => $z->formatSize($GB),
					'added' => date("d M, Y", time()),
					'total' => number_format($z->select("SELECT COUNT(ID) as total FROM servers WHERE status!=?", array("no"), "s")->row->total)
				)); exit;
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process request...')); exit;
			}
		break;
		case "adminRemoveServer":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$sid = (int) $hash->decode($_POST['sid'])[0];
			if($z->update("UPDATE servers SET status=? WHERE ID=? LIMIT 1", array("no",$sid), "si")->result=="ok"){
				echo $z->json(array(
					'result' => 'ok',
					'message' => 'Server removed successfully...',
					'total' => number_format($z->select("SELECT COUNT(ID) as total FROM servers WHERE status!=?", array("no"), "s")->row->total) 
				)); exit;
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process request...')); exit;
			}
		break;
		case "adminUpdateServer":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$sid = (int) $hash->decode($_POST['sid'])[0];
			$server = $z->select("SELECT * FROM servers WHERE ID=? LIMIT 1", array($sid), "i")->row;
			if($server->locked=='yes'){
				echo $z->json(array('result' => 'failed', 'message' => 'Requested server is locked...')); exit;
			}
			$closed = $_POST['closed'];
			if($closed=='not'){
				$closed = 'active';
			}			
			$naam = urldecode($_POST['naam']);
			$url = urldecode($_POST['url']);
			if(filter_var($url, FILTER_VALIDATE_URL) === FALSE) {
				echo $z->json(array('result' => 'failed', 'message' => 'Enter valid server url...')); exit;
			}else{
				$url_headers = @get_headers($url);
				if(!$url_headers || $url_headers[0] == 'HTTP/1.1 404 Not Found'){
					echo $z->json(array('result' => 'failed', 'message' => 'Your Server `<span class="fontb">'.$url.'</span>` looks down. Please check...')); exit;
				}
			}
			$space = (int) $_POST['space'];
			if($space <= 0){
				echo $z->json(array('result' => 'failed', 'message' => 'Enter Disk Space in GBs (Numeric Only)...')); exit;
			}
			$GB = $space * (1024 * 1024 * 1024);
			if($z->update("UPDATE servers SET title=?, address=?, tspace=?, added=?, status=? WHERE ID=? LIMIT 1",			
			array($naam,$url,$GB,time(),$closed,$sid), "ssiisi")->result=="ok"){
				echo $z->json(array(
					'result' => 'ok',
					'message' => 'Server updated...',
					'added' => date("d M Y", time()),
					'disk' => array(
						'label' => ($server->bspace==0 ? '0 Byte' : $z->formatSize($server->bspace)).' of '.$z->formatSize($GB),
						'percent' => $server->bspace == 0 ? '100%' : (($server->bspace / $GB) * 100) . '%'
					),
					'sts' => 'sts-'.$closed,
					'status' => $closed
				)); exit;
			}else{
				echo $z->json(array('result' => 'failed', 'message' => 'Unable to process request...')); exit;
			}
		break;
		case "adminUpdateCog":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$live = $_POST['live'] == 'yes' ? 'live' : 'down';
			$mustlogin = $_POST['mustlogin'];
			$title = urldecode($_POST['title']);
			$slogan = urldecode($_POST['slogan']);
			$formats = urldecode($_POST['formats']);
			$googleGA = urldecode($_POST['googlega']);
			$download = urldecode($_POST['download']);
			
			$z->update("UPDATE settings SET valu=? WHERE optn='site_status' LIMIT 1", array($live), "s");
			$z->update("UPDATE settings SET valu=? WHERE optn='must_signin' LIMIT 1", array($mustlogin), "s");
			$z->update("UPDATE settings SET valu=? WHERE optn='site_title' LIMIT 1", array($title), "s");
			$z->update("UPDATE settings SET valu=? WHERE optn='site_slogan' LIMIT 1", array($slogan), "s");
			$z->update("UPDATE settings SET valu=? WHERE optn='formats' LIMIT 1", array($formats), "s");
			$z->update("UPDATE settings SET valu=? WHERE optn='google_ga' LIMIT 1", array(strtolower($googleGA)), "s");
			$z->update("UPDATE settings SET valu=? WHERE optn='allow_download' LIMIT 1", array(strtolower($download)), "s");
			
			echo $z->json(array('result' => 'ok', 'message' => 'Settings updated successfully...')); exit;
			
		break;
		case "adminResetKey":
			if($z->isValidSession($session, $_POST['uid'], $_POST['token'], true)->result!="ok"){
				echo $z->json(array('result' => 'failed', 'message' => 'You are not authorized for this action...')); exit;
			}
			$__key = strtolower($z->randit(12));
			$apikey = $z->encode($__key.'@@'.time());
			$z->update("UPDATE settings SET valu=? WHERE optn='apikey' LIMIT 1", array($__key), "s");
			$z->update("UPDATE settings SET valu=? WHERE optn='api_key' LIMIT 1", array($apikey), "s");
			echo $z->json(array(
				'result' => 'ok',
				'message' => 'API Key updated successfully...',
				'key' => $apikey
			)); exit;
		break;
		
	endswitch;
} exit;
ob_flush(); ?>