<?php
class ZMusic{

	public  function safe_b64encode($string) {
        $data = base64_encode($string);
        $data = str_replace(array('+','/','='),array('-','_',''),$data);
        return $data;
	}
	 
	public function safe_b64decode($string) {
			$data = str_replace(array('-','_'),array('+','/'),$string);
			$mod4 = strlen($data) % 4;
			if ($mod4) {
				$data .= substr('====', $mod4);
			}
			return base64_decode($data);
	}

	public  function encode($value, $key = "none"){ 
			if(!$value){return false;}
			$text = $value;
			$ENCRYPT_KEY = $key == "none" ? ENCRYPTION_KEY : $key;
			$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
			$iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
			$crypttext = mcrypt_encrypt(MCRYPT_RIJNDAEL_256, md5($ENCRYPT_KEY), $text, MCRYPT_MODE_ECB, $iv);
			return trim($this->safe_b64encode($crypttext)); 
	}
	 
	public function decode($value, $key = "none"){
			if(!$value){return false;}
			$ENCRYPT_KEY = $key == "none" ? ENCRYPTION_KEY : $key;
			$crypttext = $this->safe_b64decode($value); 
			$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB);
			$iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
			$decrypttext = mcrypt_decrypt(MCRYPT_RIJNDAEL_256, md5($ENCRYPT_KEY), $crypttext, MCRYPT_MODE_ECB, $iv);
			return trim($decrypttext);
	}
	
	public function _CURL($url, $header = true, $timeout = 3600){
		$ch = curl_init($url);		
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		if($header==true) curl_setopt($ch, CURLOPT_HEADER, TRUE); // We'll parse redirect url from header.
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE); // We want to just get redirect url but not to follow it.
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
		curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
		return curl_exec($ch);
	}

	public function parseHeaders($headers){
    	$vals = array();
  		foreach($headers as $key):
    		if(strpos($key, ':') !== false && substr_count($key, ":") == 1){
        		@list($headername, $headervalue) =  explode(":", $key);
        		$vals[$headername] = trim($headervalue);
     		}
  		endforeach;
    	return $vals;
	}

	public function toHMS($seconds) {
  		$t = round($seconds);
  		return sprintf('%02d:%02d:%02d', ($t/3600),($t/60%60), $t%60);
	}

	public function getCombinations($array){	
		$length = count($array);
		$combocount=pow(2,$length);
		for ($i = 0;$i<=$combocount;$i++){
			$binary=$this->decextbin($i,$length);
			$combination='';
			for($j=0;$j<$length;$j++)
			{
				if($binary[$j]=="1")
					$combination.=$array[$j].' ';
			}
			$combinationsarray[]=$combination;			
		}
		return array_reverse($combinationsarray);
	}

	public function decextbin($decimalnumber,$bit){
		$binarynumber = '';
		$maxval = 1;
		$sumval = 1;
		for($i=1;$i< $bit;$i++)
		{
			$maxval = $maxval * 2;
			$sumval = $sumval + $maxval;
		}
	 
		if ($sumval < $decimalnumber) return 'ERROR - Not enough bits to display this figure in binary.';
		for($bitvalue=$maxval;$bitvalue>=1;$bitvalue=$bitvalue/2)
		{
			if (($decimalnumber/$bitvalue) >= 1) $thisbit = 1; else $thisbit = 0;
			if ($thisbit == 1) $decimalnumber = $decimalnumber - $bitvalue;
		$binarynumber .= $thisbit;
		}
		return $binarynumber;
	}

	public function stream($file, $name, $content_type = 'application/octet-stream') {
		
		@error_reporting(0);		
		$filesize = sprintf("%u", filesize($file));
		$read_size = 4096;
    	$filename = substr($name, -1) == '.' ? rtrim($name, '.') : $name;
		if(isset($_SERVER['HTTP_RANGE'])){
			$range = $_SERVER['HTTP_RANGE'];
		}elseif($apache = apache_request_headers()){
			$headers = array();
			foreach ($apache as $header => $val):
				$headers[strtolower($header)] = $val;
			endforeach;
			$range = isset($headers['range']) ? $headers['range'] : FALSE;			
		}else{
			$range = FALSE;
		}

		//Is range
		if($range){
			$partial = true;
			list($param, $range) = explode('=',$range);
			if(strtolower(trim($param)) != 'bytes'){ 
				header("HTTP/1.1 400 Invalid Request"); exit;
			}
			$range = explode(',',$range);
			$range = explode('-',$range[0]); 
			if ($range[0] === ''){
				$end = $filesize - 1;
				$start = $end - intval($range[0]);
			} else if ($range[1] === '') {
				$start = intval($range[0]);
				$end = $filesize - 1;
			}else{ 
				// Both numbers present, return specific range
				$start = intval($range[0]);
				$end = intval($range[1]);
            	// Invalid range/whole file specified, return whole file
				if ($end >= $filesize || (!$start && (!$end || $end == ($filesize - 1)))) $partial = false; 
			}
			$length = $end - $start + 1;
		}else{
			$partial = false; 
		}

		// Send standard headers
		header("Content-Type: $content_type");
    	header('Content-Disposition: attachment; filename="'.$filename.'.mp3"');
		header("Content-Length: $filesize");
		header('Accept-Ranges: bytes');

		// send extra headers for range handling...
		if($partial){
			header('HTTP/1.1 206 Partial Content');
			header("Content-Range: bytes $start-$end/$filesize");
			if (!$fp = fopen($file, 'rb')) {
				header("HTTP/1.1 500 Internal Server Error"); exit;
			}
			if ($start) fseek($fp,$start);
			while($length){
				set_time_limit(0);
				$read = ($length > $read_size) ? $read_size : $length;
				$length -= $read;
				print(fread($fp,$read));
			}
			fclose($fp);
		}else{
			readfile($file);
		}
		exit;
	}
	
}

date_default_timezone_set("UTC");
ini_set("display_errors", "0");
error_reporting(E_ALL | E_STRICT);
$z = new ZMusic();
?>