<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"> 
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:og="http://ogp.me/ns#"  xmlns:fb="http://www.facebook.com/2008/fbml">
<head>
<meta name="robots" content="noindex" />
<meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>ZMusic Setup</title>	
<style>
.anim{transition: all 0.2s linear 0s;}
ul, ol{list-style:none;margin:0px;padding:0px;}
p, h1, h2{margin:0px;padding:0px;font-size:13px;font-weight:normal;}
.hide{display:none;}
.rel{position: relative;}
a{
	color: #0070ff;
    text-decoration: none;
}
a:hover{
	text-decoration:underline;
}
.errorNote{
	background: #d63d3d;
    text-align: center;
    padding: 10px;
    color: #fff;
	border-radius:2px;
	margin-bottom: 5px;
	font-size: 15px;
}
body{
	background: #e6e6e6;
	font-family: segoe ui, arial, tahoma, sans-serif;
	padding: 0px;
	margin: 0px;
	font-size:13px;
}
.zuz-logo{
	display: block;
    margin: 0 auto;
    width: 120px;
    height: 120px;
    margin-top: 40px;
}
.wrap{
	margin: 0 auto;
    width: 650px;    
}
.frm{
	background: #fff;
    margin-top: 20px;
    margin-bottom: 50px;
    padding: 40px;
    box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.05);
    line-height: 1;
    font-size: 24px;
    border-radius: 3px;
    font-weight: lighter;
    box-sizing: border-box;
	font-family: segoe ui;
}
.frm .error-ico{
	background: #e24040;
    color: #fff;
    width: 70px;
    height: 70px;
    text-align: center;
    font-size: 58px;
    border-radius: 100px;
    margin: 0 auto;
	margin-bottom: 20px;
}
.frm .title{}
.frm-error .title{
	text-align: center;
    margin: 4px 0px;
}
.checkmark__circle {
  stroke-dasharray: 166;
  stroke-dashoffset: 166;
  stroke-width: 2;
  stroke-miterlimit: 10;
  stroke: #7ac142;
  fill: none;
  animation: stroke 0.6s cubic-bezier(0.65, 0, 0.45, 1) forwards;
}

.checkmark {
  width: 56px;
  height: 56px;
  border-radius: 50%;
  display: block;
  stroke-width: 2;
  stroke: #fff;
  stroke-miterlimit: 10;
  margin: 0 auto;
  box-shadow: inset 0px 0px 0px #7ac142;
  animation: fill .4s ease-in-out .4s forwards, scale .3s ease-in-out .9s both;
}

.checkmark__check {
  transform-origin: 50% 50%;
  stroke-dasharray: 48;
  stroke-dashoffset: 48;
  animation: stroke 0.3s cubic-bezier(0.65, 0, 0.45, 1) 0.8s forwards;
}

@keyframes stroke {
  100% {
    stroke-dashoffset: 0;
  }
}
@keyframes scale {
  0%, 100% {
    transform: none;
  }
  50% {
    transform: scale3d(1.1, 1.1, 1);
  }
}
@keyframes fill {
  100% {
    box-shadow: inset 0px 0px 0px 200px #7ac142;
  }
}
.update-done{
	font-size: 16px;
    text-align: center;
    margin-top: 20px;
}
.continue-link{
	text-align: center;
}
.continue-link a{font-weight:bold;font-size:13px;}
</style>
</head>
<body>
<img src="https://zuz.host/ui/zuz-logo-public.png" class="zuz-logo">
<div class="wrap">
<?php 
if(!file_exists(__DIR__ . '/includes/config.php')){
	echo '<div class="frm frm-error rel">
		<div class="error-ico">&times;</div>
		<h2 class="title">I think you haven\'t installed ZMusic Yet :(</h2>
		<h2 class="title">`<b>config.php</b>` not found inside `<b>' . __DIR__ . '/includes/</b>`</h2>
	</div>'; exit;
}
require_once(__DIR__ ."/includes/config.php");
date_default_timezone_set("UTC");
ini_set("display_errors", "1");
error_reporting(E_ALL | E_STRICT);

if(!function_exists('mysqli_connect')){
	echo '<div class="frm frm-error rel">
		<div class="error-ico">&times;</div>
		<h2 class="title">MySQLi Extension Needed for ZMusic to Work Properly...</h2>		
	</div>'; exit;
}
$_time = time();
$DB = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if($DB->connect_error){
	echo '<div class="frm frm-error rel">
		<div class="error-ico">&times;</div>
		<h2 class="title">Wrong Username/Password/Host/DatabaseName in `<b>config.php</b>`</h2>		
	</div>'; exit;
}
$DB->set_charset("utf8");
$DB->query("CREATE TABLE IF NOT EXISTS `ads` (`ID` int(11) NOT NULL,`type` enum('adsense','other') NOT NULL DEFAULT 'adsense', `device` enum('desktop','mobile') NOT NULL DEFAULT 'desktop', `code` mediumtext NOT NULL, `status` enum('yes','no') NOT NULL DEFAULT 'yes') ENGINE=InnoDB DEFAULT CHARSET=utf8");
$DB->query("ALTER TABLE `ads` ADD PRIMARY KEY (`ID`)");
$DB->query("ALTER TABLE `ads` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");

//Last Update Checked
$optn = $DB->query("SELECT ID FROM settings WHERE optn='last_updated' LIMIT 1");
if($optn->num_rows == 0){
	$DB->query("INSERT INTO settings (optn,valu,status) VALUES ('last_updated','$_time','yes')");
}
//Show Ads Per Row
$optn = $DB->query("SELECT ID FROM settings WHERE optn='show_ads_per_row' LIMIT 1");
if($optn->num_rows == 0){
	$DB->query("INSERT INTO settings (optn,valu,status) VALUES ('show_ads_per_row','10','yes')");
}
//Allow Download 
$optn = $DB->query("SELECT ID FROM settings WHERE optn='allow_download' LIMIT 1");
if($optn->num_rows == 0){
	$DB->query("INSERT INTO settings (optn,valu,status) VALUES ('allow_download','no','yes')");
}
//Signin to view
$optn = $DB->query("SELECT ID FROM settings WHERE optn='must_signin' LIMIT 1");
if($optn->num_rows == 0){
	$DB->query("INSERT INTO settings (optn,valu,status) VALUES ('must_signin','no','yes')");
}
//API KEY
$__key = strtolower($z->randit(12));
$optn = $DB->query("SELECT ID FROM settings WHERE optn='apikey' LIMIT 1");
if($optn->num_rows == 0){	
	$DB->query("INSERT INTO settings (optn,valu,status) VALUES ('apikey','$__key','yes')");
}
$apiKey = $z->encode($__key.'@@'.time());
$optn = $DB->query("SELECT ID FROM settings WHERE optn='api_key' LIMIT 1");
if($optn->num_rows == 0){	
	$DB->query("INSERT INTO settings (optn,valu,status) VALUES ('api_key','$apiKey','yes')");
}
 
echo '<div class="frm rel">
	<svg class="checkmark" style="width:75px;height:75px;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 52">
	<circle class="checkmark__circle" cx="26" cy="26" r="25" fill="none"/>
	<path class="checkmark__check" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"/></svg>
	<h2 class="update-done">ZMusic Updated Successfully.</h2>
	<div class="continue-link"><a href="'.baseurl.'?f=updated" class="lnk">Click to Continue</a></div>
</div>';

?>
</div>
