<?php 
date_default_timezone_set("UTC");
ini_set("display_errors", "1");
error_reporting(E_ALL | E_STRICT);

function myip(){
	if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
	{    $ip=$_SERVER['HTTP_CLIENT_IP'];    }
	elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
	{    $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];    }
	else
	{    $ip=$_SERVER['REMOTE_ADDR'];    }
	return $ip;
}

function _CURL($url, $header = true, $timeout = 3600){
	$ch = curl_init($url);		
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
	if($header==true) curl_setopt($ch, CURLOPT_HEADER, TRUE); // We'll parse redirect url from header.
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE); // We want to just get redirect url but not to follow it.
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
	curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
	return curl_exec($ch);
}

function randit($digits){
	srand ((double) microtime() * 10000000);
	$input = array ("A", "B", "C", "D", "E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z");
	$random_generator="";
	for($i=1;$i<$digits+1;$i++){ 
		if(rand(1,2) == 1){
			$rand_index = array_rand($input);
			$random_generator .=$input[$rand_index];
		}else{
			$random_generator .=rand(1,10);
		}
	}
	return $random_generator;
}
	
function Geo(){		
	return @json_decode($z->_CURL('https://api.zuz.host/geo/'.myip(), false));			
}

$_time = time();
	
if(isset($_POST['action'])){
	header("Content-Type: application/json");
	switch($_POST['action']):
		case "stepdb":
		
			$host = $_POST['host'];
			$name = $_POST['name'];
			$user = $_POST['user'];
			$pass = $_POST['pass'];			
			
			$gid = $_POST['gid'];
			$uname = empty($_POST['uname']) || $_POST['uname']=='undefined' ? 'ZMusic User' : $_POST['uname'];
			@list($fname, $lname) = explode(" ", $uname);
			$umail = $_POST['umail'];
			
			$siteTitle = urldecode($_POST['stitle']);
			$siteSlogan = urldecode($_POST['slogan']);
			
			if(empty($host) || empty($name) || empty($user) || empty($pass)){
				echo @json_encode(array('result' => 'failed', 'message' => 'Fill out all fields...')); exit;
			}			
			if(function_exists('mysqli_connect')){
				try{
					$DB = new mysqli($host, $user, $pass, $name);
					if($DB->connect_error){
						echo @json_encode(array('result' => 'failed', 'message' => 'We are unable to connect to Database with provided Username/Password...')); exit;	
					}
					$apiKey = strtolower(randit(12));
					$DB->set_charset("utf8");
					//Create Tables
					$DB->query("SET SQL_MODE = \"NO_AUTO_VALUE_ON_ZERO\"");					
					$DB->query("SET AUTOCOMMIT = 0");					
					$DB->query("SET time_zone = \"+00:00\"");					
					$DB->query("CREATE TABLE IF NOT EXISTS `albums` ( `ID` int(11) NOT NULL, `locked` enum('yes','no') DEFAULT 'no', `userid` bigint(255) NOT NULL DEFAULT '0', `title` varchar(355) NOT NULL, `slug` varchar(355) NOT NULL, `photo` varchar(155) NOT NULL DEFAULT 'no-cover.png', `tracks` int(11) NOT NULL DEFAULT '0', `status` enum('yes','no') NOT NULL DEFAULT 'yes' ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
					$DB->query("CREATE TABLE IF NOT EXISTS `genres` ( `ID` int(11) NOT NULL, `icon` varchar(50) NOT NULL DEFAULT 'no.png', `title` varchar(155) NOT NULL, `slug` varchar(155) NOT NULL, `tracks` int(11) NOT NULL DEFAULT '0', `status` enum('yes','no') NOT NULL DEFAULT 'yes' ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
					$DB->query("INSERT INTO `genres` (`ID`, `icon`, `title`, `slug`, `tracks`, `status`) VALUES (1, 'icon.png', 'Default', 'default', 0, 'yes')");	
					$DB->query("CREATE TABLE IF NOT EXISTS `history` ( `ID` int(11) NOT NULL, `ipaddr` varchar(50) NOT NULL DEFAULT '0.0.0.0', `uid` int(11) NOT NULL DEFAULT '0', `tid` int(11) NOT NULL DEFAULT '0', `loops` int(11) NOT NULL DEFAULT '0', `added` bigint(30) NOT NULL ) ENGINE=InnoDB DEFAULT CHARSET=latin1");	
					$DB->query("CREATE TABLE IF NOT EXISTS `ipdb` ( `ID` int(11) NOT NULL, `ip_addr` varchar(30) NOT NULL, `detail` varchar(455) NOT NULL, `queries` int(11) NOT NULL DEFAULT '0', `status` enum('yes','no') NOT NULL DEFAULT 'yes' ) ENGINE=InnoDB DEFAULT CHARSET=utf8");	
					$DB->query("CREATE TABLE IF NOT EXISTS `playlists` ( `ID` int(11) NOT NULL, `uid` bigint(255) NOT NULL DEFAULT '0', `label` varchar(255) NOT NULL DEFAULT 'Untitled', `tracks` int(11) NOT NULL DEFAULT '0', `status` enum('yes','no') NOT NULL DEFAULT 'yes' ) ENGINE=InnoDB DEFAULT CHARSET=utf8");	
					$DB->query("CREATE TABLE IF NOT EXISTS `playlists_tracks` ( `ID` int(11) NOT NULL, `pid` int(11) NOT NULL DEFAULT '0', `tid` int(11) NOT NULL DEFAULT '0', `status` enum('yes','no') NOT NULL DEFAULT 'yes' ) ENGINE=InnoDB DEFAULT CHARSET=latin1");	
					$DB->query("CREATE TABLE IF NOT EXISTS `servers` ( `ID` int(11) NOT NULL, `locked` enum('yes','no') NOT NULL DEFAULT 'no', `title` varchar(255) NOT NULL DEFAULT 'none', `address` varchar(355) NOT NULL DEFAULT 'none', `tspace` bigint(50) NOT NULL DEFAULT '0', `bspace` bigint(50) NOT NULL DEFAULT '0', `added` varchar(50) NOT NULL DEFAULT '0', `status` enum('active','closed','no') NOT NULL DEFAULT 'active' ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
					$DB->query("INSERT INTO `servers` (`ID`, `locked`, `title`, `address`, `tspace`, `bspace`, `added`, `status`) VALUES (1, 'yes', 'Zuz CDN', 'https://oyecdn.us/zemdrive/', 10737418240, 0, UNIX_TIMESTAMP(), 'active')");
					$DB->query("CREATE TABLE IF NOT EXISTS `settings` ( `ID` int(11) NOT NULL, `optn` varchar(155) NOT NULL, `valu` varchar(155) NOT NULL, `status` enum('yes','no') NOT NULL DEFAULT 'yes' ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
					$DB->query("INSERT INTO `settings` (`ID`, `optn`, `valu`, `status`) VALUES (1, 'site_title', '$siteTitle', 'yes'), (2, 'site_slogan', '$siteSlogan', 'yes'), (3, 'site_status', 'live', 'yes'), (4, 'formats', '128', 'yes'), (5, 'google_ga', 'ua-xxxxxxxx-x', 'yes'), (6, 'show_ads_per_row', '10', 'yes'), (7, 'allow_download', 'no', 'yes'), (8, 'last_updated', '$_time', 'yes'), (9, 'must_signin', 'no', 'yes')");
					$DB->query("CREATE TABLE IF NOT EXISTS `tracks` ( `ID` int(11) NOT NULL, `userid` int(11) NOT NULL DEFAULT '0', `type` enum('youtube','local','soundcloud') NOT NULL DEFAULT 'youtube', `ytid` varchar(100) NOT NULL, `albumid` bigint(255) NOT NULL DEFAULT '0', `genre` varchar(100) NOT NULL, `title` mediumtext NOT NULL, `slug` mediumtext NOT NULL, `tags` mediumtext NOT NULL, `poster` varchar(255) NOT NULL DEFAULT 'no-photo.png', `duration` varchar(20) NOT NULL, `artist` varchar(455) NOT NULL, `server` mediumtext NOT NULL, `filename` varchar(255) NOT NULL DEFAULT 'remote', `formats` varchar(100) NOT NULL DEFAULT '0', `views` int(11) NOT NULL DEFAULT '0', `added` varchar(50) NOT NULL DEFAULT '0', `status` enum('yes','no') NOT NULL DEFAULT 'yes' ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
					$DB->query("ALTER TABLE `tracks` CHANGE `type` `type` ENUM('youtube','local','soundcloud') CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'youtube'");
					$DB->query("CREATE TABLE IF NOT EXISTS `users` ( `ID` int(11) NOT NULL, `token` varchar(255) NOT NULL, `ucode` varchar(20) NOT NULL DEFAULT '0', `utype` enum('admin','moderator','user') NOT NULL DEFAULT 'user', `locked` enum('yes','no') NOT NULL DEFAULT 'no', `googleid` varchar(355) NOT NULL DEFAULT '0', `fbid` varchar(355) NOT NULL DEFAULT '0', `email` varchar(255) NOT NULL, `password` varchar(255) NOT NULL, `fname` varchar(100) NOT NULL, `lname` varchar(100) NOT NULL, `dp` varchar(100) NOT NULL DEFAULT 'no-dp.png', `join_date` varchar(100) NOT NULL, `join_location` varchar(100) NOT NULL, `last_login` varchar(255) NOT NULL, `last_login_location` varchar(255) NOT NULL, `status` varchar(100) NOT NULL DEFAULT 'toactive' ) ENGINE=InnoDB DEFAULT CHARSET=utf8");
					$DB->query("CREATE TABLE IF NOT EXISTS `users_sess` ( `ID` int(11) NOT NULL, `uid` bigint(255) NOT NULL DEFAULT '0', `token` varchar(455) NOT NULL, `expiry` varchar(50) NOT NULL DEFAULT '0', `uinfo` varchar(255) NOT NULL DEFAULT 'none', `status` enum('yes','no') NOT NULL DEFAULT 'yes' ) ENGINE=MyISAM DEFAULT CHARSET=latin1");
					$DB->query("ALTER TABLE `albums` ADD PRIMARY KEY (`ID`)");
					$DB->query("ALTER TABLE `genres` ADD PRIMARY KEY (`ID`)");
					$DB->query("ALTER TABLE `history` ADD PRIMARY KEY (`ID`)");
					$DB->query("ALTER TABLE `ipdb` ADD PRIMARY KEY (`ID`)");
					$DB->query("ALTER TABLE `playlists` ADD PRIMARY KEY (`ID`)");
					$DB->query("ALTER TABLE `playlists_tracks` ADD PRIMARY KEY (`ID`)");
					$DB->query("ALTER TABLE `servers` ADD PRIMARY KEY (`ID`)");
					$DB->query("ALTER TABLE `settings` ADD PRIMARY KEY (`ID`);");
					$DB->query("ALTER TABLE `tracks` ADD PRIMARY KEY (`ID`)");
					$DB->query("ALTER TABLE `users` ADD PRIMARY KEY (`ID`), ADD UNIQUE KEY `email` (`email`)");
					$DB->query("ALTER TABLE `users_sess` ADD PRIMARY KEY (`ID`)");
					$DB->query("ALTER TABLE `albums` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("ALTER TABLE `genres` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("ALTER TABLE `history` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("ALTER TABLE `ipdb` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("ALTER TABLE `playlists` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("ALTER TABLE `playlists_tracks` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("ALTER TABLE `servers` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("ALTER TABLE `settings` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("ALTER TABLE `tracks` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("ALTER TABLE `users` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("ALTER TABLE `users_sess` MODIFY `ID` int(11) NOT NULL AUTO_INCREMENT");
					$DB->query("COMMIT");
					
					//Create Default User
					$already = $DB->query("SELECT * FROM users WHERE googleid='$gid' AND email='$umail' LIMIT 1");
					if($already->num_rows == 0){
						$json = @json_decode(str_replace("$", "", _CURL("http://picasaweb.google.com/data/entry/api/user/".$gid."?alt=json", false)))->entry;					
						$xdp = parse_url($json->gphotothumbnail->t);
						$dp = $xdp['scheme'].'://'.$xdp['host'];
						$dp .= str_replace("/s64-c/", "/s500-c/", $xdp['path']);
						$nDP = $gid.'.jpg';
						@chmod(__DIR__ . "/assets/dps", 0777);
						@file_put_contents(__DIR__ . "/assets/dps/".$nDP, @file_get_contents($dp));					
						$geo = Geo(); $location = is_object($geo) ? $geo->IP.'@@'.$geo->city.'@@'.$geo->country : 'none@@none@@none';		
						$token = rand(111111111111,9999999999999);
						$jdate = time();	
						@mysql_connect($host, $user, $pass);
						@mysql_select_db($name);
						$quer = "INSERT INTO `users` (`ID`, `token`, `ucode`, `utype`, `locked`, `googleid`, `fbid`, `email`, `password`, `fname`, `lname`, `dp`, `join_date`, `join_location`, `last_login`, `last_login_location`, `status`) 
						VALUES (1, '97275i65279mutlgzdz7', '13VM5375', 'admin', 'yes', '$gid', '0', '$umail', 'change123', '$fname', '$lname', '$nDP', '$jdate', '$location', '$jdate', '$location', 'active')";
						@mysql_query($quer);												
					}
					echo @json_encode(array('result' => 'ok', 'message' => 'Database Connected & Tables Created Successfully...')); exit;							
					
				}catch(Exception $e){
					echo @json_encode(array('result' => 'failed', 'message' => 'We are unable to connect to Database with provided credentials...')); exit;	
				}
			}else{
				echo @json_encode(array('result' => 'failed', 'message' => 'MySQLi Extension Needed for ZMusic to Work Properly...')); exit;	
			}	
		break;
	endswitch;
	exit;
}
?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"> 
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:og="http://ogp.me/ns#"  xmlns:fb="http://www.facebook.com/2008/fbml">
<head>
<meta name="robots" content="noindex" />
<meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title>ZMusic Setup</title>	
</head>
<body>
<img src="https://zuz.host/ui/zuz-logo-public.png" class="zuz-logo">
<div class="wrap">

<ul class="steps ibl">
	<li class="stp on stp1 size14 fontn" data-step="1">
		<h2 class="size30 fontb">1</h2>
		Basic
	</li>
	<li class="stp stp2 size14 fontn" data-step="2">
		<h2 class="size30 fontb">2</h2>
		Database
	</li>
	<li class="stp stp3 size14 fontn" data-step="3">
		<h2 class="size30 fontb">3</h2>
		Google App
	</li>
	<li class="stp stp4 size14 fontn" data-step="4">
		<h2 class="size30 fontb">4</h2>
		Email
	</li>
	<li class="stp stp5 size14 fontn" data-step="5">
		<h2 class="size30 fontb">5</h2>
		Done
	</li>
</ul>

<?php
$https = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on' ? 'https' : 'http';
$curl = $https.'://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];						
$uri = parse_url($curl);
$basehost = $uri['host'];
$baseuri = $https.'://'.$basehost.$uri['path']; 	
$step = isset($_GET['step']) ? $_GET['step'] : 1;
$configFile = "";

function getConfigFile($baseuri, $basehost, $gapp_clientid, $adminEmail, $appSlug, $appKey, $siteName, $siteSlogan,
	$db_host, $db_name, $db_user, $db_pass, $gapp_name, $gapp_uid, $gapp_secret, $gapp_key,
	$mail_host, $mail_port, $mail_user, $mail_pass, $mail_footer){		
	$config = "<?php\n"
	. "date_default_timezone_set(\"UTC\");\n"
	. "ini_set(\"display_errors\", \"0\");\n"
	. "error_reporting(E_ALL | E_STRICT);\n"
	. "define(\"zuz_version\", \"1.2.3\");\n"
	. "define(\"baseurl\", \"".$baseuri."\");\n"
	. "define(\"page\", \"pages/\");\n"
	. "define(\"root\", $" . "_SERVER[\"DOCUMENT_ROOT\"].\"/\");\n"
	. "define(\"cookieurl\", \"".$basehost."\");\n"
	. "define(\"user_cookie\", \"_udata\");\n"
	. "define(\"ZUZAPP_KEY\", \"".$appKey."\");\n"
	. "define(\"ZUZAPP_SLUG\", \"".$appSlug."\");\n"
	. "define(\"admin_email\", \"".$adminEmail."\");\n"	
	. "define(\"MAIL_HOST\", \"".$mail_host."\");\n"
	. "define(\"MAIL_PORT\", ".$mail_port.");\n"
	. "define(\"MAIL_FROM\", \"".$mail_user."\");\n"
	. "define(\"MAIL_PASSWORD\", \"".$mail_pass."\");\n"
	. "define(\"MAIL_FOOTER\", \"".$mail_footer."\");\n"
	. "define(\"DB_HOST\", \"".$db_host."\");\n"
	. "define(\"DB_NAME\", \"".$db_name."\");\n"
	. "define(\"DB_USER\", \"".$db_user."\");\n"
	. "define(\"DB_PASS\", \"".$db_pass."\");\n"
	. "define(\"GOOGLE_DIR\", __DIR__ . \"/google/\");\n"
	. "define(\"GOOGLE_APP_NAME\", \"".$gapp_name."\");\n"
	. "define(\"GOOGLE_CLIENT_ID\", \"".$gapp_clientid."\");\n"
	. "define(\"GOOGLE_SECRET_KEY\", \"".$gapp_secret."\");\n"
	. "define(\"GOOGLE_API_KEY\", \"".$gapp_key."\");\n"
	. "define(\"ENCRYPTION_KEY\", \"".md5($appKey)."\");\n"
	. "define(\"SITE_TITLE\", \"".$siteName." - ".$siteSlogan."\");\n"
	. "define(\"SITE_NAME\", \"".$siteName."\");\n"
	. "define(\"SITE_SLOGAN\", \"".$siteSlogan."\");\n"
	. "$" . "page = isset($" . "_GET['page']) ? $" . "_GET['page'] : 'home';\n"
	. "$" . "curl = 'https://'.$" . "_SERVER['HTTP_HOST'].$" . "_SERVER['REQUEST_URI'];\n"
	. "require(__DIR__ .\"/browser.php\");\n"
	. "require(__DIR__ .\"/hashids.php\");\n"
	. "require(__DIR__ .\"/father.php\");\n"
	. "require(__DIR__ .\"/zmusic.php\");\n"
	. "$" . "hash = new Hashids(ENCRYPTION_KEY, 10);\n"
	. "$" . "b = new Browser();\n"
	. "$" . "z = new zMusic();\n"
	. "$" . "session = $" . "z->user();\n"
	. "$" . "keywords = $" . "description = '';\n"
	. "if(!isset($" . "_COOKIE['_vlm'])) $" . "z->cookie('_vlm', 1, 365*7);\n"
	. "if(!isset($" . "_COOKIE['_loop'])) $" . "z->cookie('_loop', 1, 365*7);\n"
	. "if(!isset($" . "_COOKIE['_shfl'])) $" . "z->cookie('_shfl', 0, 365*7);\n"
	. "?>";				
	return $config;
}


$gapp_clientid = $adminEmail = $appSlug = $appKey = $siteName = $siteSlogan = "";
$db_host = "localhost"; $db_name = $db_user = $db_pass = "";
$gapp_name = $gapp_uid = $gapp_secret = $gapp_key = "";
$mail_host = $mail_port = $mail_user = $mail_pass = "";
$mail_footer = '&copy; '.date("Y").' ZMusic. All Rights Reserved.';

$_WRITE = false;
$_WRITTEN = true;
if(isset($_POST['_savenewconfig'])){
	
	$gapp_clientid = $_POST['gappclientid'];
	$adminEmail = $_POST['adminmail'];
	$appSlug = $_POST['_slug'];
	$appKey = $_POST['_key'];
	$siteName = $_POST['_title'];
	$siteSlogan = $_POST['_slogan'];	
	
	$db_host = $_POST['_dbhost'];
	$db_name = $_POST['_dbname'];
	$db_user = $_POST['_dbuser'];
	$db_pass = $_POST['_dbpass'];	
	
	$gapp_name = $_POST['_gapp_name'];	
	$gapp_secret = $_POST['_gapp_secret'];
	$gapp_key = $_POST['_gapp_key'];	
	$gapp_uid = $_POST['_googleid'];
	
	$mail_host = $_POST['_mail_host'];
	$mail_port = $_POST['_mail_port'];
	$mail_user = $_POST['_mail_user'];
	$mail_pass = $_POST['_mail_pass'];
	$mail_footer = $_POST['_mail_footer'];
	
	$configFile = getConfigFile($baseuri, $basehost, $gapp_clientid, $adminEmail, $appSlug, $appKey, $siteName, $siteSlogan,
	$db_host, $db_name, $db_user, $db_pass, $gapp_name, $gapp_uid, $gapp_secret, $gapp_key,
	$mail_host, $mail_port, $mail_user, $mail_pass, $mail_footer);
	$fp = @fopen(__DIR__ . DIRECTORY_SEPARATOR . "/includes/config.php","wb");
	if($fp){				
		@fwrite($fp,$configFile);
		@fclose($fp);	
		$_WRITE = true;
		header("location: ".$baseuri."#step5"); exit;
	}				
}
?>
<form action="<?php echo $curl; if(strpos($curl, "?stp=step4b")==false){ echo '?stp=step4b'; } ?>" method="post" class="configform">	

<div class="frmTitles">
	<div class="frmt frmTitle1<?php echo $step!=1 ? ' hide' : ''; ?>"><h2 class="title">ZMusic Setup &ndash; Step 1 of 5</h2>
	<p class="welcome-info">Just fill in the information below and you'll be on your way.</p></div>
	<div class="frmt frmTitle2<?php echo $step!=2 ? ' hide' : ''; ?>"><h2 class="title">ZMusic Setup &ndash; Step 2 of 5</h2>
	<p class="welcome-info">Fill in database info.</p></div>
	<div class="frmt frmTitle3<?php echo $step!=3 ? ' hide' : ''; ?>"><h2 class="title">ZMusic Setup &ndash; Step 3 of 5</h2></div>
	<div class="frmt frmTitle4<?php echo $step!=4 ? ' hide' : ''; ?>"><h2 class="title">ZMusic Setup &ndash; Step 4 of 5</h2>	
	<p class="welcome-info">Fill in Email Server info.</p></div>
	<div class="frmt frmTitle4b hide"><h2 class="title">ZMusic Setup &ndash; Save Config File</h2></div>
	<div class="frmt frmTitle5<?php echo $step!=5 ? ' hide' : ''; ?>"><h2 class="title">ZMusic Setup &ndash; Step 5 of 5</h2></div>
</div>

<div class="frm frm1 rel<?php echo $step != 1 ? ' hide' : ''; ?>">		
	<div class="writeCheck">
		<?php 
			$_dirs = array(
				__DIR__ . '/assets/covers',
				__DIR__ . '/assets/dps',
				__DIR__ . '/assets/posters',
				__DIR__ . '/assets/temp',
				__DIR__ . '/assets/tracks'
			);
			$uls = '<ul class="chmod">';
			$errs = 0;
			for($n = 0; $n < count($_dirs); $n++):
				$cls = is_writeable($_dirs[$n]) ? '&#10004;' : '&times;';
				if(is_writeable($_dirs[$n])){
					$err = 'ok';					
				}else{ $err = 'nok'; $errs++; }
				$dr = str_replace(__DIR__, "", $_dirs[$n]);
				$uls .= '<li><div class="icn icn-'.$err.'"><div class="n">'.$cls.'</div></div>'.$dr.'</li>';
			endfor;			
			$uls .= '</ul>';
			if($errs>0){ echo '<div class="errorNote">These directories should have 0777 Permission.</div>'; }
			echo $uls;
			if($errs==0){
				echo 'All Required Directories are writeable :) <a href="javascript:;" class="gotoFromChmod"><b>Continue</b></a>';
			}else{
				echo 'Required Directories are not writeable :( <a href="'.$curl.'"><b>Check Again</b></a>';
			}
		?>		
	</div>
	<div class="afterWriteCheck hide">
		<input type="text" value="<?php echo $gapp_clientid; ?>" placeholder="Google App Client ID" name="gappclientid" class="anim iput iputb gappClient" style="margin-bottom:0px;">
		<div class="imsg gappconn">
			<a href="javascript:;" class="connectGapp">Connect Google App</a>
			<h2 class="gappMsg">If you haven't created Google App Yet; <a href="https://console.developers.google.com/apis/dashboard" target="_blank" class="lnk">Goto Google App Console</a></h2>
			<h2 class="lod hide"></h2>
		</div>
	</div>
	<div class="afterGapp hide">
		<input type="text" value="<?php echo $adminEmail; ?>" placeholder="Gmail Address" name="adminmail" class="anim iput iputb _gmail">		
		<h2 class="imsg">This will be your admin account</h2>
		<input type="text" value="<?php echo $appSlug; ?>" placeholder="Zuz App Slug" name="_slug" class="anim iput iputb _zslug">
		<input type="text" value="<?php echo $appKey; ?>" placeholder="Zuz Api Key" name="_key" class="anim iput iputb _zkey">
		<h2 class="imsg">If you don't have Zuz Api Key; <a href="https://zuz.host/api" target="_blank" class="lnk">Goto Zuz Api Console</a></h2>
		<input type="text" value="<?php echo $siteName; ?>" placeholder="Site Title" name="_title" class="anim iput iputb _ztitle">
		<input type="text" value="<?php echo $siteSlogan; ?>" placeholder="Site Tag line" name="_slogan" class="anim iput iputb _zslogan">			
		<input type="button" value="Continue" class="anim ibtn goto-step2">
	</div>
</div>

<div class="frm frm2 rel<?php echo $step != 2 ? ' hide' : ''; ?>">	
	<div class="covr covr2 hide"></div>
	<input type="text" value="<?php echo $db_host; ?>" placeholder="Database Host" name="_dbhost" class="anim iput iputb dbhost">
	<input type="text" value="<?php echo $db_name; ?>" placeholder="Database Name" name="_dbname" class="anim iput iputb dbname">
	<input type="text" value="<?php echo $db_user; ?>" placeholder="Database Username" name="_dbuser" class="anim iput iputb dbuser">
	<input type="text" value="<?php echo $db_pass; ?>" placeholder="Database Password" name="_dbpass" class="anim iput iputb dbpass">	
	<input type="button" value="Back" class="anim ibtn goto-back" step="1"><input type="button" value="Connect Database" class="anim ibtn goto-step3">
</div>

<div class="frm frm3 rel<?php echo $step != 3 ? ' hide' : ''; ?>">	
	<div class="covr covr3 hide"></div>
	<h2 class="title">Google App Info</h2>
	<h2 class="imsg">If you haven't created Google App Yet; <a href="https://console.developers.google.com/apis/dashboard" target="_blank" class="lnk">Goto Google App Console</a></h2>
	<input type="text" value="<?php echo $gapp_name; ?>" placeholder="Google App Name" name="_gapp_name" class="anim iput iputb gappName">	
	<input type="text" value="<?php echo $gapp_secret; ?>" placeholder="Google App Secret" name="_gapp_secret" class="anim iput iputb gappSecret">
	<input type="text" value="<?php echo $gapp_key; ?>" placeholder="Google App Key" name="_gapp_key" class="anim iput iputb gappKey">	
	<input type="button" value="Back" class="anim ibtn goto-back" step="2"><input type="button" value="Continue" class="anim ibtn goto-step4">
</div>

<div class="frm frm4 rel<?php echo $step != 4 ? ' hide' : ''; ?>">	
	<div class="covr covr4 hide"></div>
	<h2 class="title">Email Server Info</h2>
	<h2 class="imsg">*Email server required to send emails</h2>
	<input type="text" value="<?php echo $mail_host; ?>" placeholder="Email Server e.g: mail.example.com" name="_mail_host" class="anim iput iputb mail_host">
	<input type="text" value="<?php echo $mail_port; ?>" placeholder="Email Server Port e.g: 465" name="_mail_port" class="anim iput iputb mail_port">
	<input type="text" value="<?php echo $mail_user; ?>" placeholder="Email Username e.g: no-reply@example.com" name="_mail_user" class="anim iput iputb mail_user">
	<input type="text" value="<?php echo $mail_pass; ?>" placeholder="Email Password" name="_mail_pass" class="anim iput iputb mail_pass">	
	<input type="text" value="<?php echo $mail_footer; ?>" placeholder="Email Footer" name="_mail_footer" class="anim iput iputb mail_footer">	
	<input type="button" value="Back" class="anim ibtn goto-back" step="3"><input type="submit" name="_savenewconfig" value="Continue" class="anim ibtn goto-step5">
</div>

<div class="frm frm5 rel<?php echo $step != 5 ? ' hide' : ''; ?>">	
	<div class="covr covr5 hide"></div>
	<div class="install-ok">
		<svg class="checkmark" style="width:75px;height:75px;" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 52">
			<circle class="checkmark__circle" cx="26" cy="26" r="25" fill="none"/>
			<path class="checkmark__check" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"/>
		</svg>
		<h2 class="install-done">ZMusic Installed Successfully.</h2>
		<h2 class="install-done">Please remove `<b>__installer.php</b>` from ROOT Directory.</h2>
		<div class="continue-link"><a href="<?php echo $baseuri; ?>" class="lnk">Click to Continue</a></div>
	</div>
</div>
<input type="hidden" value="<?php echo $gapp_uid; ?>" name="_googleid">
</form>

<?php
$writeLbl = 'write';
if(isset($_POST['validateconfig'])){
	$configFile = $_POST['configtxt'];
	$writeLbl = 'find';
	if(file_exists(__DIR__ . DIRECTORY_SEPARATOR . 'includes/config.php')){
		header("location: ".$baseuri."?stp=step5"); exit;
	}
}
?>
<form action="" method="post">	
<div class="frm frmConfig rel hide">
	<h2 class="install-pending">Sorry, but I can't <?php echo $writeLbl; ?> the `<b>config.php</b>` file.</h2>
	<h2 class="install-pending">Create `<b>config.php</b>` file inside `<b><?php echo __DIR__ . DIRECTORY_SEPARATOR . 'includes/'; ?></b>` and paste the following text into it.</h2>
	<h2 class="install-pending">After yo've done that, Click `<b>Continue</b>`.</h2>
	<textarea class="configText" name="configtxt" readonly="readonly"><?php echo $configFile; ?></textarea>
	<input type="submit" name="validateconfig" value="Continue" class="anim ibtn checkconfigfile">
</div>
</form>


</div>

<div class="toast fixed"></div>
<style>
.anim{transition: all 0.2s linear 0s;}
ul, ol{list-style:none;margin:0px;padding:0px;}
p, h1, h2{margin:0px;padding:0px;font-size:13px;font-weight:normal;}
.hide{display:none;}
.rel{position: relative;}
a{
	color: #0070ff;
    text-decoration: none;
}
a:hover{
	text-decoration:underline;
}
.errorNote{
	background: #d63d3d;
    text-align: center;
    padding: 10px;
    color: #fff;
	border-radius:2px;
	margin-bottom: 5px;
	font-size: 15px;
}
body{
	background: #e6e6e6;
	font-family: segoe ui, arial, tahoma, sans-serif;
	padding: 0px;
	margin: 0px;
	font-size:13px;
}
.zuz-logo{
	display: block;
    margin: 0 auto;
    width: 120px;
    height: 120px;
    margin-top: 40px;
}
.wrap{
	margin: 0 auto;
    width: 650px;    
}
.frm{
	background: #fff;
    margin-top: 20px;
    margin-bottom: 50px;
    padding: 40px;
    box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.05);
    line-height: 1;
    font-size: 24px;
    border-radius: 3px;
    font-weight: lighter;
    box-sizing: border-box;
}
.frm .covr{
	top: 0px;
    left: 0px;
    right: 0px;
    bottom: 0px;
    z-index: 2;
    background: rgba(255,255,255, 0.9);
    position: absolute;
    border-radius: 2px;
}
.frm .covr .lod{
	top: 50%;
	left: 50%;
	transform: translate(-50%, -50%);
	position: absolute;
}
.steps{
	width: 100%;
    border-bottom: 1px #cacaca solid;
    text-align: center;
    margin-bottom: 60px;
    margin-top: 40px;
}
.steps li{
	text-align: center;
    background: #e6e6e6;
    line-height: 1;
    padding: 5px;
    border-radius: 200px;
    width: 100px;
    height: 50px;
    box-sizing: border-box;
    bottom: -30px;
    display: inline;
    display: inline-block;
    vertical-align: top;
    margin: 0px 10px -24px 10px;
    color: #999;
    border: 1px #cacaca solid;
    font-size: 10px;
}
.steps li h2{font-size: 25px;}
.steps li.on{
	background: #4094ff;
    border: 0px;
    color: #fff;
}
.steps li.ok{
    background: #74bb40;
    color: #fff;
    border: 1px #74bb40 solid;
}
.wrap .title{
	font-size: 24px;
    color: #333;
}
.wrap .welcome-info{
	margin: 5px 0px;
    font-size: 15px;
    color: #333;
}
.wrap .iput{
	width: 100%;
    box-sizing: border-box;
    padding: 12px;
    border-radius: 2px;
    border: 1px #bdbdbd solid;
    margin: 10px 0px;
    outline: none;
    box-shadow: 0px 1px 1px #e6e6e6;
	font-family: segoe ui;
    font-size: 15px;
}
.wrap .iput:focus{border: 1px #4094ff solid;}
.wrap .imsg{margin-bottom: 15px;}
.wrap .ibtn{
	line-height: 1;
    padding: 10px 20px;
    margin-top: 5px;
    border-radius: 2px;
    background: #2485ff;
    color: #fff;
    box-shadow: 0px 1px 1px #b1b1b1;
    font-family: segoe ui;
    font-size: 14px;
    border: 1px #005fd8 solid;
    margin-right: 10px;
    cursor: pointer;
}
.wrap .ibtn:hover{background: #3a91ff;}
.frm .title{
	margin-bottom: 10px;
    font-size: 20px;
}
.install-ok{
	font-size: 15px;
    margin: 4px 0px;
}
.install-ok .install-done{
	text-align: center;
    font-size: 16px;
    margin: 5px 0px;
}
.install-ok .config-php{
	width: 100%;
    border: 1px #ddd solid;
    height: 530px;
    padding: 15px;
    box-sizing: border-box;
    margin: 20px 0px;
    border-radius: 2px;
	outline: none;
    resize: inherit;
	font-size:15px;
    font-family: Courier;
}
.install-ok .install-pending{
	font-size: 15px;
    margin: 4px 0px;
}
.continue-link{
	text-align: center;
    margin-top: 30px;
}
.continue-link a{font-weight:bold;}
.checkmark__circle {
  stroke-dasharray: 166;
  stroke-dashoffset: 166;
  stroke-width: 2;
  stroke-miterlimit: 10;
  stroke: #7ac142;
  fill: none;
  animation: stroke 0.6s cubic-bezier(0.65, 0, 0.45, 1) forwards;
}

.checkmark {
  width: 56px;
  height: 56px;
  border-radius: 50%;
  display: block;
  stroke-width: 2;
  stroke: #fff;
  stroke-miterlimit: 10;
  margin: 10% auto;
  box-shadow: inset 0px 0px 0px #7ac142;
  animation: fill .4s ease-in-out .4s forwards, scale .3s ease-in-out .9s both;
}

.checkmark__check {
  transform-origin: 50% 50%;
  stroke-dasharray: 48;
  stroke-dashoffset: 48;
  animation: stroke 0.3s cubic-bezier(0.65, 0, 0.45, 1) 0.8s forwards;
}

@keyframes stroke {
  100% {
    stroke-dashoffset: 0;
  }
}
@keyframes scale {
  0%, 100% {
    transform: none;
  }
  50% {
    transform: scale3d(1.1, 1.1, 1);
  }
}
@keyframes fill {
  100% {
    box-shadow: inset 0px 0px 0px 200px #7ac142;
  }
}
.spinner-container {
	-webkit-animation: rotate 2s linear infinite;
    animation: rotate 2s linear infinite;
    z-index: 2;
}
.spinner-container .path {
    stroke-dasharray: 1,150; /* 1%, 101% circumference */
    stroke-dashoffset: 0;
    stroke: rgb(86, 86, 86);
    stroke-linecap: round;
    -webkit-animation: dash 1.5s ease-in-out infinite;
    animation: dash 1.5s ease-in-out infinite;
}
.spinner-container .xpath {
	stroke: rgba(255, 255, 255, 0.75);
}
@keyframes rotate {
   100% { transform: rotate(360deg); }
}
@-webkit-keyframes rotate{
    100% { -webkit-transform: rotate(360deg); }
}
@keyframes dash {
    0% {
        stroke-dasharray: 1,150;  /* 1%, 101% circumference */
        stroke-dashoffset: 0;
    }
    50% {
       stroke-dasharray: 90,150; /* 70%, 101% circumference */
       stroke-dashoffset: -35;   /* 25% circumference */
    }
    100% {
        stroke-dasharray: 90,150; /* 70%, 101% circumference */
        stroke-dashoffset: -124;  /* -99% circumference */
    }
}
@-webkit-keyframes dash {
    0% {
        stroke-dasharray: 1,150;  /* 1%, 101% circumference */
        stroke-dashoffset: 0;
    }
    50% {
        stroke-dasharray: 90,150; /* 70%, 101% circumference */
        stroke-dashoffset: -35;   /* 25% circumference */
    }
   100% {
        stroke-dasharray: 90,150; /* 70%, 101% circumference */
        stroke-dashoffset: -124;  /* -99% circumference */
    }
}
.frmTitles{text-align:center;}
.toast{
	background: #2b2b2b;
    z-index: 9999999;
    color: #fff;
    bottom: 20px;
    left: 20px;
    line-height: 1;
    padding: 8px 14px;
    border-radius: 2px;
    display: none;
    position: fixed;
}
.singo{display:none;}
.singo a{
	font-size: 14px;
    font-weight: bold;
}
.singo h2{margin-top: 5px;}
#SenseWithGoogle, .connectGapp{
	font-size: 14px;
    font-weight: bold;
}
.gappconn .lod{
	font-size: 14px;
    font-family: segoe ui;
	margin-top: 5px;
}
.gappMsg{margin-top: 5px;}
.frmConfig{}
.frmConfig .configText{
	width: 100%;
    box-sizing: border-box;
    padding: 12px;
    border-radius: 2px;
    border: 1px #bdbdbd solid;
    margin: 10px 0px;
    outline: none;
    box-shadow: 0px 1px 1px #e6e6e6;
    font-family: segoe ui;
    font-size: 15px;
    height: 750px;
}
.writeCheck{font-size: 16px;}
.chmod{font-size: 18px;margin-bottom: 30px;}
.chmod li{
	margin: 10px 0px;
    background: #eaeaea;
    padding: 10px 50px;
    border-radius: 2px;
	position: relative;
}
.chmod li .icn{
	display: inline;
    display: inline-block;
    background: #eee;
    line-height: 1;
    font-size: 14px;
    border-radius: 2px 0px 0px 2px;
    width: 38px;
    box-sizing: border-box;
    margin-right: 5px;
    position: absolute;
    vertical-align: bottom;
    top: 0px;
    left: 0px;
    right: 0px;
    bottom: 0px;
}
.chmod li .icn .n{
	position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}
.chmod li .icn-ok{
	background: #2ace5e;
    color: #fff;
}
.chmod li .icn-nok{
	background: #d63d3d;
	color: #fff;
}
.chmod li .icn-nok .n{font-size:28px;}
</style>
<script src="//apis.google.com/js/platform.js" async defer></script>
<script src="./js/jq.js"></script>
<script src="./js/core.js"></script>
<script>
function OnGoogleLoad(){
	if(typeof gapi != 'undefined'){
		gapi.load('auth2', function(){
			auth2 = gapi.auth2.init({
				client_id: $(".gappClient").val(),
				cookiepolicy: 'single_host_origin', fetch_basic_profile: true, scope: 'profile'				
			});
			auth2.then(function(){				
				$(".gappconn .lod").html('This account will be your admin account');				
				$(".gappconn a").attr("id", "SenseWithGoogle").html("Sign in to Google").removeClass("connectGapp").show();											
				auth2.attachClickHandler(document.getElementById('SenseWithGoogle'), {}, function(googleUser){						
					var gool = googleUser.getBasicProfile();							
					$("._gmail").val(gool.getEmail()).attr("value", gool.getEmail()).attr({
						gid: gool.getId(),
						uname: gool.getName()
					});			
					$("._googleid").val(gool.getId());
					$(".gappconn").hide();
					$(".afterGapp").show();
					$(".gappClient, ._gmail").removeAttr("disabled");
				}, function(error) {  });
			}, function(e){				
				$(".gappconn a").show();
				$(".gappconn .lod").hide();
				toast(e.details, 10);
				console.log(this);
			});				
		});
	}
}
function addEvent(event, elem, callback){ $("body, document").on(event, elem, callback); };
function loading(w,b){ return '<svg class="spinner-container" style="width:'+w+'px;height:'+w+'px;" viewBox="0 0 44 44" data-reactid=".0.1.0"><circle class="path" cx="22" cy="22" r="20" fill="none" stroke-width="'+b+'" data-reactid=".0.1.0.0"></circle></svg>'; }
function post(uri, vars, success, error, tout){	
	xhr = $.ajax({ type: "POST", url: uri, data: vars, success: success, error: error, timeout: tout });
};
var xhr, tost; function toast(msg, tout, ico){
	clearTimeout(tost)
	$(".toast").html(msg);
	$("div.toast").show().transition({ y: '-25px' }).transition({ y: '0px' });
	if(tout>0){ tost = setTimeout(function(){ $("div.toast").transition({ y: '100px' }).fadeOut(400); }, tout * 1000); }
}
$(document).ready(function(){
	var hash = window.location.hash;
	if(hash!=""){ hash = hash.replace("#", ""); }
	switch(hash){
		case "step2":
			$(".frmTitle").hide();
			$(".frmTitle2").show();
			$(".steps .stp1").addClass("ok");
			$(".steps .stp2").addClass("on");
			$(".frm").hide();
			$(".frm2").show();
		break;
		case "step3":
			$(".frmTitle").hide();
			$(".frmTitle3").show();
			$(".steps .stp1, .steps .stp2").addClass("ok");
			$(".steps .stp3").addClass("on");
			$(".frm").hide();
			$(".frm3").show();
		break;
		case "step4":
			$(".frmTitle").hide();
			$(".frmTitle4").show();
			$(".steps .stp1, .steps .stp2, .steps .stp3").addClass("ok");
			$(".steps .stp4").addClass("on");
			$(".frm").hide();
			$(".frm4").show();
		break;
		case "step4b":
			$(".frmTitle").hide();
			$(".frmTitle4b").show();
			$(".steps .stp1, .steps .stp2, .steps .stp3, .steps .stp4").addClass("ok");
			$(".frm").hide();
			$(".frmConfig").show();
		break;
	}
	if(window.location.search=="?stp=step4b"){
		$(".frmt").hide();
		$(".frmTitle4b").show();
		$(".steps .stp1, .steps .stp2, .steps .stp3, .steps .stp4").addClass("ok");
		$(".frm").hide();
		$(".frmConfig").show();	
	}else if(window.location.search=="?stp=step5"){
		$(".frmt").hide();
		$(".frmTitle5").show();
		$(".steps .stp1, .steps .stp2, .steps .stp3, .steps .stp4, .steps .stp5").addClass("ok");
		$(".frm").hide();
		$(".frm5").show();	
	}
});
addEvent("click", ".connectGapp", function(){
	var gappClient = $(".gappClient").val();
	if(gappClient==""){
		toast("Enter valid Google Client ID", 6);
		$(".gappClient").focus();
	}else{
		$(".gappconn a, .gappMsg").hide();
		$(".gappconn .lod").html("Please wait...").show();
		OnGoogleLoad();
	}
});
addEvent("click", ".gotoFromChmod", function(){
	$(".writeCheck").hide();
	$(".afterWriteCheck").show();
});
addEvent("click", ".goto-step2", function(){
	var slug = $("._zslug").val(), key = $("._zkey").val(),
	title = $("._ztitle").val(), slogan = $("._zslogan").val(),
	gappClient = $(".gappClient").val(), gmail = $("._zemail").val(),
	gid = $("._zemail").attr("gid"), uname = $("._zemail").attr("uname");
	if(slug==""){
		toast("Zuz App Slug should not be empty...", 6);
		$("._zslug").focus();
	}else if(key==""){
		toast("Zuz App Key should not be empty...", 6);
		$("._zkey").focus();
	}else if(title==""){
		toast("Site Title should not be empty...", 6);
		$("._ztitle").focus();
	}else if(slogan==""){
		toast("Site Tag line should not be empty...", 6);
		$("._zslogan").focus();
	}else if(gmail=="" || gappClient=="" || gid==""){
		$(".gappClient").removeAttr("disabled");
		$(".gappconn .lod").html('Either Google Client ID or Email Address is Missing');
		$(".gappconn a").removeAttr("id").html("Connect Google App").addClass("connectGapp").show();														
	}else{
		window.location.hash = "step2";
		$(".steps .stp1").removeClass("on").addClass("ok");
		$(".steps .stp2").addClass('on');
		$(".frmTitles .frmt").hide();
		$(".frmTitles .frmTitle2").show();
		$(".frm").hide();
		$(".frm2").show();
	}
});
addEvent("click", ".goto-back", function(){
	var ID = $(this).attr("step");
	$(".steps .stp").removeClass("on ok");
	for(var n = 1; n < parseInt(ID); n++){
		$(".steps .stp"+n).addClass('ok');
	}
	$(".steps .stp"+ID).addClass('on');
	$(".frmTitles .frmt").hide();
	$(".frmTitles .frmTitle"+ID).show();
	$(".frm, .frm .covr").hide();
	$(".frm"+ID).show();
	window.location.hash = "step"+ID;
});
addEvent("click", ".goto-step3", function(){
	window.location.hash = "step3";
	var dbhost = $(".dbhost").val(), dbname = $(".dbname").val(),
	dbuser = $(".dbuser").val(), dbpass = $(".dbpass").val();
	if(dbhost==""){
		toast("Database host should not be empty...", 6);
		$(".dbhost").focus();
	}else if(dbname==""){
		toast("Database name should not be empty...", 6);
		$(".dbname").focus();
	}else if(dbuser==""){
		toast("Database Username should not be empty...", 6);
		$(".dbuser").focus();
	}else if(dbpass==""){
		toast("Database Password should not be empty...", 6);
		$(".dbpass").focus();
	}else{
		$(".frm2 .covr").html('<div class="lod">'+loading(50, 2)+'</div>').show();
		post(window.location.href, 'action=stepdb&key='+$("._zkey").val()+'&gid='+$("._gmail").attr("gid")+'&uname='+$("._gmail").attr("uname")+'&umail='+$("._gmail").val()+'&stitle='+encodeURIComponent($("._ztitle").val())+'&slogan='+$("._zslogan").val()+'&host='+dbhost+'&name='+dbname+'&user='+dbuser+'&pass='+encodeURIComponent(dbpass), function(resp){
			toast(resp.message, 6);
			if(resp.result=="ok"){
				$(".steps .stp2").removeClass("on").addClass("ok");
				$(".steps .stp3").addClass('on');
				$(".frmTitles .frmt").hide();
				$(".frmTitles .frmTitle3").show();
				$(".frm").hide();
				$(".frm3").show();
			}else{
				$(".frm2 .covr").hide();				
			}
		}, function(){
			$(".frm2 .covr").hide();
			toast("Unable to connect to server...", 6);
		});
	}
});
addEvent("click", ".goto-step4", function(){
	window.location.hash = "step4";
	var name = $(".gappName").val(), secret = $(".gappSecret").val(),
	key = $(".gappKey").val();
	if(name==""){
		toast("Google App Name should not be empty...", 6);
		$(".gappName").focus();
	}else if(secret==""){
		toast("Google App Secret should not be empty...", 6);
		$(".gappSecret").focus();
	}else if(key==""){
		toast("Google App Key should not be empty...", 6);
		$(".gappKey").focus();
	}else{
		$(".steps .stp3").removeClass("on").addClass("ok");
		$(".steps .stp4").addClass('on');
		$(".frmTitles .frmt").hide();
		$(".frmTitles .frmTitle4").show();
		$(".frm").hide();
		$(".frm4").show();
	}
});
addEvent("click", ".goto-step5", function(e){
	window.location.hash = "step4b";
	var host = $(".mail_host").val(), port = $(".mail_port").val(),
	user = $(".mail_user").val(), pass = $(".mail_pass").val(),
	footer = $(".mail_footer").val();
	if(host==""){
		toast("Email server should not be empty...", 6);
		$(".mail_host").focus(); return false;
	}else if(port==""){
		toast("Email server port should not be empty...", 6);
		$(".mail_port").focus(); return false;
	}else if(user==""){
		toast("Email server username should not be empty...", 6);
		$(".mail_user").focus(); return false;
	}else if(pass==""){
		toast("Email server password should not be empty...", 6);
		$(".mail_pass").focus(); return false;
	}else if(footer==""){
		toast("Email footer should not be empty...", 6);
		$(".mail_footer").focus(); return false;
	}else{
		$(".steps .stp4").removeClass("on").addClass("ok");
		$(".frm4 .covr").show();		
		$(".configForm").submit();
	}
});
addEvent("click", ".configText", function(){ $(this).select(); });
addEvent("click", ".checkconfigfile", function(){ $(".configform").submit(); });
</script>