<?php

namespace Database\Seeders;

use Botble\Base\Supports\BaseSeeder;
use Botble\Contact\Enums\ContactStatusEnum;
use Botble\Contact\Models\Contact;
use Faker\Factory;

class ContactSeeder extends BaseSeeder
{
    public function run(): void
    {
        $faker = Factory::create();

        Contact::query()->truncate();

        for ($i = 0; $i < 10; $i++) {
            Contact::query()->create([
                'name' => $faker->name,
                'email' => $faker->safeEmail,
                'phone' => $faker->phoneNumber,
                'address' => $faker->address,
                'subject' => $faker->text(50),
                'content' => $faker->text(500),
                'status' => $faker->randomElement([ContactStatusEnum::READ, ContactStatusEnum::UNREAD]),
            ]);
        }
    }
}
