<?php 
	include("includes/loader.php");
	include("includes/logoutHandler.php"); 
	include("includes/functions.php"); 
	include("tpl/header.php"); 
	include("tpl/nav.php"); 
?>
	    
    <!-- MAIN -->
    <div id="main">
    	
        <!-- Breadcrumb -->
		<?php breadcrumb('Users'); ?>
        <!-- // Breadcrumb -->
        
        <!-- container -->
        <div class="container bg">
        	
            <!-- row -->
            <div class="row">
            	
                <div class="col-md-3 ps-0"><!-- col-md-3 -->
					<?php include_once('tpl/sidebar.php'); ?>
				</div><!-- // col-md-3 -->
                
                <div class="col-md-9 pe-0"><!-- col-md-9 -->
					<div class="pagetitle">
						<h2>Users</h2>
					</div>
					
					<!-- MAIN CONTENT -->
					<div id="main-content">
						
						<div class="notice_messages"></div>
						
						<div class="box">
							<div class="header">
								<h4 class="pad20">
									Users
									<a class="btn btn-sm btn-primary float-end" href="#addUser" data-bs-toggle="modal" data-original-title="Add User">Add User</a>
								</h4>
							</div>
							<div class="content">
								<?php if($user->count_users() > 0) { ?>
								<table class="table bt-dataTable" id="dataTable">
									<thead>
										<tr>
											<th>#</th>
											<th>Username</th>
											<th>First Name</th>
											<th>Last Name</th>
											<th>Role</th>
											<th>Actions</th>
										</tr>
									</thead>
									<tbody>
										<?php foreach($user->list_users() as $v) { ?>
										<tr>
											<td><?php echo $v['id']; ?></td>
											<td><a href="profile.php?id=<?php echo intval($v['id']); ?>" title="View Profile"><?php echo $v['username']; ?></a></td>
											<td><?php echo $v['first_name']; ?></td>
											<td><?php echo $v['last_name']; ?></td>
											<td><?php echo $v['role']; ?></td>
											<td>
												<ul class="table-actions">
													<li><a href="profile.php?id=<?php echo intval($v['id']); ?>" title="Edit User"><i class="bi bi-pencil-fill"></i></a></li>
													<?php if($v['id'] !== $_SESSION['mySurvey_userid']) { ?>
													<li><a href="javascript:void(0);" title="Remove User" id="removeUser" data-id="<?php echo intval($v['id']); ?>" data-username="<?php echo $v['username']; ?>"><i class="bi bi-trash-fill"></i></a></li>
													<?php } ?>
												</ul>
											</td>
										</tr>
										<?php } ?>
									</tbody>
								</table>
								<?php } else { ?>
								<p class="pad20">No Users found</p>
								<p class="pad20">There are no users to manage. First you need to <a href="create_user.php">create a user</a></p>
								<?php } ?>
							</div>
						</div>

						<div id="addUser" class="modal fade">
							<div class="modal-dialog">
								<div class="modal-content">
									<div class="modal-header">
										<h3 class="modal-title">Add User</h3>
										<button type="button" class="btn-close" data-dismiss="modal" aria-label="Close"></button>
									</div>
									<form id="add-user" class="margin-reset" method="post">
										<div class="modal-body">
											<div class="notice_messages"></div>
											<div class="row mb-3">
												<label for="username" class="col-3 col-form-label">Username:</label>
												<div class="col-9">
													<input type="text" name="username" id="username" class="form-control">
												</div>
											</div>
											<div class="row mb-3">
												<label for="first_name" class="col-3 col-form-label">First Name:</label>
												<div class="col-9">
													<input type="text" name="first_name" id="first_name" class="form-control">
												</div>
											</div>
											<div class="row mb-3">
												<label for="last_name" class="col-3 col-form-label">Last Name:</label>
												<div class="col-9">
													<input type="text" name="last_name" id="last_name" class="form-control">
												</div>
											</div>
											<div class="row mb-3">
												<label for="email" class="col-3 col-form-label">Email:</label>
												<div class="col-9">
													<input type="text" name="email" id="email" class="form-control">
												</div>
											</div>
											<div class="row mb-3">
												<label for="password" class="col-3 col-form-label">Password:</label>
												<div class="col-9">
													<input type="password" name="password" id="password" class="form-control">
													<p class="form-text">Hint: Minimum 6 characters</p>
												</div>
											</div>
											<div class="row mb-3">
												<label for="confirm_password" class="col-3 col-form-label">Confirm Password:</label>
												<div class="col-9">
													<input type="password" name="confirm_password" id="confirm_password" class="form-control">
													<p class="form-text" id="pmessage"></p>
												</div>
											</div>
											<div class="row mb-3">
												<label for="role" class="col-3 col-form-label">Role:</label>
												<div class="col-9">
													<select name="role" id="role" class="form-select">
														<option value="Admin">Admin</option>
														<option value="Pollster">Pollster</option>
													</select>
												</div>
											</div>
										</div>
										<div class="modal-footer">
											<input type="hidden" name="action" value="add">
											<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
											<button type="submit" name="add-user" data-option="add-user" disabled class="btn btn-success add-user-btn">Add User</button>
										</div>
									</form>
								</div>
							</div>
						</div>
						
					</div>
					<!-- // MAIN CONTENT -->
				</div>
				<!-- // col-md-9 -->
 
            </div>
            <!-- // row -->
        </div>
        <!-- // container -->
    </div>
    <!-- // MAIN --> 
    
    <?php include("tpl/footer.php"); ?>

