<?php 
	include("includes/loader.php");
	include("includes/logoutHandler.php"); 
	include("includes/functions.php"); 
	include("tpl/header.php"); 
	include("tpl/nav.php"); 
?>

    <!-- MAIN -->
    <div id="main">
    	
		<!-- Breadcrumb -->
		<?php breadcrumb('Survey Statistics'); ?>
        <!-- // Breadcrumb -->
        
        <!-- container -->
        <div class="container bg">
        	
            <!-- row -->
            <div class="row">
            	
                <div class="col-md-3 ps-0"><!-- col-md-3 -->
					<?php include_once('tpl/sidebar.php'); ?>
				</div><!-- // col-md-3 -->
                
                <div class="col-md-9 pe-0"><!-- col-md-9 -->  
					<div class="pagetitle">    
						<h2>Survey Statistics</h2>
					</div>

					<!-- MAIN CONTENT -->      
					<div id="main-content">

						<div class="notice_messages"></div>

						<div class="box">
							<div class="header"><h4>Surveys</h4></div> 
							<div class="content">
							<?php if($survey->listSurveys() == true) { ?>
							<table class="table bt-dataTable" id="dataTable">
								<thead>
									<tr>
										<th>#</th>
										<th>Survey</th>
										<th>Number of questions</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach($survey->listSurveys() as $v) { ?>
									<tr>
										<td class="w-30"><?php echo $v['survey_ID']; ?></td>
										<td><a href="statistics.php?id=<?php echo $v['survey_ID']; ?>" title="View Survey"><?php echo $v['name']; ?></a></td>
										<td class="w-130"><?php echo $survey->get_number_of_questions($v['survey_ID']); ?></td>
									</tr>	
									<?php } ?>
								</tbody>
							</table>  
							<?php } else { ?>
								<p class="pad20 pb-0 mb-0">No Surveys found</p>
								<p class="pad20">There are no surveys to manage. First, you need to <a href="create_survey.php">create a survey</a></p>
							<?php } ?>                            
							</div>
						</div>

					</div>
					<!-- // MAIN CONTENT -->
				</div>
				<!-- // col-md-9 -->

            </div>
            <!-- // row -->
        </div>
        <!-- // container -->
    </div>
    <!-- // MAIN --> 
    
    <?php include("tpl/footer.php"); ?>

