<?php
	session_start();
	include('includes/connection.php');
	include('includes/survey.php');

	$survey = new mySurvey(DB_HOST, DB_USERNAME, DB_PASSWORD, DATABASE, TABLE);
	//array_pop($_POST); // - for PHP debug (Clean submit data)	
	$survey_id = array_pop($_POST);
	$page = array_pop($_POST);
	$total_results = array_pop($_POST);
	$last_page = array_pop($_POST);
	
	$client_ip = $survey->get_client_ip();
	
	$all_keys = array_keys($_POST);
	
	// Extract question ids from the  keys
	$buffer = '';
	foreach($all_keys as $key) 
	{
		$buffer .= $key . '/';
	}
	
	preg_match_all("/\((\d+)\)/", $buffer, $matches, PREG_PATTERN_ORDER); 
	$q_ids = $matches[1];
	
	// If survey continues or no
	if($last_page == "true")
	{
		$page = 0;
	}

	if(isset($_POST))
	{
		$total = count($_POST);
		$z = 0; // $x = '';
		for($i = 0; $i <= $total-1; $i++)
		{	$z++;  // $x .= ''; $x .= ' / '; echo $x; print_r($_POST); // - for PHP debug
			switch($_POST)
			{
				// Matrix Single
				case isset($_POST['matrix_single-('.$q_ids[$i].')-'.(($q_ids[$i])+$z-1)]): 
					// save
					$survey->add_result($survey_id, $q_ids[$i], $_POST['matrix_single-('.$q_ids[$i].')-'.(($q_ids[$i])+$z-1)], 'matrix_single', $client_ip, $page);
				break;
				
				// Matrix Multi (array)
				case isset($_POST['matrix_multi_select-('.$q_ids[$i].')']): 
					$array = $_POST['matrix_multi_select-('.$q_ids[$i].')'];
					foreach($array as $v)
					{
						$survey->add_result($survey_id, $q_ids[$i], $v, 'matrix_multi_select', $client_ip, $page);	
					}
				break;
				
				// Checkbox (array)
				case isset($_POST['checkbox-('.$q_ids[$i].')']): 
					$array = $_POST['checkbox-('.$q_ids[$i].')'];
					foreach($array as $v)
					{
						$survey->add_result($survey_id, $q_ids[$i], $v, 'multiple_choice', $client_ip, $page);	
					}
				break;
				
				// Single
				case isset($_POST['single-('.$q_ids[$i].')']): 
					$survey->add_result($survey_id, $q_ids[$i], $_POST['single-('.$q_ids[$i].')'], 'single_text', $client_ip, $page);
				break;
				
				// Radio
				case isset($_POST['radio-('.$q_ids[$i].')']): 
					$survey->add_result($survey_id, $q_ids[$i], $_POST['radio-('.$q_ids[$i].')'], 'radio', $client_ip, $page);
				break;
				
				// Comment Box
				case isset($_POST['suggestion-('.$q_ids[$i].')']): 
					$survey->add_result($survey_id, $q_ids[$i], $_POST['suggestion-('.$q_ids[$i].')'], 'comment_box', $client_ip, $page);
				break;
				
				// Yes / No
				case isset($_POST['yes_no-('.$q_ids[$i].')']): 
					$survey->add_result($survey_id, $q_ids[$i], $_POST['yes_no-('.$q_ids[$i].')'], 'yes_no', $client_ip, $page);
				break;
				
				// Dropdown Menu
				case isset($_POST['dropdown_menu-('.$q_ids[$i].')']): 
					$survey->add_result($survey_id, $q_ids[$i], $_POST['dropdown_menu-('.$q_ids[$i].')'], 'dropdown_menu', $client_ip, $page);
				break;
			}				
		}
		
		if($last_page == "true")
		{
			if(!isset($_SESSION['mySurvey_authenticated']))
			{
				setcookie('user_completed_survey'.intval($survey_id), intval($survey_id), time() + (10 * 365 * 24 * 60 * 60)); // 10years
			}
			echo 'DONE';
		} else {
			echo 'takeSurvey.php?id='.intval($survey_id).'&page='.intval($page);
		}
		
	}

?>