<?php 
	include("includes/loader.php");
	include("includes/logoutHandler.php"); 
	include("includes/functions.php"); 
	include("tpl/header.php"); 
	include("tpl/nav.php"); 
	
	$id = intval($_GET['id']);
	if(!isset($id) || $id == 0)
	{
		header('Location: survey_statistics.php');
		exit();
	}
?>
        
    <!-- MAIN -->
    <div id="main">
    	
		<!-- Breadcrumb -->
		<?php breadcrumb(array(
			'dashboard.php' 	=> '<span class="bi bi-house-fill"></span>Dashboard',
			'survey_statistics.php' => 'Survey Statistics',
			'statistics.php' => 'Statistics',
		)); ?>
        <!-- // Breadcrumb -->
        
        <!-- container -->
        <div class="container bg">
        	
            <!-- row -->
            <div class="row">
            	
                <div class="col-md-3 ps-0"><!-- col-md-3 -->
					<?php include_once('tpl/sidebar.php'); ?>
				</div><!-- // col-md-3 -->
                
                <div class="col-md-9 pe-0"><!-- col-md-9 -->
					<div class="pagetitle">
						<?php if($survey->get_survey_info($id, 'name') == true) { ?>    
						<h2><?php echo $survey->get_survey_info($id, 'name'); ?></h2>
						<p>Statistics and results for survey: <?php echo $survey->get_survey_info($id, 'name'); ?></p>
						<?php 
							if($survey->check_reset_admin_IP($id)) {
								echo '<p><a href="#" class="survey-reset" id="'.$id.'">Reset took survey</a> for this survey</p>';	
							}
						} else {
							// not valid survey id and not valid id 
							header('Location: survey_statistics.php');
							exit();
						} ?>
					</div>
					<!-- MAIN CONTENT -->      
					<div id="main-content">

						<div class="notice_messages"></div>

						<!-- Quick Buttons -->
						<div class="quick-buttons">
							<div class="row">
								<div class="col-3">                    
									<div class="btn btn-light btn-block">
										<strong><?php echo $survey->counts('Surveys'); ?></strong>
										<span class="dasboard-icons-title">Surveys</span>
									</div>
								</div>
								<div class="col-3">                    
									<div class="btn btn-light btn-block">
										<strong><?php echo $survey->get_number_of_questions($id); ?></strong>
										<span class="dasboard-icons-title">Questions</span>
									</div> 
								</div> 
								<div class="col-3">                    
									<div class="btn btn-light btn-block">
										<strong><?php echo $survey->counts('Answers',  $id); ?></strong>
										<span class="dasboard-icons-title">Answers</span>
									</div>
								</div>                
								<div class="col-3">                    
									<div class="btn btn-light btn-block">
										<strong><?php echo $survey->counts('Took_Survey', $id); ?></strong>
										<span class="dasboard-icons-title">Entries</span>
									</div> 
								</div> 
							</div>
						</div>
						<!-- // Quick Buttons -->

						<div class="box">
							<div class="header"><h4>Questions</h4></div> 
							<div class="content">
							<?php if($survey->listQuestions($id) == true) { ?>
							<table class="table bt-dataTable" id="dataTable">
								<thead>
									<tr>
										<th>Fill</th>
										<th>Question</th>
										<th>Question Type</th>
									</tr>
								</thead>
								<tbody>
									<?php foreach($survey->listQuestions($id) as $v) { ?>
									<tr>
										<td class="w-30">
										<?php
										if($survey->results_exists($v['question_ID'])) {
											echo '<i class="bi bi-check"></i>';
										} else {
											echo '<i class="bi bi-x"></i>';
										}
										?>
										</td>
										<td><a href="statistic.php?id=<?php echo $v['question_ID']; ?>" title="View Answers"><?php echo $v['questions']; ?></a></td>
										<td class="w-130"><?php echo $survey->question_types[$v['question_type']]; ?></td>
									</tr>	
									<?php } ?>
								</tbody>
							</table>
							<?php } else { ?>
								<p class="pad20 pb-0 mb-0">No Questions found</p>
								<p class="pad20">There are no questions for this survey.</p>
							<?php } ?>                              
							</div>
						</div>

						<?php $_SESSION['survey_name'] = $survey->get_survey_info($id, 'name'); ?>

					</div>
					<!-- // MAIN CONTENT -->
				</div>
				<!-- // col-md-9 -->
	
            </div>
            <!-- // row -->
        </div>
        <!-- // container -->
    </div>
    <!-- // MAIN --> 
    
    <?php include("tpl/footer.php"); ?>

