<?php 
	include("includes/loader.php");
	include("includes/logoutHandler.php"); 
	include("includes/functions.php"); 
	include("tpl/header.php"); 
	include("tpl/nav.php"); 
	include("includes/geoiploc.php");
	
	$id = intval($_GET['id']);
	if(!isset($id) || $id == 0)
	{
		header('Location: survey_statistics.php');
		exit();
	}
	
	$raw = $survey->chart_data($id, $survey->find_question_type($id));
	$total = array_sum($survey->array_values_recursive($raw));
?>
        
    <!-- MAIN -->
    <div id="main">
    	
		<!-- Breadcrumb -->
		<?php 
		$questionsLink = 'statistics.php?id='.$survey->get_questions_info($id, 'survey_id');
		breadcrumb(array(
			'dashboard.php' 	=> '<span class="bi bi-house-fill"></span>Dashboard',
			'survey_statistics.php' => 'Survey Statistics',
			$questionsLink => 'Questions',
			'statistic.php' => 'Statistic',
		)); ?>
        <!-- // Breadcrumb -->
        
        <!-- container -->
        <div class="container bg">
        	
            <!-- row -->
            <div class="row">
            	
                <div class="col-md-3 ps-0"><!-- col-md-3 -->
					<?php include_once('tpl/sidebar.php'); ?>
				</div><!-- // col-md-3 -->
                
                <div class="col-md-9 pe-0"><!-- col-md-9 -->  
					<div class="pagetitle">
						<?php if($survey->get_questions_info($id, 'questions') == true) { ?>    
						<h2><?php echo $_SESSION['survey_name']; ?></h2>
						<p>Question: <?php echo $survey->get_questions_info($id, 'questions'); ?></p>
						<?php } else {
							// not valid survey id and not valid id 
							header('Location: survey_statistics.php');
							exit();
						} ?>
					</div>
					<!-- MAIN CONTENT -->      
					<div id="main-content">

						<div class="notice_messages"></div>

						<?php if($survey->chart_data($id, $survey->find_question_type($id)) == true) { ?>
						<table class="table bt-dataTable" id="dataTable">
							<thead>
								<tr>
									<th>Count</th>
									<th>Answer</th>
									<th>Percentage</th>
								</tr>
							</thead>
							<tbody>
								<?php foreach($survey->chart_data($id, $survey->find_question_type($id)) as $v) { ?>
								<tr>
									<td class="w-60"><?php echo $v['qtd']; ?></td>
									<td><?php echo $v['answer']; ?></td>
									<td class="w-80"><?php echo round($v['qtd']/$total, 2)*100 ?>%</td>
								</tr>	
								<?php } ?>
							</tbody>
						</table> 
						<?php $have_data = 'OK'; ?> 
						<?php } else { ?>
						<?php $have_data = 'NO'; ?>
						<p>No answers found for this question.</p>
						<?php } ?>   

						<div class="mb-20"></div>

						<div class="row grid-set">
							<!-- Answers -->
							<div class="col-6">
								<div class="box">
									<div class="header"><h4>Answer Fact</h4></div>
									<div class="content pad" id="answers-table">
										<?php if($have_data == 'OK') { ?>
										<ul class="unordered">
											<?php if($survey->find_question_type($id) !== 'matrix_multi_select' && $survey->find_question_type($id) !== 'matrix_single' && $survey->find_question_type($id) !== 'multiple_choice') { ?>
											<li><?php echo $survey->get_number_of_answers($id); ?> answered this question</li>
											<?php } else { ?>
											<li>This question has: <?php echo $survey->get_number_of_answers($id); ?> answers</li>
											<?php } ?>
											<li>Most of the users are from: <?php echo getCountryFromIP($survey->get_most_user_location($id), 'name'); ?></li>
											<li>The answer rate to this question is: <?php echo $survey->get_answer_rate($id); ?></li>
										</ul>
										<?php } else { ?>
										<p>No data found to render facts</p>
										<?php } ?>
									</div>  
								</div>  
							</div>
							<!-- // Answers -->

							<!-- Pie -->
							<div class="col-6">
								<div class="box">
									<div class="header"><h4>Pie Chart</h4></div>
									<div class="content pad">
										<?php if($have_data == 'OK') { ?>
										<?php if($survey->find_question_type($id) !== 'single_text' && $survey->find_question_type($id) !== 'comment_box' && $survey->find_question_type($id) !== 'matrix_multi_select' && $survey->find_question_type($id) !== 'matrix_single') { ?>
										<div id="google-pie" class="google-pie"></div>
										<?php } else { ?>   
										<p>This question type does not support pie charts.</p>
										<?php } ?>
										<?php } else { ?>
										<p>No data found to render pie chart</p>
										<?php } ?>
									</div> 
								</div>
							</div>
							<!-- // Pie -->
						</div><!-- // .row .grid-set -->

						<?php if($have_data == 'OK') { ?>
						<button id="export-csv" onclick="csv();" data-qid="<?php echo $id; ?>" data-qtype="comment_box" class="btn btn-primary d-block mb-3 float-end">Export to CSV</button>
						<?php } ?>

					</div>
					<!-- // MAIN CONTENT -->
				</div>
				<!-- // col-md-9 -->

            </div>
            <!-- // row -->
        </div>
        <!-- // container -->
    </div>
    <!-- // MAIN --> 
    
    <?php include("tpl/footer.php"); ?>
    