<?php 
	include("includes/loader.php");
	include("includes/logoutHandler.php"); 
	include("includes/functions.php"); 
	include("tpl/header.php"); 
	include("tpl/nav.php"); 
	
	$id = intval($_GET['id']);
	if(!isset($id) || $id == 0)
	{
		header('Location: manage_survey.php');
		exit();
	}
?>

    <!-- MAIN -->
    <div id="main">
    
		<!-- Breadcrumb -->
		<?php breadcrumb(array(
			'dashboard.php' 	=> '<span class="bi bi-house-fill"></span>Dashboard',
			'manage_survey.php' => 'Manage Surveys',
			'questions.php' => 'Questions',
		)); ?>
        <!-- // Breadcrumb -->
        
        <!-- container -->
        <div class="container bg">
        	
            <!-- row -->
            <div class="row">
            	
                <div class="col-md-3 ps-0"><!-- col-md-3 -->
					<?php include_once('tpl/sidebar.php'); ?>
				</div><!-- // col-md-3 -->
                
				<div class="col-md-9 pe-0"><!-- col-md-9 -->
					<div class="pagetitle">
						<?php if ($survey->get_survey_info($id, 'name') == true) { ?>
							<h2><?php echo $survey->get_survey_info($id, 'name'); ?></h2>
							<?php
							if ($survey->check_reset_admin_IP($id)) {
								echo '<p><a href="#" class="survey-reset" id="' . $id . '">Reset took survey</a> for this survey</p>';
							}

							if ($survey->get_survey_info($id, 'password') !== 'NULL') {
								echo '<p>The password to access this survey is: ' . $survey->get_survey_info($id, 'password') . '</p>';
							}
							?>
						<?php } else {
							// not valid survey id and not valid id 
							header('Location: manage_survey.php');
							exit();
						} ?>
					</div>

					<!-- MAIN CONTENT -->
					<div id="main-content">
						<div class="notice_messages"></div>

						<div class="box">
							<div class="header">
								<h4 class="pad20">Questions
									<a class="btn btn-sm btn-primary float-end" href="#addQuestion" data-bs-toggle="modal">Add Question</a>
									<a class="btn btn-sm btn-primary float-end me-2" href="#orderQuestions" data-bs-toggle="modal">Order Questions</a>
								</h4>
							</div>
							<div class="content">
								<?php if ($survey->listQuestions($id) == true) { ?>
									<table class="table table-striped" id="dataTable">
										<thead>
											<tr>
												<th>Fill</th>
												<th>Question</th>
												<th>Order</th>
												<th>Question Type</th>
												<th>Required</th>
												<th>Actions</th>
											</tr>
										</thead>
										<tbody>
											<?php foreach ($survey->listQuestions($id) as $v) { ?>
												<tr>
													<td class="w-30">
														<?php
														if ($survey->answer_exists($v['question_ID'])) {
															echo '<i class="bi bi-check"></i>';
														} else {
															echo '<i class="bi bi-x"></i>';
														}
														?>
													</td>
													<td><a href="answers.php?id=<?php echo $v['question_ID']; ?>" title="View Answers"><?php echo $v['questions']; ?></a></td>
													<td class="w-60"><?php echo $v['order']; ?></td>
													<td class="w-130"><?php echo $survey->question_types[$v['question_type']]; ?></td>
													<td class="w-60"><?php echo yesNo($v['requeriment']); ?></td>
													<td class="w-60">
														<ul class="table-actions">
															<li><a href="answers.php?id=<?php echo $v['question_ID']; ?>" title="View Answers"><i class="bi bi-files"></i></a></li>
															<li><a href="#editQuestion" data-bs-toggle="modal" title="Edit Question" data-question="<?php echo $v['questions']; ?>" data-id="<?php echo $v['question_ID']; ?>" data-q-type="<?php echo $v['question_type']; ?>" data-q-req="<?php echo $v['requeriment']; ?>" id="editAction"><i class="bi bi-pencil"></i></a></li>
															<li><a href="#deleteQuestion" data-bs-toggle="modal" title="Remove Question" data-question="<?php echo $v['questions']; ?>" data-id="<?php echo $v['question_ID']; ?>" id="deleteAction"><i class="bi bi-trash"></i></a></li>
														</ul>
													</td>
												</tr>
											<?php } ?>
										</tbody>
									</table>
								<?php } else { ?>
									<p class="pad20 pb-0 mb-0">No Questions found</p>
									<p class="pad20">There are no questions to this survey. First you need to <a data-bs-toggle="modal" href="#addQuestion">add a question</a></p>
								<?php } ?>
							</div>
						</div>

						<!-- editQuestion Modal -->
						<div id="editQuestion" class="modal fade">
							<div class="modal-dialog">
								<div class="modal-content">
									<div class="modal-header">
										<h3 class="modal-title">Edit: <span id="questionTitle"></span></h3>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<form id="edit-question" class="modal-body">
										<div class="notice_messages"></div>
										<div class="mb-3">
											<label for="new-question" class="form-label">Question:</label>
											<textarea class="form-control" id="new-question" name="new-question"></textarea>
										</div>
										<div class="mb-3">
											<label for="question-type" class="form-label">Question Type:</label>
											<select class="form-select" id="question-type" name="question-type">
												<?php echo $survey->render_question_types_selects(); ?>
											</select>
										</div>
										<div class="mb-3">
											<label class="form-label">Required Question?</label>
											<?php echo $survey->render_question_requeriment($id, 'Not Required', 'Required'); ?>
											<p class="hint">Hint: Required question are questions that the user must answer to it in order to continue to next questions</p>
										</div>
										<div class="modal-footer">
											<input type="hidden" id="survey_id" name="survey_id" value="<?php echo $id; ?>" />
											<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
											<button type="submit" name="edit-question" data-option="edit-question" class="btn btn-success">Save Changes</button>
										</div>
									</form>
								</div>
							</div>
						</div>

						<!-- deleteQuestion Modal -->
						<div id="deleteQuestion" class="modal fade">
							<div class="modal-dialog">
								<div class="modal-content">
									<div class="modal-header">
										<h3 class="modal-title">Delete <span id="questionTitle"></span></h3>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<form id="delete-question" class="modal-body">
										<div class="notice_messages"></div>
										<p>By deleting this question you will also delete its statistics and answers.</p>
										<p>Are you sure you want to delete this question?</p>
										<div class="modal-footer">
											<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
											<button type="submit" name="delete-question" data-option="delete-question" class="btn btn-danger">Delete</button>
										</div>
									</form>
								</div>
							</div>
						</div>

						<!-- addQuestion Modal -->
						<div id="addQuestion" class="modal fade">
							<div class="modal-dialog">
								<div class="modal-content">
									<div class="modal-header">
										<h3 class="modal-title">Add Question</h3>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<form id="add-question" class="modal-body">
										<div class="notice_messages"></div>
										<div class="mb-3">
											<label for="new-question" class="form-label">Question:</label>
											<textarea class="form-control" id="new-question" name="new-question"></textarea>
										</div>
										<div class="mb-3">
											<label for="question-type" class="form-label">Question Type:</label>
											<select class="form-select" id="question-type" name="question-type">
												<?php
													foreach($survey->question_types as $name => $value) 
													{
														echo '<option value="'.$name.'">'.$value.'</option>';	
													}
												?>
											</select>
										</div>
										<div class="mb-3">
											<label class="form-label">Required Question?</label>
											<label class="form-check-label" for="not-required">
												<input class="form-check-input" type="radio" id="not-required" name="requeriment" value="0" checked="checked"> Not Required
											</label>
											<label class="form-check-label" for="required">
												<input class="form-check-input" type="radio" id="required" name="requeriment" value="1"> Required
											</label>
											<p class="hint">Hint: Required question are questions that the user must answer to it in order to continue to next questions</p>
										</div>
										<div class="modal-footer">
											<input type="hidden" id="survey_id" name="survey_id" value="<?php echo $id; ?>" />
											<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
											<button type="submit" name="add-question" data-option="add-question" class="btn btn-success">Add Question</button>
										</div>
									</form>
								</div>
							</div>
						</div>

						<!-- Order Questions -->
						<div id="orderQuestions" class="modal fade">
							<div class="modal-dialog">
								<div class="modal-content">
									<div class="modal-header">
										<h3 class="modal-title">Order Questions</h3>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<form id="order-questions" class="modal-body">
										<div class="box">
											<div class="header">
												<h4>Template Questions Sorting</h4>
											</div>
											<div class="content">
												<ul class="sortList">
													<?php if($survey->listSortableQuestions($id)):
													foreach($survey->listSortableQuestions($id) as $v) { ?>
													<li id="recordsArray_<?php echo $v['question_ID']; ?>"><?php echo $v['questions']; ?></li>
													<?php }
													else:
													echo '<p class="pad20">No questions to sort.</p>';
													endif; ?>
												</ul>
											</div>
										</div>
										<?php if($survey->listSortableQuestions($id)): ?>
										<div class="modal-footer">
											<button type="submit" name="order-questions-confirm" data-option="order-questions-confirm" class="btn btn-success">Confirm Changes</button>
										</div>
										<?php endif; ?>
									</form>
								</div>
							</div>
						</div>

					</div>
				</div>
				<!-- col-md-9 -->
				
            </div>
            <!-- // row -->
        </div>
        <!-- // container -->
    </div>
    <!-- // MAIN --> 
    
    <?php include("tpl/footer.php"); ?>

