<?php 
	include("includes/loader.php");
	include("includes/logoutHandler.php"); 
	include("includes/functions.php"); 
	include("tpl/header.php"); 
	include("tpl/nav.php");
	
	$id = intval($_GET['id']);
	if(!isset($id) || $id == 0)
	{
		header('Location: users.php');
		exit();
	}
	
	if($user->prevent_mods($id))
	{
		include('restricted.php');
		die();
	}
	
	$username = $user->get_user_('username', $id);
	$email = $user->get_user_('email', $id);
	$first_name = $user->get_user_('first_name', $id);
	$last_name = $user->get_user_('last_name', $id);
	$role = $user->get_user_('role', $id);
?>

    <!-- MAIN -->
    <div id="main">
    	
        <!-- Breadcrumb -->
		<?php breadcrumb(array(
			'dashboard.php' 	=> '<span class="bi bi-house-fill"></span>Dashboard',
			'users.php' => 'Users',
			'profile.php' => 'Profile',
		)); ?>
        <!-- // Breadcrumb -->
        
        <!-- container -->
        <div class="container bg">
        	
            <!-- row -->
            <div class="row">
            	
                <div class="col-md-3 ps-0"><!-- col-md-3 -->
					<?php include_once('tpl/sidebar.php'); ?>
				</div><!-- // col-md-3 -->
                
                 <div class="col-md-9 pe-0"><!-- col-md-9 -->
					<div class="pagetitle">
						<h2>Profile</h2>
					</div>
					
					<!-- MAIN CONTENT -->
					<div id="main-content">
						
						<form id="profile" class="form-horizontal" method="post">
						
							<div class="notice_messages"></div>
							
							<div class="row">
								<div class="col-3">
									<h3>User Data</h3>
								</div>
							</div>
							
							<div class="row">
								<div class="col-3">
									Username
								</div>
								<div class="col-5">
									<input type="text" class="form-control" disabled value="<?php echo $username; ?>" />
								</div>
							</div>
							
							<div class="row">
								<div class="col-3">
									Email
								</div>
								<div class="col-5">
									<input type="text" class="form-control" disabled value="<?php echo $email; ?>" />
								</div>
							</div>
							
							<div class="row">
								<div class="col-3">
									First Name
								</div>
								<div class="col-5">
									<input type="text" name="first_name" class="form-control" value="<?php echo $first_name; ?>" />
								</div>
							</div>
							
							<div class="separator"></div>
							
							<div class="row">
								<div class="col-3">
									Last Name
								</div>
								<div class="col-5">
									<input type="text" name="last_name" class="form-control" value="<?php echo $last_name; ?>" />
								</div>
							</div>
							
							<div class="separator"></div>
							
							<div class="row">
								<div class="col-3">
									Role
								</div>
								<div class="col-5">
									<?php if($user->is_admin()): ?>
									<div class="form-check">
										<input class="form-check-input" type="radio" name="role" value="Admin" <?php checked($role, "Admin"); ?>>
										<label class="form-check-label">
											Admin
										</label>
									</div>
									<?php endif; 
									if($user->is_admin() && $id == intval($_SESSION['mySurvey_userid'])):
									else: 
									?>
									<div class="form-check">
										<input class="form-check-input" type="radio" name="role" value="Pollster" <?php checked($role, "Pollster"); ?>>
										<label class="form-check-label">
											Pollster
										</label>
									</div>
									<?php endif; ?>
								</div>
							</div>
							
							<div class="form-actions mb-5">
								<div class="float-end">
									<input type="hidden" name="action" value="edit" />
									<input type="hidden" name="id" value="<?php echo $id; ?>" />
									<input type="hidden" name="username" value="<?php echo $username; ?>" />
									<button type="submit" name="save-settings-profile" data-option="save-settings-profile" class="btn btn-success">Update Profile</button>
								</div>
							</div>
							
						</form>
						
						<form id="profile-change-pass" class="form-horizontal" method="post">
						
							<div class="row">
								<div class="col-3">
									<h3>Password</h3>
								</div>
							</div>
							
							<div class="row">
								<div class="col-3">
									New Password
								</div>
								<div class="col-5">
									<input name="password" id="password" type="password" class="form-control" />
									<p class="help-block inpass">Hint: Minimum 6 Characters</p>
								</div>
							</div>
							
							<div class="separator"></div>
							
							<div class="row">
								<div class="col-3">
									Confirm New Password
								</div>
								<div class="col-5">
									<input type="password" name="confirm_password" id="confirm_password" class="form-control" />
									<p class="hint" id="pmessage"></p>
								</div>
							</div>
							
							<div class="form-actions mb-5">
								<div class="float-end">
									<input type="hidden" name="action" value="edit-password" />
									<input type="hidden" name="id" value="<?php echo $id; ?>" />
									<input type="hidden" name="username" value="<?php echo $username; ?>" />
									<button type="submit" name="save-settings-password" data-option="save-settings-password" class="btn btn-success add-user-btn">Change Password</button>
								</div>
							</div>
							
						</form>
						
					</div>
					<!-- // MAIN CONTENT -->
				</div>
				<!-- // col-md-9 -->

				
            </div>
            <!-- // row -->
        </div>
        <!-- // container -->
    </div>
    <!-- // MAIN --> 
	
    <?php include("tpl/footer.php"); ?>