<?php 
	include("includes/loader.php");
	include("includes/logoutHandler.php"); 
	include("includes/functions.php"); 
	include("tpl/header.php"); 
	include("tpl/nav.php"); 
?>
	    
    <!-- MAIN -->
    <div id="main">
    	
		<!-- Breadcrumb -->
		<?php breadcrumb('Manage Surveys'); ?>
        <!-- // Breadcrumb -->
        
        <!-- container -->
        <div class="container bg">
        	
            <!-- row -->
            <div class="row">
            	
                <div class="col-md-3 ps-0"><!-- col-md-3 -->
					<?php include_once('tpl/sidebar.php'); ?>
				</div><!-- // col-md-3 -->
                
                <div class="col-md-9"><!-- col-md-9 -->
				  <div class="pagetitle">
					<h2>Manage Surveys</h2>
				  </div>

				  <!-- MAIN CONTENT -->
				  <div id="main-content">
					<div class="notice_messages"></div>

					<div class="box">
					  <div class="header">
						<h4>Surveys</h4>
					  </div>
					  <div class="content pad">
						<?php if ($survey->listSurveys() == true) { ?>
						<table class="table table-striped" id="dataTable">
						  <thead>
							<tr>
							  <th>#</th>
							  <th>Survey</th>
							  <th>Number of questions</th>
							  <th>Actions</th>
							</tr>
						  </thead>
						  <tbody>
							<?php foreach ($survey->listSurveys() as $v) { ?>
							<tr>
							  <td class="w-30"><?php echo $v['survey_ID']; ?></td>
							  <td><a href="questions.php?id=<?php echo $v['survey_ID']; ?>" title="View Survey"><?php echo $v['name']; ?></a></td>
							  <td class="w-130"><?php echo $survey->get_number_of_questions($v['survey_ID']); ?></td>
							  <td class="w-60">
								<ul class="table-actions">
								  <li><a href="questions.php?id=<?php echo $v['survey_ID']; ?>" title="View Survey"><i class="bi bi-file-earmark"></i></a></li>
								  <li><a href="#editSurvey" data-bs-toggle="modal" title="Edit Survey" data-survey="<?php echo $v['name']; ?>" data-password="<?php echo $v['password']; ?>" data-id="<?php echo $v['survey_ID']; ?>" id="editAction"><i class="bi bi-pencil"></i></a></li>
								  <li><a href="#deleteSurvey" data-bs-toggle="modal" title="Remove Survey" data-survey="<?php echo $v['name']; ?>" data-id="<?php echo $v['survey_ID']; ?>" id="deleteAction"><i class="bi bi-trash"></i></a></li>
								</ul>
							  </td>
							</tr>
							<?php } ?>
						  </tbody>
						</table>
						<?php } else { ?>
						<p class="px-4">No Surveys found</p>
						<p class="px-4">There are no surveys to manage. First, you need to <a href="create_survey.php">create a survey</a></p>
						<?php } ?>
					  </div>
					</div>

					<!-- editSurvey Modal -->
					<div id="editSurvey" class="modal fade">
					  <div class="modal-dialog">
						<div class="modal-content">
						  <div class="modal-header">
							<h3 class="modal-title">Edit <span id="surveyTitle"></span></h3>
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						  </div>
						  <form id="edit-survey" class="form-horizontal margin-reset" method="post">
							<div class="modal-body">
							  <div class="notice_messages"></div>
							  <div class="row">
								<div class="col-3">
								  <p>New Survey Name:</p>
								</div>
								<div class="col-9">
								  <input type="text" name="new-survey-name" id="new-survey-name" class="form-control">
								</div>
							  </div>
							  <div class="row">
								<div class="col-3">
								  <p>New Survey Password:</p>
								</div>
								<div class="col-9">
								  <input type="text" name="new-survey-password" id="new-survey-password" class="form-control">
								  <p class="form-text">Hint: leave blank for no password</p>
								</div>
							  </div>
							</div>
							<div class="modal-footer">
							  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
							  <button type="submit" name="create-survey" data-option="edit-survey" class="btn btn-success">Save Changes</button>
							</div>
						  </form>
						</div>
					  </div>
					</div>

					<!-- deleteSurvey Modal -->
					<div id="deleteSurvey" class="modal fade">
					  <div class="modal-dialog">
						<div class="modal-content">
						  <div class="modal-header">
							<h3 class="modal-title">Delete <span id="surveyTitle"></span>?</h3>
							<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
						  </div>
						  <form id="delete-survey" class="form-horizontal margin-reset" method="post">
							<div class="modal-body">
							  <div class="notice_messages"></div>
							  <p>By deleting this survey, you will also delete its statistics, answers, and questions.</p>
							  <p>Are you sure you want to delete this survey?</p>
							</div>
							<div class="modal-footer">
							  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
							  <button type="submit" name="delete-survey" data-option="delete-survey" class="btn btn-danger">Delete</button>
							</div>
						  </form>
						</div>
					  </div>
					</div>

				  </div>
				  <!-- // MAIN CONTENT -->
				</div>
				<!-- // col-md-9 -->
 
            </div>
            <!-- // row -->
        </div>
        <!-- // container -->
    </div>
    <!-- // MAIN --> 
    
    <?php include("tpl/footer.php"); ?>

