<?php
	
	$db = new mysqli(DB_HOST, DB_USERNAME, DB_PASSWORD, DATABASE);
	
	if($db->connect_errno > 0)
	{
		die('Unable to connect to database [' . $db->connect_error . ']');
	}
	
	// Basic User Class
	class basicUser 
	{
		
		public $roles = array('Admin', 'Pollster');
		
		private $tbl = 'users';
		
		private $sessionUserId = 'mySurvey_userid';
		private $sessionUsername = 'mySurvey_username';
		
		private $adminRoleName = 'admin';
		
		private $demoUserName = 'demouser';
		private $demoPassword = 'demo';
		
		// Result
		// @params $sql
		private function _exec_query($sql)
		{
			global $db;
			
			$result = $db->query($sql);
			
			if(!$result)
			{
				die('There was an error running the query [' . $db->error . ']');
			}
			
			return $result;
		}
		
		// Eval query if returns rows or nothing (SELECT)
		private function _query_eval_num_rows($result)
		{
			if($result->num_rows > 0)
			{
				return true;
			} else {
				return false;
			}
		}
		
		// Eval query if returns rows or nothing (UPDATE/DELETE/CREATE)
		private function _query_eval_affected_rows()
		{
			global $db;
			
			if($db->affected_rows > 0)
			{
				return true;
			} else {
				return false;
			}
		}
		
		// Eval result if true/false
		// @params $result
		private function _result_eval($result)
		{
			if($result)
			{
				return true;
			} else {
				return false;
			}
		}
		
		// Results
		private function _results($result)
		{
			$result_array = array();
			
			for ($i = 0; $row = $result->fetch_assoc(); $i++)
			{
			   $result_array[$i] = $row; 
			}
			
			return $result_array;
		}
		
		// List users
		public function list_users()
		{
			global $db;
			
			$sql = sprintf("SELECT id, username, email, first_name, last_name, role FROM $this->tbl");
			
			$result = $this->_exec_query($sql);
			
			if($result)
			{
				return $this->_results($result);
			} else {
				return false;
			}
		}
		
		// Count users
		public function count_users()
		{
			global $db;
			
			$sql = sprintf("SELECT COUNT(id) AS total_users FROM $this->tbl");
			
			$result = $this->_exec_query($sql);
			
			if($result->num_rows > 0)
			{
				$row = $result->fetch_assoc();
				return $row['total_users'];
			} else {
				return false;
			}
		}
		
		// Prevent only admin removal 
		public function count_role_admin()
		{
			global $db;
			
			$sql = sprintf("SELECT COUNT(role) as role_count FROM $this->tbl WHERE role = '%s'",
				$db->real_escape_string($this->adminRoleName)
			);
			
			$result = $this->_exec_query($sql);
			
			if($result->num_rows > 0)
			{
				$row = $result->fetch_assoc();
				return $row['role_count'];
			} else {
				return false;
			}
		}
		
		// Current user role
		public function is_role($role, $id, $username)
		{
			global $db;
			
			$sql = sprintf("SELECT id, username FROM $this->tbl WHERE role = '%s' AND id = '%d' AND username = '%s'",
				$db->real_escape_string($role),
				$db->real_escape_string($id),
				$db->real_escape_string($username)
			);
			
			$result = $this->_exec_query($sql);
			
			return $this->_query_eval_num_rows($result);
		}
		
		// Remove db demo user
		public function remove_demo_user()
		{
			global $db;
			
			$sql = sprintf("SELECT COUNT(id) AS total_users FROM $this->tbl");
			
			$result = $this->_exec_query($sql);
			
			if($result->num_rows > 0)
			{
				$row = $result->fetch_assoc();
				$total_users = $row['total_users'];
				if($total_users > 1)
				{
					// remove the demouser
					$sql = sprintf("DELETE FROM $this->tbl WHERE username = '%s' AND password = '%s'",
						$db->real_escape_string($this->demoUserName),
						$db->real_escape_string(sha1($this->demoPassword))
					);
					
					$result = $this->_exec_query($sql);
					
					return $this->_result_eval($result);
				} else {
					// unable to remove the only user
					return false;
				}
			} else {
				return false;
			}
		}
		
		// Check if email exists
		// @params $email
		public function email_exists($email)
		{
			global $db;
			
			$sql = sprintf("SELECT id FROM $this->tbl WHERE email='%s'",
				$db->real_escape_string($email)
			);
			
			$result = $this->_exec_query($sql);
			
			return $this->_query_eval_num_rows($result);
		}
		
		// Check if username exists
		// @params $username
		public function username_exists($username)
		{
			global $db;
			
			$sql = sprintf("SELECT id FROM $this->tbl WHERE username='%s'",
				$db->real_escape_string($username)
			);
			
			$result = $this->_exec_query($sql);
			
			return $this->_query_eval_num_rows($result);
		}
		
		// Prevent other users browsing (non-admin unable to browse profiles)
		// Prevent CRUD Operations (non-admin unable to do crud operations)
		public function prevent_mods($id='')
		{
			global $db;
			
			$id = intval($id);
			$logged_user_id = isset($_SESSION[$this->sessionUserId]) ? intval($_SESSION[$this->sessionUserId]) : null;

			if($id == 0)
			{
				$id = isset($_SESSION[$this->sessionUserId]) ? intval($_SESSION[$this->sessionUserId]) : null;
			}
			
			if(!$this->is_admin())
			{
				if($logged_user_id == $id)
				{
					return false; // permit
				} else {
					return true; // deny
				}
			} else {
				return false; // permit
			}
		}
		
		// Get user by id
		// @params field
		public function get_user_($field, $id)
		{
			global $db;
			
			$sql = sprintf("SELECT %s FROM $this->tbl WHERE id='%d'",
				$db->real_escape_string($field),
				$db->real_escape_string($id)
			);
			
			$result = $this->_exec_query($sql);
			
			if($result->num_rows > 0)
			{
				$row = $result->fetch_assoc();
				return $row[$field];
			} else {
				return false;
			}
		}
		
		// Creates a user
		// @params $data (array)
		public function create_user($data)
		{
			global $db;
			
			if($this->prevent_mods())
			{
				return false;
			}
			
			$username = $data['username'];
			$password = $data['password'];
			$fname = $data['first_name'];
			$lname = $data['last_name'];
			$email = $data['email'];
			$role = $data['role'];
			
			if(!is_array($data))
			{
				return false;
			}
			
			// Check if username already exists
			$user_exists = $this->username_exists($username);
			
			if($user_exists)
			{
				return false;
			} else {
				$sql = sprintf("INSERT INTO $this->tbl SET username='%s', first_name='%s', last_name='%s', email='%s', password='%s', role='%s'",
					$db->real_escape_string($username),
					$db->real_escape_string($fname),
					$db->real_escape_string($lname),
					$db->real_escape_string($email),
					$db->real_escape_string(sha1($password)),
					$db->real_escape_string($role)
				);
				
				$result = $this->_exec_query($sql);
				
				return $this->_query_eval_affected_rows($result);
			}
		}
		
		// Remove a user 
		// @params $id, $username
		public function remove_user($id, $username)
		{
			global $db;
			
			if($this->prevent_mods())
			{
				return false;
			}
			
			$sql = sprintf("DELETE FROM $this->tbl WHERE username='%s' AND id='%d'",
				$db->real_escape_string($username),
				$db->real_escape_string($id)
			);
			
			$result = $this->_exec_query($sql);
			
			return $this->_query_eval_affected_rows($result);
		}
		
		// Update a user
		// @params $data (array)
		public function update_user($data, $update_type='default') 
		{
			global $db;
			
			if($this->prevent_mods())
			{
				return false;
			}
			
			$id = $data['id'];
			$username = $data['username'];
			
			if(!is_array($data))
			{
				return false;
			}
			
			// Check if username already exists
			$user_exists = $this->username_exists($username);
			
			if($user_exists)
			{
				if($update_type == 'update_password')
				{
					$password = $data['password'];
					$sql = sprintf("UPDATE $this->tbl SET password='%s' WHERE id='%d' AND username='%s'",
						$db->real_escape_string(sha1($password)),
						$db->real_escape_string($id),
						$db->real_escape_string($username)
					);
				} else {
					$role = $data['role'];
					$fname = $data['first_name'];
					$lname = $data['last_name'];
					$sql = sprintf("UPDATE $this->tbl SET first_name='%s', last_name='%s', role='%s' WHERE id='%s' AND username='%s'",
						$db->real_escape_string($fname),
						$db->real_escape_string($lname),
						$db->real_escape_string($role),
						$db->real_escape_string($id),
						$db->real_escape_string($username)
					);
				}
				
				$result = $this->_exec_query($sql);
				
				return $this->_query_eval_affected_rows($result);
			} else {
				return false;
			}
		}
		
		// If the user is admin
		public function is_admin()
		{
			global $db;
			
			$logged_user_id = isset($_SESSION[$this->sessionUserId]) ? $_SESSION[$this->sessionUserId] : null;
			$logged_username = isset($_SESSION[$this->sessionUsername]) ? $_SESSION[$this->sessionUsername] : null;
			
			if(isset($logged_user_id) && isset($logged_username))
			{
				$sql = sprintf("SELECT id FROM $this->tbl WHERE role='%s' AND username='%s' AND id='%s'",
					$db->real_escape_string($this->adminRoleName),
					$db->real_escape_string($logged_username),
					$db->real_escape_string($logged_user_id)
				);
				
				$result = $this->_exec_query($sql);
				
				return $this->_query_eval_num_rows($result);
			} else {
				return false;
			}
		}
		
	}
	
	$user = new basicUser();
	
?>