<?php
	
	// This file is the core for managing themes, so do not modify it
	
	switch($sessions)
	{
		/***********************************************************************************************************************************************************
		* Home Complex
		************************************************************************************************************************************************************/
		case 'Y':
			// Get Sessions
			foreach(the_dropzone() as $ks => $vs)
			{
				$session[] = $vs;	
			}
			$session = array_unique($session);
			
			// Get Respective Answers of the sessions by order
			foreach(the_dropzone() as $k => $v)
			{
				$results[get_question($k, 'order')] = get_question($k, 'questions');	
			}
			
			// Get Question types
			foreach(the_dropzone() as $k => $v)
			{
				$order_array[] = get_question($k, 'question_type'); ksort($order_array);
				$qtypes[get_question($k, 'order')] = get_question($k, 'question_type');	
				$question_types[get_question($k, 'order')] = get_question($k, 'question_type');
			}
			ksort($qtypes); // not being used for templating due bug, was being used with ksort($answer) but was causing limitations
			ksort($question_types);
			
			// Get Answers and build form
			foreach(the_dropzone() as $k => $v)
			{
				$answer[get_question($k, 'order')] = unserialize(get_question($k, 'answer'));	
			}
			ksort($answer);
			
			if(!array_key_exists(1, $answer)) { include($theme_path.'/bad_survey.php'); die(); }
			
			// Get css class e requeriment e ids
			foreach(the_dropzone() as $k => $v)
			{
				$css[get_question($k, 'order')] = get_question($k, 'css');	
				$requeriment[get_question($k, 'order')] = get_question($k, 'requeriment');
				$ids[get_question($k, 'order')] = get_question($k, 'question_ID');
				$position[get_question($k, 'order')] = get_question($k, 'position');
			}
			ksort($css); ksort($requeriment); ksort($requeriment); ksort($position);

			if(isset($_GET['page']) && $survey->sanitize_integer($_GET['page']) == true)
			{
				$page = $_GET['page'];
			} else {
				$page = 1;	
			}
			
			// Pagination Var
			$per_page = $survey->settings_notice(4, 4);
			$total_pages = count($results);
			$pages = ceil($total_pages / $per_page);
			$firstIndex = ($page - 1) * $per_page;
			
			// do the job
			$i = 0;
			
			ksort($results); 
			
			// reindex arrays - this will prevent faulty questions to being published, faulty question order, etc
			$requeriment = array_combine(range(1, count($requeriment)), array_values($requeriment));
			$position = array_values($position);
			ksort($ids); $ids = array_values($ids);
			$results = array_combine(range(1, count($results)), array_values($results));
			$answer = array_combine(range(1, count($answer)), array_values($answer));
			$z = 1;
			foreach($question_types as $k => $v)
			{
				$question_types_final[$z] = $v.'-'.$z;
				$z++;	
			}
			
			// combine to prepare to build form
			$combine = @array_combine($question_types_final, $answer);
			
			if($combine == false) { include($theme_path.'/bad_survey.php'); die(); }
			
			// print_r($results); print_r($question_types_final); print_r($answer); print_r($combine); print_r($ids);
			
			include($theme_path.'/home_complex.php');
		break;
		
		/***********************************************************************************************************************************************************
		* Home Basic
		************************************************************************************************************************************************************/	
		case 'N':
		
			// Get results
			foreach($survey->listQuestions($thisID) as $k => $v)
			{
				$results[get_question($v['question_ID'], 'order')] = get_question($v['question_ID'], 'questions');
			}
			ksort($results);
			
			// Get answers to build form
			foreach($survey->listQuestions($thisID) as $k => $v)
			{
				$answer[get_question($v['question_ID'], 'order')] = unserialize(get_question($v['question_ID'], 'answer'));	
			}
			ksort($answer);
			
			// Get Question types
			foreach($survey->listQuestions($thisID) as $k => $v)
			{
				$question_types[get_question($v['question_ID'], 'order')] = get_question($v['question_ID'], 'question_type');
			}
			ksort($question_types);
			
			// Get css class e requeriment e ids
			foreach($survey->listQuestions($thisID) as $k => $v)
			{
				$css[get_question($v['question_ID'], 'order')] = get_question($v['question_ID'], 'css');	
				$requeriment[get_question($v['question_ID'], 'order')] = get_question($v['question_ID'], 'requeriment');
				$ids[get_question($v['question_ID'], 'order')] = get_question($v['question_ID'], 'question_ID');
				$position[get_question($v['question_ID'], 'order')] = get_question($v['question_ID'], 'position');
			}
			ksort($css); ksort($requeriment); ksort($requeriment); ksort($position);
			
			if(isset($_GET['page']) && $survey->sanitize_integer($_GET['page']) == true)
			{
				$page = $_GET['page'];
			} else {
				$page = 1;	
			}
			
			// Pagination Var
			$per_page = $survey->settings_notice(4, 4);
			$total_pages = count($results);
			$pages = ceil($total_pages / $per_page);
			$firstIndex = ($page - 1) * $per_page;
			
			// do the job
			$i = 0;
			
			$position = array_values($position);
			ksort($ids); $ids = array_values($ids);
			
			$z = 1;
			foreach($question_types as $k => $v)
			{
				$question_types_final[$z] = $v.'-'.$z;
				$z++;	
			}
			
			// combine to prepare to build form
			$combine = @array_combine($question_types_final, $answer);

			if($combine == false) { include($theme_path.'/bad_survey.php'); die(); }
			
			include($theme_path.'/home_basic.php');
		break;
		
		default:
			include($theme_path.'/home_basic.php');
		break;	
	}	

	
?>