<?php
	
	// Gets the title of the survey
	function get_survey_title()
	{
		global $survey, $thisID;
		$title = $survey->check_template_survey('title', 'survey_id', $thisID);
		
		if(empty($title))
		{
			echo 'mySurvey';	
		} else {
			echo $title;	
		}
	}
	
	// Gets the heading of the survey
	function get_survey_heading()
	{
		global $survey, $thisID;
		$res = $survey->check_template_survey('heading', 'survey_id', $thisID);
		if(!empty($res))
		{
			if(stripos($res, '.jpg') || stripos($res, '.png') || stripos($res, '.jpeg') || stripos($res, '.gif'))
			{
				$ext = pathinfo($res, PATHINFO_EXTENSION);
				if($ext == 'png' || $ext == 'jpg' || $ext == 'gif')
				{
					echo '<img src="'.html_entity_decode($res).'" alt="logo" />';
				}
			} else {
				echo $res;	
			}	
		} else {
			echo 'mySurvey';	
		}
	}
	
	// Gets the subheading of the survey
	function get_survey_subHeading()
	{
		global $survey, $thisID;
		$sub_head = $survey->check_template_survey('sub_heading', 'survey_id', $thisID);
		
		if(empty($sub_head))
		{
			echo 'mySurvey a sample survey';	
		} else {
			echo $sub_head;	
		}
	}
	
	// Gets the intro of the survey
	function get_survey_intro()
	{
		global $survey, $thisID;
		$si = $survey->check_template_survey('intro', 'survey_id', $thisID);
		if($si)
		{
			echo '<p class="survey-intro">'.$si.'</p>';
		}
	}
	
	// Gets the description of the survey
	function get_survey_description()
	{
		global $survey, $thisID;
		$se = $survey->check_template_survey('description', 'survey_id', $thisID);
		if($se)
		{
			echo '<p class="survey-description">'.$se.'</p>';
		}
	}
	
	// Gets the note of the survey
	function get_survey_note()
	{
		global $survey, $thisID;
		echo $survey->check_template_survey('note', 'survey_id', $thisID);
	}
	
	// Gets the footer of the survey
	function get_survey_footer()
	{
		global $survey, $thisID;
		return $survey->check_template_survey('footer', 'survey_id', $thisID);
	}
	
	// Gets survey notice success
	function get_survey_notice_success($message)
	{
		global $survey;
		echo $survey->settings_notice(2, $message);	
	}
	
	// Gets survey notice took survey
	function survey_notice_tookSurvey($message)
	{
		global $survey;
		return $survey->settings_notice(3, $message);	
	}
	
	// Gets survey notice related to page that took survey
	function survey_notice_tookPage($message)
	{
		global $survey;
		return $survey->settings_notice(5, $message);	
	}
	
	function next_button_text($txt)
	{
		global $survey;
		return $survey->settings_notice(6, $txt);	
	}
	
	function submit_button_text($txt)
	{
		global $survey;
		return $survey->settings_notice(7, $txt);	
	}
	
	function choices_hint($txt)
	{
		global $survey;
		return $survey->settings_notice(8, $txt);		
	}
	
	// Gets the description of the survey
	function the_survey_sessions()
	{
		global $survey, $thisID;
		return $survey->check_template_survey('sessions', 'survey_id', $thisID);
	}
	
	// check if user completed survey
	function user_completed_survey()
	{
		global $survey, $thisID;
		
		if(isset($_COOKIE['user_completed_survey'.$thisID]))
		{
			if($_COOKIE['user_completed_survey'.$thisID] == $thisID)
			{
				return true;
			} else {
				return false;
			}
		} else { 
			return false;	
		}
	}
	
	// check if user took survey
	function user_took_survey()
	{
		global $survey, $thisID;
		$res = $survey->user_already_took_survey($thisID, $survey->get_client_ip()); 
		if($res)
		{
			return $res;
		} else {
			return false;	
		}
	}
	
	// check if user answered current page
	function user_answered()
	{
		global $survey, $thisID, $page;
		$res = $survey->user_already_answered_page($thisID, $survey->get_client_ip(), user_took_survey());	
		
		if($res > $page)
		{
			return $res;	
		} else {
			return false;	
		}
	}
	
	// Gets the survey template rule
	function the_survey_templateRule()
	{
		global $survey, $thisID;
		return unserialize($survey->check_template_survey('template_rule', 'survey_id', $thisID));
	}
	
	// Gets the survey dropzones placements
	function the_dropzones()
	{
		global $survey, $thisID;
		
		$dropzones = the_survey_templateRule();
		
		if(is_array($dropzones) && !empty($dropzones))
		{
			$total = count($dropzones);	// to give a name to the dropzone

			for($i = 1; $i <= $total; $i++)
			{
				if(!isset($dropzones['drop-zone'.$i]))
				{
					// miss it
				} else {
					$new_array[$dropzones[$i-1]] = $dropzones['drop-zone'.$i];	
				}
			}
			
			if(isset($new_array))
			{
				return $new_array;		
			} else {
				return false;	
			}
			
		} else {
			return false;	
		}
		
	}
	
	function the_dropzone()
	{
		$zones = array();
		foreach(the_dropzones() as $dropzone => $array)
		{
			foreach($array as $value) 
			{
				$zones[$value] = $dropzone;
			}
		}
		
		if(isset($zones))
		{
			return $zones;
		} else {
			return false;	
		}
	}
	
	function survey_have_password()
	{
		global $survey, $thisID;
		$res = $survey->get_survey_info($thisID, 'password');
		if($res !== "NULL")
		{
			return $res;	
		} else {
			return false;	
		}
	}
		
	// Get questions
	function get_question($id, $return)
	{
		global $survey;
		return $survey->get_question($id, $return);	
	}
	
	function clean($val)
	{
		$val = str_replace(",","",$val);
		$val = str_replace(" ","-",$val);
		$val = str_replace("?","",$val);
		return $val;
	}
	
?>