<?php

	/*************************************************************************
	*	Survey 
	* 	PHP Survey class
	*
	*	Author: Paulo Regina
	*	Version: 1.3
	*	Copyright (C) 2014 - www.pauloreg.com
	*	
	**************************************************************************/
	
	include('survey.answer.templates.php');
	
	class mySurvey extends SurveyAnswerTemplates
	{
		############################################################################################### 
		#### Properties
		###############################################################################################
				
		// users table from same database
		public $users_table;
		public $users_username;
		public $users_user_id;
		
		############################################################################################### 
		#### Methods
		###############################################################################################
		
		/**********************************************************************************************
		* Read Context
		***********************************************************************************************/
		
		public function __construct($db_server, $db_username, $db_password, $db_name, $table) 
		{
			// Set Internal Variables
			$this->db_server = $db_server;	
			$this->db_username = $db_username;
			$this->db_password = $db_password;
			$this->db_name = $db_name;
			$this->table = $table;	
			
			// Connection @params 'Server', 'Username', 'Password', 'Database'
			$this->mysqli = new mysqli($this->db_server, $this->db_username, $this->db_password, $this->db_name);
			
			// Display Friend Error Message On Connection Failure
			if($this->mysqli->connect_errno) 
			{
				include('install.php');	
				die();
			}
			
			// Internal UTF-8
			$this->mysqli->query("SET NAMES 'utf8'");
			$this->mysqli->query('SET character_set_connection=utf8');
			$this->mysqli->query('SET character_set_client=utf8');
			$this->mysqli->query('SET character_set_results=utf8');
		}
		
		//////////////////////////////////
		// Results Transformation
		/////////////////////////////////
		private function results($result)
		{
			
			$result_array = array();
			
			for ($i = 0; $row = $result->fetch_assoc(); $i++)
			{
			   $result_array[$i] = $row; 
			}
			
			return $result_array;
						
		}
		
		/////////////////////////////////////////////
		// Array Values Recursive
		////////////////////////////////////////////
		public function array_values_recursive($ary)  
		{
			$lst = array();
			foreach( array_keys($ary) as $k ) 
			{
				$v = $ary[$k];
				if(is_scalar($v)) 
				{
					$lst[] = $v;
				} elseif (is_array($v)) {
					$lst = array_merge($lst, $this->array_values_recursive($v));
				}
			}
		
			return $lst;
		}
		
		//////////////////////////////////////////
		// Sanitize Integer
		/////////////////////////////////////////
		public function sanitize_integer($get_id)
		{
			// clean it
			$sanitize = strip_tags($get_id);
			$sanitize = str_replace("'","", $sanitize);
			$sanitize = str_replace('"', "", $sanitize);
			
			$sanitize = (int) $sanitize;
			
			if(is_int($sanitize))
			{
				return $sanitize;
			}
			
			// return all data before a space
			$sanitize = substr($sanitize, 0, strpos($sanitize, ' '));
			
			// get only the numbers
			preg_match("/^\d+$/", $sanitize, $matches);	
			
			if(!empty($matches['0']))
			{
				return $matches['0'];	
			}
		}
		
		////////////////////////////////
		// Get Client IP ADDR
		///////////////////////////////
		public function get_client_ip()
		{
			$ip_address = '';
			
			if(getenv('HTTP_CLIENT_IP'))
			{
				$ip_address = getenv('HTTP_CLIENT_IP');
			} elseif(getenv('HTTP_X_FORWARDED_FOR')) {
				$ip_address = getenv('HTTP_X_FORWARDED_FOR');	
			} elseif(getenv('HTTP_X_FORWARDED')) {
				$ip_address = getenv('HTTP_X_FORWARDED');	
			} else {
				$ip_address = $_SERVER['REMOTE_ADDR'];	
			}
			
			return $ip_address;
		}
		
		////////////////////////////////
		// Reset IP of the admin
		///////////////////////////////
		public function check_reset_admin_IP($id)
		{
			$id = $this->mysqli->real_escape_string($this->sanitize_integer($id));
			$result = $this->mysqli->query(sprintf("SELECT IP FROM took_survey WHERE survey_id = '%d' AND IP = '%s'", $id, $this->get_client_ip()));	
			
			if($result->num_rows > 0) 
			{
				return true;
			} else {
				return false;	
			}
		}
				
		//////////////////////////////////////////////
		// Get the Number of Questions
		/////////////////////////////////////////////
		public function get_number_of_questions($id)
		{
			$id = $this->mysqli->real_escape_string($this->sanitize_integer($id));
			$result = $this->mysqli->query(sprintf("SELECT survey_id FROM questions WHERE survey_id = '%d'", $id));	
			return $result->num_rows;
		}
		
		///////////////////////////////////////////
		// Get the Number of Answers
		//////////////////////////////////////////
		public function get_number_of_answers($id)
		{
			$id = $this->mysqli->real_escape_string($this->sanitize_integer($id));
			$result = $this->mysqli->query(sprintf("SELECT question_id FROM results WHERE question_id = '%d'", $id));	
			return $result->num_rows;
		}
		
		//////////////////////////////
		// Count Survey
		/////////////////////////////
		public function counts($what, $id='')
		{
			$id = $this->mysqli->real_escape_string($this->sanitize_integer($id));
			switch($what) 
			{
				case "Surveys":
					$result = $this->mysqli->query("SELECT id FROM survey"); 
					return $result->num_rows;
				break;
				
				case "Took_Survey":
					$result = $this->mysqli->query(sprintf("SELECT MIN(id) AS id FROM took_survey WHERE survey_id = '%d' GROUP BY IP", $id));
					return $result->num_rows;	
				break;
				
				case "Questions":
					$result = $this->mysqli->query("SELECT id FROM questions");
					return $result->num_rows;	
				break;
				
				case "Answers":
					$result = $this->mysqli->query(sprintf("SELECT id FROM results WHERE survey_id = '%s'",$id));
					return $result->num_rows;	
				break;
				
				case "All_Answers":
					$result = $this->mysqli->query("SELECT id FROM results");
					return $result->num_rows;	
				break;
						
			}	
		}
		
		///////////////////////////////////////////////////
		// Render Question Types (For Select Form)
		//////////////////////////////////////////////////
		public function render_question_types_selects()
		{
			$buffer = '';
			foreach($this->question_types as $qk => $qn)
			{
				$buffer .= '<option value="'.$qk.'">'.$qn.'</option>';	
			}
			return $buffer;
		}
		
		///////////////////////////////////////////////////////////////////
		// Render Question Requeriment (For Select Form)
		//////////////////////////////////////////////////////////////////
		public function render_question_requeriment($id, $text_a, $text_b)
		{
			$id = $this->mysqli->real_escape_string($this->sanitize_integer($id));
			
			$result = $this->mysqli->query(sprintf("SELECT requeriment FROM questions WHERE survey_id = '%d'", $id));
			$row = $result->fetch_assoc();	
			$result_set = $row['requeriment'];
			
			if($result_set == 0 || $result_set == '0')
			{
				$render = '
					<label class="radio inline">
					   <input type="radio" name="requeriment" checked="checked" value="0"> '.$text_a.'
					</label>
					<label class="radio inline">
					   <input type="radio" name="requeriment" value="1"> '.$text_b.'
					</label>
					';
			} else {
				$render = '
					<label class="radio inline">
					   <input type="radio" name="requeriment" value="0"> '.$text_a.'
					</label>
					<label class="radio inline">
					   <input type="radio" name="requeriment" checked="checked" value="1"> '.$text_b.'
					</label>
					';
			}
								
			return $render;
		}
		
		////////////////////////////////////////////
		// Gets the name of a survey
		///////////////////////////////////////////
		public function get_survey_info($id, $info)
		{
			$sanitized_id = $this->sanitize_integer($id);
			
			if($sanitized_id !== false)
			{
				$result = $this->mysqli->query(sprintf("SELECT name, password FROM survey WHERE id = '%d'", $sanitized_id));
				
				if($result->num_rows !== 0)
				{
					$survey = $result->fetch_assoc();
					if($info == 'name')
					{
						return $survey['name'];
					} elseif($info == 'password') {
						return $survey['password'];	
					}
				} else {
					return false;	
				}
			} else {
				return false;	
			}
		}
		
		///////////////////////////////////////////////
		// Gets questions of survey
		//////////////////////////////////////////////
		public function get_questions_info($id, $info)
		{
			$sanitized_id = $this->sanitize_integer($id);
			
			if($sanitized_id !== false)
			{
				$result = $this->mysqli->query(sprintf("SELECT survey_id, questions, question_type FROM questions WHERE id = '%d'", $sanitized_id));
				
				if($result->num_rows !== 0)
				{
					$survey = $result->fetch_assoc();
					if($info == 'questions')
					{
						return $survey['questions'];
					} elseif($info == 'question_type') {
						return $survey['question_type'];	
					} elseif($info == 'survey_id') {
						return $survey['survey_id'];
					}						
				} else {
					return false;	
				}
			} else {
				return false;	
			}	
		}
		
		/////////////////////////////////////////////
		// Gets the order of the last question
		/////////////////////////////////////////////
		public function get_last_question_order($survey_id)
		{
			$sanitized_id = $this->sanitize_integer($survey_id);
			
			if($sanitized_id !== false)
			{
				$result = $this->mysqli->query(sprintf("SELECT questions.order FROM questions WHERE survey_id = '%d' ORDER BY questions.order DESC LIMIT 1", $sanitized_id));
				if($result->num_rows !== 0)
				{
					$res = $result->fetch_assoc();
					return $res['order']; // last question added with order x
				} else {
					return 'no_results'; // first question of the survey with order 1
				}
			} else {
				return false;	
			}
		}
		
		////////////////////////////////////////////////////
		// Find if user already took survey (same ip and survey)
		////////////////////////////////////////////////////
		public function user_already_took_survey($survey_id, $ip)
		{
			$sanitized_id = $this->sanitize_integer($survey_id);
			
			$to_replace = array('+', '%3A');
			$replaces = array(' ', ':');
			
			if(isset($_COOKIE['took_survey_time']))
			{
				$date = str_replace($to_replace, $replaces, $_COOKIE['took_survey_time']);	
			} 
			
			if($sanitized_id !== false)
			{
				if(isset($date) && strlen($date) !== 0) 
				{
					$result = $this->mysqli->query(sprintf("SELECT id, survey_id, page FROM took_survey WHERE survey_id = '%d' AND date = '%s' ORDER BY survey_id DESC LIMIT 1", $sanitized_id, $this->mysqli->real_escape_string($date)));
				} else {
					$result = $this->mysqli->query(sprintf("SELECT id, survey_id, page FROM took_survey WHERE survey_id = '%d' AND IP = '%s' ORDER BY survey_id DESC LIMIT 1", $sanitized_id, $this->mysqli->real_escape_string($ip)));	
				}
				
				if($result->num_rows == 0)
				{
					return 'no_results';
				} else {
					$res = $result->fetch_assoc();
					if($res['page'] == 0)
					{
						return false;	
					} else {
						return $res['id'];	
					}
				}
			} else {
				return false;	
			}
		}
		
		public function user_already_answered_page($survey_id, $ip, $id)
		{ 
			$survey_id_id = $this->sanitize_integer($survey_id);
			$id_id = $this->sanitize_integer($id);
			
			$to_replace = array('+', '%3A');
			$replaces = array(' ', ':');
			
			if(isset($_COOKIE['took_survey_time']))
			{
				$date = str_replace($to_replace, $replaces, $_COOKIE['took_survey_time']);	
			}
			
			if($survey_id_id !== false && $id_id !== false)
			{
				if(isset($date) && strlen($date) !== 0)
				{
					$result = $this->mysqli->query(sprintf("SELECT page FROM took_survey WHERE survey_id = '%d' AND date = '%s' AND id = '%d' LIMIT 1", $survey_id_id, $date, $id_id));	
				} else {
					$result = $this->mysqli->query(sprintf("SELECT page FROM took_survey WHERE survey_id = '%d' AND IP = '%s' AND id = '%d' AND page = 0 LIMIT 1", $survey_id_id, $ip, $id_id));	
				}
				
				if($result->num_rows == 0)
				{
					return false;
				} else {
					$res = $result->fetch_assoc();
					return $res['page'];
				}
			} else {
				return false;	
			}	
		}
		
		///////////////////////////////////
		// Check if answer exists
		//////////////////////////////////
		public function answer_exists($id)
		{
			$query = sprintf("SELECT question_id FROM answers WHERE question_id = '%d'", $this->mysqli->real_escape_string($id));
			
			$result = $this->mysqli->query($query);	
			
			if($result->num_rows > 0)
			{
				return true;
			} else {
				return false;
			}
		}
		
		///////////////////////////////////
		// Check if result exists
		//////////////////////////////////
		public function results_exists($id)
		{
			$query = sprintf("SELECT question_id FROM results WHERE question_id = '%d'", $this->mysqli->real_escape_string($id));
			
			$result = $this->mysqli->query($query);	
			
			if($result->num_rows > 0)
			{
				return true;
			} else {
				return false;
			}
		}
		
		//////////////////////////////
		// List Surveys
		/////////////////////////////
		public function listSurveys()
		{
			$result = $this->mysqli->query("SELECT survey.id as survey_ID, survey.name, survey.password FROM survey ORDER BY survey.id DESC");
			return $this->results($result);
		}
		
		////////////////////////////////////
		// List Surveys to Launch
		///////////////////////////////////
		public function listSurveysLaunch()
		{
			$result = $this->mysqli->query("SELECT DISTINCT name, survey.id AS survey_ID FROM survey INNER JOIN questions ON survey.id = questions.survey_id ORDER BY survey.id DESC");
			return $this->results($result);
		}
		
		///////////////////////////////////
		// List Questions
		//////////////////////////////////
		public function listQuestions($id)
		{
			$result = $this->mysqli->query(sprintf("SELECT questions.id as question_ID, questions.survey_id, questions.questions, questions.order, questions.question_type, questions.requeriment FROM questions WHERE survey_id = '%d' ORDER BY questions.id DESC", $this->mysqli->real_escape_string($id)));
			return $this->results($result);
		}
		
		public function listSortableQuestions($id)
		{
			$result = $this->mysqli->query(sprintf("SELECT questions.id as question_ID, questions.survey_id, questions.questions, questions.order, questions.question_type FROM questions WHERE survey_id = '%d' ORDER BY questions.order ASC", $this->mysqli->real_escape_string($id)));
			return $this->results($result);
		}
		
		/////////////////////////////////////
		// List Live Surveys
		////////////////////////////////////
		public function listLiveSurveys()
		{
			$result = $this->mysqli->query(sprintf("SELECT survey.id as survey_ID, templating.id as TID, survey.name FROM templating INNER JOIN survey ON survey.id = templating.survey_id ORDER BY TID DESC"));
			
			if($result->num_rows !== 0)
			{
				return $this->results($result);	
			} else {
				return false;	
			}
		}
		
		////////////////////////////////
		// List Answer
		///////////////////////////////
		public function listAnswer($id, $select)
		{
			$result = $this->mysqli->query(sprintf("SELECT %s FROM answers WHERE question_id = '%d'", $this->mysqli->real_escape_string($select), $this->mysqli->real_escape_string($id)));
			return $this->results($result);
		}
		
		/////////////////////////////
		// Get Surveys
		////////////////////////////
		public function getSurveys()
		{
			$result = $this->mysqli->query("SELECT survey.id as survey_ID, questions.id as questions_ID, questions.questions, survey.name FROM questions INNER JOIN survey ON survey.id = questions.survey_id ORDER BY survey.id DESC");	

			// Organize Data
			if($result->num_rows !== 0)
			{
				// manipulate required data
				while($value = $result->fetch_assoc()) 
				{
					$new_set['questions'][] = $value['questions'];
					$new_set['questions_ID'][] = $value['questions_ID'];
					$new_set['survey'][] = $value['name'];
					$new_set['survey_ID'][] = $value['survey_ID'];
				}
				
				$final_set['survey'] = array_merge(array_unique($new_set['survey']), array());
				$final_set['survey_ID'] = array_merge(array_unique($new_set['survey_ID']), array());
				
				// count questions
				foreach($final_set['survey_ID'] as $q)
				{
					$final_set['questions'][] = $this->get_number_of_questions($q);	
				}
								
				for($i = 0; $i <= count($final_set['survey']) - 1; $i++)
				{
					$s_set[$i] = array(
						'survey' => $final_set['survey'][$i],
						'survey_ID' => $final_set['survey_ID'][$i],
						'questions' => $final_set['questions'][$i]
					);
				}
				
				return $s_set;
			} else {
				return false;	
			}

		}
		
		
		////////////////////////////////
		// Get Answer results
		///////////////////////////////
		public function get_result($id)
		{
			$result = $this->mysqli->query(sprintf("SELECT answer, IP FROM results WHERE question_id = '%d' ORDER BY id DESC", $this->mysqli->real_escape_string($id)));
			return $this->results($result);
		}
		
		////////////////////////////////////////////
		// Get Live Survey
		///////////////////////////////////////////
		public function get_live_survey($from, $id)
		{
			$result = $this->mysqli->query(sprintf("SELECT %s, survey.id as survey_ID, templating.id as TID FROM templating INNER JOIN survey ON survey.id = templating.survey_id WHERE templating.id = '%d'", $this->mysqli->real_escape_string($from), $this->mysqli->real_escape_string($id)));
			$return = $result->fetch_assoc();
			return $return[$from];
		}
		
		//////////////////////////////////
		// Get Answer Rate
		/////////////////////////////////
		public function get_answer_rate($qid)
		{
			$result = $this->mysqli->query(sprintf("SELECT COUNT(question_id) AS cnt FROM results WHERE question_id = '%d' GROUP BY question_id HAVING(cnt>1)", $this->mysqli->real_escape_string($qid)));
			$rows = $result->fetch_assoc();

			if($this->mysqli->affected_rows == 1)
			{
				$answers = $this->counts('All_Answers');
				$rate_count = (int)$rows['cnt'];
				$rate = $rate_count / $answers;
				$rate = round($rate, 2)*100;
				
				if($rate == 0)
				{
					return 0;
				} else {
					return $rate.'%';	
				}	
			} else {
				return 0;	
			}
		}
		
		/////////////////////////////////////////////
		// Get location of most users
		////////////////////////////////////////////
		public function get_most_user_location($qid)
		{
			$result = $this->mysqli->query(sprintf("SELECT IP, COUNT(*) as counted FROM results WHERE question_id = '%d' GROUP BY IP ORDER BY COUNT(*) DESC LIMIT 1", $this->mysqli->real_escape_string($qid)));
			$rows = $result->fetch_assoc();
			return $rows['IP'];
			
		}
		
		//////////////////////////////////////////
		// Check templating survey
		//////////////////////////////////////////
		public function check_template_survey($select, $from_id, $id)
		{
			$result = $this->mysqli->query(sprintf("SELECT %s FROM templating WHERE %s = %s LIMIT 1",  $this->mysqli->real_escape_string($select), $this->mysqli->real_escape_string($from_id), $this->mysqli->real_escape_string($id)));
			$row = $result->fetch_assoc();
			return $row[$select];
		}
		
		///////////////////////////////////////////////
		// Render Statistics Pie Chart Data
		///////////////////////////////////////////////
		public function find_question_type($qid)
		{
			$result = $this->mysqli->query(sprintf("SELECT question_type FROM results WHERE question_id = '%d'", $this->mysqli->real_escape_string($qid)));	
			$row = $result->fetch_assoc();	
			return $row['question_type'];
		}
		
		public function chart_data($qid, $qtype)
		{
			$result = $this->mysqli->query(sprintf("SELECT answer, COUNT(*) as qtd FROM results WHERE question_type = '%s' AND question_id = '%d' GROUP BY answer", $this->mysqli->real_escape_string($qtype), $this->mysqli->real_escape_string($qid)));	
			$rows = $this->results($result);
			return $rows;	
		}
		
		public function render_pie_chart($qid, $qtype)
		{
			$rows = $this->chart_data($qid, $qtype);
			
			switch($qtype)
			{
				case "yes_no":
				case "radio":
				case "multiple_choice":
				case "dropdown_menu":
				case "matrix_single":
				case "matrix_multi_select":
					$res = '';
					foreach($rows as $v)
					{
						$res .= '{ label: "'.$v['answer'].'", data: '.$v['qtd'].'},';
					}
					return rtrim($res,',');
				break;
			}
			
		}
		
		/**********************************************************************************************
		* Write Context
		***********************************************************************************************/
		
		////////////////////////////////////////////////
		// Create Survey
		///////////////////////////////////////////////
		public function create_survey($name, $password)
		{
			$query = sprintf('INSERT INTO survey
									SET 
										name = "%s",
										password = "%s"
						',
										$this->mysqli->real_escape_string(htmlentities($name, ENT_QUOTES, 'UTF-8')),
										$this->mysqli->real_escape_string(htmlentities($password, ENT_QUOTES, 'UTF-8'))
						);
			
			$result = $this->mysqli->query($query);	
			
			if($this->mysqli->affected_rows == 1)
			{
				return true;
			} else {
				return false;
			}
		}
		
		//////////////////////////////////////////////////////////////////////////////////
		// Add Question
		/////////////////////////////////////////////////////////////////////////////////
		public function add_question($question, $survey_id, $torder, $question_type, $requeriment)
		{
			// void duplicated questions
			$check_query = sprintf("SELECT * FROM questions WHERE questions = '%s' AND question_type = '%s' AND survey_id = '%d'", $this->mysqli->real_escape_string($question), $this->mysqli->real_escape_string($question_type), $this->mysqli->real_escape_string($survey_id));
			
			$result_check = $this->mysqli->query($check_query);
			
			if($this->mysqli->affected_rows == 1)
			{
				return false; // possible duplication
			} 
			
			$query = sprintf("INSERT INTO questions
								SET 
									questions.survey_id = '%d',
									questions.questions = '%s',
									questions.order = '%s',
									questions.question_type = '%s',
									questions.requeriment = '%s'
					",
									$this->mysqli->real_escape_string($survey_id),
									$this->mysqli->real_escape_string(htmlentities($question, ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string($torder),
									$this->mysqli->real_escape_string(htmlentities($question_type, ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string($requeriment)
					);
					
				$result = $this->mysqli->query($query);	
		
				if($this->mysqli->affected_rows == 1)
				{
					return $this->mysqli->insert_id;
				} else {
					return false;
				}
		}
		
		/////////////////////////////////////////////////////////////////////////////////////////
		// Add Answer
		////////////////////////////////////////////////////////////////////////////////////////
		public function add_answer($answer, $css_class, $position, $question_type, $question_id)
		{
			$query = sprintf("INSERT INTO answers
								SET 
									answer = '%s',
									question_id = '%d',
									question_type = '%s',
									css = '%s',
									position = '%s'
					",
									$this->mysqli->real_escape_string($answer),
									$this->mysqli->real_escape_string($question_id),
									$this->mysqli->real_escape_string($question_type),
									$this->mysqli->real_escape_string(htmlentities($css_class, ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string($position)
					);
					
				$result = $this->mysqli->query($query);	
		
				if($this->mysqli->affected_rows == 1)
				{
					return true;
				} else {
					return false;
				}
		}
		
		/////////////////////////////////////////////////////////////////////////////////////////
		// Add Result
		////////////////////////////////////////////////////////////////////////////////////////
		public function add_result($survey_id, $question_id, $answer, $question_type, $IP, $page)
		{
			$query = sprintf("INSERT INTO results
								SET 
									survey_id = '%d',
									question_id = '%d',
									answer = '%s',
									question_type = '%s',
									IP = '%s'
					",
									$this->mysqli->real_escape_string($survey_id),
									$this->mysqli->real_escape_string($question_id),
									$this->mysqli->real_escape_string(htmlentities($answer, ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string($question_type),
									$this->mysqli->real_escape_string($IP)
					);
					
				$result = $this->mysqli->query($query);	
		
				if($this->mysqli->affected_rows == 1)
				{
					// update current user tooking survey status (same ip and survey)
					if($page !== 0)
					{
						if($this->user_already_took_survey($survey_id, $IP) == 'no_results')
						{
							// insert it one time to after update its progress
							$this->insert_user_took_survey($survey_id, $IP, $page);
						} else {
							// just update its progress
							$this->update_user_took_survey($survey_id, $IP, $page);
						}
					} elseif($page == 0 && $this->user_already_took_survey($survey_id, $IP) == 'no_results') {
						// insert it
						$this->insert_user_took_survey($survey_id, $IP, $page);
						// if can't insert just update
					} else {
						$this->update_user_took_survey($survey_id, $IP, $page);		
					}
					
					return true;
				} else {
					return false;
				}
		}
		
		private function insert_user_took_survey($survey_id, $IP, $page)
		{
			$date = date('Y-m-d H:i:s', time());
			
			setcookie('took_survey_time', $date, time()+60*60*24*30);
			
			$query = sprintf("SELECT IP FROM took_survey WHERE IP = '%s'", $this->mysqli->real_escape_string($IP));
			
			$result = $this->mysqli->query($query);
			
			if($result->num_rows > 1)
			{
				// found so do not insert to avoid duplication
			} else {
				$query = sprintf("INSERT INTO took_survey
							SET 
								survey_id = '%d',
								IP = '%s',
								date = '%s',
								page = '%s'
				",
								$this->mysqli->real_escape_string($survey_id),
								$this->mysqli->real_escape_string($IP),
								$this->mysqli->real_escape_string($date),
								$this->mysqli->real_escape_string($page)
				);
				
				$result = $this->mysqli->query($query);	
			}
							
		}
		
		private function update_user_took_survey($survey_id, $IP, $page)
		{
			$date = date('Y-m-d H:i:s', time());
			
			setcookie('took_survey_time', $date, time()+60*60*24*30);

			$query = sprintf("UPDATE took_survey
						SET 
							survey_id = '%d',
							IP = '%s',
							date = '%s',
							page = '%s'
						WHERE
							id = '%d'
			",
							$this->mysqli->real_escape_string($survey_id),
							$this->mysqli->real_escape_string($IP),
							$this->mysqli->real_escape_string($date),
							$this->mysqli->real_escape_string($page),
							$this->user_already_took_survey($survey_id, $IP)
			);
			$result = $this->mysqli->query($query);				
		}
		
		///////////////////////////////////////
		// Publish Survey
		///////////////////////////////////////
		public function publish_survey($post)
		{ 
			$query = sprintf("INSERT INTO templating
								SET 
									survey_id = '%d',
									title = '%s',
									heading = '%s',
									sub_heading = '%s',
									intro = '%s',
									description = '%s',
									note = '%s',
									footer = '%s',
									template_rule = '%s',
									sessions = '%s',
									theme = '%s'
									
					",
									$this->mysqli->real_escape_string($post['survey']),
									$this->mysqli->real_escape_string(htmlentities($post['title'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['heading'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['sub-heading'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['intro'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['description'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['note'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['footer'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string($post['template_rule']),
									$this->mysqli->real_escape_string($post['sessions']),
									$this->mysqli->real_escape_string($post['theme'])
					);	
			
			$result = $this->mysqli->query($query);	
			
			if($this->mysqli->affected_rows == 1)
			{
				return true;
			} else {
				return false;
			}
		}
		
		/////////////////////////////////////////////////////////////////////////////////////////
		// Update Answer
		////////////////////////////////////////////////////////////////////////////////////////
		public function update_answer($answer, $css_class, $position, $question_type, $question_id)
		{
			$query = sprintf("UPDATE answers
								SET 
									answer = '%s',
									question_type = '%s',
									css = '%s',
									position = '%s'
								WHERE
									question_id = '%d'
					",
									$this->mysqli->real_escape_string($answer),
									$this->mysqli->real_escape_string($question_type),
									$this->mysqli->real_escape_string(htmlentities($css_class, ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string($position),
									$this->mysqli->real_escape_string($question_id)
					);
					
				$result = $this->mysqli->query($query);	
		
				if($this->mysqli->affected_rows == 1)
				{
					return true;
				} else {
					return false;
				}
		}
		
		/////////////////////////////////////////////////////////////////////////////////////////
		// Update Order
		////////////////////////////////////////////////////////////////////////////////////////
		public function update_order($updateRecordsArray)
		{
			$listingCounter = 1;
			foreach($updateRecordsArray as $recordIDValue)
			{
				$query = sprintf("UPDATE questions
								SET 
									questions.order = '%s'
								WHERE
									questions.id = '%d'
					",
									$this->mysqli->real_escape_string($listingCounter),
									$this->mysqli->real_escape_string($recordIDValue)
					);
					
				$result = $this->mysqli->query($query);	
				
				$listingCounter = $listingCounter + 1;
			}
		}
		
		//////////////////////////////////////////////////
		// Update Survey
		//////////////////////////////////////////////////
		public function edit_survey($name, $password, $id)
		{
			if($password == 'DO_NOT_UPDATE')
			{
				$query = sprintf("UPDATE survey
									SET 
										name = '%s'
									WHERE
										id = '%d'
						",
										$this->mysqli->real_escape_string(htmlentities($name, ENT_QUOTES, 'UTF-8')),
										$this->mysqli->real_escape_string($id)
						);
			} elseif(strlen($name) == 0 && strlen($password) !== 0) {
				$query = sprintf("UPDATE survey
									SET 
										password = '%s'
									WHERE
										id = '%d'
						",
										$this->mysqli->real_escape_string(htmlentities($password, ENT_QUOTES, 'UTF-8')),
										$this->mysqli->real_escape_string($id)
						);
			} else {
				$query = sprintf("UPDATE survey
									SET 
										name = '%s',
										password = '%s'
									WHERE
										id = '%d'
						",
										$this->mysqli->real_escape_string(htmlentities($name, ENT_QUOTES, 'UTF-8')),
										$this->mysqli->real_escape_string(htmlentities($password, ENT_QUOTES, 'UTF-8')),
										$this->mysqli->real_escape_string($id)
						);	
			}
			
			$result = $this->mysqli->query($query);	
			
			if($this->mysqli->affected_rows == 1)
			{
				return true;
			} else {
				return false;
			}
		}
		
		///////////////////////////////////////////////////////////////////////////////////////////
		// Update Question
		///////////////////////////////////////////////////////////////////////////////////////////
		public function edit_question($new_question, $question_type, $requeriment, $id, $survey_id)
		{ 
			if(strlen($new_question) !== 0 && !empty($new_question))
			{
				$query = sprintf("UPDATE questions
									SET 
										survey_id = '%d',
										questions = '%s',
										question_type = '%s',
										requeriment = %s
									WHERE
										id = '%d'
						",
										$this->mysqli->real_escape_string($survey_id),
										$this->mysqli->real_escape_string(htmlentities($new_question, ENT_QUOTES, 'UTF-8')),
										$this->mysqli->real_escape_string($question_type),
										$this->mysqli->real_escape_string($requeriment),
										$this->mysqli->real_escape_string($id)
						);	
			} else {
				$query = sprintf("UPDATE questions
									SET 
										survey_id = '%d',
										question_type = '%s',
										requeriment = %s
									WHERE
										id = '%d'
						",
										$this->mysqli->real_escape_string($survey_id),
										$this->mysqli->real_escape_string($question_type),
										$this->mysqli->real_escape_string($requeriment),
										$this->mysqli->real_escape_string($id)
						);	
			}
			
			$result = $this->mysqli->query($query);	
			
			if($this->mysqli->affected_rows == 1)
			{
				return true;
			} else {
				return false;
			}
		}
		
		///////////////////////////////////////
		// Update Live Survey
		///////////////////////////////////////
		public function edit_liveSurvey($post)
		{ 
			$query = sprintf("UPDATE templating
								SET 
									title = '%s',
									heading = '%s',
									sub_heading = '%s',
									intro = '%s',
									description = '%s',
									note = '%s',
									footer = '%s'
								WHERE
									id = '%d'
					",
									$this->mysqli->real_escape_string(htmlentities($post['title'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['heading'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['sub-heading'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['intro'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['description'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['note'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($post['footer'], ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string($post['id'])
					);	
			
			$result = $this->mysqli->query($query);	
			
			if($this->mysqli->affected_rows == 1)
			{
				return true;
			} else {
				return false;
			}
		}
		
		///////////////////////////////////////////////////////////
		// Update One Field
		//////////////////////////////////////////////////////////
		public function update_on($table, $field, $value, $id)
		{ 
			$query = sprintf("UPDATE %s
								SET 
									%s = '%s'
								WHERE
									id = '%d'
					",
									$this->mysqli->real_escape_string(htmlentities($table, ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($field, ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string(htmlentities($value, ENT_QUOTES, 'UTF-8')),
									$this->mysqli->real_escape_string($id)
					);	
			
			$result = $this->mysqli->query($query);	
			
			if($this->mysqli->affected_rows == 1)
			{
				return true;
			} else {
				return false;
			}
		}
		
		///////////////////////////////////////////////////////////
		// Update settings
		//////////////////////////////////////////////////////////
		public function update_settings($post)
		{ 
			$query = sprintf("UPDATE settings SET value = '%s' WHERE id = 2", $this->mysqli->real_escape_string(htmlentities($post['succes_notice'], ENT_QUOTES, 'UTF-8')));
			$result = $this->mysqli->query($query);	
		
			$query = sprintf("UPDATE settings SET value = '%s' WHERE id = 3", $this->mysqli->real_escape_string(htmlentities($post['took_survey'], ENT_QUOTES, 'UTF-8')));
			$result = $this->mysqli->query($query);	
		
			$query = sprintf("UPDATE settings SET value = '%s' WHERE id = 4", $this->mysqli->real_escape_string(htmlentities($post['per_page'], ENT_QUOTES, 'UTF-8')));
			$result = $this->mysqli->query($query);	
		
			$query = sprintf("UPDATE settings SET value = '%s' WHERE id = 5", $this->mysqli->real_escape_string(htmlentities($post['took_page'], ENT_QUOTES, 'UTF-8')));
			$result = $this->mysqli->query($query);	
		
			$query = sprintf("UPDATE settings SET value = '%s' WHERE id = 6", $this->mysqli->real_escape_string(htmlentities($post['next_button'], ENT_QUOTES, 'UTF-8')));
			$result = $this->mysqli->query($query);	
		
			$query = sprintf("UPDATE settings SET value = '%s' WHERE id = 7", $this->mysqli->real_escape_string(htmlentities($post['submit_button'], ENT_QUOTES, 'UTF-8')));
			$result = $this->mysqli->query($query);	
		
			$query = sprintf("UPDATE settings SET value = '%s' WHERE id = 8", $this->mysqli->real_escape_string(htmlentities($post['choices_hint'], ENT_QUOTES, 'UTF-8')));
			$result = $this->mysqli->query($query);	
																
			return true;
		}
		
		//////////////////////////////////
		// Delete Survey
		//////////////////////////////////
		public function delete_survey($id)
		{
			// Before deleting results and answers find the questions related to results and answers
			$query_s = sprintf("SELECT id FROM questions 
						WHERE 
							survey_id = '%d'
			",
							$id
			);
			
			$res = $this->mysqli->query($query_s);
			
			// Process $res
			$result_set = $this->results($res);
			
			if($res->num_rows !== 0)
			{
				foreach($result_set as $r)
				{	
					$query_1 = $this->mysqli->query(sprintf("DELETE FROM results WHERE question_id = '%d'", $r['id']));
					$query_2 = $this->mysqli->query(sprintf("DELETE FROM answers WHERE question_id = '%d'", $r['id']));
				}
				
			}
			
			// Delete Survey Name
			$query = sprintf("DELETE FROM survey
									WHERE
										id = '%d'
						",
							    $this->mysqli->real_escape_string($id)
						);
			
			$result = $this->mysqli->query($query);	
			
			// Delete Questions of the survey
			$query = sprintf("DELETE FROM questions
									WHERE
										survey_id = '%d'
						",
										$this->mysqli->real_escape_string($id)
						);
			
			$result = $this->mysqli->query($query);
			
			// remove published surveys as well
			$this->delete_liveSurvey_withSurvey($id);
						
			return true;
		}
		
		//////////////////////////////////
		// Delete Question
		//////////////////////////////////
		public function delete_question($id)
		{
			// Before deleting results and answers find the questions related to results and answers
			$query_s = sprintf("SELECT id FROM questions 
						WHERE 
							id = '%d'
			",
							$id
			);
			
			$res = $this->mysqli->query($query_s);
			
			// Process $res
			$result_set = $this->results($res);
			
			if($res->num_rows !== 0)
			{
				foreach($result_set as $r)
				{	
					$query_1 = $this->mysqli->query(sprintf("DELETE FROM results WHERE question_id = '%d'", $r['id']));
					$query_2 = $this->mysqli->query(sprintf("DELETE FROM answers WHERE question_id = '%d'", $r['id']));
				}
				
			}
			
			// Delete Questions of the survey
			$query = sprintf("DELETE FROM questions
									WHERE
										id = '%d'
						",
										$this->mysqli->real_escape_string($id)
						);
			
			$result = $this->mysqli->query($query);
			
			return true;
		}
		
		///////////////////////////////////////
		// Delete Live Survey
		//////////////////////////////////////
		public function delete_liveSurvey($id)
		{
			$query = sprintf("DELETE FROM templating
						WHERE 
							id = '%d'
			",
							$this->mysqli->real_escape_string($id)
			);
			
			$res = $this->mysqli->query($query);
			
			return true;
		}
		
		public function delete_liveSurvey_withSurvey($sid)
		{
			$query = sprintf("DELETE FROM templating
						WHERE 
							survey_id = '%d'
			",
							$this->mysqli->real_escape_string($sid)
			);
			
			$res = $this->mysqli->query($query);
			
			return true;
		}
		
		///////////////////////////////////////
		// Reset Survey
		//////////////////////////////////////
		public function reset_survey_admin_IP($id)
		{
			$query = sprintf("DELETE FROM took_survey
						WHERE 
							survey_id = '%d'
						AND
							IP = '%s'
			",
							$this->mysqli->real_escape_string($id),
							$this->get_client_ip()
			);
			
			$res = $this->mysqli->query($query);

			if($this->mysqli->affected_rows >= 1)
			{
				setcookie('took_survey_time', '', time()-3600);
				return true;	
			} else {
				return false;	
			}
				
		}
		
		/**********************************************************************************************
		* Templating Read Context
		***********************************************************************************************/
		
		// Check weather the survey was published and its valid survey
		public function is_survey_published($id)
		{
			$idx = $this->sanitize_integer($id);
			
			if($idx)
			{
				$result = $this->mysqli->query(sprintf("SELECT survey_id FROM templating WHERE survey_id = '%d'", $this->mysqli->real_escape_string($idx)));
				
				if($this->mysqli->affected_rows == 1)
				{
					return true;
				} else {
					return false;
				}	
			} else {
				return false;	
			}
			
		}
		
		// Gets questions based on the id sort by order
		public function get_question($id, $return)
		{
			$result = $this->mysqli->query(sprintf(
											"SELECT questions.id as question_ID, questions.survey_id, questions.questions, questions.order, questions.question_type, questions.requeriment, answers.answer, answers.css, answers.position 
											FROM questions 
											INNER JOIN answers ON questions.id = answers.question_id 
											WHERE questions.id = '%d'
											ORDER BY questions.order ASC", 
											$this->mysqli->real_escape_string($id))
			);
			
			$rows = $result->fetch_assoc();
			
			if($rows)
			{
				return $rows[$return];
			} else {
				return false;	
			}
		}
		
		// Success Survey
		public function settings_notice($id, $message)
		{
			$result = $this->mysqli->query(sprintf("SELECT value FROM settings WHERE id = '%d'",$id));
				
			if($this->mysqli->affected_rows == 1)
			{
				$rows = $result->fetch_assoc();
				if(strlen($rows['value']) !== 0)
				{
					return $rows['value'];	
				} else { return $message; }
			} else {
				return $message;
			}
		}
		
	}
	
?>