<?php
	
	############################################################################################### 
	#### Login Validation - Internal Validation
	###############################################################################################
	
	// Right Away on Login
	if(isset($_POST['username'], $_POST['password'], $_POST['login'])) 
	{ 
		if(isset($_POST['remember-me']))
		{
			$remember_me = $_POST['remember-me'];	
		} else {
			$remember_me = '';	
		}
		
		$ok = authenticate($_POST['username'], $_POST['password'], $remember_me, USERS_TABLE, $survey);
		
		if($ok == false)
		{
			$_SESSION['mySurvey_loginMessage'] = 'Invalid Credentials';
			header('Location: index.php');
			exit();		
		} elseif(in_array('error_found', $ok)) {
			$_SESSION['mySurvey_loginMessage'] = $ok['error'];
			header('Location: index.php');
			exit();
		}
	}
	
	// Will check all pages that does need authentication (every-time) - direct access example
	// The current pages are those to skip authentication (all pages that are not the login page)
	if(
		basename($_SERVER['PHP_SELF']) !== 'index.php'
	)
	{
		if(!isset($_SESSION['mySurvey_username']) && !isset($_SESSION['mySurvey_authenticated']) && $_SESSION['mySurvey_authenticated'] !== 'TRUE')
		{
			$_SESSION['mySurvey_loginMessage'] = 'Failed to log in';
			header('Location: index.php');
			exit();	
		}
	}
		
	############################################################################################### 
	#### Session Functions
	###############################################################################################
	
	function authenticate($username, $password, $remember_me, $user_table, $survey)
	{
		$mysqli = new mysqli(DB_HOST, DB_USERNAME, DB_PASSWORD, DATABASE);
		
		if($username && $password) 
		{
			$query = sprintf("SELECT * FROM %s WHERE username = '%s' and password = '%s' LIMIT 1", 
								$mysqli->real_escape_string($user_table),
								$mysqli->real_escape_string($username), 
								$mysqli->real_escape_string(sha1($password))
							);
							
			$result = $mysqli->query($query);
			
			$results = $result->fetch_assoc();
			
			// Have a result and was authenticated
			if(!empty($results) && is_array($results))
			{
				if(sha1($password) == $results['password'] && $username == $results['username']) // just to make sure
				{
					$_SESSION['mySurvey_authenticated'] = 'TRUE';
					
					if($_SESSION['mySurvey_authenticated'] == 'TRUE') // if its authenticated before login the user
					{
						if($remember_me == 'checked')
						{
							setcookie('survey_cookie', $results['username'], time()+8200);	
						} elseif($remember_me == '') {
							$_SESSION['mySurvey_token'] = md5(uniqid(mt_rand(), true));
							$_SESSION['mySurvey_username'] = $username;
							$_SESSION['mySurvey_userid'] = $results['id'];
						}
						register_user_login($results['id'], $mysqli, $survey);
					} else {
						return false;	
					}
					
					return $results;		
				}
				
			} elseif($mysqli->errno) {
				 return array('error_found' => 'true', 'error' => mysqli_error());
			} else {
				return false;
			}
			
			$mysqli->close();
		}
	}
	
	// Register User Login
	function register_user_login($user_id, $mysqli, $survey)
	{		
		
		$IP = $survey->get_client_ip();
		
		$query = sprintf("UPDATE %s 
							SET 
								IP = '%s',
								last_login = NOW()
							WHERE 
								id = %s",
							$mysqli->real_escape_string(USERS_TABLE),
							$mysqli->real_escape_string($IP),
							$mysqli->real_escape_string($user_id)
						);
							
		$result = $mysqli->query($query);
		
		$mysqli->close();
	}
	
	// Login Notices Messages
	function login_messages()
	{
		if(isset($_SESSION['mySurvey_loginMessage']))
		{
			echo 
			'
				<div class="alert alert-info">
					 '.$_SESSION['mySurvey_loginMessage'].'
				</div>
			';	
			unset($_SESSION['mySurvey_loginMessage']);
		}
	}
	
?>