<?php
	
    /*************************************************************************
	* 	PHP Password Recover Class
	* 	This is a class for php password recovery
	*
	*	Author: Paulo Regina
	*	Version: 1.0
	*	Copyright (C) 2014 - www.pauloreg.com
	*	
	**************************************************************************/
	
	class PasswordRecover
	{
		
		/////////////////////////////////
		// Generates 16 Chars Reset Code
		////////////////////////////////
		public function code_recover()
		{
			$allowed_chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmopqrstuvwxyz0123456789';
			
			$i = 0;
			$recover_code = '';
			
			while($i <= 15) 
			{
				$num = mt_rand(0, 60);	
				$tmp = substr($allowed_chars, $num, 1);
				$recover_code = $recover_code . $tmp;
				$i++;
			}
			
			return $recover_code;
		}
		
		//////////////////////////
		// Update Activation Code
		/////////////////////////
		public function update_activation_code($email, $code, $mysqli)
		{			
			$query = sprintf("UPDATE %s 
								SET 
									activation_code = '%s',
									activation_validity = '%s'
								WHERE 
									email = '%s'",
								$mysqli->real_escape_string(USERS_TABLE),
								$mysqli->real_escape_string($code),
								$mysqli->real_escape_string(date('Y-m-d H;i:s', strtotime('+1 day'))),
								$mysqli->real_escape_string($email)
							);
								
			$result = $mysqli->query($query);
						
			if($mysqli->affected_rows == 1)
			{
				return true;
			} else {
				return false;
			}
		}
		
		////////////////////////////
		// Validate Activation Code
		///////////////////////////
		public function validate_activation_code($user_input_code, $new_password, $mysqli)
		{
			$current_time = time();	
			
			if(strlen($user_input_code) !== 16)
			{
				// If the code does not have 16 chars skip validation right away and don't waste time
				return 'Invalid reset code';	
			}
			
			$query = sprintf("SELECT activation_code, activation_validity FROM %s WHERE activation_code = '%s' LIMIT 1", 
								$mysqli->real_escape_string(USERS_TABLE),
								$mysqli->real_escape_string($user_input_code)
							);
							
			$result = $mysqli->query($query);
			
			$results = $result->fetch_assoc();
						
			if($mysqli->affected_rows == 1)
			{
				$expire_time = strtotime($results['activation_validity']);
				
				if($current_time >= $expire_time)
				{
					// link has expired cannot change password	
					return 'Cannot change password because link expired.';
				} else {
					// allowed to change password - modify password
					$query = sprintf("UPDATE %s 
								SET 
									password = '%s',
									activation_code = 'null'
								WHERE 
									activation_code = '%s'",
								$mysqli->real_escape_string(USERS_TABLE),
								$mysqli->real_escape_string(sha1($new_password)),
								$mysqli->real_escape_string($user_input_code)
							);
										
					$result = $mysqli->query($query);
								
					if($mysqli->affected_rows == 1)
					{
						return true;
					} else {
						return false;
					}
				}
			} else {
				return 'Invalid reset code';	
			}
			
			$mysqli->close();

		}
		
	}
	
?>