<?php
	session_start();
		
	include('functions.php');

	include('recover.php');
	
	if(count(get_included_files()) ==1) exit("Direct access not permitted.");
	
	$recover = new PasswordRecover();
	
	$mysqli = new mysqli(DB_HOST, DB_USERNAME, DB_PASSWORD, DATABASE);
	
	// Process Form
	if(isset($_POST['new-password']))
	{
		$e_mail = $_POST['email'];
		
		// generate code
		$code = $recover->code_recover();
		
		// update activation code (16chars)
		$activation_code = $recover->update_activation_code($e_mail, $code, $mysqli);
		
		if($activation_code == false) // invalid email and code not updated
		{
			// throw notices
			$_SESSION['survey_notices'] = 'Your e-mail address does not exist';
			header('Location: ../lost-password.php');
			exit();	
		} else {
			// send email	
			send_recover_mail($code, $e_mail);
			header('Location: ../lost-password.php');
			exit();	
		}
		
	}
	
	// Mailing Function
	function send_recover_mail($code, $email)
	{
		$first_name = get_user('first_name', 'email', $email);
		$last_name = get_user('last_name', 'email', $email);
		
		$recover_url = 'http://'.$_SERVER['HTTP_HOST'].'/'.SITE_FOLDER.'/recover.php';
		
		$variables = array('{FIRST_NAME}', '{LAST_NAME}', '{RECOVER_CODE}', '{URL}');
		$replaceble_variables = array($first_name, $last_name, $code, $recover_url);
		
		$read_template = file_get_contents('../recover-mail-template.html');	
		
		$headers = "X-Mailer: mySurvey\r\n";
		$headers .= "Content-Type: text/html; charset=utf-8";
			
		$subject = '[mySurvey Password Recover] Recover your password';
		$message = str_replace($variables, $replaceble_variables, $read_template);
		
		// start sending email
		$send_mail = mail($email, $subject, $message, $headers);
		
		if($send_mail) 
		{
			return $_SESSION['survey_notices'] = 'E-mail was sent successfully';
		} else {
			return $_SESSION['survey_notices'] = 'Failed to send e-mail';
		}
	}
			
?>