<?php
	
	include_once('connection.php');
	
	//////////////////
	// Breadcrumb
	/////////////////
	function breadcrumb($title = '')
	{
		echo '<div class="container p0">';
		echo '<ul class="breadcrumb">';
		if(is_array($title))
		{
			foreach ($title as $url => $label) {
				$isActive = ($url === end(array_keys($title)));
				?>
				<li<?php echo $isActive ? ' class="active"' : ''; ?>>
					<?php if (!$isActive) { ?>
						<a href="<?php echo $url; ?>"><?php echo $label; ?></a>
						<span class="divider">&raquo;</span>
					<?php } else { ?>
						<?php echo $label; ?>
					<?php } ?>
				</li>
			<?php } ?>
			<?php
		} elseif(strlen($title) > 0) {
			?>
			<li><a href="dashboard.php"><span class="bi bi-house-fill"></span>Dashboard</a><span class="divider">&raquo;</span></li>
			<li class="active"><?php echo $title; ?></li>
			<?php
		} else {
			?>
			<li class="active"><a href="dashboard.php"><span class="bi bi-house-fill"></span>Dashboard</a></li>
			<?php
		}
		echo '</ul>';
		echo '</div>';
	}
	
	//////////////////
	// Notices
	/////////////////
	function notices()
	{
		if(isset($_SESSION['survey_notices']))
		{
			if(strpos($_SESSION['survey_notices'], "successfully") !== false)
			{
				echo 
				'
					<div class="alert alert-success">
						 '.$_SESSION['survey_notices'].'
					</div>
				';	
			} else {
				echo 
				'
					<div class="alert alert-warning">
						 '.$_SESSION['survey_notices'].'
					</div>
				';	
			}
			
			unset($_SESSION['survey_notices']);
		}
	}
	
	////////////////////////////////////////////////
	// Get specific information from users table
	///////////////////////////////////////////////
	function get_user($select_field, $column, $row)
	{
		$mysqli = new mysqli(DB_HOST, DB_USERNAME, DB_PASSWORD, DATABASE);
		
		$query = sprintf("SELECT %s FROM %s WHERE %s = '%s'", 
							$mysqli->real_escape_string($select_field),
							$mysqli->real_escape_string(USERS_TABLE), 
							$mysqli->real_escape_string($column),
							$mysqli->real_escape_string($row)
						);
						
		$result = $mysqli->query($query);
		
		$mysqli->close();
		
		$results = $result->fetch_assoc();
		
		return $results[$select_field];

	}
	
	/////////////////////////////
	// Prints logged user
	////////////////////////////
	function print_logged_user()
	{
		if(isset($_SESSION['mySurvey_username']))
		{
			echo $_SESSION['mySurvey_username'];
		} else {
			echo $_COOKIE['survey_cookie'];	
		}
	}
	
	
	/////////////////////////////
	// Boolean to Yes/No
	////////////////////////////
	function yesNo($bool)
	{
		if($bool)
		{
			return 'Yes';
		} else {
			return 'No';
		}
	}
	
	/////////////////////////////
	// Checked/Selected
	////////////////////////////
	function checked( $checked, $current = true, $echo = true ) 
	{
		return __checked_selected_helper( $checked, $current, $echo, 'checked' );
	}

	function selected( $selected, $current = true, $echo = true ) {
		return __checked_selected_helper( $selected, $current, $echo, 'selected' );
	}

	function __checked_selected_helper( $helper, $current, $echo, $type ) 
	{
		if ( (string) $helper === (string) $current ) {
			$result = " $type='$type'";
		} else {
			$result = '';
		}

		if ( $echo ) {
			echo $result;
		}
	}
	
	############################################################################################### 
	#### START DASHBOARD SPECIFIC FUNCTIONS
	###############################################################################################
	
	/////////////////////////////
	// Dashboard Notices
	////////////////////////////
	function dashboard_notices()
	{
		$link = mysqli_connect(DB_HOST, DB_USERNAME, DB_PASSWORD, DATABASE);
		
		$result = mysqli_query($link, "SELECT name, survey_id, question_id FROM survey INNER JOIN results ON results.survey_id=survey.id ORDER BY results.id DESC LIMIT 1");	
		
		$rows = mysqli_fetch_assoc($result);
				
		if(mysqli_affected_rows($link) == 1)
		{
			echo ' The survey: <a href="statistic.php?id='.$rows['question_id'].'"><strong>'.$rows['name'].'</strong></a> has new answers.';	
		} else {
			echo ' No notices yet';	
		}
	}
	
	/////////////////////////////
	// Dashboard Version
	////////////////////////////
	function get_content($URL)
	{
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_URL, $URL);
		$data = curl_exec($ch);
		curl_close($ch);
		return $data;
	}

	function dashboard_version()
	{
		$cur_version = '1.5';
    
		$cached_version = get_cached_version();
		
		if($cached_version) 
		{
			$server_version = $cached_version;
		} else {
			$server_version = get_content('https://pauloreg.com/_updates/mySurvey/update.php');
			cache_version($server_version);
		}
		
		if($server_version) 
		{
			if($server_version == $cur_version) 
			{
				$status = 'mySurvey ('.$cur_version.') is up to date';
			} else {
				$status = 'mySurvey has new version: <a href="https://pauloreg.com/_updates/mySurvey/update_download.php">Update</a>';    
			}
		} else {
			$status = 'mySurvey is up to date';    
		}
		
		echo '<p>&copy '.date('Y').' - '.$status.'</p>';	
	}
	
	// Function to retrieve cached version
	function get_cached_version() 
	{
		$cache_file = 'cached_version.txt';
		if(file_exists($cache_file)) 
		{
			if(time() - filemtime($cache_file) < 24 * 60 * 60) 
			{
				return file_get_contents($cache_file);
			} else {
				unlink($cache_file);
			}
		}
		return false;
	}
	
	// Function to cache version
	function cache_version($version) 
	{
		$cache_file = 'cached_version.txt';
		file_put_contents($cache_file, $version);
	}
	
	///////////////////////////////////////
	// Dashboard Chart
	//////////////////////////////////////
	function render_dashboard_chart_data() 
	{
		$link = mysqli_connect(DB_HOST, DB_USERNAME, DB_PASSWORD, DATABASE);
    
		$chart_data = array();
		
		$current_year = date('Y');
		
		for ($i = 1; $i <= 12; $i++) 
		{
			$month = str_pad($i, 2, '0', STR_PAD_LEFT);
			
			$result = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", $current_year, $month));
			
			$row = mysqli_fetch_assoc($result);
			$count = isset($row['counted']) ? $row['counted'] : 0;
			
			$chart_data[] = '[' . strtotime("{$current_year}-{$month}-01") * 1000 . ', ' . $count . ']';
		}
		
		return '[' . implode(',', $chart_data) . ']';
	}
	
	// will be removed on future releases
	function render_dashboard_chart_data_deprecated()
	{
		$link = mysqli_connect(DB_HOST, DB_USERNAME, DB_PASSWORD, DATABASE);
		
		$result = mysqli_query($link, sprintf("SELECT COUNT(merged.id) AS counted FROM (SELECT id FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s GROUP BY IP) AS merged", date('Y'), date('m')));	
		
		$rows = mysqli_fetch_assoc($result);
		
		if(mysqli_affected_rows($link) >= 1)
		{
			switch(date('m'))
			{
				case '01':
					return '[[1262304000000, '.$rows['counted'].'], [1264982400000, 0], [1267401600000, 0], [1270080000000, 0], [1272672000000, 0], [1275350400000, 0], [1277942400000, 0], [1280620800000, 0], [1283299200000, 0], [1285891200000, 0], [1288569600000, 0], [1291161600000, 0]]';	
				break;
				
				case '02':
					$result = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result); $j = $j['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$rows['counted'].'], [1267401600000, 0], [1270080000000, 0], [1272672000000, 0], [1275350400000, 0], [1277942400000, 0], [1280620800000, 0], [1283299200000, 0], [1285891200000, 0], [1288569600000, 0], [1291161600000, 0]]';	
				break;
				
				case '03':
					$result_j = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result_j); $j = $j['counted'];
					$result_f = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$f = mysqli_fetch_assoc($result_f); $f = $f['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$f.'], [1267401600000, '.$rows['counted'].'], [1270080000000, 0], [1272672000000, 0], [1275350400000, 0], [1277942400000, 0], [1280620800000, 0], [1283299200000, 0], [1285891200000, 0], [1288569600000, 0], [1291161600000, 0]]';	
				break;
				
				case '04':
					$result_j = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result_j); $j = $j['counted'];
					$result_f = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$f = mysqli_fetch_assoc($result_f); $f = $f['counted'];
					$result_m = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$m = mysqli_fetch_assoc($result_m); $m = $m['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$f.'], [1267401600000, '.$m.'], [1270080000000, '.$rows['counted'].'], [1272672000000, 0], [1275350400000, 0], [1277942400000, 0], [1280620800000, 0], [1283299200000, 0], [1285891200000, 0], [1288569600000, 0], [1291161600000, 0]]';	
				break;
				
				case '05':
					$result_j = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result_j); $j = $j['counted'];
					$result_f = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$f = mysqli_fetch_assoc($result_f); $f = $f['counted'];
					$result_m = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('03')));	
					$m = mysqli_fetch_assoc($result_m); $m = $m['counted'];
					$result_a = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('04')));	
					$a = mysqli_fetch_assoc($result_a); $a = $a['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$f.'], [1267401600000, '.$m.'], [1270080000000, '.$a.'], [1272672000000, '.$rows['counted'].'], [1275350400000, 0], [1277942400000, 0], [1280620800000, 0], [1283299200000, 0], [1285891200000, 0], [1288569600000, 0], [1291161600000, 0]]';	
				break;
				
				case '06':
					$result_j = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result_j); $j = $j['counted'];
					$result_f = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$f = mysqli_fetch_assoc($result_f); $f = $f['counted'];
					$result_m = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('03')));	
					$m = mysqli_fetch_assoc($result_m); $m = $m['counted'];
					$result_a = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('04')));	
					$a = mysqli_fetch_assoc($result_a); $a = $a['counted'];
					$result_my = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('05')));	
					$my = mysqli_fetch_assoc($result_my); $my = $my['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$f.'], [1267401600000, '.$m.'], [1270080000000, '.$a.'], [1272672000000, '.$my.'], [1275350400000, '.$rows['counted'].'], [1277942400000, 0], [1280620800000, 0], [1283299200000, 0], [1285891200000, 0], [1288569600000, 0], [1291161600000, 0]]';	
				break;
				
				case '07':
					$result_j = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result_j); $j = $j['counted'];
					$result_f = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$f = mysqli_fetch_assoc($result_f); $f = $f['counted'];
					$result_m = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('03')));	
					$m = mysqli_fetch_assoc($result_m); $m = $m['counted'];
					$result_a = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('04')));	
					$a = mysqli_fetch_assoc($result_a); $a = $a['counted'];
					$result_my = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('05')));	
					$my = mysqli_fetch_assoc($result_my); $my = $my['counted'];
					$result_ju = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('06')));	
					$ju = mysqli_fetch_assoc($result_ju); $ju = $ju['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$f.'], [1267401600000, '.$m.'], [1270080000000, '.$a.'], [1272672000000, '.$my.'], [1275350400000, '.$ju.'], [1277942400000, '.$rows['counted'].'], [1280620800000, 0], [1283299200000, 0], [1285891200000, 0], [1288569600000, 0], [1291161600000, 0]]';	
				break;
				
				case '08':
					$result_j = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result_j); $j = $j['counted'];
					$result_f = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$f = mysqli_fetch_assoc($result_f); $f = $f['counted'];
					$result_m = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('03')));	
					$m = mysqli_fetch_assoc($result_m); $m = $m['counted'];
					$result_a = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('04')));	
					$a = mysqli_fetch_assoc($result_a); $a = $a['counted'];
					$result_my = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('05')));	
					$my = mysqli_fetch_assoc($result_my); $my = $my['counted'];
					$result_ju = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('06')));	
					$ju = mysqli_fetch_assoc($result_ju); $ju = $ju['counted'];
					$result_jy = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('07')));	
					$jy = mysqli_fetch_assoc($result_jy); $jy = $jy['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$f.'], [1267401600000, '.$m.'], [1270080000000, '.$a.'], [1272672000000, '.$my.'], [1275350400000, '.$ju.'], [1277942400000, '.$jy.'], [1280620800000, '.$rows['counted'].'], [1283299200000, 0], [1285891200000, 0], [1288569600000, 0], [1291161600000, 0]]';	
				break;
				
				case '09':
					$result_j = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result_j); $j = $j['counted'];
					$result_f = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$f = mysqli_fetch_assoc($result_f); $f = $f['counted'];
					$result_m = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('03')));	
					$m = mysqli_fetch_assoc($result_m); $m = $m['counted'];
					$result_a = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('04')));	
					$a = mysqli_fetch_assoc($result_a); $a = $a['counted'];
					$result_my = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('05')));	
					$my = mysqli_fetch_assoc($result_my); $my = $my['counted'];
					$result_ju = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('06')));	
					$ju = mysqli_fetch_assoc($result_ju); $ju = $ju['counted'];
					$result_jy = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('07')));	
					$jy = mysqli_fetch_assoc($result_jy); $jy = $jy['counted'];
					$result_ag = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('08')));	
					$ag = mysqli_fetch_assoc($result_ag); $ag = $ag['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$f.'], [1267401600000, '.$m.'], [1270080000000, '.$a.'], [1272672000000, '.$my.'], [1275350400000, '.$ju.'], [1277942400000, '.$jy.'], [1280620800000, '.$ag.'], [1283299200000, '.$rows['counted'].'], [1285891200000, 0], [1288569600000, 0], [1291161600000, 0]]';	
				break;
				
				case '10':
					$result_j = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result_j); $j = $j['counted'];
					$result_f = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$f = mysqli_fetch_assoc($result_f); $f = $f['counted'];
					$result_m = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('03')));	
					$m = mysqli_fetch_assoc($result_m); $m = $m['counted'];
					$result_a = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('04')));	
					$a = mysqli_fetch_assoc($result_a); $a = $a['counted'];
					$result_my = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('05')));	
					$my = mysqli_fetch_assoc($result_my); $my = $my['counted'];
					$result_ju = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('06')));	
					$ju = mysqli_fetch_assoc($result_ju); $ju = $ju['counted'];
					$result_jy = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('07')));	
					$jy = mysqli_fetch_assoc($result_jy); $jy = $jy['counted'];
					$result_ag = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('08')));	
					$ag = mysqli_fetch_assoc($result_ag); $ag = $ag['counted'];
					$result_st = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('09')));	
					$st = mysqli_fetch_assoc($result_st); $st = $st['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$f.'], [1267401600000, '.$m.'], [1270080000000, '.$a.'], [1272672000000, '.$my.'], [1275350400000, '.$ju.'], [1277942400000, '.$jy.'], [1280620800000, '.$ag.'], [1283299200000, '.$st.'], [1285891200000, '.$rows['counted'].'], [1288569600000, 0], [1291161600000, 0]]';	
				break;
				
				case '11':
					$result_j = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result_j); $j = $j['counted'];
					$result_f = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$f = mysqli_fetch_assoc($result_f); $f = $f['counted'];
					$result_m = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('03')));	
					$m = mysqli_fetch_assoc($result_m); $m = $m['counted'];
					$result_a = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('04')));	
					$a = mysqli_fetch_assoc($result_a); $a = $a['counted'];
					$result_my = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('05')));	
					$my = mysqli_fetch_assoc($result_my); $my = $my['counted'];
					$result_ju = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('06')));	
					$ju = mysqli_fetch_assoc($result_ju); $ju = $ju['counted'];
					$result_jy = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('07')));	
					$jy = mysqli_fetch_assoc($result_jy); $jy = $jy['counted'];
					$result_ag = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('08')));	
					$ag = mysqli_fetch_assoc($result_ag); $ag = $ag['counted'];
					$result_st = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('09')));	
					$st = mysqli_fetch_assoc($result_st); $st = $st['counted'];
					$result_ou = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('10')));	
					$ou = mysqli_fetch_assoc($result_ou); $ou = $ou['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$f.'], [1267401600000, '.$m.'], [1270080000000, '.$a.'], [1272672000000, '.$my.'], [1275350400000, '.$ju.'], [1277942400000, '.$jy.'], [1280620800000, '.$ag.'], [1283299200000, '.$st.'], [1285891200000, '.$ou.'], [1288569600000, '.$rows['counted'].'], [1291161600000, 0]]';	
				break;
				
				case '12':
					$result_j = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('01')));	
					$j = mysqli_fetch_assoc($result_j); $j = $j['counted'];
					$result_f = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('02')));	
					$f = mysqli_fetch_assoc($result_f); $f = $f['counted'];
					$result_m = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('03')));	
					$m = mysqli_fetch_assoc($result_m); $m = $m['counted'];
					$result_a = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('04')));	
					$a = mysqli_fetch_assoc($result_a); $a = $a['counted'];
					$result_my = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('05')));	
					$my = mysqli_fetch_assoc($result_my); $my = $my['counted'];
					$result_ju = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('06')));	
					$ju = mysqli_fetch_assoc($result_ju); $ju = $ju['counted'];
					$result_jy = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('07')));	
					$jy = mysqli_fetch_assoc($result_jy); $jy = $jy['counted'];
					$result_ag = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('08')));	
					$ag = mysqli_fetch_assoc($result_ag); $ag = $ag['counted'];
					$result_st = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('09')));	
					$st = mysqli_fetch_assoc($result_st); $st = $st['counted'];
					$result_ou = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('10')));	
					$ou = mysqli_fetch_assoc($result_ou); $ou = $ou['counted'];
					$result_nov = mysqli_query($link, sprintf("SELECT COUNT(id) AS counted FROM took_survey WHERE YEAR(date) = %s AND MONTH(date) = %s LIMIT 1", date('Y'), date('11')));	
					$nov = mysqli_fetch_assoc($result_nov); $nov = $nov['counted'];
					return '[[1262304000000, '.$j.'], [1264982400000, '.$f.'], [1267401600000, '.$m.'], [1270080000000, '.$a.'], [1272672000000, '.$my.'], [1275350400000, '.$ju.'], [1277942400000, '.$jy.'], [1280620800000, '.$ag.'], [1283299200000, '.$st.'], [1285891200000, '.$ou.'], [1288569600000, '.$nov.'], [1291161600000, '.$rows['counted'].']]';	
				break;
			}
		} else {
			return '[[1262304000000, 0], [1264982400000, 0], [1267401600000, 0], [1270080000000, 0], [1272672000000, 0], [1275350400000, 0], [1277942400000, 0], [1280620800000, 0], [1283299200000, 0], [1285891200000, 0], [1288569600000, 0], [1291161600000, 0]]';	
		}
	}

?>