<?php
	
    include('loader.php');
	
	include('geoiploc.php');
	
	if(count(get_included_files()) ==1) exit("Direct access not permitted.");
	
	$qid = $_GET['id'];
	$qtype = $_GET['qtype'];
	
	header('Content-Type: text/csv; charset=utf-8');
	header('Content-Disposition: attachment; filename=statistic-'.$qid.'.csv');	
	
	$output = fopen('php://output', 'w');
	
	$sname = $_SESSION['survey_name'];
	
	// Some Math/Stats
	$raw = $survey->chart_data($qid, $qtype);

	$total = array_sum($survey->array_values_recursive($raw));
	
	$buffer = '';

	foreach($raw as $v)
	{
		$buffer .= round($v['qtd']/$total, 2)*100 . '% says: ' . $v['answer'] . ' | ';
	}
	
	$buffer = rtrim($buffer, ' | ');
			
	$list = array(
		array('Survey Name: '.$sname),
		array('Question: '.$survey->get_questions_info($qid, 'questions')),
		array(''),
		array(''),
		array('Survey Statistics:'),
		array($survey->get_number_of_answers($qid) . ' answered this question'),
		array('Most of the users are from: '. getCountryFromIP($survey->get_most_user_location($qid), 'name')),
		array('The answer rate to this question is: '. $survey->get_answer_rate($qid)),
		array($buffer)
	);
	
	foreach ($list as $fields) {
    	fputcsv($output, $fields);
	}
	
?>
