<?php 
	include("includes/loader.php");
	include("includes/logoutHandler.php"); 
	include("includes/functions.php"); 
	include("tpl/header.php"); 
	include("tpl/nav.php"); 
	
	$id = intval($_GET['id']);
	if(!isset($id) || $id == 0)
	{
		header('Location: launch_survey.php');
		exit();
	}
?>
        
    <!-- MAIN -->
    <div id="main">
		
		<!-- Breadcrumb -->
		<?php 
		breadcrumb(array(
			'dashboard.php' 	=> '<span class="bi bi-house-fill"></span>Dashboard',
			'launch_survey.php' => 'Launch Survey',
			'edit_live.php' => 'Edit Live Survey',
		)); ?>
        <!-- // Breadcrumb -->
        
        <!-- container -->
        <div class="container bg">
        	
            <!-- row -->
            <div class="row">
            	
                <div class="col-md-3 ps-0"><!-- col-md-3 -->
					<?php include_once('tpl/sidebar.php'); ?>
				</div><!-- // col-md-3 -->
                
                <div class="col-md-9 pe-0"><!-- col-md-9 -->
					<div class="pagetitle">
						<h2>Edit: <?php echo $survey->get_live_survey('name', $id); ?></h2>
					</div>
					
					<!-- MAIN CONTENT -->      
					<div id="main-content">
						
						<div class="notice_messages"></div>
						
						<div class="box">
							<div class="header">
								<h4>Edit Survey Template: <?php echo $survey->get_live_survey('name', $id); ?></h4>
							</div> 
							<div class="content">
								
								<form id="liveSurvey-form" class="form-horizontal margin-reset" method="post">
												 
									<div class="row pad20">
										<div class="col-3">
										   Title:
										</div>
										<div class="col-5">
											<input type="text" name="title" class="form-control" value="<?php echo $survey->get_live_survey('title', $id); ?>" />
											<p class="help-block">Hint: The title for the survey</p>
										</div>
									</div>
									
									<div class="separator"></div>
									
									<div class="row pad20">
										<div class="col-3">
										   Heading:
										</div>
										<div class="col-5">
											<input type="text" name="heading" class="form-control" value="<?php echo $survey->get_live_survey('heading', $id); ?>" />
											<p class="help-block">Hint: The heading</p>
										</div>
									</div>
									
									<div class="separator"></div>
									
									<div class="row pad20">
										<div class="col-3">
										   Sub Heading:
										</div>
										<div class="col-5">
											<input type="text" name="sub-heading" class="form-control" value="<?php echo $survey->get_live_survey('sub_heading', $id); ?>" />
											<p class="help-block">Hint: The subheading</p>
										</div>
									</div>
									
									<div class="separator"></div>
									
									<div class="row pad20">
										<div class="col-3">
											Intro:
										</div>
										<div class="col-5">
											<input type="text" name="intro" class="form-control" value="<?php echo $survey->get_live_survey('intro', $id); ?>" />
											<p class="help-block">Hint: The introductory text for the survey</p>
										</div>
									</div>
									
									<div class="separator"></div>
									
									<div class="row pad20">
										<div class="col-3">
										   Description:
										</div>
										<div class="col-5">
											<input type="text" name="description" class="form-control" value="<?php echo $survey->get_live_survey('description', $id); ?>" />
											<p class="help-block">Hint: The description of the survey</p>
										</div>
									</div>
									
									<div class="separator"></div>
									
									<div class="row pad20">
										<div class="col-3">
										   Note:
										</div>
										<div class="col-5">
											<input type="text" name="note" class="form-control" value="<?php echo $survey->get_live_survey('note', $id); ?>" />
											<p class="help-block">Hint: Some note to the survey</p>
										</div>
									</div>
									
									<div class="separator"></div>
									
									<div class="row pad20">
										<div class="col-3">
										   Footer:
										</div>
										<div class="col-5">
											<input type="text" name="footer" class="form-control" value="<?php echo $survey->get_live_survey('footer', $id); ?>" />
											<p class="help-block">Hint: Custom footer</p>
										</div>
									</div>
									
									<input type="hidden" name="id" id="id" value="<?php echo $id; ?>" />
									
									<div class="form-actions">
										<div class="float-end pad20">
											<button type="submit" name="save-live-changes" data-option="save-live-changes" class="btn btn-success">Save Changes</button>
										</div>
									</div>
									
								</form>
							  
							</div>
						</div>
						
					</div>
					<!-- // MAIN CONTENT -->
				</div>
				<!-- // col-md-9 -->
 
            </div>
            <!-- // row -->
        </div>
        <!-- // container -->
    </div>
    <!-- // MAIN --> 
    
    <?php include("tpl/footer.php"); ?>

