<?php 
	include("includes/loader.php");
	include("includes/logoutHandler.php"); 
	include("includes/functions.php"); 
	include("tpl/header.php"); 
	include("tpl/nav.php"); 
	
	$userID = $_SESSION['mySurvey_userid'];
	$first_name = $user->get_user_('first_name', $userID);
	$last_name = $user->get_user_('last_name', $userID);
	$fullName = $first_name.' '.$last_name;
	if($first_name == '' && $last_name == '')
	{
		$fullName = $user->get_user_('username', $userID);
	}
?>

    <!-- MAIN -->
    <div id="main">
    	
        <!-- Breadcrumb -->
		<?php breadcrumb(); ?>
        <!-- // Breadcrumb -->
        
        <!-- container -->
        <div class="container bg">
        	
            <!-- row -->
            <div class="row">
            	
                <div class="col-md-3 ps-0"><!-- col-md-3 -->
					<?php include_once('tpl/sidebar.php'); ?>
				</div><!-- // col-md-3 -->
                
                <div class="col-md-9 pe-0"><!-- span9 -->
					<div class="pagetitle">
						<h2>Dashboard</h2>
						<p>Welcome <a href="profile.php?id=<?php echo $userID; ?>"><?php echo $fullName; ?></a>.</p>
					</div>

					<!-- MAIN CONTENT -->
					<div id="main-content">

						<!-- Quick Buttons -->
						<div class="quick-buttons">
							<div class="row">
								<?php if($user->is_admin()): ?>
									<div class="col-md-3">
										<a href="create_survey.php" class="btn btn-light btn-block">
											<i class="bi bi-speedometer"></i>
											<span class="dasboard-icons-title">Create</span>
										</a>
									</div>
									<div class="col-md-3">
										<a href="manage_survey.php" class="btn btn-light btn-block">
											<i class="bi bi-card-checklist"></i>
											<span class="dasboard-icons-title">Manage</span>
										</a>
									</div>
								<?php endif; ?>
								<div class="col-md-3">
									<a href="survey_statistics.php" class="btn btn-light btn-block">
										<i class="bi bi-graph-up"></i>
										<span class="dasboard-icons-title">Statistics</span>
									</a>
								</div>
								<?php if($user->is_admin()): ?>
									<div class="col-md-3">
										<a href="settings.php" class="btn btn-light btn-block">
											<i class="bi bi-gear"></i>
											<span class="dasboard-icons-title">Settings</span>
										</a>
									</div>
								<?php endif; ?>
							</div>
						</div>
						<!-- // Quick Buttons -->

						<!-- chart (box full column) -->
						<div class="box">
							<div class="header">
								<h4>Users Took Survey</h4>
							</div>
							<div class="content pad">
								<div class="chart" id="dashboard-chart"></div>
							</div>
						</div>
						<!-- // chart -->

						<div class="clearfix"></div>

					</div>
					<!-- // MAIN CONTENT -->
				</div>
				<!-- // col-md-9 -->
 
				
            </div>
            <!-- // row -->
        </div>
        <!-- // container -->
    </div>
    <!-- // MAIN -->
    <script type="text/javascript">
		(function($) {
	
			"use strict";
			var dashboardChart = <?php echo json_encode(render_dashboard_chart_data()); ?>;
			
			document.addEventListener("DOMContentLoaded", () => {
				google.charts.load('current', {'packages':['corechart']});
				google.charts.setOnLoadCallback(drawLineChart);

				function drawLineChart() {
					var data = new google.visualization.DataTable();
					data.addColumn('string', 'Months');
					data.addColumn('number', 'Total');
					
					var parsedData = JSON.parse(dashboardChart);
					for (var i = 0; i < parsedData.length; i++) {
						var date = new Date(parsedData[i][0]);
						var monthName = date.toLocaleString('default', { month: 'short' });
						data.addRow([monthName, parsedData[i][1]]);
					}

					var options = {
						title: '',
						curveType: 'function',
						legend: { position: 'none' },
						hAxis: {
							title: '' + new Date(parsedData[0][0]).getFullYear(),
							titleTextStyle: {
								fontSize: 14,
								bold: true,
								color: '#485b79'
							}
						},
						chartArea: {
							left: 50,
							right: 20,
							top: 20,
							bottom: 50
						}
					};

					var chart = new google.visualization.LineChart(document.getElementById('dashboard-chart'));
					chart.draw(data, options);
				}
			});
		})(jQuery);
	</script>
    
    <?php include("tpl/footer.php"); ?>

