<?php 
	include("includes/loader.php");
	include("includes/logoutHandler.php"); 
	include("includes/functions.php"); 
	include("tpl/header.php"); 
	include("tpl/nav.php"); 
	
	$id = intval($_GET['id']);
	if(!isset($id) || $id == 0)
	{
		header('Location: manage_survey.php');
		exit();
	}
?>
        
    <!-- MAIN -->
    <div id="main">
    	
		<!-- Breadcrumb -->
		<?php 
		$questionsLink = 'questions.php?id='.$survey->get_questions_info($id, 'survey_id');
		breadcrumb(array(
			'dashboard.php' 	=> '<span class="bi bi-house-fill"></span>Dashboard',
			'manage_survey.php' => 'Manage Surveys',
			$questionsLink => 'Questions',
			'answers.php' => 'Answers',
		)); ?>
        <!-- // Breadcrumb -->
        
        <!-- container -->
        <div class="container bg">
        	
            <!-- row -->
            <div class="row">
            	
                <div class="col-md-3 ps-0"><!-- col-md-3 -->
					<?php include_once('tpl/sidebar.php'); ?>
				</div><!-- // col-md-3 -->
                
                <div class="col-9 pe-0"><!-- col-md-9 --> 
					<div class="pagetitle">
						<?php if ($survey->get_questions_info($id, 'questions') == true) { ?>    
						<h2><?php echo $survey->get_questions_info($id, 'questions'); ?></h2>
						<?php } else {
							// not valid survey id and not valid id 
							header('Location: manage_survey.php');
							exit();
						} ?>
					</div>
					
					<!-- MAIN CONTENT -->      
					<div id="main-content">
						<div class="notice_messages"></div>
						<div class="box">
							<div class="header"><h4>Answers</h4></div> 
							<div class="content">
								<?php if ($survey->answer_exists($id) == false) { ?>
								<form id="answers" class="form-horizontal" method="post">
									<input type="hidden" id="question_type" name="question_type" value="<?php echo $survey->get_questions_info($id, 'question_type') ?>" />
									<input type="hidden" id="q_id" name="q_id" value="<?php echo $id; ?>" />
									<?php include('includes/tpl-form-handler.php'); ?>
								</form>
								<?php } else { ?>
								<form id="answers" class="form-horizontal" method="post">
									<input type="hidden" id="question_type" name="question_type" value="<?php echo $survey->get_questions_info($id, 'question_type') ?>" />
									<input type="hidden" id="q_id" name="q_id" value="<?php echo $id; ?>" />
									<?php include('includes/tpl-update_form-handler.php'); ?>
								</form>
								<?php } ?>           
							</div>
						</div>
					</div>
					<!-- // MAIN CONTENT -->
				</div>
				<!-- // col-9 --> 
				
            </div>
            <!-- // row -->
        </div>
        <!-- // container -->
    </div>
    <!-- // MAIN --> 
    
    <?php include("tpl/footer.php"); ?>