@extends('layouts.master')

@section('title', 'Terms and Conditions')

@section('content')
    <section id="wrapper">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-block">
                    <h2>{{ $app_name }} - Terms and Conditions</h2>
                    <p>This is an agreement ("user agreement" or "agreement") between {{ $app_name }} ("we", "our,"
                        "us") and you. This agreement sets the terms of your use of the {{ $app_name }} website and
                        services - which include our forums and direct messaging. This agreement is meant to encourage a
                        fair and tolerant place for ideas, people, links, and discussion.
                    </p>
                    <p>This agreement is a legal contract between you and us. You acknowledge that you have read,
                        understood, and agree to be bound by the terms of this agreement. If you do not agree to this
                        agreement, you should not use {{ $app_name }}. Please take a look at {{ $app_name }}'s Privacy
                        Policy too—it explains how we collect and use your information.
                    </p>
                    <p>Without advance notice and at any time, we may, for violations of this agreement or for any other
                        reason we choose: (1) suspend your access to {{ $app_name }}, (2) suspend or terminate Your
                        Account or subscription, and/or (3) remove any of your User Content from {{ $app_name }} forums.
                    </p>
                    <p>You are responsible for all use of the Services made using your username and password, whether or
                        not the use is made by you or someone else using your username and password. You are responsible
                        for protecting and securing your username and password from unauthorised use. If you believe
                        there has been a breach of security of your username you should notify {{ $app_name }}
                        . {{ $app_name }}, at its absolute discretion, reserves the right to refuse a user permission to
                        use any particular user name and/or password. It is not permitted to impersonate or to attempt
                        to impersonate another user or to make use of or attempt to make use of another user's user name
                        or password and any such actions may result in legal action, including criminal prosecution.
                    </p>
                    <p>We reserve the right to monitor {{ $app_name }}, and your use of the Service means you agree to
                        such monitoring. At the same time, we do not guarantee we will monitor at all.
                    </p>
                    <p>{{ $app_name }} is designed and supported for personal use only. You may not use {{ $app_name }}
                        to break the law, violate an individual's privacy, or infringe any person or entity’s
                        intellectual property or any other proprietary rights.
                    </p>
                    <p>{{ $app_name }} is intended to be a place for your entertainment. We are not responsible for any
                        decisions you make based on something you read on {{ $app_name }}.
                    </p>
                    <p>{{ $app_name }} is not intended to be a marketplace for any goods or services. For this reason,
                        any transactions you undertake are your responsibility alone, so be careful.
                    </p>
                    <p>You may not use {{ $app_name }} to conduct transactions for any illegal goods or services.
                    </p>
                    <p>To participate on {{ $app_name }}, you must create an account that includes a username and
                        password ("Your Account") and, if you want to be able to reset your password or have us contact
                        you, an email address as well. Of course, you can also browse {{ $app_name }} without logging
                        in.
                    </p>
                    <p>You are solely responsible for the information associated with Your Account and anything that
                        happens related to Your Account.
                    </p>
                    <p>You may not license, transfer, sell, or assign Your Account without our written approval.
                    </p>
                    <p>You retain the rights to your copyrighted content or information that you submit
                        to {{ $app_name }} ("user content") except as described below.
                    </p>
                    <p>By submitting user content to {{ $app_name }}, you grant us a royalty-free, perpetual,
                        irrevocable, non-exclusive, unrestricted, worldwide license to reproduce, prepare derivative
                        works, distribute copies, perform, or publicly display your user content in any medium and for
                        any purpose, including commercial purposes, and to authorize others to do so.
                    </p>
                    <p>You agree that you have the right to submit anything you post, and that your user content does
                        not violate the copyright, trademark, trade secret or any other personal or proprietary right of
                        any other party.
                    </p>
                    <p>Please take a look at {{ $app_name }}'s Privacy Policy for an explanation of how we may use or
                        share information submitted by you or collected from you.
                    </p>
                    <p>We take no responsibility for, we do not expressly or implicitly endorse, and we do not assume
                        any liability for any user content submitted by you to {{ $app_name }}.
                    </p>
                    <p>Neither {{ $app_name }} nor any of its Data Providers or affiliates make any warranties expressed
                        or implied, as to the accuracy, adequacy, quality or fitness for any particular purpose of the
                        Information or the Services for a particular purpose or use and all such warranties are
                        expressly excluded to the fullest extent that such warranties may be excluded by law. You bear
                        all risks from any uses or results of using any Information. You are responsible for validating
                        the integrity of any Information received over the Internet. Neither {{ $app_name }} nor its
                        Data Providers or affiliates accept liability for any costs, losses or damages resulting from or
                        related to the availability or content of the Services. The Services or any part do not
                        constitute an offer or solicitation to sell investments in any jurisdiction.
                    </p>
                    <p>You irrevocably indemnify {{ $app_name }} and its Data Providers and affiliates from and against
                        any and all losses, damages and costs suffered or incurred by {{ $app_name }}, any Data
                        Providers or affiliates of whatsoever nature arising out of or in connection with your use,
                        provision or distribution of Information or any part or the Services or any part or otherwise
                        howsoever arising in relation to any breach of this Agreement by you.
                    </p>
                    <p>Due to the number of sources from which {{ $app_name }} obtains content and the nature of
                        electronic distribution via the world wide web neither {{ $app_name }} nor any of its Data
                        Providers nor affiliates have any liability (whether in contract or tort) for any losses, costs
                        or damages resulting from or related to use of or inability to use any Information contained in
                        the Services or the provision of the Services to the fullest extent to which such liability may
                        be excluded or avoided by law and in no event shall {{ $app_name }} be liable to you for lost
                        profits or for indirect, incidental, special, punitive or consequential damages arising out of
                        or in relation to the Services or the provision of Information. {{ $app_name }} makes no
                        warranty that the Service is free from infection by viruses or anything else that has
                        contaminating or destructive properties.
                    </p>
                    <p>Due to the number of sources from which {{ $app_name }} obtains content and the nature of
                        electronic distribution via the world wide web neither {{ $app_name }} nor any of its Data
                        Providers nor affiliates have any liability (whether in contract or tort) for any losses, costs
                        or damages resulting from or related to use of or inability to use any Information contained in
                        the Services or the provision of the Services to the fullest extent to which such liability may
                        be excluded or avoided by law and in no event shall {{ $app_name }} be liable to you for lost
                        profits or for indirect, incidental, special, punitive or consequential damages arising out of
                        or in relation to the Services or the provision of Information. {{ $app_name }} makes no
                        warranty that the Service is free from infection by viruses or anything else that has
                        contaminating or destructive properties.
                    </p>
                    <p>{{ $app_name }} is a place with many third-party hyperlinks posted by users like you. We are not
                        responsible for the content or actions of any third party websites or services associated with
                        posted links. You agree to take sole legal responsibility for any links you post, and neither
                        this agreement nor our privacy policy applies to any content on other websites related to those
                        links. You should consult the terms and privacy policies of those other websites to understand
                        your rights.
                    </p>
                    <p>You also agree to follow the {{ $app_name }}'s Content policy. These guidelines are intended to
                        keep people safe, protect kids, keep {{ $app_name }} running, and to encourage personal
                        responsibility for what you do on {{ $app_name }}.
                    </p>
                    <p>You may not post any graphics, text, photographs, images, video, audio or other material that we
                        deem to be junk or spam. Cluttering {{ $app_name }} with this sort of content reduces the
                        quality of the {{ $app_name }} experience for others. We reserve the right to determine what
                        spam is and to delete it for the benefit of users. If you feel you content has been deleted
                        unfairly you have the chance to email us with your reasons why. You may not post your own
                        affiliate links on the site.
                    </p>
                    <p>You agree not to interrupt the serving of {{ $app_name }}, introduce malicious code
                        onto {{ $app_name }}, make it difficult for anyone else to use {{ $app_name }} due to your
                        actions, or assist anyone in misusing {{ $app_name }} in any way.
                    </p>
                    <p>{{ $app_name }} is not directed at people under the age of 13, and {{ $app_name }} does not
                        knowingly collect any personal information from such people. If you know that a user under the
                        age of 13 is accessing {{ $app_name }}, please <a href="{{ route('contact.index') }}">contact us</a>.
                    </p>
                    <p>{{ $app_name }}, at our discretion, provide you with services including, but not restricted to,
                        news and information services. You agree to comply with the conditions imposed on your use of
                        the services, as set out in these Terms and Conditions of Access and elsewhere in our services.
                        These services may be outside our control or provided by a third party in which in case we
                        cannot take responsibility for their content, or for any delays, interruptions or errors in the
                        provisions of these additional services, provided we have exercised reasonable care and
                        diligence in the selection of such providers.
                    </p>
                    <p>Certain data accessible on our services is the intellectual property of the relevant news and
                        information services provider or third parties that provide such data to the relevant service
                        provider, or us. The data is protected by copyright and other intellectual laws and all
                        ownership rights remain with the information service provider or the third party or us, as the
                        case may be.
                    </p>
                    <p>The data is provided "as is". We, any information service provider or any third party shall not
                        be liable to you or any third party for any loss or damage, direct, indirect or consequential,
                        arising from (i) any inaccuracy or incompleteness in, or delays, interruptions, errors or
                        omissions in the delivery of the data or any other information supplied to you through our
                        services or (ii) any decision made or action taken by you or any third party in reliance upon
                        the data. Nor shall we, any information service provider or any third party be liable for loss
                        of business revenues, lost profits or any punitive, indirect, consequential, special or similar
                        damages whatsoever, whether in contract, tort or otherwise, even if advised of the possibility
                        of such damages incurred by you or any third party.
                    </p>
                    <p>Where the information consists of pricing or performance data, the data contained therein has
                        been obtained from sources believed reliable. Data computations are not guaranteed by any
                        information service provider, third party or us or any affiliates and may not be complete.
                        Neither we, any information service provider, nor any third party give any warranties, as to the
                        accuracy, adequacy, quality or fitness, timeless, non-infringement, title, of any information
                        for a particular purpose or use and all such warranties are expressly excluded to the fullest
                        extent that such warranties may be excluded by law. You bear all risk from any use or results of
                        using any information. You are responsible for validating the integrity of any information
                        received over the Internet.
                    </p>
                    <p>Transmission may be subject to arbitrary delays beyond our control, which may delay the provision
                        of our services and the execution of your orders. You acknowledge that neither we, any
                        information service provider, nor any third party will be liable to you or any third party for
                        any losses arising from such delay.
                    </p>
                    <p>In no event will we, any information provider, or third party be liable for any consequential
                        loss including but not limited to special, incidental, direct or indirect damages resulting from
                        delay or loss of use of our services. We are not responsible for any damage to your computer,
                        software, modem, telephone or other property resulting from your use of our services.
                    </p>
                    <p>Any claim or dispute between you and us arising out of or relating to this user agreement, in
                        whole or in part, shall be governed by the laws of the United kingdom.
                    </p>
                    <p>If any provision of this user agreement is held invalid or unenforceable, that provision will be
                        modified to the extent necessary to render it enforceable without losing its intent. If no such
                        modification is possible, that provision will be severed from the rest of this agreement.
                    </p>
                    <p>This user agreement is the entire agreement between you and us concerning {{ $app_name }}. It
                        supersedes all prior or contemporaneous agreements between you and us. We may modify this user
                        agreement at any time. If we make changes to this agreement that materially affect your rights,
                        we will provide advance notice and keep this edition available as an archive on
                        the {{ $app_name }} website. By continuing to use {{ $app_name }} after a change to this
                        agreement, you agree to those changes.
                    </p>
                </div>
            </div>
        </div>
    </section>
@stop