SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

CREATE TABLE `coin_daily_histories` (
  `id` INT (10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `symbol` VARCHAR (20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` DATE NOT NULL,
  `timestamp` BIGINT (20) UNSIGNED NOT NULL DEFAULT 0,
  `value` DECIMAL (20, 10) NOT NULL DEFAULT 0.0000000000,
  `volume` BIGINT (20) UNSIGNED NOT NULL DEFAULT 0,
  `last_updated` DATETIME NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `coin_daily_histories_symbol_date_unique` (`symbol`, `date`),
  KEY `coin_daily_histories_symbol_index` (`symbol`),
  KEY `coin_daily_histories_date_index` (`date`)
) ENGINE = INNODB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `coins` (
  `id` INT (10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `coin_id` VARCHAR (32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` VARCHAR (180) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` VARCHAR (32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` VARCHAR (180) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_usd` DECIMAL (16, 4) DEFAULT NULL,
  `price_btc` DECIMAL (16, 4) DEFAULT NULL,
  `volume_usd_24h` DECIMAL (24, 2) DEFAULT NULL,
  `market_cap_usd` DECIMAL (24, 2) DEFAULT NULL,
  `available_supply` DECIMAL (24, 2) DEFAULT NULL,
  `total_supply` DECIMAL (24, 2) DEFAULT NULL,
  `max_supply` DECIMAL (24, 2) DEFAULT NULL,
  `percent_change_1h` DECIMAL (12, 4) DEFAULT NULL,
  `percent_change_24h` DECIMAL (12, 4) DEFAULT NULL,
  `percent_change_7d` DECIMAL (12, 4) DEFAULT NULL,
  `proof_type` VARCHAR (120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` VARCHAR (191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter` VARCHAR (191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` TEXT COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `features` TEXT COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `technology` TEXT COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `algorithm` TEXT COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` DATE DEFAULT NULL,
  `last_updated` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `coins_symbol_unique` (`symbol`),
  KEY `coins_coin_id_index` (`coin_id`),
  KEY `coins_name_index` (`name`)
) ENGINE = INNODB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `currencies` (
  `id` INT (10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `symbol` VARCHAR (3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` DECIMAL (10, 5) DEFAULT NULL,
  `last_updated` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `currencies_symbol_unique` (`symbol`)
) ENGINE = INNODB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `migrations` (
  `id` INT (10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `migration` VARCHAR (191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` INT (11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE = INNODB AUTO_INCREMENT = 13 DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `news` (
  `id` INT (10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `hashid` VARCHAR (20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published_on` DATETIME NOT NULL,
  `title` TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` TEXT COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_updated` DATETIME NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `news_hashid_unique` (`hashid`),
  KEY `news_published_on_index` (`published_on`),
  KEY `news_last_updated_index` (`last_updated`)
) ENGINE = INNODB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `password_resets` (
  `email` VARCHAR (191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` VARCHAR (191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` TIMESTAMP NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE = INNODB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;

CREATE TABLE `users` (
  `id` INT (10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uuid` VARCHAR (32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` VARCHAR (191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` VARCHAR (191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` VARCHAR (191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password_changed_at` TIMESTAMP NULL DEFAULT NULL,
  `active` TINYINT (1) NOT NULL DEFAULT 1,
  `role` VARCHAR (6) COLLATE utf8mb4_unicode_ci NOT NULL,
  `confirmation_code` VARCHAR (191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed` TINYINT (1) NOT NULL DEFAULT 1,
  `remember_token` VARCHAR (100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` TIMESTAMP NULL DEFAULT NULL,
  `updated_at` TIMESTAMP NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_uuid_unique` (`uuid`),
  UNIQUE KEY `users_email_unique` (`email`),
  KEY `users_role_index` (`role`)
) ENGINE = INNODB DEFAULT CHARSET = utf8mb4 COLLATE = utf8mb4_unicode_ci;


-- Data for the table `migrations`

insert  into `migrations`(`id`,`migration`,`batch`) values (1,'2014_10_12_000000_create_users_table',1);
insert  into `migrations`(`id`,`migration`,`batch`) values (2,'2014_10_12_100000_create_password_resets_table',1);
insert  into `migrations`(`id`,`migration`,`batch`) values (3,'2017_12_13_124122_create_coins_table',1);
insert  into `migrations`(`id`,`migration`,`batch`) values (4,'2017_12_13_124131_create_currencies_table',1);
insert  into `migrations`(`id`,`migration`,`batch`) values (5,'2017_12_15_104334_create_coin_daily_histories_table',1);
insert  into `migrations`(`id`,`migration`,`batch`) values (6,'2017_12_16_082351_create_news_table',1);


-- Data for the table `coins`

INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '42 Coin', '42', '42.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://42-coin.org/', '@42newchain', 'Everything about 42 coin is 42 - apart from the transaction fees and difficulty retargetting - 0.00000001 and 7.5mins. A scrypt coin with 42 coins max, a 42 second block time, with superblocks giving 10 times the standard block reward of 0.0000420 42\'s.', '', '', 'Scrypt', '2014-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '365Coin', '365', '365.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, '365Coin is a Proof of Work and Proof of Stake cryptocurrency. This coin has a 50% APR in staking rewards and a 11% premine (299 million coins)', '', '', 'X11', '2016-02-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '404Coin', '404', '404.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, '404 is a PoW/PoS hybrid cryptocurrency that allows users to send and recieve instant payments. 404 coin rewards users for maintaining the 404 Blockchain through mining or staking 404 coins.', '', '', 'Scrypt', '2016-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SixEleven', '611', '611.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://anti.cash/', NULL, '611 is a Namecoin based cryptocurrency, and it allows data sharing and storing within its blockchain, app and cloud service creation as well as fast and gobal transactions. SixEleven\'s name comes from its coin supply, 611000', '', '', 'SHA256', '2016-09-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '808', '808', '808.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@808BassCoin', '808 is a coin develop for the music community as a tribute to the TR-808 Rhythm Composer, also known as the \"808\", one of the first programmable drum machines. 808 is a Proof of Work/Proof of Stake hybrid and uses the SHA256 hashing algorithm.', '', '', 'SHA256', '2018-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Octocoin', '888', '888.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://octocoinfoundation.org/', NULL, 'Octocoin is a Proof of Work cryptocurrency. It was launched on BTC Talk on Mar 08, 2014 at 18:08 (UTC) and later abandoned by it\'s original developer of the same name. On Nov 11, 2015 a new developer steps up and released an updated client, thus reviving Octocoin.', '', '', '', '2014-08-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '1337', '1337', '1337.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, '1337 coin was created as an experimental Proof-of-Stake coin, with high rewards and inflation control system. It\'s a fun driven cryptocurrency that develops games for users and plans to be used as an ingame currency for online games.', '', '', 'X13', '2016-08-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '2015 coin', '2015', '2015.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Twenty15 Coin was conceived to be an asset backed \'sweat equity\' currency. The main emphasis will be on creating assets that will generate revenue, and will also be available for purchase by other Crypto enthusiasts. These assets will be available for public demonstration or full usage, but also sold to interested parties for 2015 Coins.', '', '', 'X11', '2014-01-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Bitcoin', 'BTC', 'btc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://bitcoin.org/', '@bitcoin', 'Bitcoin uses peer-to-peer technology to operate with no central authority or banks; managing transactions and the issuing of bitcoins is carried out collectively by the network. Although other cryptocurrencies have come before, Bitcoin is the first decentralized cryptocurrency - Its reputation has spawned copies and evolution in the space.\n\nWith the largest variety of markets and the biggest value - having reached a peak of 18 billion USD - Bitcoin is here to stay. As with any new invention, there can be improvements or flaws in the initial model however the community and a team of dedicated developers are pushing to overcome any obstacle they come across. It is also the most traded cryptocurrency and one of the main entry points for all the other cryptocurrencies. The price is as unstable as always and it can go up or down by 10%-20% in a single day.\n\nBitcoin is an SHA-256 POW coin with 21,000,000 total minable coins. The block time is 10 minutes. See below for a full range of Bitcoin markets where you can trade US Dollars for Bitcoin, crypto to Bitcoin and many other fiat currencies too.\n\nLearn about the history of Bitcoin [here](https://fried.com/history-of-bitcoin/) and check out 50 crazy-fun facts about Bitcoin [here](https://bitcoinplay.net/58-insane-facts-about-bitocin/)!', '**Mobile payments made easy** Bitcoin on mobiles allows you to pay with a simple two step scan-and-pay. No need to sign up, swipe your card, type a PIN, or sign anything. All you need to receive Bitcoin payments is to display the QR code in your Bitcoin wallet app and let your friend scan your mobile, or touch the two phones together (using NFC radio technology).\n\n**Security and control over your money** Bitcoin transactions are secured by military grade cryptography. Nobody can charge you money or make a payment on your behalf. So long as you take the required steps to protect your wallet, Bitcoin can give you control over your money and a strong level of protection against many types of fraud.\n\n**Works everywhere, anytime** Just like with email, you don\'t need to ask your family to use the same software or the same service providers. Just let them stick to their own favorites. No problem there; they are all compatible as they use the same open technology. The Bitcoin network never sleeps, even on holidays!\n\n**Fast international payments** Sending bitcoins across borders is as easy as sending them across the street. There are no banks to make you wait three business days, no extra fees for making an international transfer, and no special limitations on the minimum or maximum amount you can send.\n\n**Choose your own fees** There is no fee to receive bitcoins, and many wallets let you control how large a fee to pay when spending. Most wallets have reasonable default fees, and higher fees can encourage faster confirmation of your transactions. Fees are unrelated to the amount transferred, so it\'s possible to send 100,000 bitcoins for the same fee it costs to send 1 bitcoin.\n\n**Protect your identity** With Bitcoin, there is no credit card number that some malicious actor can collect in order to impersonate you. In fact, it is even possible to send a payment without revealing your identity, almost just like with physical money. You should however take note that some effort can be required to protect your privacy.', '**Balances - block chain** The block chain is a shared public ledger on which the entire Bitcoin network relies. All confirmed transactions are included in the block chain. This way, Bitcoin wallets can calculate their spendable balance and new transactions can be verified to be spending bitcoins that are actually owned by the spender. The integrity and the chronological order of the block chain are enforced with cryptography.\n\n**Transactions - private keys** A transaction is a transfer of value between Bitcoin wallets that gets included in the block chain. Bitcoin wallets keep a secret piece of data called a private key or seed, which is used to sign transactions, providing a mathematical proof that they have come from the owner of the wallet. The signature also prevents the transaction from being altered by anybody once it has been issued. All transactions are broadcast between users and usually begin to be confirmed by the network in the following 10 minutes, through a process called mining.\n\n**Processing - mining** Mining is a distributed consensus system that is used to confirm waiting transactions by including them in the block chain. It enforces a chronological order in the block chain, protects the neutrality of the network, and allows different computers to agree on the state of the system. To be confirmed, transactions must be packed in a block that fits very strict cryptographic rules that will be verified by the network. These rules prevent previous blocks from being modified because doing so would invalidate all following blocks. Mining also creates the equivalent of a competitive lottery that prevents any individual from easily adding new blocks consecutively in the block chain. This way, no individuals can control what is included in the block chain or replace parts of the block chain to roll back their own spends.', 'SHA256', '2009-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ethereum', 'ETH', 'eth.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.ethereum.org/', '@ethereumproject', 'Ethereum is a decentralized platform that runs smart contracts: applications that run exactly as programmed without any possibility of downtime, censorship, fraud or third party interference. In the Ethereum protocol and blockchain there is a price for each operation. The general idea is, in order to have things transferred or executed by the network, you have to [consume or burn Gas](/coins/guides/what-is-the-gas-in-ethereum/). The cryptocurrency is called Ether and is used to pay for computation time and for transaction fees.\n\nIf you want to earn block rewards from the network, you can join the network as a miner. Follow the link for a [guide on how to mine Ethereum on a Windows Pc](/mining/guides/how-to-mine-ethereum/). The much easier but a bit more expensive way is to [buy an Ethereum mining contract](/mining/guides/how-to-mine-ethereum-the-easy-way-an-ethereum-mining-contract/).\n\nEthereum is how the Internet was supposed to work. As long as you have enough funds to pay for your code to be run by the network, your contacts will always be up and running.\n\nIt was crowdfunded during August 2014 by fans all around the world. It is developed and maintained by ETHDEV with contributions from great minds across the globe. There is also an Ethereum foundation and there are multiple startups working with the Ethereum blockchain.\n\nEthereum is currently on the \"Homestead\" stage and all its related software is still considered Beta until the release of the next stage \"Metropolis\".\n\nIf you are looking for a GUI interface for your wallet, try the [Ethereum Wallet DApp](/wallets/ethereum-wallet-dapp/). It\'s still in beta so be careful when you use it.\n\nOur block explorer data bellow is freely provided by [etherchain.org](https://etherchain.org/) and [etherscan.io](http://etherscan.io/).', 'Ethereum is a platform that is intended to allow people to easily write decentralized applications (Đapps) using blockchain technology. A decentralized application is an application which serves some specific purpose to its users, but which has the important property that the application itself does not depend on any specific party existing. Rather than serving as a front-end for selling or providing a specific party\'s services, a Đapp is a tool for people and organizations on different sides of an interaction use to come together without any centralized intermediary.\n\nContracts generally serve four purposes:\n\n\\- Maintain a data store representing something which is useful to either other contracts or to the outside world; one example of this is a contract that simulates a currency, and another is a contract that records membership in a particular organization.\n\n\\- Serve as a sort of externally owned account with a more complicated access policy; this is called a \"forwarding contract\" and typically involves simply resending incoming messages to some desired destination only if certain conditions are met; for example, one can have a forwarding contract that waits until two out of a given three private keys have confirmed a particular message before resending it (ie. multisig). More complex forwarding contracts have different conditions based on the nature of the message sent; the simplest use case for this functionality is a withdrawal limit that is overrideable via some more complicated access procedure.\n\n\\- Manage an ongoing contract or relationship between multiple users. Examples of this include a financial contract, an escrow with some particular set of mediators, or some kind of insurance. One can also have an open contract that one party leaves open for any other party to engage with at any time; one example of this is a contract that automatically pays a bounty to whoever submits a valid solution to some mathematical problem, or proves that it is providing some computational resource.\n\n\\- Provide functions to other contracts; essentially serving as a software library.\n\nContracts interact with each other through an activity that is alternately called either \"calling\" or \"sending messages\". A \"message\" is an object containing some quantity of ether (a special internal currency used in Ethereum with the primary purpose of paying transaction fees), a byte-array of data of any size, the addresses of a sender and a recipient. When a contract receives a message it has the option of returning some data, which the original sender of the message can then immediately use. In this way, sending a message is exactly like calling a function.', '**Sandwich complexity model**: the bottom level architecture of Ethereum should be as simple as possible, and the interfaces to Ethereum (including high level programming languages for developers and the user interface for users) should be as easy to understand as possible. Where complexity is inevitable, it should be pushed into the \"middle layers\" of the protocol, that are not part of the core consensus but are also not seen by end users - high-level-language compilers, argument serialization and deserialization scripts, storage data structure models, the leveldb storage interface and the wire protocol, etc. However, this preference is not absolute.\n\n**Freedom**: users should not be restricted in what they use the Ethereum protocol for, and we should not attempt to preferentially favor or disfavor certain kinds of Ethereum contracts or transactions based on the nature of their purpose. This is similar to the guiding principle behind the concept of \"net neutrality\". One example of this principle not being followed is the situation in the Bitcoin transaction protocol where use of the blockchain for \"off-label\" purposes (eg. data storage, meta-protocols) is discouraged, and in some cases explicit quasi-protocol changes (eg. OP\\_RETURN restriction to 40 bytes) are made to attempt to attack applications using the blockchain in \"unauthorized\" ways. In Ethereum, we instead strongly favor the approach of setting up transaction fees in such a way as to be roughly incentive-compatible, such that users that use the blockchain in bloat-producing ways internalize the cost of their activities (ie. Pigovian taxation).\n\n**Generalization:** protocol features and opcodes in Ethereum should embody maximally low-level concepts, so that they can be combined in arbitrary ways including ways that may not seem useful today but which may become useful later, and so that a bundle of low-level concepts can be made more efficient by stripping out some of its functionality when it is not necessary. An example of this principle being followed is our choice of a LOG opcode as a way of feeding information to (particularly light client) dapps, as opposed to simply logging all transactions and messages as was internally suggested earlier - the concept of \"message\" is really the agglomeration of multiple concepts, including \"function call\" and \"event interesting to outside watchers\", and it is worth separating the two.\n\n**Have No Features**: as a corollary to generalization, the dev team often refuses to build in even very common high-level use cases as intrinsic parts of the protocol, with the understanding that if people really want to do it they can always create a sub-protocol (eg. ether-backed subcurrency, bitcoin/litecoin/dogecoin sidechain, etc) inside of a contract. An example of this is the lack of a Bitcoin-like \"locktime\" feature in Ethereum, as such a feature can be simulated via a protocol where users send \"signed data packets\" and those data packets can be fed into a specialized contract that processes them and performs some corresponding function if the data packet is in some contract-specific sense valid.\n\n**Non-risk-aversion**: the dev team is okay with higher degrees of risk if a risk-increasing change provides very substantial benefits (eg. generalized state transitions, 50x faster block times, consensus efficiency, etc)', 'Ethash', '2017-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Litecoin', 'LTC', 'ltc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://litecoin.com/', '@litecoin', 'Litecoin LTC - provides faster transaction confirmations (2.5 minutes on average) and uses a memory-hard, scrypt-based mining proof-of-work algorithm to target the regular computers and GPUs most people already have - which are its main differentials to Bitcoin. The Litecoin network is scheduled to produce 84 million currency units with a halving in reward every four years just like bitcoin. The coin was created by a Google employee, Charles Lee. Litecoin is in second spot to Bitcoin and has spawned numerous clones - however it has a solid base of support and dedicated development team.\n\nThe Litecoin project is currently maintained by a core group of 6 software developers, led by Charles Lee, with a large community that is growing in support.\n\nIn May 2017, Litecoin became the first of the Top 5 (By Market Cap) cryptocurrencies to implement the SegWit scaling solution. Later in May of the same year, the first Lightning Network transaction was completed through litecoin, transferring 0.00000001 LTC from Zurich to San Francisco in under one second.', 'Litecoin is an open source software project released under the MIT/X11 license which gives you the power to run, modify, and copy the software and to distribute, at your option, modified copies of the software. The software is released in a transparent process that allows for independent verification of binaries and their corresponding source code.\n\nMiners are currently awarded with 25 new litecoins per block, an amount which gets halved roughly every 4 years (every 840,000 blocks). The Litecoin network is therefore scheduled to produce 84 million litecoins, which is 4 times as many currency units as Bitcoin.\n\nThe Litecoin blockchain is capable of handling higher transaction volume than its counterpart - Bitcoin. Due to more frequent block generation, the network supports more transactions without a need to modify the software in the future. As a result, merchants get faster confirmation times, while still having ability to wait for more confirmations when selling bigger ticket items.', '\\- Faster transaction confirmations (2.5 minutes on average)\n\n\\- Scrypt-based mining proof-of-work algorithm\n\n\\- 84 million litecoins\n\n\\- Higher transaction volume than Bitcoin\n\n\\- MIT/X11 license', 'Scrypt', '2012-01-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DigitalCash', 'DASH', 'dash.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://dash.org/', '@Dashpay', 'DigitalCash (DASH) uses a new chained hashing algorithm approach, with many new scientific hashing algorithms for the proof-of-work. DASH aims to be the first privacy-centric cryptographic currency with fully encrypted transactions and anonymous block transactions, this feature is called PrivateSend and can be found on the official Dashcore wallet.\n\nPrivateSend mixes your DASH coins with other users who are also using this feature at the time, making your transactions untraceable.\n\nUsers can also earn DigitalCash rewards by hosting a master node to help maintain the Blockchain. One must have a balance of at least 1000 DASH in order to host a Dash master node, this collateral is required to avoid 51% attacks on the network.', '- Untraceable payments\n- Unlinkable transactions\n- Double-spending proof\n- Blockchain analysis resistance\n- Egalitarian proof of work\n- Adaptive limits', '- **Difficulty retargets each block**\n- **Block reward decreases each block according to the formula:**   \n  BaseReward = (MSupply - A)/218, where MSupply = (264 - 1) atomic units and \'A\' is amount of already generated coins\n- **POW mechanism is a voting system for users**', 'X11', '2015-06-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Monero', 'XMR', 'xmr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://getmonero.org/', '@monerocurrency', 'Monero (XMR) is a cryptonight algorithm based alternative crypto currency. The coin is based on Proof of Work and has a block reward that varies smoothly. The difficulty retargets every block with a sixty second block target.\n\nMonero uses a Ring Signature system to protect your privacy, allowing users to make untraceable transactions.', '- ****Privacy (Untraceable payments, Unlinkable transactions)**** Monero daemon uses the original CryptoNote protocol except for the initial changes (as the block time and emission speed). The protocol itself is based on ring signatures (Daniel J. Bernstein\'s Curve25519 + Ed25519, Schnorr signatures on a Twisted Edwards curve) and stealth addresses. The end result is passive, decentralised mixing based on heavily-tested algorithms.\n- **Decentralisation** The smart mining\\[20\\] forthcoming feature will allow transparent CPU mining on the user\'s computer, far from the de facto centralization of mining farms and pool mining, pursuing Satoshi Nakamoto\'s original vision of a true p2p currency.\n- **Scalability**  \n  Monero has no hardcoded limit, which means it doesn\'t have a 1 MB block size limitation preventing scalability.', '### Ring Signature \n\nThe Basics\n\nIn cryptography, a ring signature is a type of digital signature that can be performed by any member of a group of users that each have keys. Therefore, a message signed with a ring signature is endorsed by someone in a particular group of people. One of the security properties of a ring signature is that it should be computationally infeasible to determine _which_ of the group members\' keys was used to produce the signature.\n\nFor instance, a ring signature could be used to provide an anonymous signature from \"a high-ranking White House official\", without revealing which official signed the message. Ring signatures are right for this application because the anonymity of a ring signature cannot be revoked, and because the group for a ring signature can be improvised (requires no prior setup).\n\n**Application to Monero**\n\nA ring signature makes use of your [account](https://getmonero.org/resources/moneropedia/account.html) keys and a number of public keys (also known as outputs) pulled from the [blockchain](https://getmonero.org/resources/moneropedia/blockchain.html) using a triangular distribution method. Over the course of time, past outputs could be used multiple times to form possible signer participants. In a \"ring\" of possible signers, all ring members are equal and valid. There is no way an outside observer can tell which of the possible signers in a signature group belongs to your [account](https://getmonero.org/resources/moneropedia/account.html). So, ring signatures ensure that transaction outputs are untraceable. Moreover, there are no fungibility issues with Monero given that every transaction output has plausible deniability (e.g. the network can not tell which outputs are spent or unspent).\n\nTo read how Monero gives you privacy by default (unlinkability), see [stealth addresses](https://getmonero.org/resources/moneropedia/stealthaddress.html).', 'CryptoNight', '2014-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Nxt', 'NXT', 'nxt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS/LPoS', 'http://nxt.org/', '@nxtcommunity', 'Nxt is considered a 2nd generation crypto currency. With all the alt coins that alter parametes such as hashing mechanism, time between blocks, starting difficulty, and so on, Nxt brings much much more to the table and was designed this way for a number of reasons. It\'s proof of stake model makes it less susceptible to 51% attacks whilst it is designed to support large transaction volumes, something which the traditional Bitcoin and its clones have as a potential flaw. Nxt allows the creation and exchange of custom tokens, coloured coins and assets on the Blockchain.\n\nIn 2016, the NXT team announced the launch of Ardor, the Nxt 2.0. The platform will allow users the same features as Nxt and additional tools like sidechain support for asset issuance and more. The destribution of the ARDR token was done through a snapshot process, which is the reason for the price spike during late 2016.', '', '', 'PoS', '2014-12-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ethereum Classic', 'ETC', 'etc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.ethereumclassic.org/', '@EthereumClassic', 'Ethereum Classic is an attempt at keeping the Ethereum blockchain unaltered by the part of the community that opposed the hard fork and the return of The DAO funds. It started trading on Poloniex and is getting more and more traction.\n\nThe Ethereum Classic mission statement is:\n\n\"We believe in decentralized, censorship-resistant, permissionless blockchains. We believe in the original vision of Ethereum as a world computer you can\'t shut down, running irreversible smart contracts. We believe in a strong separation of concerns, where system forks are only possible in order to correct actual platform bugs, not to bail out failed contracts and special interests. We believe in censorship-resistant platform that can be actually trusted - by anyone.\"\n\nOur block explorer data: total coins supply, total network hash rate, last block number and total difficulty are freely provided by <https://gastracker.io/>\n\nIn 2017, the Die Hard fork was implemented in ETC, removing the Ethereum difficulty bomb. Currently, there are no plans to move to Proof of Stake like Ethereum, although developers at the IOHK institute are developing a new PoS protocol for Ethereum Classic.', '', '', 'Ethash', '2017-11-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Dogecoin', 'DOGE', 'doge.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://dogecoin.com/', '@dogecoin', 'A Bitcoin clone that has reached success through clever marketing. Over the past year well over a hundred new cryptocurrencies have been created but not many have instantly carved out a niche. Dogecoin has sponsored multiple high profile events such as Nascar teams and the winter olympics - even so there are few locations to use the coin - and instead it has become a de facto internet tipping currency. The coin has produced 100 billion units by the end of 2014 and is now producing roughly 5 billion units per year.', '', '', 'Scrypt', '2013-06-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZCash', 'ZEC', 'zec.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://z.cash/', '@zcashco', 'ZCash is a privacy driven cryptocurrency. It uses the **Equihash** as an algorithm, which is an asymmetric memory-hard Proof of Work algorithm based on the generalized birthday problem. It relies on high RAM requirements to bottleneck the generation of proofs and making ASIC development unfeasible.\n\nZCash uses zero-knowledge Succinct Non-interactive Arguments of Knowledge (zk-SNARKs) to ensure that all information (sender, reciever, ammount) is encrypted, without the possibility of double-spending. The only information that is revealed regarding transactions is the time in which they take place.\n\nBlock explorer data from <https://explorer.zcha.in/>', 'Privacy Enhanced\n================\n\n A decentralized and open-source cryptocurrency that provides strong privacy protections. If Bitcoin is like http for money, Zcash is https—a secure transport layer.', 'zk-SNARKs\n=========\n\nThe Basic\n---------\n\nZcash is the first widespread application of zk-SNARKs, a novel form of zero-knowledge cryptography. The strong privacy guarantee of Zcash is derived from the fact that shielded transactions in Zcash can be fully encrypted on the blockchain, yet still be verified as valid under the network’s consensus rules by using zk-SNARK proofs.\n\nThe acronym zk-SNARK stands for “Zero-Knowledge Succinct Non-Interactive Argument of Knowledge,” and refers to a proof construction where one can prove possession of certain information, e.g. a secret key, without revealing that information, and without any interaction between the prover and verifier.\n\n“Zero-knowledge” proofs allow one party (the prover) to prove to another (the verifier) that a statement is true, without revealing any information beyond the validity of the statement itself. For example, given the hash of a random number, the prover could convince the verifier that there indeed exists a number with this hash value, without revealing what it is.\n\nApplication to ZCASH\n--------------------\n\nIn order to have zero-knowledge privacy in Zcash, the function determining the validity of a transaction according to the network’s consensus rules must return the answer of whether the transaction is valid or not, without revealing any of the information it performed the calculations on. This is done by encoding some of the network\'s consensus rules in zk-SNARKs. At a high level, zk-SNARKs work by first turning what you want to prove into an equivalent form about knowing a solution to some algebraic equations. In the following section, we give a brief overview of how the rules for determining a valid transaction get transformed into equations that can then be evaluated on a candidate solution without revealing any sensitive information to the parties verifying the equations.', 'Equihash', '2018-04-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Bitshares', 'BTS', 'bts.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://bitshares.org/', '@_bitshares', 'BitShares (BTS) was first introduced in a White Paper titled “A Peer-to-Peer Polymorphic Digital Asset Exchange” by Daniel Larimer, Charles Hoskinson, and Stan Larimer. It is a brand of open-source software based on the as blockchain technology as used by Bitcoin. Unlike bitcoins, which do not produce any income for their owners, BitShare can be used to launch Decentralized Autonomous Companies (DACs) which issue shares, produce profits and distribute profits to shareholders. As such, BitShares is about making profitable companies that people want to own shares in, thus creating return for the shareholders. The first DAC launched by this proces was called BitSharesX, a decentralized asset exchange based in Hong Kong. BitShares was originally launched under the name of ProtoShares (PTS); it was later renamed to BitShares (BTS) and \"reloaded\" in November 2014 by merging several products into BitShares (BTS).', 'The BitShares platform itself is run and maintained by the **BitShares community**–an open consortium of individuals and organizations committed to providing universal access to the power of smart contracts. Working together, this community has designed and developed the BitShares platform to include numerous innovative features which are not found elsewhere within the smart contract industry\n\n- **Price-Stable Cryptocurrencies**   \n  SmartCoins provide the freedom of cryptocurrency with the stability of the dollar\n- **Decentralized Asset Exchange** A fast and fluid trading platform\n- **Industrial Performance and Scalability** Over 100,000 transactions per second\n- **Recurring & Scheduled Payments** Flexible withdrawal permissions\n- **Referral Rewards Program**  \n  Network growth through adoption rewards\n- **Dynamic Account Permissions**  \n  Management for the corporate environment\n- **User-Issued Assets**  \n  Regulation-compatible cryptoasset issuance\n- **Stakeholder-Approved Project Funding**  \n  A self-sustaining funding model\n- **Transferable Named Accounts** Easy and secure transactions\n- **Delegated Proof-of-Stake Consensus** A robust and flexible consensus protocol', '**Delegated Proof-of-Stake Consensus**\n\nDelegated Proof of Stake (DPOS) is a new method of securing a crypto-currency’s network. DPOS attempts to solve the problems of both Bitcoin’s traditional Proof of Work system, and the Proof of Stake system of Peercoin and NXT. DPOS implements a layer of technological democracy to offset the negative effects of centralization.\n\nDelegated proof of stake mitigates the potential negative impacts of centralization through the use of witnesses (formaly called _delegates_). A total of N witnesses sign the blocks and are voted on by those using the network with every transaction that gets made. By using a decentralized voting process, DPOS is by design more democratic than comparable systems. Rather than eliminating the need for trust all together, DPOS has safeguards in place the ensure that those trusted with signing blocks on behalf of the network are doing so correctly and without bias. Additionally, each block signed must have a verification that the block before it was signed by a trusted node. DPOS eliminates the need to wait until a certain number of untrusted nodes have verified a transaction before it can be confirmed.\n\nThis reduced need for confirmation produces an increase in speed of transaction times. By intentionally placing trust with the most trustworthy of potential block signers, as decided by the network, no artificial encumbrance need be imposed to slow down the block signing process. DPOS allows for many more transactions to be included in a block than either proof of work or proof of stake systems. DPOS technology allows cryptocurrency technology to transact at a level where it can compete with the centralized clearinghouses like Visa and Mastercard. Such clearinghouses administer the most popular forms of electronic payment systems in the world.\n\nIn a delegated proof of stake system centralization still occurs, but it is controlled. Unlike other methods of securing cryptocurrency networks, every client in a DPOS system has the ability to decide who is trusted rather than trust concentrating in the hands of those with the most resources. DPOS allows the network to reap some of the major advantages of centralization, while still maintaining some calculated measure of decentralization. This system is enforced by a fair election process where anyone could potentially become a delegated representative of the majority of users.', 'SHA-512', '2014-05-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DigiByte', 'DGB', 'dgb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.digibyte.co/', '@DigiByteCoin', 'A coin that has adopted the Bitcoin \"21\" figure but increased the supply to 21 billion - with over 5 algorithms to mine with (Scryt, Sha-256, Qubit, Skein, Groestl) - in order to keep mining local and in the hands of many. A 60 second block target, a 0.5% premine and a block retarget every 2.4 hrs or 244 blocks.\n\n**DigiByte**: Refers to the entire DigiByte network or a single monetary unit on the payment network. 21 billion DigiBytes will be created over 21 years.\n\n**Block**: A grouping of all transactions sent over the DigiByte network within a 30 second time frame. Think of a block as an excel spreadsheet that lists the address location of all DigiBytes at a given point in time in history. New DigiBytes are brought into circulation as each block is discovered on the network through a process called mining.\n\n**Mining**: Mining is how transactions are processed on the network. Anyone can become a miner by donating and using their desktop, laptop or mobile phone computing power to help process transactions on the DigiByte network. DigiByte has made this process even easier with our 3 click mining software for beginners.\n\n**Blockchain**: The DigiByte blockchain is the entire history of all blocks discovered on the network & therefore all transactions made on the network. Each block references the proceeding block all the way back to the beginning of the network to what is known as the genesis block. By linking blocks (spreadsheets) together an accurate, secure accounting of all up to date DigiByte ownership is made by decentralized consensus.', '**Absolute Security**: Our number one priority will now and forever be network and user security.\n\n**Speedy Transactions**: We strive to create the fastest possible decentralized transactions.\n\n**Worldwide Decentralization**: Keep the network open, transparent and accessible at all times.\n\n**Ease of Use**: Allow anyone to use and benefit from DigiByte in an easy to understand manner.\n\n**Flexible Innovation**: Quickly improve, adapt and innovate as new technology and threats arise.', '**Security**: DigiByte uses five highly advanced cryptographic algorithms.\n\n**Speed**: DigiByte transaction notifications occur in 1-3 seconds, blocks are discovered every thirty seconds and transactions are fully confirmed every 3 minutes. Future planned upgrades will make these times even faster.\n\n**Fees**: Most DigiByte to DigiByte transactions are free or carry a very small network-mining fee to incentivize people to mine.\n\n**Worldwide**: DigiBytes are already stored, traded and transacted in over 89 countries.\n\n**Decentralization**: There is no need for a middleman or third party or central server.\n\n**Re-Spend**: Send DigiBytes you received to someone else in as little as three minutes.\n\n**Finite Production**: New DigiBytes are added to the network every thirty seconds through a process called mining as each new block (or grouping of transactions in a spreadsheet like format) is discovered by the network.\n\n**Scarcity**: 21 Billion DigiBytes will be created in 21 years.\n\n**1% Monthly New Minting Reduction**: New DigiByte production decreases 1% every month.\n\n**Mining**: DigiByte mining is decentralized with five independent, highly secure mining algorithms.\n\n**Adaptable, innovative & flexible**: DigiByte is constantly adding new features & services to remain on the cutting edge of digital currency technology.\n\n**Committed Development**: DigiByte has been under constant, progressive development for over one year now with core development team members from all over the world.\n\n**Millennial Acquisition Potential**: DigiByte provides merchants, banks & other legacy institutions with a new means of acquiring & connecting with tech savvy millennial users.\n\n**A Bright Future**: DigiByte has many new & exciting projects underway to be released throughout 2015 to increase DigiByte utility and new user adoption across the globe.', 'Multiple', '2014-12-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ripple', 'XRP', 'xrp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://ripple.com/', '@Ripple', 'Ripple positions itself as a complement to, rather than a competitor with, Bitcoin - the site has a page dedicated to Ripple for bitcoiners. Ripple is a distributed network which means transactions occur immediately across the network - and as it is peer to peer - the network is resilient to systemic risk. Ripples aren\'t mined - unlike bitcoin and its peers - but each transaction destroys a small amount of XRP which adds a deflationary measure into the system. There are 100 billion XRP at present.', '- **Math-Based Currency**  \n  A math-based currency, also referred to as a cryptocurrency, is a digital asset with verifiable mathematical properties, similar to how we can reliably verify gold as a substance made of atoms with 79 protons. Math-based currencies exist as digital assets in their own right and can be transferred directly between users (as fiat cash can be) without relying on a centralized protocol operator. XRP exists as a math-based currency on the Ripple protocol.\n- **Abuse Protection** The primary function of XRP is to protect the Ripple protocol against denial-of-service (DoS) spam attacks. Since the Ripple protocol is based around a shared ledger of accounts, a malicious attacker could create large amounts of “ledger spam” (such as fake accounts) and “transaction spam” (such as fake transactions) in an attempt to overload the protocol. This could cause the size of the ledger to become unmanageable and interfere with the protocol’s ability to quickly settle legitimate transactions.\n- **Bridge Currency**  \n  XRP has great value as a bridge currency. Because each gateway’s balances trade as distinct assets within Ripple, the number of potential currency pairings can become quite large. Instead of quoting every possible currency/gateway combination, XRP can serve as a useful bridge currency to enable these transfers. This is possible because if every currency is liquid to XRP, then every currency is liquid to every other currency:', '**The Ledger and Consensus**  \nThe Ripple protocol is, at its core, a shared public database. This database includes a ledger, which serves to track accounts and the balances associated with them. The ledger is a distributed database — a perfect, shared record of accounts, balances, and transactions in the Ripple protocol. It is continually and automatically updated by the Ripple Transaction Protocol (RTXP) so that an identical ledger exists on thousands of servers around the world. At any time, anybody can review the ledger and see a record of all activity on the Ripple protocol. When changes are made to the ledger, computers connected to the Ripple protocol will mutually agree to the changes via a process called consensus. The Ripple protocol reaches consensus globally within seconds of a change being made. The consensus finding process is the engineering breakthrough that allows for fast, secure, and decentralized transaction settlement on the Ripple protocol.\n\n**The World’s First Distributed Exchange** No one owns or controls the Ripple protocol. It runs on computers around the world, all working together to continually maintain a perfect, shared record of accounts, balances, and transactions. Distributed networks offer many efficiencies over centralized networks. Because the network is “self-clearing”, it eliminates the need for a centralized network operator (and gets rid of the associated layer of fees). Because there is no single point of failure, distributed networks are more reliable. They also tend to be more secure, due to their open source nature.', '', '2013-02-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitcoinDark', 'BTCD', 'btcd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://bitcoindark.com/', '@BitcoinDark', 'Bitcoin Dark (BTCD) is a PoW and PoS hybrid alternatve crypto currency based on the same algorithm as Bitcoin itself - SHA256 - the difference is in the intent behind development - where Bitcoin is moving towards regulatory approval with increased transparency, BitcoinDark tries to push further of the belief of decentralisation and anonymity. The block time is 60 seconds - there was a 1.5 premine and a total of 22 million coins are scheduled to be produced.\n\nFollowing the announcement of the Komodo Platform by the SuperNet team, BitcoinDark could be swapped for KMD coins and will be so until 2018. BTCD technology will be further advanced in the KMD platform.', '', '', 'SHA256', '2014-09-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PeerCoin', 'PPC', 'ppc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://peercoin.net/', '@peercoinppc', 'A peer-to-peer crypto-currency design derived from Satoshi Nakamoto\'s Bitcoin. Proof-of-Stake replaces Proof-of-Work to provide most of the network security. Under this hybrid design proof-of-work mainly provides initial minting and is largely non-essential in the long run. Security level of the network is not highly enery dependent thus providing an energy efficient and more cost-competitive peer-to-peer crypto-currency. Proof-of-Stake is based on coin age and generated by each node via a hashing scheme bearing similarity to Bitcoins but over limited search space. Block chain history and transaction settlement are further protected by a centrally broadcasted checkpoint mechanism.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CraigsCoin', 'CRAIG', 'craig.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://craigscoin.info/', '@CraigsCoin', 'CraigCoin (CRAIG) is a 100% pure PoS or Proof of Stake alternative Crypto currency - the first 30,000,000 coins were issued through a presale. The block time is 30 seconds and the PoS interest rate is set to 2% per annum.', '', '', 'X11', '2015-08-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Bitstake', 'XBS', 'xbs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://bitstake.info/', '@Bitstake', 'To create the infrastructure necessary to implement an inclusive digital economy that encourage affordable digital transactions and services. Bitstake’s vision is to make digital currencies more accessible to people unreached by traditional banking as well as drive down the costs of money transfers. Bitstake is a hybrid proof of work and proof of stake with a 5% annualised interest rate.', '', '', 'X11', '2015-11-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PayCoin', 'XPY', 'xpy.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://paycoin.com/', NULL, 'Paycoin is an SHA256 cryptocurrency that switched from Proof of Work to Proof of Stake. XPY can be sent internationally almost instantly and with low fees.', '', '', 'SHA256', '2014-12-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ProsperCoin', 'PRC', 'prc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@prospercoin', 'ProsperCoin is a PoW cryptocurrency with a modified Scrypt algorithm. Created to bring to bring prosperity to its users, PRC can be sent to anyone for a small fee and almost instantly.', '', '', 'Scrypt', '2016-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'YbCoin', 'YBC', 'ybc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.ybcoin.com/', '@ybcoin', 'YB coin is a Chinese clone of YACcoin. It uses scrypt N+1 and ChaCha. The coin has a relatively low block time at 60 seconds but being a clone hasnt really brought much to the table in terms of innovation. Again like Yacoin there is a dynamically adjusted economic model related to the network power that balances the incentivisation to mine and use it depending on its popularity. An inverse relationship.', '', '', 'Multiple', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DarkKush', 'DANK', 'dank.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@DarkKushDANK', 'DarkKush is a cryptocurrency built for the marijuana community, it\'s a PoW/PoS hybrid coin.', '', '**Block Reward:**  \nBlock 1 - 499 (2000 DarkKush)  \nBlock 500 - 1999 (1000 DarkKush)  \nBlock 2000 - 3999 (500 DarkKush)  \nBlock 4000 - 5999 (250 DarkKush)  \nBlock 6000 - 7999 (150 DarkKush)  \nBlock 8000 - 9999 (100 DarkKush)  \nBlock 10000 - 12499 (50 DarkKush)   \nBlock 12000 - 15000 (25 DarkKush)', 'X13', '2016-02-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GiveCoin', 'GIVE', 'give.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://givecoin.info/', NULL, 'GiveCoin is a CryptoCurrency with a charitable angle - the idea being to emPoWer charities and encourage giving. The coin is based on DarkCoins ASIC resistant X11 algorithm, has a block time of 60 seconds - block reward of 1000 coins per block - halving every six months - a total supply of 500 million and a Kimoto gravity well difficulty retargetting. There was a premine of 5%, 2% will be donated to charities on a most voted basis each month, 1% for disaster relief, 1% for bugs and bounties and 1% for development and marketing.', '', '', 'X11', '2015-12-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'KoboCoin', 'KOBO', 'kobo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://kobocoin.com/', '@kobocoindev', 'Kobocoin is a digital currency and payment system similar to Bitcoin, with an African heritage. All nodes verify transactions in a public distributed ledger calledthe blockchain. The ledger uses its own unit of account, also called KoboCoin(s). KOBO can be sent to anyone in the world for small fees and almost instantly and can also be used for Micropayments.', '', '', 'X15', '2014-11-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DarkToken', 'DT', 'dt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@DarkTokenDT', 'DarkToken aims to offer a refreshing new take on what a crypto-currency should be by detailing every aspect of the coin, from start to finish. DarkToken takes the next step in coin development by fixing it from the start. Rigorous, energy intensive mining over long periods of time, or even worse, short PoW flash-mines, are extremely detrimental to not only the environment, but the crypto community as a whole. Networks can be maintained perfectly using Proof of Stake.', '', '', 'NIST5', '2015-04-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CETUS Coin', 'CETI', 'ceti.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://cetuscoin.cc/', NULL, 'Cetus Coin is a Scrypt Proof of Work and Proof of Stake hybrid cryptocurrency.', '', '', 'Scrypt', '2015-03-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Supcoin', 'SUP', 'sup.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'SupCoin was a developer coin running a new algorithm based on a mixture of sha-256 but using memory hard hashing techniques called Pluck. The coin can be traded on Bittrex.', '', '', '', '2016-07-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PetroDollar', 'XPD', 'xpd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@ThePetroDollar', 'PetroDollar is a peer-to-peer digital currency designed to deflate with relation to the world crude oils reserves. PetroDollar has a approximate 1:10,000 relationship to barrels of oil still existing in the ground, thus creating an analogy of the USD/OIL trading pair. Every transaction(Tx) broadcast over the PetroDollar network will be charged a transaction fee to be destroyed in line with oil depletion. Transaction fees are destroyed autonomously, at an organic rate based on a mathematical model of the oil market. PetroDollar has a current fee of 1.429% of the amount transmitted, increasing to approximately 15% in year 2045.', '', '', 'SHA256D', '2015-07-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GeoCoin', 'GEO', 'geo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://geo.money/', '@geo_coin', 'GeoCoins are simple, geocaching-themed, virtual “coins.” They are designed to be easy to create, easy to collect and easy to share with your friends! At their most simple, GeoCoins will allow you to send and receive virtual GeoCoins encoded with short personal messages.  \nOn the technical side of things, cryptographic proof-of-work provides a real-time peer to peer network of transaction verification, a “public ledger” of synchronized numbers, and unique possibilities for math-based puzzles.', '', '', 'Scrypt', '2014-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CleverHash', 'CHASH', 'chash.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.cleverhash.com/', NULL, 'Cleverhash was a fund raising technique for a cloud mining based firm.', '', '', '', '2015-12-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Spreadcoin', 'SPR', 'spr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'SpreadCoin is a new cryptocurrency which is more decentralized than Bitcoin. It prevents centralization of hashing power in pools, which is one of the main concerns of Bitcoin security. SpreadCoin was fairly launched with no premine.', '', '', 'X11', '2016-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NXTI', 'NXTI', 'nxti.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'NXTI coin is a coin based on NextCoin.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Insanity Coin', 'WOLF', 'wolf.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'WolfCoin is an alterative crypto currency with a block time of 300 seconds and running off the X11 algorithm.', '', '', 'X11', '2015-02-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DogeParty', 'XDP', 'xdp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.dogeparty.io/', '@theDogeparty', 'Dogeparty is a layer on the Dogecoin network for new coins that foster creativity and promote social good.', '', '', '', '2015-12-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Asia Coin', 'AC', 'ac.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.thecoin.asia/', '@AsiaCoin_', 'Asia Coin is a Scrypt Coin with a very brief PoW phase of two weeks or 20,000 blocks. The PoW phase is scheduled to produce 40% of the hard capped limit of 360 million. The PoS phase is set for ten years with first year stake interest set at a high 100% - whcih subsequently drops to 2%. Block time is 60 seconds, difficulty retargets every block and there was no premine.', '', '', 'Scrypt', '2016-02-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ACoin', 'ACOIN', 'acoin.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://acoinproject.org/', '@acointeam', 'Acoin is an SHA-256 Bitcoin clone. The block reward varies with a block reward of 2-10x normal roughly every 1 in ten blocks. The block reward initially starts at 1 and reduces by 50% every 6 months.', '', '', 'SHA256', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Aero Coin', 'AERO', 'aero.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@aerocoin', 'AeroCoin is a X13 PoW PoS hybrid - the block time is 90 seconds and the maximum number of PoW blocks is 7122. The PoS stake is 12% per annum and there was a 2% premine.', '', '', 'X13', '2014-11-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AlphaCoin', 'ALF', 'alf.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://alphacoin.wordpress.com/', NULL, 'Alphacoin (ALF) is a clone from Litecoin. It uses scrypt and it matches network hashrate quickly through its difficulty retargetting. The block time target is low at 30 seconds and 4 confirmations are needed for every transaction - or two minutes.', '', '', 'Scrypt', '2013-09-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Aegis', 'AGS', 'ags.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@AegisCoin', 'Aegis (AGS) is an X15 altcoin with a block time of 60 seconds and a Proof of Work phase tht lasts 4 days. The Proof of Stake rate is set to an annualised 2% with 24 hrs minimum for staking. There was no premine and no IPO.', '', '', 'X13', '2014-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AmericanCoin', 'AMC', 'amc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'AmericanCoin (AMC) is based on Litecoin. It has a block reward of 100 coins and will have a total of 168 million coins. This a pure scrypt proof of work coin with a block time of 150s and a difficulty retargetting every 504 blocks. The difficulty adjustment is limited to a maximum 41.4% change and the subsidy halves every four years or 840000 blocks.', '', '', 'Scrypt', '2015-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AlienCoin', 'ALN', 'aln.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@aliencoin', 'AlienCoin has a block time of thirty seconds and a difficulty retargetting every 120 blocks or every hour. Total vcoin supply is 200 million.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ApexCoin', 'APEX', 'apex.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'ApexCoin is an X13 based altcoin that is both Proof of Work and Proof of Stake. The PoW ends after block 30000, or 15 days. The block time is 60 seconds.', '', '', 'X13', '2014-11-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ArchCoin', 'ARCH', 'arch.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://www.archcoin.co/', '@ARCHcoin', 'The original ARCH whitepaper focused on the concept of controlling the flow of information within a decentralized autonomous corporation (DAC) in an effort to promote financial stability and growth within a DAC and protecting sensible information. While most cryptocurrencies are created as an alternative to bitcoin, ARCH was created as a startup holding DAC whose equity is represented by a cryptographic token. The goal is to test new applications of blockchain technology as well as to model an investor-token relationship in a use-case scenario involving a real startup with palpable products and services. To improve equity fungibility, revenue from any of the holding company\'s products or services is to be used to purchase more tokens from the market, thereby making the holding DAC\'s equity token exponentially more valuable with each additional revenue stream. Although no substantial revenue has been injected into ARCH\'s fungibility yet, its tiered conditional access levels have created a natural self-audit system that has proven very effective when it comes to managing this pseudo-corporate setup and its investors. Value in information is trusted to investors according to their own responsibility in the pseudo-corporate structure. In this tiered setup, the amount of tokens held serves as a basis of evaluating trust and involvement with the DAC itself. This system promotes unbiased transparency by the developers and corporate responsibility on behalf of the investors. This system alone, without any major revenue stream, has already proven itself as the backbone of the current stable growth in the ARCH equity token\'s market cap.\n\n  \nThis unique approach opens doors for a new generation of DACs, fusing decentralized communities with traditional corporate structures using tiered conditional access levels to secure the flow of information. Although tailored to our specific ventures and “community” needs, the ARCH wallet concept is an outstanding, first-of-its-kind example for other future DACs looking to combine all relevant information and tools regarding the DAC\'s and its equity token in one place. ARCH is taking that concept even further and seeks to integrate the whole corporate structure into its wallet as the DAC grows.   \n  \nIn a nutshell, Arch rearranged how investors interacted in DACs to establish healthier lines of communication while changing the financial structure so that FIAT revenue would be injected directly into the tokens fungibility instead of being distributed through dividends.  \n  \nTheir products, services and software are inspired by bitcoin, disruptive and innovative but not interdependent.', '', '', 'Scrypt', '2015-10-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Argentum', 'ARG', 'arg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Argentum is another fast block time coin at 32 seconds. It is a scrypt proof of work coin with difficulty retargetting every 250 blocks. The name comes from the Latin for silver and the coin will have a 1.1% annual inflation after the the hard coded total coin cap is reached. The block reward is random and the maximum block size is 10mb.', '', '', 'Scrypt', '2011-11-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AriCoin', 'ARI', 'ari.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'AriCoin is another alternative crypto currency.', '', '', 'Scrypt', '2016-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Aurora Coin', 'AUR', 'aur.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://auroraspjall.is/', '@auroracoinIS', 'Auroracoin is a cryptocurrency for Iceland. It is based on litecoin and is 50% premined. The premined coins will be distributed to the entire population of Iceland, starting at the end of March 2014. An interesting way to encourage coin use and market penetration and similar to Spaincoins marketing push. Difficulty retargets every eight blocks and there is no block reward reduction unlike Bitcoin.', '', '', 'Scrypt', '2016-01-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AXRON', 'AXR', 'axr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'Axron can be traded on cryptsy for Bitcoin.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BattleCoin', 'BCX', 'bcx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://battlecoinxchange.com/', '@BattlecoinBCX', 'BXC is also a new fantasy digital currency Battlecoin is a SHA-256 hybrid Proof-of-Work and Proof-of-Stake coin. There is a generous 1% interest for every 10 day period for BCX holders. Battlecoin is a playful coin with serious potential. It has 3% premined coins and 2% of coins given to early adopters. Up untill the 10000th block thereare 500 coins per block, after - only 50 coins per block. It has Proof of Stack feature: Every 10 days 1% of stake is given to the holder if the stake was immovable within 20 days. Block time is 2 minutes and difficulty retargets every 10 blocks.', '', '', 'SHA256', '2014-10-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Benjamins', 'BEN', 'ben.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Benjamins (BEN) is a SHA based virtual currency based on speed and security. BEN is an alternate currency with 12.8 Million coins available.', '', '', 'SHA256', '2014-01-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BetaCoin', 'BET', 'bet.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@Betacoin', 'Betacoin is a decentralized Internet currency that enables instant payments to anyone in the world. It is based on the Bitcoin protocol but differs from Bitcoin in some specifications. Betacoin provides faster transaction confirmations (4 minutes average block generating time). The Betacoin network is scheduled to produce 32 million currency units.', '', '', 'SHA256', '2014-12-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitBean', 'BITB', 'bitb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.bitbean.org/', '@BitBeanCoin', 'BitBean is another alternative crypto currency. Its Proof of Stake is different from other coins. In addition to only giving all coins that have over 6 hours age only 6 hours of age in the PoS calculations, the blocks which are found are static blocks similar to PoW. Each PoS block is 1000 coins.', '', '', 'SHA256', '2016-01-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BlueCoin', 'BLU', 'blu.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.bluecoin.io/', '@BlueCoin_info', 'BlueCoin (BLU) is a scrypt altcoin that is starts with a PoW phase lasting 100 days - and then switches to Proof of Stake. The block time is 90 seconds and the difficulty retargets every block. The coin is based on Scrypt and the PoS interest rate is set to 3%. There was a 3% premine for bugs, bountie and further development.', '', '', 'X11', '2017-06-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BlackCoin', 'BLK', 'blk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://blackcoin.co/', '@CoinBlack', 'BlackCoin has seen initial success due to its innovative features. The coin has incorporated bitcoin upgrades to reduce transaction risk. The coin initially uses proof of work as well as proof of stake, with the proof of work being dropped after the 10000th block. The advantages of Blackcoins proof of stake is that it has extremely fast transaction confirmation times at ten seconds - compared to bitcoins ten minutes plus. The other bonus is the low energy consumption without PoW mining. Interest is paid annually at a 1% rate - well below the present global average.', '', '', 'Scrypt', '2015-12-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BoostCoin', 'BOST', 'bost.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Boostcoin (BOST) claims to be the first hybrid PoW/PoS X13 altcoin. The PoW phase was set to have a block reward of 515 coins per block - a sixty second block target and a total supply of 11.7 million coins. The total supply of coins is limited to 40 million including the PoS phase which has an interest rate of 10% annually. There are continuing rewards from PoS blocks towards the BoostCoin foundation and there was a 1% premine.', '', '', 'X13', '2015-03-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BQCoin', 'BQC', 'bqc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://bbqcoin.org/', '@BBQcoinOfficial', 'BBQCoin often abbreviated to BBQ or BQC, is a scrypt based blockchain fork of the original bitcoin source code, very similar to litecoin and launched only a short while after Litecoin. BBQcoin provides faster transaction confirmations and uses memory-hard, scrypt-based mining proof-of-work algorithm to target the regular computers and GPUs most people already have. The BBQcoin network is scheduled to produce 88 million currency units.', '', '', 'Scrypt', '2013-01-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MyriadCoin', 'XMY', 'xmy.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://myriadcoin.org/', '@myriadcoin', 'Myriad uses five proof of work algorithms for one coin which can be chosen by the user - Scrypt, SHA-256D. QuBit, Skein and Groestl. The coin has a block time of 2.5mins and block halving every 967680 blocks.', '', '', 'Multiple', '2015-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MoonCoin', 'MOON', 'moon.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@RealMooncoin', 'There is one coin for each millimeter of covering distance from the Earth to the Moon. Moon Coin has an increasing block reward reduction range, where in the first 100,000 blocks the reward can be between 0 and 1,000,000 coins, this then drops to 0-600,000 coins for the second 100,000 blocks and so on. After block 384,400 all block rewards are fixed at 29531.', '', '', 'Scrypt', '2015-04-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZetaCoin', 'ZET', 'zet.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://zetacoin.com/', '@zetacoins', 'Zetacoin is an open source crypto-currency based on Bitcoin and SHA-256. It has faster transaction times and faster difficulty adjustments. Initial coin mining is 160 million coins, thereafter a yearly inflation of 1 million coins. The transaction speed is 20X faster than that of Bitcoin. The coin can be traded on Bter, Cryptsy and Mintpal.', '', '', 'SHA256', '2014-12-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SexCoin', 'SXC', 'sxc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.sexcoin.info/', '@SexcoinTeam', 'Sexcoin - SXC aims to provide adult content consumers, performers and producers a fast, stable and secure method of accepting micro transactions, protecting their customers privacy and progressing adult retail services into the crypto age. Super blocks are another feature.', '', '', 'Scrypt', '2015-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Quatloo', 'QTL', 'qtl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://quatloos.org/', '@quatloocoin', 'Quatloo (QTL) is a Proof of Work scrypty alternative crypto currency. Dificulty retargets every block on a block time of 135 seconds.', '', '', 'Scrypt', '2016-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EnergyCoin', 'ENRG', 'enrg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://energycoin.pw/', '@energycoin', 'EnergyCoin (ENRG) is a pure PoS scrypt altcoin with an initial distribution of 110000000 coins going to the 2000 members of the community. The PoS annualised rates drop by 2% per year from 10% to 2% in year 5 - thereafter at year six there is a fixed interest rate of 1% per annum. There is a thirty second block time and a difficulty retargetting each block.', '', '', 'Scrypt', '2016-05-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'QuarkCoin', 'QRK', 'qrk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.qrk.cc/', '@quarkcoin', 'Quark Coin (QRK) Military Grade Encryption and it is a free open source peer-to-peer electronic cash system that is completely decentralized, without the need for a central server or trusted parties. Users hold the crypto keys to their own money and transact directly with each other, with the help of a P2P network to check for double-spending. Super secure hashing: 9 rounds of hashing from 6 hashing functions (blake, bmw, groestl, jh, keccak, skein). 3 rounds apply a random hashing function.', '', '', 'Multiple', '2014-09-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Riecoin', 'RIC', 'ric.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://riecoin.org/', '@riecoin', 'Riecoin is in homage to Bernhard Riemann who studied the distribution of prime numbers. RieCoin is a POW altcoin with a blocktime of 2.5 mins and difficulty retagetting every 288 blocks or 12 hours. There is a hard cap of 84 million RIC.', '', '', 'Groestl', '2016-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DigiCoin', 'DGC', 'dgc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://digitalcoin.co/', '@DigitalcoinDGC', 'Digitalcoin is an alternative open-source cryptocurrency with focus on economic fairness and growth. It uses the tagline \"A Currency for the Digital Age\". The Digitalcoin community aims to help facilitate the circulation of digital currency by bridging the gap between the common public and the new cryptocurrency technology.\n\nBlocks are hashed using Scrypt, X11 and SHA256 algorithms. The average block confirmation time for Digitalcoin takes about 40 seconds. The total supply of digitalcoins will balance out around 48,166,000 as block halvings occur.', '', '', 'Scrypt', '2014-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LimeCoinX', 'LIMX', 'limx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'LimeCoinx (LIMX) is an X11 altcoin that is based on the 11 hashing functions of blake, bmx, groestl, jh, keccak, skein, luffa, cubehash, shavite, simd, and echo. The maximum money supply of LIMX is set to 21 million. The block time is 5 minutes and the difficulty retargets every 36 blocks using the Dark Gravity Wave process. The block reward is 50 coins per block and there was a 2%+ premine.', '', '', 'X11', '2014-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitBar', 'BTB', 'btb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://bitbar.co/', '@spider_BTB', 'The BitBar (BTB) crypto coin is a mixture of Novacoin, Fairnova and Rarecoin. It is a unique alternative to bitcoin and it\'s first-mover advantages over the glut of currencies that launched during the summer of 2013. It is resistant to Asic miners and dedicated mining hardware, meaning specialist mining equipment built into chips is very costly to manufacture efficiently - but that could soon change.', '', '', 'Scrypt', '2014-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CAIx', 'CAIX', 'caix.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@JStuhlman', 'CAIx is a pure POS altcoin with a 5% annual interest rate. The start up money supply for staking is set to 1.6 million coins.', '', '', 'Scrypt', '2015-01-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitGem', 'BTG*', 'btg_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.bitgem.pw/', NULL, 'PoW scrypt and PoS like NovaCoin, but adapted to gem\'s character, providing semi-scarce, precious and highly valuable currency properties. Mining a block you could to get up to 3 BTGs.', '', '', 'Scrypt', '2014-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitMark', 'BTM', 'btm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://github.com/', '@ProjectBitmark', 'BitMark has a total coin supply of 27.58 million BTM - difficulty retargetting each 720 blocks and a block reward of 20 BTM.', '', '', 'Scrypt', '2015-09-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CryptoBuk', 'BUK', 'buk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://cryptobuck.com/', NULL, 'Wallet Prefix = 3\n\nMax coin cap = 10,000,000 @ 3 Minute Blocks\n\nPOW/POS Advanced Scrypt Algorithm Hybrid Block Generator\n\nDefault RPC Port=13888\n\nDefault P2P Port=12888\n\nDifficulty Adjustment = Linear (per block)\n\nTransaction Messaging\n\nSeed Node / addnode = 69.85.86.195\n\nProxy TOR hidden services\n\nUPNP and IRC\n\nSSL JSON RPC Connections', '', '', 'Scrypt', '2015-01-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cachecoin', 'CACH', 'cach.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://cachecoin.org/', '@CACHeCoin', 'CACHeCoin (CACH) utilizes Proof-of-Stake (POS) mining that generates more CACHeCoins when you retain your coins for 7 days. When the coins from a particular transaction become 7 days old, they will be used by your wallet to perform Proof-of-Stake mining that will generate new coins if you solve the block. Just like a normal Proof-of-Work block, these POS blocks require 520 confirmations. Once the POS block has reached 520 confirmations, your staked coins and the reward will be made available again in your wallet. These coins will then be required to age another 7 days before they can be used in POS mining. The POS is not very CPU intense and there\'s no need to set anything in order to mine PoS. It\'s done automatically.', '', '', 'Scrypt', '2014-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BottleCaps', 'CAP', 'cap.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Bottle caps are the standard currency in Fallout, Fallout 3, Fallout: New Vegas and Fallout: Brotherhood of Steel. Bottlecaps (CAP) are a 0 premine 0 instamine (0.25 Diff start).', '', '', 'Scrypt', '2014-11-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CryptoBullion', 'CBX', 'cbx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://cryptobullion.io/', '@CryptoBullionX', 'Crypto Bullion (CB) it is the virtual Precious Metal. A Next Generation of Crypto. This is a PoW + PoS scrypt altcoin - a virtual commodity-currency, based on Peercoin.', '', '', 'Scrypt', '2015-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CannaCoin', 'CCN', 'ccn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://cannacoin.cc/', '@CCNProject', 'Cannacoin (CCN) is another coin trying to associate itself with the narcotics business. The block reward halves every year and difficulty retargets using the kimoto gravity well. The coin is scrypt, block time is 60 seconds, and the total supply is capped at 13.14 million.', '', '', 'Scrypt', '2015-10-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CinderCoin', 'CIN', 'cin.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@CinderCoin', 'Cinder \\[CIN\\] is the new developer\'s rebranding of FlexibleCoin \\[FLEX\\]. FLEX was mined during a 10+ day X15 Algo Proof of Work stage. Most coins have since been purchased by investors on markets such as Bittrex and Cryptsy, giving the coin wide distribution to long term holders.', '', '', 'Multiple', '2014-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CINNICOIN', 'CINNI', 'cinni.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.cinnicoin.com/', '@CinniCoin', 'Cinnicoin has a total production of 15million coins in the PoW phase. After there is a 3.5% inflationary PoS. The coin is scrypt and has no block halving with 17280 blocks and 868 Cinni per block.', '', '', 'Scrypt', '2015-04-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CheckCoin', 'CXC', 'cxc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.cxc.bid/', '@BidCXC', 'Total Coin Supply: 5,000,000 Distributed among 93 Investors which invested the total amount of 85.52154000 BTC in the ICO.\n\nICO AUCTION ENDED AT 0.00001710 BTC/CXC\n\nProof-of-Stake Interest Rate (per annum): 4%\n\nBlock Spacing: 60 seconds\n\nBlocks to Maturity: 60', '', '', '', '2016-06-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CLAMS', 'CLAM', 'clam.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.clamcoin.org/', '@ClamClient', 'CLAMS are a form of digital value, or currency, that is transferred, created, and verified by the collective effort of the computers running the CLAMS software. Similar to Bitcoin, the original technology on top of which CLAMS was created, this network follows a rigorous protocol to ensure that consensus and verification is maintained.\n\nThe CLAM Network is a peer-to-peer network of computers running the CLAMS software. To become a part of the CLAMS network, you need only to run the CLAMS software on your home computer. The purpose of this network is to independently and collaboratively verify the transfer and creation of CLAMS.\n\nMoney is ever present in our lives. We buy, sell, trade, and work by exchanging and transferring money. However, the current monetary system was not designed to support freedom, fairness and equality.  \n  \nCLAMS provides an alternative. CLAMS provides freedom from seizure and taxation. It exists on the network and cannot be seized or taxed. CLAMS provides the equality that the current system lacks. It was distributed EVENLY to over three million \'accounts\' at its creation.', '', '', '', '2015-12-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CloakCoin', 'CLOAK', 'cloak.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.cloakcoin.com/', '@CloakCoin', 'CloakCoin (CLOAK) is an X13 crypto coin that is attempting to introduce anonymity features via exchanges. The team has a core set of four developers workig to implement these attributes. The PoW block reward is a flat 496 coins and will stop after seven days where PoS takes precedence at 6% per annum. There was no premine and the block time is set to 60 seconds.', '', '', 'X13', '2014-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CopperLark', 'CLR', 'clr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://copperlark.com/', '@copperlark', 'There are many changes over Bitcoin which makes it not just another clone, one which includes using SHA3 instead of SHA2 or Scrypt. If compared to BTC, some significant changes have been done to basic system parameters. Transaction speed has increased by reducing the block generation rate down to 4 minutes and a total of 26 Million will be mined.', '', '', 'SHA256', '2013-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CosmosCoin', 'CMC', 'cmc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Cosmoscoin combines the best from Bitcoin/Litecoin/Novacoin/Florincoin, it uses both Proof of Work and Proof of Stake. This provides good resistence to 51% attack. It also supports transaction comments like Florincoin, so when you send transactions to the cosmos, you and your receiver won\'t be lost! Moreover, this coin has zero transaction fees, and fast transaction confirmation time (1.5 min). It provides steady coin supply at 3.5 coins per block.\n\nCosmoscoin has a fair start and zero premined, making it one of the very best of the alt coins exist today.', '', '', 'Scrypt', '2015-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ChinaCoin', 'CNC', 'cnc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'CHNCoin (CHN), represented by the currency abbreviation CNC, is a scrypt-based cryptocurrency forked from LiteCoin.', '', '', 'Scrypt', '2013-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ConcealCoin', 'CNL', 'cnl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@ConcealCoin', 'Conceal Coin is a hybrid PoW/PoS coin with an initial distribution phase PoW distribution phase of 2880 blocks on a flat block reward and a block time of 30 seconds.\n\nThe algorithm of the coin the X11 and the ticker CNL - the PoS rate is annualised at 3%.', '', '', 'X11', '2015-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Community Coin', 'COMM', 'comm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Community_Coin', 'Community Coin is a fully premined coin with a twist - 1000 individuals have recieved 1 million coins including the developers who are only eligable for one stake - the idea is then to work with the 1000 community members to increase awareness of the crypto currency through marketing drives. There is a variable annual interest rate reducing from 30% in y1 to 2% in y5.', '', '', 'Scrypt', '2016-01-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CoolCoin', 'COOL', 'cool.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@Coin_Cool', 'CoolCoin (COOL) is a scrypt based altcoin that operates through Proof of Stake. The block time is 60 seconds and the total coin supply is 100 million COOL. The first year PoS rate is 30% which then drops to 10%.', '', '', 'Scrypt', '2015-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CrackCoin', 'CRACK', 'crack.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@CrackCoinDev', 'CrackCoin is a 60 second block time PoW and PoS hybrid alternative crypto currrency. There are 6 million PoW coins to be generated and the PoS rate varies between 1-3% depending on the staked coin percentage.', '', '', 'X11', '2015-08-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CraftCoin', 'CRC', 'crc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'CraftCoin (CRC) is a cryptocurrency based on Litecoin. CraftCoin was designed to be a portable in-game currency for Minecraft servers. The currency is used to buy in-game items on minecraft servers, and can be instantly transferred to any other Minecraft server that supports CraftCoin. Best of all it is absolutely free for anybody to use for private and commercial use.', '', '', 'Scrypt', '2013-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CryptCoin', 'CRYPT', 'crypt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'CryptCoin (CRYPT) is an X11 altcoin - a third generation of crypto currency. There is a hard cap limit set to the POW and POS at 18 million. The POW reward halves at elongating intervals from a start of 500 CRY and the POS rate is 2.75%.', '', '', 'X11', '2014-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CasinoCoin', 'CSC', 'csc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@CasinoCoin', 'Casinocoin (CSC) is an open source, peer-to-peer digital currency, specifically designed for online casino gaming.\n\nCasinoCoin is based on the strengths of crypto currency protocols such as Bitcoin, Litecoin, Feathercoin and digitalcoin, giving it a second movers advantage. It leverages the security of Bitcoin, the accessibility of Litecoin, the abundance of Feathercoin, and the speed of digitalcoin. While CasinoCoin can be used as a general purpose currency, it serves a specific purpose and is marketed exclusively for online casino gaming and rewards redemption.', 'Since April 15th, 2011, a day dubbed as \'Black Friday\' by the online gaming community, it has become increasingly difficult to deposit funds for online casino gaming due to deposit restrictions between centralized financial institutions and online casino platforms. Avid online players have since not been able to enjoy the same conveniences and the ease of accessibility that they were once afforded. Those days are no more with the advent of CasinoCoin.\n\nAs a decentralized crypto currency, CasinoCoin offers the solution to help fill this void. Consider CasinoCoin as a universal casino chip that is easily transferable between online casino gaming applications, exchanges and peers. Imagine using CasinoCoin at your favorite online poker sites, then instantly transfer your winnings over to your favorite online casino to play Blackjack. How about a friendly wager over a game of chess? This is all possible with CasinoCoin.\n\nCasinoCoin is an open source, peer-to-peer digital currency specifically designed for online casino gaming. It is a platform independent crypto currency that is easily transferable between gaming applications, exchanges and peers. CasinoCoin can simply be summed up as universal casino chips.\n\nBy itself, CasinoCoin has no value. Within casino gaming applications, it can be used to play games of skill and chance. On the exchanges, CasinoCoin is worth what the market values it at and it can be bought, sold and exchanged to fiat currencies such as US dollars or exchanged to other crypto currencies such as Bitcoin.', '', 'Scrypt', '2014-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'eMark', 'DEM', 'dem.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Deutsche eMark is an open source peer-to-peer digital Internet currency. Deutsche eMark stands for fast and secure payments to anyone around the world who has an eMark Wallet. Therefore no banks are required and the fees are low and simple to understand.', '', '', 'SHA256', '2013-12-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Diamond', 'DMD', 'dmd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://bit.diamonds/', '@dmdcoin', 'Diamond (DMD) combines the best from Bitcoin/Litecoin/Novacoin/Luckycoin/Florincoin, it uses both Proof of Work and Proof of Stake. This provides a excellent resistence to 51% attack. It also combines the random block feature from Luckycoin, making it the first coin in PoW/PoS category to use random blocks. This coin has very low transaction fees. It provides steady coin supply at 1 diamond per block for 8 years.\n\n**It\'s SCARCE**\n\nThere will be only 4,38 million Diamonds created over the course of many decades, making this one of the most scarce electronic commodities.\n\n**It\'s VALUABLE**\n\nThe moment you acquire Diamond it becomes an interest bearing asset with 50% return per year. The interest will be successively reduced over the coming years.\n\n**It\'s SECURE**\n\nSecurity lies at the core of Diamond. This means that transactions cannot be forged or altered while gaining an access to your account is practically impossible.\n\n**It\'s BRAND**\n\nDiamond is the brand you can trust. It is not only ideal for promoting your own business, but also a tool that can be utilised to engage your customers, taking your enterprise into another level.\n\n**It\'s FAST**\n\nDiamond network has been designed to be excellent for quick money transfers. Under one minute block times ensure unparalleled speed to conventional remittance and payment systems.\n\n**It\'s ECOLOGICAL**\n\nProof-of-Stake approach not only dramatically reduces carbon footprint but also dramatically lowers electricity consumption making it environmentally friendly.', '**It\'s SCARCE**\n\nThere will be only 4,38 million Diamonds created over the course of many decades, making this one of the most scarce electronic commodities.\n\n**It\'s VALUABLE**\n\nThe moment you acquire Diamond it becomes an interest bearing asset with 50% return per year. The interest will be successively reduced over the coming years.\n\n**It\'s SECURE**\n\nSecurity lies at the core of Diamond. This means that transactions cannot be forged or altered while gaining an access to your account is practically impossible.\n\n**It\'s BRAND**\n\nDiamond is the brand you can trust. It is not only ideal for promoting your own business, but also a tool that can be utilised to engage your customers, taking your enterprise into another level.\n\n**It\'s FAST**\n\nDiamond network has been designed to be excellent for quick money transfers. Under one minute block times ensure unparalleled speed to conventional remittance and payment systems.\n\n**It\'s ECOLOGICAL**\n\nProof-of-Stake approach not only dramatically reduces carbon footprint but also dramatically lowers electricity consumption making it environmentally friendly.', '- Algorithm is ASIC resistant Grøstl.\n- 4.38 million total coins.\n- Block solving target time ~ 100 seconds.\n- Low transaction fee at 0.001.\n- Mean time per block under 60 seconds.\n- Difficulty retargets at every block.\n- Endless Hybrid Network Security.\n- Transaction Message.\n- Fast and secure transactions with 6 required confirmations.\n- Provision for continuous promotion and development.\n- Brand new code base with up to date security patches and significant performance improvements.', 'Groestl', '2014-01-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Verge', 'XVG', 'xvg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://vergecurrency.com/', '@vergecurrency', 'Verge is a scrypt based alternative crypto currency trying to take the popularity of both Dogecoin and Bitcoin and combine it with the anonymous features of DASH. The block time is 30 seconds and the coin operates through Proof of Work.\n\nVERGE prides itself on being a symbol of progression in the cryptocurrency world. It is a more secure, private, and evolving cryptocurrency that is backed by bitcoin, a ton of developer resources and privacy tools ([located here](https://github.com/vergecurrency/)!)\n\n**Block reward**:\n\n- Block 0 to 14,000 : 200,000 coins\n- 14,000 to 28,000 : 100,000 coins\n- 28,000 to 42,000: 50,000 coins\n- 42,000 to 210,000: 25,000 coins\n- 210,000 to 378,000: 12,500 coins\n- 378,000 to 546,000: 6,250 coins\n- 546,000 to 714,000: 3,125 coins\n- 714,000 to 2,124,000: 1,560 coins\n- 2,124,000 to 4,248,000: 730 coins\n\nApproximately total reward: 9 Billion (9,000,000,000) during first year then issuing 1 billion (1,000,000,000) each year after.', '', '', 'Multiple', '2017-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DarkCash', 'DRKC', 'drkc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'DarkCash is another anonymity based crypto currency. The coin has a proof of work phase that produces 3.72 million DRKC units through X11. The subsequent Proof of Stake phase has an annualised 17% rate.', '', '', 'X11', '2014-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DarkShibe', 'DSB', 'dsb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://bitcointalk.org/', '@DarkShibe', 'DarkShibe is another crypto currency like Darkcoin - that takes the Dogecoin and Darkcoin elements and fuses them together. The coin is scrypt based and initially operates a proof of work phase that then shifts to a pure proof of stake with an annualised rate at 9%. You can trade DarkShibe for Bitcoin on the exchanges below.', '', '', 'Scrypt', '2015-11-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DevCoin', 'DVC', 'dvc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://devcoin.org/', '@Devtome', 'Devcoin is an ethically inspired project based on the BitCoin crypto-currency and created to help fund open source projects created by programmers, hardware developers, writers, musicians, painters, graphic artists and filmmakers. Participants in the DevCoin economy earn DevCoins in proportion to their project development. Writers earn devcoins by writing, developers earn Devcoins by developing, artists earn DevCoin by creating, and the same follow for every other category including Administrators who apply their time and effort to help organize the DevCoin project and Marketers who earn Devcoins by Marketing. There are 50,000 coins per block, of which 90% goes to funding open source projects. 5,000 are given to miners, 45,000 are given to the people distributing Devcoins to artists and contributors.', '', '', 'SHA256', '2011-05-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EarthCoin', 'EAC', 'eac.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://getearthcoin.com/', '@getearthcoin', 'EarthCoin uses scrypt as a proof of work scheme and is a scrypt coin descendant of Litecoin, Holders can send Earthcoin to anyone in the world - in 10 seconds - without having to worry about banks and borders, it uses a 365 day period & starts with 10,000 coins p/block & it varies in a sine curve with amplitude of 2,000 with a period of one year (like the Earth moving around the Sun). Then a new minimum of 8000 coins per block at about 9 months.', '', '', 'Scrypt', '2014-09-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'E-Gulden', 'EFL', 'efl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'The Electronic Gulden Crypto Currency (EFL) is named after the Gulden Florjin a Dutch coin from the Middle Ages. Again like SpainCoin, Scotcoin, CryptoEscudo, and other nationally inspired crypto currencies, the Electronic Gulden is a premined coin for distribution to a specific nationality - in this case the Dutch. 50% of the coin can be mined by anyone and 50% will be allotted to Dutch Households and verified using two proofs of address - two utility bills. The ELF coin is a PoW scrypt altcoin with a hard cap limit of 21000000, block reward halving every 210000 blocks, difficulty adjustment every 4500 blocks, and a starting block reward of 25 coins per block.', '', '', 'Scrypt', '2015-07-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Elacoin', 'ELC', 'elc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://elacoin.cc/', NULL, 'Elacoin (ELC) is a digital currency, based on Bitcoin and Litecoin. A scrypt proof of work coin with a 120 second block time and dynamic difficulty retargetting. The more network power directed at mining the more each block will reward, although this will halve roughly every nine months. The launch was preannounced to allow a fair start. Some criticism say inflation on this model will be uncontrollable.', '', '', 'Scrypt', '2014-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Einsteinium', 'EMC2', 'emc2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'The Einsteinium Foundation\'s goal is to raise capital for leading scientific research. EMC2 is a means for doing so and is built with the same idea in mind as TakeiCoin or OrbitCoin. A Scrypt coin using the Kimoto gravity well with a 50% block reduction and a 60 second block time.', '', '', 'Scrypt', '2014-01-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Emerald', 'EMD', 'emd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.emeraldcrypto.org/', '@Emerald_Crypto', 'Emerald (EMD) is an innovative new alt coin that uses scrypt for mining. Emerald has a relatively fast 20 second block time and has 50 confirmations required for newly mined blocks and 3 for transactions. The block reward is set at 5 emeralds per block and halves every two years. Difficulty retargets every hour.', '', '', 'Scrypt', '2014-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Exclusive Coin', 'EXCL', 'excl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://exclusivecoin.pw/', '@exclusivecoin', 'Exclusive coin is a pure Proof of Stake alternative cryptocurrency.', '', '', 'PoS', '2016-06-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ExeCoin', 'EXE', 'exe.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Execoin\'s main talking point is its ASIC and Multi-pool mining resistance using its progressive-n algorithm. With the arrival of scrypt mining rigs and the potential monopolisation of Scrypt mining as happened with Bitcoin and SHA-256 coins. Execoin is planning to sidestep this issue. Total coins will be 84 million with a block time of 45 seconds - and a block reward reduction of every 840000 blocks. No premine means this is a serious contender with innovative features - not just another clone.', '', '', 'Scrypt', '2016-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EZCoin', 'EZC', 'ezc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.ezcoin.org/', '@EZ_Coin', 'EZcoin is based on Litecoin and is therefore a Scrypt coin. Difficulty retargets every 12 blocks and the block target is every minute. The block reward halves every 1.5 years with a starting number of 50 EZC per block.', '', '', 'Scrypt', '2015-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Flappy Coin', 'FLAP', 'flap.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://flappycoin.biz/', '@RealFlappyCoin', 'FlappyCoin (FLAP) does not seem to offer any benefits over Bitcoin and other popular cryptocurrencies, but instead seems to want to ride on Bitcoins and Flappy Birds success.The website states, FLAP is launched following the success of Flappy Bird. Otherwise the coin has a 1 minute block time, no premine and is scrypt based.', '', '', 'Scrypt', '2015-02-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Fuel2Coin', 'FC2', 'fc2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://fuelcrypto.com/', '@fuelcoinNEWS', 'FuelCoin (FC2) is an X11 proof of stake alternative crypto currency with a 2% annualised rate. The crypto currency can be traded for Bitcoin on Cryptsy and Bittrex.', '', '', 'X11', '2016-06-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FireflyCoin', 'FFC', 'ffc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Fireflycoin (FFC) is a SHA-256 crypto coin designed for collectors and traders. It is completely open source, and has a 700 billion coin cap. There are 120 Firefly coins mined every minute. Difficulty retargets every four blocks with a block time of 60 seconds.', '', '', 'SHA256', '2015-01-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FIBRE', 'FIBRE', 'fibre.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.fibrecoin.com/', '@fibrecoin', 'Fibre is an interesting crypto currency. It gives users the option to use ToR privacy enhanced features or not for transactions. The difficulty retargets using Dark Gravity Wave. The PoS rate is 5% per annum and the PoW supply is 624,000. The block time is set to 60 seconds.', '', '', 'NIST5', '2014-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FireRoosterCoin', 'FRC', 'frc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://freico.in/', '@Freicoin', 'FireRoosterCoin is a Proof of Work cryptocurrency based on the SHA256 algorithm. The coin was made for the Chinese community and its name is based in the Chinese culture, in which Fire Roosters are Hardworking, resourceful, courageous and talented.', '', '', 'SHA256', '2017-06-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FlutterCoin', 'FLT', 'flt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS/PoW/PoT', 'http://fluttercoin.us/', '@fluttercoin', 'Flutter coin introduces another design element through its proof of transaction. It has a block reward that stabilises at 20 after a block height of 332838 so there is no hardcoded cap in place.', '', '', 'Scrypt', '2014-03-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Franko', 'FRK', 'frk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://frankos.org/', '@FrankoCurrency', 'Franko is a high-value decentralized Internet currency based on the Scrypt algorithm. There is a dynamic kimoto gravity well difficulty retargetting and a 0.25 block reward with a 30 second block time. Apart from this - as a relatively old coin - there is a following and growing user base, if small.', '', '', 'Scrypt', '2013-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FractalCoin', 'FRAC', 'frac.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://fractalco.in/', '@fractalcoin', 'Fractal Coin intends to distribute 90% of its 1 million coins in the initial 28 days of mining. The coin features a new difficulty adjustment mechanism known as slingshot - the aim of which is to increase the % of controlled hashrate required for a 51% attack to over 70%. The idea is that block rewards will be based solely on transaction fees. Otherwise the coin has a 6o second block time and has a 0.5% premine.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FeatherCoin', 'FTC', 'ftc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.feathercoin.com/', '@Feathercoin', 'Feathercoin is based on Litecoin, which is safeguarded from the effects of Bitcoin ASIC mining until now. It has a block reward of 200 coins and will have a total of 336 million coins. The start block reward was 80 coins and halves every 840,000 blocks. The coin has 336 million as a hard cap and the block target is 1 minute - difficulty is damped at 25%. Feathercoin is a UK Oxford based initiative and as such has a following locally with some merchants accepting the currency. The website also has its own shop where you can post and sell goods for FTC - or Feathercoins.', '', '', 'Scrypt', '2014-04-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GrandCoin', 'GDC', 'gdc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://grandcoin.org/', '@GDCPool', 'GrandCoin \\[GDC\\] is a descendant of Litecoin, it pays 1 grand per block. There is a 45 second block time - with 50 confirmations needed for a mined block to mature - and a 6 block transaction confirmation time. The TX fee is 0.1%. The difficulty is retargetted every block and the block reward halves every year. Alongside the system supports transaction messaging.', '', '', 'Scrypt', '2014-01-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GlobalCoin', 'GLC', 'glc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.gcrmarketing.com/', '@GCRcoin', 'Globalcoin (GLC) is a scrypt based PoW coin with 70,000,000 as a hard cap - the block time is 40 seconds and transaction confirmations are 8. The block reward halves every year from 50 GLC - and difficulty retargets every block.', '', '', 'Scrypt', '2015-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GoldCoin', 'GLD', 'gld.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.gldcoin.com/', '@GoldCoinInfo', 'GoldCoin (GLD) is the Gold Standard of Digital Currency - With large vibrant support, trading communities, real world appeal and an extremely devoted development team, GoldCoin is the Gold Standard of Digital Currency. Block time + difficulty changes depending on the height of the block chain along with demarcated block rewards. The GoldCoin team have implemented Golden River - a method to adjust the block time each block to counteract large swings in hashing power pointed at the network - this method is smoother than than the Kimoto Gravity well meaning block times are more closely regulated.', '', '', 'Scrypt', '2013-11-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GalaxyCoin', 'GLX', 'glx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://galaxy.cryptcoins.net/', NULL, 'Galaxycoin (GLX) is a descedant of Novacoin, it uses both Proof of Work and Proof of Stake. It is effectively resistent to 51% attack. There are 64 coins per block and a block target time of 30 seconds. The difficulty retargetting is smoothed based on the last ten blocks average. Mining block rewards need 50 confirmations and transactions need 3 confirmations.', '', '', 'Scrypt', '2013-08-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GlyphCoin', 'GLYPH', 'glyph.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'GlyphCoin (GLYPH) is an X11 PoW PoS alternative crypto currency. The PoS rate is 10% per annum and the block time is 90 seconds per block with difficulty retargetting each block too. There was 0% premine.', '', '', 'X11', '2014-05-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GameLeagueCoin', 'GML', 'gml.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://bitcointalk.org/', '@GameLeaguecoin', 'GameLeagueCoin (GLC) is a PoW/PoS crypto currency with a difficulty retargetting every block and a block time of 60 seconds. The coin is scrypt and the POS carries an interest rate of 50% in Y1, 20% Y2, 10% Y3, 5% Y4, 2% Y5 and 1% thereafter. The coin was 100% premined for use in an online game.', '', '', 'Scrypt', '2014-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GuerillaCoin', 'GUE', 'gue.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://guerillacoin.com/', '@GuerillaCoin', 'Guerilla Coin is an X11 Proof of Work and Proof of Scrypt hybrid alternative crypto currency. The block time is set to a minute and the PoS reward is set to vary depending on the network strength. The maximum coin supply is 15 million GUE and proof of work will stop after the 10,000th block.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Halcyon', 'HAL', 'hal.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@HalcyonDev', 'Halcyon Coin is a decentralized digital currency, launching August 16th 2014 with a Proof of Work (PoW) period lasting approximately 9 days. Halcyon was developed so the PoW period would run simulataneously with the Proof of Stake phase (PoS), which eventually took over the blockchain as a means to confirm transactions. Halcyon was launched with no Premine or IPO. Stake holders are rewarded for holding their coins, at a rate of 9% annually. This rate also compounds on itself, and the staker is rewarded transaction fees as an extra incentive. Halcyon users with wallet balances greater than 2000 coins will soon be able to participate as masternodes, which will provide another source of residual income. There were a total of 1.62 million coins produced by the end of the PoW phase. The x15 algorithm was chosen so as to give individuals the best chance to acquire coins, with the least amount of multipool and asic interference.', '', '', 'X15', '2015-04-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HoboNickels', 'HBN', 'hbn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://hobonickels.info/', NULL, 'HoboNickels (HBN) is an extremely fast and efficient crypto-currency based on bottlecaps - (CAPS). With a Proof of Work block time of 30 seconds and 5 coins per block. There is a 2% super stake every 10 days - so 100% a year of holding your coins in your wallet - the opposite principle to Freicoin and its demurrage fee.', '', '', 'Scrypt', '2014-12-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HunterCoin', 'HUC', 'huc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://huntercoin.org/', '@ChronoKings', 'HunterCoin is a hybrid of scrypt and SHA-256 and Scrypt having two difficulties. 42 million HUC\'s are to be mined or farmed with a block time of 60 seconds. 80% of all coins are distributed in the game and the difficulty retargets each block.', '', '', 'Multiple', '2016-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HeavyCoin', 'HVC', 'hvc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://heavycoin.github.io/', '@HeavycoinNews', 'HeavyCoin is another unique crypto Currency with its Hefty1 algorithm to encourage CPU mining only. The coin is secure due to its SHA-256 Keccak-512, Blake-512 combination. The coin also has pegged difficulty retargetting and a decentralised block reward voting. Otherwise a block time of 2 mins and Kimoto Gravity well temporal retargetting.', '', '', 'Multiple', '2014-08-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Hyperstake', 'HYP', 'hyp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://hypercrypto.com/', '@nigeldollentas', 'HyperStake is meant to be an experimentation in cryptocurrency economics. HyperStake\'s primary goal is to create a cryptocurrency that provides a generous return for securing the block chain without massive inflation. Currently inflation is managed through the maximum stake reward of 1000 HYP per stake combined with a block target of 90 seconds, this means maximum coins per day of 960,000 HYP.', '', '', 'X11', '2014-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'IceBergCoin', 'ICB', 'icb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.icebergcoin.com/', '@Icebergcoin', 'Iceberg coin is a hybrid proof of work and proof of stake coin that uses the NIST5 algorithm.', '', '', 'NIST5', '2014-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Infinite Coin', 'IFC', 'ifc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://infinitecoin.com/', '@Infinitecoin_US', 'Infinitecoin (IFC) is a peer-to-peer open source cryptocurrency that is based on Litecoin (which was in turn inspired by Bitcoin), except that it will have 1142.86 times as many coins, and the difficulty with which coins are produced is adjusted more frequently.', '', '', 'Scrypt', '2013-05-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'IOCoin', 'IOC', 'ioc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://iocoin.io/', '@IO_Coin', 'IOCoin has a strong development team backing it. The coin is X11 with proof of work and proof of stake. The proof of stake has an annualised rate of 2%.', '', '', 'X11', '2015-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'IXcoin', 'IXC', 'ixc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.ixcoin.co/', '@Ixcoin', 'Ixcoin (IXC) is a fork of Bitcoin with twice the inflation rate of 96 Ixcoins per block and the same 21 million total limit. Ixcoin is intended to closely mirror code updates to Bitcoin to allow for easy interoperability with Bitcoin-related third party services and APIs. IXCoin can be merge mined with bitcoin.', '', '', 'SHA256', '2011-10-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'JumBucks Coin', 'JBS', 'jbs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://getjumbucks.com/', '@getjumbucks', 'The core idea behind Jumbucks is to create a coin for everyone to use. Jumbucks is not only meant to be fun and experimental, but it is designed to be a beacon towards which all cryptocurrencies should be headed. Jumbuck’s use cases will fund honest developers for future coin development, and encourage people to keep their wallets open (and staking!) by offering unique wallet features. Compelling and self-sustaining use cases are planned for Jumbucks, many of which have never yet been seen in the world of cryptocurrency. Jumbucks’ core is a fork of ShadowCoin, so it immediately offers great features such as P2P encrypted messaging and anonymous dual-key stealth addresses.', '**Proof of Developer**\n\nFor a coin to be successful, investors and users need to be able to trust the key developers behind the project. In keeping with this principle, Jumbucks has undergone POD verification and received a 5+ out of 5 POD identity verification.\n\n**No Premine | IPO**\n\nJumbucks launched with zero premine and zero IPO, leaving zero chance of developer dumps or cash-outs. Each individual Jumbuck was mined fairly and openly by the community!\n\n**Fair Launch**\n\nJumbucks experienced one of the fairest launches and widest distributions of any coin in the altcoin community. With a record number of first time miners, a public developer, and no premine or IPO, you can invest in Jumbucks with confidence and peace of mind. Join the Jumbucks community today!', '', 'X11', '2014-01-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'JunkCoin', 'JKC', 'jkc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Junkcoin is Litecoin-based. Total coins around 107 millions;1 minutes block target. Difficulty retargets once per day Mining will be shut down after 12 years. 50 coins per block. It will also be halved about every two years (every 1036800 blocks).', '', '', 'Scrypt', '2013-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'JudgeCoin', 'JUDGE', 'judge.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://bitcointalk.org/', '@JudgeCoin', 'JudgeCoin is a hybrid proof of work and proof of stake alternative crypto currency - the algorithm is X13 and the proof of stake annualised interest rate is 6%.', '', '', 'X13', '2016-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Klondike Coin', 'KDC', 'kdc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Klondike Coin is a scrypt based proof of work coin with a one minute block interval or block target - and a one minute or one block Kimoto gravity well based difficulty retargetting.', '', '', 'Scrypt', '2014-09-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'KeyCoin', 'KEY', 'key.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@KeyCoinTeam', 'KeyCoin is an X13 crypto currency that switches from a proof of work distribution phase to a proof of stake annualised to 20%. The block time is targettred to 1 minute.', '', '', 'X13', '2015-03-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'KrugerCoin', 'KGC', 'kgc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://krugercoin.co/', '@KrugercoinCo', 'Krugercoin runs off the popular scrypt protocol which enables it to have stability for early adapters and users by operating from regular existing computer hardware.', '', '', 'Scrypt', '2015-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CoinWorksCoin', 'LAB*', 'lab_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'CoinWorksCoin was an experimental coin running off multiple algorithms like Quarkcoin. With both the twitter feed and the website down there isn\'t much information on this particular crypto currency.', '', '', 'Multiple', '2014-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Legendary Coin', 'LGD*', 'lgd_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@legendarycoin', 'Legendary Coin is a PoW/PoS hybrid. The Coin has a raft of features such as transaction fee destruction, messaging, with hourly and daily superblocks. There is a two minute block time with the reward halving every 64800 blocks. The PoW phase is limited to 10 million and the PoS has an annualised rate of 50%.', '', '', 'Scrypt', '2014-01-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Lucky7Coin', 'LK7', 'lk7.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://lucky7coin.co.nf/', NULL, 'Lucky7Coin (LK7) It is a POW/POS coin with a completely new algorithm and belong to latest PPCoin/Novacoin. Lucky7Coin offers superblocks for miners. That means they could randomly win huge rewards from 77 coins to 7,777. The coin also offers a 5% annual interest rate.', '', '', 'Scrypt', '2014-03-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LuckyCoin', 'LKY', 'lky.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.luckycoin.cc/', '@LKYFoundation', 'LuckyCoin offers super lucky blocks, where the reward can be x2 ,x5 and even x58. The difficulty was adjusted much more rapidly at the start to adapt to more fluctuating hash power than normal. The difficulty is retargeted about every 4 hours.', '', '', 'Scrypt', '2014-12-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LightSpeedCoin', 'LSD', 'lsd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'LightSpeed coin is a proof of work and proof of stake hybrid alternative cryptocurrency with a 3% annualised interest rate when staking. The algorithm is NIST5.', '', '', 'NIST5', '2015-01-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Litebar ', 'LTB', 'ltb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@litebarco', 'Litebar is another Scrypt Litecoin clone. Difficulty retargets once per block using the Kimoto gravity well. Block time is 3 minutes and the coin was not premined.', '', '', 'Scrypt', '2014-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LitecoinDark', 'LTCD', 'ltcd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.litecoindark.com/', NULL, 'Litecoin dark is a scrypt based alternative crypto currency combining darkcoin and litecoin features. Just over 80 million currency units of LTCD ar to be issued throughout the proof of work mining cycle.', '', '', 'Scrypt', '2016-05-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LitecoinX', 'LTCX', 'ltcx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://bitcointalk.org/', '@LiteCoinX11', 'LitecoinX (LTCX) is an attempt to move Litecoin away from scrypt to a non-asic mineable algorithm X11, as Bitcoinx was for Bitcoin. The total money supply is capped at 84 million and the difficulty retargets using Digishield on a block time of 45 seconds.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LibrexCoin', 'LXC', 'lxc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.librexcoin.com/', '@LibrexCoin', 'LibrexCoin (LXC) is an X11 based alternative crypto currency. The block time is sixty seconds, there was no premine and the proof of stake has a 2% annual interest rate.', '', '', 'X11', '2015-09-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LycanCoin', 'LYC', 'lyc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://lyccoin.org/', '@Lycancoin', 'LycanCoin is a spoof coin based on its namesake, and part of a trilogy of three other Coins - namely ZombieCoin and Vampire Coin. Inspired by and for the creator\'s daughter - but ultimately a scrypt coin with a 2.5 min block time.', '', '', 'Scrypt', '2015-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MaxCoin', 'MAX', 'max.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.maxcoin.co.uk/', '@maxcoinproject', 'A coin operating on a slightly different algorithm of SHA-3. However the main characteristics are all there including a relatively fast 30 second block time. Retargetting is done using the Kimoto Gravity well algorithm.', '', '', 'SHA3', '2014-06-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MegaCoin', 'MEC', 'mec.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.megacoin.co.nz/', '@mega_coin', 'Megacoin (MEC) is a Scrypt based coin. Difficulty retargets every 22.5 mins The block target is 2.5 mins and the total number of coins mined is set to 42 million.', '', '', 'Scrypt', '2015-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MediterraneanCoin', 'MED', 'med.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.mediterraneancoin.org/', '@MEDDevTeam', 'Mediterranean Coin (MED) is a uses a hybrid algorithm of Scrypt and SHA-256 - in order to limit the ability of large miners to jump on a network and increase the hashing power disproportionately. 200 million currency units are set to be mined.', '', '', 'HybridScryptHash256', '2014-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Minerals Coin', 'MIN', 'min.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Minerals_dev', 'Minerals (MIN) is a PoW/PoS X11 based crypto currency. The block time is thirty seconds and the PoW, proof of work, was designed to last for seven days. The coins main premiss was to distribute the currency evenly with 30 million coins in the PoW phase. The difficulty retargets every block and there was no premine.', '', '', 'X11', '2014-05-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MintCoin', 'MINT', 'mint.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.mintcoinofficial.com/', '@MintcoinTeam', 'Mintcoin is a community owned and operated pure PoS coin. Send your coins to your wallet and earn high yielding interest for saving your coins while securing the Mintcoin network.\n\nThere is no coin cap, in order to replace lost coins and provide sustainable global scalability. The coin now runs 100% POS (proof-of-stake) to secure the network. After the year 2016, Stakers aka Minters will receive a fixed 5% APR (annual percentage rate) indefinitely, as a reward for securing the network.', '', '', 'Scrypt', '2014-06-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cryptsy Mining Contract', 'MN', 'mn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.cryptsy.com/', '@cryptsy', 'A cryptsy mining contract share based on the SHA-256 algorithm coins. 20 Th/s are available in increments of 1Gh/s - so an issued shares of 20000. Contracts can be bought and sold as and when on the Cryptsy exchange. The provider is not disclosed by Cryptsy and the share represents a lifetime contract.', '', '', 'SHA256', '2014-03-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MinCoin', 'MNC', 'mnc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.mincoin.us/', '@MinCoinus', 'MinCoin is a peer-to-peer cryptocurrency using scrypt as a proof-of-work algorithm. Mincoin stands for \'minimalist\' coin, and it bills itself as the \'one-minute coin\' thanks to its one-minute block time. The developers behind the coin are active and progressive.', '', '', 'Scrypt', '2013-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MurrayCoin', 'MRY', 'mry.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.murraycoin.org/', '@Murraycoin', 'MurrayCoin is another celebrity based coin named after Bill Murray. Or basically a scrypt coin with 100 second block target and difficulty change limited to 67% maximum swing. The difficulty is adjusted every 36 blocks, and block rewards & reductions lower eventually stabilising at 60 after block 110001 - and then a standard subsidy 50% reduction every 300,000 blocks.', '', '', 'Scrypt', '2015-08-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MysteryCoin', 'MYST*', 'myst_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://mysterium.network/', '@https://twitter.com/MysteriumNet', 'MysteryCoin (MYST) is a PoW/PoS hybrid alternative crypto currency. The algorithm is X11 and the proof of stake rate is 16.8% for the first year. LGD\\*', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MazaCoin', 'MZC', 'mzc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://mazacoin.org/', '@MazaCoin', 'MazaCoin (MZC) is the first sovereign currency as well as Official National Currency of the Traditional Lakota Nation and a fork of the ZetaCoin that branched from BitCoin.', '', '', 'SHA256', '2015-12-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NanoToken', 'NAN', 'nan.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@nanotoken', 'NanoCoin (NAN) is a litecoin clone, nanotokens run on a scrypt algorithm and have 90-second blocks and a total circulation of 80 million.', '', '', 'Scrypt', '2015-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Nautilus Coin', 'NAUT', 'naut.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.nautiluscoin.com/', '@Nautiluscoin', 'Nautlius Coin is a Scrypt coin with some unusual features such as its 1% weekly block reward reduction. Transaction confirmations are fast due to the 60 second block time and the difficulty retargetting is every block based on DigiShield. The one percent premine is used in the Nautlius stabilisation fund to ensure liquidity in the market.\n\nAs pointed out by the Bank of England in its Quarterly Bulletin 2014 Q3 “The Economics of Digital Currencies”, Bitcoin faces three challenges: 1) Volatility 2) Sustainability of Low Transaction Fees 3) Limitations of a Fixed Money Supply. Nautiluscoin was designed to address and eliminate the challenges faced by Bitcoin.\n\nhe Nautiluscoin Stability Fund seeks to reduce volatility, while the Proof of Stake algorithm does away with the need for expensive mining equipment. Additionally, at the heart of the Proof of Stake reward calculation is an algorithmic monetary policy that adjusts money supply with demand.\n\nThe Nautiluscoin economy is built on the foundation of a strong currency policy and the view that a strong economy requires a currency which preserves purchasing power. Creating a fertile environment for an economy to develop requires the continuous pursuit of stability. But the pursuit of stability is not just about reducing daily price fluctuations.\n\nFor Nautiluscoin to be truly successful it must preserve and increase purchasing power. Daily price stability is important for consumers and merchants to transact, but the long run success of any currency is a function of purchasing power. If users of a currency believe that their ability to purchase goods and services in the future will be diminished then they are less likely to hold and use the currency. Therefore the most important goal for Nautiluscoin will be to maintain a strong currency with a stable and growing purchasing power.\n\nIn order to accomplish its strong currency goal, Nautiluscoin will compete with economics. Traditionally central banks with a strong currency policy are charged with providing an anchor for the economy through the use of money supply targets, interest rate targets, and/or exchange rate targets. Economic history has shown that these targets require the central bank to have significant resources in order to credibly accomplish the targets. Most successful targeting policies rely on an unlimited resource which is classically the ability to print or borrow money. In the case of Nautiluscoin, the terminal money supply is fixed by the software code and there are not public debt markets to use as an interest rate targets. However, this does not mean it lacks arrows in the quiver.\n\nBecause the terminal money supply is fixed and released over time we have the ability to set the growth rate of the money supply. As well, the Nautiluscoin network will be secured through proof-of-stake method which will pay interest to those who desire to hold Nautiluscoin. Finally, the mining process allows us to support the exchange rate by using mining profits to purchase Nautiluscoin.', '', '', 'Scrypt', '2016-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NavCoin', 'NAV', 'nav.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://navcoin.org/', '@NavCoin', 'NavCoin (NAV) is a privacy-driven PoW/PoS hybrid cryptocurrency. NAV uses the x13 hashing algorithm. NavCoin\'s encryption software disconnects and randomises the transaction data, removing it even from an IP address. NavCoin uses a subchain to process anonymous transactions.', '', '', 'X13', '2014-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Nybble', 'NBL', 'nbl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Nibble another litecoin clone. Ascending reward system that proved effective and prevented insta-mining, pre-mining, unfair rewards for early adopters.', '', '', 'Scrypt', '2014-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NeoCoin', 'NEC', 'nec.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://neocoin.org/', NULL, 'Neocoin has some innovative features due to its dedicated team of software engineers. It does include a simple format for messaging and tagging transaction. Otherwise it is a PoW PoS with dynamic difficulty retargetting and a 100 second block time.', '', '', 'Scrypt', '2015-03-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NetCoin', 'NET', 'net.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://netcoinfoundation.org/', '@NetcoinNET', 'Netcoin (NET) is a proposed Scrypt type cryptocurrency with a hybrid proof-of-work and proof-of-stake system that affords eventual control of the monetary supply to users. Mining features a Super block every hour equal to 8 times the regular blocks. Netcoin v1.2.0 features the Kimoto Gravity Well difficulty adjustment algorithm.', '', '', 'Scrypt', '2013-02-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Nimbus Coin', 'NMB', 'nmb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Nimbus Coin is an X15 proof of work and proof of stake hybrid - the project has been closed for development due to lack of funding - however the coin can still be traded on cryptsy. The PoS rate is 2%.', '', '', 'X15', '2015-04-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NoirBits', 'NRB', 'nrb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.noirbits.com/', '@NoirbitsCoin', 'NoirBits (NRB) The 2 minute block time aims to improve on LTC\'s time but not so drastic as to cause a permanent orphan problems. There are 50 million total coins with 20 coins per block and a 2 minute block time.There is an hourly retargetting with a 30 block mining confirmation and a six block transaction confirmation.', '', '', 'SHA256', '2013-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NobleCoin', 'NOBL', 'nobl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.noblemovement.com/', '@NobleCoin', 'NobleCoin (NBL) is a scrypt based altcoin with a block time of 60 seconds - with five confirmations needed for transactions and 50 required for minting. The coin supports transaction messaging and difficulty retargets every thirty blocks.', '', '', 'Scrypt', '2014-07-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NoirShares', 'NRS', 'nrs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@NoirDS', 'Noirshares are another interesting concept as a coin as well as being a PoW/PoS coin - they also double as an equity investment for the NIG Group. The coin has a block reward reduction every 3000 blocks and difficulty adjustments each block. There are 80 NRS per block originally and the PoW phase is limited by a hard cap of 5million NRS. Transaction fees are destroyed and taken out of the system to counter the inflation of the PoS stage.', '', '', 'Scrypt', '2016-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NovaCoin', 'NVC', 'nvc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://novacoin.org/', '@MarketNvc', 'Novacoin is a hybrid scrypt Proof-of-Work + Proof-of-Stake based cryptocurrency operating with no central authority via peer-to-peer open source network. Novacoin has no hard cap except for the 2 billion coin max that has been entered for coding purposes; this can be lifted in the future if needed.', '', '', 'Scrypt', '2013-09-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NameCoin', 'NMC', 'nmc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://namecoin.info/', '@Namecoin', 'Namecoin s a cryptocurrency which also acts as an alternative, decentralized DNS, which would avoid domain name censorship by making a new top level domain outside of ICANN control. The coin is designed to halve every four years with the same cap limit as Bitcoin of 21,000,000. With the domain registry service a small number of NMC will be destroyed so after mining has finished there will still be a deflationary ellement in place. Namecoin was the first coin to switch to merged mining.', '- Namecoin can store data within its own blockchain transaction database\n- Censorship-resistant top level domain .bit, which is functionally similar to .com or .net domains but is independent of ICANN, the main governing body for domain names\n- Identity systems\n- Messaging systems\n- Personal namespaces\n- Notary/timestamp systems\n- Alias systems\n- Issuance of shares/stocks', 'It is based on the code of bitcoin and uses the same proof-of-work algorithm. It is limited to 21 million coins. Each Namecoin record consists of a key and a value which can be up to 520 bytes in size. Each key is actually a path, with the namespace preceding the name of the record. The key d/example signifies a record stored in the DNS namespace d with the name example and corresponds to the record for the example.bit website. The content of d/example is expected to conform to the DNS namespace specification. The current fee for a record is 0.01 NMC and records expire after 36000 blocks (~200 days) unless updated or renewed. Namecoins used to purchase records are marked as used and destroyed, as giving the fee to miners would enable larger miners to register names at a significant discount.', 'SHA256', '2012-06-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NyanCoin', 'NYAN', 'nyan.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://nyan-coin.org/', '@Nyan_Coin', 'A coin based on a meme of an animated flying cat in the same vein as flappy coin. The algorithm is Scrypt and there are 337 coins per block halving every 337,000 block with a 1% premine for bounties. The block target is set to 1 minute, or 60 seconds, and difficulty retargets every 3 hours.', '', '', 'Scrypt', '2014-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OpalCoin', 'OPAL', 'opal.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.opal-coin.com/', '@OpalCoinTeam', 'OpalCoin is a rebranding and relaunch of OnyxCoin. The coin is a hybrid proof of work and proof of stake running on X13. The proof of stake rate is 5% per annum.', '', '', 'X13', '2014-12-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Orbitcoin', 'ORB', 'orb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://orbitcoin.org/', '@OrBitcoinLove', 'A coin that is a clone but with the added mission of trying to encourage scientific research. OrbitCoin is a PoW/PoS hybrid without the PoS reward to reduce inflation but maintain the resistance to 51% attacks. There are transaction messages with a 30 second block time, a block reward that halves from 0.25 to a minimal 0.00000001. There are four transaction confirmations needed and 200 for newly mined blocks.\n\nblock hashing is BLAKE2s  \nPoW hashing is NeoScrypt  \nPoS hashing is SHA-256d', '- advanced hybrid proof-of-work (PoW) and proof-of-stake (PoS)\n- 3.77 million coins to be produced\n- block hashing is BLAKE2s\n- PoW hashing is NeoScrypt\n- PoS hashing is SHA-256d\n- 1 minute combined block target (3 minutes for PoW, 1.5 minutes for PoS)\n- retargets every block using Orbitcoin Super Shield (OSS)\n- time warp and instamining protection\n- advanced checkpointing against 51% attacks\n- transaction messaging supported\n- the 1st implementation of 0% PoS\n- PoW and PoS blocks carry the same fixed reward of 1 ORB\n- 6 confirmations for regular transactions\n- 200 confirmations for minted coins\n- very low transaction fees (most transactions are free)\n- no destruction of transaction fees (all collected by a block finder)\n- the default P2P port is 15298, RPC port is 15299\n- I2P/Tor ready', '', 'NeoScrypt', '2013-11-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OpenSourceCoin', 'OSC', 'osc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://bitcointalk.org/', NULL, 'OpenSourceCoin (OSC) it is different from other cryptocurrencies due to its innovative features like symmetrically scaling difficulty retarget algorithm and its is a SHA 256 POW/POS cryptocurrency.', '', '', 'SHA256', '2013-04-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PhilosophersStone', 'PHS', 'phs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://phstones.com/', NULL, 'Philosopherstone provides an annual interest rate of 50%, for stakes that are not moved during the period. This equivalent to 3.44% monthly interest. PoS blocks will be generated if the stake is held for more than 5 days.', '', '', 'Scrypt', '2015-04-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cryptsy Points', 'POINTS', 'points.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://www.cryptsy.com/', '@cryptsy', 'Cryptsy Points are the cryptsy exchanges own internal affiliate refferal program currency. No algorithm and no code. Cryptsy calculates its payouts every day for your activity.', '', '', '', '2014-03-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PotCoin', 'POT', 'pot.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.potcoin.com/', '@PotCoin', 'PotCoin is another scrypt coin launched at the start of 2014. PotCoin is supposed to empower and facilitate the marijuana industry. The first 55 blocks were premined for checkpoints - and the coin has a relatively fast blocktime of 40 seconds.', '', '', 'Scrypt', '2015-09-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PseudoCash', 'PSEUD', 'pseud.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'PseudoCash (PSEUD) is an X13 crypto currency. The proof of stake is set to 5% per annum.', '', '', 'X13', '2014-03-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Protoshares', 'PTS*', 'pts_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://bitsharestalk.org/', '@protoshares', 'Protoshares are a confusing alt coin (any cryptocurrency that isn\'t Bitcoin). They\'re not just another cryptocurrency, though they are mined and can be traded like conventional crypto. Beyond that, they also represent shares in Invictus-Innovation\'s cryptocurrencies and digital creations.', '', '', 'SHA256', '2014-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PhoenixCoin', 'PXC', 'pxc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://phoenixcoin.org/', '@Phoenixcoin', 'Phoenixcoin (PXC)is Scrypt based cryptocoin and digital currency for everyone. It doesn\'t depend upon very expensive hardware and can be mined successfully with popular computer video cards or processors. It is also a fast and reliable way to send money worldwide. The currency can be used on the developers casino website.', '', '', 'Scrypt', '2014-08-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PayCoin', 'PYC', 'pyc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'PayCoin is a peer-to-peer (P2P) Internet currency that enables instant payments to anyone in the world. It runs off the popular scrypt protocol which gives it unmatched stability and easy accessibility. PayCoin uses memory-hard, scrypt-based mining with both proof-of-work and proof of stake algorithm to target the regular computers and GPUs most people already have.', '', '', 'Scrypt', '2013-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ReddCoin', 'RDD', 'rdd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://www.reddcoin.com/', '@reddcoin', 'ReddCoin is trying to jump on the tipping bandwagon by making itself the social network donation go to default. A Scrypt coin with a 60 second block time and block retargeting using kimoto\'s gravity well. The coin also includes a 5% annual inflation after the 27.5 billion have been mined by PoW. Alongside Reddcoin inludes an innovative proof of stake velocity algorithm.', '', '', 'Scrypt', '2014-02-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RipOffCoin', 'RIPO', 'ripo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@RipoffCoin', 'A crypto currency that mocks the numerous others that are actually scams. For example stating there was no premine then that there in fact was a hidden premine. A scrypt coin with roughly 12 milllion RIPO.', '', '', 'Scrypt', '2014-01-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RotoCoin', 'RT2', 'rt2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Rotocoin', 'RotoCoin (RT2) is a Scrypt-n algorithm based PoW coin. The block reward is 2 coins on a block time of 288 seconds and difficulty retargetting is perfomed using the Dark Gravity Wave.', '', '', 'Scrypt-n', '2015-03-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RoyalCoin', 'RYC', 'ryc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://royalcoin.org/', NULL, 'RoyalCoin is a new scrypt based coin created by three Montreal based developers. The block time is set to 3 minutes and the subsidy halves very 600,000 blocks. Difficulty retargets once per day. There was no premine and the orignal block reward was set to 100 RYC with a hard cap limit of 140,000,000.', '', '', 'Scrypt', '2013-09-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RazorCoin', 'RZR', 'rzr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://ww2.razorcoin.com/', '@RazorCoin', 'Razor (RZR) is a scrypt based PoW alternative crypto currency. The block time is targetted to 75 seconds and the block time is 75 seconds. The block reward starts at an initial 100 RZR and halves every 10,000 blocks.', '', '', 'Scrypt', '2015-03-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Saturn2Coin', 'SAT2', 'sat2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://saturn2.co.in/', '@Saturncoins', 'Saturn2Coin is a relaunch of Saturn Coin. It is a scrypt PoW coin with a total supply of 15 billion units and a difficulty retargetting every 30 minutes.', '', '', 'Scrypt', '2016-07-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'StableCoin', 'SBC', 'sbc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'StableCoin is a new type of decentralized currency. SBC has what it calls the optimised block time of 40 seconds - to play the balance between orphaned blocks and transaction confirmation time - i.e. Forking issues. Difficulty is retargetted every 90 blocks and the coin reward is set to 25 coins after block 900. They have plans for their own ecommerce site.', '', '', 'Scrypt', '2013-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ShadowCash', 'SDC', 'sdc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.aboutshadow.com/', '@SDCoin', 'ShadowCash (SDC) is a scrypt hybrid Proof of work and proof of stake coin with a 2% staking interest per annum.\n\nAn entire privacy-based platform which aims to establish an anonymous economy, with multiple features that give people all the financial freedom and privacy they should have.\n\nShadow is a decentralized anonymous communication, commerce and currency platform through which the virtual currency, ShadowCash, can be transferred. One of the significant advantages of Shadow is its deep integration with the rest of Shadow\'s features as well as offering native TOR support for IP obfuscation.', 'The ShadowSend protocol combines:\n\n**Dual-key stealth addresses**\n\n\\-- Unlinkability\n\n\\-- Severs links between the sender and receiver\n\n**Ring signatures**\n\n\\-- Signature obfuscation\n\n\\-- Signatures are grouped with other signatures to hide the real sender\n\n**NIZK (Non-Interactive Zero Knowledge) proofs**\n\n\\-- Untraceability\n\n\\-- Separates the transaction inputs and outputs', 'Specification\n\n\\- Block Time: 60 seconds\n\n\\- Difficulty Re-target: every block\n\n\\- Nominal Stake Interest: 2% annually\n\n\\- Min Transaction Fee: 0.0001 SDC\n\n\\- Confirmations: 10 - Maturity: 500\n\n\\- Min Stake Age: 8 hours - no max age\n\n\\- P2P Port: 51737\n\n\\- RPC Port: 51736', 'Scrypt', '2015-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SaffronCoin', 'SFR', 'sfr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://saffroncoin.com/', '@sfrcoin', 'SaffronCoin (SFR) is a PoW coin based on mining with any of these five algorithms - SHA-256, Scrypt, Groestl, X11 or Blake256. The difficulty is adjusted individually for each algorithm so the probability of finding a hash remains the same for algorithm type. There are random superblocks and the block time is 450 seconds with a hard cap of 111 million.', '', '', 'Multiple', '2016-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ShadeCoin', 'SHADE', 'shade.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@ShadeCoin', 'Shade is a hybrid proof of stake and proof of work alternative crypto currency that you can trade for bitcoin on cryptsy and on bittrex. The proof of stake annualised rate is 4%.', '', '', 'Scrypt', '2014-04-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ShieldCoin', 'SHLD', 'shld.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@shieldcoindevs', 'ShieldCoin (SHLD) is a hybrid Proof of Work and Proof of Stake alternative Crypto Currency. The PoW distribution phase ends after 3 days and the PoS phase carris an annualised interest rate of 15%. The block time is 120 seconds.', '', '', 'X15', '2014-08-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SilkCoin', 'SILK', 'silk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://silk-coin.com/', '@Silk_coin', 'SilkCoin (SC) is a POW POS hybrid coin that has first stage of POW and POS of 7 days, thena pure POS stage for thirty days, and then again a hybrid POW POS phase, followed by a pure POS phase in perpetuity at 2% per annum. Difficulty retargets every block and the maximum POW supply is 100 million. All fees are paid to miners to encourage the network.', '', '', 'Scrypt', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SterlingCoin', 'SLG', 'slg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://sterlingcoin.org.uk/', '@SterlingcoinSLG', 'Sterling Coin is a hybrid proof of work and proof of stake alternative crypto currency that is now pure proof of stake with a 5.5% annualised rate.', '', '', 'X13', '2014-02-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SmartCoin', 'SMC', 'smc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://smartcoin.cc/', '@SmartCoinSMC', 'SmartCoin (SMC) is a practical digital currency and anonymous peer-to-peer crypto currency designed with a fair start in mind. With it\'s fast transaction times, ease of use, and good resources SmartCoin is a great everyday use cryptocurrency. The coin was designed to encourage early mining with its super blocks - but ends up being a premine. The block reward is fixed after block 1000 - or roughly a day after its genesis block.', '', '', 'Scrypt', '2014-06-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SoleCoin', 'SOLE', 'sole.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'SoleCoin is a hybrid proof of work and proof of stake coin. The annualised rate for staking is 5%.', '', '', 'X15', '2014-08-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SpainCoin', 'SPA', 'spa.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://spaincoin.org/', '@SpainCoinDev', 'SpainCoin is a scypt-n based coin with difficulty adjustments every block using digishield and a 2 minute block time. The idea is similar to aurora coin in that it is a national coin - whereby the premine is distributed to all Spanish citizens.', '', '', 'Scrypt-n', '2015-01-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Spots', 'SPT', 'spt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'A Spot (SPT) has super-blocks that are 205 times larger than regular block and contains 10K coins. There is a small chance (0.01 percent) to generate super-block every 2 hours. The coin has 70 seconds between blocks and retargets based on average of the last 21 blocks.', '', '', 'Scrypt', '2014-09-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SecureCoin', 'SRC', 'src.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://securecoin.org/', '@SecureCoin', 'SecureCoin is a fast and secure cryptographic digital currency based on Bitcoin. The specifications have been carefully chosen to maintain Bitcoins economic model of deflation. A single hashing algorithm poses a security risk because if it is compromised, the whole network is forever compromised. Multiple hashing algorithms enhance the security of the network by not only mitigating this, but also by adding an additional layer of complexity for any attacker to penetrate.', '', '', 'Scrypt', '2015-04-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SSVCoin', 'SSV', 'ssv.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://bitcointalk.org/', '@SSVCoin', 'SSV is an X13 pure proof of work alternative crypto currency with a reducing block reward until a height of 500,000 where the reward becomes flat at 13 coins.', '', '', 'X13', '2015-10-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Stellar', 'XLM', 'xlm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://www.stellar.org/', '@stellarorg', 'Stellar is public infrastructure for money.\n\nSupported by a nonprofit, Stellar brings the world together by increasing interoperability between diverse financial systems and currencies.\n\nStellar is a technology that enables money to move directly between people, companies and financial institutions as easily as email. This means more access for individuals, lower costs for banks, and more revenue for businesses. Help better the world’s financial infrastructure by participating in our community or by building on Stellar.', '', '', '', '2014-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SuperCoin', 'SUPER', 'super.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://bitcointalk.org/', '@CoinSuper', 'SuperCoin (SUPER) is an X11 PoW/PoS hybrid that has a 90 second block time and a difficulty retargetting each block. The PoS block time is 20 seconds per block with a high first year annual rate of 100%, dropping to 50% in year 2, and a final 1% in year 3. The PoW payout halves the block reward every 45 days from an initial 512 SUPER, to a minimum of 1 coin per block. There are also superblocks every 3 hours of 4x the normal payout, every day of 16x the normal payout, and every five days 128x the normal payout. There was a 5% premine for IPOing the coin.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitSwift', 'SWIFT', 'swift.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.bitswift.io/', '@Bit_Swift', 'Bitswift (SWIFT) is a proof of stake and proof of work alternative crypto currency. The proof of stake rate is set to 3% per annum.', '', '', 'Scrypt', '2016-05-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SyncCoin', 'SYNC', 'sync.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@synclub', 'SyncCoin (SYNC) is an X11 algoithm alt Coin. The block time is sixty seconds and the POW phase ends after 1000 coins have been mined. The continuing POS phase is set to a rate of 1% per annum. There was a 0.5% premine.', '', '', 'X11', '2015-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SysCoin', 'SYS', 'sys.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://syscoin.org/', '@syscoin', 'SysCoin is a proof of work based alternative crypto currency with a block time of sixty seconds and 2 billion total currency units to be produced.', '', '', 'Scrypt', '2016-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TagCoin', 'TAG', 'tag.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.tagcoin.org/', '@TagCoin', 'TagCoin is a startup making a few changes in the membership and rewards sector. TagCoin will be the primary currency used within Tagbond and TagCash. Developers designed TagCoin to have universal worldwide rewards currency.', '', '', 'Scrypt', '2015-03-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TakCoin', 'TAK', 'tak.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@TAKcoin', 'TakCoin is another coin with a mission - this time to raise awareness of human rights abuses and to encourage charity and aid. Otherwise a very standard crypto currency operating the SHA-256 algorithm with a relatively quick 30 second block time.', '', '', 'SHA256', '2014-08-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TeslaCoin', 'TES', 'tes.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://teslacoins.com/', '@TeslaCoins', 'TeslaCoin (TES) is a Scrypt based crypto coin with a thirty second block time. There are a total of 300 million coins to be mined and 172 coins per block initially, reducing by 18.56% every thirty days. There was a 3% premine for the standard bug, bounties and development fees.', '', '', 'Multiple', '2015-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TigerCoin', 'TGC', 'tgc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://tigercoin.wordpress.com/', '@TigerCoin', 'Tiger (TGC) is a SHA-256 based cryptocoin with a re-target every 20 blocks, POW, 128 coins per block, and 47 million total coins.', '', '', 'SHA256', '2013-06-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TitCoin', 'TIT', 'tit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.titcoins.biz/', '@OfficialTitcoin', 'TitCoin is an alternative crypto currency designed for the erotic industries - and has already seen coverage in major magazines. The coin is a standard bitcoin clone based on SHA-256 and proof of work.', '', '', 'SHA256', '2015-09-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TorCoin', 'TOR', 'tor.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://bitcointalk.org/', '@TorCoinDev', 'TorCoin is an X11 Proof of Work and Proof of Stake hybrid alternative crypto currency that intends to provide anonymously located web pages through a decentralised masternode network. The block time is 60 seconds and the Proof of Work phase ends after 7 dasy wherebya Proof of Stake phase takes place with an annualised rate of 10%.', '', '', 'X11', '2014-04-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TerraCoin', 'TRC', 'trc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.terracoin.info/', '@terracoin_TRC', 'Terracoin (abbreviated TRC) is a peer to peer decentralized currency based on Bitcoin. Terracoin was launched on the 26th of October 2012 and is an SHA-256 coin with a hard cap of 42 million coins. The block time is 2 minutes and the block reward is initially set to 20 TRC. The block reward halves every four years and difficulty retargets every thirty blocks or every hour. There was no premine.\n\nIt is similar to Bitcoin, but with faster transactions, and improved security by having merged mining and Dark Gravity Wave difficulty recalculation. The Terracoin Foundation was formed to provide stable development, improved security and better community involvement for Terracoin.\n\nThe TRC Dev Team is currently implementing DASH’s decentralized governance, masternodes, and instant sent.', '', '', 'SHA256', '2014-02-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TittieCoin', 'TTC', 'ttc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://tittiecoin.com/', '@TittieCoin', 'TittieCoin is another coin attempting to sync up with the erotic industries - a scrypt proof of work crypto currency.', '', '', 'Scrypt', '2016-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Umbrella', 'ULTC', 'ultc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.umbrella.holdings/', NULL, 'Umbrella coins and its alternatives are an attempt at insuring against exchange loss or wallet key loss. Otherwise the coin is made as a pair to the major crypto currency of each algorithm type. This is the SHA-256 version.', '', '', 'SHA256', '2014-12-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Unobtanium', 'UNO', 'uno.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://unobtanium.uno/', '@bryceweiner', 'Ultra rarity is this token\'s modus operandi. 1 Un per block, halving every 102,000 blocks. Only 196,875 Proof of Work UNOs will be minted before 0.0001 minimum block subsidies take effect at block 612,000. Zero coins premined. UNO\'s are an SHA-256 POW coin with a block target of three minutes and a hard cap to the coin supply of 250,000.', '', '', 'SHA256', '2014-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'UroCoin', 'URO', 'uro.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://uro.io/', '@UroFoundation', 'UroCoin (URO) is an X11 PoW based alternative crypto currency. Uro\'s focus is to try and provide a means for efficient international trade of Urea - they wish to provide a backing to the coins market capitalisation by holding Urea itself. The coin has a block time of 3 minutes and retargets using the safe gravity well. There was no premine and the recommended transaction fee is 0.1%. The total coin supply will be 1 million URO in the first six months and then 10% growth per annum to coincide with the projected growth rate of the global Urea market - as such the block reward will drop from 12 URO after the first six months to 1 URO per block in perpetuity.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'UnitaryStatus Dollar', 'USDE', 'usde.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.usd-e.com/', '@CoinUSDE', 'USDe is another scrypt crypto currency - branding itself as an anti establishmentarian - anti Fed - and pro liberty in the American sense. The coin has two block reward reductions when 1/3 of supply has been mined. Total supply is 1.6bn. The coin is scrypt (anti asic mining) with single block difficulty retargetting using the kimoto gravity well. Inital block reward is set at 4000.', '', '', 'Scrypt', '2014-12-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'UltraCoin', 'UTC', 'utc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://ultracoin.net/', '@official_utc', 'UltraCoin(UTC) uses Scrypt-Jane algorithm, which ensures it cannot be mined by ASICs like other cryptocurrencies as it is released in a transparent process that allows for independent verification of binaries and their corresponding source code, and hybrid proof-of-work / proof-of-stake coin whereby active nodes are involved in the mining of blocks if they maintain a UTC balance. Difficulty retargeting is limited to 200% increases at each retargeting.', '', '', 'Scrypt', '2014-01-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Utility Coin', 'UTIL', 'util.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@UtilityCoinTeam', 'Utility coin is an X13 proof of work and proof of stake hybrid. The proof of stake rate is set to 20% per annum.', '', '', 'X13', '2016-02-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'VidioCoin', 'VDO', 'vdo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.vidioshare.me/', '@vidioshare', 'VDO is a new video sharing website based on the founding principle of Bitcoin, a new decentralized monetization protocol and video sharing website. One of the most prominent points surrounding the project is the sharing of rewards with video creators and users. Vidio is designed to give users an alternative platform to upload and distribute content across the Internet. Vidio specializes in video platforms and video usability. Vidio will also be built around the Vidio crypto currency. One of the most important features of the service however is that it is completely advertisement free. Instead of gaining outside advertisement revenue intrinsic revenue is provided to all users through decentralized monetization protocol for videos creators and users.', '', '', 'X11', '2014-12-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ViaCoin', 'VIA', 'via.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://viacoin.org/', '@viacoin', 'Viacoin is a digital currency similar to Bitcoin that allows the creation of applications on top of the Viacoin blockchain in a similar way that email and web are built on top of the internet protocol. This allows the building of fully decentralized exchanges, issuing of new currencies, asset tracking, betting, digital voting, reputation management and even form the basis of fully decentralized market places. Our protocol for this will be called ClearingHouse.', '', '', 'Scrypt', '2015-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'VootCoin', 'VOOT', 'voot.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.vootcoin.net/', '@vootcoin', 'VootCoin is a hybid proof of work and proof of stake alternative crypto currency with a 10% annualised rate.', '', '', 'X11', '2014-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'VeriCoin', 'VRC', 'vrc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.vericoin.info/', '@VeriCoin', 'VRC is designed to reduce the PoW phase and enter PoS phase quickly. With a steady block reward and block time of sixty seconds, the PoW phase is designed to finish after the first few weeks of launch - 10/05/2014. The PoS interest rate is dynamic and depends on how much the coin is held and staked in the PoS. The dynamic interest rate is pegged at a sensible level of between 0-3% roughly. The PoS interest is gained through transaction fees which are also distributed to the Vericoin fund - to aid in development and promotion of the currency. There was no premine.', '', '', 'Scrypt', '2014-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'VertCoin', 'VTC', 'vtc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://vertcoin.org/', '@Vertcoin', 'VertCoin (VTC) is a cryptographic currency, similar to Bitcoin and Litecoin, with one major difference - Vertcoin believes that everyone who has personal computer should be able to join the Vertcoin network.\n\nVertCoin is a Litecoin Fork, that in turn is a Bitcoin Fork.\n\nVertcoin is also the first cryptocurrency to implement Stealth Addresses, a new technology for providing privacy on the public ledger.', '', '', 'Lyra2RE', '2014-08-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'WhiteCoin', 'WC', 'wc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.whitecoinfoundation.org/', '@WhiteCoiner', 'WhiteCoin is a scypt based altcoin that morphs from a PoW into a PoS mode after block 100. Block time is reasonable at 90 seconds and difficulty retargets every block.', '', '', 'Scrypt', '2016-05-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'WorldCoin', 'WDC', 'wdc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.worldcoinalliance.net/', '@worldcoin_dach', 'WorldCoin is designed to be the digital currency of the future. WorldCoin runs off the popular scrypt protocol which enables it to have stability for early adapters and users by operating from regular existing computer hardware. At the forefront is speed with transactions fully confirmed in about 60 seconds or less.', '', '', 'Scrypt', '2014-02-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SapienceCoin', 'XAI', 'xai.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoB/PoS', 'http://www.blockchainsingularity.com/', '@SapienceAIFX', 'Fractal Coin intends to distribute 90% of its 1 million coins in the initial 28 days of mining. The coin features a new difficulty adjustment mechanism known as slingshot - the aim of which is to increase the % of controlled hashrate required for a 51% attack to over 70%. The idea is that block rewards will be based solely on transaction fees. Otherwise the coin has a 6o second block time and has a 0.5% premine.', '', '', 'X11', '2015-07-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SocialXbotCoin', 'XBOT', 'xbot.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Xbot aims to be the crypto currency of social media - the coin is scrypt with proof of work turning onto proof of stake with an annualised 25% rate.', '', '', 'Scrypt', '2016-05-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'X11 Coin', 'XC', 'xc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.xc-official.com/', '@XCurrency', 'X11 or Xcurrency, is a solid x11 algorithm coin. Total coins sheduled to be produced in the PoW phase is 5.5million. The PoS has a 3.3% annualised inflation limit. Block time is 90 seconds and there was a premine of 100,000 XC. Another positive is the roadmap and dev team\'s dedication and experience. Future developments include increasing the UX experience, adding mobile anonymous wallets and payment cards - to drive through real world adoption.', '', '', 'X11', '2014-08-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Xcash', 'XCASH', 'xcash.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.xgenstudios.com/', '@xCashcoin', 'xCash is a unique and rare altcoin that offers stealth at all times. It not only hides where the xCash is going to, but also where it came from, making it impossible to trace transactions through the block chain. The coin is a scrypt altcoin with a proof of stake rate a 5% per annum.', '', '', 'Scrypt', '2014-01-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Crypti', 'XCR', 'xcr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://crypti.me/', '@CryptiTeam', 'Crypti is a node js built crypto currency.', '', '', 'Multiple', '2015-10-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'JouleCoin', 'XJO', 'xjo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.joulecoin.org/', '@JouleCoin', 'Joulecoin is crypto currency with quick confirmations and transaction comments. Exponential moving average based difficulty retargeting. The coin is a standard SHA-256 coin with a 45 second block time, a minimum reward of 0.001 XJO with reward halving every two years. The coin difficulty retargets every block and the transaction comment functionality is included.', '', '', 'SHA256', '2014-10-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LibertyCoin', 'XLB', 'xlb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://libertycoins.co/', '@CryptoLiberty', 'Liberty Coin uses its own X11 algorithm and is both proof of work and proof of stake. The POW coins are limited to 16.5 million and the Proof of stake has a 1% annual inflationary factor. Block time is 60 seconds.', '', '', 'X11', '2014-09-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PrimeCoin', 'XPM', 'xpm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://primecoin.io/', '@Primecoin', 'Primecoin, or XPM, involves a new type of proof-of-work based on searching for prime numbers. Primecoin was created by Sunny King - who also created Peercoin. The block time is one minute and th total number of coins is 3299976 with dynamic difficulty retargetting.', '', '', 'Multiple', '2013-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'StealthCoin', 'XST', 'xst.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://www.stealth-coin.com/', '@StealthCoin', 'StealthCoin combines proof of stake and ToR anonymity.', '', '', 'X13', '2014-08-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'XXXCoin', 'XXX', 'xxx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://xxxcoin.info/', '@xxxcoins', 'XXX Coin (XXX) is a scrypt PoW PoS hybrid alternative crypto currency. There is no block reward reduction and the total coin supply is capped at 50 million. The block target is 30 seconds and over 70% of the coin supply is given out in the first few days on top of a premine of 5%.\n\nCoin edited by [@chopcoin](http://chopcoin.io) Team', '', '', 'Scrypt', '2016-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'YAcCoin', 'YAC', 'yac.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.yaccoin.org/', '@YACCoin', 'YaCoin (YAC) was created in May 2013 - so not one of the later 2013 deluge of currencies. It was also the first coin to introduce the Scypt-n parameter. Reward is equal to 25 divided by the difficulty to the power of 1/6. The coin is a hybrid proof of work and proof of stake coin with a fixed transaction fee of 0.01 YAC per transaction. The coin is a dynamic inflationary/deflationary economic model - like peercoin - as the block rewards for POW mining are inversely proportional to the amount of computer power used. The Proof of stake is set at 5% per annum. The fixed transaction fee will act as a brake to supply depending on the velocity of it use - i.e. how much it is used - probably one of the most innovative economic models out there.', '', '', 'Scrypt', '2013-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZCC Coin', 'ZCC', 'zcc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.zccoin.org/', NULL, 'ZCCCoin (ZCC) is forked from YaCoin a hybrid scrypt PoW + PoS based crypto currency and scrypt-jane algorithm with improved parameters. The total number of coins is set to one billion and there are 520 confirmations needed for mining rewards to be distributed. The block reward is again linked to the the dificulty which is in turn related to the network power. So the more network power, the higher the difficulty, and the lower the block reward.', '', '', 'Scrypt', '2014-07-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZedCoins', 'ZED', 'zed.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@ZedCoins', 'ZedCoin is another spoof coin with the idea of Zombie apocalypse but with the commercial reasoning to make it the currency of choice in Zombie gaming. The coin has a short block time of one minute and difficulty retargetting every 30 blocks. The coin also supports transaction messages with a block payout halving until a 1 coin reward is reached.', '', '', 'Scrypt', '2015-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZiftrCoin', 'ZRC*', 'zrc_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.ziftrcoin.com/', '@ziftrCOIN', 'ziftrCOIN (ZRC) is a decentralised, open-source cryptocurrency forked from Bitcoin and launched in February 2015. It is developed by Ziftr, a US-based company that offers various e-commerce solutions, such as a browser add-on and mobile applications. The company\'s goal is to enable consumers to conduct simple, secure transactions, using ziftrCOINs (as well as several other cryptocurrencies), at their favorite retailers.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ByteCoin', 'BCN', 'bcn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://bytecoin.org/', '@bytecoin_dev', 'Bytecoin (BCN) is the first currency based on the CryptoNote technology and launched back in July, 2012. BCN protects your privacy with completely untraceable and anonymous transactions so it is deservedly called the next generation anonymous cryptocurrency.\n\nIt is a fully independent currency which has been developing separately from Bitcoin and its forks. The basis for the creation of Bytecoin was the CryptoNote unique technology.', '', '', 'CryptoNight', '2012-05-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Elektron', 'EKN', 'ekn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://www.elektronfoundation.com/', '@ElektronCoin', 'Elektron is a dentralised payments system based on the x13 algorithm - the coin mines 3 million in the proof of work phase where 2 million will be sold via an IPO - the proof of stake phase carries a 1.5% rate.', '', '', 'X13', '2014-10-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'XauCoin', 'XAU', 'xau.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://bitcointalk.org/', '@xau_coin', 'Xau is a crypto currency that mimics Bitcoin in every way apart from its supply base with only 2.1 million currency units of XAU.', '', '', 'SHA256', '2015-02-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TimesCoin', 'TMC', 'tmc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.btc38.com/', NULL, 'Era coins (TimesCoin, referred to TMC) is a BTC38.com introduced virtual computing unit, free of charge to all users.\n\nBTC38 decided to give out 50% of their transaction fee as a dividend to people holding TimesCoins. It\'s a different way of funding, you could see it as a shares sell, so they produced 16 million TMC and sold it to their users. Now each user that holds TMC gets a % of the trading fees applied by BTC38. For example is there are 20 BTC generated in one day in trading fees on their platform, 10 BTC are kept by the company and another 10 BTC get divided to the owners of TMC. At the moment there are 5 million TM in circulation so if you own 500.000, you would get 10% of 10 BTC, so you would get 1 BTC at the end of the day, assuming the trading fees for that day were 20 BTC.', '', '', '', '2013-12-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NEM', 'XEM', 'xem.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoI', 'http://www.nem.io/', '@NEMofficial', 'NEM is a peer-to-peer crypto platform. It is written in Java and JavaScript with 100% original source code. NEM has a stated goal of a wide distribution model and has introduced new features in blockchain technology in its proof-of-importance (POI) algorithm. NEM also features an integrated P2P secure and encrypted messaging system, multisignature accounts and an Eigentrust++ reputation system.\n\nNEM has gone through extensive open alpha testing starting June 25, 2014, followed by lengthy and comprehensive beta testing starting on October 20, 2014. NEM finally launched on May 31, 2015.', '', '', '', '2017-07-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BurstCoin', 'BURST', 'burst.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoC', 'http://burstcoin.info/', '@Burstcoin_dev', 'Burst uses a new algorithm for proof of hdd capacity (POC) mining. Miners pre-generate chunks of data known as \'plots\' which are then saved to disk. Taking NXT\'s great PoS code, and turning it into PoC. PoC takles the problem of unfair distribution, enables blockchain trimming, and allows anyone to mine without massive power bills or any special equipment', '', '', 'Shabal256', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NuBits', 'NBT', 'nbt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://nubits.com/', '@OfficialNuBits', 'NuBits (NBT) is a decentralised closed-source cryptocurrency launched in late 2014 by Peercoin developer Jordan Lee. Unlike most other cryptocurrencies, NuBit coins are not mined, but rather issued by the project\'s shareholders whose primary goal is to maintain a 1:1 NuBit peg to the US dollar. In the case of hyperinflation of the US dollar, the shareholders can vote to peg NuBits to a different currency or to a basket of commodities. By creating more coins to keep prices down and by increasing interest rates on parked coins to restrict supply, the NuBit projects hopes to have created a stable cryptocurrency with limited volatility.', '', '', 'SHA256', '2015-11-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'StorjCoin', 'SJCX', 'sjcx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://storj.io/', '@storjproject', 'Storj is a decentralized cloud storage platform based on Bitcoin\'s blockchain technology where anyone can sell their extra hard drive space.', '', '', 'Counterparty', '2015-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'StartCoin', 'START', 'start.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://startcoin.org/', '@start_coin', 'StartCoin (START) is a crypto currency that bases itself on a community project based idea in respect to crowd funding. The coin is Proof of Work and based on Scrypt. The total coin supply is capped at 84 million and the block reward halves each year. Difficulty retargets using the Kimoto Gravity Well.\n\nStartCOIN is a digital currency that rewards you for supporting change. The more you share and support projects or the more StartCOIN you hold, the more StartCOINs you will receive. By joining the startjoin community, you become part of this crowd funding revolution.\n\nStartCOIN is a reward based coin which rewards users for pledging, sharing and holding StartCOIN. It encourages change for good. Register on StartJOIN to be part of a crowdfunding community with a difference, one that harnesses the power of social media to create change.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BigCoin', 'HUGE', 'huge.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.hardforkcoin.org/', '@bigcoin_huge', 'HugeCoin or BigVoin has a block time of 30 seconds and is proof of work based.', '', '', 'Blake', '2015-07-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CounterParty', 'XCP', 'xcp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://counterparty.io/', '@CounterpartyXCP', 'Counterparty is not a traditional crypto currency and is more of a payment network - using bitcoin as the transport layer.\n\nCounterparty is a free and open platform that puts powerful financial tools in the hands of everyone with an Internet connection. By harnessing the power of the Bitcoin network, Counterparty creates a robust and secure marketplace directly on the Bitcoin blockchain, extending Bitcoin’s functionality from a peer-to-peer payment network into a full fledged peer-to-peer financial platform.\n\nIn addition to sending money without third-party intermediation you can trade, do business, and engage in advanced financial contracts without having to trust anyone else to hold your funds or do your accounting. Along with the Counterparty protocol, the platform consists of the native XCP token to perform advanced operations, and the secure, browser-based Counterwallet to provide the functionality.', '', '', '', '2014-02-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MaidSafe Coin', 'MAID', 'maid.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://maidsafe.net/', '@maidsafe', 'MaidSafe is a fully decentralized platform on which application developers can build decentralized applications. The network is made up by individual users who contribute storage, computing power and bandwidth to form a world-wide autonomous system.\n\nSafecoin can only reside within the SAFE network and will be stored in a users wallet and used in exchange for network services; such as increased storage space and access to network applications. There is no set distribution time for safecoins. Unlike many currencies, the distribution of safecoin is backed by information and the amount of coins generated by the SAFE network is directly related to the amount of resource provided to it.', 'The SAFE (Secure Access for Everyone) network can be best described as a fully distributed data management service. This network manages static and dynamic data as well as communications. Importantly the data held is either :\n\n\\- **Encrypted by clients**\n\n\\- **Cryptographically signed by clients**\n\nIn either case the network cannot decrypt any of the data on the network. This can be thought of as a decentralized server that performs the tasks of today\'s httpd, ssh, scp, ftp, smtp, pop3, imap etc. servers.\n\nThe SAFE network is made up of unused hard drive space, CPU and communications capabilities of commodity computers. These computers are likely owned by the very users of the system, but need not be limited to that. Each computer will effectively mine for credits which can be traded for many other goods and services. These credits are called safecoin.', 'Client applications can access, store, mutate and communicate on the network. The clients allow people to anonymously join the network and cannot prevent people joining. Data is presented to clients as virtual drives mounted on their machines, application data, internal to applications, communication data as well as dynamic data that is manipulated via client applications depending on the programming methods employed.\n\nExamples of client apps are; cloud storage, encrypted messaging, web sites, crypto wallets, document processing of any data provided by any program, distributed databases, research sharing of documents, research and ideas with IPR protection if required, document signing, contract signing, decentralized co-operative groups or companies, trading mechanisms and many others. The clients can access every Internet service known today and introduce many services currently not possible with a centralised architecture.\n\nThese clients, when accessing the network, will ensure that users never type another password to access any further services. The client contains many cryptographically secured key pairs and can use these automatically sign requests for session management or membership of any network service. Therefore, a website with membership can present a join button and merely clicking that would sign an authority and allow access in the future. Digital voting, aggregated news, knowledge transfer of even very secret information is now all possible, and this is just the beginning!', '', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '007 coin', '007', '007.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@007coin', '007 coin is a scypt based alternative crypto currency with difficulty retargetting each block - the proof of work phase will be replaced with a proof of stake phase with a rate of 2.5%.', '', '', 'Scrypt', '2015-09-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NuShares', 'NSR', 'nsr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://nubits.com/', '@OfficialNuBits', 'NuShares are units held by individuals who wish to help support and maintain the Nu network. Owning NuShares is not required to use NuBits. Instead, NuShares are intended to be a source of network equity for developers, entrepreneurs, and speculators. NuShareholders can receive network revenues in the form of [Peercoin](http://peercoin.net/) dividends paid out by a custodian.\n\nNuShareholders can cast votes for actions that positively affect the Nu network. These actions help adjust the supply and demand for NuBits so that they will always remain at a long-term $1.00 US value.', '', '', '', '2016-04-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MonaCoin', 'MONA', 'mona.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://monacoin.org/', NULL, 'Monacoin is a peer-to-peer payment network and digital currency based on an open source protocol.\n\n\\- scrypt\n\n\\- 1.5 minute block targets\n\n\\- subsidy halves in 1051k blocks (~3 years)\n\n\\- 105,120,000 total coins\n\n\\- 50 coins per block\n\n\\- DigiShield difficulty algorithm', '', '', 'Scrypt', '2014-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SolarFarm', 'CELL', 'cell.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://asset.cryptomining.farm/', '@miningfarm', 'Long-term investment project under Cryptomining Farm is suitable for investors who want to earn a long-term and stable without the impact of price fluctuated violently of Cryptocurrencies. The revenue on the first 1st –3rd years is earned from using the generated electricity to bitcoin and burstcoin mining, and purchasing of cheap electricity during off-peak for using to reduce the maintenance fee. And the revenue on during 4th -25th year is earned from the sale of electricity to the Electricity Generating Authority (EGA) which has a long-term contract with fixed price, or if bitcoin and burstcoin mining have better profits, it will also be continued to dig', '', '', '', '2015-02-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TekCoin', 'TEK', 'tek.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://tekcoin.org/', '@TEKcoins', 'Tekcoin is an advanced cryptocurrency. Using the latest coding changes and features. Tekcoin supports transaction comments. Tekcoin is a proof of stake coin making it very resistant to 51% attacks. Tekcoin has implemented the latest code fixes for stake rounding. Tekcoin is Sha256 making it very efficient in terms of watts need to support the network. Tekcoin uses an advanced difficulty adjustment algorithm to prevent network stranding.', '', '', 'SHA256', '2013-07-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Positron', 'TRON', 'tron.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Tron or Positron is a crypto currency with a dynamically adjusted proof of stake level.', '', '', 'SHA256', '2015-11-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitBay', 'BAY', 'bay.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://bitbaymarket.net/', '@BitBayMarket', 'BitBay is a Proof of Stake cryptocurrency with a 1% APY in staking rewards. BitBay provides many additional tools like smart-contract capabilities, an in-wallet decentralized e-commerce platform, \"Pay-to-Email\" transactions, asset pegging and more.', '', '', '', '2014-07-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Neutron', 'NTRN', 'ntrn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.neutroncoin.com/', '@Neutron_Crypto', 'Neutron is an SHA-256d crypto currency with a 79 second block time target and a 5 hour proof of stake maturity with a varying interest reward.', '', '', 'SHA256', '2016-07-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Sling Coin', 'SLING', 'sling.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://bitcointalk.org/', NULL, 'Sling coin is a new crypto currency that is in the process of development.', '', '', 'SHA256', '2016-08-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Vcash', 'XVC', 'xvc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://v.cash/', NULL, 'Vcash, previously called Vanilla Coin (VNL), is a decentralized currency for the internet. It enables you to send money to anywhere in the world instantly for almost no cost.\n\nVcash was engineered to be **innovative** and **forward-thinking**. It prevents **eavesdropping** and **censorship**, promotes **decentralized**, **energy efficient** and **instant** network transactions.\n\n**Secure and Private** - An encrypted 3-tier network utilising widely deployed standards based algorithms.\n\n**Instant** - Payments are recieved instantly by the recipient thanks to ZeroTime.\n\n**Peer to Peer** - Using a decentralised network there is no 3rd party to trust.\n\n**Global** - Transactions have no borders.\n\n**Low Fees** - Lower than banks or credit cards.\n\n**Open and Free** - Open source code allows anyone to contribute.\n\nYou can read the full whitepaper here: <https://v.cash/papers/vanillacoin.pdf>\n\nBlock explorer data from <https://explorer.v.cash/>', 'Vcash is not a descendant of Bitcoin. While it shares the same basic network and cryptographic principles it\'s code is written using a backwards compatible but modern approach using C++11. The Vcash development team has decades of experience designing and deploying large scale autonomous peer-to-peer systems.', 'Vcash has invented many breakthrough technologies such as ZeroTime to provide sub-second (safely confirmed) transactions, Node Incentives to ensure the network remains robust and ChainBlender to provide ahead of time transaction anonymity. Currently we are exploring the area of Self Governance.', 'Whirlpool', '2017-06-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CraveCoin', 'CRAVE', 'crave.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.cravecoin.info/', '@CRAVECoin', 'Crave is a cutting edge Proof Of Stake Cryptocurrency based on Blackcoin POS2.0. Crave includes the latest technology including recent Bitcoin Core advancements such as BIP32 HD Wallet addresses, dual key stealth addresses, once-only transaction broadcasting , address index, and an advanced and friendly user interface.', '', '', 'Scrypt', '2016-08-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BlockNet', 'BLOCK', 'block.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://blocknet.co/', '@The_Blocknet', 'The Blocknet is founded on the XBridge, the first peer-to-peer protocol enabling communication between nodes on different blockchains. It is open source and is implemented in every Blocknet-enabled app. It is what connects an open-ended array of services – either decentralized or centralized – to one another.', '', '', '', '2015-08-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Stability Shares', 'XSI', 'xsi.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'StabilitySharesXSI (XSI) is a scrypt hybrid of both Proof of Work and Proof of Stake. The minimum transaction fee is 0.0001XSI and is redistributed to miners - the backbone of the network. The difficulty retargets every block on a block time of 90 seconds and the block reward varies in a hyperbolic curve manner. The PoW phase comes to an end after 14 days with a total number of coins at 7.5 million XSI. The total number of coins after 30 years will be 15 million XSI and the annual PoS rate is set to 3%.', '', '', 'Scrypt', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Giga Hash', 'GHS', 'ghs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://cex.io/', '@cex_io', 'GHS is the ticker for trading Giga hashes of mining power for Bitcoin on CEX.io for either Bitcoin Litecoin or USD. An up to date index of what mining contracts should be priced at.', '', '', '', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ByteCent', 'BYC', 'byc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://bytecent.com/', '@Bytecent_BYC', 'There have been hundreds of digital currencies that have launched worldwide, and more than ninety-eight percent of the digital currencies launched have failed for one reason or another. The Bytecent project was conceived to bring sanity back to an industry that has drifted away from the core principles set forth with the original Bitcoin project.\n\nBytecent is not just another digital currency in a sea of many; it is a philosophy born out of necessity. The goal of this project is to reinvent digital currencies from the manner that wallets are distributed and installed, to the method that coins are earned and spent. Bytecent is the first user-friendly digital currency designed from the ground up to be as easy as sending an email. If you can point and click a mouse, you can use Bytecent.\n\nBytecent is the first user-friendly digital currency designed from the ground up to be as easy as sending an email. If you can point and click a mouse, you can use Bytecent. Unlike with other digital currencies, Bytecent does not require any special hardware or configurations to mine. Simply download the software, install it, and begin mining today! \"Mining\" is lingo for discovering new Bytecent, similar to panning for gold. In actuality, mining is simply the process used to verify Bytecent transactions on the network.There are approximately 1440 coins generated per day, so finding new Bytecent can take a few hours or a few days depending on the speed of your computer. Mining Bytecent is fun and allows anyone with no mining experience or technical knowhow to begin mining immediately! Similar to conventional currencies, Bytecent is a currency that can be used to buy goods and services. You can offer your goods or services in return for payment in Bytecent.', '**No Personal Information Required** Unlike with credit cards and other forms of electronic payments, Bytecent does not require you to input personal information. Risk of privacy intrusion and ID theft is completely eliminated with Bytecent. Furthermore, compared to bank transactions, all you need to complete a transaction is the free Bytecent wallet and a unique Bytecent address.\n\n**No Credit Checks** Bytecent eliminates the need for credit checks and lengthy credit applications. Whether the end-user has excellent credit, bad credit or no credit, anyone can use Bytecent. You will never be denied or restricted from using Bytecent.\n\nI**mmediate Transactions** Money transfer services and bank wire transfers can be costly, and transaction times can vary from a few minutes to a few days. Bytecent solves this problem by allowing anyone to send funds quickly to any person worldwide, without the hassle of dealing with banks or money transfer services. The average Bytecent transaction is completed within 60 seconds or less!\n\n**No Transaction Limitations** Whether you are sending 1 Bytecent or 100000 Bytecent, the amount you are sending does not matter. There are no limitations on the amount of Bytecent you can send at one time, nor are there any daily or monthly transaction limits. You have the freedom to conduct as many transactions as you desire.\n\n**Unauthorized Transaction Prevention** With Bytecent, you do not need to be concerned with criminals gaining access to your Bytecent address, and going on a shopping spree at your expense. The \"sender\" initiates all transactions, and transactions cannot be performed remotely by a 3rd party. Someone will need to gain access to your computer or mobile device to access your Bytecent, and even then it will be virtually impossible if you password protect your wallet.', '**Proof of Bytecent** is an innovative earning system that employs captcha technology to limit network abuses while keeping the earning process tangible. POB requires workers to enter a human readable captcha code every sixty minutes to maintain the earning process without interruption. POB time can be extended without entering the captcha code by storing x amount of coins in the local wallet. For example, If 25 Bytecent are required to extend POB time for one hour, a worker will need a total of 575 Bytecent stored in his/her local wallet to extend POB time for a total of 24 hours. Bytecent utilized for POB can be used anytime and are not locked from being spent like with Proof of Stake coins. The number of coins required to extend POB time is based on numerous factors including current price, total volume, and demand.\n\n1.POB renders botnets ineffective, while dramatically reducing the effectiveness of mining farms.\n\n2.POB generates demand for Bytecent while keeping the available Bytecent in circulation low.\n\n3.Workers are rewarded by storing more Bytecent in their local wallets.\n\n4.Sell pressure from workers and merchant dumping is significantly reduced.\n\n5.Fewer Bytecent are stored on exchanges and other centralized platforms.', '', '2014-01-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GridCoin', 'GRC', 'grc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DPoR', 'http://www.gridcoin.us/', '@GridcoinNetwork', 'GridCoin (GRC) is a coin with a mission - to compensate miners for participating in BOINC projects. The coin is a scrypt altcoin with difficulty retargetting every 30 minutes - a 2.5 minute block target and a hard cap of 168 million.\n\nGridcoin introduces a Proof-of-Research algorithm that gives computers something productive to do. Instead of racing to solve meaningless equations, Gridcoin miners Researchers work on problems such as finding cures to diseases, mapping genomes, or climate studies, and are compensated for their work. Gridcoin is not limited to any one program, algorithm, or type of hardware. BOINC supports Windows, Mac OS X, Linux, and Android.', '', '', 'Scrypt', '2013-03-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Gemz Social', 'GEMZ', 'gemz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://getgems.org/', '@getgemsorg', '100 million Gems is the total currency supply in the GENESIS BLOCK. Eventual supply is achieved as follows: 50 million Gems distributed to stakeholders; 30 million Gems distributed as daily Airdrop rewards during ~3 years after launch; 12 million Gems reserved for bonus block rewards, promotion, marketing, bounties; 8 million Gems + Presale BTC will fund the network R&D and operation costs.\n\nThe Gems currency is powered by Counterparty. Every GetGems user automatically gets his own wallet, protected by the passphrase chosen on registration. The social network username is an alias to the GetGems address, making sending & receiving Gems and bitcoins between users as easy as possible.', '', '', '', '2016-02-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'KryptCoin', 'KTK', 'ktk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://kryptkoin.com/', '@KryptKoin', 'KryptKoin (KTK) is a scrypt based PoW PoS hybird altcoin with an initial distribution of 17 million coins. The transaction fee is 0.01 KTK, block time is 30 seconds and the PoS rate is 7% annually.', '', '', 'Scrypt', '2015-09-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Horizon', 'HZ', 'hz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://horizonplatform.io/', '@Horizon_HZ', 'Horizon is a decentralized platform that functions as a digital currency, asset exchange, and other features. Horizon is part of Block net and based on Nextcoin.', '', '', '', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FairCoin', 'FAIR', 'fair.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://fair-coin.org/', '@FairCoinTeam', 'FairCoin is a decentralised virtual currency, distributed through a vast airdrop process during the 6th and 8th of March, 2014 . An approximate 49,750 addresses were logged for the giveaway, each able to claim 1000 FAIR per hour. Automated airdrop claiming methods had no effect, as each IP address could register once per hour, and 2 different captchas had to be solved. These security precautions were hidden till the day of distribution. FairCoin\'s vast distribution method allowed a good portion of the cryptocurrency community to claim a little bit of the 50,000,000 FairCoins, each.', '', '', 'Groestl', '2014-06-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'QoraCoin', 'QORA', 'qora.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.qora.org/', '@qoracoin', 'New 2nd generation cryptocurrency designed from the ground up to solve Bitcoin\'s biggest problems • Built from scratch and will not rely on any other cryptocurrency • Uses a new proof of stake algorithm making it future-proof • Developed in Java and relies on native C libraries to perform the most CPU intensive tasks • Relied on IPO for initial distribution of the supply. The total amount of Qora in existence is 10\'000\'000\'000 (10 billion)', '', '', '', '2015-07-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Gulden', 'NLG', 'nlg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://guldencoin.com/', '@guldencoin', 'Gulden (NLG) is another national currency for the Netherlands. The premine is 10% with 1% to be used for bounties and not distributed. The total number of coins to be mined is 1.68 billion and the block time is set to 150 seconds. The difficulty retargetting occurs every 576 blocks using the Kimoto Gravity well. The coin is scrypt and pure Proof of Work.', '', '', 'Scrypt', '2014-02-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RubyCoin', 'RBY', 'rby.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.rubycoin.org/', '@RubyCoinOrg', 'RubyCoin is another precious gemstone coin - like Emerald or Diamond (EMD - DMD). The coin is a scrypt algorithm based currency with an average block time of 90 seconds and difficulty retargetting every block. The maximum supply is limited to 60 million, and the block reward halves each month for the first five months from 500 RBY to 50 RBY. There was a premine of 2% for bounties etc..', '', '', 'Scrypt', '2015-12-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PesetaCoin', 'PTC', 'ptc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://pesetacoin.info/', '@oPesetaCoin', 'PesetaCoin is a scrypt altcoin like Litecoin. The block time is one minute and the diffiuclty retargets using the Kimoto Gravity Well. The starting block reward is 166 PTC and halves every year. The coin is merged mineable and has a negligable premine of 0.016%.', '', '', 'Scrypt', '2014-07-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Kore', 'KORE', 'kore.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://korecoin.net/', '@NewKoreCoin', 'Kore (KORE) is an x13 algorithm alternative crypto currency. The block time is 60 seconds - the PoS rate is 8% and the PoW phase lasts 7 days. There was a premine of 0.83%.', '', '', 'X13', '2015-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Wild Beast Coin', 'WBB', 'wbb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.wildbeastbitcoin.com/', '@WildBeastBTC', 'Wild Beast Bitcoin (WBB) is a pure scypt proof of work altcoin released in February 2015. The coin supply is limited to just over 2.5 million WBB currency units.', '', '', 'Scrypt', '2015-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Sonic Screw Driver Coin', 'SSD', 'ssd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.sonic-coin.com/', '@SonicScrewDev', 'Sonic Coin (SSD) has built in ToR transport and anonymous transactions. otherwise the coin is a hybrid proof of work and proof of stake coin. The proof of stake is now active with a 20% annualised rate for minting new coins.', '', '', 'SHA256', '2014-09-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TileCoin', 'XTC', 'xtc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://www.tilepay.org/', '@tilecoinx', 'TileCoin / Tilepay is a crypto-token which enables access to a Decentralized Bill Payments/Investment Application (ĐApp).\n\nTileCoin`s mission is to revolutionize the Internet of Things by easily enabling monetization between people, sensors, and data utilizing micropayment channels via block chain technology.\n\nThe online web marketplace for MAKERS (IoT Owners) and BUYERS (people, corporations, manufacturers, etc.) conduct all transactions with bitcoin and/or multiple currencies. Bitcoin is a cryptocurrency used around the globe as a means of eliminating the need for currency conversions and allowing for many very small transactions (also referred to as “micropayments”).\n\nCurrently, there is a trend towards decentralized payments using bitcoin, that can help reduce costs associated to transferring a store of value, acquiring assets and increasing monetization of physical assets from Internet of Things (IoT) devices and/or sensors.\n\nTileCoin / Tilepay is a free decentralized application that is downloaded to your personal computer, laptop or mobile phone.\n\nEach IoT device and/or associated sensor is an asset that is created by our decentralized application. Every device has a unique token that can accept payment for data via a marketplace.', '', '', '', '2016-05-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Dnotes', 'NOTE', 'note.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://dnotescoin.com/', '@DNotesCoin', 'Dnotes is a scrypt based Proof of Work algorithm cryptocurrency.', 'You can participate in the mining network and mine DNotes for free. A Block Reward starting at 250 Coins are paid until all the coins have been mined. Additionally, a bonus of 750 coins are awarded to miners during the first thirty days covering blocks 250 to 33,250.\n\nHelp them promote their new crypto-currency and earn your share of DNotes. They need mining pools, bloggers, social media promoters, and crypto forum users. In the beginning, there will be huge giveaways and bounties. Contact them at contact@dnotescoin.com if you would like to get involved.\n\nYou may also trade for DNotes on an exchange that accepts DNotes as they become available.', 'DNotes is a shared stake concept, placing a large percentage of the coins in the hands of many, increasing personal stake and personal interest in the coin in promoting the long term value of the currency.\n\nA rapid acceptance by a very large number of individuals and groups generating the most liquidity and high transactional value is their goal.To ensure the best future for DNotes, their development team will remain focused, swift and agile in the relentless pursuit of technology changes and bring you the best as they become available.\n\nThe development team is currently working on mobile application integration and development.', 'Scrypt', '2015-04-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GridPay', 'GRID*', 'grid_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.gridpay.net/', '@GridPayTeam', 'GridPay is a decentralized crypto-currency that enables lighting fast transactions directly between individuals, merchants, companies and financial institutions. GridPay users save money by eliminating middleman fees, in addition to earning 3% annual interest.', '', '', '', '2015-04-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FlorinCoin', 'FLO', 'flo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://florincoin.org/', '@Official_Florin', 'Florincoin (FLO) is a scrypt based coin with quick transaction processing. It also introduces a useful new feature - transaction comments. Block time is low at 40 seconds. The reward halves from a start of 100 FLO each year, and difficulty retargets every block. There was no premine.', '', '', 'Scrypt', '2014-05-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MaieutiCoin', 'MMXIV', 'mmxiv.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@PurePoS', 'Maieuti Coin (MMXIV) is a coin with a whopping 2016% annualised proof of stake rate.', '', '', 'SHA256', '2015-12-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '8BIT Coin', '8BIT', '8bit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.8bitcoin.org/', NULL, '8BIT Coin is a proof of stake and proof of work hybrid with the proof of work phase halting after block 1888. The coin then operates through proof of stake with an 8% annualised rate.', '', '', 'Scrypt', '2016-05-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Sativa Coin', 'STV', 'stv.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://bitcointalk.org/', '@sativacoins', 'Sativa Coin is a proof of work and proof of stake hybrid alternative crypto currency with a coin total of 10 million and an annualised interest rate of 5%.', '', '', 'X13', '2015-09-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EbolaShare', 'EBS', 'ebs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://ebolashare.github.io/', NULL, 'EbolaShare is a proof of stake coin trying to encourage donations to the Ebola outbreak in West Africa.', '', '', '', '2014-09-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AeroMe', 'AM', 'am.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.aerome.org/', '@aerocoin', 'Aero was created 22-June-2014. By the developer, Majika.The main goal with Aero was to create the decentralized marketplace exchange, AeroME. On 11-Jan-2015 Aero completed a coinswap from Aero to AeroME.\n\nBecause Aero was not optimal for the platform, Majika created a new coin that was. After half a year of work, the AeroME platform was announced to be released in February.', '', '', 'X13', '2016-02-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Coin Magi', 'XMG', 'xmg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoM/PoSII', 'http://coinmagi.org/', '@CoinMagi', 'Coin Magi (XMG) is an online payment system, enabling instant payments to anyone in the world without needing an intermediary.\n\nWith Coin Magi, anyone in the world can issue digital coins through their personal computers and a software-based minting process. Coin Magi removes the competitive nature of minting and offers an even playing field for anyone looking to issue currencies without expensive equipment. Coin Magi distinguishes itself from other counter parties by its fairness, cost effective and energy efficiency in maintaining the operation of the system.', '', '', 'M7M', '2014-12-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AmberCoin', 'AMBER', 'amber.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://amber-coin.webnode.com/', '@AmberCoin', 'AMBER Coin - a PoW/POS hybrid coin has been launched by Ninja launch on Aug 17. PoW X11 distribution.', '', '', 'X11', '2015-05-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'JackPotCoin', 'JPC', 'jpc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://jackpotcoin.info/', '@JackpotCoin', 'JackpotCoin (JPC) is a coin thats premiss is superblocks that will on average appear every three and a half days - the payout grows from 10x to 100x at day 3.5 - and from day 3.5 to day 7 the block reward will increase 1000x. After this point the block reward probability will be increased if there has been no triggering. The block payout is reduced by 10% each week and the minimum payout will 1 coin per block - reached after just over two years. The block time is set to 120 seconds per block and the difficulty retargets per block. The Jackpot hashing algorithm is based on the SHA-3 algorithm. There was a 1% premine.', '', '', 'SHA3', '2016-01-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NakomotoDark', 'NKT', 'nkt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://nakamotodark.com/', '@nakamotodark', 'NakomotoDark (NKT) is an X11 proof of work and proof of stake hybrid alternative crypto currency.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'JoinCoin', 'J', 'j.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@Joincoin_Team', 'Joincoin is the result of a team of developers, crypto currency miners, and day traders who were tired of having to jump from coin to coin in order to find the most energy efficient or \"hot trend\" algorithm available.', '', '', 'Multiple', '2015-01-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GhostCoin', 'GHC', 'ghc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@ghostcoin1', 'GhostCoin is a Scrypt Altcoin based on both Proof of Work and Proof of Stake. The coin cap is set to 750 million and the block time is 30 seconds. The PoS rate reduces from 20% in year 1 to 5% in year six. There was a premine of 1%.', '', '', 'Scrypt', '2014-10-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DayTrader Coin', 'DTC*', 'dtc_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'DTC or Day TRader Coin is an X13 proof of work and proof of stake alternative crypto currency to Bitcoin with an annualised interest rate of 20%.', '', '', 'X13', '2015-07-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ArtByte', 'ABY', 'aby.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.applebyte.me/', '@AppleByteMe', 'Artists can receive and spend (cash in) ArtByte , just as you would cash-in airline mileage points or credit card bonus points. This provides real financial support for their careers. Additionally artists gain increased exposure (at no cost) on ArtByte’s social media and forum.', '', '', 'Scrypt', '2014-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LiteDoge', 'LDOGE', 'ldoge.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.litedoge.org/', '@LiteDoge', 'LiteDoge is a fork of Dogecoin. The coin has a block time of 64 seconds and is based on scrypt. The proof of stake rate depends on the block height.', '', '', 'Scrypt', '2015-11-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MasterTraderCoin', 'MTR', 'mtr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://mastertradercoin.com/', '@MTRDevelopers', 'A scarce peer-to-peer digital currency that enables traders to receive instant payments for providing accurate depictions of trading fundamentals and strategy.', '', '', 'X11', '2016-01-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Triangles Coin', 'TRI', 'tri.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://info.triangles.technology/', NULL, 'Triangle is a PoW/PoS hybrid with a 33% annualised rate. The coin fell into bad repute at the end of 2014 but was ultimately picked up bu community memebrs on bitcointalk and relaunched.', '', '', 'X13', '2014-11-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SwarmCoin', 'SWARM', 'swarm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://swarmcorp.com/', '@SwarmCorp', 'Every time a project is created through Swarm, a part of that project is automatically given to all Swarm members. This allows all Swarm members to participate in the distributed abundance made possible by the Swarm.', '', '', '', '2015-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Boolberry', 'BBR', 'bbr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://boolberry.com/', '@BoolberryBBR', 'Boolberry is a wild Keccak algorithm PoW crypto coin. The block interval, or target, is set to 120 seconds. The total number of coins is limited to approximately 18.5 million and the block reward reduces in a variable manner with shortening time spans between reductions.', '', '', 'X11', '2015-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitCrystal', 'BTCRY', 'btcry.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'There is no real information on this crypto currency.', '', '', '', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitCredit', 'BCR', 'bcr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://bitcredit.wikia.com/', '@yvg1900', 'Bitcredit is the first full attempt at crypto currency based financial services. This will include Banking, Credit , Insurance and possibly Investment management.', '', '', 'Momentum', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Pebble Coin', 'XPB', 'xpb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Pebblecoin (XPB) is a cryptonote based coin with improvements and changes in some areas, and the promise of development in others.', '', '', 'CryptoNight', '2015-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Dirac Coin', 'XDQ', 'xdq.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@BryceWeiner', 'Dirac Coin (XDQ) is planned to be traded in conjunction with Nautilus coin - which introduced the concept of free-market managed economic stability. Dirac is a Blake-256 algorithm based coin with a block target of 180 seconds and difficulty retargetting every 2016 blocks. The coin cap is limited to 2.272 million coins and the block reward reduces in various steps to 0.01 XDQ from an initial 8XDQ.', '', '', 'Blake', '2015-07-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Folding Coin', 'FLDC', 'fldc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://foldingcoin.net/', '@FoldingCoin', 'FoldingCoin (FLDC) helps battle diseases like cancer and Alzheimer by contributing to the Stanford\'s Folding@Home network.\n\nFLDC is a coin that rewards volunteers for contributing to this initiative. FoldingCoin is distributed on a daily basis, based on the individual contributions. This new currency can be transferred from person to person using the Bitcoin blockchain and the Counterparty protocol.', '', '', 'Stanford Folding', '2015-01-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SolarCoin', 'SLR', 'slr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://solarcoin.org/', '@SolarCoin_SLR', 'SolarCoin (SOLAR) is a coin to increase the adoption and reward photovoltaic power production. The coin is a scrypt Proof of Work crypto currency with a block time of 60 seconds. The initial 100 block reward halves every year and the difficulty adjusts every 1440 blocks. There is 140 character transaction messaging.', '', '', 'Scrypt', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Social Media Coin', 'SMAC', 'smac.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.smac.io/', '@SMACteam', 'SMAC is designed to be cryptocurrency’s first large-scale attempt in the social media advertisement industry. With the standard fast confirmation times and a development team with a clear roadmap focused on maintaining value, as well as real world adoption. SMAC is uniquely suited to act as a transmitter of payments between one-account owner to an account buyer, providing the entry point for crypto into this industry with efforts to break away from the hassles faced by large movers currently using PayPal; such as account holds, and chargebacks.   \n SMAC, aims to tap into the world’s multi-million dollar social media advertising industry, giving its holders a way to easily become a part of this newly founded lucrative industry and profit from the rewards.', '', '', 'X11', '2015-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TruckCoin', 'TRK', 'trk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://truckcoin.net/', '@truckcoin_v2', 'Truck Coin is a Proof or Work and a Proof of Stake crypto currency with a very high PoS rate at 200% The block time is 90 seconds and the team are looking to develop an android wallet in the near future.', '', '', 'X11', '2016-05-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ucoin', 'U', 'u.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://ucoin.name/', '@ucointeam', 'UCoin is a Proof of Work/Proof of Stake cryptocurrency using the x11 algorithm. it has a 20M supply and a 1 minute block time. The U stands for \"Usable\". Ucoin is a usable and user-friendly digital currency. This coin has been created not only for \"geeks\" and advanced users, but also for ordinary users. UCoin is usable and userfriendly digital currency. This coin has been created not only for \"geeks\", for advanced use, but even for ordinary users.', '', '', 'X11', '2017-01-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Unitus', 'UIS', 'uis.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@UnitusCoin', 'Unitus allows users to mine via the algorithm of their choice. The website however has not been working for some time.', '', '', 'Multiple', '2015-09-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CypherPunkCoin', 'CYP', 'cyp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.cypher.pw/', '@CypherCoin2015', 'A cypherpunk is any activist advocating widespread use of strong cryptography as a route to social and political change. Originally communicating through the Cypherpunks electronic mailing list, informal groups aimed to achieve privacy and security through proactive use of cryptography. Cypherpunks have been engaged in an active movement since the late 1980s. Cyberpunk is a subgenre of science fiction in a future setting, noted for its focus on \"high tech and low life\". It features advanced science, such as information technology and cybernetics, coupled with a degree of breakdown or radical change in the social order.', '', '', 'QuBit', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'UFO Coin', 'UFO', 'ufo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://ufocoin.net/', '@UFOCoins', 'UFO Coin or \"Uniform Fiscal Object\" is a PoW cryptocurrency based on the Neoscrypt algorithm.', '', '', 'NeoScrypt', '2014-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ascension Coin', 'ASN', 'asn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Dev_Ascension', 'Ascension Coin (ASC) is a proof of work and proof of stake hybrid with an annualised rate of 20%.', '', '', 'QuBit', '2015-07-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OrangeCoin', 'OC', 'oc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Orangecoins', 'Orangecoin (OC) is a scrypt altcoin that joins both Proof of Work and Proof of Stake to secure the network. The PoW phase is scheduled to produce 25% of the total number of 200 million coins and will last two weeks. The PoS phase has an interest rate of 20% in Y1, 10% Y2, 5% Y3 and then a constant 2.5%. There was a premine of 5% for bounties etc.', '', '', 'Scrypt', '2015-11-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GSM Coin', 'GSM', 'gsm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://gsmcoin.info/', '@gsmcoin', 'GSM coin is a phone unlocking service based on an X11 crypto currency that is both proof of stake and proof of work. The proof of stake rate is set to an annual 10%.', '', '', 'X11', '2016-10-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FriendshipCoin', 'FSC2', 'fsc2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://friendshipcoins.com/', '@Friendshipcoin', 'FriendshipCoin is a proof of work alternative crypto currency based on Proof of Work or PoW. The total number of coins is just over 37 billion and the difficulty retargets every hour on a block time of 2.5 mins.', '', '', 'Scrypt', '2015-07-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NXTTY', 'NXTTY', 'nxtty.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://nxtty.com/', '@cryptomessenger', 'Nxtty is free to download plus messaging and calls are free for everyone. All messages are encrypted from app to app, so your messages are safe and secure. A free privacy focussed crypto run forum or whatsapp.', '', '', '', '2014-12-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'QuBuck Coin', 'QBK', 'qbk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS/PoB', NULL, '@QibuckCoin', 'Every Bagholder of 100 or more QIBUCKS will be sharing in the revenue created by all the ventures invested in from the offset and from referral commissions and sales from various sites and activities. Essentially a form of fund but with no recourse to financial authorities. There website has at present been hacked.', '', '', 'X13', '2014-10-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BlakeCoin', 'BLC', 'blc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://blakecoin.org/', '@BlakeCoin', 'BlakeCoin is based on the Blake-256 algorithm. The coin is merge mined and has a block reward, that varies based on the difficulty (25 coins + inflation(square root(difficulty \\* block height). The block time is 3 minutes and the block retargetting occurs every twenty successful hashing attempts. There are a total of 7 billion coins to be mined.', '', '', 'Blake', '2013-07-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MaryJane Coin', 'MARYJ', 'maryj.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://www.facebook.com/', NULL, 'MARYJ is an alternative Crypto Currency for the Cannabis Industry', '', '', 'X15', '2015-11-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OmniCron', 'OMC', 'omc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://delta.investments/', '@gladimorcrypto', 'Omicron (OMC) is a digital blockchain-based asset that accrues interest through two mechanisms: minting and BTC dividends. It is the first step towards having an unbanked investment world where an independent digital currency asset yields returns in an alternate medium of exchange. OMC plans to be a major inflation and investment vehicle for the cryptocurrency community as well as various brick-and-mortar entities.\n\n**Taking the first step towards an unbanked society**  \n  \nThe core principle of Omicron\'s investment platform is to allow investors to own a digital asset that adds value to itself- just like shares in a dividend-issuing company. Easily transferable for a quick turnover without the need of intermediary brokers, the OMC asset will be the choice dividend vehicle for investors around the globe. Biweekly dividends ensure that no matter the price of the asset, the asset owner always will receive a 0.00001% share of the dividend pool, per Omicron, every 2 weeks.  \n  \n  \n**How are BTC dividend-yields accrued and issued?**  \n  \nBTC dividends will be funded every 2 weeks through trading on the volatile altcoin market as well as lending capital for margin-trading exchanges (stable interest). The loan interest guarantees a biweekly issuance of dividends, while the altcoin trading revenue is a major bonus, many times greater than loan yields. The trading yields aren\'t guaranteed biweekly as there may be an occurrence where there is a net loss during the timeframe. A minimum balance of 10,000 OMC in an address will be required to qualify for dividend yields. A BTC address must be associated with the OMC address, which will be done through the main website, and soon through the Omicron client itself.', '**Transparency and Solvency**  \n  \nTrust is a major issue in the unregulated industry that cryptocurrency is. The Omicron investment platform will prove solvency biweekly, by revealing copies of trading summaries, balance statements, and further evidence that OMC is solvent and paying from revenue, not from capital. Independent audits by high profile members of the Bitcoin community will be allowed every 2-3 months to make sure that data provided biweekly is accurate and not forged or modified in any way.  \n  \n  \n**Quick turnover and a market**  \n  \nOmicron will be the first dividend-issuing asset that will be able to be traded on popular cryptocurrency exchanges. The quick turn over on exchanges will make OMC a superior investment vehicle than any existing dividend-issuing company today. Issuing dividends at a faster rate than most businesses, the market will be fast paced and a choice asset to trade as daytraders make their moves on dividend performance. As OMC adds value to itself through continuous dividend payouts, long term holders of the asset will experience a steady increase to the value of their investment as well as pocketing biweekly revenue.', 'Omicron will be a blockchain based asset, and a clone of Bitcoin. Minting through the wallet will yield 5%/annum, compounding on a daily basis. The clients that will be released on Sept 17 will have a fresh overhaul to the interface, and there will be future modifications to add simplicity to OMC-BTC address linkage and addtional add-ons. Fullstack developers will be paid and employed to implement said features. The main focus of Omicron is to provide a suitable and superior investment vehicle than dividend-issuing companies. With this in mind, there will be no brand new technical developments made for OMC. Modifications will be ported from other cryptocurrency clients to keep OMC top of the line.', 'Scrypt', '2016-05-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GigCoin', 'GIG', 'gig.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://gigcoin.com/', '@GigaGridCoin', 'GigCoin was created by Julie Diaz-Asper and Ana Roca Castro – two mom entrepreneurs with a lot of experience hiring folks for gigs with big brands: community managers, survey participants, blog post contributors, designers, and SEO experts.', '', '', 'X11', '2014-07-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CyberCoin', 'CC', 'cc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Cybercoin is a project run by two developers - the coin is based on srypt and works with proof of stake. There is not much information regarding this crypto currency.', '', '', 'Scrypt', '2017-07-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitstarCoin', 'BITS', 'bits.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://bitstarcoin.com/', '@Bitstar_coinz', 'BitstarCoin is a Scrypt PoW/PoS hybrid. The PoW phase lasts for 21 days and then the PoS staking begins at 35% for Y1 - dropping to 1% in yr 5. The difficulty retargets every block and the block time is set to 30 seconds allowing for a two minute transaction confirmation.', '', '', 'Scrypt', '2015-05-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LTBCoin', 'LTBC', 'ltbc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoP/PoV/PoQ', 'http://ltbcoin.com/', '@ltbcoin', 'LTBcoin does not use computational mining. Instead, coins are distributed to the content creators, the community and the platform according to a fixed schedule. After a period of 260 weeks (5 years), all coins will be distributed and no new coins will be created.\n\nIt is a crypto-rewards system where people who help LTB to be useful are rewarded for their efforts. And it’s built on Bitcoin!\n\nLTBcoin is the proprietary token for the Let’s Talk Bitcoin Network. It is the exclusive token accepted for sponsorships. It will provide the user a significant discount in the network wide and ACT-specific e-commerce stores. It can be used in the network for tipping and will generally be useful in every corner of the LTB universe.\n\nLTBcoin does not use computational mining. Instead, coins are distributed to the content creators, the community and the platform according to a fixed schedule. After a period of 260 weeks (5 years), all coins will be distributed and no new coins will be created.\n\nLTBcoin is a user-defined asset using the Counterparty protocol. Counterparty is built on Bitcoin and is secured by the Bitcoin network. Because of this, LTBcoin addresses are exactly the same as Bitcoin addresses. LTBcoin can be traded on the Counterparty distributed exchange for Bitcoin, XCP or other user-defined assets.', '', '', '', '2016-03-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NeosCoin', 'NEOS', 'neos.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.neoscoin.com/', '@NeosCoin', 'NeosCoin is a Proof of Stake cryptocurrency featuring a network of masternodes that provide instant a private transactions. Neos v3.0 will provide a decentralized and immutable hosting service and social network, where participants are rewarded for their activity. Creating, sharing and liking (and more) content is automatically rewarded with a portion of the block reward (based on a point system).\n\nNeos v3.0 will offer access to the cryptocurrency without the need for exchanges or faucets. Within the network, there are also premium services that create a use case for the coin. Most of the coins spent on the premium services are bunt while a smaller part is sent to a development fund, making NeosCoin a deflationary currency.', '', '', 'SHA256', '2015-12-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HyperCoin', 'HYPER', 'hyper.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://hypercrypto.com/', '@HyperCrypto', 'HyperCoin (HYPER) is a scrypt altcoin that switches from PoW to PoS - the PoW phase lasts two weeks and the PoS phase has three distinct phases of its own. The first is a five PoS rate of 5% monthly for five years - the second a 10% annual rate for five years - and a third ad infinitum rate of 2%. The coin has a thirty second block time, difficulty retargetting every 20 blocks, and a 2.5% premine.', '', '', 'Scrypt', '2016-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Vtorrent', 'VTR', 'vtr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@vTorrentCrypto', 'Vtorrent is aiming to be limewire, emule or bittorrent with the block chain as its core system.', '', '', 'Scrypt', '2014-11-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MetalCoin', 'METAL', 'metal.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Metalcoin is a minable cryptocurrency, backed by tangible assets. Miners will be able to mine MetalCoins with their computers and trade them in for actual gold, silver and copper coins (minted by MetalCoin), if they choose to sell. MetalCoin will also hold a derivative value based on future franchise performance. Word of warning as their website and twitter feeds are not working as of april 2015.', '', '', 'Scrypt', '2015-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PinkCoin', 'PINK', 'pink.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://getstarted.with.pink/', '@Pinkcoin_', 'PinkCoin (PC) is an X11 coin with a seven day PoW period before switching to being a pure PoS coin with a 1% annual interest rate. There is a hard cap of 380 million coins to be produced and a block time of 30 seconds. There was no premine.', '', '', 'X11', '2014-02-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GreenCoin', 'GRE', 'gre.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.grcoin.com/', '@GoGreenCoin', 'GreenCoin Producers Official Network - A mechanism by which an open market can collectively produce, price and trade private-market carbon credits.', '', '', 'Scrypt', '2014-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'XG Sports', 'XG', 'xg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@XGcurrency', 'XG is a New Cryptocurrency focused in deploying high quality digital services to sports environments over the world.\n\nIt was created by the GoalCoin team as a natural transition of the current coin to a more solid software infrastructure that includes a completely new hash generation algorithm called as the new coin, XG.', '', '', 'XG Hash', '2014-05-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ChildCoin', 'CHILD', 'child.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.x-children.org/', '@XLaboratories', 'X-Children is a revolutionary PoW coin featuring an established difficulty adjustment algorithm (X11) and an innovative two-phase distribution plan which ensures that the coin remains sustainable and economically viable. During the first 28 days 90% of all coins will be distributed, then transitions to anti/inflation 1 coin per block mode', '', '', 'X11', '2015-12-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BOOM Coin', 'BOOM', 'boom.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://cleverhash.com/', '@Boom_Coin', 'Boomcoin was developed by the Cleverhash team to be a business oriented cryptographic token.', '', '', 'X13', '2016-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Instamine Nuggets', 'MINE', 'mine.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.instaminenuggets.com/', '@InstaMineNugget', 'InstaMineNuggets ($MINE) is a unique cryptocurrency designed to offer its users decentralized blockchain \"Crypto Coin Contracts\" offering potential rewards while striving to become a viable storage of wealth for the long-term. $MINE launched on 02-25-15 offering open-source desk top QT software for download and mining purposes. $MINE aims to produce an efficient network for miners and adopters alike.\n\n$MINE was developed utilizing the identical underlying algorithm and scrypt of Litecoin and will be capped at 21649485 million coins with 30 coins per initial block and rewards halving at block 350,000 to 15 coins. $MINE\'s mining reward will continue to halve every 350,000 blocks; EX: 30, 15, 7.5 until all coins are completely mined and in publics hands. Target spacing is 3 minutes with a target time span of 33 hours with rewards maturing every 3 blocks mined.', '', '', 'Scrypt', '2016-10-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ROS Coin', 'ROS', 'ros.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://roscoin.com/', '@roscoin', 'Roscoin cryptocurrency is launched on Sep.19.2014.\n\nPowered by x11 algorithm, precisely managed by developer placebo and completely designed by logocreator.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Unattanium', 'UNAT', 'unat.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@UnattainiumOrg', 'Unattanium is an SHA-256 alternative crypto currency.', '', '', 'SHA256', '2014-10-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SlimCoin', 'SLM', 'slm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoB', NULL, '@slmcoin', 'SlimCoin is an innovative coin and a hybrid proof of burn, work and stake. Total coins are limited to 10 billion and the block reward decreases in relation to increasing diifficulty. Difficulty retargets continuously and the block time is 90 seconds.', '', '', '', '2016-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GAIA Platform', 'GAIA', 'gaia.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@gaia_coin', 'GAIA coin offers the security and reliability of the blockchain with an Extensible, Skinnable, Modular platform design with capabilities to implement distributed markets and services.', '', '', 'X11', '2014-02-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TrustPlus', 'TRUST', 'trust.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://trustplus.co/', NULL, 'TrustPlus (TRUST) is an X11 algorithm based crypto currency that has a short PoW phase of just under seven days. The PoS rate is 18% per annum and there was a premine for roughly 10% of the PoW mined coins.', '', '', 'X11', '2015-09-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FantomCoin ', 'FCN', 'fcn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'FantomNightCoin (FCN) is a CryptoNight algorithm based coin which is a 64-bit CPU only mineable coin. There is a block time of sixty seconds and the block reward is controlled by a formula that decreases depending on the supply mined to date. The coin retargets every block.', '', '', 'CryptoNight', '2014-07-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cryptonite', 'XCN', 'xcn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://cryptonite.info/', '@CryptoniteCoin', 'Cryptonite was developed by the Mini-blockchain Project over a period of almost four months. Cryptonite is a fork of the Bitcoin core but the code has been extensively modified and expanded upon.', '', '', 'M7 POW', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Curecoin', 'CURE', 'cure.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.curecoin.net/', '@CureCoin_Team', 'Curecoin is a PoW PoS hybrid altcoin that allows both ASIC mining and CPU & GPU mining to play a part in creating coins - as they call it mining and folding. The added benefit behind the coin is that computer power is used to test protein folding and create a valuable scientific knowledge base. Block halving occurs every million blocks and the block time is 60 seconds.', '', '', 'Scrypt', '2014-11-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Gridmaster', 'GMC', 'gmc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://gridmaster.co/', NULL, 'Gridmaster Coin (GMC) is a peer to peer crypto currency that is built with the latest technologies in crypto currency such as Dynamic Proof of Stake, Anonymous transactions, Masternodes and Encrypted Messaging. Further developments will focus on building platforms and utilities that bridge the merchant-consumer gap whilst enabling the wider audience to use the digital currency in their everyday lives.', '', '', 'Scrypt', '2015-02-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MemoryCoin', 'MMC', 'mmc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://memorycoin.org/', NULL, 'MemoryCoin (MEM) is a POW is a modified momentum based algorithm and decentralizes currency mining. Each hash requires 1GB of Memory to perform and encrypts 50GB of data. By contrast, the verification only requires 128K and less than one 10th of a second. The coin is inflationary with a rate of 2% after the first two years of mining 10000000 coins.', '', '', 'Multiple', '2014-03-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitcoinPlus', 'XBC', 'xbc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://www.bitcoinplus.org/', '@BitcoinPlusXBC', 'Bitcoin Plus is a Bitcoin advance adding features such as proof of stake with a 10% annnualised interest rate.', '', '', 'Scrypt', '2016-06-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ConSpiracy Coin ', 'CYC', 'cyc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'There is no longer a functional website for this crypto currency - although the coin has 33 million total units to be mined by proof of work and X11.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OctoCoin', 'OCTO', 'octo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.theoctoparty.com/', '@theoctoparty', 'OCTO is a Counterparty asset with focus on decentralized website payments for Counterparty assets and Token Control Access Marketing. OCTO will create and fairly distribute a total of 88.8 million coins to be used for early access and testing of the OCTO projects. Distribution includes an alt coin burn, merged mining with FoldingCoin and a future crowd sale.', '', '', '', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MasterCoin', 'MSC', 'msc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://mastercoin.org/', '@MSCProtocol', 'Mastercoin is both a new type of currency (MSC) and a platform. It is a new protocol layer running on top of bitcoin like HTTP runs on top of TCP/IP. Its purpose is to build upon the core Bitcoin protocol and add new features, with a focus on a straight-forward easy to understand implementation which allow for protocol and analysis and its rapid development. Many of the functionalities are theoretical at this point (and ripple has first-mover advantage), but Mastercoin\'s definitely worth watching.', '', '', 'Scrypt', '2015-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EggCoin', 'EGG', 'egg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'EggCoin is a scrypt based alternative crypto currency.', '', '', 'Scrypt', '2015-10-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Coin.2', 'C2', 'c2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Coin2Crypto', 'Coin 2.0 is a pure proof of stake coin with 60000000 total coins and an annual variable interest rate that decreases from 30% in y1 to 2% in y5.', '', '', 'Scrypt', '2014-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GlowShares', 'GSX', 'gsx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.glowshares.com/', NULL, 'Anonymous, decentralized voting on the blockchain makes it easy for the community to form a consensus on important issues regarding the future of GSX. Secure, transparent, tamper-proof, and viewable 24 hours a day. Predefined rules govern and enforce the voting process, putting the coin in the hands of the holders. GSX brings together its community with voting on the blockchain.', '', '', '', '2014-10-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Camcoin', 'CAM', 'cam.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@CamCoinShare', 'CamCoin has an open libertarian philosophy on sharing photography and art. It is a PoW PoS hybrid X11 based alternative crypto currency with a block time of 60 seconds and difficulty retargetting every 20 blocks. There was a small premine of 10,000 CAM on a total supply of 10 million - The PoS rate is 9%.', '', '', 'X11', '2014-09-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ribbit Rewards', 'RBR', 'rbr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.ribbitrewards.me/', '@RibbitRewards', 'RibbitRewards is the world’s first rewards program supported by block chain technology. Buyers and sellers transacting in goods and services or giving charitable donations in any currency earn RibbitRewards. No matter what currency you are transacting in, the more you buy, sell, or donate on Marketplace.Life or other participating merchant sites, the more RibbitRewards you can earn.', '', '', 'Multiple', '2015-02-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Quotient', 'XQN', 'xqn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.quotientcoin.com/', '@QuotientXQN', 'Quotient is a high-interest proof-of-stake crypto currency that offers 1,618% annual returns on your stake, with a max stake reward cap of 618 coins.', '', '', 'Scrypt', '2014-11-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ICASH', 'ICASH', 'icash.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@iCashOfficial', 'iCash P2P Cryptocurrency - iCash is Anonymous and instant.', '', '', 'X11', '2014-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Node', 'NODE', 'node.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoA', 'http://nodecoin.com/', '@NodeCoin', 'Node is a second generation crypto currency built in node.js. it operates through proof of activity and can be seen as a hybrid between a crypto currency and a payments processing system. It can run efficiently on mobile clients and as the network become s more secure the more users there are - each time someone spends - the network becomes harder to break.', '', '', 'Curve25519', '2016-06-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SoonCoin', 'SOON', 'soon.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.sooncoin.com/', NULL, 'Soon Coin is an SHA-256 Bitcoin clone - the number of coins is 21 million to be mined by proof of work.', '', '', 'SHA256', '2014-05-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitMiles', 'BTMI', 'btmi.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://bitmiles.org/', '@bitmilesco', 'BitMiles (BTMi) - the official cryptogenic equivalence of frequent-flyer miles (which is known to be more valuable than money). BitMiles can be used as a means of exchange and a store of value (very much the same as your traditional flyer miles).', '', '', 'Scrypt', '2015-01-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Event Token', 'EVENT', 'event.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.event-hub.co/', '@EventToken', 'EventToken is a multi layer crypto currency aimed at the multi billion dollar events industry, and specifically the festivals market and aimed at solving the specific issues around people using cash at food and merchandise vendors. At many events people go there for several days and the majority of vendors are not set up or able to accept card payments, but carrying large amounts of cash around is risky for many reasons.', '', '', 'Scrypt', '2016-03-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '1Credit', '1CR', '1cr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.1creditcoin.org/', NULL, '1CRedit was created to be the 4th coin in the game \"The Crypto Void\" by 1BillionHex. Although a game coin in the sense of that being the driver for its creation, it is a fully functional cyber coin that can stand alone.\n\nThe genesis of the coin is to be something as stable as the current Bitcoin/Litecoin codebase will allow. Kimoto Gravity Well is used to stabilize block times as of block 5000.\n\nLong block times and high confirmation requirements should minimize fork opportunities. They will tend to make this an \"investment\" coin rather than a \"transaction\" code.', '', '', 'Scrypt', '2016-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ViorCoin', 'VIOR', 'vior.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://viorcoin.com/', '@viorcoin', 'ViorCoin includes encrypted messageing but is also a scrypt alternative crypto currency.', '', '', 'Scrypt', '2016-05-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'XCoin', 'XCO', 'xco.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://x-coin.info/', NULL, 'XCO is an ultra hybrid crypto currencies that was compiled from best altcoins, and bitcoin, allowing the ultra fast transactions to anyone anywhere in the world. Allowing you full control over your own balances.  \nX-Coin info:\n\nTicker: XCO  \nRelease Date: February 27, 2015  \nRelease Location: Bitcointalk.org   \nRelease Type: Public, Zero Premine, No IPO, No ICO offerings  \nReleased as Sha256d POW at block 1  \nChanged to POS on March 15th, 2015 at block 30001  \nNew Block Time: Instant, every transaction creates a new block.  \nMinimum transaction fee: 0.01 XCO – TX Fees are paid to staking blocks.  \nTransactions require 10 confirmations to mature  \nP2P port: 14641  \nRPC port: 14642\n\n  \nX-Coin POS Stage Specs:\n\nMinimum staking amount: 1000 XCO  \nMinimum Time to begin Stake: 8 Hours  \nMaximum Time to end of Stake: 24 Hours  \nStaking Rewards: Amount Range from .01 to 50 XCO based on staked amount  \nMax Mined: 50.00 XCO based on optimal block size of: 12500.01 XCO  \nStaked Blocks Maturity Rate: 110 Confirmations to mature  \nDecreasing Inflation Rate: 90% inflation year one, Then will decrease 12.5% each year (Example 77.5% year two, 65% year three, 52.5 % year four)', '', '', 'SHA256', '2017-02-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'VirtualMining Coin', 'VMC', 'vmc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://virtualminingcoin.org/', NULL, 'VirtualMiningCoin (VMC) is a scrypt-n adaptive altcoin that has a maximum coin supply of 100 million VMC. The block reward is fixed at 171VMC and the block time at sixty seconds. The difficulty retargets every five minutes and 2% of the coin supply is dedicated to maintenace and development, whilst the larger 8% is distributed amonsgt those involved in the book build or IPO.', '', '', 'Scrypt-n', '2015-12-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MarsCoin', 'MRS', 'mrs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://marscoin.org/', '@marscoinorg', 'MarsCoin (MRS) is out there with its charitable foundation plan to initiate colonisation of Mars. The premine was a donation towards the foundation. The block reward is set to half every year on a block time of two minutes and a total hard coin cap of 33 million', '', '', 'X11', '2016-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Viral Coin', 'VIRAL', 'viral.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://bitcointalk.org/', '@ViralDev', 'ViralCoin (VIRAL) is a crypto currency operating by proof of work but with a twist. The idea is to use native social advertising to generate revenue for holders of the crypto currency. This is then used to buy the VIRAL coin on exchanges which are then burnt - reducing total supply. Difficulty retargets every block and there is a 5% PoS rate.', '', '', 'Scrypt', '2016-04-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Equilibrium Coin', 'EQM', 'eqm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://bitcointalk.org/', '@EquibriumCoin', 'Equilibrium COIN - EQM - is an innovaticve crypto currency using SHA-256d. The main idea behind EQM is to balance the Proof of Work and the Proof of Stake to obtain network security and reduce hoarding. This is done dynaimcally on a block time of 80 seconds.', '', '', 'SHA256', '2016-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'IslaCoin', 'ISL', 'isl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://islacoin.net/', '@islacoin', 'IslaCoin (ISL) is an X11 alternative crypto currency with a sixty second block time based on the X11 algorithm. The proof of work phase has come to an end and now the proof of stake phase has kicked in with a fixed 12% per annum annualised staking interest rate.', '', '', 'X11', '2014-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Quicksilver coin', 'QSLV', 'qslv.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://quicksilvercoin.co/', '@Quicksilver_Dev', 'The goal of QuickSilver is to decentralize the process of acquiring and paying for a cab. A robust driver and customer matching system includes everyone from independent cab drivers to fleet owners allowing everyone to compete in the market. There are no hidden fees when using QuickSilver which will translate into lower prices for customers and a better bottom line for drivers.\n\nQuicksilver is a proof of stake crypto currency with an annualised interest staking rate of 6%.', '', '', 'X11', '2016-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'World Trade Funds', 'XWT', 'xwt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://worldtradefunds.com/', '@WorldTradeFunds', 'Worldtradefunds is a decentralised digital currency that enables anyone with an internet connection to create financial transactions without any third-party intermediation. Transactions are made person to person without the use of banks or middle men, and these transactions have a minimal cost compared to the centralised banking system.', '', '', 'X15', '2015-08-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DeOxyRibose', 'XNA', 'xna.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'XNA or DeOxyRibose is an alternative crypto currency.', '', '', 'X11', '2015-03-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RadonPay', 'RDN', 'rdn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'RadonPay is an attempt to use the blockchain to send files of any size. The website is no longer working.', '', '', '', '2015-08-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SkullBuzz', 'SKB', 'skb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'SkullBuzz is an SHA-256 alternative crypto currency.v The coin is both proof of work and proof of stake. Difficulty retargets every ten blocks on a block time of 60 seconds. The Proof of stake reward is HIPOS at 0.5 SKB.', '', '', 'SHA256', '2016-08-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GlobalBoost', 'BSTY', 'bsty.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://globalboo.st/', '@GlobalBoost', 'BSTY brings a completely new algorithm to the digital currency scene, and combines it with our real products, real company, and visible & accountable leadership. They aim to improve the acceptance of digital money, providing a safe & attractive investment using Yescrypt as POW - which is ASIC and FGPA resistant..', '', '', 'yescript', '2014-08-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CryptoFocus', 'FCS', 'fcs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://cryptofocus.info/', '@cryptofocus', 'CryptoFocus is an X11 algorithm based alternative crypto currency - the aim of the company is to integrate as fast as possible into the next level of intuitive applications with cryptography under the hood.', '', '', 'X11', '2015-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Gambit coin', 'GAM', 'gam.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://gambitcrypto.com/', '@gambitcrypto', 'Gambit Crypto is a Scrypt coin that was crowd funded and ran with proof of work before switching to proof of stake.\n\nGambit is an experimental trading token that combines cryptocurrency trading, hedging, and asset acquisitions.', '', '', 'Scrypt', '2015-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Nexus', 'NXS', 'nxs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/nPoS', 'http://www.nexusearth.com/', '@NxsEarth', 'Nexus is an innovative crypto currency - the coin runs off its own algorithm and has a well though through infrastructure that takes it beyond bitcoin and other 1 st generation crypto currencies - it has a checks and balances system for sending coins - where transactions can be retrieved if sent to a wrong address. The proof of stake rate is 2% up to a coin cap of 78 million.', '', '', 'SHA3', '2015-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Crypto Escudo', 'CESC', 'cesc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://cryptoescudo.org/', '@cryptoescudo', 'CryptoEscudo is the Portuguese crypto currency. The block time is two minutes - the difficult retargets with the kimoto gravity well - the coin is proof of work and runs off scrypt - with a hard cap of 1 billion CESC units.', '', '', 'Scrypt', '2015-08-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Twelve Coin', 'TWLV', 'twlv.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@CoinTwelve', 'Twelve is a fast and secure cryptocurrency based on a brand new hashing algorithm- T-inside. The difficulty retargets each block - the PoS rate is 3%.', '', '', 'T-Inside', '2017-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EagsCoin', 'EAGS', 'eags.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://eagscurrency.com/', '@EagsCurrency', 'EAGS is a New and True Decentralized Cryptocurrency with Unique Business Plan and Wallet Features. Many Cryptocurrencies failed because of lack of Ideas and a Solid Road Map. EagsCurrency is here to bring some New Strategies to Support itself and always be Valuable to the Community in a Longterm Existence.\n\nEAGS has a Total of 20,445,500 Coins. The 20 millions are the DOUBLE of 10 millions - (10 millions for POW and 10 millions for POS) and the other 445,500 is also added to the POW for Miners and it represent the 445,500 Double Eagle Gold Coins that were minted in 1933 but destroyed later and never circulated.', '', '', 'X11', '2015-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MultiWallet Coin', 'MWC', 'mwc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://mwc.pw/', '@MultiWalletCoin', 'MultiWallet Coin is an X11 alternative crypto currency with a block time of 120 seconds and a proof of stake rate at 5%.', '', '', 'X11', '2014-05-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AudioCoin', 'ADC', 'adc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.audiocoin.eu/', '@Aurovine', 'AudioCoin builds on the Peercoin and (by association) Bitcoin protocol to provide a new way to consume music. It breaks down the barriers of traditional e-commerce systems and provides a super cool way for music fans and artists to engage in viral marketing. The main gain is that artists (producers) and music fans (consumers) are rewarded tangibly and thereby rendering the current streaming model both archaic and redundant.', '', '', 'Scrypt', '2016-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MarsCoin ', 'MARS', 'mars.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://marscoin.org/', '@marscoinorg', 'MarsCoin (MARS) is out there with its charitable foundation plan to initiate colonisation of Mars. The premine was a donation towards the foundation. The block reward is set to half every year on a block time of two minutes and a total hard coin cap of 33 million', '', '', 'X11', '2016-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Megastake', 'XMS', 'xms.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'A standard alternative crypto currency with a block time of 60 seconds running off X11. The annual percentage stake is 33%.', '', '', 'X11', '2017-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Sphere Coin', 'SPHR', 'sphr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.sphrpay.io/', '@ProjectSPHR', 'Sphere (SPHR) is a decentralized peer-to-peerpayment network, secured through a proof of stake (pos) consensus blockchain. (sphere) is designed to act as an efficient and secure means of commerce, while also serving as an appreciating token for traders and long-term holders.', '', '', 'Scrypt', '2015-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Singular', 'SIGU', 'sigu.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Singular (SIGU) is a scrypt alternative crypto currency. The PoS rate is 10% per annum and the block timeis sixty seconds.', '', '', 'Scrypt', '2016-05-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitcoinTX', 'BTX*', 'btx_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@btxcoin', 'BitcoinTX is an attempt at reformulating Bitcoin with Proof of Stake and using the X11 algorithm. Initially there was a PoW phase. After that, it was all PoS but there was a problem in the \"lucky stake\" code. The original developer(s) walked away. After that, they licked their wounds, started a little \"crowd-fund\" for a new developer to fix the code and managed to go forward with the project!', '', '', 'X11', '2015-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DarkCrave', 'DCC', 'dcc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Dark_Crave', 'DarkCrave is an alternative crypto currency that is both proof of work and proof of stake. The total number of coins to be mined is 277500.', '', '', 'SHA256', '2016-03-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SupplyShock', 'M1', 'm1.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@SupplyShock', 'Supplyshock is another X13 crypto. The coin is proof of work and proof of stake. The Hypershock proof of stake has range of rates between 5-200%', '', '', 'X13', '2017-02-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DarkBit', 'DB', 'db.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'DarkBit is a Scrypt alternative crypto currency. The coin is both proof of work and proof of stake.', '', '', 'Scrypt', '2016-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Crypto', 'CTO', 'cto.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@OfficialCrypto', 'Crypto is a decentralized cryptocurrency designed for short transaction times, anonymity and a consistent, stable value. Crypto is a coin designed with the best features of the other cryptocurrencies around; its purpose is to form a flawless coin with a strong community based on all the great ideas of other cryptocurrencies. There is also another purpose of Crypto; to fix a problem which almost all the other cryptocurrencies have to endure. As more coins are generated the value of these coins goes down by a great amount over time becuase the amount of coins you get is only lowered every few years.', '', '', 'Lyra2RE', '2017-06-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EdgeCoin', 'EDGE', 'edge.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/HiPoS', NULL, NULL, 'EdgeCoin is a Proof of Work and HiPoS SHA-256 alternative crypto currency.', '', '', 'SHA256', '2015-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitLux', 'LUX*', 'lux_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Bitluxdev', 'LUX or BitLux is an alternative crypto currency trying to focus on the luxury feminine market. Otherwise the crypto currency is an X11 hybrid proof of work and proof of stake with an annual rate of 10%.', '', '', 'X11', '2016-08-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FutCoin', 'FUTC', 'futc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@futcoin__', 'FutCoin was born out of concern for the environment, with the goal of providing the usefulness and innovation of crypto currency payments to the general public. The coin is an X11 crypto currencywith proof of work and proof of stake @ 2% per annum.', '', '', 'X13', '2016-07-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Global', 'GLOBE', 'globe.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.globalcurrencycoin.com/', '@GlobalCoinTeam', 'Global is a decentralized protocol which performs nearly instant global transactions. With Global you can send or receive payments to friends, family, and/or merchants anywhere across the globe. The coin is proof of stake after a distribution phase via crowd funding. The PoS rate is 3%.', '', '', '', '2015-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TamaGucci', 'TAM', 'tam.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS/PoC', NULL, NULL, 'Tamagucci is a game focussed crypto based on the Tamagotchi. The coin will distribute via a PoW phase then move into a proof of care phase to reward those who succeed in the game.', '', '', 'Scrypt', '2016-09-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MorpheusCoin', 'MRP', 'mrp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@MRPcoinDev', 'Morpheus Coin or MRP is an X11 based Proof of Work alternative crypto currency. Block halving occurs every 10000 blocks with a block time target of 76 seconds. The total coin supply is limited to 3400000 coins.', '', '', 'X11', '2015-04-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Creva Coin', 'CREVA', 'creva.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.crevacoin.com/', NULL, 'CrevaCoin is a Korean based Crypto currency with the backing of a shop.', '', '', 'X11', '2016-08-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Forever Coin', 'XFC', 'xfc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://forevercoin.us/', NULL, 'ForeverCoin was inspired by Blackcoin. and it shares much of the source code and technical implementation of Blackcoin. The ForeverCoin source code is distributed under the MIT/X11 software license. ForeverCoin has 105 million coins for initial distribution and a hard limit on the number of possible coins of 210 million.', '', '', 'X11', '2015-01-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BananaBits', 'NANAS', 'nanas.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.bananabits.website/', '@bananabitscoin', 'BananaBits is a decentralized, peer-to-peer Proof of Stake digital crypto currency derived from Bitcoin and Blackcoin that enables you to easily send money online. Think of it as \"the internet currency.\"', '', '', 'Scrypt', '2015-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Wood Coin', 'LOG', 'log.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Woodcoin distribution is designed to more closely model renewable resources than nonrenewable. The money supply curve is designed for stability and longevity. WoodCoin, or LOG, has a hard cap to the coin supply thrpugh Proof of Work of just over 27 million.', '', '', '', '2015-10-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cerium', 'XCE', 'xce.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@CeriumDev', 'Like the rare earth element it is named after, the Cerium crypto currency is small in supply and aims to be a something the world depends on. Cerium hopes to introduce an efficient payment method which will eventually be adopted by the masses.', '', '', 'SHA256', '2015-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Anarchists Prime', 'ACP', 'acp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.anarchistsprime.info/', '@AnarchistsPrime', 'AnarchistsPrime ACP is a crypto currency for those who know the anarchy symbolism and what it stands for, this is to help aid those protestors who need ways of receiving funding. Despite the specific use named for this particular crypto by its creators the crypto is an SHA-256 Proof of Work based coin with block time of 3 minutes and difficulty retargetting each block.', '', '', 'SHA256', '2016-12-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Droidz', 'DRZ', 'drz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Droidz_DRZ', 'Droidz (DRZ) is an alternative crypto currency that runs off the QuBit algorithm via Proof of Work and Proof of Stake. The proof of stake rate is 5% and the total coin supply ois c.5060000.', '', '', 'QUAIT', '2016-02-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GorillaBucks', 'BUCKS*', 'bucks_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.gorillastake.com/', '@PurePoS', 'Bucks or Gorilla Bucks is part of the Gorilla network. An innovative and well thought through new Crypto although experimental.', '', '', '', '2016-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BowsCoin', 'BSC', 'bsc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://thebows.ru/', '@NastaGm', 'BowsCoin (BSC) is an X11 Proof of Work alternative crypto currency. The total number of coins is 21 million. The block time target is two and a half minutes.', '', '', 'X11', '2017-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DarkTron', 'DRKT', 'drkt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'DarkTron is a fork of Positron aiming to focus on structural development with anonymity as a forefront concern. Anonymity is an important aspect to crypto currency and essential in times when security and privacy boundaries are being broken down. DarkTron aims to provide solutions in payment and communication.', '', '', 'SHA256', '2015-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CryptoCircuits', 'CIRC', 'circ.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@CryptoCircuits', 'CryptoCircuits is dedicated to building a community across the crypto landscape, connecting crypto people and coin communities through their advanced Circuits trading wallet environment.\n\nCryptoCircuits wallet provides a welcoming meeting place for everyone who has crypto as part of their daily lives. Social features of the Circuits wallet include chatrooms, tipping, and encrypted private video chatting. A special chill out lounge panel includes crypto video channels, and the Crypto After Dark 24 /7 in-wallet radio stream, featuring guests and guest hosts from across the crypto landscape.   \n  \nThe social features of Circuits are complemented by a sophisticated crypto toolbox that includes in-wallet charting, trading hubs, live crypto news feeds, and trading bot functionality for advanced users.  \n  \nOn the tech side CryptoCircuits represents a major leap forward in crypto technology.   \nCircuits features the most advanced DPOS 2 iteration engineered so far in crypto, and has allowed us to build a number of advanced staking functions and features into the Circuits wallet.', '', '', 'vDPOS', '2016-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'IncaKoin', 'NKA', 'nka.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@incakoin_420', 'InkaCoin is a hybrid Proof of Work and Proof of Stake SHA-256 alternative crypto currency. There is a 60 second block time target and a 5 block difficulty retargetting. The total number of coins is limited to 190 million NKA.', '', '', 'SHA256', '2016-11-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Versa Token', 'VERSA', 'versa.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@VersaCrypto', 'Versa or Universal Token, is designed to store any type of data making it an ideal platform for a wide range of applications, including financial systems, medical records, supply chain management, voting systems, property titles, legal applications, and much more. Versa allows applications and users to create their own blockchains, which are just whatever data they wish to track. Those chains are secured by hashing them together with all the other data from other users, and a single hash is written to the Versa blockchain.', '', '', '', '2015-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Empyrean', 'EPY', 'epy.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Empyrean is a pure proof of work scrypt based alternative crypto currency with a hard coded cap of 100,000 EPY units.', '', '', 'Scrypt', '2015-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Squall Coin', 'SQL', 'sql.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@squallcoin', 'Squall coins is a proof of stake X11 based alternative crypto currency with a block time of two and a half minutes and a 2% annualised stake rate.', '', '', 'X11', '2016-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PolyBit', 'POLY', 'poly.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@polybitco', 'Polybit is a proof of work scrypt based alternative crypto currency with a 10% premine and a block time target of 3 minutes, a hard cap of 150 million units and a difficulty retargetting every 24 hours. The website URL is inactive at the time of writing.', '', '', 'Scrypt', '2015-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Piggy Coin', 'PIGGY', 'piggy.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://www.piggy-coin.com/', '@piggycoin', 'Piggy Coin aims to be a started crypto currency to get people interested and understand the concept of crypto currencies. The block time is 60 seconds and difficulty retargets each block. The PoS rate is 3% and the premine was 1% and the Proof of Work phase ended after block 10,000 based on X11.', '', '', 'X11', '2015-10-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Charity Coin', 'CHA', 'cha.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'CharityCoin is a new cryptocurrency with a single goal and purpose, to become the world’s number one charitable cryptocoin helping to fund-raise for charities across the globe. CharityCoin’s strengths lay within its community as ten percent of all mined coins are added to the CharityCoin donation fund and distributed to our supported charities.', '', '', 'Scrypt', '2014-06-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Milllionaire Coin', 'MIL', 'mil.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@MilCoin', 'As the name suggests, MIL will have just 1 million coins in the POW phase and will then have a nominal interest rate of 12% per annum in the POS stage.', '', '', 'X11', '2014-09-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Crown Coin', 'CRW', 'crw.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://crown.tech/', '@Crowncoin1', 'Crowncoin was created in 2014 as a proof of work digital currency and an alternative to FIAT currencies. CRW is a peer to peer digital currency, which enables to send and receive online payments between two parties without the need of financial institution.', '', '', 'SHA256', '2015-02-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Genstake', 'GEN', 'gen.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://genstake.com/', '@Genstake', 'Genstake is about trying something different with staking. Staking was designed originally to yield a percentage of a coinholder\'s total coins over time, every year, in exchange for supporting the network. Developers walk a fine line between coding high interest percentages to entice holders to stake to support the network while trying to keep the interest percentages low enough that inflation doesn\'t kill the coin. People have become accustomed to \'Mining Periods\' of hyper inflation where the initial coinbase is established, after which mining becomes impossible and the network relies entirely on holders to stake in order to maintain the network and process transactions.   \n  \nGenstake aims to change all that. With Genstake, staking blocks doesn\'t give you interest on the coins you already have; staking blocks gives you a full block reward. Effectively, each of your coins becomes a little mining rig on the network, working diligently to mine you more coins. Gone are the days of 0.02 coins for staking a block. Staking a block with Genstake produces 20 Gencoins.', '', '', 'Scrypt', '2015-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PharmaCoin', 'XPH', 'xph.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@pharmacurrency', 'A coin who\'s website does not work at the present - no information available.', '', '', '', '2015-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GridMaster', 'GRM', 'grm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'Gridmaster (GRM) crypto currency - no functioning website available at the time of writing.', '', '', '', '2016-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Quartz', 'QTZ', 'qtz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@QuartzCurrency', 'This crypto has limited information available and no website. The coin is a proof of work and proof of stake hybrid.', '', '', 'SHA256', '2017-02-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Arbit Coin', 'ARB', 'arb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://getaugmented.net/', '@get_ARbit', 'Arbit Coin was supposedly designed for Augmented reality. The coin is Proof of Work and Proof of Stake.', '', '', '', '2015-08-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Litestar Coin', 'LTS', 'lts.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Litestar Coin is a PoW and PoS hybrid - difficulty retargets each block. there are random superblocks and a 15 second PoS block time. Maximum supply is roughly 120 million LTS.', '', '', '', '2016-05-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SpinCoin', 'SPC', 'spc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Spincoin, a fork of Talkcoin, was designed using the NIST5 hashing algorithm to provide a better combination   \nof power efficiency and security compared to other existing algorithms. The coin is being delisted.', '', '', 'NIST5', '2015-03-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GoldPieces', 'GP', 'gp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://gpieces.com/', '@Gold_Pieces', 'GoldPieces is an X11 crypto currency that moves from proof of work to proof of stake with a 500% rate.\n\nGoldPieces \\[GP\\] are an expandable digital currency to be utilized within the browser based gaming industries games themselves. Browser based games come in all shapes and sizes but one common principle they all share is the use of some monetary unit within the games walls. We think it would add a fun and interesting dimension to the browser gaming industry if the games took advantage of the blockchain digital currency technology used in the **GoldPieces** software.\n\nBrowser based games are strategy or turn based games that you can play in your browser in most cases. Some popular browser based game themes include Virtual pet sites where the player can raise a pet, equip it with weapons, feed it, and grow its stats over time.\n\nMafia based gameplay is another crowd favorite. You must complete missions and take over parts of the city to rise to the top of the family.\n\nWe will be launching and maintaining several browser based games that will use GoldPieces as the monetary unit within the game.', '', '', 'X11', '2015-06-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Bitz Coin', 'BITZ', 'bitz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'BitzCoin does not have much information available. The coin is Proof of Stake.', '', '', '', '2016-01-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DubCoin', 'DUB', 'dub.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'DubCoin is an X15 PoW and PoS coin.', '', '', 'X15', '2015-03-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Graviton', 'GRAV', 'grav.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.graviton.ninja/', '@GravitonCoin', 'Graviton is an advanced crypto currency based on Bitcoin focused on delivering innovative decentralized applications that use the blockchain and the peer to peer network in new ways. Graviton is a pure Proof-of-Stake coin that was mined over the course of several days during the Proof-of-Work mining phase.', '', '', 'SHA256', '2015-02-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Bob Coin', 'BOB', 'bob.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.dobbscoin.info/', '@Dobbscoin', 'DobbsCoin (BOB) is a pure proof of work scrypt alternative crypto currecny. The coin has 21 million units to be issued.', '', '', 'Scrypt', '2015-09-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MonetaVerde', 'MCN', 'mcn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@MonetaVerde', 'Moneta Verde is the first cryptocoin with block reward increasing together with difficulty - this is to counter hoarding and lack of spending. Moneta Verde is a cryptonite based proof of work coin.', '', '', 'CryptoNight', '2015-05-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Quazar Coin', 'QCN', 'qcn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.quazarcoin.org/', '@QuazarCoin', 'QuazarCoin (QCN) is the new generation of cryptocurrency which is based on the cryptonote protocol and uses the cryptonight algorithm. The CryptoNight algorithm is the most democratic today, fully ASIC-resistant and only CPU-mineable.', '', '', 'CryptoNight', '2016-07-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Hedgecoin', 'HEDG', 'hedg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@HedgeCoinDev', 'HedgeCoin is an X13 alternative crypto currency with a hard cap limit of approximately 33 million currency units to be issued.', '', '', 'X13', '2015-10-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Song Coin', 'SONG', 'song.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.songcoin.org/', '@dynomania', 'Song coin is an alternative crypto currency based on proof of work and scrypt.', '', '', 'Scrypt', '2015-08-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitSeeds', 'XSEED', 'xseed.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://bitseeds.org/', '@BitSeeds', 'Bitseeds is a Proof of Work and Proof of Stake alternative Crypto currency based on Shas-256. The prrof of stake is 10% per annum. For every coin emitted on the BitSeeds network, the Rainforest Foundation and the BitSeeds Foundation has committed to planting one tree.', '', '', 'SHA256', '2016-05-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Credits', 'CRE', 'cre.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://credits-currency.org/', NULL, 'The pow/pod mining algorithm solves among other things one major problem with Bitcoin; the direct relation between inflation, Bitcoin value and mining costs. In the absolute start-up phase, approximately the first six months, only proof-of-work mining is required. Once initially mined coins will become available for deposit, the system will gradually and automatically shift toward the combined pow/pod algorithm. The deposit system does not prevent proof-of-work mining, instead it acts as a force pushing miners towards adding deposits.', '', '', 'SHA256', '2017-01-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Axiom Coin', 'AXIOM', 'axiom.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@AxiomCrypto', 'Axiom is based on its own mining proof of work algorithm and has is experimenting with a different form of digital signatures to Bitcoin.', '', '', '', '2017-02-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SmileyCoin', 'SMLY', 'smly.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'A scrypt alternative crypto currency taking an education angle.', '', '', 'Scrypt', '2014-04-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Rimbit', 'RBT', 'rbt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://rimbit.com/', NULL, 'A crypto currency aiming to be simple. Otherwise not much information available.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Chip', 'CHIP', 'chip.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'A coin again with not too much information available as their website is down.', '', '', 'X11', '2017-01-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SpecCoin', 'SPEC', 'spec.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'CryptoWatcher, or Spec coin is a coin built from Scrypt with a maximum coin supply of 3 billion.', '', '', 'Scrypt', '2017-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Gram Coin', 'GRAM', 'gram.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'No information available regarding this crypto currency.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'UnCoin', 'UNC', 'unc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.uncoin.org/', NULL, 'Uncoin was made to support NGO\'s. The coin is an X11 proof of Work and proof of stake hybrid with an annualised rate of 2%.', '', '', 'X11', '2015-10-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Sprouts', 'SPRTS', 'sprts.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://sproutcoin.github.io/', '@SproutCoin', 'Sprouts is an SHA256D based hybrid proof of work and proof of stake crypto currency.', '', '', 'SHA256', '2017-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitZeny', 'ZNY', 'zny.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://bitzeny.org/', NULL, 'Bitzeny is a scrypt based alternative crypto currency witha hard cap of 250 million units.', '', '', 'Scrypt', '2016-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitQuark', 'BTQ', 'btq.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.bitquark.info/', '@BitQuarkCoin', 'BitQuark is the result of merging Bitcoin with the super secure hashing power of Quarkcoin. BitQuark uses Bitcoin\'s distribution method with the addition of 0.5% annual inflationary after the initial 21,000,000 BitQuark\'s have been mined. It uses the super secure \'quark\' algorithm made up of 9 rounds of hashing from 6 hashing functions (blake, bmw, grøstl, JH, keccak, skein). 3 rounds apply a random hashing function. BTQ has a block time of 30 seconds and block rewards of 2.5 BTQ per block. The block rewards will never fall below 0.1 BTQ. Retargeting every block via DarkGravityWave3 and halving every 4 years. BTQ is CPU/GPU mined and ASIC resistant, so anyone can mine it without the need of running expensive high-end hardware.', '', '', 'Multiple', '2015-04-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ParkByte', 'PKB', 'pkb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.parkbyte.com/', '@ParkByte_PKB', 'A crypto currency aiming to become the de facto method of payment for the parking industry. A SHA256 coin operating on proof of work and proof of stake with a coin cap of 25 million.\n\nThe idea of this coin is to lay the foundations to give car park operators the platform to integrate with cryptocurrencies with ease.\n\nThey see Bitcoin as the tool that is trying to revolutionize the Financial Industry and that it shouldn\'t stop there. There are many other industry\'s worldwide that could benefit from its technology.\n\nParkByte will be therefore specifically targeted at laying the foundations for processing parking transactions.\n\nCurrently Parking can be paid via many methods but there is not yet a crypto related method.', 'In the UK we are able to pay for parking via Companies like RingGo, they accept Credit Card, Premium SMS methods but not Crypto.\n\nThese type of companies have in the previous years been putting a lot of pressure on conventional coin and ticket machine manufacturers because their system is cost effective. Cobalt, RingGo\'s parent have now \"securely processed over £ 1 billion\" for \"4,000 sites across the UK, by more than 60 local authorities, 10 railway operators and numerous private parking operators\".\n\nAfter having worked in the Parking Machine Manufacturing Industry for 5 years, the coin developers can see there being a huge amount of potential for this coin, its unique iOS / Android APPs and the backend processing servers.\n\nThe coin will provide basic functionality, they could then explore maybe a type of CMS marketplace where developers sell their own themes, plugins etc. for the backend server used by the parking companies.', 'Algo: SHA256\n\nTicker: PKB\n\nBlock Time: 60seconds\n\n**POW - ENDED**\n\nTimeframe: ~27days\n\nPOW Coins: 3,688,710 PKB\n\n20% Premine: 922,178 PKB\n\nPremine Burn: 1,077,822 PKB\n\nTotal POW Supply: 4,610,888 PKB\n\n**POS**\n\nMin Stake time: 1hour\n\nYear 1 - 5%\n\nYear 2 - 4%\n\nYear 3 and onwards 3%\n\n25m Total Coin\n\nRPC Port= 59060\n\nP2P Port= 58060', 'SHA256', '2015-07-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'StarCoin', 'STR*', 'str_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'STARCOIN (STR) is a litecoin clone based on the Scrypt protocol - however it is a hybrid with PoW/PoS and a 30 second block time. 4 confirmations are needed for transactions and 70 for a matured mining block. Mining subsidy or reward halves every year and difficulty retargets every block. The starting block reward was set to 100 STR and, as well as transaction messaging, there are also super blocks.', '', '', 'Scrypt', '2014-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Synergy', 'SNRG', 'snrg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.synergycoin.com/', '@SynergyCoin', 'Synergy is a peer-to-peer decentralized cryptocurrency that uses a dual-algorithm system to mine blocks. For the first 10 days, which contains the full PoW (proof of work) period, Synergy uses the X11 algorithm. Because X11 is unnecessarily inefficient after PoW, Synergy switches to SHA256d for the PoS period (proof of stake). SHA256d is easier on CPUs during syncronization and bootstrap because it requires only two hashes to verify a block whereas X11 requires 11 hashes.\n\nThe early part of the Synergy PoS period makes use of Turbo Stake, which awards Synergy holders greater interest for every stake. The multiplier is directly used in the reward calculation by multiplying it with the base Synergy interest rate of 10% per year.\n\nHolders build the Turbo Stake multiplier over two days by staking consistently. After that, the multiplier will level out and the holder will stake with a consistent rate that depends on how much stake competes with his. The Turbo Stake period lasts 30 days from the time of launch.', '', '- Ticker Symbol: SNRG\n- PoW Algorithm: X11\n- PoS Algorithm: X11, switching to SHA256d after 10 days\n- RPC Port: 50542 (configurable with rpcport= option)\n- P2P Port: 40698 (configurable with port= option)\n- Tor Port: 38155 (configurable with torport= option)\n- Block Times: 2 Minutes\n- PoW Blocks: 4320 (6 days)\n- 10% POS Interest per Year\n- Max Turbo Stake Multiplier: 288\n- Turbo Stake Lookback: 2 days Percent of Blocks over 2 days for Max Multiplier: 20%\n- Max Money Supply after PoW: 250,001 SNRG\n- Stake Minumum Age: 48 hours (2 days)\n- Stake Maximum Age: 144 hours (6 days)\n- Stake Maximum Reward Age: 8 days\n- New Mint Spendable: 120 blocks (4 hours)\n- Message Start (“Magic Bytes”): 0xf1, 0xe3, 0xe5, 0xd9\n- Message Start Test Net: 0xaf, 0xb9, 0xd9, 0xff\n- Application Data Folder Windows: “Synergy” OS X: “Synergy” Linux: “.synergy”\n- Config File Name Windows: “synergy.conf” OS X: “synergy.conf” Linux: “synergy.conf”', 'X11', '2017-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ghoul Coin', 'GHOUL', 'ghoul.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@GhostlyCrypto', 'New coin, could be a scam, not enough information available anywhere, trade carefully!', '', '', '', '2015-10-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Hellenic Coin', 'HNC', 'hnc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.helleniccoin.gr/', NULL, 'A crypto currency aiming to capitalise on the Greek Crisis. The coin is limited by a 100 million HNC currency unit cap and is scrypt based with proof of work.', '', '', 'Scrypt', '2015-09-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Diggits', 'DIGS', 'digs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.diggits.co/', '@diggitsquad', 'Diggits is a crypto-currency that rewards users for posts on our web platform dedicated to crypto and everything between.\n\nMicro transactions have proven to be pivotal in creating active communities. Diggits rewards users for posting content that everybody digs!\n\nThe website will allow users to decide which articles remain at the top meanwhile, reward those contributors with precious diggits!', 'Diggits is a crypto-currency that rewards users for posts on our web platform dedicated to crypto and everything between. Sites such as Reddit / Digg / Slashdot have a dedicated community and even their own tipping mechanisms. Diggits combines these concepts and brings together a website for the crypto community. Micro transactions have proven to be pivotal in creating active communities. Diggits rewards users for posting content that everybody digs! The website will allow users to decide which articles remain at the top meanwhile, reward those contributors with precious diggits!\n\n**Content** Users can post any kind of content they want, not just crypto-related! Posts are ordered by their popularity which are decided by the community through digs! Content quality is preserved through the incentive of creating popular posts.\n\n**Social Media** You can dig content from a plethora of content provider websites and have that content appear on diggits. Social integration enables broader reach to audiences outside of crypto.\n\n**Rewards** Posters are rewarded for their content through popularity voting mechanism. Each dig is tallied and are ranked on the main page. The poster of the content will then earn 1 Diggit for every dig on their posted content. To dig posts, users must have sufficient balance. Top posters are periodically rewarded diggits by the website. These come from a proportion of the advertising revenue that is used to buy Diggits. Diggits will earn advertising revenue through targeted ads, as well as paid sticky content. A proportion of the revenue ~30% will be used to buy Diggits from the market, and then distributed to top posters.', '\\- 100 Million Coins\n\n\\- 1 Hour Min. Coin Age\n\n\\- 64 Second Block Time\n\n\\- 10 Percent POS', 'Scrypt', '2015-03-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Expanse', 'EXP', 'exp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.expanse.tech/', '@ExpanseOfficial', 'Expanse is a decentralized cryptographic information, application, and contract platform. It is among the first of such to be fairly distributed, democratically controlled, and community managed. Through the use of smart contracts and decentralized blockchain technology, it is run not by any one individual or group, but by the users of Expanse itself.\n\nThe project is organized, managed, and operated through a decentralized organization leveraging direct influence over the platform and its future to those that matter most: our community. New features, integration, and core modifications of the expanse platform and organization can be nominated, voted on, and implemented according to the collective opinion.', 'The Expanse Development Core is composed of the project\'s founders and core developers. Knowledgeable, talented individuals with diverse technical experience related to blockchain technology.\n\nThe Expanse Community Collective is the soul of the project: the people that use it. It is made of the current active expanse token holders. Every one whole expanse counts as a voting share. Holdings less than 1 Exp do not apply.\n\nA third party board composed of individuals mutually elected by the Developer Core and Community Collective. These should be trusted well known members of the bitcoin/cryptocurrency community with long established reputations in good standing. Ideally, individuals that have a strong technical background and an understanding of blockchain technology, able to make well informed votes on technical and financial issues.', '\\- Algorithm: Dagger\n\n\\- Block Reward: 8\n\n\\- Gas Limit: 31415926\n\n\\- Block Target: 60 seconds\n\n\\- Listen Port: 42786\n\n\\- RPC Port: 9656\n\n\\- Reserve: 11 Million (Community Managed)', 'Ethash', '2015-03-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Global Currency Reserve', 'GCR', 'gcr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@GCRWorldwide', 'GCR is the the first home-based business opportunity with its own cryptocurrency and immediate opportunities for wealth-building and personal success.\n\nGlobal Coin Reserve created their very own cryptocurrency called “GCR Coins”. GCR coins are no different then other cyyptocurrencies like litecoin, namecoin and feathercoin, the only difference is that GCR coins are not as widely used as the rest or not used at all.\n\nGlobal Coin Reserve is a Multi-Level Marketing Company - similar to a pyramid scheme.', '**Collect** Cash Back Rewards From Any Merchant\n\n**Redeem** Cash Back Rewards At Any Merchant\n\nFree Mobile System\n\nFind Local Merchants\n\nView Local Promotions', 'Also Receive Award Points Equal to the Cash Back Reward\n\nRedeemable Exclusively At That Merchant\n\nRedeem Award Points for Additional Discounts and Fun Activities\n\nBe Rewarded for Your Loyalty', '', '2017-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MapCoin', 'MAPC', 'mapc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@mapcoinofficial', 'The coin is designed for shop/bar/store owners who want to give incentive for people coming to their locations ie pay coins for checking in.\n\nLater on there will be built in exchange where people will be able to exchange MAPC directly to BTC within the wallet/app.', 'They will be using Foursquare API and later on Google Maps API to let you checkin at choosen spots.\n\nYou will be able to get there MAPCoins for checkin option in the Swarm/Fouraquare APP or change them into BTC.\n\nTheir coin/app will allow people to get free MAPcoins for checkins at choosen spots - making the cryptocurrency popular this way.\n\nOn the start they will be an addon app to Swarm/Foursquare yet later we will want to join Google Maps.', 'Total supply: ~3,000,000 (3MM) \\[ 2228921.184 \\]\n\nPremine: 100% Premine\n\nDevs Premine: 1% (30000)\n\nAlgorithm: x11 (POS)\n\nPoS: 2% a year', 'X11', '2016-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'XiaoMiCoin', 'MI', 'mi.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.xiaomicoin.org/', '@she9888', 'They fully intend to implement the best practices, safe, fast, and secure transactions. Using the Kimoto Gravity Well, assures, that this coin is as fair as it is beautiful & practical. There are plenty of pump and dump coins out there. They simply do not believe in this get rich fast attitude.\n\nThey are developing an Android game that will reward XiaoMiCoin to Top Scores once per hour, with weekly, or even monthly Top Score Bonus\'s. It will have Facebook and Twitter integration, it will also be innovative and fun.', '', 'Chinese name: millet coins\n\nEnglish name: Xiaomioin\n\nEnglish abbreviation: MI\n\nDevelopers: millet currency development team\n\nCore algorithm: scrypt\n\nDate: June 15, 2015\n\nBlock Time: 60 seconds\n\nMonetary aggregates: 400000000 +\n\nPOW full pre-dug IPO after the first year of using POS 1% / year.\n\nThird one percent / year gradually decreasing.\n\nPOW + POS, 1% annual dividend, one minute to confirm,\n\n24 hours coins age\n\nPermanent node server IP：120.25.158.22\n\nIP: 121.42.12.176\n\nPort: 16789\n\nRpc port: 16889', 'Scrypt', '2016-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Paycon', 'CON', 'con_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@PayConX13', 'A revolutionary crypto based off some open source software. We plan to change the world by devoting 1 hour to making the client and building the world best website in under 5 minutes. Paycon promises to cure cancer, aids and all deadly diseases through the power of thought. World hunger?? We will fix that. PSN network down? Trust Paycon to save the day. Wonder who Satoshi Nakamoto is? We found him. Still looking for Kony? We caught him.\n\nPaycon will do everything you can imagine and more. With no buy support and a floor price so low we can even see it, Paycon will be the best investment you could make.\n\nVersion 2.0.1 comes with a the change of Multisend GUI which replaces the CON for Charity function. Multisend allows you to send up to 100% of your Stake to multiple addresses of your choosing. Link to the Cryptsy market has been added to the social/exchange tab and a small fix to the Hashsettings.', '\\- Built in Block explorer\n\n\\- Statistics page\n\n\\- Social/Exchange tab - Easily connect to popular exchanges, social media and built in IRC\n\n\\- MultiSend GUI - Automatically send up to 100% of your Stake on the 100th confirmation of a Staked Block to addresses of your Choosing\n\n\\- SplitBlock GUI - split your Blocks automatically into custom sizes.\n\n\\- Date range GUI in transactions - View Transactions based on a range, useful for determining Stakes within a given period.\n\n\\- Stake time estimates and Multisend on minting notifications.\n\n\\- ComboBox GUI for selection of Coins in Coin Control - Select Blocks based on Amount, Weight or Age.\n\n\\- Sorting of Blocks in Coin Control by Age, Weight or estimated time to Stake.', '**POW Block Rewards**\n\nPremine 50,000\n\n0-5000 250 Coins\n\n5001-15000 150 Coins\n\n15001-30000 75 Coins\n\n30001- 60480 50 Coins\n\nPOW Last Block 60480\n\nTotal POW Coins -2,449,000\n\n**POS Block Rewards**\n\n2 day Minimum Stake age\n\n14 day Maximum Stake age\n\nPOS Starts at block 7200 at 50% reward per year\n\nPOS changed to 30 Coins per Block at Block 50,000 (Feb 3rd, 2015)', 'X13', '2015-07-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Transfer', 'TX', 'tx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://txproject.io/', '@Transfer_dev', 'Transfer is a new cryptocurrency that will feature a uniquely implemented and decentralized p2p anonymization feature via Proof of Stake protocol extensions. Their decentralized network aims to be a fungible and untraceable digital medium of exchange. Transactions are lightning-fast at just 60 seconds confirmation time.Their main goal is availability on all possible devices and using all kinds of Internet services. Such as email, sms, social networks.\n\n**Latest Updates**\n\n1. Cross-Send was done completely custom by infernoman. (Cross-Send allows you to spend Transfercoin where Bitcoin is accepted.)\n2. MAC Wallet Trading. Transfercoin is the first to do this.\n3. Full implementation of secp256k1 for ecdsa sig\'s.\n4. Dark features working based off of dash 0.12.0. (Stealth addresses, Darksend,Encrypted Messaging, Masternodes)\n5. Staking and Masternodes in the same wallet. (If your running a masternode in your wallet)\n6. Masternodes and Staking in an Android Wallet.', '**Stability**\n\nWith Transferwallet you can start using the Transfer platform immediately. Even your android device is supported.\n\n**Fast transactions**\n\nEvery 60 sec. new block is generated. Transactions are almost instant\n\n**Up to Date**\n\nTransfer Block Explorer is a web tool that allows you to view information about the blocks, addresses, and transactions created by Transfer network.\n\n**Full automated TOR client in wallet.**\n\nTransfer utilizes the TOR network, an open-source utility trusted by millions to help protect their privacy.\n\n**Stealth addresses**\n\nAs crypto-currencies make their way into the mainstream of the world, privacy is of an increasing concern. They aim to provide an end-to-end privacy solution\n\n**Encrypted messages**\n\nEncrypted messages brings an encrypted and secure messaging system to Transfer. Send messages instantly, all you need is someones Transfer address and their public key\n\n**Masternodes**\n\nMasternode costs 10 000 TX and earn 50% of the mining rewards.\n\n**Android wallet**\n\nStaking with working masternodes and encrypted messages.\n\n**Made with Love**\n\nFair ditribution. TOR integration in coin, Stealth addresses, Masternodes. Staking Androind wallet with Masternodes. And more is coming.', '**Coin specifications**\n\n\\- Hybrid POW/POS\n\n\\- Algo x11\n\n\\- 60 sec per block\n\n\\- Difficulty adjusts every block coin maturity 80\n\n\\- Min. stake age 24 hours\n\n\\- POW 15 000 blocks\n\n\\- POW Block reward 300 TX per block\n\n\\- POS from block 1 000 to 15 000 block reward 300 TX per block\n\n\\- POS From block 15 001 onward block reward 1 TX per block.', 'X11', '2015-11-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Groestlcoin ', 'GRS', 'grs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.groestlcoin.org/', '@GroestlcoinTeam', 'It is a cryptocurrency utilizing Proof of Work – No ASIC currently exists for Groestl & it is unlikely that one will be developed for it anytime soon. GroestlCoin will be ASIC-free for the foreseeable future.\n\n\\- Through these features GroestlCoin embodies the fairly distributed & decentralized nature of Cryptocurrency. Anyone can mine effectively, with minimal resource consumption and nuisance. – With the influx of ASICs we thought decentralized mining will soon be dead, with GroestlCoin it is reborn and taken to another level.\n\n\\- The extra added value of Groestl is that the “richer advantage” (owning several GPU) is less interesting with Groestl; so fairer.\n\n\\- Stands for democratization of currency and mining, the ability to send and receive money immediately anywhere in the world, to not pay expensive banking fees, and to transact in an environment that is secure and anonymous.\n\n\\- Through an innovative algorithm, the Groestlcoin network consumes far less energy, maintains stronger security, and rewards miners in more sustainable ways than sha256, scrypt, x11 and x13 based coins. – Grostl will be the new greener home of GPU miners as it offers greater hashing results with less energy and heat.\n\n\\- They strive to make groestlcoin available to the masses. Innovative and user friendly, accessible for everyone. They highly value integrity and transparency. Digital currencies are the future and Groestlcoin will be one of the leaders in this revolution.\n\nThe name \"Grøstl\" is a multilingual play-on-words, referring to an Austrian dish usually made of leftover potatoes and pork, cut into slices. These are roasted on a pan together with onions and butterfat. The dish is often seasoned with salt, pepper, marjoram, cumin, and parsley, and served with a fried egg or kraut (cabbage). Hence, gröstl is somewhat similar to the American dish called hash. The letter ‘ö’ was replaced by ‘ø’, which is a letter in the Danish alphabet that is pronounced in the same way as ‘ö’. This way, the name, like the hash function itself, contains a mix of Austrian and Danish influences. The pronunciation of Grøstl may seem challenging. If you think so, then think of the letter ‘ø’ as the ‘i’ in \"bird\". This letter is a so-called close-mid front rounded vowel.\n\n[Groestl Specifications White Paper](http://www.groestl.info/Groestl-0.pdf \"Groestl\")', '\\- Is a cryptocurrency utilizing Proof of Work\n\n\\- No ASIC currently exists for Groestl & it is unlikely that one will be developed for it anytime soon. GroestlCoin will be ASIC-free for the foreseeable future.\n\n\\- Through these features GroestlCoin embodies the fairly distributed & decentralized nature of Cryptocurrency. Anyone can mine effectively, with minimal resource consumption and nuisance.\n\n\\- With the influx of ASICs we thought decentralized mining will soon be dead, with GroestlCoin it is reborn and taken to another level.\n\n\\- The extra added value of Groestl is that the \"richer advantage\" (owning several GPU) is less interesting with Groestl; so fairer.\n\n\\- Stands for democratization of currency and mining, the ability to send and receive money immediately anywhere in the world, to not pay expensive banking fees, and to transact in an environment that is secure and anonymous.\n\n\\- Through an innovative algorithm, the Groestlcoin network consumes far less energy, maintains stronger security, and rewards miners in more sustainable ways than sha256, scrypt, x11 and x13 based coins.\n\n\\- Grostl will be the new greener home of GPU miners as it offers greater hashing results with less energy and heat.\n\n\\- We strive to make groestlcoin available to the masses. Innovative and user friendly, accessible for everyone. We highly value integrity and transparency. Digital currencies are the future and Groestlcoin will be one of the leaders in this revolution.', '**About the algorithm:**\n\n\\- Is an iterated hash function, where the compression function is built from two fixed, large, different permutations. The design of Grøstl is transparent and based on principles very different from those used in the SHA-family.The two permutations used are constructed using the wide trail design strategy, which makes it possible to give strong statements about the resistance of Grøstl against large classes of cryptanalytic attacks. Moreover, if these permutations are assumed to be ideal, there is a proof for the security of the hash function.\n\n\\- Can and is accelerated by the hardware AES support present in most modern Intel CPUs, which helps reduce the efficiency gap between a CPU and other implementations. Groestl (old GPU/CPU) - Groestl makes wide range of trade-offs between throughput, latency, and power consumption. Because of this, groestl uses less power per hash than other algos. Due to the less complex hashing, groestl performs well on older GPU’s as well as CPU’s.\n\n\\- Is the single most efficient algorithm for GPUs in the cryptocurrency market. It has been shown to have the lowest power consumption, heat and noise of recently released algorithms, allowing for a quieter and more effective mining environment.\n\n\\- Is set to be the future of mining, Groestlcoin is proud to be the first to utilize this new efficient algorithm.\n\n\\- Is a recently proposed cryptographic hash algorithm that has common structure and features with the Advanced Encryption Standard (AES). The objective of this paper is to present the design of a high speed joint implementation of Grøstl and AES with minimal resources using a pipelining method. The advantage of this implementation is that it efficiently provides both cryptographic hash function and block cipher. The system is targeted to the Altera Cyclone IV FPGA. The paper presents a complete description of the design and implementation, as well as an analysis of the resulting synthesis and comparison to other proposed implementations of the Grøstl hash function.\n\n\\- Is a byte-oriented SP-network which borrows components from the AES. The S-box (substitution-box) used is identical to the one used in the block cipher AES and the diffusion layers are constructed in a similar manner to those of the AES. As a consequence there is a very strong confusion and diffusion in Grøstl.\n\n\\- Is a so-called wide-pipe construction where the size of the internal state is significantly larger than the size of the output. This has the effect that all known, generic attacks on the hash function are made much more difficult.\n\n\\- Has good performance on a wide range of different platforms and counter-measures against side-channel attacks are well-understood from similar work on the AES.\n\n**About the AES acceleration:**\n\nThe compression function f is based on a pair of 256- or 512-bit permutation functions P and Q, and is defined as:\n\nf(h, m) = P(h ⊕ m) ⊕ Q(m) ⊕ h\n\nThe permutation functions P and Q are heavily based on the Rijndael (AES) block cipher, but operate on 8×8 or 8×16 arrays of bytes, rather than 4×4. Like AES, each round consists of four operations:\n\n1.AddRoundKey (the Grøstl round keys are fixed, but differ between P and Q)\n\n2.SubBytes (this uses the Rijndael S-box, allowing sharing with AES implementations)\n\n3.ShiftBytes (expanded compared to AES, this also differs between P and Q, and 512- and 1024-bit versions)\n\n4.MixColumns (using an 8×8 matrix rather than Rijndael\'s 4×4)\n\nGrøstl divides the input into blocks and iteratively computes hi = f(hi-1, mi). However, Grøstl maintains a hash state at least twice the size of the final output (512 or 1024 bits), which is only truncated at the end of hash computation.', 'Groestl', '2015-10-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Siacoin', 'SC', 'sc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://sia.tech/', '@NebulousLabs', 'Sia is an actively developed decentralized storage platform. Users all over the world contribute disk storage from their computers to form a decentralized network.\n\nAnybody with siacoins can rent storage from hosts on Sia. This is accomplish via \"smart\" storage contracts stored on the Sia blockchain. The smart contract provides a payment to the host only after the host has kept the file for a given amount of time. If the host loses the file, the host does not get paid.\n\nThe distrubuted nature of the Sia network enables many optimizations in latency, throughput, reliability, and security. The decentralized nature of the Sia network enables anyone with storage to get paid, lowering the barrier to entry and reducing the overall price of cloud storage.\n\nThe Sia cryptocurrency is live! You can rent storage using siacoins and hosts providing storage to the network receive compensation in the form of siacoins. The storage platform itself is still in beta, and only uploads that are 500mb or less in size are supported by the wallet.', 'Sia uses a new cryptocurrency, called the siacoin. The developers will mine the first 100 blocks or so before releasing the code + miner to the public. Other than these first blocks, there is no premine for siacoins. The first block reward will be 300,000 siacoins. Each block reward after that will be one siacoin smaller than the previous block reward (299,999, then 299,998, and so on). When the block reward reaches 30,000, all remaining blocks will give a 30,000 siacoin reward. The block time is 10 minutes. Each siacoin is composed of 10^24 indivisible units.\n\nThe most important features of Sia can only be accessed by using siacoins. All storage contracts and all Sia payment channels require owning siacoins. This requirement means that as Sia grows in usage, so too will demand for siacoins. As demand grows, the price will increase. If Sia is being used for billions of dollars of storage, billions of dollars of siacoins will be required. The value of the siacoin is inextricably tied to the amount of storage in use on the Sia network.\n\nSia has a second cryptocurrency, called the Siafund. 3.9% of all successful storage contract payouts go to the holders of the siafunds. There are 10,000 siafunds total, and all 10,000 are completely premined. Sia\'s parent company, Nebulous Inc., holds approximately 8750 of these siafunds. The remaining siafunds were sold in a crowdfund which helped to finance Sia\'s early development. The primary goal of siafunding is to provide a way to finance the development of Sia without relying on donations or a premine. More people using Sia means more funding available to hire more developers.\n\nStandard transactions are not subject to the fee, and neither are failed storage contracts (where the host was offline or lost the file).', 'The foundation of Sia is a proof of work blockchain. Storage contracts are a new type of transaction that get enforced by the blockchain. Sia\'s hashing algorithm is blake2b. p2pool and multisig wallets are both supported on Sia.\n\n When a file is uploaded to Sia, a storage contract is created containing the Merkle root of the file, a reward for the host, and a penalty for the host (both in siacoins). After an agreed-upon duration, the host is required to prove that the file is still available by providing a random Merkle proof. If the proof is valid, the host is rewarded; otherwise, the host is penalized. Random numbers are generated deterministically using the most recent block as a seed.\n\nSia has support for two way payment channels, and two way contract diffs. Among other things, this provides massive scalability, and eliminates the need for untrustworthy 0-confirmation transactions. Once you join a payment channel network, all transactions within that network will be instant and final, with no risk of a double spend.\n\nReliability is achieved by using erasure coding in a massively distributed environment. Erasure coding allows a file to be split into many pieces, such that the original file can be recovered using only a few of them. For example, you can take a 50 MB file, break it into 200 pieces that are 1 MB each, and then you can recover the original file from \\*any\\* 50 of the pieces. This method has the same overhead as creating 4 complete copies of the file, yet is much more reliable because it\'s much less likely that 151 out of 200 hosts will go offline than it is that 4 out of 4 hosts will go offline.\n\nAs the network grows, we will apply statistical analysis to determine the redundancy required to provide 99.9999% reliability on files. It is likely that 3x overhead is absurd overkill, and statistical analysis will give an accurate picture of how much overhead is required.\n\nUsing 200 hosts to store a file means that downloads can be massively parallel. Even if the average Sia host does not have quick upload speeds, the massive parallelism enabled by Sia means that downloads will be blazing fast anyway. In addition, you can choose to connect only to the datacenters that are the closest and the fastest. This optimization (known as a CDN) is a hugely expensive project for a traditional cloud storage service, but for Sia it is a natural consequence of the decentralized network.\n\nAs security is a top priority of Sia, all encryption is performed locally; the people storing your files will have no ability to see what you have uploaded. Not only is every file encrypted separately, every \\*piece\\* of every file is encrypted separately, and hosts are not told which pieces are part of the same file.', 'Blake2b', '2015-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CleverCoin', 'CLV', 'clv.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS/PoW', NULL, NULL, '**PoW/PoS coin that seems to be a scam.**\n\n**Clevernodes**\n\nMuch like masternodes, the objective of clevernodes will be to keep CLV off the market by rewarding big investors for \"holding\".\n\nTo run a clevernode you will need to have 25,000 (this number is still being discussed), this 25,000 will need to have been in your wallet for at least 2 weeks, you can think about it as a the clevernode minimum stake age.\n\n**How will payments work?**\n\nPayments relative to the past month will be made every 1st of next month. To be eligible for the payment you will need to, in the previous month have staked at least 25,000 CLV for at least 2 weeks.\n\n**How much will be paid?**\n\nClevernode owners will receive the equivalent to triple the normal stake (9 \\* 3 = 27%/year) over the coins that staked for at least 2 weeks.\n\nWith clevernodes we hope to increase Clevercoin\'s value while rewarding the investors that are supporting the project. If you have any suggestions/commentaries please tell us, this is the time to.\n\nEXAMPLE:\n\nTom stakes 30,000 CLV for 3 weeks in July 2015. He will receive, in his wallet in August 1st, 675 CLV.', '', '**Maximum number of coins:** 2 Millions\n\n**Block time:** 64 seconds\n\n**Minimum stake age:** 48 hours\n\n**No maximum stake age.**\n\n**PoS reward schedule**\n\n**Block 1 - 10,000:** 2 CLV\n\n**Block 10,000 - 30,000:** 75 CLV\n\n**From block 30,000:** 9% / year', '', '2015-09-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Factoids', 'FCT', 'fct.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://factom.org/', '@factomproject', '**Blockchain to Business and Governments**\n\nFactom is a system for securing millions of real-time records in the blockchain with a single hash.\n\nBusinesses and governments can use Factom to simplify records management, record business processes, and address security and compliance issues.\n\nFactom uses the blockchain to power a remarkable range of applications, including audit systems, medical records, supply chain management, voting systems, property titles, legal applications, and financial systems.\n\nDownload the [Factom Whitepaper](https://github.com/FactomProject/FactomDocs/blob/master/Factom_Whitepaper.pdf?raw=true) to understand out how business and governments can use the blockchain technology to improve their services and their profit margins.', 'Factoids are traded on Poloniex under the ticker – “FCT”, making the whole project more approachable for novice users. The ticker “FCT” coupled with “Factom Exchange” should make it a lot easier for anyone to find the software tokens on Poloniex. It’s not necessary to know all the technical aspects regarding Factom or Factoids to reap the benefits of this platform.\n\nInvestors have been eagerly awaiting the addition of Factoids on major cryptocurrency exchanges since the conclusion of the Factom token sale. Factoids trading on crypto-exchanges are likely to generate additional interest in the Factom platform while allowing new community members to purchase some tokens for future use.\n\nIn preparation for the launch of the Factoids trading market on Poloniex, the Factom team also released the binaries and installers for the project’s software client recently. The Factom client provides a convenient manner of storing and transferring Factoids.', '**Will Factoids have their own blockchain?**\n\nUltimately Factoids will be implemented on their own Chain in Factom. For the crowd sale, other options are possible.\n\n**How are Factoids created?**\n\nTwo ways. Factoids will be created as a part of the crowd sale. Secondly, Factoids will be created at a fixed rate and paid to the Factom Servers and Audit Servers for their work running the system, and to pay other incentives.\n\n**Is there a separate Proof of Work or other consensus mechanism for factoids, independent of factom?**\n\nNo. That said, the Factom chain and the Entry chain are managed by the Factom Servers (they are the application using these chains) so they validate them in real time. No invalid entries can be placed in these chains.\n\n**How do factoids get sent back to the protocol? Is it a kind of burn?**\n\nNo. The Entry Credits are burned. Entry Credits are non transferable. They can only be used to buy entries. But when they DO buy entries, the Factoid in the protocol that was used to buy the Entry Credits is released. The amount of Factoids varies since the price of Entry Credits per Factoid varies.\n\nThe Factoid paid out is calculated by dividing the total number of Factoid in the protocol by the number of outstanding Entry Credits.\n\nThe number of Factoids in the protocol and the number of outstanding Entry Credits are all computable from the Entry Chain and the Factoid Chain.', '', '2015-05-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LyraBar', 'LYB', 'lyb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@LyraBar', 'LyraBar is a new cryptocurrency based on its own algorithm Lyra2RE. The coin has been mined since january 2015.\n\n\\- 2.5 minute block targets  \n\\- 1971000 total LYB  \n\\- 5 coins per block  \n\\- Block reward will half at blocks 210240, 420480, 630720 (one year between each)  \n\\- Last PoW block is 840960  \n\\- Difficulty retargeting with Kimoto\'s Gravity Well  \n\\- Stealth addresses (experimental, use at own risk)', '', 'New algorithm Lyra2RE white paper[](https://vertcoin.org/downloads/Vertcoin_Lyra2RE_Paper_11292014.pdf)', 'Lyra2RE', '2016-09-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitStone', 'BST', 'bst.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://factom.org/', '@BitStone_Devs', 'BitStone is an X11 Proof of Work and Proof of Stake Crypto currency with a 12% annual rate and based on the X11 algorithm. The block time is limited to 60 seconds and the minimum staking age is three hours. The Proof of stake kicks in at block 700 - or about 11 hours after inception.', '', '', 'X11', '2016-03-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Prime-X1', 'PXI', 'pxi.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://prime-xi.com/', '@OfficialPXI', 'Prime-X1, or PXI, is an X11 based alternative crypto currency released in July 2014. The coin supply is infinite with block time of 25 seconds and 5 PXI issued per block. The difficult adjustment operates of the Dark Gravity Wave v3. There were 30,000 PXI premined to fund further development.', '', '', 'X11', '2015-08-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CapriCoin', 'CPC', 'cpc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://capricoin.com/', '@Capricoin_Team', 'CapriCoin, or CPC, is a crypto currency based on the X11 algorithm and is both proof of stake and proof of work. The coin has a large premine of 200,000,000 of the total supply of 208,000,000 - 25% is distributed - 50 million is reserved for staisybit and 99 million reserved for inhouse staking... and 1 million reserved for the development team. The proof of stake drops from 2% by 50% increments per year to year 24. The coin has a large premine which looks to be unethical.', '', '', 'X11', '2016-08-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Amsterdam Coin', 'AMS', 'ams.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.amsterdamcoin.com/', NULL, 'Amsterdam Coin, AMS, aims to be the crypto currency for Amsterdam using a ToR client to obfuscate transactions. The coin is a quark based algo with a proof of work element lasting 840000 blocks with a block reward of 10 AMS per block. The block time is 60 seconds and the proof of stake has an 8% reward.', '', '', 'Quark', '2016-02-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Obits Coin', 'OBITS', 'obits.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://obits.io/', '@Open_Bits', 'Obits is more than just a Crypto Currency - it is a token of ownership. Although innovative in its nature, the Obits Tokens were sold off market prior to December 2015 from the creator, CCEDK, and allocation during the Genesis block - after the first of December OBITS is gradually being released onto the market. That said the Crypto Asset/Token is essentially a pathway to gaining exposure to the nascent crypto space.\n\nThe Obits token denominates ownership in a profit sharing arrangement between various organisations such as Openledger, CCEDK exchange, Biteaser advertising platform & ShareBits. At the time of writing only openledger is actively contributing towards the Obits Token profits. Please see the technology page to understand more about how openledger profits are generated and used to buyback obits.\n\nAll transactions made on the platform are verifiable on the blockchain. Any user can therefore audit the profits generated by the company in real time. Since the blockchain ensures full transparency, unlike conventional banking systems, stakeholders and shareholders will be able to ensure they are not being cheated. This will also add a novel dimension to share trading as it will allow for real time disclosure of Company revenues.\n\nThe Obits buyback program will occur at regular intervals, just like government bond auctions, with the first in February 2016. The idea is that out of the 18,276,898 issued at launch the profits will then be used to reduce the number of coins in supply - like a traditional stock buyback if the number of shares is reduced then the value of each share will be increase. The opposite could be true too with dilution taking place if the network of Companies involved decides to add other Companies to its network and justify it with the addition of further OBITS.\n\nAs it is a essentially a stock crossed with an affiliate agreement depending on the future profits of a group of companies - there is high levels of risk involved. But again an innovative and novel idea as in most jurisdictions the heavy compliance costs for widows and orphans investments have been bypassed in a crowd funding manner using Crypto Asset Technology based on Bitcoin.', 'OBITS token owners are entitled to a proportional share of the profits on OpenLedger and any further projects added in the future. These profits will be paid in the form of buy-backs.\n\nOpenLedger profits come from a broad range of sources:\n\nFees incurred during registration   \n40% of all fees from registration directly on Openledger -reg with no prior lifetime or annual member as referrer.   \n10% of all fees from registration on Openledger-reg in case of sign-up via lifetime member.  \n25% of all fees from registration on Openledger-reg in case of signup via annual member referrer.\n\nFees incurred during BTS transactions performed on the platform and shown on the blockchain.  \n40% of all fees from users signing up on Openledger-reg with no prior Life time or annual member as referrer.  \n10% of all fees from users signing up on Openledger-reg in case of signup via lifetime member.  \n25% of all fees from registration on Openledger-reg in case of sign-up via annual member referrer.\n\nFees incurred during trading transactions on Open assets.  \nTotal of all 0.2% transaction fees incurred during trading of all current and future Open assets between OpenBTC, OpenLTC, OpenDOGE, OpenDASH, OpenMUSE, OpenPPC, OpenUSD, OpenEUR, OpenCNY, OBITS and QBITS, and any other assets on the platform that will be traded in the future with these Open assets. Openledger profits and connected projects are used for compulsory redemption of tokens on the first day of the month from the token owners, with 100% of profits used in the buy back. The buy-back option is possible at OpenLedger only, taking into consideration features of all other financial assets and the annual inflation rate, which reduces the true income of investors (thought to be at least 10% per year).\n\nProfits generated from referral programs  \nWhether for OpenLedger, OBITS or any other account involving any of the projects mentioned, these fees will be added in full (100%) to the value of OBITS.\n\nOBITS uses a new approach to increase investors’ capital and the value of this token/cryptocurrency. Destruction of tokens purchased at buy-back will implicit cause the appreciation of the remaining tokens. You can find out more here.  \nToken owners can lock in their profits by selling their OBITS at Openledger or other participating exchanges, using the order book..', 'Technology\n\nThe BitShares platform itself is run and maintained by the BitShares community–an open consortium of individuals and organizations committed to providing universal access to the power of smart contracts.\n\nWorking together, this community has designed and developed the BitShares platform to include numerous innovative features which are not found elsewhere within the smart contract industry:\n\n  \nPrice-Stable Cryptocurrencies - SmartCoins provide the freedom of cryptocurrency with the stability of the dollar\n\nA SmartCoin is a cryptocurrency whose value is pegged to that of another asset, such as the US Dollar or gold. SmartCoins always have 100% or more of their value backed by the BitShares core currency, BTS, to which they can be converted at any time at an exchange rate set by a trustworthy price feed. In all but the most extreme market conditions, SmartCoins are guaranteed to be worth at least their face value (and perhaps more, in some circumstances). Like any other cryptocurrency, SmartCoins are fungible, divisible, and free from any restrictions.\n\nDecentralized Asset Exchange - A fast and fluid trading platform\n\nBitShares provides a high-performance decentralized exchange, with all the features you would expect in a trading platform. It can handle the trading volume of the NASDAQ, while settling orders the second you submit them. With this kind of performance on a decentralized exchange, who needs risky centralized exchanges?\n\nIndustrial Performance and Scalability - Graphene is capable of 100,000 TPS when we pay for the network to go with it\n\nHigh performance blockchain technology is necessary for cryptocurrencies and smart contract platforms to provide a viable alternative to existing financial platforms. BitShares is designed from the ground up to process more transactions every second than VISA and MasterCard combined. With Delegated Proof of Stake, the BitShares network can confirm transactions in an average of just 1 second, limited only by the speed of light.\n\nDynamic Account Permissions - Management for the corporate environment\n\nBitShares designs permissions around people, rather than around cryptography, making it easy to use. Every account can be controlled by any weighted combination of other accounts and private keys. This creates a hierarchical structure that reflects how permissions are organized in real life, and makes multi-user control over funds easier than ever. Multi-user control is the single biggest contributor to security, and, when used properly, it can virtually eliminate the risk of theft due to hacking.\n\nRecurring & Scheduled Payments - Flexible withdrawal permissions\n\nBitShares is the first smart contract platform with built-in support for recurring payments and subscription payments. This feature allows users to authorize third parties to make withdrawals from their accounts within certain limits. This is a convenient way to “set it and forget it” for monthly bills and subscriptions.\n\nReferral Rewards Program - Network growth through adoption rewards\n\nBitShares has an advanced referral program built directly into its software. Financial networks derive their value primarily from their network effect: more people on the same network increases the value of that network for everyone. BitShares capitalizes on this by rewarding those who sign up new users, and does so in a fully transparent and automated way.\n\nUser-Issued Assets - Regulation-compatible cryptoasset issuance\n\nThe BitShares platform provides a feature known as \"user-issued assets\" to help facilitate profitable business models for certain types of services. The term refers to a type of custom token registered on the platform, which users can hold and trade within certain restrictions. The creator of such an asset publically names, describes, and distributes its tokens, and can specify customized requirements, such as an approved whitelist of accounts permitted to hold the tokens, or the associated trading and transfer fees.\n\nCollateralized Bond Market - Integrated peer-to-peer lending\n\nThe BitShares bond market is an investment marketplace accessible to anyone with an internet connection. In the bond market, you can earn interest with any asset, or take a short position using any other asset as collateral. (Coming Soon)\n\nStakeholder-Approved Project Funding - A self-sustaining funding model\n\nBitShares is designed to be self funding and self-sustaining by giving the stakeholders the power to direct where blockchain reserves are spent. BitShares has a reserve pool of 1.2 billion BTS (about $8 million dollars) that automatically grows as transaction fees are collected and the share price rises. Each day, the blockchain is authorized to spend up to 432,000 BTS (about $77,000 per month), which is enough to hire a small team to maintain the network for years, even with no price appreciation.\n\nTransferable Named Accounts - Easy and secure transactions\n\nNamed accounts enable users to easily remember and communicate their account information. We don\'t use IP addresses to browse the internet or numbers to identify our email, so why shouldn\'t we have human-friendly account names for our financial transactions?\n\nDelegated Proof-of-Stake Consensus - A robust and flexible consensus protocol\n\nDelegated Proof of Stake (DPOS) is the fastest, most efficient, most decentralized, and most flexible consensus model available. DPOS leverages the power of stakeholder approval voting to resolve consensus issues in a fair and democratic way. All network parameters, from fee schedules to block intervals and transaction sizes, can be tuned via elected delegates. Deterministic selection of block producers allows transactions to be confirmed in an average of just 1 second. Perhaps most importantly, the consensus protocol is designed to protect all participants against unwanted regulatory interference.', '', '2015-01-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, ' ClubCoin', 'CLUB', 'club.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://clubcoin.co/', '@Clubcoin_co', 'Clubcoin is a peer-to-peer digital currency that has a decentralized and consensus based system where all transactions are viewed in a public ledger. Which means nobody has control and everything is completely transparent to everyone on the network.\n\nThis type of distributed network allows the coin to function without having to trust anyone. The concept of all digital currency is taking the control out of a central authority and putting it where it belongs... In the hands of the people!\n\nWith Clubcoin you can transfer money between accounts with ease. You can send any amount to any other person and they will receive it fast and be able to spend it once the transaction is confirmed by the network.\n\nCoin added by [@chopcoin](http://chopcoin.io) Team', '**Large Distribution & Low Inflation**  \n  \n78.5 million ClubCoin was mined to start and these coins are being distributed to BitClub Network members. See disclaimer below. No new coins will be created using Proof-of-Work method, all new coins will be issued from the 20% yearly interest paid to holders of ClubCoin who are staking their coins. This drops in half every 2 years.  \n   \n  \n**Built-in Users = Adoption**   \nClubCoin was first introduced to BitClub Network members as a strategic way to distribute the coins across a global network of users. This model gives ClubCoin a unique advantage over most coins in the market as it will continue to be issued and distributed worldwide to a fast growing user base.  \n   \n  \n**Blockchain Security**   \nClubCoin has it\'s own Blockchain and distributed network of nodes that make it very secure against attacks and hard to get 51% consensus. Other digital currencies that are only Proof-of-work face issues due to their reliability on large-scale mining operations. ClubCoin also boasts a powerful Block Explorer.  \n   \n  \n**Merchant Platform**   \nA new Merchant Platform is being built that will allow online and brick & mortar businesses to accept ClubCoin risk free, within a secure and reliable environment. Since many members will be eager to use this platform we have created a very strategic way to sign up new merchants. We have big plans for ongoing development of the entire ClubCoin ecosystem.', '', 'Scrypt', '2016-05-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Radium', 'RADS', 'rads.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://radiumcore.org/', '@ProjectRadium', 'Radium is the new look and function of xRadon - the original base of Project Radon. The goal of Project Radon is to deliver a variety of 100% decentralized services using the blockchain. Radium is the base blockchain, upon which all current services are built. Radium blockchian services are accessed through the [Radium SmartChain](https://bitcointalk.org/index.php?topic=1322856.0). The SmartChain expands the utility of Radium far beyond that of a standard coin, with features such as Username-Address linkage and Proof-Of-Existences all 100% distributed within the blockchain. See the Radium SmartChain thread [here](https://bitcointalk.org/index.php?topic=1322856.0) for full list of functions and development goals.\n\nCoin added by [@chopcoin](http://chopcoin.io) Team', '', '', '', '2017-07-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Emercoin', 'EMC', 'emc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://emercoin.com/', '@EmerCoin_EMC', 'Hybrid of NameCoin and PPCoin. More focused on the production of coins by PoS than PoW. Mining has a bonus on the interval 1-512 difficulty for high initial issue of coins. Further difficulty will gradually increase, making PoS mining more promising.\n\nEmercoin offers a 6% annual POS reward with 30 day coin maturity.\n\nCoin added by [@chopcoin](http://chopcoin.io) Team', '\\- Secure shell management system needed by every site admin.\n\n\\- System for passwordless authentication on the world wide web.\n\n\\- Storage for electronic business cards for use with EMCSSL.\n\n\\- Uncensored domain name system, peering with OpenNIC.\n\n\\- Trusted storage for digital timestamps on the blockchain.\n\n\\- Distributed torrent tracker for internet file sharing.\n\n\\- Decentralized pay-per-click advertising network.\n\n\\- Digital proof of ownership solution for physical or digital goods and services.', '', 'SHA256', '2013-08-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BlitzCoin', 'BLITZ', 'blitz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@bitalize', '[Blitz](https://bitcointalk.org/index.php?topic=848186.0) is a decentralized crypto currency which seeks to provide real world application of blockchain technology through the tools and platform Bitalize has to offer.\n\nCoin added by [@chopcoin](http://chopcoin.io) Team', '**Large Distribution & Low Inflation**  \n  \n78.5 million ClubCoin was mined to start and these coins are being distributed to BitClub Network members. See disclaimer below. No new coins will be created using Proof-of-Work method, all new coins will be issued from the 20% yearly interest paid to holders of ClubCoin who are staking their coins. This drops in half every 2 years.  \n   \n  \n**Built-in Users = Adoption**   \nClubCoin was first introduced to BitClub Network members as a strategic way to distribute the coins across a global network of users. This model gives ClubCoin a unique advantage over most coins in the market as it will continue to be issued and distributed worldwide to a fast growing user base.  \n   \n  \n**Blockchain Security**   \nClubCoin has it\'s own Blockchain and distributed network of nodes that make it very secure against attacks and hard to get 51% consensus. Other digital currencies that are only Proof-of-work face issues due to their reliability on large-scale mining operations. ClubCoin also boasts a powerful Block Explorer.  \n   \n  \n**Merchant Platform**   \nA new Merchant Platform is being built that will allow online and brick & mortar businesses to accept ClubCoin risk free, within a secure and reliable environment. Since many members will be eager to use this platform we have created a very strategic way to sign up new merchants. We have big plans for ongoing development of the entire ClubCoin ecosystem.', '', 'X13', '2015-05-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitHIRE', 'HIRE*', 'hire_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.bithire.info/', '@Bithire', 'Bithire is a global online market place for offering services and acquiring services. Bithire uses Bitcoin and the blockchain for providing a secure and decentralised payment solution. In addition, members can utilize our in-site currency HIRE token for micro-tipping, redeeming rewards, and more!\n\nCoin added by [@chopcoin](http://chopcoin.io) Team', '', '', 'Scrypt', '2015-06-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EverGreenCoin', 'EGC', 'egc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://evergreencoin.org/', '@EverGreenCoin_', 'EverGreenCoin is a currency designed from the ground up not only to be an environmentally friendly currency but, an environmental movement and paradigm shift. With both the electrically and computationally efficient and secure algorithm of X15 Proof of Work and it\'s generously rewarding 7% Proof of Stake the foundation has been set. On top of that foundation we leverage renewable energy in ways our planet has never seen.\n\nEverGreenCoin is turning the mining and crypto currency industry on its head. From an industry that wastes electricity in the grandest scale, and in-turn our planet\'s finite precious resources lost forever to produce that electricity, to a profitable and prosperous endeavor for both our planet and it\'s people. Back-feeding the grid it had once robed. Then those profits are invested into the environment through environmental restoration projects such as forestry and wildlife rehabilitation. EverGreenCoin will make both our planet\'s environment and economy better than it was found.\n\nCoin added by [@chopcoin](http://chopcoin.io) Team', '', '', 'X15', '2015-01-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MindCoin', 'MND', 'mnd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@MindCoinCrypto', 'MindCoin is being launched to raise awareness of Mental Health Issues that many people face and to release a positive and charitable Crypto Currency.  \n  \nAbout one quarter of people will experience some kind of mental health problem in the course of a year, with mixed anxiety and depression. Mental health problems are found in people of all ages, regions, states, countries and societies. Did you know suicide remains the most common cause of death in men under the age of 35?  \n  \nWhen people talk about mental health problems, most people jump the gun and think of Depression and Anxiety, Whilst these are two of the most common problems there are many more. To list a few.  \n  \nBipolar Disorder, Eating Disorders (Bulimia), Anorexia, PTSD, OCD, Schizophrenia, Autism, ADHD, Tourettes, Insomnia, Narcolepsy, Dementia, Social, Conduct and Panic disorders.\n\nCoin added by [@chopcoin](http://chopcoin.io) Team', '', '', 'X11', '2015-04-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'I0coin', 'I0C', 'i0c.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://izerocoin.org/', NULL, 'I0coin has a good combination of transaction speed and security. 90 second confirmations make for quick transactions, so you can get on with your life. Network mining power ranked in the top 5% means your coins are super secure, for your peace of mind. I \"zero\" coin. Zero premine. Zero inflation by 2018. Zero gimmicks. I0coin doesn\'t play games with your money.\n\nCoin added by [@chopcoin](http://chopcoin.io) Team', '**Truly Borderless Transactions**\n\nI0coin is an international digital currency available anywhere on the planet. You just need internet access to use it. It\'s as easy to send money to the coffee shop next door or a relative in a far away land.\n\n**A Veteran Digital Currency**\n\nFirst released in August 2011, I0coin came before most other cryptocurrencies. It has a proven track record and is here to stay. Many newer cryptocurrencies are no longer supported.\n\n**Stable Service**\n\nMinimal footprint and reduced memory requirements provide a stable wallet and mining platform. Continuous updates mean you will always have the latest improvements in service and security.\n\n**Fully Decentralized**\n\nDecentralization means there are no single points of failure, so you have minimal hiccups or service disruptions. The I0coin network is always ready for business… or fun, 24/7.\n\n**Ultra Low Inflation**\n\nWith over 99% of its 21 million coins already in circulation, I0coin has one of the lowest inflation rates of any digital currency. Inflation will reach zero out to two decimal places by 2018.\n\n**Block Chain Pruning**\n\nPruning allows users to set the size of the block chain stored locally, which frees up disk space for other uses. Thin clients also allow for minimal web hosting costs for sites using I0coin.\n\nI0coin\'s specifications were chosen to provide the optimal balance across a broad spectrum of users. It\'s well balanced whether you\'re making a purchase, mining, or investing. The wallet requires only 425 MB of memory (fully synced). Its quick 90 second transaction confirmations make it excellent for making purchases, without being so fast as to sacrifice security. I0coin can be mined essentially for free since it is merge mined with Bitcoin. The maximum number of coins is permanently capped at 21 million, so you never need to worry about inflation devaluing your coins. This makes I0coin a great long term investment. Many other top coins, on the other hand, have unlimited coin supplies', '', 'SHA256', '2012-03-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Bata', 'BTA', 'bta.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.bata.io/', '@Bata_Money', 'Bata (BTA) is a peer-to-peer currency that enables instant, near-zero cost payments to anyone in the world. BTA is an open source, global payment network that is fully decentralized without any central authorities. Mathematics secures the network and empowers individuals to control their own finances. BTA features faster transaction confirmation times and improved storage efficiency than the leading math-based currencies. BTA has substantial industry support, trade volume and liquidity, BTA is a proven medium of commerce complementary to Bitcoin (BTC).\n\nCoin added by [@chopcoin](http://chopcoin.io) Team', '', '', 'Scrypt', '2017-04-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Karmacoin', 'KARM', 'karm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://karmacoin.info/', '@Karmacoingood', 'The Karmacoin community has created a currency that can be used to reward people for doing good. We see Karmacoin donation addresses appear in things like news articles about people who went above and beyond to be good. Soon after someone reads the article like that they will now have a way to reward the person who did good. In order build the community quickly so that there is currency for rewarding, there are larger bonuses for the first 400,000 blocks than after that. The founders are aligned with every individual - there has been no pre-mining.\n\nCoin added by [@chopcoin](http://chopcoin.io) Team', '', '', 'Scrypt', '2014-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Decred', 'DCR', 'dcr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://decred.org/', '@decredproject', 'Decred is an open, progressive, and self-funding cryptocurrency with a system of community-based governance integrated into its blockchain. At its core is a hybridized proof-of-work proof-of-stake (PoW/PoS) consensus system that aims to strike a balance between PoW miners and PoS voters to create a more robust notion of consensus. The project is a result of the theoretical proposals brought by proof-of-activity (PoA) and MC2 in 2013. Decred development started in April, 2014 with a single developer and expanded to include developers from btcsuite shortly thereafter.\n\nDecred is built in the spirit of open participation and we have provided below a full disclosure of the technical features of the system, wallets and mining, initial funding and distribution, project governance and development, and a group contribution timeline.\n\nDecred opted for a different funding model in an attempt to shift the risk carried by supporters to the developers of the project. Instead of asking interested parties to fund the development of the software, the developers decided to pool funds together and carry the project to completion before making it public. The consensus was that this is an ethical path given the realities of funding software development, due to the fact that the developers alone carry the risk of the project failing, whereas in the past potential users were expected to pay for coins before any code was written. We felt this was unjust.\n\nThe development of Decred was funded by Company 0 and from the pockets of its developers individually. The cost of developing the project, in terms of developer pay, totals to approximately USD 250,000, which Company 0 paid to developers. An additional amount of approximately USD 165,000 has been allocated for unpaid work and individual purchases by developers. We felt that the most equitable way to handle compensation for these expenses was to perform a small premine as part of the project launch. The model is unusual in that no developer received any amount of coins for free - all coins owned by developers will either be purchased at a rate of USD 0.49 per coin from their own pockets or exchanged for work performed at the same rate.\n\nThe premine consists of 8% of the total supply of 21 million coins, meaning the premine consists of 1.68 million coins. Rather than allocating the entire premine to the bring-up costs, we decided to split the premine equally between compensation for bring-up and an \"airdrop\", where we freely give an equal amount of coins to a number of airdrop participants. This means Company 0 and its developers will have put roughly USD 415,000 into the bring-up since April, 2014 and receive 4% of the total supply, 840,000 coins (at USD 0.49 per coin). The remaining 4% will be spread evenly across a list of airdrop participants as part of an effort to build the Decred network and decentralize its distribution. Coins held by Company 0 will be used to fund its ongoing work on open-source projects, such as Decred and btcsuite.\n\nGiving away these coins in an airdrop allows us to accomplish several things at once for the project: enlarge the Decred network, further help decentralize the distribution of coins, and allow us to get coins into the hands of people who are interested in participating in the project. Decred is fundamentally about technological progress, so the airdrop will target individuals that have made contributions to advance technology in its various forms. The maximum number of airdrop participants is capped at 5,000 individuals, so we recommend registering sooner rather than later. These coins will be given away unconditionally and there is zero expectation of Decred receiving anything from you in return for these coins.\n\nSign up for the airdrop is currently open, but the airdrop registration will commence on January 4th, 2016. People who have been selected to participate in the airdrop will receive an email that contains a link to a web registration form. This form will require airdrop participants to enter an address to which their coins can be sent. Binaries and source code will be made available so that you can generate a wallet seed and an address for your airdrop coins. Once you have entered your receiving address into the airdrop webform and submitted it, you will receive your coins on the projected launch date.', 'In addition to the technical features that make up the technology, Decred as a project introduces several development and governance features and proposals to ensure and steer long-term growth. We encourage participants to discuss these topics earnestly, as we want to ensure the system of development and governance is built on a solid foundation.\n\n- A multi-stakeholder development ecosystem that welcomes and empowers participants who want to build new functionality and improve on existing features.\n- Any party can submit feature proposals and developers are paid for work to fulfill requirements. This is done in full view of the community in a system designed to fight against ingroup-outgroup dynamics.\n- The initial contributors are the developers responsible for btcsuite (est. early 2013 - present).\n- A proposal for a layered form of transparent meritocratic governance that extends beyond proof-of-work and proof-of-stake mechanisms to bring forward and represent insider and outsider voices in the community.\n- A proposal for bottom-up decision-making through the Decred Assembly, an evolving and inclusive list of community members who make non-financial contributions to the project through their work and effort.\n- The project is bound by the [Decred Constitution](https://wiki.decred.org/Decred_Constitution) on the core principles of finite issuance, privacy, security, fungibility, inclusivity, and progressive development of the technology that keeps these principles together.', 'The features below are implemented in Decred and will be available in full at launch. For a deeper description, please consult the [Decred Technical Brief](https://decred.org/dtb001.pdf).\n\n- Novel hybridized proof-of-work/proof-of-stake (PoW/PoS) consensus system - A decentralized lottery is used to select PoS miners to vote on PoW blocks. The PoW and PoS subsidies account for 60% and 30% of each total block subsidy, respectively. This system is based on that of MC2, which is very similar to, but developed independently from, Proof-of-Activity (PoA) by Iddo Bentov, Charles Lee, Alex Mizrahi and Meni Rosenfeld.\n- Cold staking and decentralized stake pooling - The ability to generate new coins without the risk of having your coins online when PoS mining. The PoS mining system has also been engineered with distributed, decentralized stake pooling in mind, so that even those with small amounts of stake can participate in network validation.\n- Internal voting system for the addition of new features and hard or soft fork selection - Both PoW and PoS miners can vote for features and issues through bit flags, providing a sensible mechanism for resolving disputes about the features of the blockchain.\n- Immutable transaction hashes (\"transaction IDs\") by separating transaction signatures from the rest of the transaction data - A permanent fix for transaction hash malleability has been implemented that prevents mutability of the transaction hash by separating it from its input signatures. This allows more efficient SPV validation. Fraud proofs have also been added.\n- Elliptic curve cryptography over secp256k1 with optional Curve25519 support - The Bitcoin scripting system has been modified to allow for simple, drop-in addition of new elliptical curve digital signature algorithms.\n- Schnorr signatures with threshold n-of-n support - In addition to supporting Schnorr signatures, groups of signers can now jointly sign transactions off-chain in constant size signatures, ensuring higher privacy and less blockchain bloat.\n- Script enhancements and new OP codes - New OP codes have been added to the existing Bitcoin scripting engine, and extensions for the plug-in use of future scripting engines have been added.\n- PoW mining using BLAKE256 hash algorithm - Inspired by Bernstein\'s Chacha stream cipher, SHA3 finalist BLAKE256 offers speed as well as high security.\n- Compatibility with Bitcoin transaction scripting system - Decred\'s scripting system has been derived from Bitcoin\'s with care in ensuring that all future updates to the Bitcoin transaction script will be easily extensible to Decred. Further, any newly created functionalities will also be devised with backwards compatibility with Bitcoin in mind.\n- Modularized, easy-to-use Golang btcsuite codebase - Thanks the to the codebase inherited from btcsuite, adding new features to the daemon or wallet will be facile. Decred will episodically sync updates from btcsuite, so that it benefits from the latest developments in Bitcoin.\n- Hierarchical deterministic (HD) wallets - Wallets use a seed to deterministically generate addresses, so your wallet can be restored from a single BIP0032 seed.\n- Transaction expiration - Transactions have a new expiration field to prevent inclusion into the blockchain after a certain height.\n- Patches for intrinsic Bitcoin bugs - Extra push for multisignature scripts has been removed, SIGHASH\\_SINGLE behavior has been corrected.\n- Approximately 21 million coins - Exponential decay in subsidy or the number of coins generated per year.\n- Self-funded development via block subsidy - In order to have an ongoing source of funding for development work, a consensus rule has been added to allocate 10% of each block subsidy to a development organization. This entity is transparent and responsible for funding development work performed by current and new developers so that the project remains sustainable without a funding dependence on outside forces in the future. Decred therefore improves with growth in a sustainable way and is accountable only to its users.', 'BLAKE256', '2016-08-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Nas2Coin', 'NAS2', 'nas2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://nascoin.net/', NULL, 'NAS2 is a new cryptocurrency, issued in February 2016, is based on the old [NasCoin](/coins/nas/overview). There was an issue during maintenance with NasCoin and all the coins were lost. The new NAS2Coin will have a reduced max coins from 10 billion to 200 million. Old NasCoin wallet balances will be replaced, in proportion of 50 to 1, by the a new Nas2Coin. The full conversion is expected to be completed by April 1, 2016 and after that the balances that have failed to be redeemed will be used as development and maintenance funds for Nas2Coin. A proportion of the un-redeemed coins will also be used by the Foundation in a marketing effort to promote the new Nas2Coin.\n\n_(We translated this from Chinese with google translate and tried to make sense of it)_', '', 'Based on Nubits, no breakthrough technology', '', '2017-10-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Pakcoin', 'PAK', 'pak.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.pakcoin.info/', '@pakcoinofficial', 'Pakcoin is premier digital currency for Pakistan. It is based on Litecoin and is 1% premined. These premined coins will be used for development and airdrop to Pakistanis.(<http://www.pakcoin.info/airdrop/>)\n\n**THE BENEFITS OF PAKCOIN** - Nearly instant transactions with a nearly impossible risk of fraud due to the unbreakable security Cryptocurrencies have to offer Mine-able by everyone however 150,000 Pakistanis will receive 50 Pakcoins for free through airdrop Zero or very low processing fees when sending Pakcoins around the world\n\n**FAIR MINING** - 182 Million Pakcoins (PAK) will be created by people like you through a process called mining. 1% has been pre-mined; 75 Million of that will be divided between the first 150,000 Pakistanis. The remaining PAK will be used for further development of the coin, marketing and merchant services in Pakistan.\n\n**INTEGRATION ASSISTANCE** - Working on a web or software project and thinking about integrating Pakcoin? Developers are standing by to help. You may be eligible for a bounty reward, our way of thanking you. **DOWNLOAD AND TRY** - You can download the wallet software in our download page and then start claiming your 50 Free Pakcoins if you are a Pakistani\n\nWallets: <http://www.pakcoin.info/wallets/>', '**Name:** Pakcoin  \n**Symbol:** PAK  \n**PoW Algorithm:** scrypt  \n**Block Time:** 60 Seconds  \n**TX fee:** 0 – 0.1 PAK depending on your amount  \n**Difficulty Retarget:** 24 Hours  \n**P2P Port:** 7867  \n**RPC Port:** 7866  \n**Testnet:** 17866  \n**Premine:** 1 % for development and Airdrop  \n**Max Coins:** approximately 182 Million PAK  \nMining Reward: 50 PAK per block, halving every 3 years', '', 'Scrypt', '2016-10-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Creditbit ', 'CRB', 'crb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://www.creditbit.org/', '@credit_2', 'Creditbit is an ERC20 token.', '**Open Source**\n\nCreditbit is an open source software project released under the MIT/X11 license which gives you the power to run, modify, and copy the software and to distribute, at your option, modified copies of the software. The software is released in a transparent process that allows for independent verification of binaries and their corresponding source code.\n\n**Decentralized**\n\nThere are no borders, no conversion fees, no delays, no centralized control. Every machine that mines creditbit and processes transactions makes up a part of the network, and the machines work together. That means that one central authority can’t tinker with monetary policy and cause a meltdown – or simply decide to take people’s creditbits away from them.\n\n**Easy**\n\nConventional banking is not available to 5 billion person, and it is a hassle for the other 2 billions, they make you jump through hoops simply to open a bank account. Setting up merchant accounts for payment is another Kafkaesque task, beset by bureaucracy. However, you can set up a creditbit address in seconds, no questions asked, and with no fees payable.\n\n**Free & Private**\n\nThere are no clearing company or any organization behind creditbit this means no fees. Sending transactions is free.\n\nYour personal informations are safe. No need to expose your information when generating addresses or when sending/receiving transactions.\n\n**Community**\n\nCreditbit has an open community, anyone can join and participate and build on the technology without the need of any permission, you also can join the developer team or pull requests directly on the main repos on Github.\n\n**Staking**\n\nCreditbit use something called staking, if you own coins you can earn up to 8% annaully extra by participating in the staking process which is just leaving your wallet open to process transactions.\n\n**Fast & Scalable**\n\nCreditbit is 10 times faster and can handle 10 times more transactions than Bitcoin, Creditbit is enviremont friendly, it doesn\'t waste as much resources as bitcoin does, and it is ready for scaling if rapid growth happens.\n\n**Development & Innovation**\n\nDevelopers are always working on ways to improve Creditbit, projects that boost adoption and give users an easy and excellent experience are being ported and updated all the time, but most importantly they are open-source and available for public for review.', '', '', '2015-04-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DogeCoinDark', 'DOGED', 'doged.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.dogecoindark.net/', '@dogedcoin', 'DogeCoinDark is a scrypt based alternative crypto currency trying to take the popularity of both Dogecoin and Bitcoin and combine it with the anonymous features of Darkcoin. The block time is 30 seconds and the coin operates through Proof of Work.', '', '', 'Scrypt', '2015-09-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Augur', 'REP', 'rep.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://augur.net/', '@AugurProject', 'Prediction markets are widely considered the best forecasting tool. Augur is an open, global platform where anyone anywhere can create, monitor or trade in prediction markets about any topic. Think of it as an \"Early Warning System\'\' with the most accurate event forecasts, a potential \"Google Search\", \"Bloomberg Terminal\" or \"Reuters Terminal\" for crowdsourced event forecasts.\n\nThe system plans to use the \"Wisdom of Crowds\'\' (\"collective intelligence\'\') via market incentives, \"Long Tail\'\' dynamics and blockchain technology to securely generate a more accurate, robust and unfiltered array of dynamic event forecasts than any alternative can match.\n\nAugur is decentralized, self-regulating, pseudonymous and autonomous. It offers the promise of markets without exposure to counterparty risk, principal-agent problems or central points of control, failure or censorship. No person is ever in direct control of someone else’s funds or in a position to single-handedly threaten the system’s integrity.\n\nThe software is comprised of smart contracts perpetually deployed on a blockchain network, which enables applications deployed to be immune to local outages while benefiting from the entire community\'s security. All interactions with markets are communicated as database transactions between unique accounts powered by immutable software instructions.', '', '', '', '2015-05-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OKCash', 'OK', 'ok.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://okcash.co/', '@OKCashCrypto', 'The \"OK\" name got selected to represent the new brand precisely because it reflects properly the coin\'s goals and attitude. OK is one of only 2 words in the whole world that requires no translation at all to be understood, giving it the potential for mainstream adoption without the hassle of trying to integrate the new name to different cultures. \"OK\" is understood the whole world over.  \n  \nOK reflects a positive outcome, speed and empathy. Security and user experience are the first thoughts behind any update or code modification. The addition of the word \"cash\" was made to give it direct inclusion into the financial sector and to communicate the whole concept in a word: \"OKCash\".  \nAnybody who hears this word gets an overall concept or general idea of what it is about. OK is the technology while OKCash is the first application of this technology, being the coins we can send or put in our wallets for saving, spending or sharing.  \n   \nOKCash\'s rebranding was done in April 2015, and since then the OK cryptocurrency has been added to one of the largest cryptocurrency exchanges - Bittrex. This adds to the list of exchanges where the coin is already trading (Bittrex, Bleutrade, Cryptopia ).', '$OK - OKCash is The future for Social payments.  \n  \nThe name is OKCash with the \"OK\" Ticker, the different dedicated languages sites and resources are currently being rolled out across the networks and social media.  \n  \nThe purpose of the name OKCash is to ensure that the name of the coin properly reflects the trust, positivism, innovation and vision that are at the center of all of our work. We firmly believe that OKCash will have better projection and appeal to a broader international audience, making it a perfect fit for integration in different markets, promotions, exchanges and resources. Say OK to Cash!  \n  \nDevelopment focus on the long term service provision for OKCash across multiple payment platforms, and the accessibility and reliability will compliment the socially orientated services that are currently under development.  \n  \nWe are very excited by the new opportunities that OKCash is bringing to different communities and people around the world with its new positioning as a mainstream brand.   \n  \nOKCash is fun and inclusive, we warmly welcome the community and would like to thank you for your continued support.  \n  \nHistory: Started as a PoW/PoS hybrid, meaning miners were able to use their gpu cards and special miner equipments to mine the coin for the first 15 days without halving to make it more fair to miners, After this Phase, OKCash became a Full Proof of Stake (PoS) Cryptocurrency, meaning the only way to create more coins is the process of staking. It had a Dev\\_Fund mined of 2,691,000 OK in 1st Block for initial distribution for the community. ( Dev Fund was fully distributed via Rains, Giveaways, Bounties, Quiz bots and contests to all the participant crypto communities. Full dev already spent.  \n  \nLaunched in November 2014 with the name Positive Innovation for Multi Payment Cash solutions and re branded later to OKCash, it has a growing reputation as The most socially orientated cryptocurrency with almost daily updates, shared directly on a website for news and updates for the community, and across broad social media.   \n  \nIn December 2014 released a custom wallet for Gaia coin based on the previous OK design, a first for cross-coin collaboration in the crypto Eco-system. This reflects the OKCash focus on developing relationships with other cryptocurrencies, through charitable initiatives and collaborative projects with other coins, which so far have included projects with Gaia, Einsteinium (EMC2) and others.  \n  \nAnother important point to be highlighted regarding OKCash is the fact that there has not been any problems so far with the block chain or it’s code and it runs in real fast and reliable network.  \n  \nThe custom wallet designs reflect an attention to detail and an importance of visual design that is unique to OKCash, along with its emphasis on positivism, inclusiveness and to further the advancement of all the cryptocurrency environment adoption and decentralized payment systems, while bringing back trust to Crypto and becoming The Future of Social Payments.  \n  \nUses: Spending, Sharing, Saving, Remittance, Social Tipping, Crowdfunding, Promotion, Bitcoin Support, Education, communications and much more to be discovered.', '**OK Specs**\n\n  \nReleased: Nov 24th 2014  \nPoW Ended at block: 33,186  \nTotal coins at the end of Pow/Pos Hybrid Period: 36,297,000 OKCash  \nMax Cap: 105,000,000 OKCash  \nFull POS started: Dec 9th 2014  \nProof of Stake  \nStake Rewards: 69% 1st Year (block 531,257)  \n| 20% 2nd (block 1,022,514) | 10% 3rd (block 1,523,771)| 6% 4th Year on wards  \nPoS Min Stake Time: 8 hr  \nTransactions: 10 confirmations  \nStakes: 64 confirmations  \nBlock Time: 72 seconds average block time.  \nRpcport: 6969  \nPort: 6970  \nTest ports: ( RPCport 7979 ) ( Port 7980 )', '', '2015-12-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Voxels', 'VOX', 'vox.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.voxelus.com/', '@Voxelus', 'Voxelus is a platform that allows anyone, anywhere to create, share and play virtual reality games and experiences without writing a single line of code. Voxelus includes a bundle of free assets that you can use to design with more content coming out every week.\n\nThe coin itself (Voxels) is a fork of Litecoin that is fully premined. Mining is possible but not recommended. We could not find their github repository.\n\nThe team behind Voxelus is quite impressive:\n\n- **Halsey Minor -** [halsey@voxelus.com](mailto:halsey@voxelus.com) Founder of [CNET](http://www.cnet.com/) , [Salesforce](http://www.salesforce.com/), [Google Voice](https://www.google.com/voice/), Chairman of [Uphold](https://uphold.com/)(formaly Bitreserve), Chairman of [Voxelus](http://www.voxelus.com/).\n- **Martin Repetto** - [martin@voxelus.com](mailto:martin@voxelus.com) CEO and co-founder [Voxelus](http://www.voxelus.com/)\n- **Máximo Radice** - [maximo@voxelus.com](mailto:maximo@voxelus.com) Voxelus Platform Developer\n- **Michael Terpin** - [michael@transform.pr](mailto:michael@transform.pr) Voxelus & Voxel PR Team\n- **Jim Blasko** - [admin@unbreakablecoin.com](mailto:admin@unbreakablecoin.com) Creator of Voxels\n\nVoxelus also features a stand-alone player app that plays the content created with the desktop tool on your PC, with or without Oculus Rift and on the Samsung Gear VR. We have support for real time multiplayer.\n\nYou can check their latest trailer here: <https://vimeo.com/157963300>\n\nThe asset library can be expanded by purchasing content from designers all around the world in the Voxelus Marketplace, an online 3D asset store where users can upload 3D assets that are curated and compatible with the voxelus platform. To operate in the Marketplace users need Voxels, the official currency of VR and the only form of money used inside the Voxelus Platform.\n\nYou can contact the Voxelus team by email at: [info@voxelus.com](mailto:info@voxelus.com)', '**The Voxelus Platform**\n\nVoxelus is a platform that allows anyone, anywhere to create, share and play virtual reality games and experiences without writing a single line of code. Voxelus also features a real time multiplayer app that plays the content created with the desktop tool, currently working on Oculus Rift and the Samsung Gear VR.\n\n- The asset library can be expanded by purchasing content from the Voxelus Marketplace.\n- To operate in the Marketplace users need Voxels.\n\n**The Voxelus Marketplace**\n\nThe Voxelus Marketplace allows users to expand their content library by purchasing 3D assets from designers all around the world. The marketplace is an online curated 3D asset store compatible content with the voxelus platform.\n\nThey took the hassle out of 3D content, in the marketplace you just select what you want, you purchase the asset and then it becomes automatically available in The Voxelus Creator the next time you open it or hit refresh.\n\nTo operate in the Marketplace users need Voxels which is currently the only form of money used inside the Voxelus Platform.\n\nVoxelus also announced their partnership with Flatpyramid.com , an online marketplace for discovering, buying and selling 3D content. With the partnership, Voxelus will integrate up to 7000 Flat Pyramid VR assets such as non-proprietary graphics, images and 3D models, including still and animated characters and environments into the Voxelus Marketplace, making them readily accessible for creating custom VR worlds immediately ready for multiplayer.\n\n- New content uploaded every day!\n- Anyone can sell assets and make money! Learn More!\n\n**Created to Encourage Broader Cryptocurrency Adoption**\n\nVoxelus Endows Voxel Foundation with 5 Million Voxels to Fund Hackathons, Conference, Global Outreach, New Blockchain Applications for Consumer Entertainment and Content.\n\nVoxelus just announced that it will fund a Voxel Foundation with 5 million Voxels ($3.5 million) to expand the robust cryptocurrency to work with a variety of networks, games, VR platforms and entertainment content providers, as well as to seed its adoption in Latin America and Asia, where gaming is popular but millions of users have no access to the traditional financial system to purchase digital assets online.\n\n- Foundation Will Grant $1 Million in First Year to Developers!\n- Prizes of up to V$100,000 to encourage development of non-entertainment applications.\n- Annual developer and content creator conference.\n- Up to V$50,000 grants for blockchain social implementations and ideas.\n\n**The Voxel & Uphold**\n\nThe Voxel is one of the virtual currencies supported by Uphold that is exchangeable on a major exchange for USD, EURO, GOLD, SILVER and over 30 more currencies. Creating an account at Uphold Is free!\n\n- HOLD your VOX safely and securely in your Uphold Wallet for FREE.\n- SEND your VOX to any member on Uphold, easily, instantly and for FREE.\n- The Voxel can be managed very easily via Uphold, buying and selling with just a few clicks.\n- Create an account and connect any bank accounts in the US, Europe and Asia.', '**Litecoin Core** - Upgraded to the latest version with added extra security and two minutes verifications.\n\n**Pre Mined Currency 210** - Million token are pre-mined, transactions utilize 0.1 voxel mining fee.\n\n**Multiplatform Wallets** - The tokens and wallets are operational today. PC Windows, Mac and Linux are supported.\n\n**Verified By Experts** - The Voxel passed industry experts verifications in terms of security and functionality before it was sent to the exchanges.\n\n**Supported By Major Exchanges** - The Voxel is techonologycally approved by major exchanges that will start trading the coin in Q2 2016.\n\n**Free Online Wallet** - Created and provided by Uphold. The Voxel online wallet is fully operational and it\'s the safest and easiest way to hold voxels.', 'Scrypt', '2015-03-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Synereo', 'AMP', 'amp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Pow/PoSC', 'http://www.synereo.com/', '@Synereo', 'AMPs, Synereo’s content flow currency, serve as a way to Amplify the flow of information in the network. AMPing content increases its ability to propagate to peers and the chances of it being seen by more users. This gives them an inherent market value, as any business or individual wishing to bring information to your attention non-organically has to pay you with AMPs for it.\n\n**Value**\n\nThe AMP is unlike any other cryptocurrency, as it is backed by a commodity for which there is always demand and that can be purchased only with AMPs - the attention of its users.\n\n[Read more about Synereo’s crypto-token, the AMP, and why it has an inherent use and value on the Synereo network.](http://blog.synereo.com/2015/03/27/how-amps-work/)\n\n**Value Appreciation**\n\nAs users join the network, AMPs become more effective in acquiring attention. A similar amount of AMPs on the more mature and larger network will allow a piece of content to reach the attention of more users on it, increasing the value of each AMP.\n\nAs well, a larger user base generates more interaction and content in circulation, increasing the total amount of attention allocated to, and available on, Synereo.\n\nAs Synereo functions as a platform for new applications and markets, AMPs may eventually become a de-facto currency.\n\n**Extensibility**\n\nSynereo enables a new wave of distributed applications that piggyback on the social platform and its user base. Music streaming, content distribution, distributed marketplaces, collaborative platforms, and many other applications can all take advantage of Synereo’s fully decentralized and distributed technology and deploy systems that truly benefit both businesses and end users while removing the need for any middleman.\n\nSynereo is open-source and very modular, designed for rich extensibility. AMPs can power the delivery of any content across this distributed cloud and the apps running on top of it.', '**Synereo offers a complete, commercially-tested framework for creating any type of application in a decentralized manner.**\n\nYou don\'t have to become an expert to create your decentralized application.\n\nSynereo aims to become the go-to platform for decentralized applications.\n\n**They\'re building a framework for the decentralization of the Internet.**\n\nSynereo will:\n\n- Continue developing the open-source building blocks of this new decentralized paradigm.\n- Develop in-house applications that benefit from decentralization.\n- Work with third parties to bring their own innovation to the platform.\n- Develop SDKs and powerful APIs for developers.\n\n**Synereo has a fully operational, complete peer-to-peer stack.**\n\nSynereo is built from the ground up on top of a distributed implementation of the applied π-calculus, the premier mathematical formalism developed to reason about concurrent and distributed computations in a secure manner.This dramatically reduces development time and the level of technical expertise required, and dramatically increases the quality of implementations.\n\n**Synereo has a powerful smart contracting engine.**\n\nNodes on the network can coordinate and enter binding agreements without requiring a central mediator or enforcer. It becomes simple to build decentralized, structured financial instruments as well as verify any type of distributed protocol.\n\n**The Social Platform**\n\nThey\'ve developed a decentralized social platform to provide the basic components of identity creation, communications, and reputation management to every application built on top of Synereo.\n\nThese are shared across the entire ecosystem to service any app and are necessary especially in lieu of a central authority; a decentralized Uber would have to rely on reputation to provide assurance to potential clients.\n\nA decentralized jobs market could rely on existing profiles, groups and reputations.\n\nApplications may integrate their streams into the unified feed provided to Synereo social network users.\n\nThe feed is prioritized using our attention economy model and allows users to interface with apps from one comfortable location. Each application serves as another portal in the Synereo social network and ecosystem.\n\n**Who\'s Building On Top of Synereo?**\n\n- **LivelyGig**: a decentralized jobs market. Uses all Synereo features.\n- **Ethereum**: uses the tech stack and social contract mechanism. Greg, Synereo CSO, is leading the design of their new PoS blockchain using our tech.\n- **weWOWwe**: smart token wallet connected to an existing sports social network and marketplace. Social network and marketplace will migrate to our platform to use all Synereo features.\n- **Backfeed**: reputation mechanisms for centerless coordination. Will use all Synereo features.\n- **Stealth**: a music publishing and community creation/management platform for artists.', '**Synereo AMPs: A Voice Amplifier**\n\nAMPs, Synereo’s tokens, serve as a way to Amplify the flow of information in the network, increasing its ability to propagate to peers.\n\nThey work in two ways:\n\n1. A user may Amplify his own posts: status messages, pictures, created events, etc. Depending on the amount of AMPs used, the post will gain greater visibility in the stream of his Synereo friends - and in adjacent, connected areas of the network through them. A user may also Amplify his friends’ posts in such a manner, helping to propagate the friends’ messages. Thus, a group of friends may band around a common interest and Amplify it together, making sure it is heard as it reaches more of their collective Synereo. The originator of Amplified content will receive a portion of the AMPs invested by his peers. Another small portion will be used for the maintenance of the platform; people donating their storage and bandwidth to the network. The majority of AMPs will go to those who are exposed to the content, compensating them for their time and attention.\n2. Advertisers may use AMPs to created sponsored messages, reaching target audiences based on their interests and activity on the network. NOTE: A user of the system may always opt-out of receiving messages from specific advertisers, about specific topics, or altogether. Most of the AMPs used to advertise to you will be paid to you directly. This is a way to gain from your participation in the network and from the value you generate for it. The more you participate, the more the network is familiar with you and your interests, and the more influence you have on the network, the more your attention is worth!\n\n**Advertising on Synereo**\n\nFacebook’s revenue for Q4 2014 was $3.85 Billion. This is the sum of money that was spent for Facebook content visibility alone, and does not account for resources invested in the creation of the content being advertized or the middlemen optimizing this process.\n\nThis grand economy relies on us - the users of the social network - in its entirety, but we do not share in its gains. Advertisers on these networks are not happy campers, either. The advertising platforms, along with the service providers, are profiteering middlemen that take a major cut for supplying your attention to them.\n\n**How is advertising on Synereo different?**\n\nSynereo users are a real part of the advertising ecosystem rather than merely existing as pawns on someone else’s playing board. The advertisers’ funds do not remain in the hands of major corporations, but are delivered straight to potential customers around the globe as a form of compensation for their attention.\n\nSynereo enables a two-way relationship between advertisers and prospects. Advertisers can target specific communities, contributing AMPs to causes, organizations or projects - and the people that enable them. On the other hand, an advertising campaign initiated by a popular charity or cause can maintain minimal advertising spend while relying completely on \"crowdsourced\" AMPing by its supporters.\n\nSynereo’s information flow logic greatly benefits advertisers who have committed to content excellence, increasing the spread of content engaged with by users recognized for their curation abilities and positive influence on the network; their ability to contribute to the attention economy underlying Synereo.\n\nSimilar to real-world viral campaigns, a well planned advertising effort would target influencers of the relevant topics and audiences to the campaign with excellent content that, if appreciated, will be distributed on Synereo organically rather than by “brute forcing” it with AMPs.\n\nThe lesser the quality of the content you see, the more you will be compensated for it!', '', '2017-07-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HOdlcoin', 'HODL', 'hodl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.hodlcoin.com/', '@hodlcoin', 'HOdlcoin is just like Bitcoin, but it pays interest on every balance. This is to recognize the importance of HODLers and properly reward HODLing.\n\nVery high interest rates (4000%+ APR) are paid in the first few months to attract early adopters to the project.\n\n**Proof of Work**\n\n1GB AES Pattern Search POW. Pattern Search involves filling up RAM with pseudo-random data, and then conducting a search for the start location of an AES encrypted data pattern in that data. Pattern Search is an evolution of the ProtoShares Momentum PoW, first used in MemoryCoin and later modified for use in CryptoNight(Monero,Bytecoin), Ethash(Ethereum). CPU/GPU friendly.\n\n**Pools**\n\n- <https://hodl.suprnova.cc/>\n- <https://hodl.maxminers.net/>\n- <https://hodl.blockquarry.com/>\n\n**Paper Wallet**\n\n- <http://hodlpaperwallets.tk/>\n\n**Block Explorers**\n\n- [http://hodl.presstab.pw](http://hodl.presstab.pw/)\n- <http://www.tekyexplorer.xyz/hodl/>\n- <http://coinofview.com/coin/HOdlcoin.html>', '**Q: What is the official animal of HOdlcoin?**\n\nThe squirrel is the official animal of HOdlcoin. The squirrel is the animal kingdom\'s natural HOdler.\n\n**Q: What is the official song of HOdlcoin?**\n\n\"HODL California\" is the official song of HOdlcoin. You can check-out any time you like, but you can never leave.\n\n**Q: How do I correctly capitalize HOdlcoin?**\n\nHOdlcoin.\n\n**Q: How do I correctly say HODL?**\n\nHODL. It rhymes with Yodel. Yodeling is also the official musical style of HOdlcoin.\n\n**Q: What is the smallest unit of HODL?**\n\nThe nut. There are 100,000,000 nuts in one HODL.\n\n**Q: Why do you HODL?**\n\nBecause we suck at trading and we know we suck at trading if you can pit pat piffy wing wong wang make a milino bucks no problem bro then you don\'t need to hodl', '**Specifications**:\n\n- Subsidy: 50 HODL subsidy per block\n- Interest Supply: Between 150,000,000 and 500,000,000 HODL will be paid in interest to HODLers\n- Fair launch: No Premine/Instamine/Ninja/100 initial 1 HODL blocks\n- Port: 1989\n- RPC Port: 11989\n- Testnet Port: 8989\n- Proof of Work: 1GB AES Pattern Search POW\n- Codebase: Bitcoin 0.11.2\n\n**Interest**\n\n\\*NEW\\* Current Interest Rates and Page - <http://hodlcoin.github.io/>\n\n**1. The Standard Interest Rate**\n\nInterest is paid on regular balances (outputs), on every block, for a period of up to 30 days (561x30 blocks). The rate is 0.0000002384185791015625% (1/2^22). It\'s compounded every block, so the rate is approximately 5% APR. However, remember there is a maximum of 30 days, so to get that APR, you\'d need to log in each month and shuffle the HODL to a new address.\n\n**2. Bonus Interest Rates**\n\nTo encourage early adoption, astronomical rates of interest are paid in the early months. The max rate is 0.0000152587890625 (1/2^16). Compounded, the rate is 2174%. It\'s reduced every block by a multiplier - calculated like this =((409530-X)/409530)^4 (X is the block where the balance is recorded as an output).\n\nTo calculate your bonus rate, you can use this formula.\n\nPrincipal + (Standard Interest + (Bonus Interest \\* Bonus Multiplier)\n\nBonus rates\n\n- Day 0 ~ 2174%\n- Day 30 ~ 1881%\n- Day 60 ~ 1543%\n- Day 90 ~ 1317%\n- .\n- .\n- Day 660 ~ 0.230% APR\n- Day 690 ~ 0.029% APR\n- Day 730 ~ no bonus\n\n**3. Term Deposit Bonus**\n\nIf you lock an amount of HODL as a term deposit, you can also get a bonus on the interest. The longer the deposit, the bigger bonus. The bonus is just a multiplier of the interest, so if you locked up 100 HODL for 1 year, you\'d expect a return of 5 HODL. The term deposit bonus for 1 year is about 100% - so at the end of the term you\'d have 110 HODL (Capital 100 + Interest 5 + Term Deposit Bonus 5). See the chart for the multipliers, or use this formula - =(1-((409530-X)/409530)^6)\\*100 (X is the number of blocks to lock for, min 2 days, max 1 year)\n\nSo to calculate your full bonus return on a term deposit . . . it\'s  \nPrincipal + ((Standard Interest + (Bonus Interest \\* Bonus Multiplier))\\*Term Deposit Multiplier)\n\nTerm deposit Rates\n\n- 1 week term deposit ~ 5.6% bonus on interest\n- 1 month term deposit ~ 22% bonus on interest\n- 3 month term deposit ~ 55% bonus on interest\n- 6 month term deposit ~ 82% bonus on interest\n- 1 year term deposit ~ 98% bonus on interest\n\nn.b. When a Term Deposit matures, it stops earning interest - you must move it to start earning interest again.\n\nn.b. Bonus rates are paid on regular balances too\n\nn.b. The bonus rate is locked at the time of the transaction, the rate you can achieve reduces over time due to the multiplier, but once you\'re earning that bonus rate, it doesn\'t reduce.', '1GB AES Pattern Search', '2016-07-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Digix DAO', 'DGD', 'dgd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'N/A', 'https://www.dgx.io/', '@DigixGlobal', 'Digix DAO is a new form of cryptographic asset in that it is a Decentralised Autonomous Organisation or DAO for short. DAO are basically Companies written in code that are there to perform a set of functions with holders of the tokens voting in relation to the number of tokens they hold.\n\nThe Digix DAO gives users the right to profits in the trading of Digix tokens (DGX) which own the right to gold stored in vault in Singapore. So if people trade 20 gold bars per day - the Digix DAO token holders will have the profits of the commission from those trades distributed equally amongst themselves.', 'Digix DAO is a \"Decentralised Autonomous Organisation\" - DAO\'s are a nascent idea and are therefore not a fully proven concept. The Digix DAO tokens give holders the rights to vote on how funds earned by the DAO are spent and act like shares in a traditional Company.\n\nThe DGD tokens give users the right to earn profits from the trading of DGX tokens - which are tokens backed 1:1 with a gram of gold. The DAO or DGD tokens earn a commission fee based on the number of trades of the DGX tokens. holders of the tokens can vote for\n\nThere are costss for the DAO so headline commission is not equal to profit. The cost come in the form of storing the gold and auditing its veracity. This is where the role of voting rights come in as holders of the tokens can vote who they want to audit the gold.\n\nIf the DAO runs out of funds the founders can propose to raise more tokens in an offering which requires a special majority of voters to agree to.\n\nThe initial offering raised $5.5million for 85% of the tokens. The other 15% were rewards for developers and founders - a premine of sorts.', 'The DAO token is built on ethereum.\n\nThe ICO - or initial coin offering - raised $5.5million to acquire the 85% of the DGD tokens.', '', '2018-04-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EDRCoin', 'EDRC', 'edrc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@EDRCoinOfficial', 'EDRcoin - is the currency, aimed not only to enrichment, but also for saving the Earth resources. It means that part of income system will be used to help recovery worldwide forests, and in addition, for the development of new solar power plants.', '', '', 'SHA256', '2017-10-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Lisk', 'LSK', 'lsk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DPoS', 'https://lisk.io/', '@LiskHQ', 'Lisk is a crypto-currency and decentralized application platform. As a crypto-currency, much like Bitcoin and other alternatives, it provides a decentralized payment system and digital money network. The network itself, operates using a highly efficient Delegated-Proof-of-Stake (DPoS) consensus model, that is secured by 101 democratically elected delegates. The Lisk decentralized application platform, it\'s most powerful component, allows the deployment, distribution and monetisation of decentralized applications and custom blockchains (sidechains) onto the Lisk blockchain. The inflation rate is 5 LISK per block, which gets lowered by 1 every year until it reaches a stable block reward of 1 LISK per block.\n\nLisk partnered with Microsoft to integrate Lisk into its Azure Blockchain as a Service (BaaS) program — meaning developers worldwide can develop, test, and deploy Lisk blockchain applications using Microsoft\'s Azure cloud computing platform and infrastructure.', 'The Lisk network is both decentralized and trustless. That means no single entity is in direct control. The network is secured by 101 democratically elected delegates. Whose primary responsibility is to confirm and broadcast the validity of transactions. All Lisk accounts on the network are eligible to vote for delegates registered on the Lisk blockchain. The 101 delegates with the most votes are elected with the responsibility of confirming the validity of transactions broadcast on the network. They also receive 100% of all fees collected by the network and all forging rewards.', 'During the ICO 100,000,000 LISK weree goven out to ICO participants, the core team, third parties and active community members. Once the network is established with 101 delegates there will be an inflation of 5 newly created LISK with every block, these are the [Forging Rewards](https://blog.lisk.io/explaining-lisk-forging-rewards-53d295066be2). Every 3,000,000 blocks (~1 year) this reward is reduced by 1 LISK, ending at 1 LISK per block where it stays like that forever.\n\nThe Forging Rewards will be equally distributed through all active (101 and higher) delegates, same as the network fees. We implemented this mechanism to create an incentive to run a delegate and secure the network. Additionally, this allows Lisk to finance itself in the future.\n\nLisk is written in JavaScript utilizing NodeJS.', 'DPoS', '2017-12-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Waves', 'WAVES', 'waves.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'LPoS', 'https://wavesplatform.com/', '@wavesplatform', 'Waves is a custom blockchain tokens platform designed for large-scale business and consumer adoption. Waves was created to make the benefits of blockchain technology accessible to ordinary businesses and end users. The platform launched in 2016 and was designed from the ground up to address the shortcomings of existing blockchain services. The result is an enterprise-ready platform that emphasises security, easy token operations (creation, transfer, exchange) and a straightforward user experience, as well as dealing with critical long-term issues such as speed and scalability.', 'Descentralized token exchange: Waves platform will facilitate fundraising, crowdfunding, and trading of  \nfinancial instruments on the blockchain with reduced volatility.\n\nCustom and fiat token creation, deletion and transfer.\n\nAsset-to-asset exchange.\n\nLightweight clients: Waves will provide a easy to setup light client that can run on any computer.', 'Waves is the first production system being built on top of the **Scorex** framework\n\n**Extensible solution**: In order to fix the need for a mandatory hard fork when creating a new type of transaction on the NXT Platform (forcing network client software updates) WAVES offers plug-ins that are not included in the core software module, but are instead installed as an extension on top of it.', 'Leased POS', '2016-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Hitcoin', 'HTC', 'htc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://hitcoininfo.com/', NULL, 'Hitcoin focuses on crypto currency market adoption for companies and investors in the global financial market, in order to provide a new connection between technology, finance and humanism', '', '', 'X11', '2017-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Gamecredits', 'GAME', 'game.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://gamecredits.com/', '@Game_Credits', 'GameCredits is a game driven Cryptocurrency, created to facilitate in-game transactions and monetization.', '', '', 'Scrypt', '2015-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Dashcoin', 'DSH', 'dsh.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://dashcoin.info/', NULL, ' Dashcoin aims to create a perfect mirror image of Bytecoin without a premine. Dashcoin offers true anonymity and data protection through a ring signature system.\n\n CPU-friendly & ASIC-resistant, Dashcoin allows true decentralized mining.', '**Untraceable payments**\n\n**Unlinkable transactions**\n\n**Double-spending proof**\n\n**Blockchain analysis resistance**\n\n**Egalitarian proof of work**\n\n**Adaptive limits**', '', 'CryptoNight', '2014-05-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DubaiCoin', 'DBIC', 'dbic.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://dubaicoin.org/', '@DubaiCoin_org', 'DubaiCoin wants to make cryptocurrencies widely acessible and used in the Arab community. Online marketplace and payment gateway seems to be one of DBIC main focus, and mining rigs are their nº1 sold product', '', '', 'SHA256', '2017-08-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HiCoin', 'XHI', 'xhi.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://xhicoin.com/', NULL, 'HiCoin provides cheap, fast and easy-to-use transactions. Micro-payments and face-to-face transactions are also made easy by XHI.', '', '', 'Scrypt', '2017-01-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Spots', 'SPOTS', 'spots.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, '', '', '', '', '2018-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BiosCrypto', 'BIOS', 'bios.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@vanyabios', 'BiosCrypto focuses on crowdfunding, mobile applications and software development industries. BIOS plans to develop a way to empower developers while still reducing costs for app users.', '', '', 'Quark', '2016-10-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Khancoin', 'KNC*', 'knc_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://khancoin.com/', NULL, 'Khancoin empowers both businesses and employees thorugh decentralized cryptocurrency.\n\nKNC mobile application allows users to shop online and share informatiom, gifts and donations.\n\nKhancoin\'s financial platform (KHANprime) provides users with financial investment and trading tools.', '', '', 'X11', '2016-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CabbageUnit', 'CAB', 'cab.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@cabbagetech', ' Cabbáge Unit enables instant/low cost payments specifically designed for agricultural consumers/merchants.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CarpeDiemCoin', 'DIEM', 'diem.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://thehouseofdiem.info/', NULL, 'After DIEM\'s first version devs abandoned the project , it was picked up by some of its community members who are now offering support to other \"dying\" altcoin in order to form a new \"family of united coins\".', '', '', 'SHA256', '2016-03-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GameBetCoin', 'GBT', 'gbt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://www.gamebet.gg/', '@GamebetGg', 'GameBet is a Sport and eSport betting platform that enables user to bet on matches using cryptocurrencies and Steam based items. GameBetCoin plans to raise the adoption of cryptocurrencies among gamers and sports enthusiasts.\n\nGameBetCoin gathered a total of 268.0639 btc during in exchange for 20,000,000 GBT during it\'s it\'s ICO.', '', '', 'POS 3.0', '2017-06-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SARCoin', 'SAR', 'sar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.sarcoin.com/', '@sarcoin', 'SARCoin offers debit card support (KryptoCardSARcoin stake rewards are 2% during 2016 and 1% in the following years.', '', '', 'SHA256', '2015-09-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RedCrowCoin', 'RCX', 'rcx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, ' RedCrowCoin uses a Scrypt Pow/PoS algorithm that offers a 80% per year staking reward', '', '', 'Scrypt', '2016-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PowerCoin', 'PWR', 'pwr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.powercoin.pw/', '@Powercoin_PWR', 'PowerCoin is a cryptocurrency meant to facilitate decentralized co-working and shared computing power. Users can create and share projects, work groups, notes, polls and much more, through their PowerClient. PWR also provides a easy to use PowerGrid that allows companies to buy and sell or donate computing power.', '', 'POW Block reward reduction:  \n  \nBlocks 0 to 10: Airdrop PWR  \nBlocks 10 to 100 = 0 PWR  \nBlocks 101 to 43100 = 350 PWR  \nBlocks 43101 to 86400 = 230 PWR   \n  \nPOS Block reward reduction:  \n  \nBlocks: 86000-86400: 5 PWR (Warm-Up)  \nBlocks: 86400-100800: 10 PWR (1 Stage)  \nBlocks: 100800-115200: 25 PWR (2 Stage)  \nBlocks: 115200-129600: 50 PWR (3 Stage)  \nBlocks: 129600-144000: 100 PWR (Full Power)  \nBlocks: 144000-158400: 20 PWR (5 Stage)  \nBlocks: 158400-172800: 15 PWR (6 Stage)  \nBlocks: 172800 > 5% Fixed Yearly', 'NIST5', '2016-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TrumpCoin', 'TRUMP', 'trump.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://trumpcoin.rocks/', NULL, 'TrumpCoin was named after the political candidate, Donald Trump and it promotes some of the same ideals they see in said candidate, such as: Free Speech and Fair Trade Capitalism.   \n   \nSince TrumpCoin relies heavily on the election for publicity, the Dev team have come up with a solution to assure TRUMP holders will not suffer from this decrease in demand: TRUMP will be exchangeable 1-1 for Teth tokens (TrumpTech) that will be built on the the Ethereum network in order to support smart contracts and Dapp', '', '', 'Blake', '2016-11-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PrismChain', 'PRM', 'prm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Prism is a Blockchain-as-a-Service development and production environment. PRM offers Dapp development and E Language coding support\n\nPrism reached their ICO goal and sucessfully destributed 28500000 PRM', '', 'Triple Layer Blockchain (TLB): A single blockchain with three different layers to handle various functions.', 'SHA256', '2017-06-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitCrystals', 'BCY', 'bcy.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://bitcrystals.com/', '@spellsofgenesis', 'BitCrystals is the official Spells of Genesis (SoG) crypto currency. SoG is upcoming mobile game with a storyline based on bitcoin. BCY is  a tradable Counterparty asset that will allow gamers to have ownership of their game items in and outisde the game database.', '', '', 'Counterparty', '2015-06-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Rubies', 'RBIES', 'rbies.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://rbies.org/', '@Betterbets_io', 'Rubies is a Business and Entertainment Crypto Currency. RBIES coin is mined though bet-mining.\n\nBet-Mining new Rubies will help determine the price per coin, if people determine that it takes 0.015 BTC to make 1 BTC betting volume to unlock 30 Rubies via Bet-Mining, then that would put each Ruby valued at 0.0005 BTC. Markets will ultimately determine the value however.\n\nBet-Mining halved on June 1st 2016  \nThe next halving occurs December 1st 2016\n\nCurrent reward is 200 Rubies per 1 BTC of volume', '', '', '', '2016-09-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Steem', 'STEEM', 'steem.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://steem.io/', '@steemit', 'Steem.it is a blockchain-based social media platform where anyone can earn rewards by posting relevant content, curating quality content by upvoting and by holding Steem based currencies in a vest fund, which generates interest.\n\nThere are three main currencies in Steemit: Steem, Steem Power (SP) and Steem Backed Dollars (SBD).\n\nSteem is liquid and can be bought in an exchange and converted into steem dollars or steem power.\n\nSteem Power is basically Steem that is locked in a vesting fund for 3 months. Users can use steem power to upvote content and get curating rewards.\n\nWhen a user upvotes content his steem power gets depleted and then slowly regenerated. Steem Power holders recieve interest from their holdings. The more Steem Power a voter has the more revenue he\'ll generate for himself (in form of SP) and for the content creator (In SBD).\n\nThere is also an incentive to upvote content early, as the rewards are distributed according to time. The earliest votes gets the biggest share of the reward.\n\nSteem Backed Dollars are there to protect content creators from volatitlity and can be traded for roughly 1 usd worth of steem, in order to cash out from steem. Converting Steem backed dollars into STEEM takes 5 days. Users also recieve interest from holding SBD. T\n\nSteem is a proof of work currency with a scheduled blocktime of 3 seconds. Steem PoW mining is done in rounds of 63 seconds by 21 miners (witnesses). 19 of the miners are pre voted, one is the other with the most computational power, and the last one is selected from a queue of witnesses that did not get on the top 19 voted witnesses.\n\n90% of the block reward is allocated to a vest fund to reward curators and PoW miners, the other 10% are made liquid in the form of steem and are used to reward content creators. Steem gets converted to Steem Backed Dollars and sent to the content creator.', '', '', '', '2015-04-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BillaryCoin', 'BLRY', 'blry.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://billary.rocks/', '@BillaryCoin', 'BillaryCoin plans to achieve trustless demoracy with a cryptocurrency powered election platform. BLRY has partenered with FollowMyVote.', '', 'PoW Phase Duration: 150,000 blocks', 'Scrypt', '2017-04-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'WhiteCoin', 'XWC', 'xwc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.whitecoin.info/', '@whitecoiner', 'Whitecoin (XWC) is a three year old decentralized global blockchain with a focus on cyber security, payments & secure communications\n\nWhile available to everyone, WhiteCoin is driven by a dedicated community of supporters yet controlled by no one single individual. This attractive combination will help ensure stability, growth, and compelling technological developments.', 'Unique design  \nEasy to use interface  \nCreate XWC accounts  \nMultilanguage  \nBuilt in block-explorer  \nNetwork statistics  \nManage your contacts  \nWindows / Mac / Linux', 'Bootstrap: bootstrap.dat allows a new Whitecoin client (not synced) to rapidly import the initial blocks from a local file instead of slowly downloading blocks from random peers. This significantly reduces the time it takes to get a client synced with the current blockchain.\n\nWhiteOS: WhiteOS is a custom, optimized and hardened Ubuntu environment. It can be installed in any computer and it provides bulit in anonymity.\n\nPOS starts after Block: 10000', 'Scrypt', '2015-01-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Dotcoin', 'DOT', 'dot.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.cryptopia.co.nz/', '@dotcoinnz', 'Dotcoin was developed by Cryptopia and it provides instant payments without the need for central authority.', '', '', 'Scrypt', '2016-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Scotcoin', 'SCOT', 'scot.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.scotcoin.org/', '@ScotcoinProject', 'Scotcoin 2.0 is a Counterparty asset that replaced the original SHA-256 Scotcoin.\n\nThe Scotcoin project plans to spreat their cryptocurrency  to the people of Scotland and to ensure SCOT is widely accepted in all areas of commerce and society in Scotland in order to grow the Scottish economy.', '', '', 'Counterparty', '2015-03-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Darknet', 'DNET', 'dnet.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Pow/PoS', 'http://darknet-crypto.com/', NULL, 'Darknet stives to provide true privacy and anonimity in Cryptocurrency.', '', 'Tor and I2P\n\nAsic Resistant Algorithm\n\nFast Synchronization', 'Quark', '2018-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitalphaCoin', 'BAC', 'bac.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://bitalphacoin.com/', '@bitalphacoin', 'Bitalpha is a easy-to-use, peer-to-peer cryptocurrency ideal for gifts and micro-payments', '', 'PoW Phase Duration: 150,000 blocks', '', '2016-05-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'International Diamond Coin', 'XID*', 'xid_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://xidcoin.com/', NULL, 'XID coin can be exchanged for loose diamonds on the International Diamond Coin official website.', '', '', '', '2016-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Grantcoin', 'GRT', 'grt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Pow', 'http://www.grantcoin.org/', '@grantcoin', 'Grantcoin wants to provide a basic income for everyone in the world. It\'s the dev team\'s belief that everyone is entitled to a basic income in order to provide a minimum life quality standard.', '', '', 'SHA256', '2015-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Thecreed', 'TCR', 'tcr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://thecreed.tech/', '@TheCreed_Crypto', 'Thecreed focuses on \"macabre\" media sharing/rewarding.', '', '', 'QuBit', '2016-07-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PostCoin', 'POST', 'post.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@POSTcoinArena', ' Postcoin is the official cryptocrurrency of the Altcoinboard forum. The forum allows you to earn tokens for every post you make and then exchange them in the forum\'s Exchange Center for POST coins.', '', '', '', '2017-05-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Influxcoin', 'INFX', 'infx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://chainworksindustries.com/', '@Infxcoin', 'Influxcoin is a X11 algorithm based coin with no pre-mine using a Pow+Pos Hybrid backend and designed specifically for CPU/GPU mining. INFX focuses on web hosting. You can exchange BTC for INFX directly on the Influxcoin website.', '', '', 'X11', '2017-02-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EthereumScrypt', 'ETHS', 'eths.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Ethereum_scrypt', 'EthereumScrypt is a Decentralized payment system that provides free transactions. ETHS uses a PoW/PoS hybrid version of the Scrypt algorithm.', '', '', 'Scrypt', '2016-08-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Phalanx', 'PXL', 'pxl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@PLXDev', 'PhalanXL provides a mining platform where miners can sell, buy, trade and rent mining resources and computational power. The QT-client also, allows users to store and trade multiple cryptocurrencies', 'y', '', 'SHA256', '2015-10-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NumbersCoin', 'NUM', 'num.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'NumbersCoin is a digital currency that enables instant payments.', '', '', 'Scrypt', '2015-02-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SoulCoin', 'SOUL', 'soul.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Soulcoin enables low cost transfers, faster confirmation time and improved storage efficiency.', '', '', 'Scrypt', '2015-10-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ionomy', 'ION', 'ion.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://ionomy.com/', '@ionomics', 'Ionomy focuses on mobile gaming applications. ION provides a platform that facilitates the development and monetization of new mobile games and rewards gamers financially.', 'Pre-mine:\n\n\\- 3.4 million ION: participation incentives given away by ionomy.com  \n\\- 2.5 million ION: bounties for coin development  \n\\- 5.0 million ION: to offer through Initial Coin Offering', '', '', '2016-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GrownCoin', 'GROW', 'grow.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.growcoin.pw/', '@Grow_Dev', 'Growcoin is the cryptocurrency for marijuana growers and crypto enthusiasts. You can use GROW to buy growing supplys in their official Growshop.', 'Growshop: allows users to trade GROW for growing supplies', 'Alogrithm: SHA256-D', '', '2015-02-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SuperNET', 'UNITY', 'unity.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://www.supernet.org/', '@SuperNETorg', 'SuperNET is an asset built on the NXT platform and it is a cryptocurrency network that facilitates the creation revenue for developers in the cryptosphere. UNITY, like the coin\'s ticker itself, plans to unite, spread and empower cryptocurrencies whle still allowing them to maintain their brand freedom and identity.\n\nSuperNET\'s platform allows developers to create, deploy amd integrate new funcionalities and features related to blockchain technology, with of over 15 programming languages at their disposal through a system of plug-ins.\n\nPlug-ins can be downloaded and used within the SuperNET client, allowing new deployments to be easily integrated and used by the SuperNET community.\n\nSupeNET revenues (from its core assets, advertisements and shared fees) will be distributed as follows:  \n  \n10% for overhead  \n20% for coin communities, according to their proportional contribution  \n5% Nxt core development  \n5% for BTCD stakers  \n10% unallocated, for discretionary spending to maximise the market cap of SuperNET  \n50% will go to SuperNET assetholders using the NXT dividend mechanism.', '**NXT Asset 12071612744977229797**\n\nSuperNET is an integrated **trading-house/incubator/software/advertising** entity that plans to aggregate users and monetize the internal and external traffic..\n\nThe **trading-house** will be a global 24/7 team based trading combined with individual trading based on each traders results.\n\nThe **incubator** (NXTventure) provides funding to developers to create software for the SuperNET that enhances the overall monetization, this monetization only being possible when value is created for the user.\n\nThe **software** is the sum of all asset companies and cryptocurrencies that are joined together to create the useful services, eg. decentralized trading.\n\nThe **advertising** is the total inventory created by all the user minutes interacting with the dynamically generated context sensitive HTML GUI.', '', '', '2016-04-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OldSafeCoin', 'OLDSF', 'oldsf.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://safecoinclub.com/', NULL, 'OldSafecoin provides Easy, Fast and Safe Trading throught their SafeCoinClub.', '', '', '', '2018-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SunShotCoin', 'SSTC', 'sstc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'SunShotCoin is a PoW coin that can be mined at iSpace Mining Pools. SSTC provides fast and cheap transactions.', '', '', 'X11', '2017-01-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NetworkCoin', 'NETC', 'netc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Network_Coin', 'NetworkCoin uses X13 consensus algorithm, which provides higher security and performance. NETC is a PoW/PoS Hybrid that provides fast, cheap and safe transactions.', '', '', 'X13', '2017-01-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GPU Coin', 'GPU', 'gpu.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.usedgpus.com/', '@GPU_coin', 'GPU Coin will be used in the used GPU global market, where users can buy and sell used GPUs (Graphic Processing unit) safely through their escrow service.', '', '', 'Scrypt', '2017-04-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Think And Get Rich Coin', 'TAGR', 'tagr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.tagrcoin.com/', '@tagrcoin', 'TAGR plans to set itself apart from other cryptocurrencies through it\'s unique image and social media features. The name Think and Get Rich is a tribute to Napoleon Hill, author of \"Think and Grow Rich\".', '', '', 'X15', '2016-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HempCoin', 'HMP', 'hmp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.hempcoin.com/', '@hempcoin1', 'HempCoin is a Scrypt-n Proof of Work cryptocurrency that plans to be the main currency in the cannabis community.', '', '', 'Scrypt-n', '2016-03-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Adzcoin', 'ADZ', 'adz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://adzcoin.org/', '@ADZbuzz', 'Adzcoin plans to replace traditional online advertisin with a decentralized blockchain based system that will empower website administators and allow users to support content they enjoy by chosing to view certain ads instead of blocking all of them.', '', 'Block reward halving every 12 months  \nDifficulty re-targeting using the multipool-resistant DigiShield', 'X11', '2017-01-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Gapcoin', 'GAP', 'gap.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://gapcoin.org/', '@Gapcoin', 'Gapcoin uses it\'s custom PoW algorithm: Prime Gaps. Difficulty is adjusted every block, and there is also an halving every 420000 Blocks (about 2 years).', '', '', 'Scrypt', '2017-01-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MayaCoin', 'MYC', 'myc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.mayacoin.org/', '@Gapcoin', 'Maya currency, the English full name: Maya coins, called MYC. Ai Maya culture is a group of hot team effort to build a combination of virtual and physical founded based on a decentralized peer to peer network, open source payment system.\n\nMayan Civilization: Maya civilization is the most ancient and wise race of a tribe, the Mayan civilization, Mayan Indian named because, Amerindian and Mayans in Asia, Africa, Europe and the ancient civilization isolated conditions, independently created a great civilization whose ruins are mainly distributed in Mexico, Guatemala and Honduras and other places. Mayan civilization was born in the 10th century BC, it is divided into the pre-classical period, classical and post-classical period of three periods in which AD 3-9 century its heyday.\n\nMaya Faith: Mayan religiosity, full of religious and cultural life. They worship the sun god, the god of rain, Inari, death, god of war, Aeolus, god of corn and the like. Titan outranked gods, revered as the incarnation of God. In addition, the line of ancestor worship, believe in immortality. Maya country also responsible for religious affairs, is the religious center of the capital.\n\nThe decline of Mayan civilization: the Mayans after this prosperous period, how rapid decline in a very short period of time, is still a mystery. Although Maya sharp reduction in a very short period of time, but the reasons for the formation of a long time. Maya decline factors are: population explosion food shortage of natural disasters alien infestation spread of the disease outside the decision-making energy shortages Star fratricidal aliens say a word, annihilation in the deserted tropical jungles to build the world super-civilization, in the golden age of the Maya mystery man suddenly disappeared, too cryptic.\n\nMaya civilization is the civilization of Central and South America region, and legends contrary, the Maya never disappeared, there are still three million contemporary Maya living in the Yucatan Peninsula, many people are still able to speak the language of the Mayan language. Maya never had a unified powerful kingdom, the whole region is divided into hundreds of Mayan city-states, the states in the Maya language, religion, customs and traditions, but belong to the same cultural circle.\n\nFor this great culture has been able to be able to spread it, so that we learn more about the Maya history, a group of hot young Ai Maya Maya culture founded credits.\n\nMaya currency Technically, fully absorb the advantages of Bitcoin, litecoin, Ethernet Square and other digital currencies, Bitcoin basis while some technology has been criticized on the little bit of money by means of the introduction of POS, POW + POSDE proof way to completely avoid the operator center of force may bring 51 attacks, with its own characteristics, multi-angle interpretation of the superiority of digital currency.\n\nMYC is based on P2P technology to the center (Decentralized) using cryptography digital currency latest technology to build the block chain, MYC make up the current Bitcoin appeared double flowers (now resolved), a fork (technical issues remain unresolved), confirm a long time (not conducive to fast transaction), the block is too large (narrow block currently imperative) and other issues. Maya credits MYC program based on P2P block chain technology, while using Block-Reduce algorithm (Block-Reduce algorithm redefine the data structure block chain to ensure data in the exact premise of safety, for minimized block chain size) and the block chain technology, the area block size reduced to a minimum, so that users can easily and quickly using Maya credits MYC payment and other business practices.\n\nTotal Released: Maya has a total number of 8,000,000 credits, the development team is 100% pre-mining, post pure POS algorithm, POS interest: 2% annual interest. Maya by the management team uses, including 6 million IPO packaged using crowdfunding distribution assets, and the remaining 1 million gift to promote the use of free distribution, promotion of the development team as one million maintenance expense', '', '', 'Scrypt', '2016-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'InvisibleCoin', 'IVZ', 'ivz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'IVZ is a Pure POS cryptocurrency that gets it\'s image from it\'s lack of one.', '', '', '', '2015-09-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'VirtaCoin', 'VTA', 'vta.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.virtalocal.com/', '@VirtaCoin', 'VirtaCoin, formerly PayBox.me/VirtaPay, enables instant payments to anyone, anywhere in the world. VirtaCoin offers a “printed cash-note” system, which can help real-life users in adopting to cryptocurrencies through a familiar method: paper money. Altough VTA is Proof of Work currency, you can also earn interest by being involved in VirtaCoin Kiva Fund.', '', '', 'Scrypt', '2017-01-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SoilCoin', 'SOIL', 'soil.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://soilcoin.xyz/', '@SOILcoin', 'SOILcoin uses Dagger algorithm to allow the creation of Smart Contracts and Dapps while still allowing Developers to create this features for a lower cost, when buying and transfering SOIL, than other cryptocurrencies that use similar technology (like Ethereum). SoilCoin allows any cryptocurrency protocol to be ran on the SOIL blockchain as a deployed smart contract hosting its own token.', 'SoilCoin has been integrated into the ROKOS OS for Raspberry Pis', 'SOIL uses DAGGER algorithm. Dagger was creted by Vitalik Buterin and it\'s a GPU-Friendly, Memory intensive, ASIC-proof consensus algorithm.', 'Dagger', '2015-10-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DigiCube', 'CUBE', 'cube.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.freestaking.com/', '@PurePoS', 'DigiCube\'s core feature is it\'s inflation control system that allows users to profit from highstaking rates while maintaing GUBE\'s value. DigiCube offers a FreeStaking platform that shows real-time coin market info as well as aarbitrage oppurtunities', '.', '', '', '2016-12-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'YoCoin', 'YOC', 'yoc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.yocoin.org/', '@yocoin15', 'YoCoin is a decentralized, peer-to-peer cryptocurrency that enables instant, fast and secure payments globally.', '', '', 'Scrypt', '2017-07-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Coin', 'COIN*', 'coin_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://coin.org/', '@Coin_currency', 'COIN allows instant payments globally, while still a SHA256 cryptocurrency, Coin plans to create and run on a SHA256 clone called CSha256, which will allos asset creation and deployment.', '', '', 'SHA256', '2018-02-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'VapersCoin', 'VPRC', 'vprc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://vaperscoin.com/', NULL, 'VapersCoin is a peer-to-peer cryptocurrency that enables instant payments', '', '', 'Scrypt', '2017-11-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AlpaCoin', 'APC', 'apc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://alpacoin.com/', NULL, ' AlpaCoin is crytpocurrency, that allows instant payments to anyone in the world. It was introduced as a way to raise cryptocurrency adoption in Korea.', '', '', '', '2017-10-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Steps', 'STEPS', 'steps.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://altcoinsteps.com/', NULL, 'Steps is a cryptocurrency-sphere platform that alows you to safely store various altcoins through their Steps Stay Safe feature and to sell/buy Digital goods, Products and Services through the platform\'s market.', '**Steps Stay Safe** - Store many cryptocurrencies safely.\n\n**Market** - Buy and Sell Digital items, Products and services\n\n**CryptoWorld** - Crypto related game (in progress)', '', '', '2016-04-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DebitCoin', 'DBTC', 'dbtc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'DebitCoin is a community driven project and plans to function as a D.A.O. Users can earn rewards by mining or running a node.', '', '', 'Scrypt', '2018-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Universal Currency', 'UNIT', 'unit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://www.u-currency.com/', '@UnitCurrency', 'Universal Currency is a decentralized, peer-to-peer payment system', '', 'PoS mining starts at block 10001', 'SHA256', '2018-02-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AeonCoin', 'AEON', 'aeon.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@AeonCoin', 'AEON is a privacy driven cryptocurrency that allows anonymous payments. AeonCoin uses a CPU/GPU friendly algorithm', '', '', 'CryptoNight', '2014-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MoinCoin', 'MOIN', 'moin.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://coin.org/', '@AeonCoin', 'MoinCoin uses the Sha256d algorithm to provide secure and fast payments. MOIN is a PoW/PoS hybrid.', '', '0-19: 0 MOIN  \n20-999: 79 MOIN  \n1000-17999: 59 MOIN  \n18000-19999: 89 MOIN\n\n18000-19999: POS', '', '2017-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SibCoin', 'SIB', 'sib.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://sibcoin.org/', NULL, 'SibCoin is the cryptocurrency designed for the Siberian Community. It provides fast, anonymous and cheap transactions.', 'Darksend: Anonymous Transactions\n\nInstantX: Faster Payments', '', 'X11GOST', '2015-09-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EuropeCoin', 'ERC', 'erc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@EuropeCoinERC', 'EuropeCoin was designed to inspire mass-adoption in European Countries and to empower charity organizations. 25% of the ERC IPO funds ere destributed through various charities.', 'Darksend: Anonymous Transactions\n\nInstantX: Faster Payments', '', 'X11', '2015-09-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AdvancedInternetBlock', 'AIB', 'aib.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Advanced Internet Block is a project designed to get funds through the value of the coin itself in order to invest in the field of real estate, internet(mobile) application and future infrastructure  and reinvest back in the coin\'s development. 99.998% of AIB\'s supply was premined and 500000 AIB remained to be mined during the next 10 years.', '', '', 'Scrypt', '2016-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PrimeChain', 'PRIME', 'prime.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://statmine.online/', NULL, ' Primechain allows users to make instant transaction with no fees at all. PRIME\'s website has real-life arbitrage tools.', '', '', '', '2015-11-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BERNcash', 'BERN', 'bern.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://berncoin.org/', '@berncash', ' BERNcash, is a peer-to-peer payment system that allows instant payments with low fees. BERN was named after presidential candidate Bernie Sanders.', '', '', 'X14', '2017-10-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BigUp', 'BIGUP', 'bigup.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://bigup.club/', '@BigUpKing', 'Bigup allows peer-to-peer transactions across the globe. BIGUP uses PoS 2.0 algorithm, which means users can earn transaction fees by staking Bigup.\n\n919000000 BIGUP were sold during the ICO. 2,581,823,262 were burned.', '', '', '', '2016-12-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Krypton', 'KR', 'kr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://krypton.rocks/', '@covertress', 'Krypton was developed from Ethereum\'s previous technology, Dagger-Hashimoto consensus algorithm. It enables developers to create and deploy Dapps and smart contract with fewer initial coins and in a shorter period of time.', '', '', 'Dagger-Hashimoto', '2017-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RevolverCoin', 'XRE', 'xre.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.revolvercoin.org/', '@RevolverCoin', 'Revolver is a cryptocurrency developed to empower and reward content service proviers, independent music and vide projects, startups and users inside the XRE network.', '', 'XRE uses its own algorithm, X11Evo.', 'X11Evo', '2018-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DragonSphere', 'XDB', 'xdb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@DragonSphereXDB', 'DragonSphere is a Dragon Ball Z theme coin. It allows instant transactions to anyone in a world.', '', '', 'X11', '2015-12-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Anti Bitcoin', 'ANTI', 'anti.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://anti.cash/', '@anti_bitcoin', 'Anti Bitcoin was created as a symbol against greed and dishonesty inside the cryptocurrency community, it seeks to point out bitcoin\'s greatest flaws, such as market manipulation by small groups of individuals.', '', '', 'SHA256', '2016-03-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BreakoutCoin', 'BRK', 'brk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://breakoutenterprise.com/', '@BreakoutGaming', 'Breakout Chain is Multicurrency Blockchain based platform. Breakout Chain allows the issuance of colored coins, pegged currencies and the deployment of smart contracts Break Chain\'s main currency is BreakCoin (BRK), which can also be used to gamble on the Breakout Gaming Platform.', 'Multicurrencies – multiple currencies carried on a single chain\n\nMulticurrency Hybrid PoW/PoS – a security mechanism where currency A is rewarded to secure a chain using Proof-of-Work, and currency B is rewarded to secure the same chain using Proof-of-Stake (PoS, also described below)\n\nBreakout Gravity Wave – a difficulty algorithm derived from Dark Gravity Wave that throttles block creation.\n\nDelegated Fees – the ability to send currency A but pay for the transaction in currency B\n\nFee Scavenging – the ability for transaction fee collection to be deferred until a Proof-of-Work claims the fee\n\nNonmalleable Transactions – transactions protected against changes to their transaction IDs\n\nColored Coins – currencies with only one unit that is indivisible, a proof of concept for which has been incorporated into Breakout Chain in the form of a deck of cards\n\nCurrency Interrelationships\n\nExchange Friendliness', '', 'SHA256', '2016-03-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ColossusCoinXT', 'COLX', 'colx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.colossuscoin.org/', '@colossuscoin', 'ColossusCoinXT is a decentralized, open-source, and energy-efficient transaction platform. It is based on the popular PIVX Source Code with a fixed PoS block reward.', '', '', 'X11', '2015-08-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Mineum', 'MNM', 'mnm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://mineum.org/', '@mineumproject', 'Mineum is a cryptocurrency dedicated to providing mining services to a wide audience of crytpo enthusiasts, allowing users to buy mining equipment to be hosted in Mineum\'s mining farm located in Quebec, Canada. Users can also earn BTC by becoming a Mineum share holder as long as they have 10 000 MNM.', '', '', 'X13', '2016-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Asiadigicoin', 'ADCN', 'adcn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.asiadigicoin.org/', NULL, ' Asiadigicoin is a Proof of Work scrypt cryptocurrency', '', '', 'Scrypt', '2017-04-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZeitCoin', 'ZEIT', 'zeit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@Zeitcoin', 'Zeitcoin is a cryptocurrency that allows insant peer-to-peer payments to anyone, withou the oversight of any central authority. Zeitcoin is a charity and activism driven coin. ZEIT uses a sustainable PoS algorithm with dynamic staking rewards:\n\n25% during the first year\n\n20% during the second year\n\n15% during the third year\n\n5% until all coins have been mined', '', '', 'PoS', '2016-04-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '2GiveCoin', '2GIVE', '2give.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://2give.info/', '@2GiveCoin', '2GIVE is a charity and altruism driven project designed to recieve and make donations, tips and transactions. 2GIVE is a PoW/PoS hybrid, which means users can earn 5% interest on their holdings or mine with computational power and earn transaction fees as a reward. 2GIVE can also be used to produce GiftcCards within the wallet.', '', '', 'Scrypt', '2017-06-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cryptographic Anomaly', 'CGA', 'cga.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://anti.cash/', '@CGAnomaly', 'Cryptographic Anomaly is a modified clone of Litecoin. CGA uses a unique block reward algorithm that has a 25% probablity of creating an extra block reward of 1 coin , this anomaly is the inspiration for the coin\'s name.', '', '', 'Scrypt', '2014-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SwingCoin', 'SWING', 'swing.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://tryswing.com/', NULL, 'SwingCoin is a cryptocurrency that allows instant payments to anyone in the world. SwingCoin is a Pow/PoS hybrid with strategic block rewards.', '', '', 'SHA256', '2017-04-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SafeExchangeCoin', 'SAFEX', 'safex.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoC', 'http://safex.io/', '@safe_exchange', 'The Safe Exchange Platform allows the creation of digital assets and contracts, cryptographic data-storage and transfers. Through a client application a user can define an item\'s attributes and then later offer that item in a contract to a marketplace where others can discover, scrutinize, and fulfill the terms of the contract autonomously without the necessity of a trusted third party.', '', '', 'Scrypt', '2018-02-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Nebuchadnezzar', 'NEBU', 'nebu.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'Nebuchadnezzar is a Matrix themed cryptocurrency, that provides fast and cheap transactions to anyone in the world', '', '', 'PoS', '2016-05-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AcesCoin', 'AEC', 'aec.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.acescoin.org/', NULL, 'AcesCoin is a PoW/PoS hybrid, ASIC-resistant cryptocurrency that allows instant and anonymous payments.', '', '', 'X11', '2016-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Francs', 'FRN', 'frn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.francs.paris/', '@francnoir', 'Francs is a cryptocurrency designed to create interest and adoption of crypto within the French community. FRN can be sent to anyone, instantly and with low fees.', '', '', 'Scrypt', '2017-09-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Aiden', 'ADN', 'adn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.aidenorg.org/', NULL, 'Aiden is a cryptocurrency designed for GPU Miners. ADN uses Scrypt-OG algorithm developed from Scrypt and optmizied for GPU (OG).', '', 'ScryptOG - Memory light algorithm', 'ScryptOG', '2016-05-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Pulse', 'PULSE', 'pulse.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://pulseproject.pw/', '@PulseCrypto', 'Pulse is a Pow/PoS hybrid, that uses the algorithm SHA256D, developed from Bitcoin\'s algorithm. Pulse allows decentralized and instant payments to anyone in the world.', '', '', 'SHA256D', '2016-05-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Number7', 'N7', 'n7.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.number7.co/', '@number7team', 'Number7 is a Proof of Work cryptocurrency with a 7% premine, it allows users to send anonymous, cheap and fast payments/transactions to anyone in the world through it\'s peer-to-peer network.', '', '', 'Scrypt', '2016-08-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cygnus', 'CYG', 'cyg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://cygnus.online/', '@Project_Cygnus', 'Cygnus was developed in order to provide a stable, and easy to use cryptocurrency for the community. Cygnus is a PoS/Hybrid coin that allows users to earns rewards by mining or by staking CYG coins owned. In order to provide a totally egalitarian and fair distribution process, a bounty and airdrop process was developed before the launch.', '', '', 'X11', '2017-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LGBTQoin', 'LGBTQ', 'lgbtq.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://lgbtqoin.org/', '@LGBTQoin', ' LGBTQoin is human rights driven coin for everyone that aims to support pride festivals, cummuny support groups & organizations, charities, student & trade unions related to the protection of civil and human rights for all minorities. LGBTQoin uses a X11 Proof of Work algorithm which allows fast and anonymous transactions with low fees.', '', '', 'X11', '2015-12-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Uther', 'UTH', 'uth.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Uther is a peer-to-peer network, it uses a Proof of Work algorithm that allows the creation of Dapps and Smartcontracts, Dagger. Uther plans to move to PoS, when Ethereum does. UTH has a 12 million premine in order to support the project\'s development. UTH can be sent to anyone instantly and used to fuel the creation of decentralized applications within the Uther network.', '', '', 'Dagger', '2016-01-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MediumProject', 'MPRO', 'mpro.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@MEDIUMPROJECTHQ', 'MediumPoject is a Proof of Stake cryptocurrency that allows fast and cheap transactions across the Globe.', '', '', 'PoS', '2016-10-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'KATZcoin', 'KAT', 'kat.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@katzcoin', 'KATZcoin is a Proof of Work/Hi-Proof of Stake Hybrid that allows users to earn up to 50% monthly interest on their holdings. KAT uses Sha256D as an encryption algorithm.\n\n[](https://youtu.be/zeBfZf1N7x4)', '', '', 'SHA256D', '2016-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Supreme', 'SPM', 'spm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Supreme is a Pow/Pos Scrypt Cryptocurrency that allows users to send fast and cheap transactions across the blockchain. SUP was created to please it\'s community with a \"everything you want\" roadmap.', '', '', 'Scrypt', '2017-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Mojocoin', 'MOJO', 'mojo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@Mojodevs', 'Mojocoin is a 100% Proof of Stake cryptocurrency with the core focus set on privacy and the development of future mobile applications.. The MOJO team wants to reach the full potential of Blockchain technology, providing a stable and secure ecosystem. Users will be able to make fast and cheap transacitons on the MOJO blockchain while remaining anonymous.', '', '', 'PoS', '2016-10-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BelaCoin', 'BELA', 'bela.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://belacoin.org/', '@BelaCoin', ' Belacoin is a Scrypt cryptocurrency, based on Litecoin. It was created to increase funding and awareness for chartity organizations that are dedicated to helping children.', '', '', 'Scrypt', '2017-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Flash', 'FLX', 'flx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@CryptoFlashDev', 'Flash is a PoW/PoS hybrid coin with fast and completely free transactions. FLX provides strealth adresses and an encrypted message system  \n  \n  \n!', '', 'POW Schedule  \nBlocks 1- 500: 500FLX  \nBlocks 500-1000: 250FLX  \nBlocks 1000-1500: 50FLX  \nBlocks 1500-2000: 25FLX\n\n  \nPOS Schedule  \nRandom is 1-100  \n1-500: rand \\* 500;  \n500-1000: rand \\* 250;  \n1000-1500: rand \\* 75;  \nProof of Stake  \nInterest: 1.25%  \n  \n10MB Block size.  \n  \nNo TX Fees, the way it should be', 'Scrypt', '2017-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BolivarCoin', 'BOLI', 'boli.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://bolicoin.com/', '@Bolivarcoin', 'BolivarCoin is a decentralized Proof of Work cryptocurrency based on and ment for the Venezuelan people, BOLI provides fast, cheap and anonymous transactions.', '', '', 'X11', '2017-05-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CludCoin', 'CLUD', 'clud.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://cludcoin.com/', NULL, 'CludCoin is a Proof of Work cryptocurrency that allows instant and cheap payments, while providing security with Scrypt algorithm encryption.', '', '', 'Scrypt', '2016-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DimeCoin', 'DIME', 'dime.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://dimecoin.org/', '@dimecoin_org', 'DimeCoin is a Quark based cryptocurrency designed to provide greater privacy and security.', '', '', 'Quark', '2014-11-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FlyCoin', 'FLY', 'fly.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'FlyCoin was created with the msission of promoting a scam-free and integrity-driven crypto community. FLY providing simple and fast transactions across the world.', '', '', 'X13', '2016-06-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'High Voltage Coin', 'HVCO', 'hvco.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@hvocoin', 'High Voltage Coin is a PoW/PoS hybrid designed to be a rare and efficient cryptocurrency. HVCO provides fast, anonymous and cheap transactions to anyone in the world.', '', '', 'SHA256', '2018-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GIZMOcoin', 'GIZ', 'giz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://gizmocoin.info/', '@GizmoCoin', 'GIZMOcoin is a decentralized cryptocurrency that favors coin holders and miners with a PoW/PoS hybrid algorithm. GIZMO provides fast and cheap transactions to anyone in the globe.', '', '', 'X11', '2017-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GrexitCoin', 'GREXIT', 'grexit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@Mojodevs', 'GrexitCoin is a peer to peer cryptocurrecny created as an alternative to the Euro, in case Greece leaves the European Union. GREXI provides fast and cheap transactions to anyone in Greece or anywhere else in the world.', '', '', '', '2017-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Carboncoin', 'CARBON', 'carbon.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@truecarboncoin', 'Carboncoin was created with a clear purpose: to fund and facilitate the fight against the climate change and envioremental damage caused by human beings and corporations. Being a enviroment-friendly coin itself, the CARBON blockchain can be maintained wth a low global hashrate.', '', '', 'Scrypt', '2014-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DigiEuro', 'DEUR', 'deur.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.digieuro-altcoin.com/', NULL, 'DigiEuro is a cryptocurrency created for the European community, it allows fast and free payments, while providing privacy and security.', '', '', 'Scrypt', '2017-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Turron', 'TUR', 'tur.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'Turron is a Prooft of Stake cryptocurrency that allows users to profit 8% anually from their holding. TUR profides fast and cheap transactions.', '', '', '', '2017-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LemonCoin', 'LEMON', 'lemon.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'LemonCoin is the result of the developer\'s continuous interest in the crypto world and its flaws. In order to address some of the major issues with most alternative cryptocurrencies, LEMON was built with its own algorithm: Argon2 + Scrypt-jane based on Argon 2, Lemon provides fast and secure transactions while favouring ease of acess and energy efficiency.\n\n8960948 unsold LEMON (out of the 10000000 premined) were burned after the ICO.', '', '', '', '2016-09-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'STRESScoin', 'STS', 'sts.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'STRESScoin is a PoW/PoS hybrid that wil change to full PoS. Designed to be a test cryptocurrency with the purpose of figuring out possible problems and solutions regarding the coin\'s current model STS will undergo various stress tests until conclusive results and met, at which point STRESScoin will arrange a swap for STS second generation coin.', '', '', 'X13', '2018-06-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Dark Lisk', 'DISK', 'disk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Dark Lisk is a PoW/PoS hybrid that will change to full PoS when 100000 are mined, awarding users with a 200% annual interest for Proof of Stake Mining. Dark Lisk uses the algorithm X11, which provides fast and anonymous transactions.', '', '', 'X11', '2016-09-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NevaCoin', 'NEVA', 'neva.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://nevacoin.pw/', '@nevacoin', 'NevaCoinis the first cryptocurrency to be created as a gift, it is a PoW/PoS Hybrid coin with a long Proof of Work period that will last pproximately 15 years. NEVA uses the Blake2s algorithm and provides an easy one-click miner incorporated in the wallet\n\n  \n  \n.', '', '', '', '2016-07-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cryptokenz', 'CYT', 'cyt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@Cryptokenz', 'Cryptokenz is a PoS cryptocurrency that will used in product/project funding by the CYT team. Cryptokenz plans to be attatched to it\'s own unique brand of hard/software products.', '', 'PoS Rewards:\n\n1 = Premine  \n2 - 150 = 0 Coins per block  \n151 - 1000 = 150% Pos Interest  \n1001 - 2000 = 200% Pos Interest  \n2001 - 2500 = 250% Pos Interest  \n2501 - 3000 = 300% Pos Interest  \n3001 - 4000 = 10% Pos Interest  \n4001 - 4200 = 1000% Pos Interest  \n4201 Onward = 30% Pos Interest', 'PoS', '2016-01-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Fuzzballs', 'FUZZ', 'fuzz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://fyi-koerier.nl/', NULL, 'FuzzBalls is a fun driven coin, intended for gifts and parties. the FUZZ blockchain is maintained by Proof of Work miners, who can then use FuzzBalls rewards to girft people in IRC or Chatrooms.', '', '', 'Scrypt', '2017-04-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Nukecoinz', 'NKC', 'nkc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.Nukecoinz.org/', NULL, 'Nukecoinz is a PoW cryptocurrency created to fight the abundance of low quality cryptocurrencies in existence. NKC can be sent worldwide for a small fee and almos instantly.\n\n[](https://youtu.be/zeBfZf1N7x4)', '', '', 'Scrypt', '2017-12-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SecretCoin', 'SCRT', 'scrt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://secretcoin.club/', '@SecretCoinDevs', 'SecretCoin is PoW/PoS hybrid cryptocurrency ment to be used in online game exchanges where it can be exchnaged for points/levels/weapons/vehicles/etc. the SCRT team created the coin as a way to develop games for the SecretCoin community.', '', '**Block Rewards**  \n500 coins per block until block 2000  \n250 coins per block until block 4000  \n125 coins per block until block 8000  \n62.5 coins per block until block 16000  \n31.25 coins per block until block 224000', 'X11', '2017-02-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ratecoin', 'XRA', 'xra.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://ratecoin.info/', '@Rate_coin', 'Ratecoin is a PoW/PoS cryptocurrency that allows users to make fast and cheap transaction while remaining anonymous.', '', '', 'X11', '2016-05-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'XanaxCoin', 'XNX', 'xnx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'XanaxCoin is a PoW/PoS hybrid cryptocurrency that allows fast and anonymous payments to anyone in the world. Its X11 algorithm is well known for providing strong privacy protection', '', '', 'Scrypt', '2017-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'StarCoin', 'STAR*', 'star_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'StarCoin is a easy-to-use PoW/PoS hybrid cryptocurrency. STAR can be sent to anyone in the world for a small fee and almost instantly.', '', '', 'Scrypt', '2016-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Stakerush', 'STHR', 'sthr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@stakerush', 'Stakerush is a high-reward PoS cryptocurrency with low supply, desiged to reward early adopters. STHR can be sent to anyone in the world instantly and for a low fee.', '', '', 'PoS', '2017-01-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Digital Bullion Gold', 'DBG', 'dbg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.digitalbulliongold.com/', NULL, 'Digital Bullion Gold is a Proof of Stake cryptocurrency designed to be a store value, it can also be transfered anywhere for a low fee and almost instanly. Users can use DBG to digitally back and prove ownership of their gold on the Blockchain.', '', 'Block Reward: 210  \nBlock Reward Halving Rate: 100000  \nDifficulty retarget: D.G.W.', 'PoS', '2016-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BonesCoin', 'BON', 'bon.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'BonesCoin is a Proof of Stake peer-to-peer cryptocurrency with high staking rewards. BON can be transfered to anyone in the world instantly and for low fees.', '', '', 'Scrypt', '2017-08-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'WMCoin', 'WMC', 'wmc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.digitalbulliongold.com/', '@wemcoin', 'The WMCoin is a PoW/PoS hybrid cryptocurrency, in Prof of Stake only phase. WMC can be sent anywhere in the world for low fees and anonymously, as payments to micro buisinesses and more. WMCoin focuses on games and marketplaces', '', '', 'X11', '2017-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GothicCoin', 'GOTX', 'gotx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'GothicCoin is a proof of Work cryptocurrency created for the gothic community.', '', '', 'Scrypt', '2016-03-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FlavorCoin', 'FLVR', 'flvr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://soundcloud.com/', '@flavorcoin', 'FLVR is a PoW/PoS hybrid cryptocurrency and it\'s a music driven project. 2FLAV is the second version of FlavorCoin, the previous version was swaped for the 9% premine.', '', '**PoW Block Rewards**  \n  \nBlock 1 = 675.000(swap)  \nBlock 2 - Block 100 = 0 (anti instamine)  \nBlock 101 - Block 1 100 = 1000(~1.000.000)  \nBlock 1 101 - Block 3 100 = 750(~1.500.000)  \nBlock 3 101 - Block 6 100 = 500(~1.500.000)  \nBlock 6 101 - Block 10 100 = 250(~1.000.000)  \nBlock 10 101 - Block 15 100 = 125(~625.000)  \nBlock 15 101 - Block 21 100 = 62.5(~375.000)  \nBlock 21 101 - Block 28 100 = 31.25(~218.750)  \nBlock 28 101 - Block 36 100 = 15.625(~125.000)  \nBlock 36 101 - Block 45 100 = 7.813(~70.317)  \nBlock 45 101 - Block 55 100 = 3.9(~39.000)  \nBlock 55 101 - Block 66 100 = 1(~11.000)  \n  \n**PoS Block Rewards**  \n  \nBlock 1 - Block 1 100 = 1(~11.000)  \nBlock 1 101 - Block 3 100 = 3.9(~39.000)  \nBlock 3 101 - Block 6 100 = 7.813(~70.317)  \nBlock 6 101 - Block 10 100 = 15.625(~125.000)  \nBlock 10 101 - Block 15 100 = 31.25(~218.750)  \nBlock 15 101 - Block 21 100 = 62.5(~375.000)  \nBlock 21 101 - Block 28 100 = 125(~625.000)  \nBlock 28 101 - Block 36 100 = 250(~1.000.000)  \nBlock 36 101 - Block 45 100 = 500(~1.500.000)  \nBlock 45 101 - Block 55 100 = 750(~1.500.000)  \nBlock 55 101 - Block 66 100 = 1000(~1.000.000)  \nBlock 66.101 ++ = 5 FLAV', 'SHA256', '2016-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ShrekCoin', 'SHREK', 'shrek.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://soundcloud.com/', '@flavorcoin', '2FLAV is a PoW/PoS hybrid cryptocurrency and it\'s a music driven project. 2FLAV is the second version of FlavorCoin, the previous version was swaped for the 9% premine.', '', '', 'Scrypt', '2017-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Stakers', 'STA*', 'sta_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, '[](https://youtu.be/zeBfZf1N7x4)\n\nStakers is a Proof of Stake cryptocurrency that allows users to earn an annual interest of 100% on their holdings. STA provides fast and secure transactions.', '', '', 'PoS', '2016-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Rise', 'RISE', 'rise.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://rise.vision/', '@RiseVisionTeam', 'RISE is a Dapp and Smart Contract creation and deployment user-friendly platform based on Lisk, and created to reinforce programming langueage diversity and security. Rise allows developers to use any programming language to create dapps as well as the creation of sidechains for specific decentralized applications, so that users don\'t have to download the whole Blockchain to use an app built on RISE.', '', '', 'DPoS', '2017-12-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Revenu', 'REV', 'rev.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://revsurfprofit.com/', NULL, 'REV is a Pow/PoS hybrid crypto currency and uses Revenu, which is an advertising platform site which acts as a MiddleMen(agent) between advertisers and surfers, to generate profir for members through advertisers & the revenue generated through external sources.', '', '', 'SHA256', '2017-12-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PabyosiCoin', 'PBC', 'pbc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://pbcinfo.net/', NULL, 'PabyosiCoin is a Proof of Work and Proof of Stake hybrid that allows users to earn a 3% interest on their holdings. PabyosiCoin uses X11 algorithm and provides fast, secure and anonymous transactions.', '', '', 'X11', '2018-01-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Obscurebay', 'OBS', 'obs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.Nukecoinz.org/', NULL, 'Obscruebay is a X11 cryptocurrency that offers fast and anonymous transactions.', '', '', 'X11', '2017-12-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ExitCoin', 'EXIT', 'exit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.Nukecoinz.org/', NULL, 'Exit is a blockchain application that can be used to perform peer-to-peer transactions in a fast, simple and secure way. EXIT allows P2P lending, digital asset management, industrial investment, smart contract and equity, crowdfunding', '', '', 'Scrypt', '2017-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EducoinV', 'EDC', 'edc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'EducoinV is a Proof of Work cryptocurrency designed to support student\'s education in Vietnam. EDC can be sent anywhere for a low fee and was created by a team of charitable teaches', '', '', 'Scrypt', '2017-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Clinton', 'CLINT', 'clint.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://myclint.us/', NULL, 'Clinton is a peer-to-peer Proof of Work cryptocurrency and can be send anywhere for a small fee and almost instantly.', '', '', 'SHA256', '2017-04-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Clockcoin', 'CKC', 'ckc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://myclint.us/', '@clockcoin', 'Clockcoin is a Scrypt PoW/PoS cryptocurrency that allows fast and anonymous transactions worldwide. CKC was desiged to be a payment system, where the ammount of CKC is proportional to the time spent on the serivce you want to pay or are being paid for.', '', '', 'SHA256', '2016-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'VIP Tokens', 'VIP', 'vip.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://viptokens.club/', '@clockcoin', 'VIP Tokens is a Pow/Pos Hybrid cryptocurrency that uses a combination of 5 encryption algorithms know as Nist5. VIP is designed to be an exclusive coin that will deliver high quality products to its members', '', 'Blocks: 0-20 : Airdrop  \nBlock: 20-100: 0 VIP  \nBlock: 100-1000: 500 VIP  \nBlock: 1000-30000: 450 VIP  \nBlock: 30000-60000: 300 VIP  \nBlock: 60000-100000: 250 VIP  \nBlock: 100000-150000: 150 VIP  \nBlock: 150000-200000: 110 VIP', 'NIST5', '2016-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NXEcoin', 'NXE', 'nxe.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.nxeprotocol.co/', '@nxeprotocol', 'NXEcoin is a PoW/PoS hybrid cryptocurrency that was swapped for DCX 1-1. NXE focuses on domain and alias creation.', '', 'Blocks: 0-20 : Airdrop  \nBlock: 20-100: 0 VIP  \nBlock: 100-1000: 500 VIP  \nBlock: 1000-30000: 450 VIP  \nBlock: 30000-60000: 300 VIP  \nBlock: 60000-100000: 250 VIP  \nBlock: 100000-150000: 150 VIP  \nBlock: 150000-200000: 110 VIP', 'NIST5', '2016-05-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZoomCoin', 'ZOOM', 'zoom.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'ZoomCoin is an ASIC resistant cryptocurrency that can be used to make anonymous and fast transactions.', '', '', 'Lyra2RE', '2016-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DT Token', 'DRACO', 'draco.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.drachmae.co.uk/', '@E_Drachma', 'DT Token is a NXT issued cryptocurrency through the Nxt monetary system.\n\nNXT Cryptocurrency ID: 13507468225104715822', '', '', '', '2016-12-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'YobitVirtualCoin', 'YOVI', 'yovi.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://yobit.net/', NULL, 'YOVI is the official Yobit exchange cryptocurrency. Created along with a new market type: ROM or Rise Only Market, in which coins can only be solde at a higher value than the last order.', '', '', 'SHA256', '2015-03-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OrlyCoin', 'ORLY', 'orly.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'OrlyCoin is a meme themed cryptocurrency based on the orly?! (oh really?!) meme. ORLY is a PoW/PoS hybrid coin and can be sent anywhere for a small fee.', '', '', 'X15', '2017-02-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'KubosCoin', 'KUBO', 'kubo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.kuboscoin.usa.cc/', NULL, 'KubosCoin is a Proof of Work and Proof of Stake hybrid cryptocurrency.', '', '', 'Scrypt', '2016-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'InceptionCoin', 'INCP', 'incp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Inception is a PoW/PoS cryptocurrency uses the well-known and highly regarded X11 algorithm. Inception will be a base for Fintech applications and will reward its first adaptors through a small PoW phase.', '', '', 'X11', '2016-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SharkCoin', 'SAK', 'sak.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.sharkcoin.org/', '@sharkcoins', 'SharkCoin is a anti-scam cryptocurrency based on Bitcoin. SHAK can be sent anywhere for a small fee an almost instantly.', '', '', 'SHA256', '2016-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EvilCoin', 'EVIL', 'evil.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://evilcoin.xyz/', '@evil_coin', 'EvilCoin was created to embrace, reward and inspire \"evil\". EVIL is a Pow/PoS cryptocurrency that uses the X11 algorithm, it allows fast and anonymous transactions across the blockchain.', '', '', 'X11', '2015-01-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OmegaCoin', 'OMA', 'oma.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'OmegaCoin is a PoW/PoS hybrid cryptocurrency that uses the x15 encryption algorith and can be sent anywhere almost instantly. 1,960,000 OMA were distributed during the ICO period', '', '', 'X15', '2018-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MonetaryUnit', 'MUE', 'mue.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.monetaryunit.org/', '@MonetaryUnit', 'MonetaryUnit is a cryptocurrency based on the Quark encryption algorithm. MUE can be sent anywhere for a low fee and offers a in-wallet blockchain messaging system', '', '', 'Quark', '2016-02-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CobraCoin', 'COX', 'cox.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'CobraCoin is a Proof of Work/Proof of Stake cryptocurrency that uses Scrypt as a consensus algorithm. COX can be sent anywhere in world instantly.', '', '', 'Scrypt', '2017-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Bancor Network Token', 'BNT', 'bnt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://bancor.network/', '@bancornetwork', 'The Bancor Protocol is a blockchain-based system for discovery and a liquidity mechanism supporting multiple smart contract platforms. The flexibility of these blockchains allows tokens to be locked in reserve and to issue smart tokens on the Bancor system, enabling anyone to instantly purchase or liquidate the smart token in exchange for any of its reserve tokens.\n\nThe BNT is the first smart token on the Bancor system and it will hold a single reserve in Ether. Other smart tokens, by using BNT as one of their reserves, connect to the BNT network. The BNT establishes network dynamics where increased demand for any of the network’s smart tokens increases demand for the common BNT, benefiting all other smart tokens holding it in reserve.', '', '', '', '2018-01-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EkoCoin', 'EKO', 'eko.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.ekocoin.org/', NULL, 'EkoCoin is a Proof of Work cryptocurrency based on Bitcoin and Litecoin.', '', '', 'Scrypt', '2016-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitSend', 'BSD', 'bsd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://www.bitsend.info/', '@Bit_send', 'BitSend is Pow/PoS hybrid cryptocurrency with a 100 years mining period. Users can earn rewards by running a masternode or mining with computational power. BitSend uses the X11 hashing algorithm, which allows features like Darksend and InstantX. Darksend allows users to send BSD anonymously and InstantX reduces confirmation period.', '', 'Darksend\n\nInstantX', 'X11', '2014-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Destiny', 'DES', 'des.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.kuboscoin.usa.cc/', NULL, 'Destiny is a Scrypt based cryptocurrency that will be swapped for an Expanse asset in the future. DES is currently a PoW/PoS hybrid.', '', '', 'Scrypt', '2016-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '16BitCoin', 'BIT16', 'bit16.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.16bit.ml/', '@16bit_coin', '16BitCoin is an arcade themed cryptocurrency, it can be mined with computational power or through staking your BIT16 balance and uses the Nist5 hashing algorithm.', '', '', 'NIST5', '2015-04-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Project Decorum', 'PDC', 'pdc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.project-decorum.com/', NULL, 'Project Decorum is a peer to peer digital social platform, its open source protocol that can be used to create and manage forums, comment sections, private communities and more. PDC allows you to create and manage a large number of different identities.', '', '', '', '2016-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CometCoin', 'CMT', 'cmt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://cometcoin.com/', '@cometcoin', 'CometCoin is a Proof of Work cryptocurrency created to provide ease-of-access to users new to the crypto community. CMT can be send anywhere in the world, for a small fee and almost instantly.', '', '', 'Scrypt', '2016-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ChessCoin', 'CHESS', 'chess.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://chesscoinpro.com/', '@Chess_Coin', 'ChessCoin is a PoW&PoS hybrid cryptocurrency, in which the Proof of Work stage ended before the launch, therefore CHESS can be considered 100% Proof of Stake. ChessCoin was designed to be used as a reward for winning online chess competitions, but can be used as a currency and sent anywhere almost instantly.', '', '', 'Scrypt', '2016-05-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SpaceCoin', 'SPACE', 'space.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@SpaceCoinLab', 'SpaceCoin is a Proof of Work and Proof of Stake hybrid cryptocurrency based on the Scrypt hashing algorithm. SPACE can be mined with computational power or with coin holdings.', '', '', 'Scrypt', '2017-07-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ReeCoin', 'REE', 'ree.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@SpaceCoinLab', 'ReeCoin is a peer-to-peer PoW/PoS hybrid cryptocurrency with increased security and a fast consensus mechanism.', '', '', 'Scrypt', '2016-08-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Liquid', 'LQD', 'lqd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@tech_liquid', 'Liquid is an NXT asset that pays monthly dividends to its holders.\n\nNXT asset ID: **4630752101777892988**', '', '', '', '2015-01-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Marvelous', 'MARV', 'marv.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Marvelous is a Scrypt based cryptocurrency that can be mined with computational power. MARV can be sent, recieved and stored on a computer and almost instantly.', '', '', 'Scrypt', '2016-10-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'XDE II', 'XDE2', 'xde2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'XDE II is a XDE swapped cryptocurrency, it\'s a 100% Proof of Stake coin with a 500% annual interest rate.', '', '', 'SHA256', '2017-07-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'VectorCoin 2.0 ', 'VEC2', 'vec2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'VectorCoin 2.0 is the new verison of VectorCoin, in which VEC could be freely swapped for VEC2.0. VectorCoin 2.0 is a Proof of Work cryptocurrency and uses the Hashimoto algorithm, from which Ethereum\'s algorithm (Ethash) was partly developed from.', '', '', 'Dagger-Hashimoto', '2018-06-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Omni', 'OMNI', 'omni.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.omnilayer.org/', '@Omni_layer', 'Omni is an asset and currency creation platform re branded from MasterCoin. Based on bitcoin, OMNI provides all the same features as bitcoin and advanced Omni Layer features, such as blockchain-based crowdfunding and asset creation, management and exchange.', '', '', 'Scrypt', '2015-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GenesysCoin', 'GSY', 'gsy.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://genesyscoin.com/', '@GenesysCoin', 'GenesysCoin is a Mulitplayer Gaming Cryptocurrency, that can be mined through PoW or PoS. GenesysCoin is the first cryptocurrency to have in-wallet games, which means users can play multiplayer games while staking GSY.', '', '', 'SHA256', '2016-02-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TrollTokens', 'TKN*', 'tkn_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'TrollTokens is a PoW/PoS hybrid cryptocurrency based on Bitcoin\'s hashing algorithm. TKN was created as a tribute to the figurative internet \"troll\".', '', '', 'SHA256', '2017-05-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Let it Ride', 'LIR', 'lir.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://letitri.de/', '@LetItRide_Dice', 'LIR is a gambling driven Proof of Stake cryptocurrency for the use designed to used in the Let it Ride Proveably fair gaming platform. LIR also plans to make blockchain gambling accessible through fiat gateways through The Waves Platform fiat gateway system, which is yet to be implemented.\n\nLIR pays dividends to the ICO investors and a 7% interest to Miners who stake Let it Ride coins.', '', '', 'POS 3.0', '2017-02-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MMNXT ', 'MMNXT', 'mmnxt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'MMNXT is a NXT asset that paid dividends to holders and works as an automated trading fund for NXT asset exchange. MMNXT has recently merged with EIX and formed the NEXT asset. Even though MMNXT does not pay dividends and is no longer swappable for NEXT, it can be freely traded in the regular exchange markets.\n\n**Asset ID: 979292558519844732**', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ScryptCoin', 'SCRPT', 'scrpt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@ScryptCurrency', 'ScryptCoin is a Proof of Work currency made for the Scrypt algorithm miners and users. SCRPT plans to add a feature in which any scrypt algorithm coin to be mined and converted through the SCRPT wallet.', '', '', 'Scrypt', '2018-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LBRY Credits', 'LBC', 'lbc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://lbry.io/', '@LBRYio', 'Lbry is a content sharing platform where users can define the terms and fees on which they wish to share their content, using Blockchain technology and Bittorrent protocol. LBC is a proof of work currency and can be mined using a GPU.', '', '', '', '2016-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Specie', 'SPX', 'spx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'Specie is a Proof of Stake cryptocurrency that allows users to make instant transactions to anyone in the world for a small fee. Users can stake SPX for a 5% annual interest.', '', '', 'PoS', '2016-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Steem Backed Dollars', 'SBD', 'sbd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://steemit.com/', NULL, 'Steem Backed Dollars or simply Steem Dollars are stable value pegged assets issued in the Steem.it platform. SBD are pegged to the value of the USD and can be redeemed on the Steem.it platform for about one dollar worth of Steem.\n\nWhen Content creators receive rewards on the Steem.it platform they are made available in 50% Steem Power, which can be redeemed continuously over a period of 104 weeks, and 50% SBD which can be fully redeemed for Steem in a 5 day period. SBD can also be transfered on the Steem Platform and can be exchanged outside of the Platform.', '', '', '', '2016-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CryptoJacks', 'CJ', 'cj.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://cryptojacks.com/', '@CryptoJacksCoin', 'CryptoJack is a PoW/PoS hybrid cryptocurrency focused on online gambling. CryptoJack\'s ICO extends over a 36 round period in which 10000000 coins will be sold, giving a total of 360000000 Coins being sold on the ICO. CJ uses the X13 algorithm for PoW and SHA-256 for PoS block hashing', '', '', 'X13', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PutinCoin', 'PUT', 'put.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://putincoin.org/', '@PutinCoinPUT', 'PutinCoin was created as a virtual tribute to Vladimir Vladimirovich Putin. PUT is a PoW/PoS hybrid cryptocurrency that allows users to mine with computational power or to stake through available balance.', '', '', 'Scrypt', '2017-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Kraken', 'KRAK', 'krak.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Kraken is a Proof of Work and Proof of Stake cryptocurrency with the same hashing algorithm as Bitcoin, SHA-256. Users can send and recieve Kraken freely and almost intantly.', '', '', 'SHA256', '2015-02-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Dlisk', 'DLISK', 'dlisk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DPoS', 'https://dlisk.com/', '@Dlisk_promo', 'DLISK is a Delegated Proof of Stake crytocurrency that acts as the native value token of the DLisk Platform. The Dlisk platform allows the creation of Decentralized Applications with popular programming languages like Node.js and JavaScript.\n\nDLisk is based in Lisk and uses the same Forging system, with the possibility to delegate DLISK Balance to pre-selected master nodes and get forging rewards without having to run a full node.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'iBankCoin', 'IBANK', 'ibank.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'iBankCoin is a Proof of Work / Proof of Stake cryptocurrency that uses the Scrypt encryption algorithm. IBANK can be sent anywhere for a small fee and almost intantly. iBankCoin works as a investment group that focuses on PoS coins and trading to generate revenue.', '', '', 'Scrypt', '2016-08-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Stratis', 'STRAT', 'strat.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.stratisplatform.com/', '@stratisplatform', 'Stratis is the native value currency in the Stratis Platform, it fuels the creation of private and public custom blockchains for corporate use. The Stratis Platform offers a one-click deployment system for custom blockchain deployment. These blockchains can be customized to suit the companies\' needs, and can even be deployed to mimic the features of popular blockchains like Ethereum or Lisk, which can be tested individually or in parallel.\n\nThe Stratis team will also function as a London Based consultancy agency that will help businesses to deploy the blockchain that best suits them.', '', '', 'X13', '2016-09-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Voyacoin', 'VOYA', 'voya.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@voyacoin', ' Voyacoin is a Proof of Work cryptocurrency that uses the Pluck-128 algoirthm and allows users to send and recieve transactions almost intantly.', '', '', '', '2016-09-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EnterCoin (ENTER)', 'ENTER', 'enter.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'EnterCoin is a Proof of Work and Proof of Stake hybrid cryptocurrency that allows users to send and recieve transactions almost instantly. ENTER uses the Scrypt hashing algorithm and has a 1 minute average block time.', '', '', 'Scrypt', '2018-05-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'World Gold Coin', 'WGC', 'wgc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://wgcglobal.com/', NULL, 'World Gold Coin is a Hong Kong based Proof of Work Cryptocurrency that allows users to send and receive transactions almost instantlyl WGC use Sha-256 as its hashing algorithm, like Bitcoin.', '', '', 'SHA256', '2016-11-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitMoon', 'BM', 'bm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.bitmoon.net/', NULL, 'BitMoon is a gambling cryptocurrency with its own provably fair game. It\'s a Proof of Stake cryptocurrency that uses the x13 hashing algorithm.', '', '', 'X13', '2017-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Frankywillcoin', 'FRWC', 'frwc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Frankywillcoin is an PoW/PoS Scrypt cryptocurrency.', '', '', 'Scrypt', '2017-08-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Psilocybin', 'PSY', 'psy.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Psylocybin is a Proof of Work & Delegated Proof of Stake hybrid cryptocurrency, created as a tribute to Psilocybin mushrooms also known as \"Magic Mushroom\". PSY is a sha256d currency and has an average 1 minute block time.', '', '', 'SHA256D', '2017-03-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ExtremeCoin', 'XT', 'xt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'ExtremeCoin is a PoW/PoS cryptocurrency. It uses the Scrypt hashing algorithm and has a 64 second average block time.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RustCoin', 'RUST', 'rust.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'RustCoin is the in-game cryptocurrency for the Rust RPG game, which is currently available on Steam. It\'s a Scrypt PoW/PoS cryptocurrency.', '', '', 'Scrypt', '2016-03-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NewZealandCoin', 'NZC', 'nzc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'NewZelandCoin is a Proof of Work cryptocurrency.', '', '', 'Scrypt', '2017-08-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SingularDTV', 'SNGLS', 'sngls.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://singulardtv.com/', '@SingularDTV', 'SingularDTV (S-DTV) is a decentralized and tokenized content creating and distributing platform that will create, acquire and distribute film and television content in an innovative way, generating revenue for its token holders in a completely transparent and decentralized manner.\n\nSNGLS are tokens built on **Ethereum** and represent a share in the SingularDTV platform, which is comprised of four key elements:\n\n**‘SINGULAR’** – a mini Sci-fi television series about decentralization and technological advancements in a futuristic setting, comprised of 3 episode seasons.\n\n**The S-DTV DOCUMENTARY DIVISION** - A Documentary Division that will focus on producing documentary films about blockchain technology.\n\n**THE S-DTV RIGHTS MANAGEMENT PLATFORM** - A digital rights, revenue and royalty management platform for all the content produced and acquired by SingularDTV.\n\n**THE S-DTV TRANSACTION** **VIDEO-ON-DEMAND (TVOD) PORTAL** - A TVOD Portal to distribute SingularDTV content via GooglePlay, AppleTV iTunes, and Vimeo.\n\nSNGLS tokens will also generate dividends for its holders, depending on the revenue gathered by the SingularDTV platform. 1 Billion SNGLS tokens will be issued, which will be distributed in the following way:\n\n**500M SNGLS** will be distributed to investors in an initial coin offering period. Each token will cost the ETH equivalent of $0.015.\n\n**400M SNGLS** will be kept in a vault, and the dividends generated by the tokens will be used to further develop the S-DTV ecosystem.\n\n**100M** **SNGLS** will be given to S-DTV\'s core investors.\n\nThe **Vault** where 400M tokens are kept will be managed by the **Workshop**. The Workshop will not only spend and convert ETH to build new projects or to work on existing ones, but it will also collect cryptocurrency and fiat revenue to deposit back in the safe.', '', '', '', '2016-02-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Xaurum', 'XAUR', 'xaur.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.xaurum.org/', '@urumproject', 'Xaurum (XAUR) is a smart contract & token system built on Ethereum. It was developed from the previous PoS blockchain, Xaurum (XAU) which was migrated to the Ethereum platform to lower costs and inflation associated wwith mantaining a Proof of Stake 2.0 cryptocurrency.\n\nXaurum is gold backed crypto asset, that derives its value from the gold reserves maintained by the Auresco Institute, a non-profit organization created by the Xaurum team. Xaurum is ment to be used as a store of value since the gold base that backs Xaurum is always growing.\n\nThe former cryptocurrency, Xaurum (XAU) had an ICO period, in which 1016 XAU coins were sold. In the RICO period, these XAU coins are exchangeable for XAUR at a 1-8000 rate. During this RICO period, anyone was also allowed to send cryptocurrencies and fiat currencies to the Auresco Institute to recieve newly created XAUR.\n\nIn this smart contract system, the old PoS XAU coins that were swapped and the ones that were minted in the RICO period will be in circulation (all of these coins have been backed by gold), and the remaining supply is locked (the locked supply is not backed by gold). Xaurum users have two ways of acquiring tokens, you can earn them in the \"Goldmine\" or Mint them.\n\nWhen mining on the Goldmine, users are exchanging their hashpower in a multipool. The earned coins from staking and mining these cryptocurrencies is used to buy more gold and to release Xaurum that was previously locked into circulation, by backing it with the newly bought gold. The proceeds from the Multipool can also be used to buy Xaurum in an exchange and pay the miners, depending on the market value of Xaurum, mined cryptocurrencies and the gold itself.\n\nwhen Minting new coins, users are allowed to send fiat currencies directly to the Auresco Institute in exchange for new coins. These users are called Masternodes but they do not mantain the blockchain. Instead, they are required to have a 1000 XAUR collateral (like Dash masternodes), in order to create new coins. This ensures that any fraud attempt would not be profitable for the Xaurum masternodes.\n\nProfits from running the PoW multipool and from the Minting process are sent to the Commonwealth wallet, and allow the Xaurum system to increase their gold supply at a must faster pace than the XAUR supply itself.', '', '', '', '2017-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitFinex Tokens', 'BFX', 'bfx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'BitFinex Tokens were issued by BitFinex as obligations by the exchange for the 36% haircut on customer account after the hack in August 2016. It is not fully clear what the rights are that are attached to the token and it has been suggested that there is a form of put and call option attached.\n\nIn this case the market cap figure is the total market capitalisation of the debt obligation tokens which was originally set at $72m.\n\n40 million tokens have been exchanged for equity in Bitfinex', '', '', '', '2016-10-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Uniqredit', 'UNIQ', 'uniq.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://uniqredit.com/', NULL, 'UniQredit is a decentralized Finance Platform that allows everyday users, corporations and non-profit organizations to borrow and lend money in a p2p enviroment. UNIQ enables users to access features like Micro Branking, Insurance and Equity Markets.', '', '', 'SHA256D', '2017-02-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ChronosCoin', 'CRX', 'crx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://chronos-coin.com/', '@_Pennyauction_', 'ChronosCoin is a scrypt PoW/PoS hybrid cryptocurrency, created with an airdrop fair launch and designed to be used as the main currency in the PennyAuction.Click website. Profits from bidding websites will be distributed across users via blockchain.', '', '', 'Scrypt', '2016-09-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Decent', 'DCT', 'dct.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://decent.ch/', '@DECENTplatform', '[Decent](https://decent.ch/) is a decentralized open source content distribution platform that allows anyone to buy, sell, or share content without unnecessary middleman fees or manipulation. Using Decent, authors can share their content directly with consumers using blockchain technology and a modified version of the Bittorrent protocol, without any cultural, geographical or political limitations.\n\nDecent holds multiple advantages over traditional platforms, such censorship resistance, which is ensured by Decent\'s decentralized nature where no single server can be targetted or shut down (It is also impossible to target specific nodes with one piece of content in mind). It allows consumers to acquire content for a cheaper price, while the content creators can keep 100% of the profits. Furthermore, there is no central authority that dictates what content is worth downloading, meaning that content creators are free to express themselves completely and to succeed (or fail) in their craft, regardless of what corporations or governments see fit. The reputation, recommendation, and feedback systems will give every user an equal opportunity.\n\nDecent will host an ICO starting on the 10th of September in which 70% of the DCT tokens\' total supply will be sold for ETH and BTC. The remaining 30% will be used for mining rewards. DCT tokens are used to fuel the Decent Platform and is required to publish and buy content. Users can choose to set the price for their published content.', '', '', '', '2016-10-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PokeChain', 'XPOKE', 'xpoke.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'PokèChain is a Pokemon based cryptocurrency that plans to release an in-wallet pokemon exchange that allows users to exchange pokemons or buy/sell them with XPOKE.', '', '', 'X13', '2018-04-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MudraCoin', 'MUDRA', 'mudra.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'MudraCoin is a Proof of Stake cryptocurrency that uses the x13 hashing algorithm. MUDRA can be sent anywhere almost instantly and for a low fee', '', '', 'X13', '2016-01-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'WarpCoin', 'WARP', 'warp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'WarpCoin is a Proof of Stake cryptocurrency that aims to create a network of systems and services exclusively for WARP users.', '', '', 'PoS', '2017-10-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Coinomat', 'CNMT', 'cnmt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'Coinomat is a dividend paying asset on the Nxt Platform that represents a share in the Coinomat instant exchange.\n\nNXT Asset ID: **7474435909229872610**', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PizzaCoin', 'PIZZA', 'pizza.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'PizzaCoin is a cryptocurrency dedicated to the popular Pizza dish. Using the X11 Proof of Work algorithm, PIZZA can be sent anywhere instantly and for low fees.', '', '', 'X11', '2017-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Lutetium Coin', 'LC', 'lc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'Lutetium is a X11 Proof of Stake cryptocurrency that aims at creating a share-based mining concept, in which 100% premined supply is destributed across users who buy or recieve LC shares.', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Heat Ledger', 'HEAT', 'heat.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS/PoP', NULL, NULL, 'Heat Ledger is a cryptocurrency written in Java that aims to solve scalability problems associated with Bitcoin and other cryptocurrencies. Heat Ledger offers sidechain solutions for corporate and personal use, and has a built-in decentralized \"coin-to-coin\" exchange, that allows users to trade cryptoassets between themselves or even fiat currency pegged assets.\n\nHear Ledger\'s block rewards are given out according to a traditional Proof of Stake system and a new Proof of Presence system that checks for nodes that host the block files online.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Iconomi', 'ICN', 'icn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://www.iconomi.net/', '@https://twitter.com/iconominet', 'Iconomi is an European based exchange that allows users to easily acquire Ether with EUR. Iconomi has recently expanded into a crowdfunded project, the Iconomi Open Fund Management platform. In the Iconomi OFM, users can choose between two investment types with different risk and profit levels, Coin Traded Funds (CTFs) and Coin Managed Funds (CMFs).\n\nIconomi (ICN) tokens allow users to vote regarding the platform\'s development and they pay out dividends from the profits generated by the Iconomi OFM platform.', '', '', '', '2018-01-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ExaByte (EXB)', 'EXB', 'exb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'ExaByte is a multi-algorithm Proof of Work cryptocurrency that can be mined through a Sha256, Scrypt or Myriad-Groestl hashing algorithm, depending on the user\'s mining hardware.', '', '', 'SHA256', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Wings DAO', 'WINGS', 'wings.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://wings.ai/', '@wingsplatform', 'Wings is a platform where users can create and invest in Decentralized Autonomous Organizations (DAOs). These DAOs can be created without any specific coding knowledge or technical skills, and are approved through a prediction market feature. the Wings Platform is run by a DAO itself, the Wings DAO. Wings DAO tokens, WINGS, represent a share within that DAO and allows users to vote on the developments of the platform, and to recieve dividends from the fees generated within the platform.', '', '', '', '2018-07-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cryptodex', 'CDX', 'cdx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://cryptodex.io/', '@CryptodexPools', 'Cryptodex is an investment platform and educational portal that reduces the risk and volatility associated with investing in a single cryptocurrency, by grouping them into general purpose pools that can be invested in by the Cryptodex user. Investing in a specific cryptocurrency pool (group) unlocks the section of the educational portal relative to the cryptocurrencies included in that same pool.\n\nThe revenue generated by the fees collected in the Cryptodex platform will be distributed to all CDX holders', '', '', '', '2017-08-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ReturnBit', 'RBIT', 'rbit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@http://www.returnbit.com/', 'ReturnBit is an investment platform that uses blockchain to reward users via a trust fund dubbed rTrust. The rTrust gets its funds from the block rewards, from which 50% is allocated to it, and from the transaction fees that are generated from RBIT transactions. Users can then, send RBIT to the special rTrust address.', '', '', 'Scrypt', '2017-03-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'deCLOUDs', 'DCS.', 'dcs..jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.declouds.com/', '@decloudscom', '**Previous information:**\n\ndeCLOUDs is a decentralized cloud-based crypto platform that allows users to issue assets and tokens and to exchange them on a peer-to-peer basis. deCLOUDs\' system groups nodes into virtual clouds by geographic location and ping time to make interaction between all members ion platform faster and more efficient. deCLOUDs allows asset-to-asset and cross token exchange and it can be acessed via light client, meaning that anyone with an internet connect can mine CLOUD through a PoS system.', '', '', '', '2016-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Komodo', 'KMD', 'kmd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'dPoW/PoW', 'https://komodoplatform.com/', '@komodoplatform', 'Komodo is a privacy-centric cryptocurrency that combines the anonymity of ZCash with the security of Bitcoin. Using a new consensus mechanism developed by the Komodo team, delayed Proof of Work, Komodo blocks can be notarized using the Bitcoin blockchain. KMD is issued through an Equihash-based PoW protocol, and the new block information is sent to pre-voted notary nodes. These nodes insert the Komodo block information on the BTC blockchain by creating a custom transaction. This system ensures that in order to \"hack\" komodo, one would have to rewrite both chains.  \n  \nKomodo uses Zero Knowledge Proofs to provide 100% anonymous transactions, that are now secured with Bitcoin\'s hash rate.', '', '', 'Equihash', '2016-01-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GoldBlocks', 'GB', 'gb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://goldblocks.eu/', NULL, 'GoldBlocks is a gold based PoW/PoS cryptocurrency that is based on the idea of portable wealth.', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NEO', 'NEO', 'neo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://neo.org/', '@neo_blockchain', 'NEO is a platform in which users can issue and trade assets. NEO has been rebranded from the original \'Antshares\'. NEO tokenizes proofs of ownership of an asset and not the asset itself, thus taking into account all of the legal complications and obligations that may come with the transfer of shares, equity and assets.\n\nNEO represent an ownership of the NEO platform and allows users to buy NEO (ANC) and to vote on protocol changes on the NEO blockchain. ANS are 100% premined and issued on the NEO\'s genesis block.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Anoncoin', 'ANC', 'anc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://anoncoin.net/', '@AnonCoinProject', 'Anoncoin is a cryptocurrency that supports the i2p darknet for transactions, providing a higher degree of anonimity. With the addition of being fully tor compatible there is a huge possibility of hiding in plain sight by transferring coins using the darknet only.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Syndicate', 'SYNX', 'synx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://syndicateltd.net/', '@syndicate_ltd', 'The Syndicate Platform aims to provide a modular and secure crypto platform that simplifies employee and asset management. SYNX itself is a x11 Proof of Work/Proof of Stake cryptocurrency.', '', '', 'X11', '2017-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Mass Coin', 'MC', 'mc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://mass.network/', '@network_mass', 'The Mass Network is a blockchain based system in which users are rewarded for their attention and data. The Mass Network software shields users\' data and allows them to set a price they are willing to accept for revealing it, thus creating a free market for advertisers and consumers, in which the websites act as mediators. Mass Coin (MC) is the native currency in the Mass Network system.', '', '', '', '2016-02-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'E-Dinar Coin', 'EDR', 'edr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DPoS', 'https://edinarcoin.com/', '@edinarworldwide', 'E-Dinar Coin is a DPoS cryptocurrency that uses the X11 algorithm. EDR gives up to 0.65% daily staking rewards and an affiliated referral bonus user network. The total supply of EDR coins will be mined within 33 years.', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Jewels', 'JWL', 'jwl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@JewelsCoin', 'Jewels is a Proof of Stake cryptocurrency that will be used as an in-game currency in games from the \"Pro4Never Network\". Currently, it’s primary use case will be in that of “Apex Conquer”.', '', '', 'POS 3.0', '2017-01-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'WayCoin', 'WAY', 'way.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://wayguide.club/', NULL, 'WayGuide is a social platform for travelers, turists and storytellers. The WayGuide Platform has a WayCoin wallet that allows users to be paid for sharing their traveling stories. WayCoin (WAY) itself is a X11 Proof of Stake cryptocurrency.', '', '', 'X11', '2018-01-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MollyCoin', 'TAB', 'tab.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Molly_Tab', 'MollyCoin is a PoW/PoS hybrid cryptocurrency dedicated to the MDMA drug community. TAB uses Scrypt as an hashing algorithm and has a 60 second blocktime.', '', '', 'Scrypt', '2017-03-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Trigger', 'TRIG', 'trig.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://www.blocksafefoundation.com/', '@blocksafe', 'Blocksafe is a decentralized protocol for managing access to firearms. Blocksafe is being built on Lisk as a sidechain and is powered by the Trigger (TRIG) token, the native currency within the Blocksafe system.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'bitCNY', 'BITCNY', 'bitcny.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'bitCNY is a market pegged asset (MPA) issued on the Bitshares platform, these assets are known as bitassets or smartcoins. Smartcoins always have 100% or more of its value backed by BitShares (BTS), and can be redeemed for it at any time. Since the exchange rate of BTS to CNY can change, the blockchain protocol deals with increasing and decreasing supply accordingly. This allows users to trade and transfer stable priced tokens across the blockchain and to trade real world commodities like gold and silver in a decentralized manner.', '', '', '', '2015-05-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'bitUSD', 'BITUSD', 'bitusd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'bitUSD is a market pegged asset (MPA) issued on the Bitshares platform, these assets are known as bitassets or smartcoins. Smartcoins always have 100% or more of its value backed by BitShares (BTS), and can be redeemed for it at any time. Since the exchange rate of BTS to USD can change, the blockchain protocol deals with increasing and decreasing supply accordingly. This allows users to trade and transfer stable priced tokens across the blockchain and to trade real world commodities like gold and silver in a decentralized manner.', '', '', '', '2015-05-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Autumncoin', 'ATM', 'atm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Autumcoin is a Proof of Work/Proof of Stake hybrid cryptocurrency.', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Save The Ocean', 'STO', 'sto.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Save The Ocean is a Proof of Work/Proof of Stake hybrid cryptocurrency that uses the popular x11 hashing algorithm. The STO cryptocurrency was designed to create and fund a movement to raise awareness regarding the degradation of the oceans through a carefully designed roadmap.', '', '', 'X11', '2018-07-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Sense', 'SNS', 'sns.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.sensusapp.co/', '@sensusmobile', 'Sense (SNS) is the native currency of Sensus, a Incentivized Crowd-Wisdom mobile application that allows users to ask and answer questions in an incentivized environment, thus producing higher quality answers and rewarding users for their time and effort.\n\nThe Sensus platform will allows users to choose a target demographic, pose direct question to specific users and to build a reputation within the system. Sensus will have a built-in exchange that will allow users to trade, buy, and sell SNS with Bitcoin or even fiat currencies. The Sensus payment infrastructure is built on the Ripple network and will allow transactions to be almost instant', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Fusion', 'FSN', 'fsn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://fusioncoindev.wixsite.com/', '@FusionFSN', 'Fusion is a peer-to-peer cryptocurrency that uses the SHA256 hashing algorithm.', '', '', 'SHA256', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CarterCoin', 'CTC', 'ctc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.cartercoinweb.com/', NULL, 'CarterCoin is a PoW/PoS cryptocurrency based on NovaCoin, with the goal of providing a long-term energy-efficient scrypt-based coin.', '', '', 'Scrypt', '2017-02-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TotCoin', 'TOT', 'tot.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'TotCoin is a Scrypt Proof of Work/Proof of Stake cryptocurrency with a 120 second block time.', '', '', 'Scrypt', '2016-08-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Bitcloud', 'BTD', 'btd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://bit-cloud.net/', '@Bitcloud_BTD', 'Bitcloud is a scrypt PoW/PoS hybrid (currently in PoS stage) cryptocurrency that wants to \"decentralize the Internet\" through a new Proof of Stake/Proof of Host protocol, where Hostnodes will provide space, cpu and ram.', '', '', 'Scrypt', '2016-01-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ArkDAO', 'BOTS', 'bots.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.arkdao.com/', '@monkeyscage', 'ArkDAO is a decentalized application built on Ethereum where users can list newly created cryptocurrencies for a 1 ETH antispam fee, and where the community can easy find them in real time manually, or via smart contract.\n\nARK is the first Collaborative Market - A group of microeconomical actors joining together to offer a service to the public, all ruled by a trustless smart contract.\n\nWhen someone lists a new coin, the fee will be paid to one of the BOT holders. A trustless multiplexer pointer then redirects the next user to another bot randomly, until all the all BOTs have received been \"used\" and the cycle restarts.', '', '', '', '2016-08-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MedicCoin', 'MDC', 'mdc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://mediccoin.wordpress.com/', '@MDCTeam', 'MedicCoin is a PoW/PoS cryptocurrency that uses the scrypt hashing algorithm.', '', '', 'Scrypt', '2015-01-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FuturePoints', 'FTP', 'ftp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.ftpcoin.com/', NULL, 'FuturePoints is a free open source project derived from NovaCoin, it\'s a X11 cryptocurrency with a PoS consensus mechanism.', '', '', 'X11', '2017-03-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Zeta2Coin', 'ZET2', 'zet2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Zeta2Quark', 'Zeta2Coin is a PoS cryptocurrency. It uses the Quark algorithm and has a 30s block time.', '', '', 'Quark', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CovenCoin', 'COV*', 'cov_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@covencoin', 'CovenCoin is a PoW/PoS hybrid cryptocurrency using the SHA256 hashing algorithm and a 60 second block time.', '', '', 'SHA256', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Karbowanec', 'KRB', 'krb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://karbowanec.com/', '@krbcoin', 'Karbowanec is a Proof of Work cryptocurrency that uses the cryptonight hashing algorithm. It was created as a national cryptocurrency for the Ukranian community', '', '', 'CryptoNight', '2018-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Tellurion', 'TELL', 'tell.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://tellurion.info/', '@telluriondev', 'Tellurion is a Proof of Work/Proof of Stake hybrid cryptocurrency that uses the well-known X11 hashing algorithm. It is currently in the PoS stage and it has a 60 minute block time', '', '', 'X11', '2016-04-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EneCoin', 'ENE', 'ene.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@ene_coin', 'EneCoin is a X13 PoW/PoS cryptocurrency built for the anime community. It aims to incentivize users that play the upcoming RPG game that EneCoin plans to develop.', '', '', 'X13', '2016-08-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TDFB', 'TDFB', 'tdfb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'TDFB, which stands for  Tricky Dick Fun Bills, is a PoW/PoS cryptocurrency that aims to make a statement regarding the real value of fiat currencies. According to the developers, anyone can choose to use and transfer TDFB, making it as worthy as fiat currencies like the USD, which have nothing backing them since the gold standard ended.', '', '', 'SHA256D', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BlockPay', 'BLOCKPAY', 'blockpay.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://blockpay.ch/', '@blockpay_ch', 'Blockpay is a cryptocurrency point-of-sale system that allows merchants to easily receive cryptocurrency payments. Blockpay supports Bitcoin, Bitshares, Ether, Litecoin, Dash, Dogecoin, Steem, and Peercoin. Customers can even pay for goods or services with smartcoins like bitUSD or bitCNY.   \n  \nBlockpay offers many advantages over traditional systems, such as fraud, ID theft, chargebacks and rolling reserves. It can be used with the existing equipment and the software itself is free.  \n  \nBlockpay tokens were issued on the Bitshares blockchain and represent a share in the revenues of Blockpay, meaning that Blockpay tokens allow users to share in the rewards from BlockPay transactions as well as value   \nincreases from products built by the Company.', '', '', '', '2016-05-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitTokens', 'BXT', 'bxt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@gladimorcrypto', 'BitTokens is a cryptocurrency that aims to be an improved version of Bitcoin, with faster blocktimes and higher transaction capabilities. BitTokens use the Sha256d hashing algortihm and have a 3 minute block time.', '', '', 'SHA256', '2017-11-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZayedCoin', 'ZYD', 'zyd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://zayedcoin.net/', '@ZayedCoin', 'ZayedCoin is a Proof of Work cryptocurrency that uses the Bitcoin hashing algorithm and has a 90 second blocktime. ZYD had no ICO or premine and aims to be a \"fair launch\" cryptocurrency.', '', '', 'SHA256', '2016-07-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MustangCoin', 'MST', 'mst.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://mustangcoin.xyz/', NULL, 'MustangCoin is a Proof of Work/Proof of Stake hybrid cryptocurrency. It uses the X11 Hashing algorithm and has a 90 second block time.', '', '', 'X11', '2016-05-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Goonies', 'GOON', 'goon.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://gooncoin.tk/', '@GoonBagSack', 'Goonies is a Scrypt Proof of Work cryptocurrency witha 60 second blocktime. The block reward halves every 255 days.', '', '', 'Scrypt', '2018-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Veltor', 'VLT', 'vlt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://veltor.org/', '@j_veltor', 'Valtor is a cryptocurrency that focuses on stability, efficiency and long term scaling implementing a Lightning Network like feature, providing viable transaction privacy without bloating the blockchain and eliminating the drawbacks of longer block time. VLT has a 30 minute block tiem and it uses the custom hashing algorithm \"Thor\'s secret\".', '', '', '', '2016-12-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZoneCoin', 'ZNE', 'zne.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@ZonecoinTech', 'ZoneCoin is a Proof of Work/Proof of Stake cryptocurrency that uses the Scrypt Algorithm. It has a 64 second blocktime and 10% yearly staking rewards.', '', '', 'Scrypt', '2016-05-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DickCoin', 'DCK', 'dck.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://dickcoin.biz/', '@Team_DickCoin', 'DickCoin is a cryptocurrency that aims to bring awareness to sexism against men. It\'s a PoW/PoS hybric cryptocurrency with the X11 algorithm', '', '', 'X11', '2016-06-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Circuits of Value', 'COVAL', 'coval.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://cov.al/', '@circuitsofvalue', 'Circuits of Value is a rewards program supported by block chain technology. Buyers and sellers transacting in goods and services or giving charitable donations in any currency earn RibbitRewards. No matter what currency you are transacting in, the more you buy, sell, or donate on Marketplace.Life or other participating merchant sites, the more COVAL you can earn.', '', '', 'Multiple', '2015-02-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DarkGold', 'DGDC', 'dgdc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'DarkGold is a PoW/PoS hybrid cryptocurrency that uses the x13 hashing algorithm. There are 1m DGD coins, 560k of which have been burned.', '', '', 'X13', '2015-10-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TodayCoin', 'TODAY', 'today.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'TodayCoin is a Proof of Work cryptocurrency that, like Litecoin, uses the Scrypt hashing algorithm', '', '', 'Scrypt', '2018-05-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Verium', 'VRM', 'vrm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoWT', 'http://www.vericoin.info/', '@VeriumReserve', 'Verium is a cryptocurrency created by the developers of Vericoin. Together, these two coins (Verium and Vericoin) create a \"system\" in which Vericoin acts as currency, due to its cheap transaction fees and faster block times, while Verium acts as a store of value due to its higher fees and slower blocktimes that dis-incentivize spending. Verium uses the Proof of Work Time consensus protocol that has variable block times to increases blockchain performance and security. PoWT also allows mining to be GPU and ASIC resistant.', '', '', '', '2017-04-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RootCoin', 'ROOT', 'root.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'RootCoin is a Proof of Work/Proof of Stake cryptocurrency, although the PoW phase ended on block 3700. Rootcoin has a 5 minute block time and uses the Scrypt algorithm', '', '', 'Scrypt', '2016-02-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FirstBlood', '1ST', '1st.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://firstblood.io/', '@firstbloodio', 'FirstBlood is a decentralized platform where gamers can be rewarded for their gaming skills. Built on Ethereum, the First Blood platform allows users to bet against each other on mainstream games and for the results to be verified and settled automatically via a smart-contract system, eliminating attack vectors, middlemen, and server down time.', '', '', '', '2018-01-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Gold Pressed Latinum', 'GPL', 'gpl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Gold Pressed Latinum is a Proof of Work/Proof of Stake hybrid inspired by Star Trek. It\'s based on YACoin and on the scrypt-jane algorith.', '', '', '', '2015-03-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DopeCoin', 'DOPE', 'dope.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.dopecoin.com/', '@dopecoinGold', 'DopeCoin is a Proof of Work cryptocurrency created for the cannabis community. It has a 60 second blocktime and uses the scrypt algorithm.', '', '', 'Scrypt', '2015-09-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'B3 Coin', 'B3', 'b3.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'B3 Coin is a Proof of Work/Proof of Stake cryptocurrency with a 6 minute block time. B3 uses the X11 hashing algorithm, which is very popular.', '', '', 'X11', '2018-02-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FCoin', 'FX', 'fx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Fcoin2', 'FCoin is a Scrypt cryptocurrency. It employs a Proof of Work/Proof of Stake consensus prtocol and 10 minute block times. The total suppy for FX is 987600000 with a 15% premine.', '', '', 'Scrypt', '2016-04-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Pioneershares', 'PIO', 'pio.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.blockpioneers.info/', '@BlockPioneers', 'Pioneershares is a X11 Proof of Work /Proof of Stake cryptocurrency with a relatively small supply, 200k coins. Each coin represents a share in the Blockpioneers exchange that will launch later in 2016. PIO will pay dividends according to the revenue made in the Blockpioneers exchange platform.', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GayCoin', 'GAY', 'gay.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.gaycoin.online/', '@GayCoin', 'GayCoin is a X11 Proof of Work/Proof of Stake hybrid cryptocurrency created for the Lesbian, Gay, Bisexual, Trans and Queer community. It has a 10 billion coin supply and a 60 second block time.', '', '', 'X11', '2017-02-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Samsara Coin', 'SMSR', 'smsr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://samsara.pw/', '@SamsaraCoin', 'Samsara Coin is a PoW/PoS cryptocurrency that uses the QuBit algorithm. Samsara Coin developers plan to create a succesful business around the coin in china that will be around for years to come', '', '', 'QuBit', '2017-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ubiqoin', 'UBIQ', 'ubiq.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://ubiquoin.com/', NULL, 'Ubiquoin is a Proof of Stake cryptocurrency designed to address the biggest challenge of any cryptocurrency, mass adoption and use. Ubiquoin is focused on making the user experience easy and the reasons for using Ubiquoin endless.', '', '', 'Progressive-n', '2017-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Armory Coin', 'ARM', 'arm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Armory Coin is a Proof of Work/Proof of Stake cryptocurrency. It has a 480 second block time and uses the Scrypt algorithm.', '', '', 'Scrypt', '2017-06-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RingCoin', 'RING', 'ring.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'RingCoin is a scrypt cryptocurrency with a Proof of Work/Proof of Stake hybrid consensus mechanism.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ERBCoin', 'ERB', 'erb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://endroadbullying.org/', '@erbcoin', 'ERB is a reward coin for motorists who contribute to the safety of our roadways. A point system has been devised rewarding specific driving behaviors that reduce congestion on the roads, and allow traffic to flow more smoothly. This, in turn, will alleviate many of the stresses that typically come with everyday driving, and thus reduce \"road rage\" incidents and accidents.  \n.', '', '', 'Scrypt', '2017-07-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Lazarus', 'LAZ', 'laz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DPoS', 'http://lazaruscoin.com/', NULL, 'Lazarus is a delayed Proof of Work crypto-currency and decentralized application platform, written entirely in JavaScript. Lazarus is designed for the needs of business and organisations that want to develop on the blockchain.', '', '', 'DPoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FonzieCoin', 'FONZ', 'fonz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://fonziecoin.com/', NULL, 'FonzieCoin is a Fonzie themed cryptocurrency. It had a fair Proof of Work launch and uses the SHA256.', '', '', 'SHA256', '2015-07-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitCurrency', 'BTCR', 'btcr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@BitcurrencyTeam', 'BitCurrency is a Proof of Stake cryptocurrency. It has a 64 second block time and uses Scrypt as its hashing algorithm.', '', '', 'Scrypt', '2015-09-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FaucetCoin', 'DROP', 'drop.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://faucetdrop.com/', '@FaucetDrop', 'FaucetCoin is a Proof of Stake cryptocurrency distributed through faucets. It uses the X13 hashing algorithm', '', '', 'X13', '2016-10-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Save and Gain', 'SANDG', 'sandg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Save and Gain is a Proof of Work cryptocurrency that employs a system to create more demand and lower supply. SANDG devs keep a Proof of Stake coins fund, the profits from the coins staked are used to buy SANDG, which is then burned.', '', '', 'SHA256', '2016-04-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SteamPunk', 'PNK', 'pnk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@SteamResource', 'SteamPunk is a Proof of Stake cryptocurrency.', '', '', 'PoS', '2016-02-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Dark Moon', 'MOOND', 'moond.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@DARKMOON_COIN', 'Dark Moon is a Proof of Work/Proof of Stake cryptocurrency. It is currently in the PoS stage and has a 60 second block time.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DollarCoin', 'DLC', 'dlc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Dollarcoin ia Proof of Work cryptocurrency. It uses the SHA256 algorithm and has a 6% premine.', '', '', 'SHA256', '2017-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Sentaro', 'SEN', 'sen.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@SentaroCoin', 'Sentaro is a Scrypt PoW/PoS cryptocurrency. It has a 60 second block time and 1% PoS reward. Users can host Masternodes if they have a 5000 SEN collateral.', '', '', 'Scrypt', '2016-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Swiscoin', 'SCN', 'scn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoW', 'https://www.swisopensource.com/', NULL, 'SwisCoin is Scrypt PoW/PoS created to be used by businesses for raising funds, tracking share ownership and distributing dividends in an automated fashion.', '', '', 'Scrypt', '2016-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Wexcoin', 'WEX', 'wex.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.wexcoin.org/', NULL, 'Wexcoin is a Proof of Stake cryptocurrency created to facilitate the use of cryptocurrency in real life situations and make transactions effortless for users. It have low transaction costs and a 60 second average block time. Wexcoin was designed using BlockTex LTD.', '', '', '', '2017-10-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Lathaan', 'LTH', 'lth.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://lathaan.com/', NULL, 'Lathan is a Proof of Stake cryptocurrency.', '', '', 'PoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitBronze', 'BRONZ', 'bronz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@BitBronze', 'BitBronze is a Proof of Work cryptocurrency that uses the Scrypt algorithm. BRONZ has a 3 minute average block time.', '', '', 'Scrypt', '2015-12-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Shilling', 'SH', 'sh.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://digitalshilling.org/', '@DigitalShilling', 'Shilling is a Proof of Work cryptocurrency created for the African crypto community.', '', '', 'Scrypt', '2017-04-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Mind Gene', 'MG', 'mg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Mind Gene, referred to MG in short, is a Proof of Work/Proof of Stake cryptocurrency based on the SHA-256 algorithm. It is an encrypted digital currency issued by the lock time and MAS issuing mechanism, the unique system stake.', '', '', 'SHA256', '2017-02-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PSIcoin', 'PSI', 'psi.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'PSIcoin stands for Polish Sex Industry coin, it\'s a pure PoS cryptocurrency using the X11 algorithm. The main goal of PSI is be used as a payment method for watching Polish webcams.', '', '', 'X11', '2016-12-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Opair', 'XPO', 'xpo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://www.opair.co/', '@OpairProject', 'Opair is a cryptocurrency platform that supports Colored Coins and Smart Contracts (with a functional programming languages). Opair is fueld by XPO tokens, a Proof of Stake cryptocurrency with a 60 avg. second blocktime.\n\nOpair features a Market place with a decentralized reputation system, a Crowfunding platform, an Alias System, and Decentralized debit cards.Users can also start a configurable private blockchains using Opair.', '', '', 'PoS', '2017-05-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NoLimitCoin', 'NLC', 'nlc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'NoLimitCoin is a Proof of Work/Proof of Stake hybrid created to be the currency used in the upcoming Fantasy Football game, No Limits Fantasy Sports. NLC uses SHA256D as an algorithm and has a 2 minute block time.', '', '', 'SHA256D', '2017-07-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PesoBit', 'PSB', 'psb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.pesobit.net/', '@pesobit', 'PesoBit is a Proof of Work/Proof of Stake cryptocurrency that will target Remittance, Freelancing and eCommerce while at the same time retain the normal practices of altcoins via trading and staking that the International community can partake of. PesoBit was designed for the Filipino community.', '', '', 'Scrypt', '2016-10-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Beats', 'XBTS', 'xbts.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@Beats_coin', 'Beats is a Proof of Work/Proof of Stake cryptocurrency creates as a tribute to music. It uses the X11 algorithm.', '', '', 'X11', '2016-02-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Fitcoin', 'FIT', 'fit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://wisefintechs.com/', NULL, 'Fitcoin is a Proof of Work/Proof of Stake cryptocurrency created to fit perfectly between finance and information technology. FIT uses the X11 algorithm.', '', '', 'X11', '2016-01-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PantherCoin', 'PINKX', 'pinkx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'PantherCoin is a Proof of Work/Proof of Stake cryptocurrency. It uses the Scrypt algorithm.', '', '', 'Scrypt', '2018-06-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FireCoin', 'FIRE', 'fire.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@FirecoinX15', 'Fire is a Pow/PoS cryptocurrency that uses the X15 algorithm.', '', '', 'X15', '2016-04-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Unfed Coin', 'UNF', 'unf.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.unfedcurrency.byethost9.com/', NULL, 'Unfed Coin is a Proof of Work cryptocurrency, it uses the Scrypt algorithm. The main target of the project is to attract more users and to become a common tool for easy, secure and fast payments over the web, aspiring to create a stable and global peer-to-peer network of users that use Unfed as a solid payment gateway with very low-cost transactions.', '', '', 'Scrypt', '2016-06-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SportsCoin', 'SPORT', 'sport.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.thesportscoin.com/', '@thesportscoin', 'SportsCoin is a Proof of Stake cryptocurrency created as a means to fund promising sportspeople. SPORT uses the X11 algorithm and has a 2 minute block time.', '', '', 'X11', '2016-07-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Peerplays', 'PPY', 'ppy.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.peerplays.com/', '@PeerPlays', 'Peerplays is an eSports tournament and wagering platform built on the blockchain that allows users to compete against themselves with no centralized authority. Peerplays allows users to create their own buy-in games, organize and host multiplayer eSports games tournaments and competeing against their peers using various cryptocurrencies.', '', '', '', '2018-06-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NineElevenTruthCoin', 'NTC', 'ntc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'NineElevenTruthCoin is a Scrypt PoW/PoS cryptocurrency developed by Members of The 9/11 Truth Movement with years of experience and activism under their belts in regards to the catastrophic events relating to 9/11/2001 with a primary focus on the destruction of the three World Trade Center skyscrapers (Towers 1, 2 & Building 7) on 9/11/2001.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EGOcoin', 'EGO', 'ego.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'EGO is a Proof of Stake privacy-driven cryptocurrency and it allows users to send encrypted messages and to use stealth addresses.', '', '', 'PoS', '2018-05-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RCoin', 'RCN*', 'rcn_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://rcoin.eu/', NULL, 'RCoin is a SHA256 cryptocurrency aimed not only to enrichment, but also for charity purposes', '', '', 'SHA256', '2016-01-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'X2Coin', 'X2', 'x2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@X2Team2017', 'X2 is a Proof of Stake-based cryptocurrency using the X13 algorithm.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Mycelium Token', 'MT', 'mt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://mycelium.com/', '@MyceliumCom', 'Mycelium Tokens are coloured coins issued on the Bitcoin blockchain, they represent ownership in the Mycelium wallet. They can be freely exchange though the team requests that you notify them of any changes in ownership. The total supply of MT represents 5% of the Mycelium Wallet.', '', '', '', '2017-06-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Tianhe', 'TIA', 'tia.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'Tianhe is a Proof of Work cryptocurrency using the Lyra2Rev2 algorithm.', '', '', 'Lyra2RE', '2017-02-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GBR Coin', 'GBRC', 'gbrc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://gbrcoin.com/', '@gbrcoin', 'GBR coin is a PoW cryptocurrency. It has come after successful establishment of Bitcoin user network of Global BTC Rating, a platform where several users got an opportunity to explore the world of digital currency, understanding Bitcoin and its future. After huge demand of Global BTC Rating members GBR coin has launched as to offer them same platform as of 2009 of bitcoin.', '', '', 'Scrypt', '2016-12-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'UPcoin', 'XUP', 'xup.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'UPcoin, is designed to only run for a short 6weeks. This short timeframe concept idea is designed that all IPO funds will be spent to purchase cloud mining equipment via HashNest (antminer s4/s5) to produce profits daily, which will be used to buy \\[XUP\\] straight off the order books, and then be burned. The coins will be burned daily from day 1 all the way till day 42, in addition to this burn, every week one antminer s4/s5 will be sold off, and the funds will be used to buy straight off the the sell order books. This idea is branched off the idea of a drastically decreasing supply over a very short period of time. After the 6 weeks, the coin will not be abandoned, we will collaborate with our team and the developers and pick a brand new/fresh approach to the success of the coin, and the rest of its lifespan.  \n  \nbased on rough calculations, the supply should reduce by 15% weekly. The way this has been devised is to obviously be greatly beneficial to early investors.  \n  \nAll burnt coins will be documented and posted in the thread and visible to all.', '', '', 'X13', '2016-03-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Halloween Coin', 'HALLO', 'hallo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'HALLO is a Halloween themed cryptocurrency. It is a Proof of Work/Proof of Stake hybrid using the x11 algorithm.', '', '', 'X11', '2018-06-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BaseballCardCoin', 'BBCC', 'bbcc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@BBCCTeam', 'BaseballCardCoin is a PoW/PoS cryptocurrency using the Scrypt algorithm. The purpose of this experimental Cryptocurrency is to bring back the spirit of trading Baseball Cards which has been waning in interest over the last decade. Even the quality of Baseball Cards has been taking a tumble.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EmiratesGoldCoin', 'EMIGR', 'emigr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'EmiratesGoldCoin is a \"classic\" blockchain, using a proof of work and with a low supply of 4 millions. Designed specifically for ASIC miners, EMIGR uses the SHA256 algorithm.', '', '', 'SHA256', '2017-06-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BighanCoin', 'BHC', 'bhc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'BighanCoin is a Proof of Work Quark cryptocurrency. It is an international free trade service for online and offline consumer spending.', '', '', 'Quark', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Craftcoin', 'CRAFT', 'craft.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Craftcoin is a PoW/PoS cryptocurrency for handcrafted and customized goods. The goal is to create a website where people can trade handmade pieces or customizations for manufactured goods using CRAFT.', '', '', 'Scrypt', '2017-11-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Invictus', 'INV', 'inv.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Invictus is an X11 PoW/PoS based cryptocurrency.', '', '', 'X11', '2016-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OlympCoin', 'OLYMP', 'olymp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@olympcoin', 'OlympCoin is a X11 cryptocurrency dedicated to celebrate both summer and winter olympic games. Its distribution is based on POW and POS, but also on a Country winning distribution, which means that if your favourite country wins a medal you will get a prize too. The coin\'s infrastructure is built around the olympic games, rewards are 31 OLYMP/block as this years Summer Olympics is the XXXI. one, and from 2018 the reward will be reduced to 23 celebrating the XXIII Winter Olympic games.', '', '', 'X11', '2016-10-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DelightPay', 'DPAY', 'dpay.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'DelightPay is a Proof of Work/Proof of Stake x13 cryptocurrency.', '', '', 'X13', '2016-11-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Atomic Coin', 'ATOM', 'atom.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://www.atomicproject.org/', '@AtomcoinProject', 'Atomic Coin is an hybrid PoW/PoS using the Scrypt algorithm. 100% PoS interest will be reduced after 3 months after launch.', '', '', 'Scrypt', '2017-11-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Hacker Gold', 'HKG', 'hkg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://hack.ether.camp/', '@CampEther', 'Hacker Gold (HKG) is the official token of the Virtual Accelerator, a platform that allows for the promotion, testing and funding of ideas. It’s a place that allows new startups to be formed. HKG allows anyone to be involved and signify their appreciation of the best projects participating in the event. The teams who collect the most HKG will have the largest acceptance by the crowd and will have the greatest potential.', '', '', '', '2017-08-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AntiLitecoin', 'ANTC', 'antc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'AntiLitecoin is a Scrypt Proof of Work cryptocurrency created to fix issues in Litecoin', '', '', 'Scrypt', '2016-11-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'JobsCoin', 'JOBS', 'jobs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://jobscoin.us/', '@Jobscoin', 'JobsCoin is a Proof of Work/Proof of Stake cryptocurrency developed in memory of Steve Jobs.', '', '', 'X11', '2016-05-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DogeGoreCoin', 'DGORE', 'dgore.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@dogegorecoin', 'DogeGoreCoin is a X11 cryptocurrency created as a \"parody\" to Dogecoin. It\'s supposed to be a fun-based cryptocurrency.', '', '', 'X11', '2015-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'The Hempcoin', 'THC', 'thc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://hempcoin.org/', '@thehempcoin', 'The Hempcoin is a Scrypt Proof of Work/Proof of Stake cryptocurrency for the hemp community.', '', '', 'Scrypt', '2014-09-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Tetra', 'TRA', 'tra.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://tetracurrency.com/', '@tetracurrency', 'Tetra is a Proof of Work Scrypt coin backed by Silver.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Resumeo Shares', 'RMS', 'rms.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@Resumeoshares', 'Resumeo Shares is a Proof of Stake cryptocurrency that represents 10% ownership of the Resumeo platform, a tool that helps employers find employees.', '', '', 'NIST5', '2016-10-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FujiCoin', 'FJC', 'fjc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.fujicoin.org/', '@FujiCoin', 'FujiCoin is a Proof of Work cryptocurrency using the Scrypt-N-Fixed algorithm. If', '', '', 'Scrypt-n', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Vaporcoin', 'VAPOR', 'vapor.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Vaporcoin is a Proof of Work/Proof of Stake SHA256 cryptocurrency.', '', '', 'SHA256', '2015-02-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SydPakCoin', 'SDP', 'sdp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.sydpak.com/', '@SydpakCoin', 'SydPakCoin is a PoW/PoS cryptocurrency using the X13 algorithm. SDP plans to build many applications for the coin to be used on, like Strip Dice, an Auction Site, Mining Rig Rentals, and a PayPerClick (PCC) Site.', '', '', 'X13', '2016-09-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Recovery Right Tokens', 'RRT', 'rrt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@https://www.bitfinex.com/', 'On October 11th, 2016, at 09:00:00 UTC, Exchange Trading of RRT pairs RRTUSD and RRTBTC has been enabled for all Bitfinex accounts, save and except for U.S. Persons. Margin Trading and Margin Funding will not be available.\n\nThose who participated in the first round of the BFX token-to equity conversion have already had RRTs credited to their accounts. Those who did not participate in the first round of conversions are still eligible to receive RRTs for every BFX token converted at a rate of ½ of an RRT for each BFX token converted to equity until the end of October 2016.\n\nRight Token (the RRT) was created to compensate victims of the security breach and, thereafter, to offer a priority to early BFX token conversions.', '', '', '', '2016-11-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZCoin', 'XZC', 'xzc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://zcoin.io/', '@zcoinofficial', 'ZCoin is a Proof of Work cryptocurrency using the Lyra2 hashing algorithm. It is an implementation of the Zerocoin protocol ([http://zerocoin.org](http://zerocoin.org/)) guaranteeing true financial anonymity using ZK-Snarks. Zero-Knowledge proofs allows one to show ownership of a Zcoin coin without having to reveal which coin one owns.\n\nRecently, the Zcoin protocol was found to have a typographic bug that costed the network roughly $400k. This bug, however, did not compromise the anonimity features of Zcoin.', '', '', 'Lyra2RE', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Premium', 'PRE', 'pre.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@PremiumCoinDev', 'Premium is a lite version of Bitcoin using scrypt as a Proof of Work algorithm similar to Litecoin, except the total supply is considerably lower – only 20 million coins. Premium is coin designed to offer cryptocurrency an entrance into the premium and bespoke products industry in the United Kingdom.', '', '', 'Scrypt', '2016-10-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CaliphCoin', 'CALC', 'calc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@http://caliphcoin.eu/', 'CaliphCoin is a Proof of Work cryptocurrency using the SHA256 algorithm.', '', '', 'SHA256', '2018-05-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LeaCoin', 'LEA', 'lea.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'LeaCoin is a SHA256 Proof of Work cryptocurrency. It has a maximum volume of 2 billion coins and a avg. block time of 30 seconds.', '', '', 'SHA256', '2017-06-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Californium', 'CF', 'cf.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Californium (CF) is a SHA256 Proof of Work cryptocurrency. It\'s name is inspired in the most expensive metal on the planet, Californium.', '', '', 'SHA256', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CrankCoin', 'CRNK', 'crnk.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS/PoW', NULL, NULL, 'CrankCoin is a Proof of Work/Proof of Stake cryptocurrency, using the X11 as its hashing algorithm.', '', '', 'X11', '2018-04-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CoffeeCoin', 'CFC', 'cfc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'CoffeeCoin is 100% Proof of Stake. It\'s a cryptocurrency created to be used for the everyday cup of coffee.', '', '', 'PoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Victoriouscoin', 'VTY', 'vty.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://victoriouscoin.site/', '@victoriouscoin', 'VictoriousCoin is a Proof of Work/Proof of Stake cryptocurrency created to provide services and products for its community and enhance the usage of VTY', '', '', 'Scrypt', '2017-01-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Safecoin', 'SFE', 'sfe.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://safecoinclub.com/', NULL, 'Safecoin is a PoW/PoS cryptocurrency designed to eliminate the possibility of hacks, cracks, forks, or compromises.', '', '', '', '2018-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ardor', 'ARDR', 'ardr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://www.ardorplatform.org/', '@ArdorPlatform', 'Ardor is a Blockchain-as-a-Service (BaaS) Platform that will allow users to create their own child chains with specific settings for asset issuance. Ardor is the evolution of the NXT blockchain and offers many advantages over its predecessor, both in functionality and in scalability.\n\nARDR, the Main Chain tokens are the backbone of the platform, they will be used maintain the blockchain and forge tokens from tx fees, which is the equivalent of Mining in the NXT Proof of Stake (PoS) protocol.\n\nThe distribution process for Ardor started on the 14th of July and lasted until 12th of October. During this time hourly snapshots of NXT Balances were taken and averaged, the balance was then given to holders on a 1 to 1 scale. ARDR issued as an asset on the NXT 1.9 Blockchain until the full release of the Ardor Platform in Q3 of 2017.\n\nA second set of tokens will be given to users according to their NXT holding on the day the first block of Ardor is mined, meaning that the balance won’t be measured and averaged over a period of time, but will instead be given on a 0.5 – 1 scale according to the one snapshot taken at the moment of the Genesis Block. These tokens will house the features of the first Ardor child chain.', '', '', '', '2017-01-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BlackShadowCoin', 'BS', 'bs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'BlackShadow is a X11 Proof of Work/Proof of Stake cryptocurrency allowing fast transactions, anonymity, a stable exchange rate against the currencies of the world.  \nDevelopment of the coin is divided into steps (roadmap). The ultimate goal of development is to release terminals exchange and implementation in the online stores as payment method.', '', '', 'X11', '2018-03-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'JiffyCoin', 'JIF', 'jif.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://jiffycoin.xyz/', NULL, 'JiffyCoin (JIF) is a worldwide decentralized payment network & digital currency, inspired by Bitcoin. JiffyCoins is uses the SHA256D hashing algorithm and is 100% Proof of Work. Using, JiffyCoin, people looking for programmers/freelancers within the crypto scene will be able to register and post work to be done as well as get ratings for employers and workers.', '', '', 'SHA256D', '2016-08-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CrabCoin', 'CRAB', 'crab.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'CrabCoin is a Proof of Work/Proof of Stake that brings a light and playful tone to the cryptocurrency world. This fun themed coin was created to \"raise awareness to the existence of the Crabpeople, a species that is forced to live underground by the modern human\".', '', '', 'X15', '2016-09-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Aircoin', 'AIR*', 'air_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Aircoin is a Proof of Work/Proof of Stake cryptocurrency using Scrypt as its hashing algorithm.', '', '', 'Scrypt', '2016-10-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'President Clinton', 'HILL', 'hill.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'President Clinton is an asset issued using Omni layer. It\'s a presidential themed asset.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ForexCoin', 'FOREX', 'forex.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Forexcoin is a Pow/PoS cryptocurrency developed by group of forex traders with experience in Forex trading, Stock Market and Crypto currency trading. FOREX traders will trade with the ICO funds in different markets and use the profits to develop the Forexcoin. The share holder and miner who has the ForexCoin will be getting 120% profit per annum.', '', '', 'X15', '2017-01-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Moneta', 'MONETA', 'moneta.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://moneta.io/', '@moneta_io', 'Moneta is a Proof of Work cryptocurrency using Scrypt as an hashing algorithm. It is the new decentralized peer-to-peer payment network that is powered by its users with no central authority or middlemen.', '', '', 'Scrypt', '2016-07-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Eclipse', 'EC', 'ec.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.eclipsecrypto.com/', '@EclipseCrypto', 'Eclipse is a PoW/PoS privacy-driven cryptocurrency that was forked from Shadowcash but the hashToEC was replaced with a cryptographically secure variant.', '', '', 'SHA256D', '2018-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Rublebit', 'RUBIT', 'rubit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://rublebit.com/', '@rublebit', 'RubleBit is a Proof of Work cryptocurrency intended to trade in the global Internet. The development team will promote RubleBit to the masses via the internet shops.', '', '', 'Scrypt', '2015-10-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HappyCreatorCoin ', 'HCC', 'hcc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://hccunited.net/', NULL, 'HappyCreatorCoin is a Proof of Work cryptocurrency.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BrainCoin', 'BRAIN', 'brain.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Brain is an experimental new digital currency that enables anonymous, instant payments to anyone, anywhere in the world. Brain uses peer-to-peer technology to operate with no central authority: managing transactions and issuing money are carried out collectively by the network. Brain Core is the name of open source software which enables the use of this currency.', '', '', 'X11', '2016-11-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Vertex', 'VTX', 'vtx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Vertex is a Proof of Stake/Proof of Work cryptocurrency. T goal of the Vertex developers is for everyone involved in the Cryptocurrency revolution to have access to the exciting developments that have been taking place. An ASIC-friendly, mixed PoW/PoS coin with eventual anonymous transaction capabilities.\n\nThe Vertex developers believe that progress should never be held back. ASICs use much less energy than GPUs and are orders of magnitude more efficient. The energy used mining Scrypt coins for years to prolong the days of GPU mining was a truly enormous waste of resources on a global scale. Why hold back progress? Vertex encourages it.', '', '', 'SHA256', '2016-11-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'KRCoin', 'KRC', 'krc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'KRCoin is a Proof of Work cryptocurrency.', '', '', 'X11', '2018-06-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RoyalCoin', 'ROYAL', 'royal.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@royalcoin2016', 'Royal Coin is an experimental X13 Proof of Stake cryptocurrency created with a solid business model on top of the robust blockchain technology to take adoption of Digital Currency to the mainstream public. Royal Coin ( ROYAL ) has been launched by a team of Crypto Traders who have years of experience in crypto trading.', '', '', 'X13', '2016-12-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BigLifeCoin', 'LFC', 'lfc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@biglifecoin', 'BigLifeCoin is a X11 cryptocurrency created by the BigLife Group company.', '', '', 'X11', '2017-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Zurcoin', 'ZUR', 'zur.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://shai102.wixsite.com/', NULL, 'Zurcoin is a Proof of Work cryptocurrency based on Quarkcoin and Bitcoin. ZUR uses the Quark hashing algorithm and has a 42 second block time.', '', '', 'Quark', '2015-06-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NubisCoin', 'NUBIS', 'nubis.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Nubis is a Proof of Work/Proof of Stake cryptocurrency, created for cloud services. NUBIS uses SHA256 as an algorithm and gives an APY of 250% in PoS block rewards.', '', '', 'SHA256D', '2016-10-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Tennet', 'TENNET', 'tennet.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Tennet is a Proof of Work/Proof of Stake cryptocurrency using the SHA356D algorithm.', '', '', 'SHA256D', '2016-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PeaceCoin', 'PEC', 'pec.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'PeaceCoin is a Proof of Work cryptocurrency created to be easy-to-use for new users.', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Goldmaxcoin', 'GMX', 'gmx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.gmxcoin.org/', '@gmxcoins', 'Goldmaxcoin is a lite version of Bitcoin using Scrypt as a Proof of Work algorithm.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '32Bitcoin', '32BIT', '32bit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, '32Bitcoin is a Proof of Work/Proof of Stake cryptocurrency using the X11 algorithm. 32BIT has a 90 second block time and a total supply of 355000 coins', '', '', 'X11', '2016-11-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GanjaCoin V2', 'GNJ', 'gnj.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.ganjacoin.net/', '@GanjaCoinV2', 'GanjaCoin V2 is a PoW/PoS cryptocurrency for Cannabis enthusiasts and investors. The goal for GNJ is to become the main currency to exchange Cannabis related goods and services (concerning the legal market). GanjaCoin V2 offers a secure and anonymous way of transacting value for cannabis goods and services.', '', '', 'X14', '2017-06-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TeamUP', 'TEAM', 'team.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@teamupcoin', 'TeamUP is a PoS cryptocurrency. It was launched as a way to protect less technical and experienced users from investing in dead or scam coins. TeamUP uses the ICO funds gathered for trading and the proceeds are then distributed through higher and higher buy walls to keep the coin market value growing.', '', '', 'PoS', '2016-11-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ScryptToken', 'SCT', 'sct.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'ScryptToken is a Proof of Work/Proof of Stake cryptocurrency using the Scrypt algorithm. SCT has an APY of 5% in PoS rewards.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LanaCoin', 'LANA', 'lana.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@LanaCoin', 'LanaCoin is a Proof of Work/Proof of Stake cryptocurrency using the SHA256D algorithm.', '', '', 'SHA256D', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Elementrem', 'ELE', 'ele.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.elementrem.org/', NULL, 'Elementrem is a Proof of Work Ethereum clone. It has the same features and tools like smart contract and dapp creation and deployment.', '', '', 'Ethash', '2016-04-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GuccioneCoin', 'GCC', 'gcc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@GuccioneCoinGCC', 'GuccioneCoin is an experimental Proof of Work cryptocurrency beta project which will be used for rewards. GCC is meant to be accepted for goods and services including paid content in the form of Micro-Purchases on the new Guccione eZine Platform.', '', '', 'Scrypt', '2017-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AndromedaCoin', 'AND', 'and.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'AndromedaCoin is a PoW/PoS cryptocurrency. It uses the X11 algorithm and has a 30 second blocktime.', '', '', 'X11', '2018-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Byteball', 'GBYTE', 'gbyte.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://byteball.org/', '@ByteballOrg', 'Byteball is a decentralized database with it\'s own native cryptocurrency, Bytes, that unlike most does not require PoW or PoS mining and does not have a blockchain nor blocks. Instead, Byteball links transactions by signing the hashes from the previous transactions on the new one. These links between transactions form a DAG (Directed Acyclic Graph). Since Byteball has no blocks, there is no block size issue.\n\nByteball can be used as a means to transfer value between users in a transaction, either with Bytes or assets that can be issued on the network or as a decentralized data base that allows users to store information within it. Byteball\'s currency, Bytes, are used to pay transaction fees in this network. Transactions can be meant to exchange value or to store any type of data. The transaction fees (Bytes) are relative to the Bytes used in the transaction, so if a transaction uses 500 Bytes, that\'s the tx fee that will be charged. This system gives the currency intrinsic value, each Byte is worth a byte of information that is stored on the network, which alows the system to scale according to its use.\n\n1 GBYTE equals 1000000000 BYTES', '', '', '', '2018-01-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EqualCoin', 'EQUAL', 'equal.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'EqualCoin is a Proof of Work/Proof of Stake cryptocurrency using the X13 algorithm. It was designed to be a fair launch coin with equal airdrop opportunities for all of the community.', '', '', 'X13', '2017-06-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SweetStake', 'SWEET', 'sweet.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'SweetStake is a Proof of Stake cryptocurrency designed for high staking profits, it has a 100% APY.', '', '', 'PoS', '2017-09-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '2BACCO Coin', '2BACCO', '2bacco.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@2bacco_2bacco', '2BACCO is a Scrypt Proof of Work cryptocurrency.', '', '', 'Scrypt', '2016-10-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DarkKnightCoin', 'DKC', 'dkc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'DarkKnightCoin is a Proof of Work/Proof of Stake cryptocurrency with a high APY of 999%.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Community Coin', 'COC', 'coc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@communitycoin_', 'Community Coin is a Proof of Work coin using the SHA256 algorithm, also used by Bitcoin.', '', '', 'SHA256', '2018-01-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ChoofCoin', 'CHOOF', 'choof.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@choofcoin_pr', 'Choofcoin is a Scrypt PoW/PoS cannabis coin that will be used in the cannabis industry. Choofcoin as a digital currency is an alternative payment network for cannabis users, merchants and industry professionals.', '', '', 'Scrypt', '2017-03-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CashOut', 'CSH', 'csh.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://cshout.net/', NULL, 'Cashout is a new digital currency that enables instant payments to anyone, anywhere in the world. cashout uses peer-to-peer technology to operate with no central authority: managing transactions and issuing money are carried out collectively by the network. cashout is also the name of the open source software which enables the use of this currency.', '', '', 'SHA256', '2018-06-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZClassic', 'ZCL', 'zcl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://zclassic.org/', '@ZclassicCoin', 'ZClassic is a cryptocurrency forked from Zcash. It has the exact same features as ZEC, including its private transactions protected by zero knowledge proofs and its Equihash Proof of Stake mining, but with no founder\'s reward. This founder\'s reward is currently deducted from mined zcash blocks (20% of all block rewards during the first four years of mining which will amount to 10% of the total zcash supply). By removing this founder\'s reward ZClassic wants to make mining fair for everyone involved.\n\nBlock explorer data from <https://classic.zcha.in/>', '', '', 'Equihash', '2016-06-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RoyalCoin 2.0', 'RYCN', 'rycn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@royalcoin2016', 'RoyalCoin is a Proof of Stake cryptocurrencyusing the X13 algorithm.', '', '', 'X13', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Pabyosi Coin', 'PCS', 'pcs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://pbcinfo.net/', NULL, 'Pabyosi Coin is a Proof of Work/Proof of Stake cryptocurrency that uses the X11 algorithm and yields an annual staking profit of 3%', '', '', 'X11', '2016-01-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NetBit', 'NBIT', 'nbit.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'NetBit is a PoW/PoS cryptocurrency that uses the popular Scrypt algorithm.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'WineCoin', 'WINE', 'wine.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'WineCoin is a PoW/PoS cryptocurrency with a 11% yearly staking profit.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Darcrus', 'DAR', 'dar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://darcr.us/', '@darcrus', 'Darcrus is an asset issued on the NXT blockchain that will allow its holders to receive rewards via disbursements that are assigned through a Proof of Holding reward system (which is similar to the master node payment system found in DASH). The reward system can be based on a buyback program on an exchange or disbursement via the NXT’s & Waves’ native systems. Darcrus also generates profit for its holders by selling decentralized applications, like the dAppsheet, an application that automatically replicates and decentralizes the underlying infrastructure for companies to tailor almost any tracking, billing, or service desk application to their specific needs.\n\nThe Dracrus Initial Coin Offering period will start on the 21st of November and will last for three weeks. Investors will benefit from a 50% bonus on the first day, which will then be decreased during the course of the ICO. A total of 50 million DAR tokens will be issued, 42,500,000 of which will be distributed to investors, while the 5 million tokens will be reserved for SIGFARM and SIGWO asset swaps. The remaining supply will be kept for maintenance, auditing, marketing, and development, as well as for community bounty programs. The release of the dAppsheet application is scheduled for May 2017, after which Dracrus will continue to develop new products.', '', '', '', '2016-12-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ARK', 'ARK', 'ark.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DPoS', 'https://ark.io/', '@ArkEcosystem', 'Ark is a cryptocurrency platform built on top an improved Delegated Proof of Stake (DPoS) system derived from Lisk, Crypti, and BitShares. It uses Smart Bridges to communicate with other (new and existing) blockchains to further increase its reach, providing a wider range of features in a single place.\n\nArk plans to stimulate cryptocurrency mass adoption by offering multiple consumer tools like a card network, game tokens, anonymous transactions, multi-signature accounts, and others. Adding more features and tools along the way.', '', '', 'DPoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'InflationCoin', 'IFLT', 'iflt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'InflationCoin is a PoW/PoS with random super block rewards. It uses high PoS rewards to destribute the supply fairly.', '', '', 'X11', '2016-06-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZCashDarkCoin', 'ZECD', 'zecd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@Cryptoman82', 'ZCashDarkCoin is a Proof of Work/Proof of Stake Scrypt cryptocurrency. ZECD does not possess the same privacy features as Zcash (ZEC) or ZClassic (ZCL).', '', '', 'Scrypt', '2018-07-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Zcrypt', 'ZXT', 'zxt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoZ', 'http://www.zcrypt.io/', NULL, 'Zcrypt is an anoymouc cryptocurrency that uses zero knowledge proofs. It uses a Proof of Work/Proof of Stake protocol with a new algorithm, LyraZ.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'WashingtonCoin', 'WASH', 'wash.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'WASH is a cryptocurrency created in honor of George Washington. It\'s a X11 PoW/PoS cryptocurrency. WashingtonCoin has random super blocks with 100x the normal reward every day. and it\'s PoS rewards get smaller every year until the 5th.\n\nVariable PoS annual payout rate:  \n\\- 1st year: 80%  \n\\- 2nd year: 40%  \n\\- 3rd year: 20%  \n\\- 4th year: 10%  \n\\- and subsequent years: 5%', '', '', 'X11', '2016-11-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TeslaCoilCoin', 'TESLA', 'tesla.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.teslacoilcoin.com/', NULL, 'A commemorative coin in memory of Nikola Tesla the great inventor. It\'s an asset issued with the OMNI layer and it has 100 million units.', '', '', '', '2015-08-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LuckyBlocks (LUCKY)', 'LUCKY', 'lucky.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'LuckyBlocks is a 100% Proof of Stake cryptocurrency with a unique feature: Super Blocks paid out in bitcoin, the biggest bonus block will pay out 4 BTC. The super block rewards are held in escrow by a reputable third party.', '', '', 'PoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'vSlice', 'VSL', 'vsl.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://www.vdice.io/', '@vdice_io', 'vSlice is a token issued on the Ethereum blockchain. It represents a piece in the ownership of the vDice gambling dapp and its revenue. This token will issue dividends produced by the gambling fees charged on vDice, which is a fully decentralized version of SatoshiDICE for Ether betting.', '', '', '', '2017-03-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Troll Payment', 'TPG', 'tpg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@Trollpayment', 'Troll Payment is an advertisement cryptocurrency with a PoS consensus mechanism. It allows users to get paid for typing specific words on their favorite trollboxs.', '', '', 'PoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LEOcoin', 'LEO', 'leo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.leocoin.org/', '@LEOcoinORG', 'LEOcoin is a Proof of Stake cryptocurrency developed from Litecoin. It uses the Scrypt-Jane algorithm and has a 5% premine. LEOcoin aims at being an easy-to-use, pseudonymous cryptocurrency.', '', '', 'Scrypt', '2015-05-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Midnight ', 'MDT', 'mdt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@midnightmdt', 'Midnight is a Proof of Work/Proof of Stake cryptocurrency that uses the Blue Midnight Wish hashing algorithm. MDT halves every year to a floor of 0.125 MDT for PoW and 0.25 MDT for PoS. Every 720 blocks is a 100 MDT coin reward, which acts as an incentive to mine on a continuous basis.', '', '', 'SHA256', '2016-01-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CBD Crystals', 'CBD', 'cbd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@CBDCRYPTODIOL', 'CBD Crystals is a Proof of Stake cryptocurrency.', '', '', 'PoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PosEx', 'PEX', 'pex.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@PoSeX_2016', 'PosEx is a Pow/Pos hybrid cryptocurrency. It has a 30 second block time and uses the SHA256D', '', '', 'SHA256D', '2018-04-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'InsaneCoin', 'INSANE', 'insane.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://insanecoin.com/', NULL, 'InsaneCoin is a Proof of Stake cryptocurrency with an initial Proof of Work destribution. It uses the X11 algorithm.', '', '', 'X11', '2018-02-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Golem Network Token', 'GNT', 'gnt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://golem.network/', '@golemproject', 'The Golem Network is a decentralized computation network. Using Golem users can buy or sell computational power from other users in a peer to peer environment. Golem is built using Ethereum smart contracts as a transaction system for nano-payments within the network. Golem Network Tokens (GNT) will serve as a secure medium for all transactions within the Golem Network.', '', '', '', '2017-05-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PenCoin', 'PEN', 'pen.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'PenCoin is a Proof of Work cryptocurrency', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LuckChain', 'BASH', 'bash.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@LuckChain', 'LuckChain is a Scrypt cryptocurrency that provides a decentralized gaming platform on the blockchain. Games include Lucky 16, Lucky Odd Even, Lucky Big Small, Lucky Boss, Lucky Lotto and bet real events, you can bet anything in LuckChain.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FameCoin', 'FAME', 'fame.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://famecoin.us/', '@famecoinn', 'Fame is a Proof of Work/Proof of Stake cryptocurrency that uses the QuBit algorithm. It focuses on providing solutions for the crypto economy and it will begin with a social Photo tipping app, according to their roadmap.', '', '', 'QuBit', '2018-01-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LiviaCoin', 'LIV', 'liv.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'LiviaCoin is a PoW/PoS cryptocurrency with a high apy of 40% in staking rewards. LiviaCoin has a 15% premine.', '', '', 'Scrypt', '2017-10-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Sex Pistols', 'SP', 'sp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Sex Pistols is a PoW/PoS cryptocurrency created in tribute of the British band, Sex Pistols. It uses the Scrypt algorithm and has a 64 second block time.', '', '', 'Scrypt', '2018-04-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MegaFlash', 'MEGA', 'mega.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://flashcoin.io/', NULL, 'Each MEGA coin is a Counterparty asset secured with the Bitcoin blockchain and will initially be redeemable for 1 million FLASH coins. FLASH coins are given free to end users and used for advertising and incentive marketing, using a private high performance blockchain. There are 900 billion FLASH coins authorized, but only 300,000 MEGA coins authorized. MEGA coins are scarce and can be used by advertisers and online marketers to purchase FLASH coins in volume for campaigns. End users will also need MEGA coins to redeem their FLASH for BTC via an in-wallet exchange, where available.\n\nFLASH is a blockchain based platform that enables users and developers to leverage this powerful technology for social media, websites, blogs and e-commerce sites. As easy to use as webmail, FLASH is a great way to introduce your friends to crypto-coins and to build in rewards to your web pages and services.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Veros', 'VRS', 'vrs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://veros.org/', NULL, 'Veros is a crypto token built on Ethereum with a 10 billion coin supply. The main beneft of VEROS is ofering access to individuals, which are not linked to any banking services, thus enabling them to use fnancial services for their daily transactional processes. VEROS has the main advantage of ofering the possibility of transitioning online and ofine and exchanging VEROS into FIAT money in a simplifed manner.', '', '', '', '2016-01-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Arab League Coin', 'ALC', 'alc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Arab League Coin is a Proof of Work cryptocurrency using the x13 algorithm. It is the result of wanting to create a real alternative currency designed from the ground up, with many projects in mind.', '', '', 'X13', '2017-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EtherDoge', 'DOGETH', 'dogeth.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Ether Doge is a x11 cryptocurrency with a Proof of Stake/Proof of Work hybrid protocol.', '', '', 'X11', '2017-09-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'KiloCoin', 'KLC', 'klc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.facebook.com/', NULL, 'KiloCoin is a Proof of Work cryptocurrency using the Scrypt algorithm. Kilocoin is ment to be a new measurement of value.', '', '', 'Scrypt', '2015-01-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Hush', 'HUSH', 'hush.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://myhush.org/', '@MyHushTeam', 'Hush is a private implementation of the \"Zerocash\" protocol forked from Zcash. Based on Bitcoin\'s code, it intends to offer a far higher standard of privacy through a sophisticated zero-knowledge proving scheme that preserves confidentiality of transaction metadata.', '', '', 'Equihash', '2017-09-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitLuckCoin', 'BTLC', 'btlc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.bitluckcoin.com/', NULL, 'BitLuckCoin is a Proof of Stake cryptocurrency that enables fast instant payments to anyone in the world with almost no fees. It runs off the popular scrypt protocol.', '', '', 'PoS', '2016-05-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Dream8Coin', 'DRM8', 'drm8.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Dream8Coin is a Proof of Work cryptocurrency running on the Scrypt algorithm. It has a 60 second block time.', '', '', 'Scrypt', '2017-01-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FistBump', 'FIST', 'fist.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'FistBump is a PoW/PoS cryptocurrency based on Peercoin and using the X13 algorithm.', '', '', 'X13', '2015-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ebitz', 'EBZ', 'ebz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://www.ebitz.org/', NULL, 'Ebitz is a Proof of Stake implementation of the ZeroCash protocol. Forked from Zcash, Ebitz has no founder\'s reward and will instead host an Initial Coin Offering.', '', '', 'PoS', '2018-04-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Digital Rupees', 'DRS', 'drs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS ', 'https://www.digitalrs.me/', '@DigitalRupees', 'Digital Ruppes is an anonymous Proof of Stake cryptocurrency that uses the Scrypt algorithm. The first five blocks of the DRS blockchain were premined to destributed in the ICO, during which 490 (99% of the premined supply) could be exchanged for bitcoin.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Free Game Zone', 'FGZ', 'fgz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'FGZ is a Proof of Work cryptocurrency using the scrypt algorithm. According to the developers the coin is backed by many services related to gaming.', '', '', 'Scrypt', '2018-06-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BosonCoin', 'BOSON', 'boson.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'BosonCoin is a Proof of Work/Proof of Stake cryptocurrency using the X11 hashing algorithm. BosonCoin is named after the Boson, a subatomic particle, such as a photon, that has zero or integral spin and follows the statistical description given by S. N. Bose and Einstein.', '', '', 'X11', '2017-05-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ArtexCoin', 'ATX', 'atx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'ArtexCoin is a Proof of Work cryptocurrency that uses the popular X11 algorithm. Their goal is to develop leading crypto-currency software that combines all features of cash and digital money, design and implement a marketing plan to position Artex as a leading solution in crypto-industry and expand the network by focusing on new adoptions and integration within the existing target markets, and attract new financial industry partners.', '', '', 'X11', '2016-02-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PlatiniumCoin', 'PNC', 'pnc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@dev_platinum', 'PlatiniumCoin is a pure Proof of Work cryptocurrency using the same algorithm as Bitcoin, SHA256. It has a 3 minute block size and a 21000000 total supply, 0% of which is premined.', '', '', 'SHA256', '2015-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BeardDollars', 'BRDD', 'brdd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'BeardDollars is a Proof of Work/Proof of Stake cryptocurrency created in association with [www.crossedpistols.com](http://www.crossedpistols.com/), a website that provides apparel and home made beard products worldwide at affordable prices. All purchases made with BRDD with result in an additional 5% discount on top of any other offers currently going.', '', '', 'Scrypt', '2016-07-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Time', 'TIME', 'time.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://chronobank.io/', '@ChronobankNews', 'Time is an Ethereum-based token issued by Chronobank. It allows users to receive dividends from the fees and issuance of Labor-Hour Tokens (LHT) in the Chronobank system.\n\nChronobank is a system designed to tokenize labour-hours using blockchain technology. The system leverages smart contract techniques to automate a process whereby a country-specific ‘labour-hour’ token may be redeemed for real labour-hours via legally binding (traditional) contracts with labour-offering companies. The proposed ‘stable-coin’ LHT implementation provides a non-volatile, inflation-resistant digital asset transfer system.', '', '', '', '2016-08-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BipCoin', 'BIP', 'bip.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://bipcoin.org/', NULL, 'BipCoin is a Cryptonote coin that is covered by the BipCot NoGov license, which allows use and re-use by anyone except governments and government agents.', '', '', 'CryptoNight', '2017-04-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'XenCoin', 'XNC', 'xnc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.xencoin.com/', '@Xencoin', 'XenCoin is a Proof of Work cryptocurrency using the Scrypt algortihm. It has as a 20 second block time. XNC was created to be used as a currency in the XenZino, XenBingo, XenLotto, and PokerXen.', '', '', 'Scrypt', '2018-04-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'EmberCoin', 'EMB', 'emb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'EmberCoin is a PoW/PoS cryptocurrency. It uses the x13 algorithm and has a three minute average block time', '', '', 'X13', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Coin to the Future', 'BTTF', 'bttf.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'Coin to the Future is a pure Proof of Stake cryptocurrency created as a tribute to the Back to the Future movie.', '', '', 'PoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DollarOnline', 'DLR', 'dlr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.edollar.online/', NULL, 'DollarOnline is a X11 PoW/PoS cryptocurrency with a 20% APY in staking rewards.', '', '', 'X11', '2017-10-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cosmic', 'CSMIC', 'csmic.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Cosmic is a PoW/PoS hybrid cryptocurrency using the SHA256D algorithm. CSMIC developers have plans to build a Simulation Platform which will allow users to explore Space in real time.', '', '', 'SHA256D', '2017-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FirstCoin', 'FIRST', 'first.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://firstcoinproject.com/', NULL, 'FirstCoin is a PoW/PoS hybrid using the famous Scrypt algorithm.', '', '', 'Scrypt', '2018-02-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SpaceCash', 'SCASH', 'scash.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'SpaceCash is a Proof of Work/Proof of Stake cryptocurrency.', '', '', 'X13', '2018-05-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'XenixCoin', 'XEN', 'xen.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://xenixcoin.com/', '@XenixCoin', 'XenixCoin is a cryptocurrency based not only on the mining principle, but also in a sustainable energy efficiency policies generating money. XenixCoin uses x11 as it is proof of work algorithm, making it energy efficient. It offers high levels of security, privacy, stability and speed. XenixCoin was built on a new bitcoin codebase, and scheduled to create 19 coins every ten minutes, and approximatively 1 million coins per year. Proof of stake APR at 1%, helps reward holders, while also adding additional security to the network while the users stake. It has 2MB blocks, so it can handle many transactions in a single block.', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'JIO Token', 'JIO', 'jio.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://tamtamtravels.com/', '@TamTamTravels', 'JIO is a crypto asset issued on the NXT blockchain. The token is ment to be used for flights, hotels and other services offered within the members Area of TamTam Travels.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'iWallet', 'IW', 'iw.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'iWallet is a X11 Proof of Work/Proof of Stake cryptocurrency that enables almost instant payments to anyone in the world', '', '', 'X11', '2017-08-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Janus', 'JNS', 'jns.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://janustoken.com/', '@Janus_Token', 'The Janus token is a crypto asset built and issued on the NXT blockchain and later on migrated to the Ardor blockchain. A total amount of 100,000,000 tokens will be issued, of which 97% will be destributed to ICO investors. The Janus ICO will be held with the collaboration of the NXT team, which will perform as an escrow agent. The Janus project will then donate 5% of the funds received to the development of the NXT and Ardor projects.\n\nThe Janus token was created as a way to fund the Janus project and to allow token holders to share in the profits created by the Janus company through an automated and transparent dividends issuance system on the NXT platform. The company will also release an annual report in which its financial standing will be detailed along with key milestones achieved.\n\nJanus will be a software and services company that uses common technology to implement distinctly branded projects targeting a number of carfully selected markets. The Janus project has outlined content management, online and self publishing, marketplaces for targeted audiences and digital assets, online education technology, social fintech platforms, crypto financial services and social applications as some of the areas in which the company will develop solutions.', '', '', '', '2018-07-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TrickyCoin', 'TRICK', 'trick.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@TrickyCoin', 'TrickyCoin is a PoW/PoS Cryptocurrency, currently on the PoS stage.', '', '', 'PoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DeltaCredits', 'DCRE', 'dcre.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://twitter.com/', '@gladimorcrypto', 'DeltaCredits is a PoS cryptocurrency with a decreasing coin supply based on a buy-back program. In this program the developers buy back coins with profits made from various physical and cloud mining contracts, dispensed by reputable and trustworthy registered businesses. The coins purchased from the exchanges will be publicly burn them to decrease the coin supply.', '', '', '', '2017-06-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'FreeCoin', 'FRE', 'fre.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@fre_coin', 'FreeCoin is a Proof of Work coin with no PoW mining or ICO/IPO, instead the total supply was given away through an airdrop.', '', '', 'PoS', '2016-05-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NPCcoin', 'NPC', 'npc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://npccoin.com/', '@npccoin', 'NPCcoin is an SHA256d Proof of Work (PoW) / Proof of Stake (PoS) based cryptocurrency. PoS rewards are 30% for the 1st year, then 20% for the 2nd, 3rd year 15%, 4th year 10%, and then 7%.', '', '', 'SHA256D', '2016-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PLNCoin', 'PLNC', 'plnc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://plncoin.org/', NULL, 'PLNcoin is a Polish PoW cryptocurrency with a 38 540 000 coin supply, which is the number of people who live in Poland.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Digigems', 'DGMS', 'dgms.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@Digigems_', 'Digigems is a lite version of Bitcoin using scrypt as a proof-of-work algorithm.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Icobid', 'ICOB', 'icob.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.icobidplatform.net/', '@pioneer8816', 'Icobid is a Proof of Work/Proof of Stake cryptocurrency that fuels the Icobid platform. The Icobid platform will be the place for users to join, share ideas, vote for best ideas and earn by expressing their opinions, allowing users to easily publish teir proposals to be voted on and funded.', '', '', 'Scrypt', '2018-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AquariusCoin', 'ARCO', 'arco.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://aquariuscoin.com/', '@ArcCoin', 'AquariusCoin is a PoW/PoS cryptocurrency, currently in the Proof of Stake phase. It uses the Scrypt algorithm and has a 64 second block time.', '', '', 'Scrypt', '2017-07-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Kurrent', 'KURT', 'kurt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://kurrentproject.com/', '@Kurrent_Project', 'Kurrent is a Proof of Work cryptocurrency that uses zero knowledge proofs to provide anonymous transactions. It\'s the first zk cryptocurrency to add random bonus blocks in order to create a fun mining enviroment. Kurrent uses the X11 algorithm.', '', '', 'X11', '2016-06-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Creatio', 'XCRE', 'xcre.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://xcreatio.com/', '@creatioteam', 'Creatio is a Proof of Stake cryptocurrency that offers its users the possibility to create their own cryptocurrency within the wallet. The creation of the coin is done by the team, which only accepts XCRE as a payment method through the official wallet.', '', '', 'PoS', '2017-08-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Eternity', 'ENT', 'ent.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://ent.eternity-group.org/', '@Eternity_Group', 'Eternity is a Proof of Work/Proof of Stake cryptocurrency using the X11 algorith. It allows anonymous and almost instant transactions through the Spysend and InstantX features (respectively).', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'UR', 'UR', 'ur.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://www.ur.technology/', '@URforall', 'UR is a decentralized cryptographic information, application, and contract platform and a coin of the same name. The UR coin will be fairly distributed to all humans on Earth via the \"UR Airdrop,\" with each human receiving 2,000 UR initially and additional amounts. The coin itself is based on Ethereum, using the Dagger algorithm.', '', '', 'Dagger', '2017-04-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Metal Music v3', 'MTLM3', 'mtlm3.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@metalmusiccoin', 'etal Music Coin is a crypto currency based on scrypt algorithm.  \n  \nOur main goal is to be recognized as a crypto currency only for metal scene,  \nand most important is to support underground metal scene through the use of our Metal Music Coin.  \nThe goal of the Metal Music Coin is not profit, but the promotion of underground metal music and its artists.  \nThis desire and passion to spread the music is one that we can rally around and will fervently support and keep track of.', '', '', 'Scrypt', '2016-11-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Old Dogs New Tricks', 'ODNT', 'odnt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, ' Old Dogs New Tricks is a 501c3 non-profit organization of volunteers who provide veterinary care and meet the day-to-day needs of senior dogs while they look for forever homes. The ODNT coin is a SHA256D cryptocurrency created to crowdfund the improvement of this non-profit organization.', '', '', 'SHA256D', '2016-10-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Eurocoin', 'EUC', 'euc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@EuroCoinBot', 'Eurocoin is a region-specific cryptocurrency that uses the same hashing algorithm as Bitcoin, SHA256.', '', '', 'SHA256', '2015-01-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CoolDarkCoin', 'CCX', 'ccx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@coolindark', 'CoolDarkCoin is a Proof of Work/Proof of Stake cryptocurrency using the Scrypt algorithm. It has a 100% APY in staking rewards.', '', '', 'Scrypt', '2017-09-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitcoinFast', 'BCF', 'bcf.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://bitcoinfast.wordpress.com/', '@BitCoinFastTeam', 'BitCoinFast is a PoW/PoS cryptocurrency created to be a faster version of Bitcoin. It has a 60 second block time and uses the Scrypt algorithm. BCF has 33 Million POW Coins and a 25% Annual Stake.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SeedShares', 'SEEDS', 'seeds.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'SeedShares is a PoW/PoS cryptocurrency using the SHA256D algorithm. It aims to provide a means of exchanging botanical products and seeds over the TOR network.', '', '', 'SHA256D', '2016-02-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PoSWallet', 'POSW', 'posw.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'https://poswallet.com/', '@POSWallet', 'PoSWallet is a PoW/PoS cryptocurrency using the Scrypt algorithm. The PoSWallet service allows users to stake various cryptocurrencies in one single wallet. All dividends from the PoSWallet staking services are paid in POSW coin.', '', '', 'Scrypt', '2016-01-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Tokes', 'TKS', 'tks.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://cannabisrevolution.us/', '@TokesPlatform', 'Tokes is a crypto asset issued on the Waves blockchain. The Cannabis Revolution (TM), empowered by the tokes digital currency platform, aspires to be one of the first projects in the world to combine the technological advances of the blockchain and digital tokens with the cultural shift associated with the marijuana legalization movement.', '', '', '', '2016-03-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitConnect Coin', 'BCCOIN', 'bccoin.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://www.bitconnectcoin.co/', '@bitconnect', '**Warning: There is building evidence to suggest bitconnect is a ponzi [scam](https://s3-eu-west-1.amazonaws.com/document-api-images-prod/docs/wYGmnuGVgp6obZ3htZsVMhGcK8aZXTSlG2QBe9SXMjQ/application-pdf?AWSAccessKeyId=ASIAI7ZLYOQ5CYDZOLBQ&Expires=1510936190&Signature=R9GVPQgzyJF2NrsYDGLILMwRYJE%3D&x-amz-security-token=FQoDYXdzEJD%2F%2F%2F%2F%2F%2F%2F%2F%2F%2FwEaDIkfdQZ7MZkw%2Ff5jSyK3A80l4vRGmK%2F2zZLsci17QMb%2BaCHeQBsGVqlvcRQNmMetU7kbRzcjCoTuHSNaLbFjXyYg6LdwcafoCwix%2BRwOzHQenPxh5wmXNT%2BnPNNv4AB9t%2BxYdrm7VF%2FUpxE%2FfU5tSuBF74R%2FEY6vmuz0xM3x44Ot5Nlp7n3QB%2FRShfa%2BDt%2BGTuchgU7V6KcDLcGsPtpC05X%2B%2F5SzCsdb5FMR5A6fVhelS77%2FuXAW2Na%2BHaDAnCmX8KorDh%2Fo1%2BC1yl9al7gsFhv3SiN9zqqVoAuJNfK2J60O0NH%2FvJ35YX9IsYRWPjZARXdOvLw5OpB40XytYTbdi3CLfqOuwKe%2Bn4Pt20tKhoS6mWK%2BxAgg2QHaAqFm03TwHoi%2FunECDCBPM6CqvOD%2BNuKvHdTUNSfZ5lXE08xjk8AjinCgq5xl%2F23HoTE7QUSiYoHCy%2FVTVgCdCPMOWzPqtS4aA9TBMWpeKXNQ8L7oNep6s36%2Bk4L0Wi3nN2TafDXixue3X33ojoaago3VZ4YdqJTLP7ks2guxMJMpAfYciz6iTEQX7gxEp%2B8%2F3j%2FcT3PsleLG%2FXAWXZIbvPQo9PDGT4kZqPg1JVUo1%2Bi70AU%3D)**\n\nBitConnect Coin is a Proof of Work/Proof of Stake Scrypt cryptocurrency. They are used by bitconnect community members for bitconnect services and to store and invest the wealth in a non-government controlled currency. The BitConnect coins will also be used as payment system on number of BitConnect partner websites.', '', '', 'Scrypt', '2017-03-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ShortyCoin', 'SHORTY', 'shorty.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'ShortyCoin is a PoS cryptocurrency with a 7% apy in staking rewards.', 'social video sharing\n\n8 seconds limit\n\nsend self destructing videos\n\ncustomizable profiles', '', 'PoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Procom', 'PCM', 'pcm.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://www.procomcoin.org/', NULL, 'Procom is a Proof of Work cryptocurrency using the scrypt algorithm. It has a six minute block time average and a 28 million PCM supply.', '', '', 'Scrypt', '2016-05-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Kernalcoin', 'KC', 'kc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Kernalcoin is a PoW/PoS cryptocurrency. It uses the SHA256 algorithm and has a maximum PoW supply of 2500000. The Proof of Stake APY for Kernalcoin is 2.25%', '', '', 'SHA256', '2016-08-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CoralPay', 'CORAL', 'coral.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://coralpay.online/', '@CoralPay_Crypto', 'CoralPay is a Proof of Stake cryptocurrency. It uses the x13 algorithm and has a 5% APY in staking rewards.', '', '', 'X13', '2018-03-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BAM', 'BAMITCOIN', 'bamitcoin.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'BamitCoin is a PoW/PoS cryptocurrency, currently in a all-PoS stage. It has a APY of 23% in staking rewards.', '', '', 'X11', '2017-09-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Nexium', 'NXC', 'nxc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://beyond-the-void.net/', '@BeyondVoidGame', 'Nexium is an Ethereum-based token created to be used as in-game currency for items in the Beyond the Void game, an upcoming real-time strategy video game. NXC was created to provide true ownership in the game.', '', '', '', '2018-05-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MoneyCoin', 'MONEY', 'money.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@moneycoindev', 'MoneyCoin is a Proof of Work/Proof of Stake cryptocurrency using the Scrypt algorithm.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Blackstar', 'BSTAR', 'bstar.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'BSTAR is a Proof of Stake cryptocurrency.', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Horse Power', 'HSP', 'hsp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://horsepowercoin.eu/', '@HorsePowerCoin', 'Horse Powe is a Proof of Work cryptocurrency using the Scrypt algorithm. it has a 1 minute block time and a 6% premine.', '', '', 'Scrypt', '2016-08-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HazMatCoin', 'HZT', 'hzt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@hazmatcoin_', 'HazMatCoin is a Proof of Work/Proof of Stake hybrid cryptocurrency based on the Scrypt algorithm. It was created with the intention of providing the mining community with a quality coin to mine.', '', '', 'Scrypt', '2015-10-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CryptoSpots', 'CS', 'cs.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DPoS', NULL, '@CryptoSpot', 'CryptoSpots is a Delegated Proof of Stake (DPoS) cryptocurrency created to for for merchants and consumers to use during their everyday transactions.', '', '', 'DPoS', '2017-04-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PoolStamp', 'XSP', 'xsp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'PoolStamp is a Proof of Stake cryptocurrency based on the x13 algorithm. It had a 5 day Proof of Work stage in which 4 millions XSP were mined. PoolStamp is backed by a profit switching cloud multipool which mines BTC and major Altcoins to convert them into XSP. Holders recieve rewards from the PoS nature of the coin and from the market support generated by cloud mining multipool.', '', '', 'X13', '2014-12-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CryptoCarbon', 'CCRB', 'ccrb.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'CryptoCarbon is an Ethereum-based token issued using the EToken Protocol, which is a set of Ethereum smart contracts. It has a adjustable token supply. CryptoCarbon is backed by CRYPTOCARBON GLOBAL LTD and it is currently accepted for many services and products sold by a UK based company BEE-ONE UK LTD.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BullshitCoin', 'BULLS', 'bulls.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'BullShitCoin is a Proof of Work/Proof of Stake cryptocurrency based on the Scrypt algorithm. It has a 19% Premine that will be used for weekly airdrops and bounties.', '', '', 'Scrypt', '2017-08-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Incent', 'INCNT', 'incnt.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'http://www.incentloyalty.com/', '@IncentLoyalty', 'Incent is a crypto asset issued on the Waves blockchain. It to provides mechants with a universal currency of reward for loyalty points. Incent is based on the premise that restricting customers\' options as a way to ensure repeat business is a faulty method. Instead, Incent provides a reward that is universal and ensures that customers return to get more of these rewards.', '', '', '', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Iconic', 'ICON', 'icon.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://iconicproject.com/', '@ICONICTOKEN', 'Iconic is a blockchain based application platform that wants to make blockchain application integration more attractive for new parties by simplifying integration processes and adding practical user funcionality. ICN uses a new algorithm dubbed \"ICONIC Stake\" and has a total supply of 520 thousand coins.', 'Innovative blockchain applications\n\nBlockchain useability for secure and easy application integration\n\nSimplified wallet options suitable for mass adoption\n\nProperty Contracts for owner verification', '', 'PoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NewInvestCoin', 'NIC', 'nic.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://newinvestcoin.tk/', NULL, 'NewInvestCoin is a Proof of Stake cryptocurrency.', '', '', 'PoS', '2018-05-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AvonCoin', 'ACN', 'acn.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://avoncoin.org/', NULL, 'AvonCoin is a pure PoS coin which generates coins through PoS blocks. Except the first block where it generates the initial 100 million coins, no PoW mining will get any coins. The 1 billion coins were distributed equally to 1000 individuals with 100,000 coin each, completely free.', '', '', 'PoS', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Enigma', 'XNG', 'xng.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Enigma is a PoW/hi-PoS hybrid coin. It gives an APY of 300% in staking rewards in the first year, which s then reduced to 100%.', '', '', 'X11', '2016-10-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Cannabis Industry Coin', 'XCI', 'xci.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'Cannabis Industry Coin is a Proof of Work cryptocurrency based on the Cryptonight algorithm. It is a  is a privacy focused cryptocurrency for the legal Cannabis Industry', '', '', 'CryptoNight', '2017-04-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LookCoin', 'LOOK', 'look.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'LookCoin is a privacy driven cryptocurrency using the X11 algorithm. It uses a Proof of Work/Proof of Stake hybrid protocol.', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Loco', 'LOC', 'loc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Loco is a PoW/PoS hybrid cryptocurrency using the Quark algorithm. It features fast transactions through InstantX and anonymous payments through Darksend.', '', '', 'Quark', '2017-03-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MMXVI', 'MMXVI', 'mmxvi.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'MMXVI is a pure Proof of Work cryptocurrency using the Argon2 algorithm. It has a 30 second block time.', '', '', '', '2016-07-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TrustCoin', 'TRST', 'trst.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', 'https://www.wetrust.io/', '@WeTrustPlatform', 'WeTrust is a collaborative lending and insurance platform built on the blockchain created as an alternative to traditional finance and provide community based form of credit scores, insurance, and banking. The first product being built at WeTrust is a Rotating Savings and Credit Association (ROSCA) platform running on a decentralized blockchain, Ethereum. WeTrust ROSCA allows users to save and issue credit as a group, at self-determined and fair interest rates.\n\nTrustCoin is an Ethereum-based token that is used to fuel operations within the WeTrust services, like its ROSCA platform and future products.', '', '', '', '2016-07-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MIScoin', 'MIS', 'mis.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'MIScoin stands for Mobile Intelligent System Coin. It\'s based on X11 algo and has both PoW/Pos stages. MIS gives a 5% APY rate in stake rewards', '', '', 'X11', '2015-03-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'WorldPay', 'WOP', 'wop.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@worldpaydev', 'WorldPay is a PoW/PoS cryptocurrency based on the X11 algorithm. Mining rewards from the PoW stage grow exponentially, while the PoS stage gives a 2% APY in rewards', '', '', 'X11', '2015-07-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ConquestCoin', 'CQST', 'cqst.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@ConquestCoin', 'ConquestCoin is a X13 PoW/PoS cryptocurrency. It\'s suitable for gaming, shopping, and real-time transactions. It\'s integrated with true random super bonus block features.', '', '', 'X13', '2017-07-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Impulse Coin', 'IMPS', 'imps.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@impulsecoin', 'Impulse Coin is an anonymous and decentralized. It uses secure x13 algorithm. Impulse coin is Minable as well as holding coins in wallet generate a 6% interest yearly. This allows people to mine with GPUs and avoids centralization. It uses POW + POS hybrid block chain technology for securing the blockchain.', '', '', 'X13', '2017-07-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'InCoin', 'IN', 'in.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'InCoin is a PoW/PoS cryptocurrency using the X11 algorithm. It has a 30% APY in staking rewards from the PoS stage', '', '', 'X11', '2018-01-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TheChiefCoin', 'CHIEF', 'chief.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'TheChiefCoin is cryptocurrency focused on ease of use, security and development. It uses the Scrypt algorithm and it uses a PoW/PoS scheme.', '', '', 'Scrypt', '2017-04-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Goat', 'GOAT', 'goat.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@JStuhlman', 'Goat is a PoW/PoS cryptocurrency using the Scrypt algorithm.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AnalCoin', 'ANAL', 'anal.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'AnalCoin is a PoW/PoS cryptocurrency. It uses the same algorithm as Bitcoin, SHA256.', '', '', 'SHA256', '2015-11-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Russiacoin', 'RC', 'rc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Russiacoin is a Scrypt PoW/PoS cryptocurrency made for all people around the world and escpecially the russian altcoin-community. Russiacoin will be the first coin to use the GDR (=golden readjustment algorithm) which is just similar to std. diff. adj. but has a adapted PoS start diff. so it will be a hybrid PoW/PoS in the PoW stage to allow an stabilization of PoS diff. within the PoW stage to make sure the network runs fluid.', '', '', 'Scrypt', '2016-05-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PandaCoin', 'PND', 'pnd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://dev.digitalpandacoin.org/', '@PandaCoinPND', 'PandaCoin is a PoW Scrypt coin created for the Asian community. It is called the Bitcoin of Asia.', '', '', 'Scrypt', '2015-02-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PXcoin', 'PX', 'px.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'PX was swapped from PEX coin and it is a SHA256 PoW/PoS cryptocurrency.', '', '', 'SHA256', '2018-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Canada eCoin', 'CND*', 'cnd_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@ThisIsOurCoin', 'CanadaCoin is a merge mineable scrypt-based eCoin with a Canadian theme.', '', '', 'Scrypt', '2016-04-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OptionCoin', 'OPTION', 'option.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'OptionCoin is a X11 Proof of Stake cryptocurrency with a 10% APY in staking rewards.', '', '', 'X11', '2015-03-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Avatar Coin', 'AV', 'av.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'Avatar Coin is a pure Proof of Stake cryptocurrency with high staking rewards of 100% APY.', '', '', 'PoS', '2016-08-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Limited Coin', 'LTD', 'ltd.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'LimitedCoin (LTD) is a Proof of Stake cryptocurrency that has a total coin supply of only 128 coins. It has a high APY in staking rewards, which is 1000%', '', '', 'PoS', '2015-11-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GameUnits', 'UNITS', 'units.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'GameUnits is an Open Source Gaming currency created to revolutionize in-game purchases. Gameunits is a forked version of Bitcoin using scrypt as a proof-of-work & proof-of-stake algorithm.', '', '', 'Scrypt', '2018-03-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HeelCoin', 'HEEL', 'heel.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, '@heelcoin', 'HeelCoin is a full PoS cryptocurrency.', '', '', 'PoS', '2015-10-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GAKHcoin', 'GAKH', 'gakh.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'GAKHcoin is a Proof of Work/Proof of Stake cryptocurrency. It uses the Scrypt algorithm and has a 64 second block time.', '', '', 'Scrypt', '2018-01-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Shift', 'SHIFT', 'shift.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'DPoS', 'http://www.shiftnrg.org/', '@ShiftNrg', 'Shif is a dApp-ready, delegated Proof of Stake cryptocurrency with the interplanetary file system - for a decentralized, resilient and highly extensible web 3.0 platform.', '', '', 'DPoS', '2016-12-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'S88 Coin', 'S8C', 's8c.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'S88 Coin is a Proof of Work/Proof of Stake Scrypt-chacha based cryptocurrency. It cannot be mined with ASIC miners.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Leverage Coin', 'LVG', 'lvg.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@LVGCoin', 'LVG aims to bring about leverage trading to wider range of altcoins almost like the “yobit” of leverage trading. Coins will grouped into 3 categories to determine the leverage ratios: New, Stable and Veteran coins.', '', '', '', '2015-07-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DraculaCoin', 'DRA', 'dra.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'DraculaCoin is a Scrypt cryptocurrency.', '', '', 'Scrypt', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Allsafe', 'ASAFE2', 'asafe2.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'https://allsafetoken.com/', '@allsafetoken', 'Allsafe is a Proof of Stake Scrypt-based cryptocurrency with a 15% APY in staking rewards.', '', '', 'Scrypt', '2016-06-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LiteCreed', 'LTCR', 'ltcr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@litecredproject', 'Litecred is a PoW/PoS cryptocurrency with the characteristic of self-funded development, via block subsidy of 10% for each minted block, which guarantees a small and continuos flow to the developers, in order to mantain the project active. There is no developer premine at launch.', '', '', 'QuBit', '2017-04-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Quebecoin', 'QBC', 'qbc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'Québecoin is a PoW/PoS cryptocurrency using the X11 algorithm. It was launched in April 2014 and abandoned in the next few days. Over the past six weeks, the community of miners and investors have been coordinating a re-launch and preparing all the required pieces, including the removal of a 50% premine. The coin now has a 21M supply.', '', '', 'X11', '2015-12-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ProCoin', 'XPRO', 'xpro.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'ProCoin is a is a x15 PoW/PoS cryptocurrency. It has a 60 second block time and a 4% APY in Proof of Stake rewards.', '', '', 'X15', '2015-04-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Astral', 'AST*', 'ast_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Astral is a PoW/PoS X13-based cryptocurrency. It has a high yield of 100% APY in staking rewards.', '', '', 'X13', '2015-11-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'GiftNet', 'GIFT', 'gift.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'GiftNet is an ecosystem built on top of blockchain technology with the intent of providing a secure, anonymous marketplace in which free market economics prevail. GirftNet allows their users to encrypt their giftcard\'s verification code and only release the code once the desired clause has been met. GiftNet\'s native currency, GIFT is based on the x13 algorithm and uses a PoW protocol.', '', '', 'X13', '2015-12-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PureVidz', 'VIDZ', 'vidz.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'PureVidz is a blockchain base video sharing platform. The native currency in the system is VIDZ, a Proof of Work cryptocurrency based on the algorithm.', '', '', 'PoS', '2018-05-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Incrementum', 'INC', 'inc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'Incrementum is a pure Proof of Stake cryptocurrency with a high staking rate of 100%.', '', '', 'PoS', '2016-07-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PentaCoin', 'PTA', 'pta.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'PentaCoin is a Proof of Work/Proof of Stake cryptocurrency using the classic Sha256 hashing algorithm.', '', '', 'SHA256', '2016-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'AcidCoin', 'ACID', 'acid.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, NULL, 'AcidCoin is a Proof of Work cryptocurrency using the popular SHA256 hashing algorithm.', '', '', 'SHA256', '2017-11-04', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ZLiteQubit', 'ZLQ', 'zlq.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@Zlitequbit_ZLQ', 'ZLiteQubit is a cryptocurrency using the Qubit algorithm. It has a max supply of roughly 83M.', '', '', 'QuBit', '2016-08-11', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'RadicalCoin', 'RADI', 'radi.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'RadicalCoin is a fully Proof of Stake cryptocurrency with high PoS rewards. It uses the X11 algorithm and has a 100% APY in staking.', '', '', 'X13', '2016-11-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'ReturnCoin', 'RNC', 'rnc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'ReturnCoin (RNC) is a peer-to-peer digital currency with a distributed, decentralized public ledger; that unlike ones held at traditional banks, are viewable and easily audited by the people. ReturnCoin pays 100% interest per annum and is one of the best investments you can make. It will give you a full return in just 1 year.\n\nThe ability to manage transactions and issue additional ReturnCoins is all handled by the network of users utilizing ReturnCoin. Because the ReturnCoin network is run by the people, holders of ReturnCoin receive a 100% yearly interest through a process called staking.\n\nReturnCoin’s technology allows people to send and receive fast, easy and secure payments with friends, family, and merchants anywhere in the world. ReturnCoin allows you to manage your finances without the need for a central authority or bank.', '', '', 'X11', '2015-04-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Golos', 'GOLOS', 'golos.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://golos.io/', NULL, 'Blockchain-based social network for Russian-speaking people. It is a spin-off from the Steemit system. Steem owns 10% of the Golos.', '', '', '', '2017-10-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Pascal Coin', 'PASC', 'pasc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, '@PascalCoin', 'Pascal Coin prides itself on being an easy to understand and easy to work with Crypto because it is very similar to a bank. Using accounts instead of a cryptographic address lowers the entry barrier for people not used to the crypto space. Everybody needs to have a personal account in order to receive or send coins. The name derives from the use of Pascal programming language in the reference client.\n\n[Read White Paper Here](https://github.com/PascalCoin/PascalCoin/blob/master/PascalCoin%20White%20Paper%20-%20EN.pdf)', '- **Written in the Pascal programming language**. This is the first cryptocurrency written in the Pascal programming language. Easy to understand for students and binary multi-platform compatible. (like \"C++\", the language used to make BitCoin)\n  \n  \n  - All code is new and written by the Pascal Coin creator [Albert Molina](https://github.com/PascalCoin/PascalCoin/wiki/bpascalblockchain@gmail.com)\n  - Cross-platform. Source can be compiled with Delphi and/or Free Pascal compiler and run over with Windows / Linux / Mac\n- **Pascal Coin works with ordinal numbered accounts instead of complicated cryptocurrency addresses**, yes, like a traditional bank (from account \"0\" to account \"XXXX\")\n  \n  \n  - To operate with coins, first, you must have at least one account (like a bank)\n  - Accounts are created on each block by the miners. **Each block creates 5 new accounts**\n  - Users can\'t create accounts by themselves. Unless the user is a miner and creates a block. Users can only create public/private keys to operate with accounts. Users can also have someone with an extra account send one to their public wallet key.\n- Crypto keys (Public key/Private key) are not part of the address like Bitcoin, keys are used as a personal password to operate with your accounts (like a password PIN), wallets can also be locked with a password.\n- Due to the White Paper explained concept, historical transactions can be deleted, but there will always be some nodes with all historical transactions to check consensus on the blockchain.', '- Average block time - 5 minutes\n  \n  \n  - 288 blocks per day\n  - 105,120 blocks per year\n  - _Note: Average is an estimation, due to internal adjusting mechanism, real average time is a value between 4 and 5 minutes, having a range of 288-360 blocks/day or 105,120-131,400 blocks/year_\n- Pascal Coin use\'s **4 decimal values**: ex. 15.1234 (_15.12345 is not a valid value_)\n- Initial reward per mined block is **100.0000 Pascal Coins per block**.\n  - This value will be divided by 2 every 420,480 blocks (average 4 years), so the next cycle reward will be 50.0000, 25.0000, etc. ... until reaching 1.0000 Pascal Coin per block.\n  - **The minimum reward will be 1.0000 Pascal Coin.** After block 2,943,360 (avg 32 years) the block reward will remain a constant 1.0000\n- Pascal Coin uses self-creating accounts. **Each block produces 5 accounts**\n- **3 operation types** can be done with Pascal Coin:\n  \n  \n  - **Transaction 1 to 1**: A single and simple transaction, from one account to another account.\n  - **Change Account key**: Change Public/Private key of an account.\n  - **Recover funds**: Explained on the White Paper. This is to prevent lost keys/lost coins inside the Pascal Coin blockchain. This operation can only be done by miners when mining.\n      - Recover funds can only be executed after **420,480 blocks** when no operations occur in an account (approx 4 years)\n- In order to easily operate with Accounts, each account has 2 extra verification numbers.\n  \n  \n  - Account \"0\" -> \"0-10\"\n  - Account \"1\" -> \"1-22\"\n  - Account \"12345\" -> \"12345-54\"\n- Cryptographic keys (elliptic curve keys) used by Pascal Coin can be one of:\n  \n  \n  - secp256k1 (like bitcoin)\n  - secp384r1\n  - secp283k1\n  - secp521r1\n      - See \"SEC 2: Recommended Elliptic Curve Domain Parameters:\" \\[<http://www.secg.org/SEC2-Ver-1.0.pdf>\\]\n- Genesis block was created on August 11 2016\n- This coin has **NO PREMINE**. All coins have been distributed to miners from block 0.\n- _Note: Current blockchain version is 1. The Pascal technical\'s can only change with a blockchain version upgrade_', '', '2016-11-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'TwisterCoin', 'TWIST', 'twist.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'TwisterCoin is a PoW/PoS cryptocurrency based on the X11 algorithm. It was created to facilitate selling and buying Twister jewelry.', '', '', 'X11', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'PayPeer', 'PAYP', 'payp.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@PayPeerDev', 'PayPeer is a Proof of Work/Proof of Stake cryptocurrency based on the X11 algorithm. It has a high APY of 365% in staking rewards.', '', '', 'X11', '2017-07-02', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'DarkEther', 'DETH', 'deth.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, 'DarkEther is a Proof of Work/Proof of Stake cryptocurrency based on the X11 algorithm.', '', '', 'X11', '2015-09-08', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'YAYcoin', 'YAY', 'yay.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'YAYcoin is Proof of Work/Proof of Stake cryptocurrency based on the popular Scrypt algorithm. It has a high APY of 100% in staking rewards.', '', '', 'Scrypt', '2016-07-07', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'YesCoin', 'YES', 'yes.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'YesCoin is a PoW/PoS scrypt cryptocurrency with a 88% return in staking rewards.', '', '', 'Scrypt', '2018-11-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'LeninCoin', 'LENIN', 'lenin.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://lenincoin.com/', NULL, 'LeninCoin is a PoW', '', '', 'SHA256D', '2018-12-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MrsaCoin', 'MRSA', 'mrsa.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'MrsaCoin is a Proof of Work/Proof of Stake hybrid cryptocurrency using the X13 algorithm. It has a premine of 20%.', '', '', 'X13', '2017-03-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'OsmiumCoin', 'OS76', 'os76.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@OS76_OsmiumCoin', 'OsmiumCoin is a Proof of Work cryptocurrency based on the popular Scrypt algorithm. Although the coin name is based on Osmium, the coin has no relation to it whatsoever.', '', '', 'Scrypt', '2016-05-10', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'BitBoss', 'BOSS', 'boss.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'BitBoss is a cryptocurrency based on Bitcoin0s characteristics but with a few changes. The coin uses SHA256 algorithm and has the same 10 minute blocktime. However, BitBoss is a PoW/PoS cryptocurrency that gives out a 30% APY in staking rewards.', '', '', 'SHA256', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Bikercoins', 'BIC', 'bic.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://bikercoin.org/', '@BikerCoins', 'Bikercoin is a digital cryptocurrency that operates on a community-based standard of value using peer-to-peer (P2P) networking as the means of conducting transactions. Rather than having a central authority determine the value of the currency, its worth is determined by the number of products and services people are willing to buy or sell using Bikercoins. Bikercoins have a global value, so they can be used in any country, at any time. Bikercoin is also open-source; its architecture is public, nobody owns or controls Bikercoin and anybody can take part.\n\nBikercoin uses the cryptonote algorithm and is a PoW coin.', '', '', 'CryptoNight', '2016-07-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'CryptoPennies', 'CRPS', 'crps.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', NULL, NULL, 'CryptoPennies is a Proof of Stake cryptocurrency (PoW is over) that uses the X11 algorithm.', '', '', 'X11', '2017-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Motocoin', 'MOTO', 'moto.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoP', 'http://motocoin.org/', '@Motocoin', 'Motocoin is a cryptocurrency utilizing an innovative proof-of-play scheme where coins can only be mined by cognitive workload - playing a 2D motorbike simulation game, which is different from Bitcoin and other crypto-currencies that use a proof-of-work scheme where miners must perform difficult computations and then use proof of that work to secure coin transactions and get their reward. Motocoin was historically dominated by bots, but is currently testing a new security model that better enforces balanced play.', '', '', '', '2014-01-05', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'NeptuneClassic', 'NTCC', 'ntcc.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', 'http://tituslimited.asia/', NULL, 'NeptuneClassic is a Proof of Work/Proof of Stake cryptocurrency based on the X11 algorithm.', '', '', 'X11', '2017-07-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Numismatic Collections', 'XNC*', 'xnc_.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, NULL, 'Numismatic Collections is a Proof of Work/Proof of Stake cryptocurrency created to facilitate the investment in antique coins for users in Japan.', '', '', 'X13', '0001-01-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'HexxCoin', 'HXX', 'hxx.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', NULL, '@hxxcoin', 'Hexxcoin is a Proof of Work cryptocurrency that uses the lyra2rev2 algorithm. HXX makes user of the Anonymous Zerocoin Protocol to provide private transactons', '', '', 'Lyra2RE', '2015-05-09', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Ghost Coin', 'SPKTR', 'spktr.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW/PoS', NULL, '@SPKTRteam', 'Ghost Coin is a Proof of Work/Proof of Stake cryptocurrency based on the popular SHA256 algorithm, the same used in Bitcoin.', '', '', 'SHA256', '2017-01-06', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'MachineCoin', 'MAC', 'mac.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'https://machinecoin.org/', NULL, 'Machinecoin is a free and decentralized peer-to-peer cryptocurrency that is completely open source and uses TimeTravel as a proof-of-work algorithm. Machinecoin operates with no central authority or any banks; managing transactions and the issuing of Machinecoins is carried out collectively by the network itself. [Paper Wallets](https://paper.machinecoin.org/) allow to store Machinecoins offline and even much more safer than this can be done with any fiat money. [Exchanges](https://www.cryptopia.co.nz/Exchange?market=MAC_BTC) can be used to trade Machinecoins with Bitcoins and other cryptocurrencies. [Work](https://machinecoin.work/) can be done with Machinecoin either as an employer or as an employee.', '', '', 'Time Travel', '2014-07-01', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'SelenCoin', 'SEL', 'sel.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://selencoin.for-biz.com/', NULL, 'SelenCoin (SEL) is a PoS cryptocurrency designed to assist the development of small businesses.', '', '', 'PoS', '2017-05-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'Noocoin', 'NOO', 'noo.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoS', 'http://www.noohack.com/', '@noocoin', 'NooCoin is a Proof of Stake cryptocurrency created to empower the NooHack business with blockchain technology, providing an alternative payment method. Noohack provides Nootropics, which are cognitive enhancing drugs.', '', '', 'PoS', '2015-04-12', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, '23 Skidoo', 'CHAO', 'chao.jpg', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'PoW', 'http://23skidoo.info/', NULL, '23 Skidoo is a SHA256D cryptocurrency. It is mined through a Proof of Work mechanism and is said to be the cryptocurrency of the Illuminatus.', '', '', 'SHA256D', '2015-03-03', '2001-01-01 00:00:00');
INSERT INTO `coins`(`coin_id`, `name`, `symbol`, `logo`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `available_supply`, `total_supply`, `max_supply`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `proof_type`, `website`, `twitter`, `description`, `features`, `technology`, `algorithm`, `start_date`, `last_updated`) VALUES (NULL, 'YamahaCoin', 'YMC', '