<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.transfer' => 'Transfer',
    'global.reset' => 'Reset',
    'global.share' => 'Share',
    'global.share_via' => 'Share via %s',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose language',
    'global.choose_currency' => 'Choose currency',
    'global.theme_style' => 'Switch to %s (CMD/CTRL + I)',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available',
    'global.na' => 'N/A',
    'global.unknown' => 'Unknown',
    'global.none' => 'None',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.status' => 'Status',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.download' => 'Download',
    'global.all' => 'All',
    'global.order' => 'Order',
    'global.statistics' => 'Statistics',
    'global.download_as' => 'Download as %s',
    'global.export' => 'Export',
    'global.export_to' => 'Export to %s',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.remove_selected_file' => 'Remove selected file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.duplicated' => 'Duplicated',
    'global.datetime' => 'Created on',
    'global.last_datetime' => 'Updated on',
    'global.datetime_tooltip' => 'Created on %s',
    'global.last_datetime_tooltip' => 'Updated on %s',
    'global.device' => 'Device',
    'global.device.desktop' => 'Desktop',
    'global.device.tablet' => 'Tablet',
    'global.device.mobile' => 'Mobile',
    'global.continent' => 'Continent',
    'global.continents' => 'Continents',
    'global.country' => 'Country',
    'global.countries' => 'Countries',
    'global.city' => 'City',
    'global.cities' => 'Cities',
    'global.os_name' => 'Operating system',
    'global.browser_name' => 'Browser',
    'global.browser_language' => 'Browser language',
    'global.ip' => 'IP',
    'global.name' => 'Name',
    'global.description' => 'Description',
    'global.title' => 'Title',
    'global.email' => 'Email',
    'global.email_placeholder' => 'hello@example.com',
    'global.password' => 'Password',
    'global.user' => 'User',
    'global.image' => 'Image',
    'global.icon' => 'Icon',
    'global.icon_placeholder' => 'fas fa-bolt',
    'global.icon_help' => '<a href="https://fontawesome.com/search?o=r&m=free" target="_blank">FontAwesome</a> icon class.',
    'global.url' => 'URL',
    'global.url_placeholder' => 'https://example.com/',
    'global.url_slug_placeholder' => 'example',
    'global.host' => 'Host',
    'global.host_placeholder' => 'example.com',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.spintax_help' => 'You can also use Spintax format, as such: <code>{Hi|Hey|Hello}</code> to randomize words or phrases.',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',
    'global.update_x' => 'Edit %s',
    'global.mb' => 'MB',
    'global.details' => 'Details',
    'global.type' => 'Type',
    'global.view_all' => 'View all',
    'global.select_all' => 'Select all',
    'global.deselect_all' => 'Deselect all',
    'global.show' => 'Show',
    'global.hide' => 'Hide',
    'global.chart_help' => 'Chart automatically refreshes every %1$s hours. Data from the last %2$s days.',
    'global.id' => 'Entry number (ID)',
    'global.variables' => 'You can use the following dynamic variables: %s.',
    'global.translate' => 'Translate',
    'global.scroll_top' => 'Scroll top',
    'global.scroll_bottom' => 'Scroll bottom',
    'global.no_chart_data' => 'No data available',
    'global.no_chart_data_help' => 'There is not enough data to generate a chart.',
    'global.image_error' => 'Image error',
    'global.spotlight.search_placeholder' => '🔎 Search & go to a page...',
    'global.spotlight.tooltip' => 'Spotlight search (CMD/CTRL + K)',
    'global.drag_and_drop' => 'Drag & drop to reorder',
    'global.crop' => 'Crop image',
    'global.crop_selection' => 'Crop selection',
    'global.no_crop' => 'Continue without cropping',
    'global.prefilled_dynamic_name' => '%1$s %2$s - %3$s, %4$s',
    'global.day_part_late_night' => 'Late Night',
    'global.day_part_early_morning' => 'Early Morning',
    'global.day_part_morning' => 'Morning',
    'global.day_part_afternoon' => 'Afternoon',
    'global.day_part_evening' => 'Evening',
    'global.day_part_night' => 'Night',

    'global.custom_css' => 'Custom CSS',
    'global.custom_css_placeholder' => 'body { background: blue !important; }',
    'global.custom_css_help' => 'Your CSS code to modify the already existing page style.',
    'global.custom_js' => 'Custom JS',
    'global.custom_js_help' => 'Your custom JS code to enhance the capability of your page.',
    'global.custom_js_placeholder' => '<script>console.log(`Hello world`);</script>',

    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is now limited.',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_upgrade' => 'Upgrade your plan 🔐',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.plan_feature_limit_info' => '%1$s out of %2$s used <br /> %3$s remaining',
    'global.info_message.plan_feature_limit_month_info' => '%1$s out of %2$s used <br /> %3$s remaining this month',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the required fields.',
    'global.error_message.empty_field' => 'This field is required, you must fill it.',
    'global.error_message.invalid_file_type' => 'You are not allowed to upload files of this type.',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again.',
    'global.error_message.basic' => 'We could not perform this action.',
    'global.error_message.file_size_limit' => 'The uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'The password must be between 6 and 64 characters.',
    'global.error_message.passwords_not_matching' => 'The entered passwords do not match.',
    'global.error_message.invalid_email' => 'The entered email is invalid.',
    'global.error_message.invalid_captcha' => 'The entered captcha code is invalid.',
    'global.error_message.function_required' => '<code>%s</code> is required, but your server does not have it enabled. Contact your server administrator.',
    'global.error_message.limit_try_again' => 'You reached the limit. Try again in %1$s %2$s.',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin panel',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',
    'global.accessibility.file_size_limit' => '%s MB maximum.',
    'global.accessibility.admin_file_size_limit_help' => 'You are not able to set a higher limit than your actual server upload limit.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.tooltip' => 'Filters<br />(CMD/CTRL + SHIFT + F)',
    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.clear' => 'Clear filters',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_by_last_datetime' => 'Updated datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.results_per_page' => 'Results per page',
    'global.filters.no_data' => 'No filtered data found',
    'global.filters.no_data_help' => 'No matches found for your filter.',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.last_7_days' => 'Last 7 days',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.week' => 'week',
    'global.date.weeks' => 'weeks',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',
    'global.emails.is_broadcast' => 'You are receiving this email because you have subscribed to our newsletter broadcasts. You can %sUnsubscribe here%s at any point in time.',

    'global.emails.user_welcome.subject' => 'Welcome to {{WEBSITE_TITLE}}',
    'global.emails.user_welcome.body' => 'Hello, <strong>{{NAME}}</strong>!<br /><br />Welcome to our website community, we\'re excited to have you on board!<br /><br />Get started by visiting our <a href="{{URL}}">homepage</a> or your <a href="{{DASHBOARD_LINK}}">dashboard</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_activation.subject' => 'Confirm your new account - {{WEBSITE_TITLE}}',
    'global.emails.user_activation.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and your account is ready,<br /><br />Click the link below in order to join <strong>{{WEBSITE_TITLE}}</strong><br /><br /><a href="{{ACTIVATION_LINK}}" class="cta">Activate account</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}" class="cta">Confirm email address change</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is your reset password link:<br /><br /><a href="{{LOST_PASSWORD_LINK}}" class="cta">Reset password</a><br /><br />If you did not request this, you can ignore it.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />You\'ve paid for the <strong>{{PLAN_NAME}}</strong> plan until <strong>{{PLAN_EXPIRATION_DATE}}</strong>.<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_data_collected.subject' => 'New data for \'{{BLOCK_TITLE}}\' - {{WEBSITE_TITLE}}',
    'global.emails.user_data_collected_phone_collector.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You just got a new <strong>Phone Collector</strong> data submission from one of your visitors.<br /><br /><strong>Phone:</strong> {{DATA_PHONE}}<br /><strong>Name:</strong> {{DATA_NAME}}<br /><br /><a href="{{DATA_LINK}}" class="cta">View all collected data</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',
    'global.emails.user_data_collected_email_collector.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You just got a new <strong>Email Collector</strong> data submission from one of your visitors.<br /><br /><strong>Email:</strong> {{DATA_EMAIL}}<br /><strong>Name:</strong> {{DATA_NAME}}<br /><br /><a href="{{DATA_LINK}}" class="cta">View all collected data</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',
    'global.emails.user_data_collected_contact_collector.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You just got a new <strong>Contact Form</strong> data submission from one of your visitors.<br /><br /><strong>Email:</strong> {{DATA_EMAIL}}<br /><strong>Phone:</strong> {{DATA_PHONE}}<br /><strong>Name:</strong> {{DATA_NAME}}<br /><strong>Message:</strong> {{DATA_MESSAGE}}<br /><br /><a href="{{DATA_LINK}}" class="cta">View all collected data</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',
    'global.emails.user_data_collected_appointment_calendar.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You just got a new <strong>Appointment Calendar</strong> booking from one of your visitors.<br /><br /><strong>Date:</strong> {{DATA_DATE}}<br /><strong>Time:</strong> {{DATA_TIME}}<br /><strong>Email:</strong> {{DATA_EMAIL}}<br /><strong>Phone:</strong> {{DATA_PHONE}}<br /><strong>Name:</strong> {{DATA_NAME}}<br /><strong>Message:</strong> {{DATA_MESSAGE}}<br /><br /><a href="{{DATA_LINK}}" class="cta">View all collected data</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_guest_payment_donation.subject' => '{{TOTAL_AMOUNT}} {{CURRENCY}} donation for \'{{DONATION_TITLE}}\' - {{WEBSITE_TITLE}}',
    'global.emails.user_guest_payment_donation.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You just got a new donation from one of your visitors.<br /><br /><strong>Email:</strong> {{EMAIL}}<br /><strong>Name:</strong> {{NAME}}<br /><strong>Total amount:</strong> {{TOTAL_AMOUNT}}<br /><strong>Currency:</strong> {{CURRENCY}}<br /><strong>Processor:</strong> {{PROCESSOR}}<br /><strong>Donation:</strong> {{DONATION_TITLE}}<br /><strong>Message:</strong> {{MESSAGE}}<br /><br /><a href="{{GUESTS_PAYMENTS_LINK}}" class="cta">View all payments</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_guest_payment_product.subject' => '\'{{PRODUCT_TITLE}}\' sold for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.user_guest_payment_product.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You just got a new payment from one of your visitors, for one of your products.<br /><br /><strong>Email:</strong> {{EMAIL}}<br /><strong>Name:</strong> {{NAME}}<br /><strong>Total amount:</strong> {{TOTAL_AMOUNT}}<br /><strong>Currency:</strong> {{CURRENCY}}<br /><strong>Processor:</strong> {{PROCESSOR}}<br /><strong>Product:</strong> {{PRODUCT_TITLE}}<br /><br /><a href="{{GUESTS_PAYMENTS_LINK}}" class="cta">View all payments</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.guest_guest_payment_product.subject' => 'You purchased \'{{PRODUCT_TITLE}}\' - {{WEBSITE_TITLE}}',
    'global.emails.guest_guest_payment_product.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is the official email notice that your order is successful. You can use the download link below to download the product you purchased.<br /><br /><strong>Download link:</strong> {{DOWNLOAD_LINK}}<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_guest_payment_service.subject' => '\'{{SERVICE_TITLE}}\' sold for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.user_guest_payment_service.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />You just got a new payment from one of your visitors, for one of your services.<br /><br /><strong>Email:</strong> {{EMAIL}}<br /><strong>Name:</strong> {{NAME}}<br /><strong>Total amount:</strong> {{TOTAL_AMOUNT}}<br /><strong>Currency:</strong> {{CURRENCY}}<br /><strong>Processor:</strong> {{PROCESSOR}}<br /><strong>Service:</strong> {{SERVICE_TITLE}}<br /><strong>Message:</strong> {{MESSAGE}}<br /><br /><a href="{{GUESTS_PAYMENTS_LINK}}" class="cta">View all payments</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.guest_guest_payment_service.subject' => 'You paid for \'{{SERVICE_TITLE}}\' - {{WEBSITE_TITLE}}',
    'global.emails.guest_guest_payment_service.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is the official email notice that your order is successful. You will get contacted by the provider of the service as soon as possible.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple reminder that your <strong>{{PLAN_NAME}} plan</strong> is going to expire in <strong>{{DAYS_UNTIL_EXPIRATION}} days</strong>.<br /><br />You must renew your plan if you wish to continue using our website with all the features you have.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew plan</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_plan_expired.subject' => 'Your plan has expired - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expired.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />Your <strong>{{PLAN_NAME}} plan</strong> has expired as you haven\'t renewed your membership.<br /><br />If you wish to continue using our website with all the features you had, you will need to renew your membership.<br /><br /><a href="{{USER_PLAN_RENEW_LINK}}" class="cta">Renew plan</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply login with your account and the deletion process will be stopped.<br /><br /><a href="{{LOGIN_LINK}}">Login & stop deletion</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to sign-up another account with us.<br /><br /><a href="{{REGISTER_LINK}}" class="cta">Register again</a><br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hello, <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM:NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hello,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}" class="cta">login and accept invitation</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',
    'global.emails.team_member_create.body_register' => 'Hello,<br /><br />You have been invited by <strong>{{USER:NAME}}</strong> ({{USER:EMAIL}}) to join the <strong>{{TEAM:NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}" class="cta">register and accept invitation</a>.<br /><br />Regards,<br />The {{WEBSITE_TITLE}} team.',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) has signed up successfully.<br /><br /><strong>Source:</strong> {{SOURCE}}<br /><strong>IP:</strong> {{IP}}<br /><strong>Country:</strong> {{COUNTRY_NAME}}<br /><strong>City:</strong> {{CITY_NAME}}<br /><strong>Device:</strong> {{DEVICE_TYPE}}<br /><strong>OS:</strong> {{OS_NAME}}<br /><strong>Browser:</strong> {{BROWSER_NAME}}<br /><br /><a href="{{USER_LINK}}" class="cta">View user</a>',

    'global.emails.admin_delete_user_notification.subject' => 'User deleted his account - {{WEBSITE_TITLE}}',
    'global.emails.admin_delete_user_notification.body' => 'All data of <strong>{{NAME}}</strong> ({{EMAIL}}) has been deleted.<br /><br /><strong>Account age:</strong> {{ACCOUNT_AGE}}<br /><strong>Source:</strong> {{SOURCE}}<br /><strong>IP:</strong> {{IP}}<br /><strong>Country:</strong> {{COUNTRY_NAME}}<br /><strong>City:</strong> {{CITY_NAME}}<br /><strong>Device:</strong> {{DEVICE_TYPE}}<br /><strong>OS:</strong> {{OS_NAME}}<br /><strong>Browser:</strong> {{BROWSER_NAME}}<br /><br />All of the data related to this user has been deleted.',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> for the <strong>{{PLAN_NAME}} plan</strong>.<br /><br /><strong>Type:</strong> {{PAYMENT_TYPE}}<br /><strong>Frequency:</strong> {{PAYMENT_FREQUENCY}}<br /><strong>Processor:</strong> {{PROCESSOR}}<br /><strong>Code:</strong> {{CODE}} (-{{DISCOUNT_AMOUNT}} {{CURRENCY}})<br /><strong>Payment ID:</strong> {{PAYMENT_ID}}<br /><strong>Processor payment ID:</strong> {{EXTERNAL_PAYMENT_ID}}<br /><strong>Status:</strong> {{PAYMENT_STATUS}}<br /><strong>Date:</strong> {{DATE}} {{DATE_TIMEZONE}}<br /><br /><a href="{{PAYMENT_LINK}}" class="cta">View payment</a>',

    'global.emails.admin_new_code_redeemed_notification.subject' => '{{CODE}} code has been redeemed - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_code_redeemed_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) has just redeemed the <strong>{{CODE}}</strong> redeemable code for <strong>{{REDEEMED_DAYS}} days</strong> on the <strong>{{PLAN_NAME}} plan</strong>.<br /><br /><a href="{{USER_LINK}}" class="cta">View user</a>',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}" class="cta">View affiliate withdrawal</a>',

    'global.emails.admin_new_domain_notification.subject' => 'New custom domain is pending approval - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_domain_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user\'s custom domain ({{DOMAIN_HOST}}) is now pending approval.<br /><br /> <a href="{{ADMIN_DOMAIN_UPDATE_LINK}}" class="cta">View domain</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) has sent you the following message:<br /><br />{{MESSAGE}}',


    'global.notifications.new_user.title' => 'New user!',
    'global.notifications.new_user.description' => '<strong>%1$s</strong> (%2$s) has signed up successfully.',

    'global.notifications.delete_user.title' => 'User deleted!',
    'global.notifications.delete_user.description' => '<strong>%1$s</strong> (%2$s) has deleted his account.',

    'global.notifications.new_payment.title' => 'New payment!',
    'global.notifications.new_payment.description' => '<strong>%1$s</strong> (%2$s) user just paid <strong>%3$s %4$s</strong> via %5$s.',

    'global.notifications.new_affiliate_withdrawal.title' => 'New affiliate withdrawal request!',
    'global.notifications.new_affiliate_withdrawal.description' => '<strong>%1$s</strong> (%2$s) user just submitted an affiliate withdrawal request for <strong>%3$s %4$s</strong>.',

    'global.notifications.new_newsletter_subscriber.title' => 'New newsletter subscriber!',
    'global.notifications.new_newsletter_subscriber.description' => '<strong>%1$s</strong> (%2$s) has subscribed successfully.',


    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent.',
    'global.cookie_consent.modal.preferences.header' => 'Cookie preferences',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.customize' => 'Customize',
    'global.cookie_consent.save' => 'Save settings',

    'global.footer.copyright' => 'Copyright © %1$s %2$s.',

    'global.plan_settings.annual_price_savings' => 'You save %s by purchasing the annual plan',
    'global.plan_settings.additional_domains' => '%s additional domains',
    'global.plan_settings.additional_domains_help' => 'You get to choose from multiple domains when creating new links. %s',
    'global.plan_settings.custom_url' => 'Custom back-half',
    'global.plan_settings.custom_url_help' => 'Instead of auto generated urls, like /a853we6, you get to choose your own',
    'global.plan_settings.deep_links' => 'Deep linking',
    'global.plan_settings.deep_links_help' => 'Provides the ability to enter deep links, like: steam://rungameid/id',
    'global.plan_settings.no_ads' => 'No ads',
    'global.plan_settings.no_ads_help' => 'No ads for everything related to your account and experience.',
    'global.plan_settings.export' => '%s export features',
    'global.plan_settings.removable_branding' => 'Removable branding',
    'global.plan_settings.removable_branding_help' => 'All the branding will be removed from branded resources.',
    'global.plan_settings.custom_branding' => 'Custom branding',
    'global.plan_settings.custom_branding_help' => 'Change and whitelabel the branding of your Biolinks',
    'global.plan_settings.statistics' => 'Indepth statistics',
    'global.plan_settings.statistics_help' => 'You get access to more advanced statistics for all your links',
    'global.plan_settings.temporary_url_is_enabled' => 'Links scheduling & limiter',
    'global.plan_settings.temporary_url_is_enabled_help' => 'The ability to schedule links for when to go live & when to expire based on amount of clicks or date range.',
    'global.plan_settings.cloaking_is_enabled' => 'Cloaking short URLs',
    'global.plan_settings.cloaking_is_enabled_help' => 'The ability to hide the original destination URL of a short link, under the created short alias.',
    'global.plan_settings.app_linking_is_enabled' => 'Auto open app on mobile',
    'global.plan_settings.app_linking_is_enabled_help' => 'The ability to automatically detect and open the specific apps on mobile for short URLs.',
    'global.plan_settings.targeting_is_enabled' => 'Advanced targeting',
    'global.plan_settings.targeting_is_enabled_help' => 'The ability to use the short URLs targeting features: Continent, Country, City, Device, OS, Browser, Language, A/B testing.',
    'global.plan_settings.seo' => 'SEO features',
    'global.plan_settings.seo_help' => 'Customize the meta tags for your pages',
    'global.plan_settings.utm' => 'UTM parameters',
    'global.plan_settings.utm_help' => 'The ability to use the UTM parameters builder for your links',
    'global.plan_settings.fonts' => 'Additional fonts',
    'global.plan_settings.fonts_help' => 'Get access to multiple fonts to use for your pages.',
    'global.plan_settings.password' => 'Password protection',
    'global.plan_settings.password_help' => 'Get access to password protect your links or pages.',
    'global.plan_settings.sensitive_content' => 'Sensitive content',
    'global.plan_settings.sensitive_content_help' => 'Get access to enable sensitive content warning on your links or pages.',
    'global.plan_settings.leap_link' => 'Leap link',
    'global.plan_settings.leap_link_help' => 'The ability to temporarily redirect a biolink page to a specific URL.',
    'global.plan_settings.dofollow_is_enabled' => 'Dofollow links',
    'global.plan_settings.dofollow_is_enabled_help' => 'All your links from your biolink pages will be dofollow links.',
    'global.plan_settings.custom_pwa_is_enabled' => 'Custom PWA app',
    'global.plan_settings.custom_pwa_is_enabled_help' => 'Generate a custom PWA app for all of your biolink pages.',
    'global.plan_settings.biolink_blocks_limit' => '<strong>%s</strong> biolink blocks',
    'global.plan_settings.projects_limit' => '<strong>%s</strong> projects',
    'global.plan_settings.splash_pages_limit' => '<strong>%s</strong> splash pages',
    'global.plan_settings.pixels_limit' => '<strong>%s</strong> pixels',
    'global.plan_settings.qr_codes_limit' => '<strong>%s</strong> QR codes',
    'global.plan_settings.qr_codes_bulk_limit' => '<strong>%s</strong> bulk QR codes Limit',
    'global.plan_settings.signatures_limit' => '<strong>%s</strong> email signatures',
    'global.plan_settings.biolinks_limit' => '<strong>%s</strong> biolink pages',
    'global.plan_settings.links_limit' => '<strong>%s</strong> shortened links',
    'global.plan_settings.links_bulk_limit' => '<strong>%s</strong> bulk links',
    'global.plan_settings.files_limit' => '<strong>%s</strong> file links',
    'global.plan_settings.vcards_limit' => '<strong>%s</strong> vcard links',
    'global.plan_settings.events_limit' => '<strong>%s</strong> event links',
    'global.plan_settings.static_limit' => '<strong>%s</strong> static sites',
    'global.plan_settings.domains_limit' => '<strong>%s</strong> custom domains',
    'global.plan_settings.payment_processors_limit' => '<strong>%s</strong> payment processors',
    'global.plan_settings.track_links_retention' => '<strong>%s</strong> stats retention',
    'global.plan_settings.enabled_biolink_blocks_all' => '<strong>All biolink blocks</strong>',
    'global.plan_settings.enabled_biolink_blocks_x' => '<strong>%s</strong> biolink blocks',
    'global.plan_settings.biolinks_themes' => '<strong>%s</strong> biolink themes',
    'global.plan_settings.biolinks_templates' => '<strong>%s</strong> biolink templates',
    'global.plan_settings.no_forced_splash_page' => 'No forced splash page',
    'global.plan_settings.no_forced_splash_page_help' => 'A temporary splash page with a countdown timer on certain links.',
    'global.plan_settings.api_is_enabled' => 'API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',
    'global.plan_settings.white_labeling_is_enabled' => 'White labeling',
    'global.plan_settings.white_labeling_is_enabled_help' => 'White label your whole account title, logo, favicon and footer.',
    'global.plan_settings.custom_css_is_enabled' => 'Custom CSS',
    'global.plan_settings.custom_css_is_enabled_help' => 'Add your custom CSS code to modify the already existing page style.',
    'global.plan_settings.custom_js_is_enabled' => 'Custom JS',
    'global.plan_settings.custom_js_is_enabled_help' => 'Add your custom JS code to enhance the capability of your page.',
    'global.plan_settings.affiliate_commission_percentage' => '<strong>%s</strong> affiliate percentage',
    'global.plan_settings.affiliate_commission_percentage_help' => 'The percentage amount that you can earn with the affiliate program.',
    'global.plan_settings.teams_limit' => '<strong>%s</strong> teams',
    'global.plan_settings.team_members_limit' => '<strong>%s</strong> team members',
    'global.plan_settings.notification_handlers_limit' => 'Multiple notification handlers',
    'global.plan_settings.notification_handlers_email_limit' => '%s email handlers',
    'global.plan_settings.notification_handlers_webhook_limit' => '%s webhook handlers',
    'global.plan_settings.notification_handlers_slack_limit' => '%s Slack handlers',
    'global.plan_settings.notification_handlers_discord_limit' => '%s Discord handlers',
    'global.plan_settings.notification_handlers_microsoft_teams_limit' => '%s Microsoft Teams handlers',
    'global.plan_settings.notification_handlers_twilio_limit' => '%s SMS handlers',
    'global.plan_settings.notification_handlers_twilio_call_limit' => '%s Phone call handlers',
    'global.plan_settings.notification_handlers_telegram_limit' => '%s Telegram handlers',
    'global.plan_settings.notification_handlers_whatsapp_limit' => '%s Whatsapp handlers',
    'global.plan_settings.notification_handlers_google_chat_limit' => '%s Google chat handlers',
    'global.plan_settings.notification_handlers_x_limit' => '%s X handlers',
    'global.plan_settings.notification_handlers_push_subscriber_id_limit' => '%s Push subscribers handlers',
    'global.plan_settings.notification_handlers_internal_notification_limit' => '%s Internal notifications',
    'global.plan_settings.email_reports_is_enabled' => 'Email reports',
    'global.plan_settings.email_reports_is_enabled_weekly' => 'Weekly email reports',
    'global.plan_settings.email_reports_is_enabled_monthly' => 'Monthly email reports',
    'global.plan_settings.aix' => 'AI Features',
    'global.plan_settings.documents_per_month_limit' => '<strong>%s</strong> AI Documents <span class="small text-muted">/ month</span>',
    'global.plan_settings.words_per_month_limit' => '<strong>%s</strong> AI words <span class="small text-muted">/ month</span>',
    'global.plan_settings.images_per_month_limit' => '<strong>%s</strong> AI images <span class="small text-muted">/ month</span>',
    'global.plan_settings.transcriptions_per_month_limit' => '<strong>%s</strong> AI transcriptions <span class="small text-muted">/ month</span>',
    'global.plan_settings.transcriptions_file_size_limit' => '<strong>%s</strong> audio transcriptions',
    'global.plan_settings.chats_per_month_limit' => '<strong>%s</strong> AI chats <span class="small text-muted">/ month</span>',
    'global.plan_settings.chat_messages_per_chat_limit' => '<strong>%s</strong> AI chats messages <span class="small text-muted">/ chat</span>',


    'pwa_install.header' => 'Install our app 🪄',
    'pwa_install.or' => 'or',
    'pwa_install.subheader.desktop' => 'click on the <code>%s</code> icon in the top right of the address bar.',
    'pwa_install.subheader.android_chrome' => 'tap on the <code>%s</code> menu and then tap the <code>%s Add to Home screen</code> menu item.',
    'pwa_install.subheader.ios' => 'tap on the <code>%s</code> icon and then tap the <code>%s Add to Home Screen</code> menu item.',
    'pwa_install.subheader.ios_safari' => 'click on the <code>File > Add to Dock</code> menu item of the browser.',


    'push_notifications_modal.menu' => 'Push notifications',
    'push_notifications_modal.header' => 'Push notifications',
    'push_notifications_modal.subheader' => 'You can subscribe to our web push notifications if you want to receive helpful content and non-spam promotions from us.',
    'push_notifications_modal.subscribe' => 'Subscribe',
    'push_notifications_modal.unsubscribe' => 'Unsubscribe',
    'push_notifications_modal.denied' => 'You have denied or disabled push notifications. You must enable them again from the browser settings in order to be able to subscribe.',
    'push_notifications_modal.incompatible' => 'Your browser window is incompatible with receiving push notifications.',


    'ad_blocker_detector_modal.header' => 'Ad blocker detected',
    'ad_blocker_detector_modal.subheader' => 'We serve ads so we can keep our website running. Please disable your ad blockers.',
    'ad_blocker_detector_modal.button' => 'I\'ve disabled the ad blocker',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'delete_modal.header' => 'Delete',
    'delete_modal.subheader1' => 'Deleting <strong>%s</strong> cannot be undone.',
    'delete_modal.subheader2' => 'Deleting this cannot be undone.',


    'transfer_modal.header' => 'Transfer ownership',
    'transfer_modal.subheader1' => 'Transfer <strong>%s</strong> to another user account.',
    'transfer_modal.subheader2' => 'Transfer this resource to another user account.',
    'transfer_modal.success_message' => 'The ownership of %1$s has been transferred from %2$s to %3$s',


    'statistics_reset_modal.header' => 'Clear statistics',
    'statistics_reset_modal.subheader' => 'Clear the current selected statistics. This action cannot be undone.',

    'x_reset_modal.header' => 'Reset',
    'x_reset_modal.subheader' => 'Reset the state of the resource and clear all it\'s associated logs or statistics. This action cannot be undone.',


    'bulk_download_modal.header' => 'Download in bulk',
    'bulk_download_modal.subheader' => 'You\'ve selected multiple entries to be downloaded, this may take a while for the ZIP to be generated.',


    'bulk_delete_modal.header' => 'Delete in bulk',
    'bulk_delete_modal.subheader' => 'You\'ve selected multiple entries to be deleted, this may take a while & it action cannot be undone.',
    'bulk_delete_modal.success_message' => 'The bulk deletion process was performed successfully.',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.total_views' => '%s views',


    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',
    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',
    'pages.pages_category.breadcrumb' => 'Pages category',
    'pages.no_data' => 'There are resources yet',
    'pages.no_data_help' => 'We still got some work to do for our resources section',


    'blog.title' => 'Blog',
    'blog.title_search' => 'Search for \'%s\' - Blog',
    'blog.breadcrumb' => 'Blog',
    'blog.menu' => 'Blog',
    'blog.header' => 'Blog',
    'blog.header_search' => 'Blog - Search for \'%s\'',
    'blog.subheader' => 'Discover insights through our curated blog posts.',
    'blog.rss' => 'RSS Feed',
    'blog.categories' => 'Categories',
    'blog.popular' => 'Popular posts',
    'blog.total_views' => '%s views',
    'blog.estimated_reading_time' => '%s read',
    'blog.blog_post.title' => '%s - Blog',
    'blog.blog_posts_category.title' => '%s - Category - Blog',
    'blog.rating' => '%1$s of %2$s ratings',
    'blog.no_data' => 'There are no blog posts yet',
    'blog.no_data_help' => 'We still got some writing to do for our blog post',


    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select the most convenient plan for you.',
    'plan.header_renew' => 'Renew your plan',
    'plan.subheader_renew' => 'Select one plan to renew your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one plan to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.quarterly' => 'Quarterly',
    'plan.custom_plan.biannual' => 'Biannual',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plans.choose' => 'Choose plan',
    'plans.renew' => 'Renew plan',
    'plans.trial' => 'Try for %s days',
    'plans.contact' => 'Contact us',
    'plans.lifetime' => 'Lifetime',

    'plan.why.header' => 'Why us?',
    'plan.why.one.header' => 'Customer service',
    'plan.why.one.subheader' => 'Our support team will help you with any questions you may have regarding our service.',
    'plan.why.two.header' => 'Privacy',
    'plan.why.two.subheader' => 'You control all the data that you bring within your account on our website.',
    'plan.why.three.header' => 'Quality',
    'plan.why.three.subheader' => 'We focus on delivering the best experience to you, as we fully understand how valuable time is.',

    'plan.faq.header' => 'Frequently asked questions',
    'plan.faq.one.question' => 'What forms of payment do you accept?',
    'plan.faq.one.answer' => 'We accept payments via credit cards, PayPal & crypto as well.',
    'plan.faq.two.question' => 'Can I cancel my subscription?',
    'plan.faq.two.answer' => 'Yes, you definitely can cancel your subscription and, you will still have access to all the features that you already paid for until the end of paid date range.',
    'plan.faq.three.question' => 'Will I get an invoice?',
    'plan.faq.three.answer' => 'Yes, an invoice will be automatically generated for you after any payments from your account.',
    'plan.faq.four.question' => 'Can I have a refund?',
    'plan.faq.four.answer' => 'We do offer refunds in case something goes wrong or you change your mind, simply contact us if needed.',


    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',


    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.attention_title' => '✨Checkout ready 🔥',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'You already have the free plan activated.',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires.',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.iyzico' => 'Iyzico',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.mercadopago' => 'MercadoPago',
    'pay.custom_plan.midtrans' => 'Midtrans',
    'pay.custom_plan.flutterwave' => 'Flutterwave',
    'pay.custom_plan.lemonsqueezy' => 'Lemonsqueezy',
    'pay.custom_plan.myfatoorah' => 'Myfatoorah',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly payments',
    'pay.custom_plan.quarterly' => 'Quarterly payments',
    'pay.custom_plan.biannual' => 'Biannual payments',
    'pay.custom_plan.annual' => 'Annual payments',
    'pay.custom_plan.annual_savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'Use discount code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One time payment',
    'pay.custom_plan.recurring_type' => 'Recurring payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.quarterly' => 'Quarterly',
    'pay.custom_plan.summary.quarterly_help' => 'Every 90 days',
    'pay.custom_plan.summary.biannual' => 'Biannual',
    'pay.custom_plan.summary.biannual_help' => 'Every 180 days',
    'pay.custom_plan.summary.annual' => 'Annual',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid.',
    'pay.error_message.code_used' => 'You have already used this code.',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',


    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',


    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade plan',
    'account.plan.renew_plan' => 'Renew or change plan',
    'account.plan.renew' => 'Renew/Upgrade',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Main settings of your account.',
    'account.settings.avatar' => 'Avatar',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',
    'account.settings.is_newsletter_subscribed' => 'Newsletter subscribed',
    'account.settings.is_newsletter_subscribed_help' => 'Receive a few emails per month with updates & discount campaigns we may run. We won\'t spam you.',
    'account.settings.referral_key' => 'Referral key',

    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.county' => 'County',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',
    'account.billing.notes' => 'Additional notes',
    'account.billing.notes_help' => 'Here you can write additional data that you want to have on your invoices.',

    'account.change_password.header' => 'Change password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current password',
    'account.change_password.current_password_help' => 'If you do not know your current password, you mut logout and use the lost password functionality to reset it.',
    'account.change_password.new_password' => 'New password',
    'account.change_password.repeat_password' => 'Repeat password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR Code',
    'account.twofa.qr_help' => 'Open your authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the QR code using your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR Code?',
    'account.twofa.secret_help' => 'Copy the following secret code into your app for a manual setup.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',
    'account.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account.error_message.twofa_check' => 'The token that you entered is not valid.',
    'account.error_message.referral_key_exists' => 'This referral key is already in use.',
    'account.success_message.account_updated' => 'Your account was updated.',
    'account.success_message.password_updated' => 'Your account password was updated.',


    'account_preferences.title' => 'Preferences',
    'account_preferences.menu' => 'Preferences',
    'account_preferences.header' => 'Preferences',
    'account_preferences.subheader' => 'Here you can set different preferences for your account related to the site usage.',
    'account_preferences.success_message' => 'Your account preferences have been updated.',
    'account_preferences.avatar' => 'Avatar',
    'account_preferences.tracking_settings' => 'Tracking settings',
    'account_preferences.excluded_ips' => 'Excluded IPs',
    'account_preferences.excluded_ips_help' => 'Exclude IPs from being tracked. Comma separated values.',
    'account_preferences.default_settings' => 'Default settings',
    'account_preferences.default_results_per_page' => 'Default results per page',
    'account_preferences.default_order_type' => 'Default results order',
    'account_preferences.default_order_by_x' => '%s default order by',
    'account_preferences.white_labeling' => 'White labeling settings',
    'account_preferences.white_label_title' => 'White label title',
    'account_preferences.white_label_logo_light' => 'White label logo light',
    'account_preferences.white_label_logo_dark' => 'White label logo dark',
    'account_preferences.white_label_favicon' => 'White label favicon',
    'account_preferences.aix' => 'AI features',
    'account_preferences.aix.optional_help' => 'Leave empty if you wish to use the system provided API key.',
    'account_preferences.aix.required_help' => 'You are required to add the API key, otherwise the AI related features will not work.',
    'account_preferences.aix.openai_api_key' => 'OpenAI - API Key',
    'account_preferences.aix.openai_api_key_help' => 'You can insert multiple OpenAI API Keys per line and the system will randomly choose one on each request.',
    'account_preferences.error_message.aix.openai_api_key' => 'You must insert your personal OpenAI Key to use this feature. Go to %s.',
    'account_preferences.error_message.aix.aws_api_keys' => 'You must insert your personal AWS API Keys to use this feature. Go to %s.',
    'account_preferences.links_auto_copy_link' => 'Auto copy link after it is created',
    'account_preferences.links_autosave_settings' => 'Auto save links settings every 3 seconds',


    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',
    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account_delete.success_message' => 'Your account was fully deleted. We\'re sorry to see you go.',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.success_message_lifetime' => 'You redeemed the %2$s plan for lifetime.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'domains.breadcrumb' => 'Custom domains',
    'domains.title' => 'Custom domains',
    'domains.menu' => 'Custom domains',
    'domains.header' => 'Custom domains',
    'domains.subheader' => 'Here you can add your own custom domain to use with your biolink pages.',
    'domains.create' => 'Connect domain',
    'domains.domain_id' => 'Domain',

    'domains.table.host' => 'Domain',
    'domains.table.is_enabled_pending' => 'Pending',
    'domains.table.is_enabled_active' => 'Active',

    'domains.help' => 'Your domain or subdomain must have an A record pointing to %1$s or CNAME record pointing to %2$s.',
    'domains.host' => 'Domain or subdomain',
    'domains.custom_index_url' => 'Custom index URL',
    'domains.custom_index_url_help' => 'Redirect to a specific URL when visitors land on the index of the domain.',
    'domains.custom_not_found_url' => 'Custom 404 not found URL',
    'domains.custom_not_found_url_help' => 'Redirect to a specific URL when visitors land on a not found page of the domain.',
    'domains.no_data' => 'There are no custom domains added',
    'domains.no_data_help' => 'Start by linking your first custom domain.',
    'domains.error_message.host_exists' => 'This custom domain already exists.',


    'domain_create.breadcrumb' => 'Connect custom domain',
    'domain_create.title' => 'Connect custom domain',
    'domain_create.menu' => 'Connect custom domain',
    'domain_create.header' => 'Connect custom domain',
    'domain_create.success_message' => 'Your custom domain has been submitted for approval and processing.',


    'domain_update.breadcrumb' => 'Edit custom domain',
    'domain_update.title' => 'Edit custom domain',
    'domain_update.menu' => 'Edit custom domain',
    'domain_update.header' => 'Edit custom domain',
    'domain_update.success_message' => 'Your custom domain update has been submitted for approval and processing.',


    'domain_delete_modal.header' => 'Delete domain',
    'domain_delete_modal.subheader' => 'All data related to the domain will be completely deleted. This action cannot be undone.',


    'account_plan.title' => 'Account Plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => 'Account Plan',
    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',
    'account_plan.plan.lifetime' => 'Plan is for lifetime, it does not expire.',
    'account_plan.cancel.header' => 'Cancel subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',
    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled.',


    'account_payments.title' => 'Account payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account payments',
    'account_payments.subheader' => 'All the payments made on your account.',
    'account_payments.payment_processor' => 'Processor',
    'account_payments.total_amount' => 'Total amount',
    'account_payments.plan_id' => 'Plan',
    'account_payments.invoice' => 'Invoice',
    'account_payments.status_pending' => 'Pending',
    'account_payments.status_approved' => 'Approved',
    'account_payments.no_data' => 'No payments found',
    'account_payments.processor' => 'Processor',
    'account_payments.type_one_time' => 'One time',
    'account_payments.type_recurring' => 'Recurring',
    'account_payments.frequency' => 'Frequency',
    'account_payments.order_by_total_amount' => 'Total amount',


    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',


    'account_logs.logs.no_data' => 'Your account has no recorded logs',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',


    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Do not share your API key with unauthorized people.',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully.',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'My teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.table.members' => 'Members',
    'teams.team' => 'Team',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_members.create' => 'Invite member',
    'team_members.access' => '%s permissions',
    'team_members.access_help' => 'Set what permissions you want to hand out to the user.',
    'team_members.access.read' => 'View',
    'team_members.access.create' => 'Create',
    'team_members.access.update' => 'Update',
    'team_members.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'teams_member.title' => 'Teams\' member',
    'teams_member.menu' => 'Teams\' member',
    'teams_member.breadcrumb' => 'Teams\' member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.referral_key_help' => 'You can add the %s parameter to any link of our website.',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid_paid' => 'Paid',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing.',


    'sso.menu' => 'Go to %s',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'Invoice',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.item' => 'Item',
    'invoice.amount' => 'Amount',
    'invoice.plan' => '%s Plan',
    'invoice.frequency' => '%s access.',
    'invoice.frequency.monthly' => '30 days',
    'invoice.frequency.quarterly' => '90 days',
    'invoice.frequency.biannual' => '180 days',
    'invoice.frequency.annual' => '1 year',
    'invoice.frequency.lifetime' => 'Lifetime',
    'invoice.code' => 'Discount',
    'invoice.code_help' => 'Code used: %s',
    'invoice.total' => 'Total',
    'invoice.paid_via' => 'Paid via %s',


    'maintenance.title' => 'Maintenance mode',
    'maintenance.header' => 'Maintenance mode',
    'maintenance.subheader' => 'We are doing some maintenance work, we\'ll be back soon.',


    'login.menu' => 'Sign in',
    'login.title' => 'Sign in',
    'login.header' => 'Sign in',
    'login.twofa_token' => 'Two-factor token',
    'login.remember_me' => 'Remember me',
    'login.remember_me_help' => 'A browser cookie will be used to remember you for %s days on this browser.',
    'login.login' => 'Login',
    'login.verify' => 'Verify',
    'login.register' => 'Don\'t have an account? %s',
    'login.register_help' => 'Register',
    'login.lost_password' => 'Lost password',
    'login.resend_activation' => 'Resend activation',
    'login.facebook' => 'Sign in with Facebook',
    'login.google' => 'Sign in with Google',
    'login.twitter' => 'Sign in with X',
    'login.discord' => 'Sign in with Discord',
    'login.linkedin' => 'Sign in with LinkedIn',
    'login.microsoft' => 'Sign in with Microsoft',
    'login.info_message.twofa_token' => 'Two-factor authentication is required.',
    'login.info_message.logged_in' => 'Welcome back, %s.',
    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid.',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid.',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned.',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',


    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We\'ve emailed you the password reset link.',


    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We\'ve emailed you the activation link.',


    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password is set.',


    'activate_user.user_activation' => 'Your account has been confirmed and is now active.',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed.',


    'register.title' => 'Sign up',
    'register.menu' => 'Sign up',
    'register.header' => 'Sign up',
    'register.repeat_password' => 'Repeat Password',
    'register.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.is_newsletter_subscribed' => 'I agree receive a few emails per month from the newsletter. You can unsubscribe at any time.',
    'register.register' => 'Register',
    'register.login' => 'Already have an account? %s',
    'register.login_help' => 'Sign in',
    'register.error_message.name_length' => 'Name must be between 1 and 64 characters.',
    'register.error_message.email_exists' => 'This email address is already in use.',
    'register.error_message.email_aliases_not_allowed' => 'Email aliases are not allowed.',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted.',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted.',
    'register.success_message.registration' => 'We\'ve emailed you the activation link.',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here.',


    'dashboard.title' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.links' => 'Total short links',
    'dashboard.file_links' => 'Total file links',
    'dashboard.vcard_links' => 'Total vcard links',
    'dashboard.event_links' => 'Total event links',
    'dashboard.biolinks' => 'Total biolinks',
    'dashboard.domains' => 'Total domains',
    'dashboard.static_links' => 'Total static links',


    'index.breadcrumb' => 'Home',
    'index.menu' => 'Home',
    'index.title' => 'Your all-in-one social tool',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.header' => 'A marketing wizard, all-in-one.',
    'index.subheader.biolink' => '📱 &nbsp; Bio pages',
    'index.subheader.link' => '🔗 &nbsp; Short links',
    'index.subheader.file' => '📃 &nbsp; Transfer files',
    'index.subheader.vcard' => '👤 &nbsp; Share vcards',
    'index.subheader.event' => '📆 &nbsp; Event links',
    'index.subheader.static' => '🧑‍💻 &nbsp; Host HTML',
    'index.subheader.qr_codes' => '🤳 &nbsp; QR codes',
    'index.subheader.tools' => '🛠️ &nbsp; Web tools',
    'index.claim_placeholder' => 'your-custom-url',
    'index.claim' => 'Claim link',
    'index.sign_up' => 'Get Started',
    'index.example' => 'Bio page Demo',
    'index.stars' => 'Loved by %s creators',
    'index.hero_image_alt' => 'Screenshot of biolink page examples',
    'index.biolink_image_alt' => 'Screenshot of the app biolink editing page',
    'index.short_image_alt' => 'Screenshot of the app short URL editing page',
    'index.static_image_alt' => 'Screenshot of the app static sites hosting system',
    'index.qr_image_alt' => 'Screenshot of the app QR code system page',
    'index.analytics_image_alt' => 'Screenshot of the app links analytics system page',

    'index.presentation1.header' => 'Bio link pages',
    'index.presentation1.subheader' => 'Create your own unique & highly customizable bio link page with ease.',
    'index.presentation1.feature1' => 'Custom colors & branding',
    'index.presentation1.feature2' => 'Tons of ready-to-use components',
    'index.presentation1.feature3' => 'SEO settings',
    'index.presentation1.feature4' => 'Password protection, sensitive content warning',
    'index.presentation1.feature5' => 'Countless pre-made templates & themes',

    'index.presentation2.header' => 'Shortened links',
    'index.presentation2.subheader' => 'A state of the art URL shortener service.',
    'index.presentation2.feature1' => 'Scheduling & expiration limits',
    'index.presentation2.feature2' => 'Country, device & language targeting',
    'index.presentation2.feature3' => 'A/B Rotation',
    'index.presentation2.feature4' => 'Password protection, sensitive content warning',
    'index.presentation2.feature5' => 'Deep links support for apps',
    'index.presentation2.feature6' => 'Advanced URL cloaking',
    'index.presentation2.feature7' => 'Query & UTM parameters',

    'index.presentation3.header' => 'QR Codes',
    'index.presentation3.subheader' => 'Fully featured QR code generator system with easy to use templates.',
    'index.presentation3.feature1' => 'Custom colors with gradients',
    'index.presentation3.feature2' => 'Custom logo & background branding',
    'index.presentation3.feature3' => 'Multiple QR shapes to choose from',
    'index.presentation3.feature4' => 'Customizable QR Code Frames',
    'index.presentation3.feature5' => 'Vcard, WiFi, Calendar, Location..etc templates',

    'index.presentation4.header' => 'Built-in analytics',
    'index.presentation4.subheader' => 'Easy to understand, yet detailed analytics for all your links.',
    'index.presentation4.feature1' => 'Continents, Countries & cities',
    'index.presentation4.feature2' => 'Referrers & UTMs',
    'index.presentation4.feature3' => 'Devices & operating systems',
    'index.presentation4.feature4' => 'Browsers, Languages',
    'index.presentation4.feature5' => 'GDPR, CCPA and PECR compliant',

    'index.presentation5.header' => 'Host static sites',
    'index.presentation5.subheader' => 'Upload your website files and we will host them for you.',
    'index.presentation5.feature1' => 'HTML, CSS, JS, Video / Audio files.',
    'index.presentation5.feature2' => 'Analytics, password protected',
    'index.presentation5.feature3' => 'Automated tracking pixels',
    'index.presentation5.feature4' => 'and much more...',

    'index.tools.header' => '%s useful tools',
    'index.tools.subheader' => 'Web utility tools. Fast, reliable and easy to use.',

    'index.documents' => 'We\'ve generated more than <span class=\'text-primary-400\'>%1$s documents</span> with our AI systems.',
    'index.images' => '<span class=\'text-primary-400\'>%1$s images</span> generated by our users with AI.',
    'index.images_subheader' => 'Here\'s our latest generated images.',

    'index.stats.links' => 'Links',
    'index.stats.qr_codes' => 'QR Codes',
    'index.stats.track_links' => 'Tracked pageviews',

    'index.domains.header' => 'Custom domains',
    'index.domains.subheader' => 'Connect your own domain or use our predefined ones.',

    'index.projects.header' => 'Projects',
    'index.projects.subheader' => 'Easiest way to categorize your managed resources.',

    'index.file_links.header' => 'File links',
    'index.file_links.subheader' => 'Generate dynamic, advanced & downloadable links to files.',

    'index.vcard_links.header' => 'Vcard links',
    'index.vcard_links.subheader' => 'Create dynamic digital contact cards, tracked & downloadable.',

    'index.event_links.header' => 'Event links',
    'index.event_links.subheader' => 'Dynamically create downloadable & tracked calendar files.',

    'index.splash_pages.header' => 'Splash pages',
    'index.splash_pages.subheader' => 'Use custom made intermediary pages with countdowns for your links.',

    'index.pixels.header' => 'Tracking pixels',
    'index.pixels.subheader' => 'All the links easily integrate with any of the following pixel providers.',

    'index.shortener_app_linking.header' => 'URLs that open apps automatically',
    'index.shortener_app_linking.subheader' => 'Short links that automatically detect the used app and open it on mobile.',

    'index.pricing.header' => 'Simple, transparent pricing.',
    'index.pricing.subheader' => 'Choose the plan that is right for you and your budget.',

    'index.testimonials.header' => 'Here\'s what people are saying',
    'index.testimonials.one.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.Ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.one.name' => 'Andrea',
    'index.testimonials.one.attribute' => 'Writer Magazine',
    'index.testimonials.two.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent finibus vestibulum porta. Sed id eros quam. Nunc at nisi vel arcu placerat gravida.',
    'index.testimonials.two.name' => 'George',
    'index.testimonials.two.attribute' => 'Lorem Ipsum Founder',
    'index.testimonials.three.text' => 'Praesent finibus vestibulum porta. Sed id eros quam. Proin lacinia ipsum porttitor, sollicitudin est in, ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.three.name' => 'Calvin',
    'index.testimonials.three.attribute' => 'SAAS Lorem Owner',

    'index.faq.header' => '%1$sAnswers%2$s for your common %1$squestions%2$s',
    'index.faq.one.question' => 'How do you edit this?',
    'index.faq.one.answer' => 'All the FAQ section can be edited from the admin panel - languages section.',
    'index.faq.two.question' => 'Lorem ipsum dolor sit amet',
    'index.faq.two.answer' => 'Lorem ipsum dolor sit amet, vim eu quem nonumes omittam. Mutat facete patrioque et est, nusquam abhorreant definiebas te sit, albucius urbanitas pro ad. Ne nemore officiis sed. Cu mundi docendi qui, nam nonumes maluisset constituto an, vix ea solum accusamus consequuntur.',
    'index.faq.three.question' => 'Virtute feugiat ocurreret ad cum',
    'index.faq.three.answer' => 'Virtute feugiat ocurreret ad cum, pro in posse ullum adversarium, te qui stet graece antiopam. Amet omnesque indoctum ut mel, ea eam sonet saperet nostrum. Te modus delectus mel, pri populo definitionem ne, an eam hinc labitur inciderint. Novum vivendum gloriatur ex nec, ad vocibus eleifend deterruisset pro, mutat voluptaria repudiandae eum ea. Ipsum soluta cotidieque sea ut, aliquando scripserit no has, iisque impetus erroribus pro ad. Case labitur scaevola vis ut, clita meliore te eos.',
    'index.faq.four.question' => 'Mel iusto putant feugiat et',
    'index.faq.four.answer' => 'Mel iusto putant feugiat et, qui alii virtute eu. Diceret corrumpit mei an. Ius ei congue iudico, ex quo delectus indoctum. Mnesarchum reprehendunt pro ex, ea vix amet maluisset, in autem omnes consectetuer eum.',

    'index.cta.header' => 'Get started',
    'index.cta.subheader' => 'Start using the swiss army knife for the marketers.',
    'index.cta.register' => 'Sign up',

    'index.blog.header' => 'Latest %1$sblog%2$s posts',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',


    'api_documentation.menu' => 'API Documentation',
    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.title_dynamic' => '%s - API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',
    'api_documentation.array' => 'Array',
    'api_documentation.read_all' => 'Retrieve all',
    'api_documentation.read' => 'Retrieve one',
    'api_documentation.create' => 'Create',
    'api_documentation.update' => 'Update',
    'api_documentation.delete' => 'Delete',
    'api_documentation.allowed_values' => 'Allowed values: %s',
    'api_documentation.available_when' => 'Available when: %s',
    'api_documentation.timezone_info' => 'All API endpoint results work with the <strong>%s timezone</strong> unless specified otherwise.',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',

    'api_documentation.user' => 'User',

    'api_documentation.notification_handlers' => 'Notification handlers',
    'api_documentation.notifications_handlers_ids' => 'Notification handler ids',

    'api_documentation.links' => 'Links',
    'api_documentation.links.url' => 'The URL alias of the generated link. Leave empty for a randomly generated one.',
    'api_documentation.links.location_url' => 'The URL of the destination.',

    'api_documentation.statistics' => 'Links statistics',
    'api_documentation.statistics.start_date' => 'Start date in <code>Y-m-d</code> format.',
    'api_documentation.statistics.end_date' => 'End date in <code>Y-m-d</code> format.',

    'api_documentation.team_members' => 'Team members',
    'api_documentation.teams_member' => 'Teams\' member',


    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us via email.',
    'contact.email' => 'Email address',
    'contact.name' => 'Full name',
    'contact.subject' => 'Subject',
    'contact.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',


    'internal_notifications.breadcrumb' => 'Notifications',
    'internal_notifications.title' => 'Notifications',
    'internal_notifications.menu' => 'Notifications',
    'internal_notifications.header' => 'Notifications',
    'internal_notifications.subheader' => 'All your recent account related notifications.',
    'internal_notifications.no_data' => 'No notifications available',


    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => '%s commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',


    'not_found.title' => 'Not found',
    'not_found.header' => 'Page not found',
    'not_found.subheader' => 'Sorry, we couldn\'t find the page you\'re looking for.',
    'not_found.button' => 'Go back home',


    'directory.breadcrumb' => 'Directory',
    'directory.title' => 'Directory',
    'directory.menu' => 'Directory',
    'directory.header' => 'Explore our bio pages community',
    'directory.subheader' => 'Discover and meet creative people that our using our platform.',


    'biolinks_templates.title' => 'Biolinks templates',
    'biolinks_templates.menu' => 'Biolinks templates',
    'biolinks_templates.header' => 'Biolinks templates',
    'biolinks_templates.subheader' => 'Start your new biolink page with the help of pre-built templates.',
    'biolinks_templates.preview' => 'Preview template',
    'biolinks_templates.choose' => 'Choose template',


    'biolinks_blocks.title' => 'Biolinks blocks',


    'links.breadcrumb' => 'Links',
    'links.title' => 'Links',
    'links.menu.biolink' => 'Biolink pages',
    'links.menu.link' => 'Shortened links',
    'links.menu.file' => 'File links',
    'links.menu.vcard' => 'Vcard links',
    'links.menu.event' => 'Event links',
    'links.menu.static' => 'Static sites',
    'links.header' => 'Links',
    'links.subheader' => 'Create & manage all your custom links.',
    'links.create' => 'Create link',
    'links.create_biolink_block' => 'Add block',
    'links.total' => 'Total links',
    'links.clicks' => 'Total pageviews',
    'links.is_enabled_tooltip' => 'Change status',
    'links.no_data' => 'No links created yet',
    'links.filters.url' => 'Short URL',
    'links.filters.location_url' => 'Location URL',
    'links.filters.order_by_clicks' => 'Pageviews',
    'links.auto_copy_link.success' => 'Link has been copied to your clipboard.',
    'links.auto_copy_link.error' => 'Link could not be copied to your clipboard.',

    'link_create.breadcrumb' => 'Create link',
    'link_create.title' => 'Create link',
    'link_create.menu' => 'Bulk create links',
    'link_create.header' => 'Create a new link',


    'link_delete_modal.header' => 'Delete link',
    'link_delete_modal.subheader' => 'All data related to the link will be completely deleted. This action cannot be undone.',
    'link_delete_modal.success_message' => 'Link deletion was performed successfully.',


    'data.title' => 'Data',
    'data.menu' => 'Data',
    'data.breadcrumb' => 'Data',
    'data.header' => 'Data',
    'data.subheader' => 'All the captured data from your biolink blocks.',
    'data.link' => 'Data',
    'data.biolink' => 'View biolink',
    'data.no_data' => 'No existing data',


    'guests_payments.title' => 'Guests payments',
    'guests_payments.menu' => 'Guests payments',
    'guests_payments.link' => 'Payments',
    'guests_payments.breadcrumb' => 'Guests payments',
    'guests_payments.header' => 'Guests payments',
    'guests_payments.subheader' => 'All your guest payment from all your biolink payment blocks.',
    'guests_payments.biolink' => 'View biolink',
    'guests_payments.no_data' => 'There are no payments made yet',
    'guests_payments.processor' => 'Processor',
    'guests_payments.total_amount' => 'Total amount',
    'guests_payments.simple_notification' => 'You sold \'%1$s\' for %2$s %3$s.%4$sView details: %5$s 🔗.',
    'guests_payments.push_notification.title' => 'You sold \'%1$s\' for %2$s %3$s',
    'guests_payments.push_notification.description' => 'From the \'%1$s\' link',
    'guests_payments.free' => 'Free',
    'guests_payments.biolink_block' => 'Block',

    'guests_payments_statistics.title' => 'Guests payments statistics',
    'guests_payments_statistics.menu' => 'Guests payments statistics',
    'guests_payments_statistics.link' => 'Payments statistics',
    'guests_payments_statistics.breadcrumb' => 'Guests payments statistics',
    'guests_payments_statistics.header' => '%s payments statistics',
    'guests_payments_statistics.no_data' => 'There are no payments',
    'guests_payments_statistics.payments_label' => 'Payments',
    'guests_payments_statistics.total_amount_label' => 'Total amount',


    'payment_processors.title' => 'Payment processors',
    'payment_processors.menu' => 'Payment processors',
    'payment_processors.breadcrumb' => 'Payment processors',
    'payment_processors.header' => 'Payment processors',
    'payment_processors.subheader' => 'All your payment processors configurations for your biolink payment blocks.',
    'payment_processors.payment_processors_ids' => 'Payment processors',
    'payment_processors.create' => 'Add payment processor',
    'payment_processors.no_data' => 'No configured payment processors',
    'payment_processors.info' => 'You can fully configure the integration after the creation.',
    'payment_processors.processor' => 'Processor',
    'payment_processors.instructions' => 'Instructions',

    'payment_processors.paypal.mode' => 'Mode',
    'payment_processors.paypal.mode_sandbox' => 'Sandbox',
    'payment_processors.paypal.mode_live' => 'Live',
    'payment_processors.paypal.client_id' => 'Client ID',
    'payment_processors.paypal.secret' => 'Secret',
    'payment_processors.paypal.instructions_1' => 'Go to the <a href="https://developer.paypal.com/" target="_blank">PayPal Developer Console</a> and log into your account.',
    'payment_processors.paypal.instructions_2' => 'Go to REST API apps section and click the <strong>Create App button</strong>.',
    'payment_processors.paypal.instructions_3' => 'Add your own details for the new app and create it.',
    'payment_processors.paypal.instructions_4' => 'Switch to Live by clicking the button near your new App\'s Name.',
    'payment_processors.paypal.instructions_5' => 'Copy the <strong>Client ID</strong> and <strong>Secret</strong> and paste them here accordingly.',
    'payment_processors.paypal.instructions_6' => 'Scroll down to the Webhooks section, and click on the <strong>Add Webhook</strong> button.',
    'payment_processors.paypal.instructions_7' => 'In the <strong>Webhook URL</strong> field, add the following: <code>%s</code>',
    'payment_processors.paypal.instructions_8' => 'In the <strong>Event Types</strong> field, check the <strong>Payment sale completed</strong> event, and save the webhook.',

    'payment_processors.stripe.publishable_key' => 'Publishable Key',
    'payment_processors.stripe.secret_key' => 'Secret Key',
    'payment_processors.stripe.webhook_secret' => 'Webhook Secret',
    'payment_processors.stripe.instructions_1' => 'Go to the <a href="https://dashboard.stripe.com/" target="_blank">Stripe Dashboard</a> and log into your account.',
    'payment_processors.stripe.instructions_2' => 'Go to the <a href="https://dashboard.stripe.com/account/apikeys" target="_blank">Stripe API Keys</a> page.',
    'payment_processors.stripe.instructions_3' => 'Make sure your API keys are set to Live Mode so that you can accept real payments.',
    'payment_processors.stripe.instructions_4' => 'Copy the <strong>Publishable Key</strong> and <strong>Secret Key</strong> and paste them here accordingly.',
    'payment_processors.stripe.instructions_5' => 'Go to the <strong>Developers</strong> page, then go to the <strong>Webhooks</strong> page',
    'payment_processors.stripe.instructions_6' => 'Click on the <strong>Add endpoint</strong> button.',
    'payment_processors.stripe.instructions_7' => 'In the <strong>Endpoint URL</strong> field, add the following: <code>%s</code>',
    'payment_processors.stripe.instructions_8' => 'In the <strong>Events</strong> section, check the <strong>checkout.session.completed</strong> event, and save the webhook.',
    'payment_processors.stripe.instructions_9' => 'Now make sure to reveal the <strong>Signing secret</strong>, copy and paste it here accordingly.',

    'payment_processors.crypto_com.publishable_key' => 'Publishable Key',
    'payment_processors.crypto_com.secret_key' => 'Secret Key',
    'payment_processors.crypto_com.webhook_secret' => 'Webhook Secret',
    'payment_processors.crypto_com.instructions_1' => 'Go to the <a href="https://merchant.crypto.com/" target="_blank">Crypto.com Merchant</a> and log into your account.',
    'payment_processors.crypto_com.instructions_2' => 'Go to the <a href="https://merchant.crypto.com/integration/api_keys" target="_blank">Developers</a> page.',
    'payment_processors.crypto_com.instructions_3' => 'Copy the <strong>Publishable key</strong> and <strong>Secret Key</strong> and paste them here accordingly.',
    'payment_processors.crypto_com.instructions_4' => 'Go to the <strong>Webhooks</strong> tab and click on the <strong>Add webhook</strong> button.',
    'payment_processors.crypto_com.instructions_5' => 'In the field, add the following: <code>%s</code>',
    'payment_processors.crypto_com.instructions_6' => 'Copy the <strong>Signature secret</strong> key after adding the webhook, and paste it here accordingly.',

    'payment_processors.razorpay.key_id' => 'Key Id',
    'payment_processors.razorpay.key_secret' => 'Key Secret',
    'payment_processors.razorpay.webhook_secret' => 'Webhook Secret',
    'payment_processors.razorpay.instructions_1' => 'Go to the <a href="https://razorpay.com/" target="_blank">Razorpay</a> and log into your account.',
    'payment_processors.razorpay.instructions_2' => 'Go to the <strong>Settings</strong> page -> <strong>API Keys</strong> tab on Razorpay & generate your API keys.',
    'payment_processors.razorpay.instructions_3' => 'Copy the keys and paste them here accordingly.',
    'payment_processors.razorpay.instructions_4' => 'Go to the <strong>Settings</strong> page -> <strong>Webhooks</strong> tab on Razorpay & Add a new webhook.',
    'payment_processors.razorpay.instructions_5' => 'In the field, add the following: <code>%s</code>',
    'payment_processors.razorpay.instructions_6' => 'Add a new Secret (like a password), check the <code>payment_link.paid</code> option & save the webhook.',
    'payment_processors.razorpay.instructions_7' => 'Copy the <strong>Webhook secret</strong> key after adding the webhook, and paste it here accordingly.',

    'payment_processors.paystack.public_key' => 'Public Key',
    'payment_processors.paystack.secret_key' => 'Secret Key',
    'payment_processors.paystack.instructions_1' => 'Go to the <a href="https://paystack.com" target="_blank">Paystack page</a> and log into your account.',
    'payment_processors.paystack.instructions_2' => 'Go to the <strong>Settings</strong> page -> <strong>API Keys & Webhooks</strong> tab on Paystack.',
    'payment_processors.paystack.instructions_3' => 'Copy the keys and paste them here accordingly.',
    'payment_processors.paystack.instructions_4' => 'Add the following <code>%s</code> in the <strong>Webhook URL</strong> field.',

    'payment_processors.mollie.api_key' => 'API Key',
    'payment_processors.mollie.instructions_1' => 'Go to <a href="https://my.mollie.com/dashboard">Mollie Dashboard</a> and Login to your account..',
    'payment_processors.mollie.instructions_2' => 'Go to Developers -> API Keys page.',
    'payment_processors.mollie.instructions_3' => 'Copy the API key and paste them here accordingly.',


    'payment_processor_create.breadcrumb' => 'Add payment processor',
    'payment_processor_create.title' => 'Add payment processor',
    'payment_processor_create.header' => 'Add payment processor',


    'payment_processor_update.breadcrumb' => 'Edit payment processor',
    'payment_processor_update.title' => 'Edit payment processor',
    'payment_processor_update.header' => 'Edit payment processor',


    'projects.title' => 'Projects',
    'projects.menu' => 'Projects',
    'projects.breadcrumb' => 'Projects',
    'projects.header' => 'Projects',
    'projects.subheader' => 'The easiest way to categorize your resources.',
    'projects.create' => 'Create project',
    'projects.project_id' => 'Project',
    'projects.project_id_help' => 'A project will help you categorize your resources.',
    'projects.color' => 'Color',
    'projects.color_help' => 'The color is used to help differentiate projects.',
    'projects.no_data' => 'There are no projects for now',
    'projects.no_data_help' => 'Start by creating your first project.',


    'project_create.breadcrumb' => 'Create a new project',
    'project_create.title' => 'Create a new project',
    'project_create.header' => 'Create a new project',


    'project_update.breadcrumb' => 'Edit project',
    'project_update.title' => 'Edit project',
    'project_update.header' => 'Edit project',


    'splash_pages.title' => 'Splash pages',
    'splash_pages.menu' => 'Splash pages',
    'splash_pages.breadcrumb' => 'Splash pages',
    'splash_pages.header' => 'Splash pages',
    'splash_pages.subheader' => 'Create custom pages with a countdown timer to show ads, text or your own branding before people can go to their final link.',
    'splash_pages.create' => 'Create splash page',
    'splash_pages.splash_page_id' => 'Splash page',
    'splash_pages.advanced' => 'Advanced',
    'splash_pages.logo' => 'Logo',
    'splash_pages.favicon' => 'Favicon',
    'splash_pages.opengraph' => 'Opengraph image',
    'splash_pages.secondary_button_name' => 'Secondary button name',
    'splash_pages.secondary_button_url' => 'Secondary button URL',
    'splash_pages.link_unlock_seconds' => 'Countdown timer',
    'splash_pages.link_unlock_seconds_help' => 'How much it takes for the final link to unlock.',
    'splash_pages.auto_redirect' => 'Auto redirect',
    'splash_pages.auto_redirect_help' => 'Auto redirect to final link after the countdown timer ends.',
    'splash_pages.ads_header' => 'Ads header',
    'splash_pages.ads_footer' => 'Ads footer',
    'splash_pages.no_data' => 'No existing splash pages',


    'splash_page_create.breadcrumb' => 'Create a new splash page',
    'splash_page_create.title' => 'Create a new splash page',
    'splash_page_create.header' => 'Create a new splash page',


    'splash_page_update.breadcrumb' => 'Edit splash page',
    'splash_page_update.title' => 'Edit splash page',
    'splash_page_update.header' => 'Edit splash page',


    'pixels.title' => 'Pixels',
    'pixels.menu' => 'Pixels',
    'pixels.breadcrumb' => 'Pixels',
    'pixels.header' => 'Pixels',
    'pixels.subheader' => 'Tracking pixels collect visitor data and send it to pixel tracking websites, aiding in analytics and retargeting through conversion tracking.',
    'pixels.create' => 'Create pixel',
    'pixels.pixel' => 'Pixel ID',
    'pixels.pixel_help' => 'Enter the pixel id from this specific pixel type you chose.',
    'pixels.no_data' => 'There are no pixels for now',
    'pixels.no_data_help' => 'Start by creating your first pixel.',


    'pixel_create.breadcrumb' => 'Create a new pixel',
    'pixel_create.title' => 'Create a new pixel',
    'pixel_create.header' => 'Create a new pixel',


    'pixel_update.breadcrumb' => 'Edit pixel',
    'pixel_update.title' => 'Edit pixel',
    'pixel_update.header' => 'Edit pixel',


    'qr_codes.title' => 'QR codes',
    'qr_codes.menu' => 'QR codes',
    'qr_codes.breadcrumb' => 'QR codes',
    'qr_codes.header' => 'QR codes',
    'qr_codes.subheader' => 'Easily create customizable QR codes & remember them for later use.',
    'qr_codes.create' => 'Create QR',
    'qr_codes.print' => 'Print',
    'qr_codes.qr_code' => 'QR code',
    'qr_codes.is_readable' => 'QR Code seems to be readable.',
    'qr_codes.is_not_readable' => 'QR Code might not be readable. Adjust your QR code settings or content.',
    'qr_codes.info' => 'Test out the QR code with a scanner before using it in production.',
    'qr_codes.embedded_data' => 'Embedded data',

    'qr_codes.type.text' => 'Text',
    'qr_codes.type.text_description' => 'Simple and clear text embedded into a QR code.',
    'qr_codes.type.url' => 'URL',
    'qr_codes.type.url_description' => 'Send someone to a link.',
    'qr_codes.type.phone' => 'Phone',
    'qr_codes.type.phone_description' => 'Get calls from people by scanning the QR code.',
    'qr_codes.type.sms' => 'SMS',
    'qr_codes.type.sms_description' => 'Get custom SMS messages from people by scanning the QR code.',
    'qr_codes.type.email' => 'Email',
    'qr_codes.type.email_description' => 'Get custom Emails from people by scanning the QR code.',
    'qr_codes.type.whatsapp' => 'Whatsapp',
    'qr_codes.type.whatsapp_description' => 'Get custom Whatsapp messages from people by scanning the QR code.',
    'qr_codes.type.facetime' => 'Facetime',
    'qr_codes.type.facetime_description' => 'Get Facetime calls from people by scanning the QR code.',
    'qr_codes.type.location' => 'Location',
    'qr_codes.type.location_description' => 'Embed location coordinates for people to get directions more easily.',
    'qr_codes.type.wifi' => 'WiFi',
    'qr_codes.type.wifi_description' => 'Create WiFi QR codes and let people connect to your WiFi more easily.',
    'qr_codes.type.event' => 'Event',
    'qr_codes.type.event_description' => 'Generate a custom life calendar event and embed it into a QR code.',
    'qr_codes.type.crypto' => 'Crypto',
    'qr_codes.type.crypto_description' => 'Get paid in crypto from people by scanning the QR code.',
    'qr_codes.type.vcard' => 'Vcard',
    'qr_codes.type.vcard_description' => 'Embed all your contact data into a digital business card.',
    'qr_codes.type.paypal' => 'PayPal',
    'qr_codes.type.paypal_description' => 'Create PayPal direct payment links.',
    'qr_codes.type.upi' => 'UPI Payment',
    'qr_codes.type.upi_description' => 'Create UPI direct payment QR codes.',
    'qr_codes.type.epc' => 'EPC Payment',
    'qr_codes.type.epc_description' => 'Create EPC (European Payments Council) direct payment QR codes.',
    'qr_codes.type.pix' => 'PIX Payment',
    'qr_codes.type.pix_description' => 'Create PIX (Brazil) direct payment QR codes.',

    'qr_codes.input.type' => 'QR Type',
    'qr_codes.input.text' => 'Text content',
    'qr_codes.input.url_dynamic' => 'Dynamic QR code',
    'qr_codes.input.url_dynamic_help' => 'Enabling this will create a QR code that points to an internal short link, which will redirect to any specified link, dynamically.',
    'qr_codes.input.url_dynamic_help2' => 'Once you generate the QR code, make sure to never update the short link alias, or else the QR will stop working.',
    'qr_codes.input.link_id' => 'URL',
    'qr_codes.input.phone' => 'Phone number',
    'qr_codes.input.sms' => 'Phone number',
    'qr_codes.input.sms_body' => 'Prefilled message',
    'qr_codes.input.email' => 'Email address',
    'qr_codes.input.email_subject' => 'Prefilled subject',
    'qr_codes.input.email_body' => 'Prefilled message',
    'qr_codes.input.whatsapp' => 'Phone number',
    'qr_codes.input.whatsapp_body' => 'Prefilled message',
    'qr_codes.input.facetime' => 'Phone number or email address',
    'qr_codes.input.location_latitude' => 'Latitude',
    'qr_codes.input.location_longitude' => 'Longitude',
    'qr_codes.input.wifi_ssid' => 'WiFi name (SSID)',
    'qr_codes.input.wifi_encryption' => 'Encryption',
    'qr_codes.input.wifi_encryption_nopass' => 'No encryption',
    'qr_codes.input.wifi_password' => 'Password',
    'qr_codes.input.wifi_is_hidden' => 'WiFi is hidden',
    'qr_codes.input.event' => 'Event name',
    'qr_codes.input.event_location' => 'Location',
    'qr_codes.input.event_start_datetime' => 'Event starts on',
    'qr_codes.input.event_end_datetime' => 'Event ends on',
    'qr_codes.input.event_first_alert_datetime' => 'First alert reminder',
    'qr_codes.input.event_second_alert_datetime' => 'Second alert reminder',
    'qr_codes.input.event_timezone' => 'Timezone',
    'qr_codes.input.event_url' => 'Event URL',
    'qr_codes.input.event_note' => 'Notes',
    'qr_codes.input.crypto' => 'Crypto',
    'qr_codes.input.crypto_coin' => 'Coin',
    'qr_codes.input.crypto_address' => 'Address',
    'qr_codes.input.crypto_amount' => 'Amount',
    'qr_codes.input.vcard_first_name' => 'First name',
    'qr_codes.input.vcard_last_name' => 'Last name',
    'qr_codes.input.vcard_email' => 'Email',
    'qr_codes.input.vcard_url' => 'Website URL',
    'qr_codes.input.vcard_company' => 'Company',
    'qr_codes.input.vcard_job_title' => 'Job title',
    'qr_codes.input.vcard_birthday' => 'Birthday',
    'qr_codes.input.vcard_street' => 'Street address',
    'qr_codes.input.vcard_zip' => 'ZIP',
    'qr_codes.input.vcard_region' => 'Region',
    'qr_codes.input.vcard_note' => 'Note',
    'qr_codes.input.vcard_phone_numbers' => 'Phone numbers',
    'qr_codes.input.vcard_phone_number_value' => 'Phone number',
    'qr_codes.input.vcard_phone_number_label' => 'Label',
    'qr_codes.input.vcard_phone_number_label_help' => 'Leave empty to use the default phone generated label. Custom labels do not work on Android devices.',
    'qr_codes.input.vcard_socials' => 'Socials',
    'qr_codes.input.vcard_social_label' => 'Label',
    'qr_codes.input.vcard_social_value' => 'URL',
    'qr_codes.input.paypal_type' => 'Type',
    'qr_codes.input.paypal_type_buy_now' => 'Buy now',
    'qr_codes.input.paypal_type_add_to_cart' => 'Add to cart',
    'qr_codes.input.paypal_type_donation' => 'Donation',
    'qr_codes.input.paypal_email' => 'PayPal email',
    'qr_codes.input.paypal_title' => 'Product title',
    'qr_codes.input.paypal_currency' => 'Currency code',
    'qr_codes.input.paypal_price' => 'Price',
    'qr_codes.input.paypal_thank_you_url' => 'Thank you URL',
    'qr_codes.input.paypal_cancel_url' => 'Cancel URL',
    'qr_codes.input.upi_payee_id' => 'UPI ID / VPA',
    'qr_codes.input.upi_payee_name' => 'Payee name',
    'qr_codes.input.upi_amount' => 'Amount',
    'qr_codes.input.upi_currency' => 'Currency code',
    'qr_codes.input.upi_transaction_id' => 'Transaction ID',
    'qr_codes.input.upi_transaction_reference' => 'Transaction reference',
    'qr_codes.input.upi_transaction_note' => 'Transaction note',
    'qr_codes.input.upi_thank_you_url' => 'Thank you URL',
    'qr_codes.input.epc_payee_name' => 'Payee name',
    'qr_codes.input.epc_iban' => 'IBAN',
    'qr_codes.input.epc_bic' => 'BIC',
    'qr_codes.input.epc_amount' => 'Amount',
    'qr_codes.input.epc_currency' => 'Currency code',
    'qr_codes.input.epc_remittance_reference' => 'Remittance reference',
    'qr_codes.input.epc_information' => 'Information',
    'qr_codes.input.epc_remittance_text' => 'Remittance text',
    'qr_codes.input.pix_payee_key' => 'Pix key',
    'qr_codes.input.pix_payee_key_help' => 'Your CPF, CNPJ, Email, Phone or a Random key.',
    'qr_codes.input.pix_payee_name' => 'Payee name',
    'qr_codes.input.pix_city' => 'City',
    'qr_codes.input.pix_description' => 'Description',
    'qr_codes.input.pix_transaction_id' => 'Transaction ID',
    'qr_codes.input.pix_amount' => 'Amount',
    'qr_codes.input.pix_currency' => 'Currency code',

    'qr_codes.input.colors' => 'Colors',
    'qr_codes.input.style' => 'Style',
    'qr_codes.input.style.square' => 'Square',
    'qr_codes.input.style.dot' => 'Dot',
    'qr_codes.input.style.circle' => 'Circle',
    'qr_codes.input.style.round' => 'Rounded blob',
    'qr_codes.input.style.rounded' => 'Rounded',
    'qr_codes.input.style.heart' => 'Heart',
    'qr_codes.input.style.diamond' => 'Diamond',
    'qr_codes.input.style.star' => 'Star',
    'qr_codes.input.style.triangle' => 'Triangle',
    'qr_codes.input.style.hexagon' => 'Hexagon',
    'qr_codes.input.style.spaced_square' => 'Hexagon',
    'qr_codes.input.style.randomized_square' => 'Randomized square',
    'qr_codes.input.style.octagon' => 'Octagon',
    'qr_codes.input.style.shield' => 'Shield',
    'qr_codes.input.style.thick_star' => 'Thick star',
    'qr_codes.input.style.elastic_square' => 'Elastic square',
    'qr_codes.input.style.cross_x' => 'Cross X',
    'qr_codes.input.style.curvy_x' => 'Curvy X',
    'qr_codes.input.style.bold_x' => 'Bold X',
    'qr_codes.input.style.ninja' => 'Ninja',
    'qr_codes.input.style.sun' => 'Sun',
    'qr_codes.input.style.shine' => 'Shine',
    'qr_codes.input.style.bold_plus' => 'Bold plus',
    'qr_codes.input.style.inverted_squircle' => 'Inverted squircle',
    'qr_codes.input.style.teardrop' => 'Teardrop',
    'qr_codes.input.style.rounded_cross' => 'Rounded cross',
    'qr_codes.input.style.corner_cut' => 'Corner cut',
    'qr_codes.input.style.leaf' => 'Leaf',
    'qr_codes.input.style.flower' => 'Flower',
    'qr_codes.input.inner_eye_style' => 'Inner eye style',
    'qr_codes.input.outer_eye_style' => 'Outer eye style',
    'qr_codes.input.foreground_type' => 'Foreground type',
    'qr_codes.input.foreground_type_color' => 'Color',
    'qr_codes.input.foreground_type_gradient' => 'Gradient',
    'qr_codes.input.foreground_color' => 'Foreground color',
    'qr_codes.input.foreground_gradient_style' => 'Foreground gradient style',
    'qr_codes.input.foreground_gradient_style_vertical' => 'Vertical',
    'qr_codes.input.foreground_gradient_style_horizontal' => 'Horizontal',
    'qr_codes.input.foreground_gradient_style_diagonal' => 'Diagonal',
    'qr_codes.input.foreground_gradient_style_inverse_diagonal' => 'Inverse diagonal',
    'qr_codes.input.foreground_gradient_style_radial' => 'Radial',
    'qr_codes.input.foreground_gradient_one' => 'Foreground first color',
    'qr_codes.input.foreground_gradient_two' => 'Foreground second color',
    'qr_codes.input.background_color' => 'Background color',
    'qr_codes.input.background_color_transparency' => 'Background color transparency',
    'qr_codes.input.custom_eyes_color' => 'Custom eyes color',
    'qr_codes.input.eyes_inner_color' => 'Eyes inner color',
    'qr_codes.input.eyes_outer_color' => 'Eyes outer color',
    'qr_codes.input.branding' => 'Branding',
    'qr_codes.input.qr_code_logo' => 'Logo',
    'qr_codes.input.qr_code_logo_size' => 'Logo size',
    'qr_codes.input.qr_code_background' => 'Background image',
    'qr_codes.input.qr_code_background_help' => 'Only use the recommended 1:1 ratio for the image to look good.',
    'qr_codes.input.qr_code_background_transparency' => 'Background image transparency',
    'qr_codes.input.qr_code_foreground' => 'Foreground image',
    'qr_codes.input.qr_code_foreground_help' => 'Only use the recommended 1:1 ratio for the image to look good.',
    'qr_codes.input.qr_code_foreground_transparency' => 'Foreground image transparency',
    'qr_codes.input.options' => 'Options',
    'qr_codes.input.size' => 'Size',
    'qr_codes.input.margin' => 'Margin size',
    'qr_codes.input.ecc' => 'Error correction capability',
    'qr_codes.input.ecc_l' => 'L - low (7%)',
    'qr_codes.input.ecc_m' => 'M - medium (15%)',
    'qr_codes.input.ecc_q' => 'Q - high (25%)',
    'qr_codes.input.ecc_h' => 'H - best (30%)',
    'qr_codes.input.encoding' => 'Encoding',
    'qr_codes.input.frame' => 'Frame',
    'qr_codes.input.frame_text' => 'Frame text',
    'qr_codes.input.frame_text_size' => 'Frame text size',
    'qr_codes.input.frame_text_font' => 'Frame text font',
    'qr_codes.input.frame_custom_colors' => 'Apply custom colors',
    'qr_codes.input.frame_text_color' => 'Frame text color',
    'qr_codes.input.frame_color' => 'Frame color',
    'qr_codes.input.is_bulk' => 'Bulk generation',
    'qr_codes.input.is_bulk_help' => 'One per line. Maximum %s lines at a time.',

    'qr_codes.no_data' => 'No existing QR codes',
    'qr_codes.no_data_help' => 'Start by creating your QR code.',
    'qr_codes.empty_error_message' => 'Make sure to fill the QR content related fields.',


    'qr_code_create.breadcrumb' => 'Create QR code',
    'qr_code_create.title' => 'Create QR code',
    'qr_code_create.header' => 'Create QR code',


    'qr_code_update.breadcrumb' => 'Edit QR code',
    'qr_code_update.title' => 'Edit QR code',
    'qr_code_update.header' => 'Edit QR code',


    'biolink_block_delete.header' => 'Delete block',
    'biolink_block_delete.subheader' => 'All data related to the biolink block will be completely deleted. This action cannot be undone.',
    'biolink_block_delete.success_message' => 'Biolink block deletion was performed successfully.',


    'biolink_block.title' => 'Biolink block',


    'links_statistics.title' => 'Links statistics',
    'links_statistics.menu' => 'Links statistics',
    'links_statistics.breadcrumb' => 'Links statistics',
    'links_statistics.header' => 'Links statistics',


    'link.title' => 'Link - %s',
    'link.link' => 'Link',
    'link.breadcrumb.link' => 'Link',
    'link.breadcrumb.biolink' => 'Biolink',
    'link.breadcrumb.biolink_block' => 'Biolink block',
    'link.breadcrumb.file' => 'File link',
    'link.breadcrumb.vcard' => 'Vcard link',
    'link.breadcrumb.event' => 'Event link',
    'link.breadcrumb.static' => 'Static site',

    'link.header.header' => '%s',
    'link.header.subheader' => 'Your link is %s',
    'link.header.settings_tab' => 'Settings',
    'link.header.blocks_tab' => 'Blocks',
    'link.create_info' => 'All customization options available after creation.',

    'link.settings.header' => 'Settings',
    'link.settings.link' => 'Settings',
    'link.settings.breadcrumb' => 'Settings',
    'link.settings.location_url' => 'Destination URL',
    'link.settings.location_urls' => 'Destination URLs',
    'link.settings.is_bulk' => 'Bulk generation',
    'link.settings.is_bulk_help' => 'One destination URL per line. Maximum %s lines at a time.',
    'link.settings.is_enabled' => 'Link is active',
    'link.settings.url' => 'Short URL',
    'link.settings.url_placeholder_random' => 'randomly generated alias',
    'link.settings.url_help' => 'Leave empty for a randomly generated one.',
    'link.settings.is_main_link' => 'Exclusive link page for this custom domain',
    'link.settings.is_main_link_help' => 'Make this link page to be accessible via the index of this custom domain. Other link pages won\'t be able to be associated with this domain after.',
    'link.settings.pixels_ids' => 'Pixels',
    'link.settings.forward_query_parameters_is_enabled' => 'Forward query parameters',
    'link.settings.forward_query_parameters_is_enabled_help' => 'If your short URL is accessed with query parameters (ex: ?name=sample), append that to the destination URL automatically.',
    'link.settings.http_header' => 'HTTP Status',
    'link.settings.http_header_help' => 'The HTTP status code is only sent when the pixels and cloaking features are not used.',
    'link.settings.http_status_code.301' => '301 Permanent redirect',
    'link.settings.http_status_code.302' => '302 Temporary redirect',
    'link.settings.http_status_code.307' => '307 Form submissions with temporary redirect',
    'link.settings.http_status_code.308' => '308 Form submissions with permanent redirect',
    'link.settings.app_linking_header' => 'App linking',
    'link.settings.app_linking_is_enabled' => 'Auto open app on mobile',
    'link.settings.app_linking_is_enabled_help' => 'Enable this if you want your link to automatically open as an app when accessed on mobile.',
    'link.settings.app_linking_supported_os' => 'Supported operating systems',
    'link.settings.app_linking_supported_apps' => 'Supported apps',
    'link.settings.app_linking_supported_apps_help' => 'If you do not find your app here, you can use the Targeting feature to redirect the user to your app with your custom deep link.',
    'link.settings.app_linking_supported_apps.matched' => 'Matched',
    'link.settings.app_linking_supported_apps.no_match' => 'Your destination URL is not matching any of the supported apps for automatic app opening.',
    'link.settings.cloaking_header' => 'Cloaking',
    'link.settings.cloaking_is_enabled' => 'URL Cloaking',
    'link.settings.cloaking_is_enabled_help' => 'Hide the original destination URL and display the current Short URL in the browser. This feature only works for websites that allow iframe embedding.',
    'link.settings.cloaking_title' => 'Title of the cloaked page',
    'link.settings.cloaking_meta_description' => 'Meta description of the cloaked page',
    'link.settings.cloaking_favicon' => 'Favicon of the cloaked page',
    'link.settings.cloaking_opengraph' => 'Opengraph of the cloaked page',
    'link.settings.share_is_enabled' => 'Enable share button',
    'link.settings.share_is_enabled_help' => 'Display a button in the top right of the page that opens a share modal.',
    'link.settings.scroll_buttons_is_enabled' => 'Enable scroll buttons',
    'link.settings.scroll_buttons_is_enabled_help' => 'Display scroll top & bottom buttons in the top left of the page. They will only show up when the page is long enough.',
    'link.settings.directory_is_enabled' => 'Enable directory displaying',
    'link.settings.directory_is_enabled_help' => 'If enabled, your biolink page will be public in our %s.',
    'link.settings.schedule' => 'Schedule',
    'link.settings.schedule_help' => 'Configure the dates on which it will work.',
    'link.settings.start_date' => 'Start date',
    'link.settings.end_date' => 'End date',
    'link.settings.text_color' => 'Text color',
    'link.settings.background_type' => 'Background',
    'link.settings.background_type_preset' => 'Simple gradients',
    'link.settings.background_type_preset_abstract' => 'Abstract gradients',
    'link.settings.background_type_color' => 'Custom color',
    'link.settings.background_type_gradient' => 'Custom gradient',
    'link.settings.background_type_gradient_color_one' => 'Color one',
    'link.settings.background_type_gradient_color_two' => 'Color two',
    'link.settings.background_type_image' => 'Custom image/video',
    'link.settings.background_blur' => 'Background blur',
    'link.settings.background_brightness' => 'Background brightness',
    'link.settings.background_attachment' => 'Background attachment',
    'link.settings.background_attachment.scroll' => 'Scroll',
    'link.settings.background_attachment.fixed' => 'Fixed',
    'link.settings.favicon' => 'Favicon',
    'link.settings.verified_header' => 'Verified badge',
    'link.settings.verified_help' => '%sContact us%s to submit a verification request.',
    'link.settings.verified_required' => 'You must have the page verified.',
    'link.settings.verified_location' => 'Location',
    'link.settings.verified_location.top' => 'Top',
    'link.settings.verified_location.right' => 'Right',
    'link.settings.verified_location.left' => 'Left',
    'link.settings.verified_location.bottom' => 'Bottom',
    'link.settings.branding_header' => 'Branding',
    'link.settings.display_branding' => 'Display branding',
    'link.settings.branding.name' => 'Branding name',
    'link.settings.branding.name_help' => 'Leave empty to have the default site branding.',
    'link.settings.branding.url' => 'Branding URL',
    'link.settings.pixels_header' => 'Pixels',
    'link.settings.seo_header' => 'Seo',
    'link.settings.seo_block' => 'Block search engine indexing',
    'link.settings.seo_block_help' => 'Block your biolink page from being indexed by search engines.',
    'link.settings.seo_title' => 'Page title',
    'link.settings.seo_title_help' => 'Completely change the page title to a custom one that you are setting here.',
    'link.settings.seo_meta_description' => 'Meta description',
    'link.settings.seo_meta_description_help' => 'Set a custom meta description to rank better in search engines.',
    'link.settings.seo_meta_keywords' => 'Meta keywords',
    'link.settings.seo_image' => 'Opengraph image',
    'link.settings.utm_header' => 'UTM Parameters',
    'link.settings.utm_medium' => 'Medium',
    'link.settings.utm_medium_placeholder' => 'ex: link, banner, email, social',
    'link.settings.utm_campaign' => 'Campaign',
    'link.settings.utm_campaign_placeholder' => 'ex: spring_sale_2024, black_friday',
    'link.settings.utm_campaign_placeholder_automatic' => 'Automatically set for each link based on the name.',
    'link.settings.utm_source' => 'Source',
    'link.settings.utm_source_placeholder' => 'ex: newsletter, bing, google, youtube',
    'link.settings.utm_preview' => 'UTM preview',
    'link.settings.utm_preview_help' => 'This query parameter will be appended to your destination URL.',
    'link.settings.font' => 'Font',
    'link.settings.font_size' => 'Font size',
    'link.settings.width' => 'Width',
    'link.settings.width_help' => 'The width of the main content. This setting only applies to wide device screens.',
    'link.settings.width.6' => 'Small',
    'link.settings.width.8' => 'Medium',
    'link.settings.width.10' => 'Large',
    'link.settings.width.12' => 'Extra Large',
    'link.settings.block_spacing' => 'Block height spacing',
    'link.settings.block_spacing.1' => 'Small',
    'link.settings.block_spacing.2' => 'Medium',
    'link.settings.block_spacing.3' => 'Large',
    'link.settings.hover_animation' => 'Block hover animation',
    'link.settings.hover_animation.smooth' => 'Smooth',
    'link.settings.hover_animation.instant' => 'Instant',
    'link.settings.protection_header' => 'Protection',
    'link.settings.password_help' => 'Require users to enter a password before accessing the link.',
    'link.settings.sensitive_content' => 'Sensitive content warning',
    'link.settings.sensitive_content_help' => 'Require users to confirm that they want to access your link and letting them know that the link might be sensitive.',
    'link.settings.leap_link' => 'Leap Link URL',
    'link.settings.leap_link_help' => 'Fully redirect all users that access the biolink page to this URL. Leave empty to disable the feature.',
    'link.settings.temporary_url_header' => 'Temporary URL',
    'link.settings.clicks_limit' => 'Clicks limit',
    'link.settings.clicks_limit_help' => 'Only allow the link to work for a certain amount of clicks.',
    'link.settings.expiration_url' => 'Expiration URL',
    'link.settings.expiration_url_help' => 'Visitors will be redirected to this URL after the main link expires.',
    'link.settings.targeting_header' => 'Targeting',
    'link.settings.targeting_type' => 'Targeting type',
    'link.settings.targeting_type_continent_code_help' => 'Send visitors to different URLs based on their continent location.',
    'link.settings.targeting_type_country_code_help' => 'Send visitors to different URLs based on their country location.',
    'link.settings.targeting_type_city_name_placeholder' => 'Tokyo',
    'link.settings.targeting_type_city_name_help' => 'Send visitors to different URLs based on their city location.',
    'link.settings.targeting_type_device_type' => 'Device type',
    'link.settings.targeting_type_device_type_help' => 'Send visitors to different URLs based on the device that they are using.',
    'link.settings.targeting_type_browser_language' => 'Browser language',
    'link.settings.targeting_type_browser_language_help' => 'Send visitors to different URLs based on their main browser language.',
    'link.settings.targeting_type_browser_name' => 'Browser',
    'link.settings.targeting_type_browser_name_help' => 'Send visitors to different URLs based on their browser.',
    'link.settings.targeting_type_rotation' => 'Rotation & A/B Testing',
    'link.settings.targeting_type_rotation_help' => 'Randomly & equally split the visits to multiple URLs. Helpful when running A/B tests for example.',
    'link.settings.targeting_type_percentage' => 'Percentage chances',
    'link.settings.targeting_type_os_name' => 'Operating system',
    'link.settings.targeting_type_os_name_help' => 'Send visitors to different URLs based on the device operating system that they are using.',
    'link.settings.advanced_header' => 'Advanced',
    'link.settings.pwa_header' => 'PWA',
    'link.settings.pwa_help' => 'Generate an installable Progressive Web App (PWA) that works like a native app on your devices for your biolink page.',
    'link.settings.pwa_is_enabled' => 'Enable custom PWA app',
    'link.settings.pwa_is_enabled_help' => 'Disable to use the main website PWA app (no personalized experience for your users).',
    'link.settings.pwa_display_install_bar' => 'Display installation bar',
    'link.settings.pwa_display_install_bar_help' => 'Display helper bar that tells your users how to install & access the PWA app.',
    'link.settings.pwa_theme_color' => 'Theme color',
    'link.settings.pwa_display_install_bar_delay' => 'Delay until bar shows up',
    'link.settings.pwa_icon' => 'PWA icon',
    'link.settings.pwa_icon_help' => 'Make sure it\'s an icon of 512x512 with transparent background.',
    'link.settings.customization_header' => 'Customizations',
    'link.settings.theme_header' => 'Select preset themes',
    'link.settings.email_reports_is_enabled_help' => 'Receive simple and easy to understand analytics for your link via email.',

    'link.biolink_blocks.link_sort' => 'Drag & drop to reorder',
    'link.biolink_blocks.no_data' => 'You got no content',
    'link.biolink_blocks.no_data_help' => 'Add your first block of content.',
    'link.biolink_blocks.is_enabled_tooltip' => 'Change status',

    'link.statistics.breadcrumb' => 'Statistics',
    'link.statistics.header' => 'Statistics',
    'link.statistics.link' => 'Statistics',
    'link.statistics.pageviews' => 'Pageviews',
    'link.statistics.visitors' => 'Visitors',
    'link.statistics.no_data' => 'There are no statistics available for this date range',
    'link.statistics.no_data_help' => 'Wait for new traffic or change your date range.',
    'link.statistics.overview' => 'Overview',
    'link.statistics.overview_help' => '',
    'link.statistics.entries' => 'Entries',
    'link.statistics.entries_help' => 'All the entries that have been logged in a compact list.',
    'link.statistics.latest' => 'Latest entries',
    'link.statistics.data_preview' => 'Data preview',
    'link.statistics.data_preview_info' => 'Widgets data is based on the last %s entries. Click View more to see all the widget data.',
    'link.statistics.continent_code_help' => 'Discover the continents that your visitors are from',
    'link.statistics.country_help' => 'Discover the countries that your visitors are from.',
    'link.statistics.country_from_continent_code' => 'Countries of %s',
    'link.statistics.city_name_from_country' => 'Cities of %s',
    'link.statistics.city_name_help' => 'Discover the cities that your visitors are from.',
    'link.statistics.os' => 'Operating systems',
    'link.statistics.os_help' => 'Discover the operating systems that your visitors are using.',
    'link.statistics.browser' => 'Browsers',
    'link.statistics.browser_help' => 'Discover the browsers that your visitors are using.',
    'link.statistics.language' => 'Languages',
    'link.statistics.language_help' => 'Discover the browser languages that your visitors are having.',
    'link.statistics.device' => 'Devices',
    'link.statistics.device_help' => 'Discover the devices that your visitors are using.',
    'link.statistics.referrer_host' => 'Referrers',
    'link.statistics.referrer_path' => '%s referrer paths',
    'link.statistics.referrer_help' => 'Discover where your traffic is coming from.',
    'link.statistics.referrer_direct' => 'Direct',
    'link.statistics.referrer_qr' => 'QR Code',
    'link.statistics.utms' => 'UTMs',
    'link.statistics.utms_help' => 'Discover how your UTM marketing campaigns are performing.',
    'link.statistics.utm_medium' => '%s utm mediums',
    'link.statistics.utm_campaign' => '%s / %s utm sources',
    'link.statistics.hour' => 'Visit hours',
    'link.statistics.hour_help' => 'Discover at what hours of the day your visitors are most active.',
    'link.table.os' => 'OS',
    'link.table.device' => 'Device',
    'link.table.browser' => 'Browser',
    'link.table.referrer' => 'Referrer',

    'link.password.title' => 'Password protected',
    'link.password.header' => 'Password protected',
    'link.password.subheader' => 'You must input the correct password to continue. Your password will be remembered for 30 days.',
    'link.password.error_message' => 'The password is incorrect.',

    'link.sensitive_content.title' => 'Sensitive content',
    'link.sensitive_content.header' => 'Sensitive content',
    'link.sensitive_content.subheader' => 'This link may contain sensitive content which some viewers may find offensive or disturbing.',
    'link.sensitive_content.button' => 'Accept',

    'link.splash.title' => 'Redirection in progress',
    'link.splash.header' => 'You will be redirected',
    'link.splash.subheader' => 'This is a temporary page. You are going to be redirect to the destination page soon.',
    'link.splash.home' => 'Home',
    'link.splash.continue' => 'Continue',
    'link.splash.link_unlock_seconds' => 'You will be able to continue to your link in %s seconds.',

    'link.error_message.blacklisted_url' => 'This custom URL is not available for usage.',
    'link.error_message.blacklisted_domain' => 'This domain has been blacklisted, you can\'t use it.',
    'link.error_message.blacklisted_keyword' => 'This custom URL is blacklisted.',
    'link.error_message.blacklisted_location_url' => 'This URL has been blacklisted, you can\'t use it.',
    'link.error_message.invalid_location_url' => 'Your entered URL has an invalid format. Maybe you\'re missing the https:// from the URL?',
    'link.error_message.invalid_location_url_embed' => 'Your entered URL is invalid for embedding.',
    'link.error_message.url_exists' => 'This custom URL already exists.',
    'link.error_message.url_minimum_characters' => 'This custom URL is too small. Make sure it has at least %s characters.',
    'link.error_message.url_maximum_characters' => 'This custom URL is too big. Make sure it has maximum %s characters.',

    'link.link.name' => 'Shortened URL',
    'link.file.name' => 'File link',
    'link.vcard.name' => 'Vcard link',
    'link.biolink.name' => 'Biolink page',
    'link.event.name' => 'Event link',
    'link.static.name' => 'Static site',

    'link.biolink.create_block' => 'Create block',
    'link.biolink.report' => 'Report page',
    'link.biolink.report.subject' => 'Report %s page',
    'link.biolink.report.message' => 'Write a specific and detailed reason for reporting the page.',
    'link.biolink.verified' => 'Verified page',
    'link.biolink.verified_help' => 'This page has been manually verified by the %s team.',
    'link.biolink.blocks.link' => 'Link',
    'link.biolink.blocks.heading' => 'Heading',
    'link.biolink.blocks.paragraph' => 'Paragraph',
    'link.biolink.blocks.markdown' => 'Markdown',
    'link.biolink.blocks.avatar' => 'Avatar',
    'link.biolink.blocks.socials' => 'Socials',
    'link.biolink.blocks.business_hours' => 'Business hours',
    'link.biolink.blocks.image' => 'Image',
    'link.biolink.blocks.twitch' => 'Twitch',
    'link.biolink.blocks.youtube' => 'YouTube',
    'link.biolink.blocks.soundcloud' => 'SoundCloud',
    'link.biolink.blocks.threads' => 'Threads',
    'link.biolink.blocks.snapchat' => 'Snapchat',
    'link.biolink.blocks.vimeo' => 'Vimeo',
    'link.biolink.blocks.spotify' => 'Spotify',
    'link.biolink.blocks.tiktok_video' => 'TikTok Video',
    'link.biolink.blocks.tiktok_profile' => 'TikTok Profile',
    'link.biolink.blocks.vk_video' => 'VK Video',
    'link.biolink.blocks.applemusic' => 'Apple Music',
    'link.biolink.blocks.tidal' => 'Tidal',
    'link.biolink.blocks.mixcloud' => 'Mixcloud',
    'link.biolink.blocks.kick' => 'Kick',
    'link.biolink.blocks.anchor' => 'Anchor FM',
    'link.biolink.blocks.twitter_profile' => 'Twitter profile',
    'link.biolink.blocks.twitter_video' => 'Twitter video',
    'link.biolink.blocks.twitter_tweet' => 'Twitter tweet',
    'link.biolink.blocks.pinterest_profile' => 'Pinterest profile',
    'link.biolink.blocks.instagram_media' => 'Instagram media',
    'link.biolink.blocks.rss_feed' => 'RSS feed',
    'link.biolink.blocks.custom_html' => 'Custom HTML',
    'link.biolink.blocks.vcard' => 'VCard',
    'link.biolink.blocks.image_grid' => 'Image grid',
    'link.biolink.blocks.divider' => 'Divider',
    'link.biolink.blocks.list' => 'List',
    'link.biolink.blocks.alert' => 'Alert',
    'link.biolink.blocks.email_collector' => 'Email collector',
    'link.biolink.blocks.big_link' => 'Big link',
    'link.biolink.blocks.header' => 'Header section',
    'link.biolink.blocks.faq' => 'FAQ',
    'link.biolink.blocks.discord' => 'Discord server',
    'link.biolink.blocks.facebook' => 'Facebook post',
    'link.biolink.blocks.reddit' => 'Reddit post',
    'link.biolink.blocks.audio' => 'Audio',
    'link.biolink.blocks.video' => 'Video',
    'link.biolink.blocks.file' => 'File',
    'link.biolink.blocks.pdf_document' => 'PDF document',
    'link.biolink.blocks.powerpoint_presentation' => 'Powerpoint presentation',
    'link.biolink.blocks.excel_spreadsheet' => 'Excel spreadsheet',
    'link.biolink.blocks.countdown' => 'Countdown',
    'link.biolink.blocks.cta' => 'Call to action',
    'link.biolink.blocks.external_item' => 'External item',
    'link.biolink.blocks.share' => 'Share',
    'link.biolink.blocks.coupon' => 'Coupon',
    'link.biolink.blocks.modal_text' => 'Modal text',
    'link.biolink.blocks.youtube_feed' => 'Youtube feed',
    'link.biolink.blocks.timeline' => 'Timeline',
    'link.biolink.blocks.review' => 'Review',
    'link.biolink.blocks.image_slider' => 'Image slider',
    'link.biolink.blocks.paypal' => 'PayPal',
    'link.biolink.blocks.phone_collector' => 'Phone collector',
    'link.biolink.blocks.contact_collector' => 'Contact form',
    'link.biolink.blocks.donation' => 'Donation',
    'link.biolink.blocks.product' => 'Product',
    'link.biolink.blocks.service' => 'Service',
    'link.biolink.blocks.map' => 'Map',
    'link.biolink.blocks.typeform' => 'Typeform',
    'link.biolink.blocks.calendly' => 'Calendly',
    'link.biolink.blocks.rumble' => 'Rumble video',
    'link.biolink.blocks.telegram' => 'Telegram post',
    'link.biolink.blocks.iframe' => 'Iframe embed',
    'link.biolink.blocks.appointment_calendar' => 'Appointment calendar',


    'create_link_modal.header' => 'Shorten URL',
    'create_link_modal.input.location_url' => 'Long URL',
    'create_link_modal.input.url' => 'Short URL',
    'create_link_modal.input.url_placeholder' => 'randomly generated alias',
    'create_link_modal.input.url_help' => 'Leave empty for a random generated one.',
    'create_link_modal.input.submit' => 'Shorten URL',
    'create_link_modal.error_message.main_domain_is_disabled' => 'You are not allowed to use the main domain creating links.',


    'create_file_modal.header' => 'File URL',
    'create_file_modal.input.file' => 'File',
    'create_file_modal.input.force_download_is_enabled' => 'Force download',
    'create_file_modal.input.force_download_is_enabled_help' => 'File types that can be viewed in browser (ex: pdf, images) will be force downloaded automatically.',
    'create_file_modal.input.submit' => 'Create file URL',


    'create_vcard_modal.header' => 'Vcard',
    'create_vcard_modal.input.submit' => 'Create Vcard URL',


    'create_event_modal.header' => 'Event',
    'create_event_modal.event_name' => 'Event name',
    'create_event_modal.event_location' => 'Location',
    'create_event_modal.event_start_datetime' => 'Event starts on',
    'create_event_modal.event_end_datetime' => 'Event ends on',
    'create_event_modal.event_first_alert_datetime' => 'First alert reminder',
    'create_event_modal.event_second_alert_datetime' => 'Second alert reminder',
    'create_event_modal.event_timezone' => 'Timezone',
    'create_event_modal.event_url' => 'Event URL',
    'create_event_modal.event_note' => 'Notes',
    'create_event_modal.submit' => 'Create Event URL',


    'create_static_modal.header' => 'Static site',
    'create_static_modal.file' => 'HTML or ZIP file',
    'create_static_modal.file.inside_zip_whitelisted_file_extensions' => 'File types allowed inside of a ZIP file: %s',
    'create_static_modal.file.help1' => 'Make sure your zip file contents have an <code>index.html</code> file when unzipped.',
    'create_static_modal.file.help2' => 'Make sure your you reference your images, js, css...etc in the following relative format, example: <code>&lt;link rel="stylesheet" href="./css/styles.css"&gt;</code>.',
    'create_static_modal.submit' => 'Create static site',


    'biolink_modal.header' => 'Create biolink page',
    'biolink_modal.input.submit' => 'Create biolink page',


    'biolink_link.header' => 'Add a link button',
    'biolink_link.subheader' => 'Link to any external web pages with ease.',
    'biolink_link.button_header' => 'Customization settings',
    'biolink_link.url_help' => 'Leave empty for a random generated one.',
    'biolink_link.location_url' => 'Destination URL',
    'biolink_link.open_in_new_tab' => 'Open in new tab',
    'biolink_link.coupon' => 'Coupon',
    'biolink_link.coupon_placeholder' => 'BF-30',
    'biolink_link.name' => 'Name',
    'biolink_link.markdown_text' => 'Markdown syntax',
    'biolink_link.markdown_text_help' => 'Basic markdown syntax is supported. Read more about it <a href="https://www.markdownguide.org/cheat-sheet/" target="_blank" rel="nofollow noreferrer">here</a>.',
    'biolink_link.text' => 'Text',
    'biolink_link.description' => 'Description',
    'biolink_link.button_text' => 'Button text',
    'biolink_link.text_color' => 'Text color',
    'biolink_link.description_color' => 'Description color',
    'biolink_link.icon_color' => 'Icon color',
    'biolink_link.text_alignment' => 'Text alignment',
    'biolink_link.text_alignment.center' => 'Center',
    'biolink_link.text_alignment.left' => 'Left',
    'biolink_link.text_alignment.right' => 'Right',
    'biolink_link.text_alignment.justify' => 'Justify',
    'biolink_link.background_color' => 'Background color',
    'biolink_link.image' => 'Image thumbnail',
    'biolink_link.image_alt' => 'Image alt',
    'biolink_link.image_alt_help' => 'Image description for accessibility & SEO purposes.',
    'biolink_link.border_width' => 'Border width',
    'biolink_link.border_color' => 'Border color',
    'biolink_link.border_shadow_color' => 'Border shadow color',
    'biolink_link.border_shadow_offset_x' => 'Border shadow offset X',
    'biolink_link.border_shadow_offset_y' => 'Border shadow offset Y',
    'biolink_link.border_shadow_blur' => 'Border shadow blur',
    'biolink_link.border_shadow_spread' => 'Border shadow spread',
    'biolink_link.border_radius' => 'Border radius',
    'biolink_link.border_radius_straight' => 'Straight',
    'biolink_link.border_radius_round' => 'Round',
    'biolink_link.border_radius_rounded' => 'Rounded',
    'biolink_link.border_style' => 'Border style',
    'biolink_link.border_style_solid' => 'Solid',
    'biolink_link.border_style_dashed' => 'Dashed',
    'biolink_link.border_style_double' => 'Double',
    'biolink_link.border_style_inset' => 'Inset',
    'biolink_link.border_style_outset' => 'Outset',
    'biolink_link.object_fit' => 'Fit',
    'biolink_link.object_fit.contain' => 'Contain',
    'biolink_link.object_fit.cover' => 'Cover',
    'biolink_link.object_fit.fill' => 'Fill',
    'biolink_link.animation' => 'Animation',
    'biolink_link.animation_runs' => 'Animation runs',
    'biolink_link.animation_runs_infinite' => 'Infinite',
    'biolink_link.columns' => 'Columns',
    'biolink_link.border_header' => 'Border settings',
    'biolink_link.border_shadow_header' => 'Border shadow settings',
    'biolink_link.display_settings_header' => 'Display settings',
    'biolink_link.display_devices' => 'Devices',
    'biolink_link.display_languages' => 'Browser languages',
    'biolink_link.display_operating_systems' => 'Operating systems',
    'biolink_link.display_browsers' => 'Browsers',
    'biolink_link.display_cities_placeholder' => 'Tokyo, New York, Istanbul',
    'biolink_link.display_cities_help' => 'Comma separated values. Leave empty for all.',
    'biolink_link.settings.display_help' => 'Select who should see this block. Leave empty for all.',


    'biolink_heading.header' => 'Add a heading',
    'biolink_heading.subheader' => 'A heading section will allow you to separate your page content.',


    'biolink_paragraph.header' => 'Add a paragraph',
    'biolink_paragraph.subheader' => 'A block of simple text.',


    'biolink_business_hours.header' => 'Add your business hours',
    'biolink_business_hours.subheader' => 'A section to display your business hours.',
    'biolink_business_hours.twenty_four_seven' => 'Open 24/7',
    'biolink_business_hours.twenty_four_seven_help' => 'Mark as always open.',
    'biolink_business_hours.temporarily_closed' => 'Temporarily closed',
    'biolink_business_hours.temporarily_closed_help' => 'Mark as temporarily closed.',
    'biolink_business_hours.hours_placeholder' => '10:00 - 18:00, Closed or 24 Hours open',
    'biolink_business_hours.note' => 'Additional notice',


    'biolink_markdown.header' => 'Add a markdown block',
    'biolink_markdown.subheader' => 'A block of parsed markdown formatted text.',


    'biolink_avatar.header' => 'Add an avatar',
    'biolink_avatar.subheader' => 'An image with different styles to act like your page avatar.',
    'biolink_avatar.size' => 'Size',
    'biolink_avatar.border_radius' => 'Border Radius',
    'biolink_avatar.border_radius_straight' => 'Straight',
    'biolink_avatar.border_radius_round' => 'Round',
    'biolink_avatar.border_radius_rounded' => 'Rounded',


    'biolink_socials.header' => 'Add social links',
    'biolink_socials.subheader' => 'A collection of social media links with their respective icons.',
    'biolink_socials.color' => 'Color',
    'biolink_socials.size' => 'Size',
    'biolink_socials.size.s' => 'Small',
    'biolink_socials.size.m' => 'Medium',
    'biolink_socials.size.l' => 'Large',
    'biolink_socials.size.xl' => 'Extra Large',
    'biolink_socials.email.name' => 'Email',
    'biolink_socials.email.placeholder' => 'email@domain.com',
    'biolink_socials.tel.name' => 'Telephone',
    'biolink_socials.tel.placeholder' => '+00000000000',
    'biolink_socials.vk.name' => 'VK',
    'biolink_socials.vk.placeholder' => 'id',
    'biolink_socials.telegram.name' => 'Telegram',
    'biolink_socials.telegram.placeholder' => 'telegram-username',
    'biolink_socials.skype.name' => 'Skype',
    'biolink_socials.skype.placeholder' => 'Skype invitation id',
    'biolink_socials.whatsapp.name' => 'Whatsapp',
    'biolink_socials.whatsapp.placeholder' => '2124567890',
    'biolink_socials.whatsapp_channel.name' => 'Whatsapp channel',
    'biolink_socials.whatsapp_channel.placeholder' => '00123abcd456jkl123',
    'biolink_socials.facebook.name' => 'Facebook',
    'biolink_socials.facebook.placeholder' => 'facebook-page',
    'biolink_socials.facebook-messenger.name' => 'Facebook Messenger',
    'biolink_socials.facebook-messenger.placeholder' => 'facebook-page',
    'biolink_socials.instagram.name' => 'Instagram',
    'biolink_socials.instagram.placeholder' => 'Instagram username',
    'biolink_socials.instagram_dm.name' => 'Instagram DM',
    'biolink_socials.instagram_dm.placeholder' => 'Instagram username to DM',
    'biolink_socials.twitter.name' => 'Twitter',
    'biolink_socials.twitter.placeholder' => 'Twitter username',
    'biolink_socials.tiktok.name' => 'TikTok',
    'biolink_socials.tiktok.placeholder' => 'TikTok username',
    'biolink_socials.youtube.name' => 'YouTube Channel',
    'biolink_socials.youtube.placeholder' => 'Channel ID',
    'biolink_socials.soundcloud.name' => 'SoundCloud',
    'biolink_socials.soundcloud.placeholder' => 'SoundCloud username',
    'biolink_socials.linkedin.name' => 'LinkedIn',
    'biolink_socials.linkedin.placeholder' => 'Linked In Profile',
    'biolink_socials.spotify.name' => 'Spotify',
    'biolink_socials.spotify.placeholder' => 'Spotify username',
    'biolink_socials.pinterest.name' => 'Pinterest',
    'biolink_socials.pinterest.placeholder' => 'Pinterest username',
    'biolink_socials.snapchat.name' => 'Snapchat',
    'biolink_socials.snapchat.placeholder' => 'Snapchat username',
    'biolink_socials.twitch.name' => 'Twitch',
    'biolink_socials.twitch.placeholder' => 'Twitch username',
    'biolink_socials.discord.name' => 'Discord',
    'biolink_socials.discord.placeholder' => 'Discord username',
    'biolink_socials.address.name' => 'Address',
    'biolink_socials.address.placeholder' => 'Your business location address',
    'biolink_socials.threads.name' => 'Threads',
    'biolink_socials.threads.placeholder' => 'Threads username',
    'biolink_socials.reddit.name' => 'Reddit',
    'biolink_socials.reddit.placeholder' => 'Reddit page / username',
    'biolink_socials.rumble.name' => 'Rumble',
    'biolink_socials.rumble.placeholder' => 'Rumble channel / video',
    'biolink_socials.signal.name' => 'Signal',
    'biolink_socials.signal.placeholder' => 'Signal link',
    'biolink_socials.onlyfans.name' => 'Onlyfans',
    'biolink_socials.onlyfans.placeholder' => 'Onlyfans username',
    'biolink_socials.bluesky.name' => 'Bluesky',
    'biolink_socials.bluesky.placeholder' => 'Bluesky username',
    'biolink_socials.mastodon.name' => 'Mastodon',
    'biolink_socials.mastodon.placeholder' => 'Mastodon username',


    'biolink_image.header' => 'Add an image',
    'biolink_image.subheader' => 'A simple & good looking image block for your page.',


    'biolink_youtube.header' => 'Add a YouTube video',
    'biolink_youtube.subheader' => 'Display a YouTube video on your page with ease.',
    'biolink_youtube.location_url' => 'YouTube Video URL',
    'biolink_youtube.location_url_placeholder' => 'https://www.youtube.com/watch?v=2a8PgqWrc_4',
    'biolink_youtube.video_autoplay' => 'Allow video autoplay',
    'biolink_youtube.video_controls' => 'Display video controls',
    'biolink_youtube.video_loop' => 'Video loop enabled',
    'biolink_youtube.video_muted' => 'Video is muted',


    'biolink_twitch.header' => 'Add a Twitch channel or video',
    'biolink_twitch.subheader' => 'Display a Twitch account or video widget on your page with ease.',
    'biolink_twitch.location_url' => 'Twitch URL',
    'biolink_twitch.location_url_placeholder' => 'https://www.twitch.tv/sodapoppin',


    'biolink_vimeo.header' => 'Add a Vimeo video',
    'biolink_vimeo.subheader' => 'Display a Vimeo video on your page with ease.',
    'biolink_vimeo.location_url' => 'Vimeo URL',
    'biolink_vimeo.location_url_placeholder' => 'https://vimeo.com/43338103',


    'biolink_soundcloud.header' => 'Add a Soundcloud song',
    'biolink_soundcloud.subheader' => 'Display a Soundcloud player widget on your page with ease.',
    'biolink_soundcloud.location_url' => 'Soundcloud URL',
    'biolink_soundcloud.location_url_placeholder' => 'https://soundcloud.com/octobersveryown/duppy-freestyle',


    'biolink_threads.header' => 'Add a Threads post',
    'biolink_threads.subheader' => 'Display a Threads post widget on your page with ease.',
    'biolink_threads.location_url' => 'Threads Post URL',
    'biolink_threads.location_url_placeholder' => 'https://www.threads.com/@zuck/post/Cy3m1VnRiwP',


    'biolink_snapchat.header' => 'Add a Snapchat embed',
    'biolink_snapchat.subheader' => 'Display a Spotlight video or Lens widget from Snapchat on your page with ease.',
    'biolink_snapchat.location_url' => 'Snapchat Spotlight/Lens URL',
    'biolink_snapchat.location_url_placeholder' => 'https://www.snapchat.com/spotlight/W7_EDlXWTBiXAEEniNoMPwAAYbnh4Z3d0aHdoAYpqrMorAYpqrKT5AAAAAQ',


    'biolink_applemusic.header' => 'Add an Apple Music song',
    'biolink_applemusic.subheader' => 'Display an Apple Music player widget on your page with ease.',
    'biolink_applemusic.location_url' => 'Apple Music URL',
    'biolink_applemusic.location_url_placeholder' => 'https://music.apple.com/us/album/evermore/1544268281',


    'biolink_tidal.header' => 'Add a Tidal song',
    'biolink_tidal.subheader' => 'Display a Tidal player widget on your page with ease.',
    'biolink_tidal.location_url' => 'Tidal Music URL',
    'biolink_tidal.location_url_placeholder' => 'https://tidal.com/browse/track/18445266',


    'biolink_mixcloud.header' => 'Add a Mixcloud song',
    'biolink_mixcloud.subheader' => 'Display a Mixcloud player widget on your page with ease.',
    'biolink_mixcloud.location_url' => 'Mixcloud Music URL',
    'biolink_mixcloud.location_url_placeholder' => 'https://www.mixcloud.com/maestrosdelritmo/maestros-del-ritmo-volxxx-the-masterpiece-top-100-2012-2018/',
    'biolink_mixcloud.theme' => 'Theme',
    'biolink_mixcloud.type.picture' => 'Picture',
    'biolink_mixcloud.type.classic' => 'Classic',
    'biolink_mixcloud.type.mini' => 'Mini',


    'biolink_kick.header' => 'Add a Kick video',
    'biolink_kick.subheader' => 'Display a Kick account widget on your page with ease.',
    'biolink_kick.location_url' => 'Kick URL',
    'biolink_kick.location_url_placeholder' => 'https://kick.com/xqc',


    'biolink_anchor.header' => 'Add an Anchor.fm podcast',
    'biolink_anchor.subheader' => 'Display an Anchor FM podcast player widget on your page with ease.',
    'biolink_anchor.location_url' => 'Anchor FM Podcast URL',
    'biolink_anchor.location_url_placeholder' => 'https://anchor.fm/beachtoosandy/episodes/107-Reviews-of-Driving-Schools-ensejl',


    'biolink_twitter_profile.header' => 'Add a Twitter profile',
    'biolink_twitter_profile.subheader' => 'Display a Twitter profile widget on your page with ease.',
    'biolink_twitter_profile.location_url' => 'Twitter Profile URL',
    'biolink_twitter_profile.location_url_placeholder' => 'https://twitter.com/naval/',
    'biolink_twitter_profile.theme' => 'Theme',


    'biolink_twitter_video.header' => 'Add a Twitter video',
    'biolink_twitter_video.subheader' => 'Display a Twitter video widget on your page with ease.',
    'biolink_twitter_video.location_url' => 'Twitter Video URL',
    'biolink_twitter_video.location_url_placeholder' => 'https://x.com/MrBeast/status/1776732112013463825',


    'biolink_twitter_tweet.header' => 'Add a Twitter tweet',
    'biolink_twitter_tweet.subheader' => 'Display a Twitter tweet widget on your page with ease.',
    'biolink_twitter_tweet.location_url' => 'Twitter Tweet URL',
    'biolink_twitter_tweet.location_url_placeholder' => 'https://twitter.com/naval/status/1002103360646823936',
    'biolink_twitter_tweet.theme' => 'Theme',


    'biolink_pinterest_profile.header' => 'Add a Pinterest profile',
    'biolink_pinterest_profile.subheader' => 'Display a Pinterest profile widget on your page with ease.',
    'biolink_pinterest_profile.location_url' => 'Pinterest Profile URL',
    'biolink_pinterest_profile.location_url_placeholder' => 'https://pinterest.com/Google/',


    'biolink_instagram_media.header' => 'Add Instagram media',
    'biolink_instagram_media.subheader' => 'Display an Instagram post, video or reel widget on your page with ease.',
    'biolink_instagram_media.location_url' => 'Instagram Media URL',
    'biolink_instagram_media.location_url_placeholder' => 'https://www.instagram.com/p/CI1pQoDjZTz',


    'biolink_spotify.header' => 'Add Spotify media',
    'biolink_spotify.subheader' => 'Display a Spotify song, album, show or episode widget on your page with ease.',
    'biolink_spotify.location_url' => 'Spotify URL',
    'biolink_spotify.location_url_placeholder' => 'https://open.spotify.com/track/5ry2OE6R2zPQFDO85XkgRb',


    'biolink_tiktok_video.header' => 'Add a TikTok video',
    'biolink_tiktok_video.subheader' => 'Display a TikTok video widget on your page with ease.',
    'biolink_tiktok_video.location_url' => 'TikTok Video URL',
    'biolink_tiktok_video.location_url_placeholder' => 'https://www.tiktok.com/@charlidamelio/video/6808693617306111237',


    'biolink_tiktok_profile.header' => 'Add a TikTok profile',
    'biolink_tiktok_profile.subheader' => 'Display a TikTok profile widget on your page with ease.',
    'biolink_tiktok_profile.location_url' => 'TikTok Profile URL',
    'biolink_tiktok_profile.location_url_placeholder' => 'https://www.tiktok.com/@charlidamelio',


    'biolink_vk_video.header' => 'Add a VK video',
    'biolink_vk_video.subheader' => 'Display a VK video widget on your page with ease.',
    'biolink_vk_video.location_url' => 'VK Video URL',
    'biolink_vk_video.location_url_placeholder' => 'https://vk.com/video-30666517_456244845',


    'biolink_email_collector.header' => 'Add a sign up form',
    'biolink_email_collector.subheader' => 'Easily capture emails from your visitors.',
    'biolink_email_collector.email_collector_header' => 'Form settings',
    'biolink_email_collector.email_placeholder' => 'Email placeholder',
    'biolink_email_collector.name_placeholder' => 'Name placeholder',
    'biolink_email_collector.success_text' => 'Thank you message',
    'biolink_email_collector.show_agreement' => 'Show agreement checkbox',
    'biolink_email_collector.show_agreement_help' => 'Require the user to confirm his agreement by ticking a checkbox.',
    'biolink_email_collector.agreement_url' => 'Agreement URL',
    'biolink_email_collector.agreement_text' => 'Agreement text',
    'biolink_email_collector.thank_you_url' => 'Thank you URL',
    'biolink_email_collector.thank_you_url_help' => 'Redirect the user to a specific URL after submitting the form. Leave empty to disable.',
    'biolink_email_collector.email_placeholder_default' => 'hello@example.com',
    'biolink_email_collector.name_placeholder_default' => 'Your full name',
    'biolink_email_collector.button_text_default' => 'Sign up',
    'biolink_email_collector.success_text_default' => 'Thank you for signing up.',
    'biolink_email_collector.error_message.exists' => 'You have already submitted your data once.',


    'biolink_rss_feed.header' => 'Add an RSS Feed',
    'biolink_rss_feed.subheader' => 'Display a simple dynamic RSS Feed on your page.',
    'biolink_rss_feed.location_url' => 'RSS Feed URL',
    'biolink_rss_feed.location_url_placeholder' => 'https://example.com/feed.xml',
    'biolink_rss_feed.amount' => 'Amount of posts to show',


    'biolink_custom_html.header' => 'Add custom HTML',
    'biolink_custom_html.subheader' => 'Display any type of custom HTML on your page.',
    'biolink_custom_html.html' => 'Custom HTML',


    'biolink_vcard.header' => 'Add VCard',
    'biolink_vcard.subheader' => 'Your downloadable contact details via a button to your profile.',
    'biolink_vcard.vcard_header' => 'Vcard settings',
    'biolink_vcard.vcard_avatar' => 'Avatar',
    'biolink_vcard.vcard_first_name' => 'First name',
    'biolink_vcard.vcard_last_name' => 'Last name',
    'biolink_vcard.vcard_url' => 'Website URL',
    'biolink_vcard.vcard_company' => 'Company',
    'biolink_vcard.vcard_job_title' => 'Job title',
    'biolink_vcard.vcard_birthday' => 'Birthday',
    'biolink_vcard.vcard_street' => 'Street address',
    'biolink_vcard.vcard_zip' => 'ZIP',
    'biolink_vcard.vcard_region' => 'Region',
    'biolink_vcard.vcard_note' => 'Note',
    'biolink_vcard.vcard_phone_numbers' => 'Phone numbers',
    'biolink_vcard.vcard_phone_number_value' => 'Phone number',
    'biolink_vcard.vcard_phone_number_label' => 'Label',
    'biolink_vcard.vcard_phone_number_label_help' => 'Leave empty to use the default phone generated label. Custom labels do not work on Android devices.',
    'biolink_vcard.vcard_socials' => 'Socials',
    'biolink_vcard.vcard_social_label' => 'Label',
    'biolink_vcard.vcard_social_value' => 'URL',


    'biolink_image_grid.header' => 'Add an image grid',
    'biolink_image_grid.subheader' => 'Display multiple images on the same row.',
    'biolink_image_grid.columns' => 'Columns',


    'biolink_list.header' => 'Add a text list',
    'biolink_list.subheader' => 'Display an ordered or unordered list on your page.',
    'biolink_list.text' => 'List items',
    'biolink_list.text_help' => 'Write one item per line.',
    'biolink_list.margin_items_y' => 'Margin between items',
    'biolink_list.margin_items_x' => 'Margin between icon & text',


    'biolink_alert.header' => 'Add an alert box',
    'biolink_alert.subheader' => 'Display an alert notification type of widget with ease.',
    'biolink_alert.display_close_button' => 'Display close button',
    'biolink_alert.alert_pause_after_closed' => 'Pause alert for X minutes after closed',


    'biolink_divider.header' => 'Add a space divider',
    'biolink_divider.subheader' => 'Separate your content with the help of this block.',
    'biolink_divider.margin_top' => 'Margin top',
    'biolink_divider.margin_bottom' => 'Margin bottom',


    'biolink_big_link.header' => 'Add a big link button',
    'biolink_big_link.subheader' => 'Link to any external web pages with an expanded link.',


    'biolink_header.header' => 'Add a header section',
    'biolink_header.subheader' => 'A beautiful avatar with background section for your page.',
    'biolink_header.avatar' => 'Avatar image',
    'biolink_header.background_type' => 'Background type',
    'biolink_header.background' => 'Background image',
    'biolink_header.video' => 'Youtube video',
    'biolink_header.video_url' => 'YouTube Video URL',
    'biolink_header.video_url_placeholder' => 'https://www.youtube.com/watch?v=2a8PgqWrc_4',

    'biolink_faq.header' => 'Add an FAQ block',
    'biolink_faq.subheader' => 'Display a block of the most frequent questions & answers for your visitors.',
    'biolink_faq.title' => 'Title',
    'biolink_faq.content' => 'Content',


    'biolink_discord.header' => 'Add a Discord server',
    'biolink_discord.subheader' => 'Display a Discord server widget on your page with ease.',
    'biolink_discord.server_id' => 'Server Id',


    'biolink_facebook.header' => 'Add a Facebook post',
    'biolink_facebook.subheader' => 'Display a Facebook post widget on your page with ease.',
    'biolink_facebook.location_url' => 'Facebook Post/Video URL',


    'biolink_reddit.header' => 'Add a Reddit post',
    'biolink_reddit.subheader' => 'Display a Reddit post widget on your page with ease.',
    'biolink_reddit.location_url' => 'Reddit Post URL',


    'biolink_audio.header' => 'Add an audio file',
    'biolink_audio.subheader' => 'Display a playable audio widget on your page with ease.',
    'biolink_audio.file' => 'Audio file',
    'biolink_audio.audio_autoplay' => 'Allow audio autoplay',
    'biolink_audio.audio_controls' => 'Display audio controls',
    'biolink_audio.audio_loop' => 'Audio loop enabled',
    'biolink_audio.audio_muted' => 'Audio is muted',

    'biolink_video.header' => 'Add a video file',
    'biolink_video.subheader' => 'Display a playable video widget on your page with ease.',
    'biolink_video.file' => 'Video file',
    'biolink_video.poster_url' => 'Thumbnail image URL',
    'biolink_video.video_autoplay' => 'Allow video autoplay',
    'biolink_video.video_controls' => 'Display video controls',
    'biolink_video.video_loop' => 'Video loop enabled',
    'biolink_video.video_muted' => 'Video is muted',


    'biolink_file.header' => 'Add a file block',
    'biolink_file.subheader' => 'A link to a downloadable file on your page with ease.',
    'biolink_file.file' => 'File',


    'biolink_pdf_document.header' => 'Add a PDF document',
    'biolink_pdf_document.subheader' => 'A button with a modal opening a PDF viewer & link to the PDF document.',
    'biolink_pdf_document.file' => 'File',


    'biolink_powerpoint_presentation.header' => 'Add a powerpoint presentation',
    'biolink_powerpoint_presentation.subheader' => 'A button with a modal opening a viewer with the powerpoint presentation & a direct link to the file.',
    'biolink_powerpoint_presentation.file' => 'File',


    'biolink_excel_spreadsheet.header' => 'Add an excel spreadsheet',
    'biolink_excel_spreadsheet.subheader' => 'A button with a modal opening a viewer with the excel spreadsheet & a direct link to the file.',
    'biolink_excel_spreadsheet.file' => 'File',


    'biolink_countdown.header' => 'Add a countdown timer',
    'biolink_countdown.subheader' => 'Display a simple countdown widget on your page with ease.',
    'biolink_countdown.end_date' => 'End date',
    'biolink_countdown.theme' => 'Theme',


    'biolink_cta.header' => 'Add a call to action button',
    'biolink_cta.subheader' => 'A link to a custom action, such as email or phone number.',
    'biolink_cta.type_email' => 'Email',
    'biolink_cta.type_call' => 'Call',
    'biolink_cta.type_sms' => 'SMS',
    'biolink_cta.type_facetime' => 'Facetime',
    'biolink_cta.value_email' => 'Email address',
    'biolink_cta.value_call' => 'Phone number',
    'biolink_cta.value_sms' => 'Phone number',
    'biolink_cta.value_facetime' => 'Phone number or email address',


    'biolink_external_item.header' => 'Add an external item',
    'biolink_external_item.subheader' => 'A more detailed link button to an external sold product.',
    'biolink_external_item.location_url' => 'Item URL',
    'biolink_external_item.price' => 'Price',
    'biolink_external_item.price_placeholder' => '20 USD',
    'biolink_external_item.name_color' => 'Name color',
    'biolink_external_item.price_color' => 'Price color',


    'biolink_share.header' => 'Add a share button',
    'biolink_share.subheader' => 'A button that opens a modal with all the easily sharable links to your page.',


    'biolink_coupon.header' => 'Add a coupon code',
    'biolink_coupon.subheader' => 'A button that opens a modal with a coupon code & button to your page.',


    'biolink_modal_text.header' => 'Add a button modal with text',
    'biolink_modal_text.subheader' => 'A button that opens a modal with text content.',


    'biolink_youtube_feed.header' => 'Add a YouTube feed',
    'biolink_youtube_feed.subheader' => 'Display your latest youtube videos dynamically as button links on your page.',
    'biolink_youtube_feed.channel_id' => 'YouTube Channel Id',
    'biolink_youtube_feed.amount' => 'Amount of videos to show',


    'biolink_timeline.header' => 'Add a Timeline feed',
    'biolink_timeline.subheader' => 'Display a simple, nice looking & customizable timeline widget on your page.',
    'biolink_timeline.title' => 'Title',
    'biolink_timeline.date' => 'Date',
    'biolink_timeline.title_color' => 'Title color',
    'biolink_timeline.date_color' => 'Date color',
    'biolink_timeline.line_color' => 'Vertical line color',


    'biolink_review.header' => 'Add a review block',
    'biolink_review.subheader' => 'Display a review that you received to build social proof on your page.',
    'biolink_review.title' => 'Title',
    'biolink_review.author_name' => 'Author name',
    'biolink_review.author_description' => 'Author description',
    'biolink_review.image' => 'Author image',
    'biolink_review.stars' => 'Stars',
    'biolink_review.title_color' => 'Title color',
    'biolink_review.author_name_color' => 'Author name color',
    'biolink_review.author_description_color' => 'Author description color',
    'biolink_review.stars_color' => 'Stars color',


    'biolink_image_slider.header' => 'Add an image slider block',
    'biolink_image_slider.subheader' => 'Display a horizontal collection of dynamically added images on your page.',
    'biolink_image_slider.slider_settings_header' => 'Slider settings',
    'biolink_image_slider.slider_items_header' => 'Slider images',
    'biolink_image_slider.width_height' => 'Width/height for images',
    'biolink_image_slider.autoplay_interval' => 'Autoplay interval',
    'biolink_image_slider.gap' => 'Gap between images',
    'biolink_image_slider.display_multiple' => 'Display multiple images when it fits',
    'biolink_image_slider.display_arrows' => 'Display arrows',
    'biolink_image_slider.display_pagination' => 'Display pagination',
    'biolink_image_slider.autoplay' => 'Autoplay',


    'biolink_paypal.header' => 'Add a PayPal payment button',
    'biolink_paypal.subheader' => 'Redirect your users to pay via PayPal for a custom product.',
    'biolink_paypal.type_buy_now' => 'Buy now',
    'biolink_paypal.type_add_to_cart' => 'Add to cart',
    'biolink_paypal.type_donation' => 'Donation',
    'biolink_paypal.email' => 'PayPal email',
    'biolink_paypal.title' => 'Product title',
    'biolink_paypal.price' => 'Price',
    'biolink_paypal.currency' => 'Currency code',
    'biolink_paypal.currency_placeholder' => 'EUR',
    'biolink_paypal.thank_you_url' => 'Thank you URL',
    'biolink_paypal.cancel_url' => 'Cancelled payment URL',


    'biolink_phone_collector.header' => 'Add a phone collector form',
    'biolink_phone_collector.subheader' => 'Capture phone numbers with ease from your visitors.',
    'biolink_phone_collector.phone_collector_header' => 'Form settings',
    'biolink_phone_collector.phone_placeholder' => 'Phone placeholder',
    'biolink_phone_collector.name_placeholder' => 'Name placeholder',
    'biolink_phone_collector.success_text' => 'Thank you message',
    'biolink_phone_collector.show_agreement' => 'Show agreement checkbox',
    'biolink_phone_collector.show_agreement_help' => 'Require the user to confirm his agreement by ticking a checkbox.',
    'biolink_phone_collector.agreement_url' => 'Agreement URL',
    'biolink_phone_collector.agreement_text' => 'Agreement text',
    'biolink_phone_collector.thank_you_url' => 'Thank you URL',
    'biolink_phone_collector.thank_you_url_help' => 'Redirect the user to a specific URL after submitting the form. Leave empty to disable.',
    'biolink_phone_collector.phone_placeholder_default' => 'Your phone number',
    'biolink_phone_collector.name_placeholder_default' => 'Your full name',
    'biolink_phone_collector.button_text_default' => 'Sign up',
    'biolink_phone_collector.success_text_default' => 'Thank you for signing up.',
    'biolink_phone_collector.error_message.exists' => 'You have already submitted your data once.',


    'biolink_contact_collector.header' => 'Add a contact form',
    'biolink_contact_collector.subheader' => 'Capture emails, phone numbers & messages from your visitors.',
    'biolink_contact_collector.contact_collector_header' => 'Form settings',
    'biolink_contact_collector.email_placeholder' => 'Email placeholder',
    'biolink_contact_collector.phone_placeholder' => 'Phone placeholder',
    'biolink_contact_collector.name_placeholder' => 'Name placeholder',
    'biolink_contact_collector.message_placeholder' => 'Message placeholder',
    'biolink_contact_collector.success_text' => 'Thank you message',
    'biolink_contact_collector.show_agreement' => 'Show agreement checkbox',
    'biolink_contact_collector.show_agreement_help' => 'Require the user to confirm his agreement by ticking a checkbox.',
    'biolink_contact_collector.agreement_url' => 'Agreement URL',
    'biolink_contact_collector.agreement_text' => 'Agreement text',
    'biolink_contact_collector.thank_you_url' => 'Thank you URL',
    'biolink_contact_collector.thank_you_url_help' => 'Redirect the user to a specific URL after submitting the form. Leave empty to disable.',
    'biolink_contact_collector.phone_placeholder_default' => '+401234567890',
    'biolink_contact_collector.name_placeholder_default' => 'Your full name',
    'biolink_contact_collector.email_placeholder_default' => 'Your valid email address',
    'biolink_contact_collector.message_placeholder_default' => 'Your message to us',
    'biolink_contact_collector.button_text_default' => 'Send message',
    'biolink_contact_collector.success_text_default' => 'We got your message, we\'ll get back to you.',


    'biolink_appointment_calendar.header' => 'Add an appointment calendar form',
    'biolink_appointment_calendar.subheader' => 'Allow your visitors to book sessions on your calendar with ease.',
    'biolink_appointment_calendar.booking_header' => 'Booking settings',
    'biolink_appointment_calendar.form_header' => 'Form settings',
    'biolink_appointment_calendar.duration' => 'Slot duration',
    'biolink_appointment_calendar.available_times_x' => '%s available times',
    'biolink_appointment_calendar.minimum_notice_period' => 'Minimum notice period',
    'biolink_appointment_calendar.allowed_scheduling_days_ahead' => 'Allowed scheduling days ahead',
    'biolink_appointment_calendar.timezone' => 'Timezone',
    'biolink_appointment_calendar.email_placeholder' => 'Email placeholder',
    'biolink_appointment_calendar.phone_placeholder' => 'Phone placeholder',
    'biolink_appointment_calendar.name_placeholder' => 'Name placeholder',
    'biolink_appointment_calendar.message_placeholder' => 'Message placeholder',
    'biolink_appointment_calendar.success_text' => 'Thank you message',
    'biolink_appointment_calendar.show_agreement' => 'Show agreement checkbox',
    'biolink_appointment_calendar.show_agreement_help' => 'Require the user to confirm his agreement by ticking a checkbox.',
    'biolink_appointment_calendar.agreement_url' => 'Agreement URL',
    'biolink_appointment_calendar.agreement_text' => 'Agreement text',
    'biolink_appointment_calendar.thank_you_url' => 'Thank you URL',
    'biolink_appointment_calendar.thank_you_url_help' => 'Redirect the user to a specific URL after submitting the form. Leave empty to disable.',
    'biolink_appointment_calendar.phone_placeholder_default' => '+401234567890',
    'biolink_appointment_calendar.name_placeholder_default' => 'Your full name',
    'biolink_appointment_calendar.email_placeholder_default' => 'Your valid email address',
    'biolink_appointment_calendar.message_placeholder_default' => 'Your message to us',
    'biolink_appointment_calendar.button_text_default' => 'Send message',
    'biolink_appointment_calendar.success_text_default' => 'We got your message, we\'ll get back to you.',
    'biolink_appointment_calendar.time_placeholder' => 'Select booking time',
    'biolink_appointment_calendar.no_time_slots' => 'There are no available time slots.',
    'biolink_appointment_calendar.time_slot_booked' => '(Booked)',
    'biolink_appointment_calendar.error_message.time_slot_booked' => 'The selected time slot is already booked.',
    'biolink_appointment_calendar.error_message.invalid_time_slot' => 'The selected time slot is not available.',


    'biolink_donation.header' => 'Get donations',
    'biolink_donation.subheader' => 'Receive donations from your visitors with ease.',
    'biolink_donation.donation_header' => 'Donation settings',
    'biolink_donation.title' => 'Donation title',
    'biolink_donation.description' => 'Donation description',
    'biolink_donation.prefilled_amount' => 'Prefilled amount',
    'biolink_donation.minimum_amount' => 'Minimum amount',
    'biolink_donation.currency' => 'Currency code',
    'biolink_donation.currency_help' => 'Currency code, such as USD, EUR, AUD...etc. Make sure that it is compatible with the payment processor you choose to use.',
    'biolink_donation.allow_custom_amount' => 'Allow custom amount',
    'biolink_donation.allow_message' => 'Allow messages',
    'biolink_donation.allow_message_help' => 'You will be able to receive a small message from people who donate.',
    'biolink_donation.thank_you_title' => 'Thank you title',
    'biolink_donation.thank_you_description' => 'Thank you description',
    'biolink_donation.thank_you_url' => 'Thank you URL',
    'biolink_donation.thank_you_url_help' => 'Instead of displaying a thank you modal with the Title and Description, redirect to a custom Thank you URL.',
    'biolink_donation.amount' => 'Amount',
    'biolink_donation.message' => 'Your message',
    'biolink_donation.payment_processor' => 'Pay via',
    'biolink_donation.submit' => 'Donate',


    'biolink_product.header' => 'Sell a digital product',
    'biolink_product.subheader' => 'Sell digital products to your visitors with ease.',
    'biolink_product.product_header' => 'Product settings',
    'biolink_product.file' => 'Product file',
    'biolink_product.title' => 'Product title',
    'biolink_product.description' => 'Product description',
    'biolink_product.price' => 'Price',
    'biolink_product.minimum_price' => 'Minimum price',
    'biolink_product.currency' => 'Currency code',
    'biolink_product.currency_help' => 'Currency code, such as USD, EUR, AUD...etc. Make sure that it is compatible with the payment processor you choose to use.',
    'biolink_product.allow_custom_price' => 'Allow custom amount',
    'biolink_product.email_help' => 'You will receive your unique download link of the product via email.',
    'biolink_product.payment_processor' => 'Pay via',
    'biolink_product.submit' => 'Pay',
    'biolink_product.free' => 'Download for free',
    'biolink_product.error_message.double_download' => 'You have already downloaded this product. Your download link was already sent to your email once.',


    'biolink_service.header' => 'Sell a service',
    'biolink_service.subheader' => 'Sell services to your visitors with ease.',
    'biolink_service.service_header' => 'Payment service settings',
    'biolink_service.title' => 'Service title',
    'biolink_service.description' => 'Service description',
    'biolink_service.currency' => 'Currency code',
    'biolink_service.currency_help' => 'Currency code, such as USD, EUR, AUD...etc. Make sure that it is compatible with the payment processor you choose to use.',
    'biolink_service.email_help' => 'You will be contacted after via email.',
    'biolink_service.message' => 'Your request',
    'biolink_service.payment_processor' => 'Pay via',
    'biolink_service.submit' => 'Pay',


    'biolink_block.data_header' => 'Data collection',
    'biolink_block.data_help' => 'All collected data can also be found in the %sData page%s.',
    'biolink_block.guests_payments_help' => 'All payments data can also be found in the %sGuests payments page%s.',
    'biolink_block.notifications' => 'Notifications',
    'biolink_block.notifications_help' => 'Get notified when new data is received.',
    'biolink_block.simple_notification' => 'Caught new submitted data for \'%1$s\' block / \'%2$s\' link.%3$sView details: %4$s 🔗.',
    'biolink_block.push_notification.title' => 'Caught new submitted data',
    'biolink_block.push_notification.description' => '%1$s (%2$s)',



    'biolink_map.header' => 'Add a Google map',
    'biolink_map.subheader' => 'Show your users a map image with a particular location.',
    'biolink_map.address' => 'Address',
    'biolink_map.address_placeholder' => 'Via Montenapoleone 12, Milan, Italy',
    'biolink_map.markers' => 'Markers addresses',
    'biolink_map.markers_help' => 'One map marker address per line.',
    'biolink_map.zoom' => 'Zoom',
    'biolink_map.type.roadmap' => 'Roadmap',
    'biolink_map.type.satellite' => 'Satellite',
    'biolink_map.type.terrain' => 'Terrain',
    'biolink_map.type.hybrid' => 'Hybrid',


    'biolink_typeform.header' => 'Add a Typeform block',
    'biolink_typeform.subheader' => 'Display a Typeform form widget on your page.',
    'biolink_typeform.location_url' => 'Typeform URL',
    'biolink_typeform.location_url_placeholder' => 'https://lifeship.typeform.com/to/YWeOlPu7',


    'biolink_calendly.header' => 'Add a Calendly block',
    'biolink_calendly.subheader' => 'Display a Calendly form widget on your page.',
    'biolink_calendly.location_url' => 'Calendly user or calendar URL',
    'biolink_calendly.location_url_placeholder' => 'https://calendly.com/username/calendar-name',


    'biolink_rumble.header' => 'Add a Rumble video',
    'biolink_rumble.subheader' => 'Display a Rumble post widget on your page with ease.',
    'biolink_rumble.location_url' => 'Rumble Video Embed URL',
    'biolink_rumble.location_url_placeholder' => 'https://rumble.com/embed/v4oja79',


    'biolink_telegram.header' => 'Add a Telegram post',
    'biolink_telegram.subheader' => 'Display a Telegram post widget from a public channel on your bio page with ease.',
    'biolink_telegram.location_url' => 'Telegram Post URL',
    'biolink_telegram.location_url_placeholder' => 'https://t.me/altumcode/12345',


    'biolink_iframe.header' => 'Add an iframe embed',
    'biolink_iframe.subheader' => 'Display a website link within an iframe.',


    'biolink_themes.header' => 'Select a theme',
    'biolink_themes.id' => 'Theme',
    'biolink_themes.id_null' => 'Custom',
    'biolink_themes.sample_description' => 'This is a sample description.',


    'biolink_link_create.header' => 'Add a new block',
    'biolink_link_create.standard' => 'Standard',
    'biolink_link_create.standard_subheader' => 'The base blocks to help you with your general needs.',
    'biolink_link_create.advanced' => 'Advanced',
    'biolink_link_create.advanced_subheader' => 'The blocks which help you achieve more complex functionality.',
    'biolink_link_create.embeds' => 'Embeds',
    'biolink_link_create.embeds_subheader' => 'The blocks that help you integrate content from other websites.',
    'biolink_link_create.payments' => 'Payments',
    'biolink_link_create.payments_subheader' => 'The blocks that help you get paid & make money.',


    'tools.breadcrumb' => 'Online tools',
    'tools.title' => 'Online tools',
    'tools.tool_title' => '%s',
    'tools.menu' => 'Tools',
    'tools.header' => 'Online tools',
    'tools.subheader' => 'Web tools that help you test, convert, calculate, generate different kind of things.',
    'tools.total_views' => 'Total views',
    'tools.popular_tools' => 'Popular tools',
    'tools.similar_tools' => 'Similar tools',
    'tools.share' => 'Share',
    'tools.result' => 'Result',
    'tools.rating' => '%1$s of %2$s ratings',
    'tools.content' => 'Content',
    'tools.text' => 'Text',
    'tools.quality' => 'Quality',
    'tools.last_submissions' => 'Last submissions',
    'tools.no_data' => 'We haven\'t found any tool named like that.',
    'tools.extra_content' => 'Additional page content: Editable from the admin panel -> languages -> choose or create language -> translate app page.',

    'tools.checker_tools' => 'Checker tools',
    'tools.checker_tools_help' => 'A collection of great checker-type tools to help you check & verify different types of things.',
    'tools.text_tools' => 'Text tools',
    'tools.text_tools_help' => 'A collection of text content related tools to help you create, modify & improve text type of content.',
    'tools.converter_tools' => 'Converter tools',
    'tools.converter_tools_help' => 'A collection of tools that help you easily convert data.',
    'tools.generator_tools' => 'Generator tools',
    'tools.generator_tools_help' => 'A collection of the most useful generator tools that you can generate data with.',
    'tools.developer_tools' => 'Developer tools',
    'tools.developer_tools_help' => 'A collection of highly useful tools mainly for developers and not only.',
    'tools.image_manipulation_tools' => 'Image manipulation tools',
    'tools.image_manipulation_tools_help' => 'A collection of tools that help modify & convert image files.',
    'tools.misc_tools' => 'Misc tools',
    'tools.misc_tools_help' => 'A collection of other random, but great & useful tools.',
    'tools.time_converter_tools' => 'Time converter tools',
    'tools.time_converter_tools_help' => 'A collection of date & time conversion related tools.',

    'tools.dns_lookup.name' => 'DNS Lookup',
    'tools.dns_lookup.description' => 'Find A, AAAA, CNAME, MX, NS, TXT, SOA DNS records of a host.',
    'tools.dns_lookup.meta_keywords' => '',
    'tools.dns_lookup.host' => 'Host',
    'tools.dns_lookup.error_message' => 'We could not retrieve any DNS records for your given host.',
    'tools.dns_lookup.result.host' => 'Host',
    'tools.dns_lookup.result.ttl' => 'TTL',
    'tools.dns_lookup.result.target' => 'Target',
    'tools.dns_lookup.result.ipv6' => 'IPv6',
    'tools.dns_lookup.result.priority' => 'Priority',
    'tools.dns_lookup.result.entries' => 'Entries',
    'tools.dns_lookup.result.mname' => 'MNAME',
    'tools.dns_lookup.result.rname' => 'RNAME',
    'tools.dns_lookup.result.serial' => 'Serial',
    'tools.dns_lookup.result.refresh' => 'Refresh',
    'tools.dns_lookup.result.retry' => 'Retry',
    'tools.dns_lookup.result.expire' => 'Expire',
    'tools.dns_lookup.result.minimum_ttl' => 'Min. TTL',
    'tools.dns_lookup.result.flags' => 'Flags',
    'tools.dns_lookup.result.tag' => 'Tag',
    'tools.dns_lookup.result.value' => 'Value',
    'tools.dns_lookup.result.ns' => 'Nameserver',
    'tools.dns_lookup.result.x_records' => '%s records',
    'tools.dns_lookup.extra_content' => '',

    'tools.ip_lookup.name' => 'IP Lookup',
    'tools.ip_lookup.description' => 'Get approximate IP details.',
    'tools.ip_lookup.meta_keywords' => '',
    'tools.ip_lookup.error_message' => 'We could not retrieve any details for your given IP.',
    'tools.ip_lookup.result.latitude' => 'Latitude',
    'tools.ip_lookup.result.longitude' => 'Longitude',
    'tools.ip_lookup.result.timezone' => 'Timezone',
    'tools.ip_lookup.extra_content' => '',

    'tools.reverse_ip_lookup.name' => 'Reverse IP Lookup',
    'tools.reverse_ip_lookup.description' => 'Take an IP and try to look for the domain/host associated with it.',
    'tools.reverse_ip_lookup.meta_keywords' => '',
    'tools.reverse_ip_lookup.error_message' => 'We could not retrieve any details for your given IP.',
    'tools.reverse_ip_lookup.extra_content' => '',

    'tools.ssl_lookup.name' => 'SSL Lookup',
    'tools.ssl_lookup.description' => 'Get all possible details about an SSL certificate.',
    'tools.ssl_lookup.meta_keywords' => '',
    'tools.ssl_lookup.host' => 'Host',
    'tools.ssl_lookup.port' => 'Port',
    'tools.ssl_lookup.error_message' => 'We could not retrieve any details for your given host.',
    'tools.ssl_lookup.result.organization' => 'Organization',
    'tools.ssl_lookup.result.common_name' => 'Common name',
    'tools.ssl_lookup.result.start_datetime' => 'Issued on',
    'tools.ssl_lookup.result.end_datetime' => 'Expiring on',
    'tools.ssl_lookup.result.signature_type' => 'Signature type',
    'tools.ssl_lookup.extra_content' => '',

    'tools.whois_lookup.name' => 'Whois Lookup',
    'tools.whois_lookup.description' => 'Get all possible details about a domain name.',
    'tools.whois_lookup.meta_keywords' => '',
    'tools.whois_lookup.domain_name' => 'Domain name',
    'tools.whois_lookup.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.whois_lookup.result.nameservers' => 'Nameservers',
    'tools.whois_lookup.result.registrar' => 'Registrar',
    'tools.whois_lookup.result.start_datetime' => 'Issued on',
    'tools.whois_lookup.result.end_datetime' => 'Expiring on',
    'tools.whois_lookup.result.updated_datetime' => 'Updated on',
    'tools.whois_lookup.extra_content' => '',

    'tools.ping.name' => 'Ping',
    'tools.ping.description' => 'Ping a website, server or port.',
    'tools.ping.meta_keywords' => '',
    'tools.ping.type' => 'Ping Protocol',
    'tools.ping.type_website' => 'HTTP(s)',
    'tools.ping.type_website_help' => 'Ideal for monitoring websites, APIs and web services.',
    'tools.ping.type_ping' => 'Ping (ICMP)',
    'tools.ping.type_ping_help' => 'Ideal for monitoring a server.',
    'tools.ping.type_port' => 'Host / Port',
    'tools.ping.type_port_help' => 'Ideal for monitoring databases, POP or SMTP servers.',
    'tools.ping.target_url' => 'URL',
    'tools.ping.target_host' => 'Host',
    'tools.ping.target_port' => 'Port',
    'tools.ping.error_message' => 'We could not retrieve any details for your given domain name.',
    'tools.ping.result.ping_server_id' => 'Ping Server',
    'tools.ping.result.is_ok' => 'Online',
    'tools.ping.result.is_not_ok' => 'Offline',
    'tools.ping.result.response_time' => 'Response time',
    'tools.ping.result.response_status_code' => 'Response status code',
    'tools.ping.result.error' => 'Error',
    'tools.ping.extra_content' => '',

    'tools.md5_generator.name' => 'MD5 generator',
    'tools.md5_generator.description' => 'Generate an MD5 hash of 32 characters length for any string input.',
    'tools.md5_generator.meta_keywords' => '',
    'tools.md5_generator.result' => 'MD5 Hash',
    'tools.md5_generator.extra_content' => '',

    'tools.md2_generator.name' => 'MD2 generator',
    'tools.md2_generator.description' => 'Generate an MD2 hash for any string input.',
    'tools.md2_generator.meta_keywords' => '',
    'tools.md2_generator.result' => 'MD2 Hash',
    'tools.md2_generator.extra_content' => '',

    'tools.md4_generator.name' => 'MD4 generator',
    'tools.md4_generator.description' => 'Generate an MD4 hash for any string input.',
    'tools.md4_generator.meta_keywords' => '',
    'tools.md4_generator.result' => 'MD4 Hash',
    'tools.md4_generator.extra_content' => '',

    'tools.whirlpool_generator.name' => 'Whirlpool generator',
    'tools.whirlpool_generator.description' => 'Generate a whirlpool hash for any string input.',
    'tools.whirlpool_generator.meta_keywords' => '',
    'tools.whirlpool_generator.result' => 'Whirlpool Hash',
    'tools.whirlpool_generator.extra_content' => '',

    'tools.sha1_generator.name' => 'SHA-1 generator',
    'tools.sha1_generator.description' => 'Generate a SHA-1 hash for any string input.',
    'tools.sha1_generator.meta_keywords' => '',
    'tools.sha1_generator.result' => 'SHA-1 Hash',
    'tools.sha1_generator.extra_content' => '',

    'tools.sha224_generator.name' => 'SHA-224 generator',
    'tools.sha224_generator.description' => 'Generate a SHA-224 hash for any string input.',
    'tools.sha224_generator.meta_keywords' => '',
    'tools.sha224_generator.result' => 'SHA-224 Hash',
    'tools.sha224_generator.extra_content' => '',

    'tools.sha256_generator.name' => 'SHA-256 generator',
    'tools.sha256_generator.description' => 'Generate a SHA-256 hash for any string input.',
    'tools.sha256_generator.meta_keywords' => '',
    'tools.sha256_generator.result' => 'SHA-256 Hash',
    'tools.sha256_generator.extra_content' => '',

    'tools.sha384_generator.name' => 'SHA-384 generator',
    'tools.sha384_generator.description' => 'Generate a SHA-384 hash for any string input.',
    'tools.sha384_generator.meta_keywords' => '',
    'tools.sha384_generator.result' => 'SHA-384 Hash',
    'tools.sha384_generator.extra_content' => '',

    'tools.sha512_generator.name' => 'SHA-512 generator',
    'tools.sha512_generator.description' => 'Generate a SHA-512 hash for any string input.',
    'tools.sha512_generator.meta_keywords' => '',
    'tools.sha512_generator.result' => 'SHA-512 Hash',
    'tools.sha512_generator.extra_content' => '',

    'tools.sha512_224_generator.name' => 'SHA-512/224 generator',
    'tools.sha512_224_generator.description' => 'Generate a SHA-512/224 hash for any string input.',
    'tools.sha512_224_generator.meta_keywords' => '',
    'tools.sha512_224_generator.result' => 'SHA-512/224 Hash',
    'tools.sha512_224_generator.extra_content' => '',

    'tools.sha512_256_generator.name' => 'SHA-512/256 generator',
    'tools.sha512_256_generator.description' => 'Generate a SHA-512/256 hash for any string input.',
    'tools.sha512_256_generator.meta_keywords' => '',
    'tools.sha512_256_generator.result' => 'SHA-512/256 Hash',
    'tools.sha512_256_generator.extra_content' => '',

    'tools.sha3_224_generator.name' => 'SHA-3/224 generator',
    'tools.sha3_224_generator.description' => 'Generate a SHA-3/224 hash for any string input.',
    'tools.sha3_224_generator.meta_keywords' => '',
    'tools.sha3_224_generator.result' => 'SHA-3/224 Hash',
    'tools.sha3_224_generator.extra_content' => '',

    'tools.sha3_256_generator.name' => 'SHA-3/256 generator',
    'tools.sha3_256_generator.description' => 'Generate a SHA-3/256 hash for any string input.',
    'tools.sha3_256_generator.meta_keywords' => '',
    'tools.sha3_256_generator.result' => 'SHA-3/256 Hash',
    'tools.sha3_256_generator.extra_content' => '',

    'tools.sha3_384_generator.name' => 'SHA-3/384 generator',
    'tools.sha3_384_generator.description' => 'Generate a SHA-3/384 hash for any string input.',
    'tools.sha3_384_generator.meta_keywords' => '',
    'tools.sha3_384_generator.result' => 'SHA-3/384 Hash',
    'tools.sha3_384_generator.extra_content' => '',

    'tools.sha3_512_generator.name' => 'SHA-3/512 generator',
    'tools.sha3_512_generator.description' => 'Generate a SHA-3/512 hash for any string input.',
    'tools.sha3_512_generator.meta_keywords' => '',
    'tools.sha3_512_generator.result' => 'SHA-3/512 Hash',
    'tools.sha3_512_generator.extra_content' => '',

    'tools.base64_encoder.name' => 'Base64 encoder',
    'tools.base64_encoder.description' => 'Encode any string input to Base64.',
    'tools.base64_encoder.meta_keywords' => '',
    'tools.base64_encoder.result' => 'Base64 encoded',
    'tools.base64_encoder.extra_content' => '',

    'tools.base64_decoder.name' => 'Base64 decoder',
    'tools.base64_decoder.description' => 'Decode Base64 input to back to string.',
    'tools.base64_decoder.meta_keywords' => '',
    'tools.base64_decoder.result' => 'Base64 decoded',
    'tools.base64_decoder.extra_content' => '',

    'tools.base64_to_image.name' => 'Base64 to Image',
    'tools.base64_to_image.description' => 'Decode Base64 input to an image.',
    'tools.base64_to_image.meta_keywords' => '',
    'tools.base64_to_image.result' => 'Image',
    'tools.base64_to_image.extra_content' => '',

    'tools.image_to_base64.name' => 'Image to Base64',
    'tools.image_to_base64.description' => 'Transform an image input to a Base64 string.',
    'tools.image_to_base64.meta_keywords' => '',
    'tools.image_to_base64.result' => 'Base64 encoded',
    'tools.image_to_base64.extra_content' => '',

    'tools.url_encoder.name' => 'URL encoder',
    'tools.url_encoder.description' => 'Encode any string input to URL format.',
    'tools.url_encoder.meta_keywords' => '',
    'tools.url_encoder.result' => 'URL encoded',
    'tools.url_encoder.extra_content' => '',

    'tools.url_decoder.name' => 'URL decoder',
    'tools.url_decoder.description' => 'Decode URL input to back to a normal string.',
    'tools.url_decoder.meta_keywords' => '',
    'tools.url_decoder.result' => 'URL decoded',
    'tools.url_decoder.extra_content' => '',

    'tools.lorem_ipsum_generator.name' => 'Lorem Ipsum generator',
    'tools.lorem_ipsum_generator.description' => 'Easily generate dummy text with the Lorem Ipsum generator.',
    'tools.lorem_ipsum_generator.meta_keywords' => '',
    'tools.lorem_ipsum_generator.amount' => 'Amount',
    'tools.lorem_ipsum_generator.paragraphs' => 'Paragraphs',
    'tools.lorem_ipsum_generator.sentences' => 'Sentences',
    'tools.lorem_ipsum_generator.words' => 'Words',
    'tools.lorem_ipsum_generator.extra_content' => '',

    'tools.markdown_to_html.name' => 'Markdown to HTML',
    'tools.markdown_to_html.description' => 'Convert markdown snippets to raw HTML code.',
    'tools.markdown_to_html.meta_keywords' => '',
    'tools.markdown_to_html.markdown' => 'Markdown',
    'tools.markdown_to_html.html' => 'HTML',
    'tools.markdown_to_html.extra_content' => '',

    'tools.case_converter.name' => 'Case converter',
    'tools.case_converter.description' => 'Convert your text to any kind of text case, such as lowercase, UPPERCASE, camelCase...etc.',
    'tools.case_converter.meta_keywords' => '',
    'tools.case_converter.lowercase' => 'lowercase',
    'tools.case_converter.uppercase' => 'UPPERCASE',
    'tools.case_converter.sentencecase' => 'Sentence case',
    'tools.case_converter.camelcase' => 'camelCase',
    'tools.case_converter.pascalcase' => 'PascalCase',
    'tools.case_converter.capitalcase' => 'Capital Case',
    'tools.case_converter.constantcase' => 'CONSTANT_CASE',
    'tools.case_converter.dotcase' => 'dot.case',
    'tools.case_converter.snakecase' => 'snake_case',
    'tools.case_converter.paramcase' => 'param-case',
    'tools.case_converter.extra_content' => '',

    'tools.random_number_generator.name' => 'Random number generator',
    'tools.random_number_generator.description' => 'Generate a random number between a given range.',
    'tools.random_number_generator.meta_keywords' => '',
    'tools.random_number_generator.minimum' => 'Minimum',
    'tools.random_number_generator.maximum' => 'Maximum',
    'tools.random_number_generator.result' => 'Number',
    'tools.random_number_generator.extra_content' => '',

    'tools.uuid_v4_generator.name' => 'UUID v4 generator',
    'tools.uuid_v4_generator.description' => 'Easily generate v4 UUID\'s (Universally unique identifier) with the help of our tool.',
    'tools.uuid_v4_generator.meta_keywords' => '',
    'tools.uuid_v4_generator.result' => 'UUID v4',
    'tools.uuid_v4_generator.extra_content' => '',

    'tools.bcrypt_generator.name' => 'Bcrypt generator',
    'tools.bcrypt_generator.description' => 'Generate a bcrypt password hash for any string input.',
    'tools.bcrypt_generator.meta_keywords' => '',
    'tools.bcrypt_generator.result' => 'Bcrypt Hash',
    'tools.bcrypt_generator.extra_content' => '',

    'tools.password_generator.name' => 'Password generator',
    'tools.password_generator.description' => 'Generate passwords with custom length and custom settings.',
    'tools.password_generator.meta_keywords' => '',
    'tools.password_generator.characters' => 'Characters',
    'tools.password_generator.numbers' => 'Include numbers',
    'tools.password_generator.symbols' => 'Include symbols',
    'tools.password_generator.lowercase' => 'Include lowercase characters',
    'tools.password_generator.uppercase' => 'Include UPPERCASE characters',
    'tools.password_generator.extra_content' => '',

    'tools.password_strength_checker.name' => 'Password strength checker',
    'tools.password_strength_checker.description' => 'Make sure your passwords are good enough.',
    'tools.password_strength_checker.meta_keywords' => '',
    'tools.password_strength_checker.characters' => 'Characters',
    'tools.password_strength_checker.strength' => 'Strength',
    'tools.password_strength_checker.strength.no_data' => 'No data',
    'tools.password_strength_checker.strength.very_low' => 'Very low',
    'tools.password_strength_checker.strength.low' => 'Low',
    'tools.password_strength_checker.strength.moderate' => 'Moderate',
    'tools.password_strength_checker.strength.strong' => 'Strong',
    'tools.password_strength_checker.extra_content' => '',

    'tools.slug_generator.name' => 'Slug generator',
    'tools.slug_generator.description' => 'Generate a URL slug for any string input.',
    'tools.slug_generator.meta_keywords' => '',
    'tools.slug_generator.result' => 'Slug',
    'tools.slug_generator.extra_content' => '',

    'tools.html_minifier.name' => 'HTML minifier',
    'tools.html_minifier.description' => 'Minify your HTML by removing all the unnecessary characters.',
    'tools.html_minifier.meta_keywords' => '',
    'tools.html_minifier.html' => 'HTML',
    'tools.html_minifier.error_message' => 'We could not process your HTML content.',
    'tools.html_minifier.result' => 'Minified HTML',
    'tools.html_minifier.result.html_characters' => 'HTML characters',
    'tools.html_minifier.result.minified_html_characters' => 'Minified HTML characters',
    'tools.html_minifier.extra_content' => '',

    'tools.css_minifier.name' => 'CSS minifier',
    'tools.css_minifier.description' => 'Minify your CSS by removing all the unnecessary characters.',
    'tools.css_minifier.meta_keywords' => '',
    'tools.css_minifier.css' => 'CSS',
    'tools.css_minifier.error_message' => 'We could not process your CSS content.',
    'tools.css_minifier.result' => 'Minified CSS',
    'tools.css_minifier.result.css_characters' => 'CSS characters',
    'tools.css_minifier.result.minified_css_characters' => 'Minified CSS characters',
    'tools.css_minifier.extra_content' => '',

    'tools.js_minifier.name' => 'JS minifier',
    'tools.js_minifier.description' => 'Minify your JS by removing all the unnecessary characters.',
    'tools.js_minifier.meta_keywords' => '',
    'tools.js_minifier.js' => 'JS',
    'tools.js_minifier.error_message' => 'We could not process your JS content.',
    'tools.js_minifier.result' => 'Minified JS',
    'tools.js_minifier.result.js_characters' => 'JS characters',
    'tools.js_minifier.result.minified_js_characters' => 'Minified JS characters',
    'tools.js_minifier.extra_content' => '',

    'tools.user_agent_parser.name' => 'User agent parser',
    'tools.user_agent_parser.description' => 'Parse details from user agent strings.',
    'tools.user_agent_parser.meta_keywords' => '',
    'tools.user_agent_parser.user_agent' => 'User agent',
    'tools.user_agent_parser.result.browser' => 'Browser',
    'tools.user_agent_parser.result.os' => 'Operating system',
    'tools.user_agent_parser.result.device_type' => 'Device type',
    'tools.user_agent_parser.extra_content' => '',

    'tools.website_hosting_checker.name' => 'Website hosting checker',
    'tools.website_hosting_checker.description' => 'Get the web-host of a given website.',
    'tools.website_hosting_checker.meta_keywords' => '',
    'tools.website_hosting_checker.host' => 'Host',
    'tools.website_hosting_checker.error_message' => 'We could not retrieve any details for your given host.',
    'tools.website_hosting_checker.result.isp' => 'ISP',
    'tools.website_hosting_checker.result.org' => 'Organization',
    'tools.website_hosting_checker.result.latitude' => 'Latitude',
    'tools.website_hosting_checker.result.longitude' => 'Longitude',
    'tools.website_hosting_checker.result.timezone' => 'Timezone',
    'tools.website_hosting_checker.extra_content' => '',

    'tools.file_mime_type_checker.name' => 'File mime type checker',
    'tools.file_mime_type_checker.description' => 'Get details of any file type, such as the mime type or last edit date.',
    'tools.file_mime_type_checker.meta_keywords' => '',
    'tools.file_mime_type_checker.file' => 'File',
    'tools.file_mime_type_checker.file_type' => 'Type',
    'tools.file_mime_type_checker.file_size' => 'Size',
    'tools.file_mime_type_checker.file_name' => 'Name',
    'tools.file_mime_type_checker.file_last_modified_date' => 'Last modified date',
    'tools.file_mime_type_checker.error_message' => 'We could not retrieve any details for your given host.',
    'tools.file_mime_type_checker.extra_content' => '',

    'tools.gravatar_checker.name' => 'Gravatar checker',
    'tools.gravatar_checker.description' => 'Get the gravatar.com globally recognized avatar for any email.',
    'tools.gravatar_checker.meta_keywords' => '',
    'tools.gravatar_checker.result.mp' => 'Mistery person',
    'tools.gravatar_checker.result.monsterid' => 'Monsterid',
    'tools.gravatar_checker.result.identicon' => 'Identicon',
    'tools.gravatar_checker.result.wavatar' => 'Wavatar',
    'tools.gravatar_checker.result.retro' => 'Mistery person',
    'tools.gravatar_checker.result.robohash' => 'Robohash',
    'tools.gravatar_checker.result.blank' => 'Blank',
    'tools.gravatar_checker.open' => 'Open',
    'tools.gravatar_checker.extra_content' => '',

    'tools.character_counter.name' => 'Character counter',
    'tools.character_counter.description' => 'Count the amount of characters and words of a given text.',
    'tools.character_counter.meta_keywords' => '',
    'tools.character_counter.result.characters' => 'Characters',
    'tools.character_counter.result.words' => 'Words',
    'tools.character_counter.result.lines' => 'Lines',
    'tools.character_counter.extra_content' => '',

    'tools.list_randomizer.name' => 'List randomizer',
    'tools.list_randomizer.description' => 'Easily convert a list of given text into a randomized list.',
    'tools.list_randomizer.meta_keywords' => '',
    'tools.list_randomizer.result' => 'Randomized',
    'tools.list_randomizer.extra_content' => '',

    'tools.reverse_words.name' => 'Reverse words',
    'tools.reverse_words.description' => 'Reverse the words in a given sentence or paragraph with ease.',
    'tools.reverse_words.meta_keywords' => '',
    'tools.reverse_words.result' => 'Reversed',
    'tools.reverse_words.extra_content' => '',

    'tools.reverse_letters.name' => 'Reverse letters',
    'tools.reverse_letters.description' => 'Reverse the letters in a given sentence or paragraph with ease.',
    'tools.reverse_letters.meta_keywords' => '',
    'tools.reverse_letters.result' => 'Reversed',
    'tools.reverse_letters.extra_content' => '',

    'tools.emojis_remover.name' => 'Emojis remover',
    'tools.emojis_remover.description' => 'Remove all the emojis from any given text with ease.',
    'tools.emojis_remover.meta_keywords' => '',
    'tools.emojis_remover.result' => 'Text without emojis',
    'tools.emojis_remover.extra_content' => '',

    'tools.reverse_list.name' => 'Reverse list',
    'tools.reverse_list.description' => 'Reverse a list of given text lines.',
    'tools.reverse_list.meta_keywords' => '',
    'tools.reverse_list.result' => 'Reversed',
    'tools.reverse_list.extra_content' => '',

    'tools.list_alphabetizer.name' => 'List alphabetizer',
    'tools.list_alphabetizer.description' => 'Order text lines in alphabetical order (A-Z or Z-A) with ease.',
    'tools.list_alphabetizer.meta_keywords' => '',
    'tools.list_alphabetizer.result' => 'Alphabetized',
    'tools.list_alphabetizer.extra_content' => '',

    'tools.upside_down_text_generator.name' => 'Upside down text generator',
    'tools.upside_down_text_generator.description' => 'Flip, upside down text with ease.',
    'tools.upside_down_text_generator.meta_keywords' => '',
    'tools.upside_down_text_generator.reverse' => 'Reverse text',
    'tools.upside_down_text_generator.result' => 'Flipped',
    'tools.upside_down_text_generator.extra_content' => '',

    'tools.old_english_text_generator.name' => 'Old English text generator',
    'tools.old_english_text_generator.description' => 'Convert normal text to old english font type.',
    'tools.old_english_text_generator.meta_keywords' => '',
    'tools.old_english_text_generator.result' => 'Old English',
    'tools.old_english_text_generator.extra_content' => '',

    'tools.cursive_text_generator.name' => 'Cursive text generator',
    'tools.cursive_text_generator.description' => 'Convert normal text to cursive font type.',
    'tools.cursive_text_generator.meta_keywords' => '',
    'tools.cursive_text_generator.result' => 'Cursive text',
    'tools.cursive_text_generator.extra_content' => '',

    'tools.palindrome_checker.name' => 'Palindrome checker',
    'tools.palindrome_checker.description' => 'Check if a given word of phrase is palindrome (if it reads the same backwards as forward).',
    'tools.palindrome_checker.meta_keywords' => '',
    'tools.palindrome_checker.extra_content' => '',

    'tools.url_parser.name' => 'URL parser',
    'tools.url_parser.description' => 'Parse details from any URLs.',
    'tools.url_parser.meta_keywords' => '',
    'tools.url_parser.result.scheme' => 'Scheme',
    'tools.url_parser.result.path' => 'Path',
    'tools.url_parser.result.query' => 'Query',
    'tools.url_parser.extra_content' => '',

    'tools.color_converter.name' => 'Color converter',
    'tools.color_converter.description' => 'Convert your color to multiple other formats.',
    'tools.color_converter.meta_keywords' => '',
    'tools.color_converter.color' => 'Color',
    'tools.color_converter.color_help' => 'Accepted formats: HEX, HEX alpha, RGB, RGBA, HSV, HSL, HSLA.',
    'tools.color_converter.hex' => 'HEX',
    'tools.color_converter.hexa' => 'HEX Alpha',
    'tools.color_converter.rgb' => 'RGB',
    'tools.color_converter.rgba' => 'RGBA',
    'tools.color_converter.hsv' => 'HSV',
    'tools.color_converter.hsl' => 'HSL',
    'tools.color_converter.hsla' => 'HSLA',
    'tools.color_converter.error_message' => 'No valid color format was detected.',
    'tools.color_converter.extra_content' => '',

    'tools.http_headers_lookup.name' => 'HTTP headers lookup',
    'tools.http_headers_lookup.description' => 'Get all the HTTP headers that an URL returns for a typical GET request.',
    'tools.http_headers_lookup.meta_keywords' => '',
    'tools.http_headers_lookup.error_message' => 'We could not get any information for your entered URL.',
    'tools.http_headers_lookup.extra_content' => '',

    'tools.http2_checker.name' => 'HTTP/2 Checker',
    'tools.http2_checker.description' => 'Check whether a website is using the new HTTP/2 protocol or not.',
    'tools.http2_checker.meta_keywords' => '',
    'tools.http2_checker.error_message' => 'We could not get any information for your entered URL.',
    'tools.http2_checker.success_message.disabled' => 'HTTP/2 is disabled.',
    'tools.http2_checker.success_message.enabled' => 'HTTP/2 is enabled.',
    'tools.http2_checker.extra_content' => '',

    'tools.brotli_checker.name' => 'Brotli Checker',
    'tools.brotli_checker.description' => 'Check whether a website is using the Brotli Compression algorithm or not.',
    'tools.brotli_checker.meta_keywords' => '',
    'tools.brotli_checker.error_message' => 'We could not get any information for your entered URL.',
    'tools.brotli_checker.success_message.disabled' => 'Brotli is disabled.',
    'tools.brotli_checker.success_message.enabled' => 'Brotli is enabled.',
    'tools.brotli_checker.extra_content' => '',

    'tools.duplicate_lines_remover.name' => 'Duplicate lines remover',
    'tools.duplicate_lines_remover.description' => 'Easily remove duplicate lines from a text.',
    'tools.duplicate_lines_remover.meta_keywords' => '',
    'tools.duplicate_lines_remover.result.lines' => 'Lines',
    'tools.duplicate_lines_remover.result.new_lines' => 'New lines',
    'tools.duplicate_lines_remover.result.removed_lines' => 'Removed lines',
    'tools.duplicate_lines_remover.extra_content' => '',

    'tools.text_to_speech.name' => 'Text to speech',
    'tools.text_to_speech.description' => 'Use the Google translator API to generate text to speech audio.',
    'tools.text_to_speech.meta_keywords' => '',
    'tools.text_to_speech.language_code' => 'Language code',
    'tools.text_to_speech.extra_content' => '',

    'tools.idn_punnycode_converter.name' => 'IDN Punnycode converter',
    'tools.idn_punnycode_converter.description' => 'Easily convert IDN to Punnycode and back.',
    'tools.idn_punnycode_converter.meta_keywords' => '',
    'tools.idn_punnycode_converter.to_punnycode' => 'Convert to Punnycode/ASCII',
    'tools.idn_punnycode_converter.to_idn' => 'Convert to IDN/Text',
    'tools.idn_punnycode_converter.result.punnycode' => 'Punnycode/ASCII',
    'tools.idn_punnycode_converter.result.idn' => 'IDN/Text',
    'tools.idn_punnycode_converter.extra_content' => '',

    'tools.json_validator_beautifier.name' => 'JSON validator & beautifier',
    'tools.json_validator_beautifier.description' => 'Validate JSON content and make it looks good.',
    'tools.json_validator_beautifier.meta_keywords' => '',
    'tools.json_validator_beautifier.json' => 'JSON',
    'tools.json_validator_beautifier.error_message' => 'JSON content is invalid.',
    'tools.json_validator_beautifier.success_message' => 'JSON content is valid.',
    'tools.json_validator_beautifier.extra_content' => '',

    'tools.qr_code_reader.name' => 'QR code reader',
    'tools.qr_code_reader.description' => 'Upload a QR code image and extract the data out of it.',
    'tools.qr_code_reader.meta_keywords' => '',
    'tools.qr_code_reader.image' => 'QR code image',
    'tools.qr_code_reader.result' => 'Data',
    'tools.qr_code_reader.extra_content' => '',

    'tools.barcode_reader.name' => 'Barcode reader',
    'tools.barcode_reader.description' => 'Upload a Barcode image and extract the data out of it.',
    'tools.barcode_reader.meta_keywords' => '',
    'tools.barcode_reader.image' => 'Barcode image',
    'tools.barcode_reader.result' => 'Data',
    'tools.barcode_reader.extra_content' => '',

    'tools.meta_tags_checker.name' => 'Meta tags checker',
    'tools.meta_tags_checker.description' => 'Get & verify the meta tags of any website.',
    'tools.meta_tags_checker.meta_keywords' => '',
    'tools.meta_tags_checker.error_message' => 'We could not retrieve any details for your given URL.',
    'tools.meta_tags_checker.extra_content' => '',

    'tools.exif_reader.name' => 'Exif reader',
    'tools.exif_reader.description' => 'Upload a image and extract the data out of it.',
    'tools.exif_reader.meta_keywords' => '',
    'tools.exif_reader.result' => 'Data',
    'tools.exif_reader.result.no_data' => 'No data found.',
    'tools.exif_reader.extra_content' => '',

    'tools.color_picker.name' => 'Color picker',
    'tools.color_picker.description' => 'The easiest way to select a color from the color wheel and get the results in any format.',
    'tools.color_picker.meta_keywords' => '',
    'tools.color_picker.color' => 'Color',
    'tools.color_picker.extra_content' => '',

    'tools.sql_beautifier.name' => 'SQL formatter/beautifier',
    'tools.sql_beautifier.description' => 'Format & beautify your SQL code with ease.',
    'tools.sql_beautifier.meta_keywords' => '',
    'tools.sql_beautifier.sql' => 'SQL',
    'tools.sql_beautifier.result' => 'Beautified SQL',
    'tools.sql_beautifier.extra_content' => '',

    'tools.html_entity_converter.name' => 'HTML entity converter',
    'tools.html_entity_converter.description' => 'Encode or decode HTML entities for any given input.',
    'tools.html_entity_converter.meta_keywords' => '',
    'tools.html_entity_converter.encode' => 'Encode',
    'tools.html_entity_converter.decode' => 'Decode',
    'tools.html_entity_converter.result.encoded' => 'HTML entity encoded',
    'tools.html_entity_converter.result.decoded' => 'HTML entity decoded',
    'tools.html_entity_converter.extra_content' => '',

    'tools.binary_converter.name' => 'Binary converter',
    'tools.binary_converter.description' => 'Convert text to binary and the other way for any string input.',
    'tools.binary_converter.meta_keywords' => '',
    'tools.binary_converter.to_binary' => 'To binary',
    'tools.binary_converter.to_text' => 'To text',
    'tools.binary_converter.result.binary' => 'Binary',
    'tools.binary_converter.extra_content' => '',

    'tools.hex_converter.name' => 'Hex converter',
    'tools.hex_converter.description' => 'Convert text to hexadecimal and the other way for any string input.',
    'tools.hex_converter.meta_keywords' => '',
    'tools.hex_converter.to_hex' => 'To hex',
    'tools.hex_converter.to_text' => 'To text',
    'tools.hex_converter.result.hex' => 'Hex',
    'tools.hex_converter.extra_content' => '',

    'tools.ascii_converter.name' => 'Ascii converter',
    'tools.ascii_converter.description' => 'Convert text to ascii and the other way for any string input.',
    'tools.ascii_converter.meta_keywords' => '',
    'tools.ascii_converter.to_ascii' => 'To ascii',
    'tools.ascii_converter.to_text' => 'To text',
    'tools.ascii_converter.result.ascii' => 'Ascii',
    'tools.ascii_converter.extra_content' => '',

    'tools.decimal_converter.name' => 'Decimal converter',
    'tools.decimal_converter.description' => 'Convert text to decimal and the other way for any string input.',
    'tools.decimal_converter.meta_keywords' => '',
    'tools.decimal_converter.to_decimal' => 'To decimal',
    'tools.decimal_converter.to_text' => 'To text',
    'tools.decimal_converter.result.decimal' => 'Decimal',
    'tools.decimal_converter.extra_content' => '',

    'tools.octal_converter.name' => 'Octal converter',
    'tools.octal_converter.description' => 'Convert text to octal and the other way for any string input.',
    'tools.octal_converter.meta_keywords' => '',
    'tools.octal_converter.to_octal' => 'To octal',
    'tools.octal_converter.to_text' => 'To text',
    'tools.octal_converter.result.octal' => 'Octal',
    'tools.octal_converter.extra_content' => '',

    'tools.morse_converter.name' => 'Morse converter',
    'tools.morse_converter.description' => 'Convert text to morse and the other way for any string input.',
    'tools.morse_converter.meta_keywords' => '',
    'tools.morse_converter.to_morse' => 'To morse',
    'tools.morse_converter.to_text' => 'To text',
    'tools.morse_converter.result.morse' => 'Morse',
    'tools.morse_converter.extra_content' => '',

    'tools.number_to_words_converter.name' => 'Number to words converter',
    'tools.number_to_words_converter.description' => 'Convert a number to written, spelled out words.',
    'tools.number_to_words_converter.meta_keywords' => '',
    'tools.number_to_words_converter.number' => 'Number',
    'tools.number_to_words_converter.extra_content' => '',

    'tools.mailto_link_generator.name' => 'Mailto link generator',
    'tools.mailto_link_generator.description' => 'Generate deep link mailto with subject, body, cc, bcc & get the HTML code as well.',
    'tools.mailto_link_generator.meta_keywords' => '',
    'tools.mailto_link_generator.to' => 'To email',
    'tools.mailto_link_generator.cc' => 'CC',
    'tools.mailto_link_generator.bcc' => 'BCC',
    'tools.mailto_link_generator.subject' => 'Subject',
    'tools.mailto_link_generator.body' => 'Body content',
    'tools.mailto_link_generator.extra_content' => '',

    'tools.youtube_thumbnail_downloader.name' => 'YouTube thumbnail downloader',
    'tools.youtube_thumbnail_downloader.description' => 'Easily download any YouTube video thumbnail in all the available sizes.',
    'tools.youtube_thumbnail_downloader.meta_keywords' => '',
    'tools.youtube_thumbnail_downloader.url' => 'YouTube video URL',
    'tools.youtube_thumbnail_downloader.invalid_url' => 'Invalid YouTube video URL.',
    'tools.youtube_thumbnail_downloader.result.default' => 'Default (120x90)',
    'tools.youtube_thumbnail_downloader.result.hqdefault' => 'High (480x360)',
    'tools.youtube_thumbnail_downloader.result.mqdefault' => 'Medium (320x180)',
    'tools.youtube_thumbnail_downloader.result.sddefault' => 'SD (640x480)',
    'tools.youtube_thumbnail_downloader.result.maxresdefault' => 'HD (1280x720)',
    'tools.youtube_thumbnail_downloader.open' => 'Open',
    'tools.youtube_thumbnail_downloader.extra_content' => '',

    'tools.safe_url_checker.name' => 'Safe URL checker',
    'tools.safe_url_checker.description' => 'Check if the URL is banned and marked as safe/unsafe by Google.',
    'tools.safe_url_checker.meta_keywords' => '',
    'tools.safe_url_checker.result.safe' => 'Your URL is marked as safe.',
    'tools.safe_url_checker.result.unsafe' => 'Your URL is marked as unsafe.',
    'tools.safe_url_checker.extra_content' => '',

    'tools.utm_link_generator.name' => 'UTM link generator',
    'tools.utm_link_generator.description' => 'Easily add UTM valid parameters and generate a UTM trackable link.',
    'tools.utm_link_generator.meta_keywords' => '',
    'tools.utm_link_generator.utm_source' => 'UTM Source',
    'tools.utm_link_generator.utm_medium' => 'UTM Medium',
    'tools.utm_link_generator.utm_campaign' => 'UTM Campaign',
    'tools.utm_link_generator.utm_content' => 'UTM Content',
    'tools.utm_link_generator.utm_term' => 'UTM Term',
    'tools.utm_link_generator.extra_content' => '',

    'tools.whatsapp_link_generator.name' => 'WhatsApp link generator',
    'tools.whatsapp_link_generator.description' => 'Generate whatsapp message links with ease.',
    'tools.whatsapp_link_generator.meta_keywords' => '',
    'tools.whatsapp_link_generator.phone' => 'Phone number',
    'tools.whatsapp_link_generator.prefilled_message' => 'Prefilled message',
    'tools.whatsapp_link_generator.prefilled_message_help' => 'Messages on WhatsApp can be also formatted, <a href="https://faq.whatsapp.com/general/chats/how-to-format-your-messages/?lang=en">learn more</a>.',
    'tools.whatsapp_link_generator.extra_content' => '',

    'tools.youtube_timestamp_link_generator.name' => 'YouTube Timestamp link generator',
    'tools.youtube_timestamp_link_generator.description' => 'Generated youtube links with exact start timestamp, helpful for mobile users.',
    'tools.youtube_timestamp_link_generator.meta_keywords' => '',
    'tools.youtube_timestamp_link_generator.url' => 'YouTube video URL',
    'tools.youtube_timestamp_link_generator.start_minute' => 'Min',
    'tools.youtube_timestamp_link_generator.extra_content' => '',

    'tools.google_cache_checker.name' => 'Google cache checker',
    'tools.google_cache_checker.description' => 'Check if the URL is cached or not by Google.',
    'tools.google_cache_checker.meta_keywords' => '',
    'tools.google_cache_checker.result.cached' => 'This URL is cached (%s).',
    'tools.google_cache_checker.result.not_cached' => 'This URL is not cached.',
    'tools.google_cache_checker.error_message' => 'We could not retrieve any details for your given URL.',
    'tools.google_cache_checker.extra_content' => '',

    'tools.url_redirect_checker.name' => 'URL redirect checker',
    'tools.url_redirect_checker.description' => 'Check for 301 & 302 redirects of a specific URL. It will check for up to 10 redirects.',
    'tools.url_redirect_checker.meta_keywords' => '',
    'tools.url_redirect_checker.status_code' => 'Status code',
    'tools.url_redirect_checker.error_message' => 'We could not retrieve any details for your given URL.',
    'tools.url_redirect_checker.extra_content' => '',

    'tools.image_optimizer.name' => 'Image optimizer',
    'tools.image_optimizer.description' => 'Compress and optimize images for a smaller image size but still high quality.',
    'tools.image_optimizer.meta_keywords' => '',
    'tools.image_optimizer.result.original_size' => 'Original size',
    'tools.image_optimizer.result.new_size' => 'New size',
    'tools.image_optimizer.open' => 'Open',
    'tools.image_optimizer.error_message' => 'We could not process your given image at this moment in time.',
    'tools.image_optimizer.extra_content' => '',

    'tools.png_to_jpg.name' => 'PNG to JPG',
    'tools.png_to_jpg.description' => 'Easily convert PNG image files to JPG.',
    'tools.png_to_jpg.meta_keywords' => '',
    'tools.png_to_jpg.extra_content' => '',

    'tools.png_to_webp.name' => 'PNG to WEBP',
    'tools.png_to_webp.description' => 'Easily convert PNG image files to WEBP.',
    'tools.png_to_webp.meta_keywords' => '',
    'tools.png_to_webp.extra_content' => '',

    'tools.png_to_bmp.name' => 'PNG to BMP',
    'tools.png_to_bmp.description' => 'Easily convert PNG image files to BMP.',
    'tools.png_to_bmp.meta_keywords' => '',
    'tools.png_to_bmp.extra_content' => '',

    'tools.png_to_gif.name' => 'PNG to GIF',
    'tools.png_to_gif.description' => 'Easily convert PNG image files to GIF.',
    'tools.png_to_gif.meta_keywords' => '',
    'tools.png_to_gif.extra_content' => '',

    'tools.png_to_ico.name' => 'PNG to ICO',
    'tools.png_to_ico.description' => 'Easily convert PNG image files to ICO.',
    'tools.png_to_ico.meta_keywords' => '',
    'tools.png_to_ico.extra_content' => '',

    'tools.jpg_to_png.name' => 'JPG to PNG',
    'tools.jpg_to_png.description' => 'Easily convert JPG image files to PNG.',
    'tools.jpg_to_png.meta_keywords' => '',
    'tools.jpg_to_png.extra_content' => '',

    'tools.jpg_to_webp.name' => 'JPG to WEBP',
    'tools.jpg_to_webp.description' => 'Easily convert JPG image files to WEBP.',
    'tools.jpg_to_webp.meta_keywords' => '',
    'tools.jpg_to_webp.extra_content' => '',

    'tools.jpg_to_bmp.name' => 'JPG to BMP',
    'tools.jpg_to_bmp.description' => 'Easily convert JPG image files to BMP.',
    'tools.jpg_to_bmp.meta_keywords' => '',
    'tools.jpg_to_bmp.extra_content' => '',

    'tools.jpg_to_gif.name' => 'JPG to GIF',
    'tools.jpg_to_gif.description' => 'Easily convert JPG image files to GIF.',
    'tools.jpg_to_gif.meta_keywords' => '',
    'tools.jpg_to_gif.extra_content' => '',

    'tools.jpg_to_ico.name' => 'JPG to ICO',
    'tools.jpg_to_ico.description' => 'Easily convert JPG image files to ICO.',
    'tools.jpg_to_ico.meta_keywords' => '',
    'tools.jpg_to_ico.extra_content' => '',

    'tools.webp_to_png.name' => 'WEBP to PNG',
    'tools.webp_to_png.description' => 'Easily convert WEBP image files to PNG.',
    'tools.webp_to_png.meta_keywords' => '',
    'tools.webp_to_png.extra_content' => '',

    'tools.webp_to_jpg.name' => 'WEBP to JPG',
    'tools.webp_to_jpg.description' => 'Easily convert WEBP image files to JPG.',
    'tools.webp_to_jpg.meta_keywords' => '',
    'tools.webp_to_jpg.extra_content' => '',

    'tools.webp_to_ico.name' => 'WEBP to ICO',
    'tools.webp_to_ico.description' => 'Easily convert WEBP image files to ICO.',
    'tools.webp_to_ico.meta_keywords' => '',
    'tools.webp_to_ico.extra_content' => '',

    'tools.webp_to_bmp.name' => 'WEBP to BMP',
    'tools.webp_to_bmp.description' => 'Easily convert WEBP image files to BMP.',
    'tools.webp_to_bmp.meta_keywords' => '',
    'tools.webp_to_bmp.extra_content' => '',

    'tools.webp_to_gif.name' => 'WEBP to GIF',
    'tools.webp_to_gif.description' => 'Easily convert WEBP image files to GIF.',
    'tools.webp_to_gif.meta_keywords' => '',
    'tools.webp_to_gif.extra_content' => '',

    'tools.bmp_to_png.name' => 'BMP to PNG',
    'tools.bmp_to_png.description' => 'Easily convert BMP image files to PNG.',
    'tools.bmp_to_png.meta_keywords' => '',
    'tools.bmp_to_png.extra_content' => '',

    'tools.bmp_to_jpg.name' => 'BMP to JPG',
    'tools.bmp_to_jpg.description' => 'Easily convert BMP image files to JPG.',
    'tools.bmp_to_jpg.meta_keywords' => '',
    'tools.bmp_to_jpg.extra_content' => '',

    'tools.bmp_to_ico.name' => 'BMP to ICO',
    'tools.bmp_to_ico.description' => 'Easily convert BMP image files to ICO.',
    'tools.bmp_to_ico.meta_keywords' => '',
    'tools.bmp_to_ico.extra_content' => '',

    'tools.bmp_to_webp.name' => 'BMP to WEBP',
    'tools.bmp_to_webp.description' => 'Easily convert BMP image files to WEBP.',
    'tools.bmp_to_webp.meta_keywords' => '',
    'tools.bmp_to_webp.extra_content' => '',

    'tools.bmp_to_gif.name' => 'BMP to GIF',
    'tools.bmp_to_gif.description' => 'Easily convert BMP image files to GIF.',
    'tools.bmp_to_gif.meta_keywords' => '',
    'tools.bmp_to_gif.extra_content' => '',

    'tools.ico_to_png.name' => 'ICO to PNG',
    'tools.ico_to_png.description' => 'Easily convert ICO image files to PNG.',
    'tools.ico_to_png.meta_keywords' => '',
    'tools.ico_to_png.extra_content' => '',

    'tools.ico_to_jpg.name' => 'ICO to JPG',
    'tools.ico_to_jpg.description' => 'Easily convert ICO image files to JPG.',
    'tools.ico_to_jpg.meta_keywords' => '',
    'tools.ico_to_jpg.extra_content' => '',

    'tools.ico_to_bmp.name' => 'ICO to BMP',
    'tools.ico_to_bmp.description' => 'Easily convert ICO image files to BMP.',
    'tools.ico_to_bmp.meta_keywords' => '',
    'tools.ico_to_bmp.extra_content' => '',

    'tools.ico_to_webp.name' => 'ICO to WEBP',
    'tools.ico_to_webp.description' => 'Easily convert ICO image files to WEBP.',
    'tools.ico_to_webp.meta_keywords' => '',
    'tools.ico_to_webp.extra_content' => '',

    'tools.ico_to_gif.name' => 'ICO to GIF',
    'tools.ico_to_gif.description' => 'Easily convert ICO image files to GIF.',
    'tools.ico_to_gif.meta_keywords' => '',
    'tools.ico_to_gif.extra_content' => '',

    'tools.gif_to_png.name' => 'GIF to PNG',
    'tools.gif_to_png.description' => 'Easily convert GIF image files to PNG.',
    'tools.gif_to_png.meta_keywords' => '',
    'tools.gif_to_png.extra_content' => '',

    'tools.gif_to_jpg.name' => 'GIF to JPG',
    'tools.gif_to_jpg.description' => 'Easily convert GIF image files to JPG.',
    'tools.gif_to_jpg.meta_keywords' => '',
    'tools.gif_to_jpg.extra_content' => '',

    'tools.gif_to_bmp.name' => 'GIF to BMP',
    'tools.gif_to_bmp.description' => 'Easily convert GIF image files to BMP.',
    'tools.gif_to_bmp.meta_keywords' => '',
    'tools.gif_to_bmp.extra_content' => '',

    'tools.gif_to_webp.name' => 'GIF to WEBP',
    'tools.gif_to_webp.description' => 'Easily convert GIF image files to WEBP.',
    'tools.gif_to_webp.meta_keywords' => '',
    'tools.gif_to_webp.extra_content' => '',

    'tools.gif_to_ico.name' => 'GIF to ICO',
    'tools.gif_to_ico.description' => 'Easily convert GIF image files to ICO.',
    'tools.gif_to_ico.meta_keywords' => '',
    'tools.gif_to_ico.extra_content' => '',

    'tools.text_separator.name' => 'Text separator',
    'tools.text_separator.description' => 'Separate text back and forth by new lines, commas, dots...etc.',
    'tools.text_separator.meta_keywords' => '',
    'tools.text_separator.separated_by' => 'Currently separated by',
    'tools.text_separator.separate_by' => 'Separate by',
    'tools.text_separator.new_line' => 'New line',
    'tools.text_separator.space' => 'Space',
    'tools.text_separator.extra_content' => '',

    'tools.email_extractor.name' => 'Email extractor',
    'tools.email_extractor.description' => 'Extract email addresses from any kind of text content.',
    'tools.email_extractor.meta_keywords' => '',
    'tools.email_extractor.result.count' => 'Count',
    'tools.email_extractor.extra_content' => '',

    'tools.url_extractor.name' => 'URL extractor',
    'tools.url_extractor.description' => 'Extract http/https URLs from any kind of text content.',
    'tools.url_extractor.meta_keywords' => '',
    'tools.url_extractor.result.count' => 'Count',
    'tools.url_extractor.extra_content' => '',

    'tools.text_size_calculator.name' => 'Text size calculator',
    'tools.text_size_calculator.description' => 'Get the size of a text in Bytes (B), Kilobytes (KB) or Megabytes (MB).',
    'tools.text_size_calculator.meta_keywords' => '',
    'tools.text_size_calculator.result' => 'Size',
    'tools.text_size_calculator.extra_content' => '',

    'tools.paypal_link_generator.name' => 'PayPal link generator',
    'tools.paypal_link_generator.description' => 'Generate a paypal payment link with ease.',
    'tools.paypal_link_generator.meta_keywords' => '',
    'tools.paypal_link_generator.type.buy_now' => 'Buy now',
    'tools.paypal_link_generator.type.add_to_cart' => 'Add to cart',
    'tools.paypal_link_generator.type.donation' => 'Donation',
    'tools.paypal_link_generator.email' => 'PayPal email',
    'tools.paypal_link_generator.title' => 'Title',
    'tools.paypal_link_generator.currency' => 'Currency code',
    'tools.paypal_link_generator.price' => 'Price',
    'tools.paypal_link_generator.thank_you_url' => 'Thank you URL',
    'tools.paypal_link_generator.cancel_url' => 'Cancel URL',
    'tools.paypal_link_generator.extra_content' => '',

    'tools.bbcode_to_html.name' => 'BBCode to HTML',
    'tools.bbcode_to_html.description' => 'Convert forum type bbcode snippets to raw HTML code.',
    'tools.bbcode_to_html.meta_keywords' => '',
    'tools.bbcode_to_html.bbcode' => 'BBCode',
    'tools.bbcode_to_html.html' => 'HTML',
    'tools.bbcode_to_html.extra_content' => '',

    'tools.html_tags_remover.name' => 'HTML tags remover',
    'tools.html_tags_remover.description' => 'Easily remove all HTML tags from a block of text.',
    'tools.html_tags_remover.meta_keywords' => '',
    'tools.html_tags_remover.extra_content' => '',

    'tools.unix_timestamp_to_date.name' => 'Unix Timestamp to Date',
    'tools.unix_timestamp_to_date.description' => 'Convert a unix timestamp to UTC and your local date.',
    'tools.unix_timestamp_to_date.meta_keywords' => '',
    'tools.unix_timestamp_to_date.unix_timestamp' => 'Unix timestamp',
    'tools.unix_timestamp_to_date.utc' => 'UTC',
    'tools.unix_timestamp_to_date.local' => 'Your local timezone',
    'tools.unix_timestamp_to_date.extra_content' => '',

    'tools.date_to_unix_timestamp.name' => 'Date to Unix Timestamp',
    'tools.date_to_unix_timestamp.description' => 'Convert a particular date to the unix timestamp format.',
    'tools.date_to_unix_timestamp.meta_keywords' => '',
    'tools.date_to_unix_timestamp.timezone' => 'Timezone',
    'tools.date_to_unix_timestamp.result' => 'Unix timestamp',
    'tools.date_to_unix_timestamp.extra_content' => '',

    'tools.signature_generator.name' => 'Signature generator',
    'tools.signature_generator.description' => 'Easily generate your own custom signature and download it with ease.',
    'tools.signature_generator.meta_keywords' => '',
    'tools.signature_generator.clear' => 'Clear',
    'tools.signature_generator.undo' => 'Undo',
    'tools.signature_generator.extra_content' => '',


    'notification_handlers.title' => 'Notification handlers',
    'notification_handlers.menu' => 'Notification handlers',
    'notification_handlers.breadcrumb' => 'Notification handlers',
    'notification_handlers.header' => 'Notification handlers',
    'notification_handlers.subheader' => 'How do you want to get notified when certain events happen?',
    'notification_handlers.create' => 'Create notification handler',
    'notification_handlers.test' => 'Test integration',
    'notification_handlers.test_title' => 'This is a test message.',
    'notification_handlers.test_description' => 'This is the test description for the notification handler.',
    'notification_handlers.test.subject' => 'Notification handler test - {{WEBSITE_TITLE}}',
    'notification_handlers.test.body' => 'This is the test description for the notification handler.',
    'notification_handlers.success_message_test' => 'The test has been successful.',
    'notification_handlers.error_message_test' => 'The test has failed.',

    'notification_handlers.type' => 'Notification type',
    'notification_handlers.type_x' => 'X tweet',
    'notification_handlers.type_email' => 'Email',
    'notification_handlers.type_webhook' => 'Webhook',
    'notification_handlers.type_slack' => 'Slack',
    'notification_handlers.type_microsoft_teams' => 'Microsoft Teams',
    'notification_handlers.type_discord' => 'Discord',
    'notification_handlers.type_telegram' => 'Telegram',
    'notification_handlers.type_twilio' => 'SMS',
    'notification_handlers.type_twilio_call' => 'Phone call',
    'notification_handlers.type_whatsapp' => 'Whatsapp',
    'notification_handlers.type_google_chat' => 'Google chat',
    'notification_handlers.type_internal_notification' => 'Internal notification',
    'notification_handlers.type_push_subscriber_id' => 'Push notification',
    'notification_handlers.push_subscriber_id' => 'Push subscriber',
    'notification_handlers.push_subscriber_id_help' => 'Select one device that you have subscribed with.',
    'notification_handlers.email' => 'Email',
    'notification_handlers.email_help' => 'Receive email notifications.',
    'notification_handlers.webhook' => 'Webhook URL',
    'notification_handlers.webhook_help' => 'Receive POST calls notifications to your specified webhook URL.',
    'notification_handlers.slack' => 'Slack webhook URL',
    'notification_handlers.slack_help' => 'Receive Slack notifications for your specified Slack channel via webhooks. <a href="https://slack.com/apps/A0F7XDUAZ-incoming-webhooks" target="_blank">Get Slack webhook URL</a>.',
    'notification_handlers.discord' => 'Discord webhook URL',
    'notification_handlers.discord_help' => 'Receive Discord notifications for your specified Discord channel via webhooks.',
    'notification_handlers.microsoft_teams' => 'Microsoft Teams webhook URL',
    'notification_handlers.microsoft_teams_help' => 'Receive Microsoft Teams notifications for your specified channel via webhooks. <a href="https://learn.microsoft.com/en-us/microsoftteams/platform/webhooks-and-connectors/how-to/add-incoming-webhook?tabs=dotnet" target="_blank">Get Microsoft Teams webhook URL</a>.',
    'notification_handlers.telegram' => 'Telegram API Token',
    'notification_handlers.telegram_help' => 'The token for the HTTP API that you received after creating the bot on Telegram.',
    'notification_handlers.telegram_chat_id' => 'Telegram Chat ID',
    'notification_handlers.telegram_chat_id_help' => 'Where the bot should send the messages to.',
    'notification_handlers.twilio' => 'Phone number',
    'notification_handlers.twilio_help' => 'Example of valid phone number: +15558675310.',
    'notification_handlers.twilio_call' => 'Phone number',
    'notification_handlers.twilio_call_help' => 'Example of valid phone number: +15558675310.',
    'notification_handlers.whatsapp' => 'Whatsapp number',
    'notification_handlers.whatsapp_help' => 'Example of valid phone number: 15558675310. Only numbers.',
    'notification_handlers.google_chat' => 'Google chat webhook URL',
    'notification_handlers.google_chat_help' => 'Receive Google chat notifications for your specified space via webhooks.',
    'notification_handlers.x_consumer_key' => 'X consumer key',
    'notification_handlers.x_consumer_secret' => 'X consumer secret',
    'notification_handlers.x_access_token' => 'X access token',
    'notification_handlers.x_access_token_secret' => 'X access token secret',
    'notification_handlers.internal_notification_help' => 'Get notified internally via the notifications system near in the menu bar.',
    'notification_handlers.is_enabled' => 'Notification handler is active',
    'notification_handlers.no_data' => 'There are no notification handlers for now',
    'notification_handlers.no_data_help' => 'Start by creating your first notification handler.',


    'notification_handler_create.breadcrumb' => 'Create a new notification handler',
    'notification_handler_create.title' => 'Create a new notification handler',
    'notification_handler_create.header' => 'Create a new notification handler',


    'notification_handler_update.breadcrumb' => 'Edit notification handler',
    'notification_handler_update.title' => 'Edit notification handler',
    'notification_handler_update.header' => 'Edit notification handler',


    'signatures.breadcrumb' => 'Signatures',
    'signatures.title' => 'Signatures',
    'signatures.menu' => 'Signatures',
    'signatures.header' => 'Signatures',
    'signatures.subheader' => 'Here you can find all the email signatures that you have created.',
    'signatures.create' => 'Create signature',
    'signatures.copy' => 'Copy signature',
    'signatures.copy_code' => 'Copy signature HTML code',
    'signatures.signature' => 'Signature',
    'signatures.direction' => 'Direction',
    'signatures.direction.rtl' => 'Right to Left',
    'signatures.direction.ltr' => 'Left to Right',
    'signatures.template' => 'Template',
    'signatures.template.plain_text' => 'Plain text',
    'signatures.template.mars' => 'Mars',
    'signatures.template.mercury' => 'Mercury',
    'signatures.template.venus' => 'Venus',
    'signatures.is_removed_branding' => 'Remove branding',
    'signatures.image_url' => 'Image URL',
    'signatures.image_url_help' => 'Only use JPG, JPEG, GIF, PNG images.',
    'signatures.sign_off' => 'Sign off',
    'signatures.sign_off.default' => 'Regards,',
    'signatures.full_name' => 'Full name',
    'signatures.job_title' => 'Job title',
    'signatures.department' => 'Department',
    'signatures.company' => 'Company',
    'signatures.website_name' => 'Website name',
    'signatures.website_url' => 'Website URL',
    'signatures.address' => 'Address',
    'signatures.address_url' => 'Address URL',
    'signatures.address_url_help' => 'Link to a Google maps location, for example.',
    'signatures.phone_number' => 'Phone number',
    'signatures.whatsapp' => 'Whatsapp',
    'signatures.facebook_messenger' => 'Facebook messenger username',
    'signatures.telegram' => 'Telegram username',
    'signatures.facebook' => 'Facebook username',
    'signatures.threads' => 'Threads username',
    'signatures.instagram' => 'Instagram username',
    'signatures.x' => 'X username',
    'signatures.youtube' => 'YouTube channel',
    'signatures.tiktok' => 'TikTok username',
    'signatures.spotify' => 'Spotify username',
    'signatures.pinterest' => 'Pinterest username',
    'signatures.linkedin' => 'LinkedIn username',
    'signatures.snapchat' => 'Snapchat username',
    'signatures.twitch' => 'Twitch username',
    'signatures.discord' => 'Discord user id',
    'signatures.github' => 'Github username',
    'signatures.reddit' => 'Reddit username',
    'signatures.disclaimer' => 'Disclaimer text',
    'signatures.font_size' => 'Font size',
    'signatures.font_family' => 'Font family',
    'signatures.width' => 'Email signature width',
    'signatures.image_width' => 'Image width',
    'signatures.image_border_radius' => 'Image border radius',
    'signatures.socials_width' => 'Social media icons width',
    'signatures.socials_padding' => 'Social media icons padding',
    'signatures.separator_size' => 'Separator size',
    'signatures.theme_color' => 'Theme color',
    'signatures.full_name_color' => 'Full name color',
    'signatures.text_color' => 'Text color',
    'signatures.link_color' => 'Link color',

    'signatures.no_data' => 'There are no created signatures',
    'signatures.no_data_help' => 'Start by sending your first email signature.',


    'signature_create.breadcrumb' => 'Create signature',
    'signature_create.title' => 'Create signature',
    'signature_create.header' => 'Create signature',


    'signature_update.breadcrumb' => 'Edit signature',
    'signature_update.title' => 'Edit signature - %s',
    'signature_update.to' => 'To:',
    'signature_update.to_value' => 'john@domain.com',
    'signature_update.subject' => 'Subject:',
    'signature_update.subject_value' => 'I got a new email signature 🥳',
    'signature_update.body_value' => 'Hello, <strong>John</strong> <br /><br /> How does my email signature look? 👇',
    'signature_update.tab.main' => 'Main',
    'signature_update.tab.customizations' => 'Customizations',
    'signature_update.tab.preview' => 'Preview',
    'signature_update.tab.code' => 'Get code',
    'signature_update.tab.personal' => 'Personal',
    'signature_update.tab.social' => 'Social media',
    'signature_update.tab.disclaimer' => 'Disclaimer',
    'signature_update.tab.contact' => 'Contact',


    'documents.breadcrumb' => 'AI Documents',
    'documents.title' => 'AI Documents',
    'documents.menu' => 'AI Documents',
    'documents.header' => 'AI Documents',
    'documents.subheader' => 'Here you can find all the AI generated documents that you have created.',
    'documents.create' => 'Generate AI document',
    'documents.widget.total' => 'Total documents',
    'documents.widget.words_current_month' => 'Words used',
    'documents.widget.available_words' => 'Words available',
    'documents.widget.this_month' => 'This month',
    'documents.table.document' => 'Document',
    'documents.model' => 'AI Model',
    'documents.api_response_time' => 'API Response Time',
    'documents.words' => 'Generated words',
    'documents.words_help' => 'This is an approximation based on the resource usage and language response.',
    'documents.x_words_available' => '%s words available this month',
    'documents.variants' => 'Variants',
    'documents.variants_help' => 'How many results the AI should try to generate.',
    'documents.x_variants' => '%s variants',
    'documents.variant_x' => 'Variant %s',
    'documents.language_help' => 'Tell the AI to give you the answer in the above language.',

    'documents.creativity_level' => 'Creativity level',
    'documents.creativity_level.none' => 'None (most factual)',
    'documents.creativity_level.low' => 'Low (highly factual)',
    'documents.creativity_level.optimal' => 'Optimal',
    'documents.creativity_level.high' => 'High (highly creative)',
    'documents.creativity_level.maximum' => 'Max (most creative)',
    'documents.creativity_level.custom' => 'Custom',
    'documents.creativity_level_help' => 'This tells the AI the amount of creativity "risks" to take when generating content.',
    'documents.creativity_level_custom' => 'Creativity level',
    'documents.creativity_level_custom_help' => '0 is the most factual. 1 is the highest amount of creativity.',
    'documents.input' => 'Input',
    'documents.max_words_per_variant' => 'Maximum words per variant',
    'documents.max_words_per_variant_help' => 'This is an approximation based on the length of the generated words. Leave empty for optimal responses.',
    'documents.content' => 'Content',
    'documents.advanced' => 'Advanced settings',
    'documents.no_data' => 'There are no created AI documents',
    'documents.no_data_help' => 'Start by generating your first AI written document.',
    'documents.error_message.flagged' => 'The keywords/text you\'ve used been flagged as they are breaking the terms of use.',
    'documents.error_message.timed_out' => 'Due to breaking the terms of use, you are timed out for a few minutes.',
    'documents.error_message.prompt_tokens' => 'You\'ve given too much text for the AI to process, please shorten the given text.',


    'document_create.breadcrumb' => 'Create AI document',
    'document_create.title' => 'Create AI document',
    'document_create.header' => 'Create AI document',
    'document_create.name_x' => 'AI Doc - %s',


    'document_update.breadcrumb' => 'Edit AI document',
    'document_update.title' => 'Edit AI document - %s',


    'images.breadcrumb' => 'AI Images',
    'images.title' => 'AI Images',
    'images.menu' => 'AI Images',
    'images.header' => 'AI Images',
    'images.subheader' => 'Here you can find all the AI generated images.',
    'images.create' => 'Generate AI image',
    'images.widget.total' => 'Total images',
    'images.widget.images_current_month' => 'Images used',
    'images.widget.available_images' => 'Images available',
    'images.widget.this_month' => 'This month',
    'images.api' => 'API',
    'images.api_response_time' => 'API Response Time',
    'images.variants' => 'Variants',
    'images.variants_help' => 'How many results the AI should try to generate.',
    'images.x_variants' => '%s variants',
    'images.artist' => 'Artist',
    'images.artist_help' => 'Select the style of the generated image based on specific artists.',
    'images.lighting' => 'Lighting style',
    'images.lighting_help' => 'Select the lighting style of the generated image based on specific light parameters.',
    'images.lighting.warm' => 'Warm',
    'images.lighting.cold' => 'Cold',
    'images.lighting.golden_hour' => 'Golden Hour',
    'images.lighting.blue_hour' => 'Blue Hour',
    'images.lighting.ambient' => 'Ambient',
    'images.lighting.studio' => 'Studio',
    'images.lighting.neon' => 'Neon',
    'images.lighting.dramatic' => 'Dramatic',
    'images.lighting.cinematic' => 'Cinematic',
    'images.lighting.natural' => 'Natural',
    'images.lighting.foggy' => 'Foggy',
    'images.lighting.backlight' => 'Backlight',
    'images.lighting.hard' => 'Hard',
    'images.style' => 'Art style',
    'images.style_help' => 'Select the main style of the generated image based on specific art parameters.',
    'images.style.3d_render' => '3D render',
    'images.style.pixel' => 'Pixel',
    'images.style.sticker' => 'Sticker',
    'images.style.isometric' => 'Isometric',
    'images.style.cyberpunk' => 'Cyberpunk',
    'images.style.vaporwave' => 'Vaporwave',
    'images.style.steampunk' => 'Steampunk',
    'images.style.glitchcore' => 'Glitchcore',
    'images.style.bauhaus' => 'Bauhaus',
    'images.style.vector' => 'Vector',
    'images.style.low_poly' => 'Low poly',
    'images.style.ukiyo_e' => 'Ukiyo-e',
    'images.style.line' => 'Line art',
    'images.style.pencil' => 'Pencil drawing',
    'images.style.ballpoint_pen' => 'Ballpoint pen drawing',
    'images.style.watercolor' => 'Watercolor',
    'images.style.origami' => 'Origami',
    'images.style.cartoon' => 'Cartoon',
    'images.style.retro' => 'Retro',
    'images.style.anime' => 'Anime',
    'images.style.renaissance' => 'Renaissance',
    'images.style.clay' => 'Clay',
    'images.style.cubism' => 'Cubism',
    'images.style.modern' => 'Modern',
    'images.style.pop' => 'Pop',
    'images.style.contemporary' => 'Contemporary',
    'images.style.impressionism' => 'Impressionism',
    'images.style.pointillism' => 'Pointillism',
    'images.style.minimalism' => 'Minimalism',
    'images.mood' => 'Mood',
    'images.mood_help' => 'Select the mood of the generated image.',
    'images.mood.aggressive' => 'Aggressive',
    'images.mood.angry' => 'Angry',
    'images.mood.boring' => 'Boring',
    'images.mood.bright' => 'Bright',
    'images.mood.calm' => 'Calm',
    'images.mood.cheerful' => 'Cheerful',
    'images.mood.chilling' => 'Chilling',
    'images.mood.colorful' => 'Colorful',
    'images.mood.dark' => 'Dark',
    'images.mood.neutral' => 'Neutral',
    'images.size' => 'Image size',
    'images.size_help' => 'The resolution of the generated image.',
    'images.input' => 'Image description',
    'images.input_placeholder' => 'A wide nature scenery with wild life, at the golden hour.',
    'images.input_help' => 'Describe to the AI exactly what you want to generate.',
    'images.content' => 'Content',
    'images.advanced' => 'Advanced settings',
    'images.no_data' => 'There are no created AI images',
    'images.no_data_help' => 'Start by generating your first AI image.',


    'image_create.breadcrumb' => 'Create AI image',
    'image_create.title' => 'Create AI image',
    'image_create.header' => 'Create AI image',
    'image_create.name_x' => 'AI Image - %s',


    'image_update.breadcrumb' => 'Edit AI image',
    'image_update.title' => 'Edit AI image - %s',


    'templates.breadcrumb' => 'Templates',
    'templates.title' => 'Templates',
    'templates.menu' => 'Templates',
    'templates.header' => 'Templates',
    'templates.subheader' => 'Here you can find all the available predefined AI document templates.',
    'templates.templates_per_category' => '%s templates',


    'transcriptions.breadcrumb' => 'AI Speech to Text',
    'transcriptions.title' => 'AI Speech to Text',
    'transcriptions.menu' => 'AI Speech to Text',
    'transcriptions.header' => 'AI Speech to Text',
    'transcriptions.subheader' => 'Here you can find all the AI generated transcriptions.',
    'transcriptions.create' => 'Generate AI transcription',
    'transcriptions.widget.total' => 'Total transcriptions',
    'transcriptions.widget.transcriptions_current_month' => 'Transcriptions used',
    'transcriptions.widget.available_transcriptions' => 'Transcriptions available',
    'transcriptions.widget.this_month' => 'This month',
    'transcriptions.transcription' => 'Transcription',
    'transcriptions.words' => 'Transcribed words',
    'transcriptions.api_response_time' => 'API Response Time',
    'transcriptions.file' => 'File',
    'transcriptions.language_help' => 'Help the AI by specifying the language of the speech.',
    'transcriptions.language.auto' => 'Auto detect',
    'transcriptions.input' => 'Audio description',
    'transcriptions.input_placeholder' => 'The transcript is about a two person interaction inside of a cafe bar talking about business ideas, with multiple people speaking in the background.',
    'transcriptions.input_help' => 'Describe the speech from the file uploaded above to help the AI. You can leave this field empty. Must be written in English.',
    'transcriptions.content' => 'Content',
    'transcriptions.advanced' => 'Advanced settings',
    'transcriptions.no_data' => 'There are no created AI transcriptions',
    'transcriptions.no_data_help' => 'Start by generating your first AI transcription.',


    'transcription_create.breadcrumb' => 'Create AI transcription',
    'transcription_create.title' => 'Create AI transcription',
    'transcription_create.header' => 'Create AI transcription',
    'transcription_create.name_x' => 'AI Transcription - %s',


    'transcription_update.breadcrumb' => 'Edit AI transcription',
    'transcription_update.title' => 'Edit AI transcription - %s',


    'chats.breadcrumb' => 'AI Chats',
    'chats.title' => 'AI Chats',
    'chats.menu' => 'AI Chats',
    'chats.header' => 'AI Chats',
    'chats.subheader' => 'Here you can start having conversations with the AI.',
    'chats.create' => 'Start new chat',
    'chats.widget.total' => '%s Total chats',
    'chats.widget.chats_current_month' => '%s Chats used',
    'chats.widget.available_chats' => '%s Chats available',
    'chats.widget.this_month' => 'This month',
    'chats.chat' => 'Chat',
    'chats.chat_assistant_id' => 'Chat assistant',
    'chats.total_messages' => 'Messages',
    'chats.used_tokens' => 'Used tokens',
    'chats.api_response_time' => 'API Response Time',
    'chats.content_placeholder' => 'Ask the bot anything you want...',
    'chats.no_data' => 'There are no created AI chats',
    'chats.no_data_help' => 'Start by talking to your first AI Bot.',


    'chat_create.breadcrumb' => 'Create AI chat',
    'chat_create.title' => 'Create AI chat',
    'chat_create.header' => 'Create AI chat',
    'chat_create.name_x' => 'AI Chat - %s',


    'chat.breadcrumb' => 'AI chat',
    'chat.title' => 'AI Chat - %s',
    'chat.header' => 'AI Chat - %s',
    'chat.total_messages' => '%s chat messages.',
    'chat.error_message.context_length' => 'The chat has reached it\'s context length limit.',
    'chat.error_message.context_length_help' => 'We automatically changed the context length to only remember the last 5 messages. You can resend your message.',


    'chat_settings_modal.header' => 'Chat settings',
    'chat_settings_modal.subheader' => 'We serve ads so we can keep our website running. Please disable your ad blockers.',
    'chat_settings_modal.context_length' => 'Context length',
    'chat_settings_modal.context_length_x' => '%s chat messages',
    'chat_settings_modal.context_length_help' => 'How many of the past messages should the AI remember.',
    'chat_settings_modal.button' => 'Save',


    'syntheses.breadcrumb' => 'AI Text to Speech',
    'syntheses.title' => 'AI Text to Speech',
    'syntheses.menu' => 'AI Text to Speech',
    'syntheses.header' => 'AI Text to Speech',
    'syntheses.subheader' => 'Here you can find all the AI generated syntheses.',
    'syntheses.create' => 'Generate AI synthesis',
    'syntheses.widget.total' => 'Total syntheses',
    'syntheses.widget.syntheses_current_month' => 'Syntheses used',
    'syntheses.widget.available_syntheses' => 'Syntheses available',
    'syntheses.widget.this_month' => 'This month',
    'syntheses.synthesis' => 'Synthesis',
    'syntheses.characters' => 'Characters',
    'syntheses.api_response_time' => 'API Response Time',
    'syntheses.language' => 'Language',
    'syntheses.voice_id' => 'Voice',
    'syntheses.voice_gender' => 'Voice gender',
    'syntheses.voice_gender.male' => 'Male',
    'syntheses.voice_gender.female' => 'Female',
    'syntheses.voice_gender.male_child' => 'Male child',
    'syntheses.voice_gender.female_child' => 'Female child',
    'syntheses.voice_engine' => 'Voice engine',
    'syntheses.voice_engine.standard' => 'Standard',
    'syntheses.voice_engine.neural' => 'Neural (HQ)',
    'syntheses.voice_engine.tts_1' => 'TTS 1',
    'syntheses.voice_engine.tts_1_hd' => 'TTS 1 (HQ)',
    'syntheses.input' => 'Text',
    'syntheses.input_placeholder' => '',
    'syntheses.format' => 'Format',
    'syntheses.input_help' => 'The text that will be used to generate a synthesis with.',
    'syntheses.advanced' => 'Advanced settings',
    'syntheses.no_data' => 'There are no created AI syntheses',
    'syntheses.no_data_help' => 'Start by generating your first AI synthesis.',


    'synthesis_create.breadcrumb' => 'Create AI synthesis',
    'synthesis_create.title' => 'Create AI synthesis',
    'synthesis_create.header' => 'Create AI synthesis',
    'synthesis_create.name_x' => 'AI synthesis - %s',


    'synthesis_update.breadcrumb' => 'Edit AI synthesis',
    'synthesis_update.title' => 'Edit AI synthesis - %s',

    'cron.email_reports.title' => 'Summary analytics for \'{{LINK:URL}}\' between {{START_DATE}} and {{END_DATE}} - {{WEBSITE_TITLE}}',
    'cron.email_reports.p1' => 'Short analytics overview for the <strong>%s</strong> link.',
    'cron.email_reports.button' => 'View statistics',
    'cron.email_reports.notice' => 'You\'re receiving these emails because you activated email reports. You can unsubscribe from the %slink settings%s page at any point in time.',
];
