{{ Form::open(['route' => 'mobileservice.home-setup.banner.store', 'method' => 'post', 'enctype' => 'multipart/form-data', 'class' => 'needs-validation', 'novalidate']) }}
<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            {{ Form::label('banner_title', __('Title'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::text('banner_title', $settings['banner_title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter title'), 'required']) }}
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group">
            {{ Form::label('banner_subtitle', __('Subtitle'), ['class' => 'form-label']) }}
            {{ Form::text('banner_subtitle', $settings['banner_subtitle'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter subtitle')]) }}
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group">
            {{ Form::label('banner_description', __('Description'), ['class' => 'form-label']) }}<x-required></x-required>
            {{ Form::textarea('banner_description', $settings['banner_description'] ?? '', ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Enter description'), 'required']) }}
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4">
        <div class="form-group mb-0">
            <label class="form-label">{{ __('Image') }}</label>@if (empty($settings['banner_image']))<x-required></x-required>@endif
            <input type="file" name="banner_image" class="form-control mb-2" accept="image/*"
                onchange="previewImage(this)" @if (empty($settings['banner_image'])) required @endif>
            @php
                $banner_image = $settings['banner_image'] ?? '';
                if (isset($banner_image) && $banner_image != '' && check_file($banner_image)) {
                    $banner_image_path = get_file($banner_image);
                } else {
                    $banner_image_path = asset('packages/workdo/MobileServiceManagement/src/Resources/assets/images/defualt.png');
                }
            @endphp
            <div class="image-preview" @if (isset($settings['banner_image']) && $settings['banner_image']) style="display:block;" @else style="display:none;" @endif>
                <img src="{{ $banner_image_path }}" alt="{{ __('Preview') }}"
                    style="max-width:100px;max-height:100px;border:1px solid #ddd;border-radius:4px;">
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <x-icon-picker name="banner_image_icon" :value="$settings['banner_image_icon'] ?? ''" label="{{ __('Image Icon') }}" />
    </div>
    <div class="col-md-4">
        <div class="form-group">
            {{ Form::label('banner_image_text', __('Image Text'), ['class' => 'form-label']) }}
            {{ Form::text('banner_image_text', $settings['banner_image_text'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter image text')]) }}
        </div>
    </div>
</div>
<div class="row">
    <div class="col-12">
        <div class="text-end">
            <input class="btn btn-primary" type="submit" value="{{ __('Save Changes') }}">
        </div>
    </div>
</div>
{{ Form::close() }}
