<div class="card mt-4">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5>{{ __('FAQ Page') }}</h5>
        <div class="d-flex align-items-center">
            <span class="me-1">{{ __('On/Off') }}:</span>
            <div class="form-check form-switch custom-switch-v1 me-2">
                <input type="hidden" name="is_faq_page_active" value="off">
                <input type="checkbox" class="form-check-input input-primary section-toggle"
                    name="is_faq_page_active" id="is_faq_page_active"
                    {{ !empty($settings['is_faq_page_active']) && $settings['is_faq_page_active'] == 'on' ? 'checked="checked"' : '' }}>
            </div>
        </div>
    </div>
    {{ Form::open(['route' => 'mobileservice.faq-custom-setup.faq.store', 'method' => 'post', 'class' => 'needs-validation', 'novalidate']) }}
    <div class="card-body">
        <div class="repeater faq-repeater" id="faq-repeater">
            <div data-repeater-list="faqs">
                <div data-repeater-item class="card border mb-3">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-11">
                                <div class="form-group">
                                    <label class="form-label">{{ __('Question') }}</label><x-required></x-required>
                                    <input type="text" name="question" class="form-control"
                                        placeholder="{{ __('Enter question') }}" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">{{ __('Answer') }}</label><x-required></x-required>
                                    <textarea name="answer" class="form-control" rows="3" placeholder="{{ __('Enter answer') }}" required></textarea>
                                </div>
                            </div>
                            <div class="col-md-1 text-center">
                                <button type="button" class="btn btn-danger btn-sm" data-repeater-delete>
                                    <i class="ti ti-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-center mt-3">
                <button type="button" data-repeater-create class="btn btn-primary">
                    <i class="ti ti-plus"></i> {{ __('Add FAQ') }}
                </button>
            </div>
        </div>
    </div>
    <div class="card-footer text-end">
        <input class="btn btn-primary" type="submit" value="{{ __('Save Changes') }}">
    </div>
    {{ Form::close() }}
</div>

@push('scripts')
    <script src="{{ asset('js/jquery.repeater.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            var faqRepeater = $('.faq-repeater').repeater({
                initEmpty: true,
                defaultValues: {
                    'question': '',
                    'answer': ''
                },
                show: function() {
                    $(this).slideDown();
                },
                hide: function(deleteElement) {
                    $(this).slideUp(deleteElement);
                }
            });

            var faqData = {!! json_encode(json_decode($settings['faq_data'] ?? '[]', true) ?: []) !!};

            if (!faqData || faqData.length === 0) {
                faqRepeater.setList([{
                    question: '',
                    answer: ''
                }]);
            } else {
                faqRepeater.setList(faqData);
            }
        });
    </script>
@endpush
