<div class="card">
    <div class="repeater icon-repeater" id="social-repeater">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5>{{ __('Follow Us') }}</h5>
            <button type="button" data-repeater-create class="btn btn-primary btn-sm">
                <i class="ti ti-plus"></i>
            </button>
        </div>
        {{ Form::open(['route' => 'mobileservice.contact-setup.social.store', 'method' => 'post', 'class' => 'needs-validation', 'novalidate']) }}
        <div class="card-body">
            <div data-repeater-list="social_links">
                @php
                    $socialLinks = json_decode($settings['social_links'] ?? '[]', true) ?: [];
                @endphp
                @forelse($socialLinks as $social)
                    <div data-repeater-item class="card border mb-3">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-4">
                                    <x-icon-picker name="icon" label="{{ __('Social Media Icon') }}" value="{{ $social['icon'] ?? '' }}" />
                                </div>
                                <div class="col-md-7">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Social Media URL') }}</label><x-required></x-required>
                                        <input type="url" name="link" class="form-control" value="{{ $social['link'] ?? '' }}" placeholder="{{ __('Enter social media URL') }}" required>
                                    </div>
                                </div>
                                <div class="col-md-1 text-center">
                                    <button type="button" class="btn btn-danger btn-sm" data-repeater-delete>
                                        <i class="ti ti-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                @empty
                    <div data-repeater-item class="card border mb-3">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-4">
                                    <x-icon-picker name="icon" label="{{ __('Social Media Icon') }}" />
                                </div>
                                <div class="col-md-7">
                                    <div class="form-group">
                                        <label class="form-label">{{ __('Social Media URL') }}</label><x-required></x-required>
                                        <input type="url" name="link" class="form-control" placeholder="{{ __('Enter social media URL') }}" required>
                                    </div>
                                </div>
                                <div class="col-md-1 text-center">
                                    <button type="button" class="btn btn-danger btn-sm" data-repeater-delete>
                                        <i class="ti ti-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforelse
            </div>
        </div>
        <div class="card-footer text-end">
            <input class="btn btn-primary" type="submit" value="{{ __('Save Changes') }}">
        </div>
        {{ Form::close() }}
    </div>
</div>

@push('scripts')
    <script src="{{ asset('js/jquery.repeater.min.js') }}"></script>
    <script src="{{ asset('js/icon-repeater.js') }}"></script>
@endpush
