<div class="card">
    <div class="card-header">
        <h5>{{ __('Contact Information') }}</h5>
    </div>
    {{ Form::open(['route' => 'mobileservice.contact-setup.info.store', 'method' => 'post']) }}
    <div class="card-body">
        <div class="row">
            <!-- Location Card -->
            <div class="col-xxl-4 mt-1">
                <div class="card h-100">
                    <div class="card-header py-3">
                        <h6 class="mb-0"><i class="ti ti-map-pin me-2"></i>{{ __('Our Location') }}</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            {{ Form::label('location_title', __('Location Title'), ['class' => 'form-label']) }}
                            {{ Form::text('location_title', $settings['location_title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter location title')]) }}
                        </div>
                        <div class="form-group">
                            {{ Form::label('contact_address', __('Complete Address'), ['class' => 'form-label']) }}
                            {{ Form::textarea('contact_address', $settings['contact_address'] ?? '', ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Enter complete address')]) }}
                        </div>
                    </div>
                </div>
            </div>

            <!-- Service Hours Card -->
            <div class="col-xxl-4 mt-1">
                <div class="card h-100">
                    <div class="card-header py-3">
                        <h6 class="mb-0"><i class="ti ti-clock me-2"></i>{{ __('Service Hours') }}</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            {{ Form::label('hours_title', __('Hours Title'), ['class' => 'form-label']) }}
                            {{ Form::text('hours_title', $settings['hours_title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter hours title')]) }}
                        </div>
                        @php
                            $service_hours = json_decode($settings['service_hours'] ?? '[]', true);
                            $weekdays = [__('Monday'), __('Tuesday'), __('Wednesday'), __('Thursday'), __('Friday'), __('Saturday'), __('Sunday')];
                        @endphp
                        <div class="service-hours-simple">
                            @foreach ($weekdays as $index => $day)
                                @php
                                    $hour = $service_hours[$index] ?? null;
                                @endphp
                                <div class="row mb-3 align-items-center">
                                    <div class="col-12 col-sm-6 col-md-3 mb-2 mb-md-0">
                                        <strong class="d-block">{{ $day }}</strong>
                                        <input type="hidden" name="service_hours[{{ $index }}][day]" value="{{ $day }}">
                                    </div>
                                    <div class="col-12 col-sm-6 col-md-3 mb-2 mb-md-0">
                                        <select name="service_hours[{{ $index }}][status]" class="form-control form-control-sm hour-status" data-index="{{ $index }}">
                                            <option value="open" {{ ($hour['status'] ?? 'open') == 'open' ? 'selected' : '' }}>{{ __('Open') }}</option>
                                            <option value="closed" {{ ($hour['status'] ?? 'open') == 'closed' ? 'selected' : '' }}>{{ __('Closed') }}</option>
                                        </select>
                                    </div>
                                    <div class="col-6 col-sm-6 col-md-3 time-fields" id="start-time-{{ $index }}" style="{{ ($hour['status'] ?? 'open') == 'closed' ? 'display:none' : '' }}">
                                        <input type="time" name="service_hours[{{ $index }}][start_time]" class="form-control form-control-sm" value="{{ $hour['start_time'] ?? '' }}" placeholder="{{ __('Start') }}">
                                    </div>
                                    <div class="col-6 col-sm-6 col-md-3 time-fields" id="end-time-{{ $index }}" style="{{ ($hour['status'] ?? 'open') == 'closed' ? 'display:none' : '' }}">
                                        <input type="time" name="service_hours[{{ $index }}][end_time]" class="form-control form-control-sm" value="{{ $hour['end_time'] ?? '' }}" placeholder="{{ __('End') }}">
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact Info Card -->
            <div class="col-xxl-4 mt-1">
                <div class="card h-100">
                    <div class="card-header py-3">
                        <h6 class="mb-0"><i class="ti ti-phone me-2"></i>{{ __('Contact Details') }}</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            {{ Form::label('contact_title', __('Contact Title'), ['class' => 'form-label']) }}
                            {{ Form::text('contact_title', $settings['contact_title'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter contact title')]) }}
                        </div>
                        <div class="form-group">
                            <x-mobile name="contact_phone" label="{{ __('Primary Phone') }}" value="{{ $settings['contact_phone'] ?? '' }}" class="form-control" placeholder="{{ __('Enter primary phone') }}" id="contact_phone"></x-mobile>
                        </div>
                        <div class="form-group">
                            {{ Form::label('contact_email', __('Email Address'), ['class' => 'form-label']) }}
                            {{ Form::email('contact_email', $settings['contact_email'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter email address')]) }}
                        </div>
                        <div class="form-group">
                            {{ Form::label('contact_emergency', __('Emergency/Support'), ['class' => 'form-label']) }}
                            {{ Form::text('contact_emergency', $settings['contact_emergency'] ?? '', ['class' => 'form-control', 'placeholder' => __('Enter emergency/support')]) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="card-footer text-end">
        <input class="btn btn-primary" type="submit" value="{{ __('Save Changes') }}">
    </div>
    {{ Form::close() }}
</div>

@push('scripts')
    <script>
        // Service hours status toggle
        $(document).ready(function() {
            $(document).on('change', '.hour-status', function() {
                var index = $(this).data('index');
                var status = $(this).val();

                if (status === 'closed') {
                    $('#start-time-' + index).hide();
                    $('#end-time-' + index).hide();
                    $('input[name="service_hours[' + index + '][start_time]"]').val('');
                    $('input[name="service_hours[' + index + '][end_time]"]').val('');
                } else {
                    $('#start-time-' + index).show();
                    $('#end-time-' + index).show();
                }
            });
        });
    </script>
@endpush
