@extends('layouts.main')

@section('page-title')
    {{ __('Theme Setup') }}
@endsection

@section('page-breadcrumb')
    {{ __('System Setup') }}, {{ __('Theme Setup') }}
@endsection

@push('css')
    <link rel="stylesheet" href="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/css/style.css') }}">
@endpush

@section('content')
    <div class="row">
        <div class="col-sm-12">
            @include('mobile-service-management::theme-setup.sections')

            <div class="card mt-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5>{{ __('About Page') }}</h5>
                    <div class="d-flex align-items-center">
                        <span class="me-2">{{ __('On/Off') }}:</span>
                        <div class="form-check form-switch custom-switch-v1">
                            <input type="hidden" name="is_about_page_active" value="off">
                            <input type="checkbox" class="form-check-input input-primary section-toggle"
                                name="is_about_page_active" id="is_about_page_active"
                                {{ !empty($settings['is_about_page_active']) && $settings['is_about_page_active'] == 'on' ? 'checked="checked"' : '' }}>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="justify-content-center">
                        <div class="col-sm-12 col-md-10 col-xxl-12">
                            <div class="accordion accordion-flush setting-accordion" id="aboutAccordion">

                                {{-- Our Story --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="story-heading">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#story-collapse" aria-expanded="false" aria-controls="story-collapse">
                                            <span class="d-flex align-items-center">
                                                {{ __('Our Story') }}
                                            </span>
                                            <div class="d-flex align-items-center">
                                                <span class="me-2">{{ __('On/Off') }}:</span>
                                                <div class="form-check form-switch custom-switch-v1">
                                                    <input type="hidden" name="is_story_section_active" value="off">
                                                    <input type="checkbox" class="form-check-input input-primary section-toggle"
                                                        name="is_story_section_active" id="is_story_section_active"
                                                        {{ !empty($settings['is_story_section_active']) && $settings['is_story_section_active'] == 'on' ? 'checked="checked"' : '' }}>
                                                </div>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="story-collapse" class="accordion-collapse collapse"
                                        aria-labelledby="story-heading" data-bs-parent="#aboutAccordion">
                                        <div class="accordion-body">
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    @include('mobile-service-management::theme-setup.about-setup.story')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Our Mission --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="mission-heading">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#mission-collapse" aria-expanded="false"
                                            aria-controls="mission-collapse">
                                            <span class="d-flex align-items-center">
                                                {{ __('Our Mission') }}
                                            </span>
                                            <div class="d-flex align-items-center">
                                                <span class="me-2">{{ __('On/Off') }}:</span>
                                                <div class="form-check form-switch custom-switch-v1">
                                                    <input type="hidden" name="is_mission_section_active" value="off">
                                                    <input type="checkbox" class="form-check-input input-primary section-toggle"
                                                        name="is_mission_section_active" id="is_mission_section_active"
                                                        {{ !empty($settings['is_mission_section_active']) && $settings['is_mission_section_active'] == 'on' ? 'checked="checked"' : '' }}>
                                                </div>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="mission-collapse" class="accordion-collapse collapse"
                                        aria-labelledby="mission-heading" data-bs-parent="#aboutAccordion">
                                        <div class="accordion-body">
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    @include('mobile-service-management::theme-setup.about-setup.mission')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- Our Team --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="team-heading">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#team-collapse" aria-expanded="false" aria-controls="team-collapse">
                                            <span class="d-flex align-items-center">
                                                {{ __('Our Team') }}
                                            </span>
                                            <div class="d-flex align-items-center">
                                                <span class="me-2">{{ __('On/Off') }}:</span>
                                                <div class="form-check form-switch custom-switch-v1">
                                                    <input type="hidden" name="is_team_section_active" value="off">
                                                    <input type="checkbox" class="form-check-input input-primary section-toggle"
                                                        name="is_team_section_active" id="is_team_section_active"
                                                        {{ !empty($settings['is_team_section_active']) && $settings['is_team_section_active'] == 'on' ? 'checked="checked"' : '' }}>
                                                </div>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="team-collapse" class="accordion-collapse collapse"
                                        aria-labelledby="team-heading" data-bs-parent="#aboutAccordion">
                                        <div class="accordion-body">
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    @include('mobile-service-management::theme-setup.about-setup.team')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- CTA Section --}}
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="cta-heading">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#cta-collapse"
                                            aria-expanded="false" aria-controls="cta-collapse">
                                            <span class="d-flex align-items-center">
                                                {{ __('CTA') }}
                                            </span>
                                            <div class="d-flex align-items-center">
                                                <span class="me-2">{{ __('On/Off') }}:</span>
                                                <div class="form-check form-switch custom-switch-v1">
                                                    <input type="hidden" name="is_about_cta_section_active" value="off">
                                                    <input type="checkbox" class="form-check-input input-primary section-toggle"
                                                        name="is_about_cta_section_active" id="is_about_cta_section_active"
                                                        {{ !empty($settings['is_about_cta_section_active']) && $settings['is_about_cta_section_active'] == 'on' ? 'checked="checked"' : '' }}>
                                                </div>
                                            </div>
                                        </button>
                                    </h2>
                                    <div id="cta-collapse" class="accordion-collapse collapse"
                                        aria-labelledby="cta-heading" data-bs-parent="#aboutAccordion">
                                        <div class="accordion-body">
                                            <div class="row gy-4">
                                                <div class="col-md-12">
                                                    @include('mobile-service-management::theme-setup.about-setup.cta')
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('.section-toggle').on('change', function() {
                var checkbox = $(this);
                var checkboxName = checkbox.attr('name');
                var checkboxStatus = checkbox.is(':checked') ? 'on' : 'off';

                $.ajax({
                    url: '{{ route('mobileservice.theme-setup.toggle') }}',
                    method: 'POST',
                    data: {
                        [checkboxName]: checkboxStatus,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        toastrs('success', response.success, 'success');
                    },
                    error: function(xhr) {
                        let message = xhr.responseJSON?.error || __('Something went wrong!');
                        toastrs('Error', message, 'error');
                    }
                });
            });
        });

        function previewImage(input) {
            const preview = $(input).closest('.form-group').find('.image-preview');
            const img = preview.find('img');
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    img.attr('src', e.target.result);
                    preview.show();
                };
                reader.readAsDataURL(input.files[0]);
            } else {
                preview.hide();
                img.attr('src', '');
            }
        }
    </script>
@endpush
