@extends('layouts.main')

@section('page-title')
    {{ __('Service Details') }}
@endsection

@section('page-breadcrumb')
    {{ __('Services') }}
@endsection

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('Service Details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">{{ __('Name') }}</label>
                                <p class="form-control-static">{{ $service->name ?? '-' }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">{{ __('Category') }}</label>
                                <p class="form-control-static">{{ $service->category ? $service->category->category_name : '-' }}</p>
                            </div>
                        </div>
                    </div>
                    @if ($service->description)
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">{{ __('Description') }}</label>
                                    <p class="mb-0 desc-wrp p-3 rounded-1">{{ $service->description }}</p>
                                </div>
                            </div>
                        </div>
                    @endif
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">{{ __('Expected Price') }}</label>
                                <p class="form-control-static">{{ currency_format_with_sym($service->expected_price) }}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">{{ __('Expected Duration') }}</label>
                                <p class="form-control-static">{{ $service->expected_duration }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="form-label">{{ __('Icon') }}</label>
                                <div class="mt-2">
                                    <i class="{{ $service->icon }} fs-1"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="form-label">{{ __('Status') }}</label>
                                <p class="form-control-static">
                                    @if ($service->is_active)
                                        <span class="badge bg-success p-2 px-3">{{ __('Active') }}</span>
                                    @else
                                        <span class="badge bg-danger p-2 px-3">{{ __('Inactive') }}</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="form-label">{{ __('Show in Expertise') }}</label>
                                <p class="form-control-static">
                                    @if ($service->show_in_expertise)
                                        <span class="badge bg-success p-2 px-3">{{ __('Yes') }}</span>
                                    @else
                                        <span class="badge bg-secondary p-2 px-3">{{ __('No') }}</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label class="form-label">{{ __('Show in Footer') }}</label>
                                <p class="form-control-static">
                                    @if ($service->show_in_footer)
                                        <span class="badge bg-success p-2 px-3">{{ __('Yes') }}</span>
                                    @else
                                        <span class="badge bg-secondary p-2 px-3">{{ __('No') }}</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h5>{{ __('What\'s Included') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        @forelse ($service->whats_included as $item)
                            <div class="col-md-6 mb-3">
                                <div class="d-flex align-items-start">
                                    <div class="me-3">
                                        <i class="ti ti-check fs-4 text-primary"></i>
                                    </div>
                                    <div>
                                        <h6 class="mb-1">{{ $item['title'] ?? '' }}</h6>
                                        <p class="text-muted mb-0">{{ $item['description'] ?? '' }}</p>
                                    </div>
                                </div>
                            </div>
                        @empty
                            @include('layouts.nodatafound')
                        @endforelse
                    </div>
                </div>
            </div>

            <div class="float-end">
                <a href="{{ route('mobileservice.services.index') }}" class="btn btn-secondary">{{ __('Back') }}</a>
            </div>
        </div>
    </div>
@endsection
