@permission('mobileservice_service show')
    <div class="action-btn me-2">
        <a href="{{ route('mobileservice.services.show', ['id' => encrypt($data->id)]) }}" class="bg-warning btn btn-sm"
            data-toggle="tooltip" title="{{ __('Show') }}">
            <i class="ti ti-eye text-white"></i>
        </a>
    </div>
@endpermission

@permission('mobileservice_service edit')
    <div class="action-btn me-2">
        <a href="{{ route('mobileservice.services.edit', ['id' => encrypt($data->id)]) }}" class="bg-info btn btn-sm"
            data-toggle="tooltip" title="{{ __('Edit') }}">
            <i class="ti ti-pencil text-white"></i>
        </a>
    </div>
@endpermission

@permission('mobileservice_service delete')
    <div class="action-btn">
        <form method="POST" action="{{ route('mobileservice.services.destroy', encrypt($data->id)) }}" id="delete-form-{{ $data->id }}">
            @csrf
            @method('DELETE')
            <a href="#" class="bg-danger btn btn-sm show_confirm" data-bs-toggle="tooltip" title="{{ __('Delete') }}"
                data-original-title="{{ __('Delete') }}" data-confirm="{{ __('Are You Sure?') }}"
                data-text="{{ __('This action can not be undone. Do you want to continue?') }}"
                data-confirm-yes="delete-form-{{ $data->id }}">
                <i class="ti ti-trash text-white"></i>
            </a>
        </form>
    </div>
@endpermission
