@extends('layouts.main')

@section('page-title')
    {{ __('Manage Tracking Status') }}
@endsection

@section('page-breadcrumb')
    {{ __('Tracking Status') }}
@endsection

@section('page-action')
    <div>
        @permission('mobileservice_trackingstatus create')
            <a class="btn btn-sm btn-primary" data-ajax-popup="true" data-size="md" data-title="{{ __('Create Tracking Status') }}"
                data-url="{{ route('mobileservice.tracking-status.create') }}" data-toggle="tooltip" title="{{ __('Create') }}">
                <i class="ti ti-plus"></i>
            </a>
        @endpermission
    </div>
@endsection

@section('content')
    <div class="row">
        @include('mobile-service-management::service-setup.setup')

        <div class="col-sm-9">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('Tracking Status') }}</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0" id="assets" data-repeater-list="stages">
                            <thead>
                                <th><i class="fas fa-crosshairs"></i></th>
                                <th>{{ __('Icon') }}</th>
                                <th>{{ __('Tracking Status') }}</th>
                                @if (Laratrust::hasPermission('mobileservice_trackingstatus edit') || Laratrust::hasPermission('mobileservice_trackingstatus delete'))
                                    <th width="10%">{{ __('Action') }}</th>
                                @endif
                            </thead>
                            <tbody class="tracking-status">
                                @forelse($trackingStatusData as $trackingStatus)
                                    <tr data-id="{{ $trackingStatus->id }}"
                                        class="{{ $trackingStatus->status_name == 'Received' ? 'non-sortable' : '' }}">
                                        <td><i class="fas fa-crosshairs sort-handler"></i></td>
                                        <td>
                                            <span class='btn btn-sm' style="background-color: #{{ $trackingStatus->status_color }} !important;">
                                                <i class="text-white {{ $trackingStatus->icon_name }}"></i>
                                            </span>
                                        </td>
                                        <td class="sort-handler">
                                            {{ !empty($trackingStatus->status_name) ? $trackingStatus->status_name : '' }}
                                        </td>
                                        @if (Laratrust::hasPermission('mobileservice_trackingstatus edit') || Laratrust::hasPermission('mobileservice_trackingstatus delete'))
                                            <td width="10%">
                                                @if ($trackingStatus->status_name !== 'Received' && $trackingStatus->status_name !== 'Completed')
                                                    @permission('mobileservice_trackingstatus edit')
                                                        <div class="action-btn me-2">
                                                            <a class="bg-info btn btn-sm"
                                                                data-url="{{ route('mobileservice.tracking-status.edit', ['trackingStatusId' => $trackingStatus->id]) }}"
                                                                data-ajax-popup="true" data-size="md"
                                                                data-title="{{ __('Edit Tracking Status') }}"
                                                                data-toggle="tooltip" title="{{ __('Edit') }}">
                                                                <i class="ti ti-pencil text-white"></i>
                                                            </a>
                                                        </div>
                                                    @endpermission
                                                    @permission('mobileservice_trackingstatus delete')
                                                        <div class="action-btn">
                                                            <form method="POST"
                                                                action="{{ route('mobileservice.tracking-status.delete', $trackingStatus->id) }}"
                                                                id="delete-form-{{ $trackingStatus->id }}">
                                                                @csrf
                                                                @method('DELETE')
                                                                <a href="#" class="bg-danger btn btn-sm show_confirm"
                                                                    data-bs-toggle="tooltip" title="{{ __('Delete') }}"
                                                                    data-original-title="{{ __('Delete') }}"
                                                                    data-confirm="{{ __('Are You Sure?') }}"
                                                                    data-text="{{ __('This action can not be undone. Do you want to continue?') }}"
                                                                    data-confirm-yes="delete-form-{{ $trackingStatus->id }}">
                                                                    <i class="ti ti-trash text-white"></i>
                                                                </a>
                                                            </form>
                                                        </div>
                                                    @endpermission
                                                @endif
                                            </td>
                                        @endif
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            @if (\Auth::user()->type == 'company')
                <div class="alert alert-dark" role="alert">
                    {{ __('Note: You can easily change the order of job stages using drag & drop.') }}
                </div>
            @endif
        </div>
    </div>
@endsection

@push('scripts')
    <script src="{{ asset('assets/js/jscolor.js') }}"></script>
    <script src="{{ asset('js/jquery-ui.min.js') }}"></script>
    @if (\Auth::user()->type == 'company')
        <script>
            $(document).ready(function() {
                var $dragAndDrop = $("body .tracking-status tbody").sortable({
                    handle: '.sort-handler',
                    items: 'tr:not(.non-sortable)'
                });

                myFunction();
            });

            function myFunction() {
                $(".tracking-status").sortable({
                    handle: '.sort-handler',
                    items: 'tr:not(.non-sortable)',
                    stop: function() {
                        var order = [];
                        $(this).find('tr').each(function(index, data) {
                            order[index] = $(data).attr('data-id');
                        });
                        $.ajax({
                            url: "{{ route('mobileservice.tracking-status.order-update') }}",
                            data: {
                                order: order,
                                _token: $('meta[name="csrf-token"]').attr('content')
                            },
                            type: 'POST',
                            success: function(data) {
                                if (data.status == true) {
                                    toastrs('Success', data.message, 'success');
                                } else {
                                    toastrs('Error', 'Something Went Wrong !!', 'error');
                                }
                            },
                            error: function(data) {
                                data = data.responseJSON;
                            }
                        })
                    }
                });
            }
        </script>
    @endif
@endpush
