{{ Form::open(['route' => ['mobileservice.service-request.assign-technician.store', 'serviceId' => encrypt($serviceId)], 'method' => 'post', 'class' => 'needs-validation', 'novalidate']) }}
<div class="modal-body">
    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <label for="service_id" class="form-label">{{ __('Service ID') }}</label>
                <input type="text" name="service_id" value="{{ $serviceId }}" class="form-control" disabled>
            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                {{ Form::label('technician_id', __('Technician'), ['class' => 'form-label']) }} <x-required></x-required>
                {{ Form::select('technician_id', $technicians, '', ['class' => 'form-control']) }}
            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <label for="estimated_date" class="form-label">{{ __('Estimated Completion Date') }}</label> <x-required></x-required>
                <input type="date" name="estimated_date" id="estimated_date" class="form-control" required>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer">
    <button class="btn btn-light" type="button" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
    <button class="btn btn-primary" type="submit">{{ __('Assign') }}</button>
</div>
{{ Form::close() }}

<script>
    var today = new Date().toISOString().split('T')[0];
    document.getElementById('estimated_date').min = today;
</script>
