@extends('layouts.main')

@section('page-title')
    {{ __('Create Service Request') }}
@endsection

@section('page-breadcrumb')
    {{ __('Service Request') }}
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            {{ Form::open(['route' => ['mobileservice.service-request.store'], 'method' => 'post', 'enctype' => 'multipart/form-data', 'class' => 'needs-validation', 'novalidate']) }}
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('Customer Details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-4">
                            <label for="customer_name" class="form-label">{{ __('Name') }}</label> <x-required></x-required>
                            <input type="text" name="customer_name" id="customer_name" class="form-control" placeholder="{{ __('Enter name') }}" value="{{ old('customer_name') }}" required>
                            @error('customer_name')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-4">
                            <label for="email" class="form-label">{{ __('Email Address') }}</label> <x-required></x-required>
                            <input type="email" name="email" id="email" class="form-control" placeholder="{{ __('Enter email address') }}" value="{{ old('email') }}" required>
                            @error('email')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <x-mobile divClass="col-md-4" label="{{ __('Phone Number') }}" name="mobile_no"
                            placeholder="{{ __('Enter phone number') }}" class="form-control"
                            value="{{ old('mobile_no') }}" id="mobile_no" required></x-mobile>

                        <div class="form-group col-md-12">
                            <label for="address" class="form-label">{{ __('Address') }}</label>
                            <textarea name="address" id="address" class="form-control" rows="2" placeholder="{{ __('Enter address') }}">{{ old('address') }}</textarea>
                            @error('address')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('Service & Device Details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-6">
                            <label for="mobile_service_id" class="form-label">{{ __('Service') }}</label>
                            <x-required></x-required>
                            <select name="mobile_service_id" id="mobile_service_id" class="form-control" required>
                                <option value="">{{ __('Select a service') }}</option>
                                @foreach ($allServices as $service)
                                    <option value="{{ $service->id }}">{{ $service->name }}</option>
                                @endforeach
                                <option value="0">{{ __('Other service') }}</option>
                            </select>
                            @error('mobile_service_id')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-6">
                            <label for="priority" class="form-label">{{ __('Priority') }}</label> <x-required></x-required>
                            <select class="form-control" name="priority" id="priority" required>
                                <option value="">{{ __('Select priority') }}</option>
                                <option value="standard">{{ __('Standard') }}</option>
                                <option value="priority">{{ __('Priority') }}</option>
                                <option value="emergency">{{ __('Emergency') }}</option>
                            </select>
                            @error('priority')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-6">
                            <label for="device_brand" class="form-label">{{ __('Device Brand') }}</label>
                            <x-required></x-required>
                            <select name="device_brand" id="device_brand" class="form-control" required>
                                <option value="">{{ __('Select brand') }}</option>
                                @foreach ($brands as $brand)
                                    <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                                @endforeach
                            </select>
                            @error('device_brand')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-6">
                            <label for="mobile_model" class="form-label">{{ __('Device Model') }}</label> <x-required></x-required>
                            <input type="text" name="mobile_model" id="mobile_model" class="form-control" placeholder="{{ __('Enter device model') }}" value="{{ old('mobile_model') }}" required>
                            @error('mobile_model')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-12">
                            <label for="description" class="form-label">{{ __('Describe the issue') }}</label> <x-required></x-required>
                            <textarea name="description" id="description" class="form-control" rows="4" placeholder="{{ __('Enter issue') }}" required>{{ old('description') }}</textarea>
                            @error('description')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('More Details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-12">
                            <label for="special_requests" class="form-label">{{ __('Special Requests') }}</label>
                            <textarea name="special_requests" id="special_requests" class="form-control" rows="3" placeholder="{{ __('Enter special requests') }}">{{ old('special_requests') }}</textarea>
                            @error('special_requests')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="form-group col-md-12">
                            <label for="attachments" class="form-label">{{ __('Attachments') }}</label>
                            <input type="file" class="form-control" name="attachments[]" id="attachments" multiple>
                            <small class="text-muted">{{ __('You can upload multiple files') }}</small>
                            @error('attachments')
                                <p class="text-danger mb-3">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>

            <div class="float-end">
                <button type="button" class="btn btn-secondary me-2" onclick="window.location.href='{{ route('mobileservice.service-request.index') }}'">{{ __('Cancel') }}</button>
                <button type="submit" id="submit" class="btn  btn-primary">{{ __('Create') }}</button>
            </div>
            {{ Form::close() }}
        </div>
    </div>
@endsection
