@extends('layouts.main')

@section('page-title')
    {{ __('Pending Request Details') }}
@endsection

@section('page-breadcrumb')
    {{ __('Pending Request') }},
    {{ __($serviceReqData->service_id) }}
@endsection

@section('page-action')
     @if(is_null($serviceReqData->is_approve))
        @permission('mobileservice_pendingrequest approve-reject')
            <div>
                <div class="action-btn me-2">
                    <a href="{{ route('mobileservice.pending-request.accept', ['serviceId' => $serviceReqData->service_id]) }}"
                        data-toggle="tooltip" title="{{ __('Accept') }}" class="bg-success btn btn-sm">
                        <i class="ti ti-check text-white"></i>
                    </a>
                </div>
                <div class="action-btn">
                    <a href="{{ route('mobileservice.pending-request.reject', ['serviceId' => $serviceReqData->service_id]) }}"
                        data-toggle="tooltip" title="{{ __('Reject') }}" class="bg-warning btn btn-sm">
                        <i class="ti ti-x text-white"></i>
                    </a>
                </div>
            </div>
        @endpermission
    @endif
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-6 mb-4">
            <div class="card h-100">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('Customer Information') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="text-muted small">{{ __('Name') }}</label>
                            <p class="fw-bold">{{ $serviceReqData->customer_name }}</p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">{{ __('Mobile Number') }}</label>
                            <p class="fw-bold">{{ $serviceReqData->mobile_no }}</p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">{{ __('Email Address') }}</label>
                            <p class="fw-bold">{{ $serviceReqData->email }}</p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">{{ __('Created By') }}</label>
                            <p class="fw-bold">{{ $serviceReqData->getServiceCreatedName->name }}</p>
                        </div>
                        @if(!empty($serviceReqData->address))
                            <div class="col-12">
                                <label class="text-muted small">{{ __('Address') }}</label>
                                <div class="bg-light p-3 rounded">
                                    {{ $serviceReqData->address }}
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="card h-100">
                <div class="card-header">
                    <h5 class="mb-0">{{ __('Service & Device Details') }}</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="text-muted small">{{ __('Service Type') }}</label>
                            <p class="fw-bold">{{ $serviceReqData->service ? $serviceReqData->service->name : __('Other service') }}</p>
                        </div>
                        <div class="col-6">
                            <label class="text-muted small">{{ __('Priority') }}</label>
                            @php
                                if ($serviceReqData->priority == 'priority') {
                                    $priorityClass = "bg-warning";
                                } elseif ($serviceReqData->priority == 'emergency') {
                                    $priorityClass = "bg-danger";
                                } else {
                                    $priorityClass = "bg-secondary";
                                }
                            @endphp
                            <div>
                                <span class="badge {{ $priorityClass }} px-3 py-2">{{ __(ucfirst($serviceReqData->priority)) }}</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">{{ __('Device Brand') }}</label>
                            <p class="fw-bold">{{ $serviceReqData->deviceBrand ? $serviceReqData->deviceBrand->name : '-' }}</p>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small">{{ __('Device Model') }}</label>
                            <p class="fw-bold">{{ $serviceReqData->mobile_model }}</p>
                        </div>
                        <div class="col-12">
                            <label class="text-muted small">{{ __('Issue Description') }}</label>
                            <div class="bg-light p-3 rounded">
                                {{ $serviceReqData->description }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @php
        $attachments = explode(',', $serviceReqData->attachment);
        $hasAttachments = array_filter($attachments, function($file) {
            return !empty($file) && check_file($file);
        });
        $index = 0;
    @endphp
    @if(!empty($serviceReqData->special_requests) || !empty($hasAttachments))
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ __('More Details') }}</h5>
            </div>
            <div class="card-body">
                @if(!empty($serviceReqData->special_requests))
                    <div class="mb-4">
                        <h6 class="text-muted mb-2">{{ __('Special Requests') }}</h6>
                        <div class="bg-light p-3 rounded">
                            {{ $serviceReqData->special_requests }}
                        </div>
                    </div>
                @endif

                @if(!empty($hasAttachments))
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 class="text-muted mb-0">{{ __('Attachments') }}</h6>
                        <span class="badge bg-primary px-3 py-2 file_count">{{ count($hasAttachments) }} {{ __('Files') }}</span>
                    </div>
                    <div class="row g-3" id="attachment">
                        @foreach($hasAttachments as $attachment)
                            @php
                                $index = ++$index;
                                $fileExtension = pathinfo($attachment, PATHINFO_EXTENSION);
                                $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
                                $isImage = in_array(strtolower($fileExtension), $imageExtensions);
                            @endphp

                            <div class="col-md-6 col-lg-3 attachment-card">
                                <div class="border rounded p-3 bg-light position-relative d-flex flex-column" style="min-height: 200px;">
                                    <div class="dropdown position-absolute" style="top: 8px; right: 8px;">
                                        <button class="btn btn-sm btn-light border-0" type="button" data-bs-toggle="dropdown">
                                            <i class="ti ti-dots-vertical"></i>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <li><a class="dropdown-item" href="{{ get_file($attachment) }}" target="_blank"><i class="ti ti-eye me-2"></i>{{ __('View') }}</a></li>
                                            <li><a class="dropdown-item" href="{{ get_file($attachment) }}" download><i class="ti ti-download me-2"></i>{{ __('Download') }}</a></li>
                                            <li><hr class="dropdown-divider"></li>
                                            <li><a class="dropdown-item text-danger" href="#attachment" onclick="deleteAttachment('{{ $serviceReqData->service_id }}', '{{ $attachment }}', this)"><i class="ti ti-trash me-2"></i>{{ __('Delete') }}</a></li>
                                        </ul>
                                    </div>
                                    <div class="text-center mb-3 flex-grow-1 d-flex align-items-center justify-content-center">
                                        @if ($isImage)
                                            <img src="{{ get_file($attachment) }}" alt="Attachment {{ $index }}" class="img-fluid rounded" style="max-height: 120px;">
                                        @else
                                            <div class="bg-secondary text-white rounded d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                                                <i class="fas fa-file fa-lg"></i>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center mt-auto">
                                        <small class="text-muted">{{ $isImage ? __('Image') : __('File') }} #{{ $index }}</small>
                                        <span class="badge bg-success">{{ strtoupper($fileExtension) }}</span>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>
    @endif
@endsection

@push('scripts')
    <script>
        function deleteAttachment(serviceId, filePath, btn) {
            $.ajax({
                url: "{{ route('mobileservice.service-request.attachment-destroy', ['serviceId' => '__id__']) }}".replace('__id__', serviceId),
                type: "POST",
                data: {
                    _method: 'DELETE',
                    _token: "{{ csrf_token() }}",
                    file: filePath
                },
                success: function (response) {
                    $(btn).closest('.attachment-card').fadeOut(300, function() {
                        $(this).remove();
                        var remainingCards = $('.attachment-card').length;
                        $('.file_count').text(remainingCards + ' {{ __('Files') }}');
                    });
                    toastrs('Success', '{{ __('Attachment deleted successfully') }}', 'success');
                },
                error: function () {
                    toastrs('Error', '{{ __('Failed to delete attachment') }}', 'error');
                }
            });
        }
    </script>
@endpush
